# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/accessapproval/v1/accessapproval_pb"
require "google/cloud/access_approval/v1/access_approval/rest/service_stub"

module Google
  module Cloud
    module AccessApproval
      module V1
        module AccessApproval
          module Rest
            ##
            # REST client for the AccessApproval service.
            #
            # This API allows a customer to manage accesses to cloud resources by
            # Google personnel. It defines the following resource model:
            #
            # - The API has a collection of
            #   {::Google::Cloud::AccessApproval::V1::ApprovalRequest ApprovalRequest}
            #   resources, named `approvalRequests/{approval_request}`
            # - The API has top-level settings per Project/Folder/Organization, named
            #   `accessApprovalSettings`
            #
            # The service also periodically emails a list of recipients, defined at the
            # Project/Folder/Organization level in the accessApprovalSettings, when there
            # is a pending ApprovalRequest for them to act on. The ApprovalRequests can
            # also optionally be published to a Pub/Sub topic owned by the customer
            # (contact support if you would like to enable Pub/Sub notifications).
            #
            # ApprovalRequests can be approved or dismissed. Google personnel can only
            # access the indicated resource or resources if the request is approved
            # (subject to some exclusions:
            # https://cloud.google.com/access-approval/docs/overview#exclusions).
            #
            # Note: Using Access Approval functionality will mean that Google may not be
            # able to meet the SLAs for your chosen products, as any support response times
            # may be dramatically increased. As such the SLAs do not apply to any service
            # disruption to the extent impacted by Customer's use of Access Approval. Do
            # not enable Access Approval for projects where you may require high service
            # availability and rapid response by Google Cloud Support.
            #
            # After a request is approved or dismissed, no further action may be taken on
            # it. Requests with the requested_expiration in the past or with no activity
            # for 14 days are considered dismissed. When an approval expires, the request
            # is considered dismissed.
            #
            # If a request is not approved or dismissed, we call it pending.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "accessapproval.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :access_approval_stub

              ##
              # Configure the AccessApproval Client class.
              #
              # See {::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AccessApproval clients
              #   ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AccessApproval", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_approval_requests.timeout = 600.0
                  default_config.rpcs.list_approval_requests.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_approval_request.timeout = 600.0
                  default_config.rpcs.get_approval_request.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.approve_approval_request.timeout = 600.0

                  default_config.rpcs.dismiss_approval_request.timeout = 600.0

                  default_config.rpcs.invalidate_approval_request.timeout = 600.0

                  default_config.rpcs.get_access_approval_settings.timeout = 600.0
                  default_config.rpcs.get_access_approval_settings.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_access_approval_settings.timeout = 600.0

                  default_config.rpcs.delete_access_approval_settings.timeout = 600.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AccessApproval Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @access_approval_stub.universe_domain
              end

              ##
              # Create a new AccessApproval REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AccessApproval client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @access_approval_stub = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @access_approval_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @access_approval_stub.logger
              end

              # Service calls

              ##
              # Lists approval requests associated with a project, folder, or organization.
              # Approval requests can be filtered by state (pending, active, dismissed).
              # The order is reverse chronological.
              #
              # @overload list_approval_requests(request, options = nil)
              #   Pass arguments to `list_approval_requests` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::ListApprovalRequestsMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::ListApprovalRequestsMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_approval_requests(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_approval_requests` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     The parent resource. This may be "projects/\\{project}",
              #     "folders/\\{folder}", or "organizations/\\{organization}".
              #   @param filter [::String]
              #     A filter on the type of approval requests to retrieve. Must be one of the
              #     following values:
              #
              #       * [not set]: Requests that are pending or have active approvals.
              #       * ALL: All requests.
              #       * PENDING: Only pending requests.
              #       * ACTIVE: Only active (i.e. currently approved) requests.
              #       * DISMISSED: Only requests that have been dismissed, or requests that
              #         are not approved and past expiration.
              #       * EXPIRED: Only requests that have been approved, and the approval has
              #         expired.
              #       * HISTORY: Active, dismissed and expired requests.
              #   @param page_size [::Integer]
              #     Requested page size.
              #   @param page_token [::String]
              #     A token identifying the page of results to return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AccessApproval::V1::ApprovalRequest>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AccessApproval::V1::ApprovalRequest>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::ListApprovalRequestsMessage.new
              #
              #   # Call the list_approval_requests method.
              #   result = client.list_approval_requests request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AccessApproval::V1::ApprovalRequest.
              #     p item
              #   end
              #
              def list_approval_requests request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::ListApprovalRequestsMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_approval_requests.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_approval_requests.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_approval_requests.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.list_approval_requests request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @access_approval_stub, :list_approval_requests, "approval_requests", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an approval request. Returns NOT_FOUND if the request does not exist.
              #
              # @overload get_approval_request(request, options = nil)
              #   Pass arguments to `get_approval_request` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::GetApprovalRequestMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::GetApprovalRequestMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_approval_request(name: nil)
              #   Pass arguments to `get_approval_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the approval request to retrieve.
              #     Format:
              #     "\\{projects|folders|organizations}/\\{id}/approvalRequests/\\{approval_request}"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AccessApproval::V1::ApprovalRequest]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AccessApproval::V1::ApprovalRequest]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::GetApprovalRequestMessage.new
              #
              #   # Call the get_approval_request method.
              #   result = client.get_approval_request request
              #
              #   # The returned object is of type Google::Cloud::AccessApproval::V1::ApprovalRequest.
              #   p result
              #
              def get_approval_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::GetApprovalRequestMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_approval_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_approval_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_approval_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.get_approval_request request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Approves a request and returns the updated ApprovalRequest.
              #
              # Returns NOT_FOUND if the request does not exist. Returns
              # FAILED_PRECONDITION if the request exists but is not in a pending state.
              #
              # @overload approve_approval_request(request, options = nil)
              #   Pass arguments to `approve_approval_request` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::ApproveApprovalRequestMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::ApproveApprovalRequestMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload approve_approval_request(name: nil, expire_time: nil)
              #   Pass arguments to `approve_approval_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the approval request to approve.
              #   @param expire_time [::Google::Protobuf::Timestamp, ::Hash]
              #     The expiration time of this approval.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AccessApproval::V1::ApprovalRequest]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AccessApproval::V1::ApprovalRequest]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::ApproveApprovalRequestMessage.new
              #
              #   # Call the approve_approval_request method.
              #   result = client.approve_approval_request request
              #
              #   # The returned object is of type Google::Cloud::AccessApproval::V1::ApprovalRequest.
              #   p result
              #
              def approve_approval_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::ApproveApprovalRequestMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.approve_approval_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.approve_approval_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.approve_approval_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.approve_approval_request request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Dismisses a request. Returns the updated ApprovalRequest.
              #
              # NOTE: This does not deny access to the resource if another request has been
              # made and approved. It is equivalent in effect to ignoring the request
              # altogether.
              #
              # Returns NOT_FOUND if the request does not exist.
              #
              # Returns FAILED_PRECONDITION if the request exists but is not in a pending
              # state.
              #
              # @overload dismiss_approval_request(request, options = nil)
              #   Pass arguments to `dismiss_approval_request` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::DismissApprovalRequestMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::DismissApprovalRequestMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload dismiss_approval_request(name: nil)
              #   Pass arguments to `dismiss_approval_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the ApprovalRequest to dismiss.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AccessApproval::V1::ApprovalRequest]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AccessApproval::V1::ApprovalRequest]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::DismissApprovalRequestMessage.new
              #
              #   # Call the dismiss_approval_request method.
              #   result = client.dismiss_approval_request request
              #
              #   # The returned object is of type Google::Cloud::AccessApproval::V1::ApprovalRequest.
              #   p result
              #
              def dismiss_approval_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::DismissApprovalRequestMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.dismiss_approval_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.dismiss_approval_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.dismiss_approval_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.dismiss_approval_request request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Invalidates an existing ApprovalRequest. Returns the updated
              # ApprovalRequest.
              #
              # NOTE: This does not deny access to the resource if another request has been
              # made and approved. It only invalidates a single approval.
              #
              # Returns FAILED_PRECONDITION if the request exists but is not in an approved
              # state.
              #
              # @overload invalidate_approval_request(request, options = nil)
              #   Pass arguments to `invalidate_approval_request` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::InvalidateApprovalRequestMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::InvalidateApprovalRequestMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload invalidate_approval_request(name: nil)
              #   Pass arguments to `invalidate_approval_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the ApprovalRequest to invalidate.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AccessApproval::V1::ApprovalRequest]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AccessApproval::V1::ApprovalRequest]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::InvalidateApprovalRequestMessage.new
              #
              #   # Call the invalidate_approval_request method.
              #   result = client.invalidate_approval_request request
              #
              #   # The returned object is of type Google::Cloud::AccessApproval::V1::ApprovalRequest.
              #   p result
              #
              def invalidate_approval_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::InvalidateApprovalRequestMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.invalidate_approval_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.invalidate_approval_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.invalidate_approval_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.invalidate_approval_request request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the settings associated with a project, folder, or organization.
              #
              # @overload get_access_approval_settings(request, options = nil)
              #   Pass arguments to `get_access_approval_settings` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::GetAccessApprovalSettingsMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::GetAccessApprovalSettingsMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_access_approval_settings(name: nil)
              #   Pass arguments to `get_access_approval_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the AccessApprovalSettings to retrieve.
              #     Format: "\\{projects|folders|organizations}/\\{id}/accessApprovalSettings"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AccessApproval::V1::AccessApprovalSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AccessApproval::V1::AccessApprovalSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::GetAccessApprovalSettingsMessage.new
              #
              #   # Call the get_access_approval_settings method.
              #   result = client.get_access_approval_settings request
              #
              #   # The returned object is of type Google::Cloud::AccessApproval::V1::AccessApprovalSettings.
              #   p result
              #
              def get_access_approval_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::GetAccessApprovalSettingsMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_access_approval_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_access_approval_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_access_approval_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.get_access_approval_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the settings associated with a project, folder, or organization.
              # Settings to update are determined by the value of field_mask.
              #
              # @overload update_access_approval_settings(request, options = nil)
              #   Pass arguments to `update_access_approval_settings` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::UpdateAccessApprovalSettingsMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::UpdateAccessApprovalSettingsMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_access_approval_settings(settings: nil, update_mask: nil)
              #   Pass arguments to `update_access_approval_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param settings [::Google::Cloud::AccessApproval::V1::AccessApprovalSettings, ::Hash]
              #     The new AccessApprovalSettings.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The update mask applies to the settings. Only the top level fields of
              #     AccessApprovalSettings (notification_emails & enrolled_services) are
              #     supported. For each field, if it is included, the currently stored value
              #     will be entirely overwritten with the value of the field passed in this
              #     request.
              #
              #     For the `FieldMask` definition, see
              #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
              #     If this field is left unset, only the notification_emails field will be
              #     updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AccessApproval::V1::AccessApprovalSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AccessApproval::V1::AccessApprovalSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::UpdateAccessApprovalSettingsMessage.new
              #
              #   # Call the update_access_approval_settings method.
              #   result = client.update_access_approval_settings request
              #
              #   # The returned object is of type Google::Cloud::AccessApproval::V1::AccessApprovalSettings.
              #   p result
              #
              def update_access_approval_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::UpdateAccessApprovalSettingsMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_access_approval_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_access_approval_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_access_approval_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.update_access_approval_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the settings associated with a project, folder, or organization.
              # This will have the effect of disabling Access Approval for the project,
              # folder, or organization, but only if all ancestors also have Access
              # Approval disabled. If Access Approval is enabled at a higher level of the
              # hierarchy, then Access Approval will still be enabled at this level as
              # the settings are inherited.
              #
              # @overload delete_access_approval_settings(request, options = nil)
              #   Pass arguments to `delete_access_approval_settings` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::DeleteAccessApprovalSettingsMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::DeleteAccessApprovalSettingsMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_access_approval_settings(name: nil)
              #   Pass arguments to `delete_access_approval_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the AccessApprovalSettings to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::DeleteAccessApprovalSettingsMessage.new
              #
              #   # Call the delete_access_approval_settings method.
              #   result = client.delete_access_approval_settings request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_access_approval_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::DeleteAccessApprovalSettingsMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_access_approval_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_access_approval_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_access_approval_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.delete_access_approval_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the service account that is used by Access Approval to access KMS
              # keys for signing approved approval requests.
              #
              # @overload get_access_approval_service_account(request, options = nil)
              #   Pass arguments to `get_access_approval_service_account` via a request object, either of type
              #   {::Google::Cloud::AccessApproval::V1::GetAccessApprovalServiceAccountMessage} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AccessApproval::V1::GetAccessApprovalServiceAccountMessage, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_access_approval_service_account(name: nil)
              #   Pass arguments to `get_access_approval_service_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the AccessApprovalServiceAccount to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AccessApproval::V1::AccessApprovalServiceAccount]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AccessApproval::V1::AccessApprovalServiceAccount]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/access_approval/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AccessApproval::V1::GetAccessApprovalServiceAccountMessage.new
              #
              #   # Call the get_access_approval_service_account method.
              #   result = client.get_access_approval_service_account request
              #
              #   # The returned object is of type Google::Cloud::AccessApproval::V1::AccessApprovalServiceAccount.
              #   p result
              #
              def get_access_approval_service_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AccessApproval::V1::GetAccessApprovalServiceAccountMessage

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_access_approval_service_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AccessApproval::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_access_approval_service_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_access_approval_service_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_approval_stub.get_access_approval_service_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AccessApproval REST API.
              #
              # This class represents the configuration for AccessApproval REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_approval_requests to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_approval_requests.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_approval_requests.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "accessapproval.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the AccessApproval API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_approval_requests`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_approval_requests
                  ##
                  # RPC-specific configuration for `get_approval_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_approval_request
                  ##
                  # RPC-specific configuration for `approve_approval_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :approve_approval_request
                  ##
                  # RPC-specific configuration for `dismiss_approval_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :dismiss_approval_request
                  ##
                  # RPC-specific configuration for `invalidate_approval_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :invalidate_approval_request
                  ##
                  # RPC-specific configuration for `get_access_approval_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_access_approval_settings
                  ##
                  # RPC-specific configuration for `update_access_approval_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_access_approval_settings
                  ##
                  # RPC-specific configuration for `delete_access_approval_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_access_approval_settings
                  ##
                  # RPC-specific configuration for `get_access_approval_service_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_access_approval_service_account

                  # @private
                  def initialize parent_rpcs = nil
                    list_approval_requests_config = parent_rpcs.list_approval_requests if parent_rpcs.respond_to? :list_approval_requests
                    @list_approval_requests = ::Gapic::Config::Method.new list_approval_requests_config
                    get_approval_request_config = parent_rpcs.get_approval_request if parent_rpcs.respond_to? :get_approval_request
                    @get_approval_request = ::Gapic::Config::Method.new get_approval_request_config
                    approve_approval_request_config = parent_rpcs.approve_approval_request if parent_rpcs.respond_to? :approve_approval_request
                    @approve_approval_request = ::Gapic::Config::Method.new approve_approval_request_config
                    dismiss_approval_request_config = parent_rpcs.dismiss_approval_request if parent_rpcs.respond_to? :dismiss_approval_request
                    @dismiss_approval_request = ::Gapic::Config::Method.new dismiss_approval_request_config
                    invalidate_approval_request_config = parent_rpcs.invalidate_approval_request if parent_rpcs.respond_to? :invalidate_approval_request
                    @invalidate_approval_request = ::Gapic::Config::Method.new invalidate_approval_request_config
                    get_access_approval_settings_config = parent_rpcs.get_access_approval_settings if parent_rpcs.respond_to? :get_access_approval_settings
                    @get_access_approval_settings = ::Gapic::Config::Method.new get_access_approval_settings_config
                    update_access_approval_settings_config = parent_rpcs.update_access_approval_settings if parent_rpcs.respond_to? :update_access_approval_settings
                    @update_access_approval_settings = ::Gapic::Config::Method.new update_access_approval_settings_config
                    delete_access_approval_settings_config = parent_rpcs.delete_access_approval_settings if parent_rpcs.respond_to? :delete_access_approval_settings
                    @delete_access_approval_settings = ::Gapic::Config::Method.new delete_access_approval_settings_config
                    get_access_approval_service_account_config = parent_rpcs.get_access_approval_service_account if parent_rpcs.respond_to? :get_access_approval_service_account
                    @get_access_approval_service_account = ::Gapic::Config::Method.new get_access_approval_service_account_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
