# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/area120/tables/v1alpha1/version"

require "google/area120/tables/v1alpha1/tables_service/credentials"
require "google/area120/tables/v1alpha1/tables_service/paths"
require "google/area120/tables/v1alpha1/tables_service/rest/client"

module Google
  module Area120
    module Tables
      module V1alpha1
        ##
        # The Tables Service provides an API for reading and updating tables.
        # It defines the following resource model:
        #
        # - The API has a collection of {::Google::Area120::Tables::V1alpha1::Table Table}
        #   resources, named `tables/*`
        #
        # - Each Table has a collection of {::Google::Area120::Tables::V1alpha1::Row Row}
        #   resources, named `tables/*/rows/*`
        #
        # - The API has a collection of
        #   {::Google::Area120::Tables::V1alpha1::Workspace Workspace}
        #   resources, named `workspaces/*`.
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/area120/tables/v1alpha1/tables_service/rest"
        #     client = ::Google::Area120::Tables::V1alpha1::TablesService::Rest::Client.new
        #
        module TablesService
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/area120/tables/v1alpha1/tables_service/rest/helpers" if ::File.file? helper_path
