# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Area120
    module Tables
      module V1alpha1
        module TablesService
          # Path helper methods for the TablesService API.
          module Paths
            ##
            # Create a fully-qualified Row resource string.
            #
            # The resource will be in the following format:
            #
            # `tables/{table}/rows/{row}`
            #
            # @param table [String]
            # @param row [String]
            #
            # @return [::String]
            def row_path table:, row:
              raise ::ArgumentError, "table cannot contain /" if table.to_s.include? "/"

              "tables/#{table}/rows/#{row}"
            end

            ##
            # Create a fully-qualified Table resource string.
            #
            # The resource will be in the following format:
            #
            # `tables/{table}`
            #
            # @param table [String]
            #
            # @return [::String]
            def table_path table:
              "tables/#{table}"
            end

            ##
            # Create a fully-qualified Workspace resource string.
            #
            # The resource will be in the following format:
            #
            # `workspaces/{workspace}`
            #
            # @param workspace [String]
            #
            # @return [::String]
            def workspace_path workspace:
              "workspaces/#{workspace}"
            end

            extend self
          end
        end
      end
    end
  end
end
