# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/area120/tables/v1alpha1/tables_pb"

module Google
  module Area120
    module Tables
      module V1alpha1
        module TablesService
          ##
          # Client for the TablesService service.
          #
          # The Tables Service provides an API for reading and updating tables.
          # It defines the following resource model:
          #
          # - The API has a collection of {::Google::Area120::Tables::V1alpha1::Table Table}
          #   resources, named `tables/*`
          #
          # - Each Table has a collection of {::Google::Area120::Tables::V1alpha1::Row Row}
          #   resources, named `tables/*/rows/*`
          #
          # - The API has a collection of
          #   {::Google::Area120::Tables::V1alpha1::Workspace Workspace}
          #   resources, named `workspaces/*`.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "area120tables.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :tables_service_stub

            ##
            # Configure the TablesService Client class.
            #
            # See {::Google::Area120::Tables::V1alpha1::TablesService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all TablesService clients
            #   ::Google::Area120::Tables::V1alpha1::TablesService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Area120", "Tables", "V1alpha1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_table.timeout = 60.0

                default_config.rpcs.list_tables.timeout = 60.0

                default_config.rpcs.get_workspace.timeout = 60.0

                default_config.rpcs.list_workspaces.timeout = 60.0

                default_config.rpcs.get_row.timeout = 60.0

                default_config.rpcs.list_rows.timeout = 60.0

                default_config.rpcs.create_row.timeout = 60.0

                default_config.rpcs.batch_create_rows.timeout = 60.0

                default_config.rpcs.update_row.timeout = 60.0

                default_config.rpcs.batch_update_rows.timeout = 60.0

                default_config.rpcs.delete_row.timeout = 60.0

                default_config.rpcs.batch_delete_rows.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the TablesService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Area120::Tables::V1alpha1::TablesService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @tables_service_stub.universe_domain
            end

            ##
            # Create a new TablesService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Area120::Tables::V1alpha1::TablesService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the TablesService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/area120/tables/v1alpha1/tables_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @tables_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Area120::Tables::V1alpha1::TablesService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @tables_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @tables_service_stub.logger
            end

            # Service calls

            ##
            # Gets a table. Returns NOT_FOUND if the table does not exist.
            #
            # @overload get_table(request, options = nil)
            #   Pass arguments to `get_table` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::GetTableRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::GetTableRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_table(name: nil)
            #   Pass arguments to `get_table` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the table to retrieve.
            #     Format: tables/\\{table}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Area120::Tables::V1alpha1::Table]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Area120::Tables::V1alpha1::Table]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::GetTableRequest.new
            #
            #   # Call the get_table method.
            #   result = client.get_table request
            #
            #   # The returned object is of type Google::Area120::Tables::V1alpha1::Table.
            #   p result
            #
            def get_table request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::GetTableRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_table.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_table.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_table.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :get_table, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists tables for the user.
            #
            # @overload list_tables(request, options = nil)
            #   Pass arguments to `list_tables` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::ListTablesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::ListTablesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_tables(page_size: nil, page_token: nil)
            #   Pass arguments to `list_tables` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param page_size [::Integer]
            #     The maximum number of tables to return. The service may return fewer than
            #     this value.
            #
            #     If unspecified, at most 20 tables are returned. The maximum value is 100;
            #     values above 100 are coerced to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListTables` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListTables` must match
            #     the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Area120::Tables::V1alpha1::Table>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Area120::Tables::V1alpha1::Table>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::ListTablesRequest.new
            #
            #   # Call the list_tables method.
            #   result = client.list_tables request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Area120::Tables::V1alpha1::Table.
            #     p item
            #   end
            #
            def list_tables request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::ListTablesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_tables.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_tables.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_tables.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :list_tables, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @tables_service_stub, :list_tables, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a workspace. Returns NOT_FOUND if the workspace does not exist.
            #
            # @overload get_workspace(request, options = nil)
            #   Pass arguments to `get_workspace` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::GetWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::GetWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_workspace(name: nil)
            #   Pass arguments to `get_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the workspace to retrieve.
            #     Format: workspaces/\\{workspace}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Area120::Tables::V1alpha1::Workspace]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Area120::Tables::V1alpha1::Workspace]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::GetWorkspaceRequest.new
            #
            #   # Call the get_workspace method.
            #   result = client.get_workspace request
            #
            #   # The returned object is of type Google::Area120::Tables::V1alpha1::Workspace.
            #   p result
            #
            def get_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::GetWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :get_workspace, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists workspaces for the user.
            #
            # @overload list_workspaces(request, options = nil)
            #   Pass arguments to `list_workspaces` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::ListWorkspacesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::ListWorkspacesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_workspaces(page_size: nil, page_token: nil)
            #   Pass arguments to `list_workspaces` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param page_size [::Integer]
            #     The maximum number of workspaces to return. The service may return fewer
            #     than this value.
            #
            #     If unspecified, at most 10 workspaces are returned. The maximum value is
            #     25; values above 25 are coerced to 25.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListWorkspaces` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListWorkspaces` must
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Area120::Tables::V1alpha1::Workspace>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Area120::Tables::V1alpha1::Workspace>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::ListWorkspacesRequest.new
            #
            #   # Call the list_workspaces method.
            #   result = client.list_workspaces request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Area120::Tables::V1alpha1::Workspace.
            #     p item
            #   end
            #
            def list_workspaces request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::ListWorkspacesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_workspaces.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_workspaces.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_workspaces.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :list_workspaces, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @tables_service_stub, :list_workspaces, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a row. Returns NOT_FOUND if the row does not exist in the table.
            #
            # @overload get_row(request, options = nil)
            #   Pass arguments to `get_row` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::GetRowRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::GetRowRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_row(name: nil, view: nil)
            #   Pass arguments to `get_row` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the row to retrieve.
            #     Format: tables/\\{table}/rows/\\{row}
            #   @param view [::Google::Area120::Tables::V1alpha1::View]
            #     Optional. Column key to use for values in the row.
            #     Defaults to user entered name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Area120::Tables::V1alpha1::Row]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Area120::Tables::V1alpha1::Row]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::GetRowRequest.new
            #
            #   # Call the get_row method.
            #   result = client.get_row request
            #
            #   # The returned object is of type Google::Area120::Tables::V1alpha1::Row.
            #   p result
            #
            def get_row request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::GetRowRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_row.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_row.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_row.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :get_row, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists rows in a table. Returns NOT_FOUND if the table does not exist.
            #
            # @overload list_rows(request, options = nil)
            #   Pass arguments to `list_rows` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::ListRowsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::ListRowsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_rows(parent: nil, page_size: nil, page_token: nil, view: nil, filter: nil)
            #   Pass arguments to `list_rows` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent table.
            #     Format: tables/\\{table}
            #   @param page_size [::Integer]
            #     The maximum number of rows to return. The service may return fewer than
            #     this value.
            #
            #     If unspecified, at most 50 rows are returned. The maximum value is 1,000;
            #     values above 1,000 are coerced to 1,000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListRows` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListRows` must match
            #     the call that provided the page token.
            #   @param view [::Google::Area120::Tables::V1alpha1::View]
            #     Optional. Column key to use for values in the row.
            #     Defaults to user entered name.
            #   @param filter [::String]
            #     Optional. Raw text query to search for in rows of the table.
            #     Special characters must be escaped. Logical operators and field specific
            #     filtering not supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Area120::Tables::V1alpha1::Row>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Area120::Tables::V1alpha1::Row>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::ListRowsRequest.new
            #
            #   # Call the list_rows method.
            #   result = client.list_rows request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Area120::Tables::V1alpha1::Row.
            #     p item
            #   end
            #
            def list_rows request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::ListRowsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_rows.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_rows.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_rows.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :list_rows, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @tables_service_stub, :list_rows, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a row.
            #
            # @overload create_row(request, options = nil)
            #   Pass arguments to `create_row` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::CreateRowRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::CreateRowRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_row(parent: nil, row: nil, view: nil)
            #   Pass arguments to `create_row` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent table where this row will be created.
            #     Format: tables/\\{table}
            #   @param row [::Google::Area120::Tables::V1alpha1::Row, ::Hash]
            #     Required. The row to create.
            #   @param view [::Google::Area120::Tables::V1alpha1::View]
            #     Optional. Column key to use for values in the row.
            #     Defaults to user entered name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Area120::Tables::V1alpha1::Row]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Area120::Tables::V1alpha1::Row]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::CreateRowRequest.new
            #
            #   # Call the create_row method.
            #   result = client.create_row request
            #
            #   # The returned object is of type Google::Area120::Tables::V1alpha1::Row.
            #   p result
            #
            def create_row request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::CreateRowRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_row.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_row.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_row.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :create_row, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates multiple rows.
            #
            # @overload batch_create_rows(request, options = nil)
            #   Pass arguments to `batch_create_rows` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::BatchCreateRowsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::BatchCreateRowsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_rows(parent: nil, requests: nil)
            #   Pass arguments to `batch_create_rows` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent table where the rows will be created.
            #     Format: tables/\\{table}
            #   @param requests [::Array<::Google::Area120::Tables::V1alpha1::CreateRowRequest, ::Hash>]
            #     Required. The request message specifying the rows to create.
            #
            #     A maximum of 500 rows can be created in a single batch.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Area120::Tables::V1alpha1::BatchCreateRowsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Area120::Tables::V1alpha1::BatchCreateRowsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::BatchCreateRowsRequest.new
            #
            #   # Call the batch_create_rows method.
            #   result = client.batch_create_rows request
            #
            #   # The returned object is of type Google::Area120::Tables::V1alpha1::BatchCreateRowsResponse.
            #   p result
            #
            def batch_create_rows request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::BatchCreateRowsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_rows.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_rows.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_rows.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :batch_create_rows, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a row.
            #
            # @overload update_row(request, options = nil)
            #   Pass arguments to `update_row` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::UpdateRowRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::UpdateRowRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_row(row: nil, update_mask: nil, view: nil)
            #   Pass arguments to `update_row` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param row [::Google::Area120::Tables::V1alpha1::Row, ::Hash]
            #     Required. The row to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to update.
            #   @param view [::Google::Area120::Tables::V1alpha1::View]
            #     Optional. Column key to use for values in the row.
            #     Defaults to user entered name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Area120::Tables::V1alpha1::Row]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Area120::Tables::V1alpha1::Row]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::UpdateRowRequest.new
            #
            #   # Call the update_row method.
            #   result = client.update_row request
            #
            #   # The returned object is of type Google::Area120::Tables::V1alpha1::Row.
            #   p result
            #
            def update_row request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::UpdateRowRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_row.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.row&.name
                header_params["row.name"] = request.row.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_row.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_row.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :update_row, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates multiple rows.
            #
            # @overload batch_update_rows(request, options = nil)
            #   Pass arguments to `batch_update_rows` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::BatchUpdateRowsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::BatchUpdateRowsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_update_rows(parent: nil, requests: nil)
            #   Pass arguments to `batch_update_rows` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent table shared by all rows being updated.
            #     Format: tables/\\{table}
            #   @param requests [::Array<::Google::Area120::Tables::V1alpha1::UpdateRowRequest, ::Hash>]
            #     Required. The request messages specifying the rows to update.
            #
            #     A maximum of 500 rows can be modified in a single batch.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Area120::Tables::V1alpha1::BatchUpdateRowsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Area120::Tables::V1alpha1::BatchUpdateRowsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::BatchUpdateRowsRequest.new
            #
            #   # Call the batch_update_rows method.
            #   result = client.batch_update_rows request
            #
            #   # The returned object is of type Google::Area120::Tables::V1alpha1::BatchUpdateRowsResponse.
            #   p result
            #
            def batch_update_rows request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::BatchUpdateRowsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_update_rows.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_update_rows.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_update_rows.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :batch_update_rows, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a row.
            #
            # @overload delete_row(request, options = nil)
            #   Pass arguments to `delete_row` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::DeleteRowRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::DeleteRowRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_row(name: nil)
            #   Pass arguments to `delete_row` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the row to delete.
            #     Format: tables/\\{table}/rows/\\{row}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::DeleteRowRequest.new
            #
            #   # Call the delete_row method.
            #   result = client.delete_row request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_row request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::DeleteRowRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_row.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_row.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_row.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :delete_row, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes multiple rows.
            #
            # @overload batch_delete_rows(request, options = nil)
            #   Pass arguments to `batch_delete_rows` via a request object, either of type
            #   {::Google::Area120::Tables::V1alpha1::BatchDeleteRowsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Area120::Tables::V1alpha1::BatchDeleteRowsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_delete_rows(parent: nil, names: nil)
            #   Pass arguments to `batch_delete_rows` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent table shared by all rows being deleted.
            #     Format: tables/\\{table}
            #   @param names [::Array<::String>]
            #     Required. The names of the rows to delete. All rows must belong to the parent table
            #     or else the entire batch will fail. A maximum of 500 rows can be deleted
            #     in a batch.
            #     Format: tables/\\{table}/rows/\\{row}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/area120/tables/v1alpha1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Area120::Tables::V1alpha1::TablesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Area120::Tables::V1alpha1::BatchDeleteRowsRequest.new
            #
            #   # Call the batch_delete_rows method.
            #   result = client.batch_delete_rows request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def batch_delete_rows request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Area120::Tables::V1alpha1::BatchDeleteRowsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_delete_rows.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Area120::Tables::V1alpha1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_delete_rows.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_delete_rows.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @tables_service_stub.call_rpc :batch_delete_rows, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the TablesService API.
            #
            # This class represents the configuration for TablesService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Area120::Tables::V1alpha1::TablesService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_table to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Area120::Tables::V1alpha1::TablesService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_table.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Area120::Tables::V1alpha1::TablesService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_table.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Area120::Tables::V1alpha1::TablesService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "area120tables.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the TablesService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_table`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_table
                ##
                # RPC-specific configuration for `list_tables`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_tables
                ##
                # RPC-specific configuration for `get_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_workspace
                ##
                # RPC-specific configuration for `list_workspaces`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_workspaces
                ##
                # RPC-specific configuration for `get_row`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_row
                ##
                # RPC-specific configuration for `list_rows`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_rows
                ##
                # RPC-specific configuration for `create_row`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_row
                ##
                # RPC-specific configuration for `batch_create_rows`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_rows
                ##
                # RPC-specific configuration for `update_row`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_row
                ##
                # RPC-specific configuration for `batch_update_rows`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_update_rows
                ##
                # RPC-specific configuration for `delete_row`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_row
                ##
                # RPC-specific configuration for `batch_delete_rows`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_delete_rows

                # @private
                def initialize parent_rpcs = nil
                  get_table_config = parent_rpcs.get_table if parent_rpcs.respond_to? :get_table
                  @get_table = ::Gapic::Config::Method.new get_table_config
                  list_tables_config = parent_rpcs.list_tables if parent_rpcs.respond_to? :list_tables
                  @list_tables = ::Gapic::Config::Method.new list_tables_config
                  get_workspace_config = parent_rpcs.get_workspace if parent_rpcs.respond_to? :get_workspace
                  @get_workspace = ::Gapic::Config::Method.new get_workspace_config
                  list_workspaces_config = parent_rpcs.list_workspaces if parent_rpcs.respond_to? :list_workspaces
                  @list_workspaces = ::Gapic::Config::Method.new list_workspaces_config
                  get_row_config = parent_rpcs.get_row if parent_rpcs.respond_to? :get_row
                  @get_row = ::Gapic::Config::Method.new get_row_config
                  list_rows_config = parent_rpcs.list_rows if parent_rpcs.respond_to? :list_rows
                  @list_rows = ::Gapic::Config::Method.new list_rows_config
                  create_row_config = parent_rpcs.create_row if parent_rpcs.respond_to? :create_row
                  @create_row = ::Gapic::Config::Method.new create_row_config
                  batch_create_rows_config = parent_rpcs.batch_create_rows if parent_rpcs.respond_to? :batch_create_rows
                  @batch_create_rows = ::Gapic::Config::Method.new batch_create_rows_config
                  update_row_config = parent_rpcs.update_row if parent_rpcs.respond_to? :update_row
                  @update_row = ::Gapic::Config::Method.new update_row_config
                  batch_update_rows_config = parent_rpcs.batch_update_rows if parent_rpcs.respond_to? :batch_update_rows
                  @batch_update_rows = ::Gapic::Config::Method.new batch_update_rows_config
                  delete_row_config = parent_rpcs.delete_row if parent_rpcs.respond_to? :delete_row
                  @delete_row = ::Gapic::Config::Method.new delete_row_config
                  batch_delete_rows_config = parent_rpcs.batch_delete_rows if parent_rpcs.respond_to? :batch_delete_rows
                  @batch_delete_rows = ::Gapic::Config::Method.new batch_delete_rows_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
