# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/apps/meet/v2beta/service_pb"
require "google/apps/meet/v2beta/spaces_service"

class ::Google::Apps::Meet::V2beta::SpacesService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_space
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Meet::V2beta::Space.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    space = {}

    create_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_space, name
      assert_kind_of ::Google::Apps::Meet::V2beta::CreateSpaceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Meet::V2beta::Space), request["space"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_space_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_space({ space: space }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_space space: space do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_space ::Google::Apps::Meet::V2beta::CreateSpaceRequest.new(space: space) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_space({ space: space }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_space(::Google::Apps::Meet::V2beta::CreateSpaceRequest.new(space: space), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_space_client_stub.call_rpc_count
    end
  end

  def test_get_space
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Meet::V2beta::Space.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_space, name
      assert_kind_of ::Google::Apps::Meet::V2beta::GetSpaceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_space_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_space({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_space name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_space ::Google::Apps::Meet::V2beta::GetSpaceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_space({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_space(::Google::Apps::Meet::V2beta::GetSpaceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_space_client_stub.call_rpc_count
    end
  end

  def test_update_space
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Meet::V2beta::Space.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    space = {}
    update_mask = {}

    update_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_space, name
      assert_kind_of ::Google::Apps::Meet::V2beta::UpdateSpaceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Meet::V2beta::Space), request["space"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_space_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_space({ space: space, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_space space: space, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_space ::Google::Apps::Meet::V2beta::UpdateSpaceRequest.new(space: space, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_space({ space: space, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_space(::Google::Apps::Meet::V2beta::UpdateSpaceRequest.new(space: space, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_space_client_stub.call_rpc_count
    end
  end

  def test_connect_active_conference
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Meet::V2beta::ConnectActiveConferenceResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    offer = "hello world"

    connect_active_conference_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :connect_active_conference, name
      assert_kind_of ::Google::Apps::Meet::V2beta::ConnectActiveConferenceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["offer"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, connect_active_conference_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.connect_active_conference({ name: name, offer: offer }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.connect_active_conference name: name, offer: offer do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.connect_active_conference ::Google::Apps::Meet::V2beta::ConnectActiveConferenceRequest.new(name: name, offer: offer) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.connect_active_conference({ name: name, offer: offer }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.connect_active_conference(::Google::Apps::Meet::V2beta::ConnectActiveConferenceRequest.new(name: name, offer: offer), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, connect_active_conference_client_stub.call_rpc_count
    end
  end

  def test_end_active_conference
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    end_active_conference_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :end_active_conference, name
      assert_kind_of ::Google::Apps::Meet::V2beta::EndActiveConferenceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, end_active_conference_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.end_active_conference({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.end_active_conference name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.end_active_conference ::Google::Apps::Meet::V2beta::EndActiveConferenceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.end_active_conference({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.end_active_conference(::Google::Apps::Meet::V2beta::EndActiveConferenceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, end_active_conference_client_stub.call_rpc_count
    end
  end

  def test_create_member
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Meet::V2beta::Member.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    member = {}

    create_member_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_member, name
      assert_kind_of ::Google::Apps::Meet::V2beta::CreateMemberRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Meet::V2beta::Member), request["member"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_member_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_member({ parent: parent, member: member }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_member parent: parent, member: member do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_member ::Google::Apps::Meet::V2beta::CreateMemberRequest.new(parent: parent, member: member) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_member({ parent: parent, member: member }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_member(::Google::Apps::Meet::V2beta::CreateMemberRequest.new(parent: parent, member: member), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_member_client_stub.call_rpc_count
    end
  end

  def test_get_member
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Meet::V2beta::Member.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_member_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_member, name
      assert_kind_of ::Google::Apps::Meet::V2beta::GetMemberRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_member_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_member({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_member name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_member ::Google::Apps::Meet::V2beta::GetMemberRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_member({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_member(::Google::Apps::Meet::V2beta::GetMemberRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_member_client_stub.call_rpc_count
    end
  end

  def test_list_members
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Meet::V2beta::ListMembersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_members_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_members, name
      assert_kind_of ::Google::Apps::Meet::V2beta::ListMembersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_members_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_members({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_members parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_members ::Google::Apps::Meet::V2beta::ListMembersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_members({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_members(::Google::Apps::Meet::V2beta::ListMembersRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_members_client_stub.call_rpc_count
    end
  end

  def test_delete_member
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_member_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_member, name
      assert_kind_of ::Google::Apps::Meet::V2beta::DeleteMemberRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_member_client_stub do
      # Create client
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_member({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_member name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_member ::Google::Apps::Meet::V2beta::DeleteMemberRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_member({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_member(::Google::Apps::Meet::V2beta::DeleteMemberRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_member_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Apps::Meet::V2beta::SpacesService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Apps::Meet::V2beta::SpacesService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Apps::Meet::V2beta::SpacesService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
