# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/apps/meet/v2beta/conference_records_service"

class ::Google::Apps::Meet::V2beta::ConferenceRecordsService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_conference_record_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.conference_record_path conference_record: "value0"
      assert_equal "conferenceRecords/value0", path
    end
  end

  def test_participant_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.participant_path conference_record: "value0", participant: "value1"
      assert_equal "conferenceRecords/value0/participants/value1", path
    end
  end

  def test_participant_session_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.participant_session_path conference_record: "value0", participant: "value1", participant_session: "value2"
      assert_equal "conferenceRecords/value0/participants/value1/participantSessions/value2", path
    end
  end

  def test_recording_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.recording_path conference_record: "value0", recording: "value1"
      assert_equal "conferenceRecords/value0/recordings/value1", path
    end
  end

  def test_transcript_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.transcript_path conference_record: "value0", transcript: "value1"
      assert_equal "conferenceRecords/value0/transcripts/value1", path
    end
  end

  def test_transcript_entry_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.transcript_entry_path conference_record: "value0", transcript: "value1", entry: "value2"
      assert_equal "conferenceRecords/value0/transcripts/value1/entries/value2", path
    end
  end
end
