# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Meet
      module V2beta
        # Virtual place where conferences are held. Only one active conference can be
        # held in one space at any given time.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. Resource name of the space.
        #
        #     Format: `spaces/{space}`.
        #
        #     `{space}` is the resource identifier for the space. It's a unique,
        #     server-generated ID and is case sensitive. For example, `jQCFfuBOdN5z`.
        #
        #     For more information, see [How Meet identifies a meeting
        #     space](https://developers.google.com/meet/api/guides/meeting-spaces#identify-meeting-space).
        # @!attribute [r] meeting_uri
        #   @return [::String]
        #     Output only. URI used to join meetings consisting of
        #     `https://meet.google.com/` followed by the `meeting_code`. For example,
        #     `https://meet.google.com/abc-mnop-xyz`.
        # @!attribute [r] meeting_code
        #   @return [::String]
        #     Output only. Type friendly unique string used to join the meeting.
        #
        #     Format: `[a-z]+-[a-z]+-[a-z]+`. For example, `abc-mnop-xyz`.
        #
        #     The maximum length is 128 characters.
        #
        #     Can only be used as an alias of the space name to get the space.
        # @!attribute [rw] config
        #   @return [::Google::Apps::Meet::V2beta::SpaceConfig]
        #     Configuration pertaining to the meeting space.
        # @!attribute [rw] active_conference
        #   @return [::Google::Apps::Meet::V2beta::ActiveConference]
        #     Active conference, if it exists.
        class Space
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Active conference.
        # @!attribute [r] conference_record
        #   @return [::String]
        #     Output only. Reference to 'ConferenceRecord' resource.
        #     Format: `conferenceRecords/{conference_record}` where `{conference_record}`
        #     is a unique ID for each instance of a call within a space.
        class ActiveConference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration pertaining to a meeting space.
        # @!attribute [rw] access_type
        #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::AccessType]
        #     Access type of the meeting space that determines who can join without
        #     knocking. Default: The user's default access settings.  Controlled by the
        #     user's admin for enterprise users or RESTRICTED.
        # @!attribute [rw] entry_point_access
        #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::EntryPointAccess]
        #     Defines the entry points that can be used to join meetings hosted in this
        #     meeting space.
        #     Default: EntryPointAccess.ALL
        # @!attribute [rw] moderation
        #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::Moderation]
        #     [Developer Preview](https://developers.google.com/workspace/preview):
        #     The pre-configured moderation mode for the Meeting.
        #     Default: Controlled by the user's policies.
        # @!attribute [rw] moderation_restrictions
        #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ModerationRestrictions]
        #     [Developer Preview](https://developers.google.com/workspace/preview):
        #     When moderation.ON, these restrictions go into effect for the meeting.
        #     When moderation.OFF, will be reset to default ModerationRestrictions.
        # @!attribute [rw] attendance_report_generation_type
        #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::AttendanceReportGenerationType]
        #     [Developer Preview](https://developers.google.com/workspace/preview):
        #     Whether attendance report is enabled for the meeting space.
        # @!attribute [rw] artifact_config
        #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ArtifactConfig]
        #     [Developer Preview](https://developers.google.com/workspace/preview):
        #     Configuration pertaining to the auto-generated artifacts that the meeting
        #     supports.
        class SpaceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines restrictions for features when the meeting is moderated.
          # @!attribute [rw] chat_restriction
          #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ModerationRestrictions::RestrictionType]
          #     Defines who has permission to send chat messages in the meeting space.
          # @!attribute [rw] reaction_restriction
          #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ModerationRestrictions::RestrictionType]
          #     Defines who has permission to send reactions in the meeting space.
          # @!attribute [rw] present_restriction
          #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ModerationRestrictions::RestrictionType]
          #     Defines who has permission to share their screen in the meeting space.
          # @!attribute [rw] default_join_as_viewer_type
          #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ModerationRestrictions::DefaultJoinAsViewerType]
          #     Defines whether to restrict the default role assigned to users as viewer.
          class ModerationRestrictions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Determines who has permission to use a particular feature.
            module RestrictionType
              # Default value specified by user policy.
              # This should never be returned.
              RESTRICTION_TYPE_UNSPECIFIED = 0

              # Meeting owner and co-host have the permission.
              HOSTS_ONLY = 1

              # All Participants have permissions.
              NO_RESTRICTION = 2
            end

            # By default users will join as contributors. Hosts can restrict users to
            # join as viewers.
            # Note: If an explicit role is set for a users in the Member resource, the
            # user will join as that role.
            module DefaultJoinAsViewerType
              # Default value specified by user policy.
              # This should never be returned.
              DEFAULT_JOIN_AS_VIEWER_TYPE_UNSPECIFIED = 0

              # Users will by default join as viewers.
              ON = 1

              # Users will by default join as contributors.
              OFF = 2
            end
          end

          # Configuration related to meeting artifacts potentially generated by this
          # meeting space.
          # @!attribute [rw] recording_config
          #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ArtifactConfig::RecordingConfig]
          #     Configuration for recording.
          # @!attribute [rw] transcription_config
          #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ArtifactConfig::TranscriptionConfig]
          #     Configuration for auto-transcript.
          # @!attribute [rw] smart_notes_config
          #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ArtifactConfig::SmartNotesConfig]
          #     Configuration for auto-smart-notes.
          class ArtifactConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration related to recording in a meeting space.
            # @!attribute [rw] auto_recording_generation
            #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ArtifactConfig::AutoGenerationType]
            #     Defines whether a meeting space is automatically recorded when someone
            #     with the privilege to record joins the meeting.
            class RecordingConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration related to transcription in a meeting space.
            # @!attribute [rw] auto_transcription_generation
            #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ArtifactConfig::AutoGenerationType]
            #     Defines whether the content of a meeting is automatically transcribed
            #     when someone with the privilege to transcribe joins the meeting.
            class TranscriptionConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration related to smart notes in a meeting space. More
            # details about smart notes
            # https://support.google.com/meet/answer/14754931?hl=en.
            # @!attribute [rw] auto_smart_notes_generation
            #   @return [::Google::Apps::Meet::V2beta::SpaceConfig::ArtifactConfig::AutoGenerationType]
            #     Defines whether to automatically generate a summary and recap of the
            #     meeting for all invitees in the organization when someone with the
            #     privilege to enable smart notes joins the meeting.
            class SmartNotesConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Determines whether an artifact can be automatically generated in the
            # meeting space.
            module AutoGenerationType
              # Default value specified by user policy.
              # This should never be returned.
              AUTO_GENERATION_TYPE_UNSPECIFIED = 0

              # The artifact is generated automatically.
              ON = 1

              # The artifact is not generated automatically.
              OFF = 2
            end
          end

          # Possible access types for a meeting space.
          module AccessType
            # Default value specified by the user's organization.
            # Note: This is never returned, as the configured access type is
            # returned instead.
            ACCESS_TYPE_UNSPECIFIED = 0

            # Anyone with the join information (for example, the URL or phone access
            # information) can join without knocking.
            OPEN = 1

            # Members of the host's organization, invited external users, and dial-in
            # users can join without knocking. Everyone else must knock.
            TRUSTED = 2

            # Only invitees can join without knocking. Everyone else must knock.
            RESTRICTED = 3
          end

          # Entry points that can be used to join a meeting.  Example:
          # `meet.google.com`, the Meet Embed SDK Web, or a mobile application.
          module EntryPointAccess
            # Unused.
            ENTRY_POINT_ACCESS_UNSPECIFIED = 0

            # All entry points are allowed.
            ALL = 1

            # Only entry points owned by the Google Cloud project that created the
            # space can be used to join meetings in this space. Apps can use the Meet
            # Embed SDK Web or mobile Meet SDKs to create owned entry points.
            CREATOR_APP_ONLY = 2
          end

          # The moderation mode for a meeting. When the moderation mode is on, the
          # meeting owner has more control over the meeting with features such as
          # co-host management (see message Member) and feature restrictions (see
          # message ModerationRestrictions).
          module Moderation
            # Moderation type is not specified. This is used to indicate the user
            # hasn't specified any value as the user does not intend to update the
            # state. Users are not allowed to set the value as unspecified.
            MODERATION_UNSPECIFIED = 0

            # Moderation is off.
            OFF = 1

            # Moderation is on.
            ON = 2
          end

          # Possible states of whether attendance report is enabled for the meeting
          # space.
          module AttendanceReportGenerationType
            # Default value specified by user policy.
            # This should never be returned.
            ATTENDANCE_REPORT_GENERATION_TYPE_UNSPECIFIED = 0

            # Attendance report will be generated and sent to drive/email.
            GENERATE_REPORT = 1

            # Attendance report will not be generated.
            DO_NOT_GENERATE = 2
          end
        end

        # Users who are configured to have a role in the space. These users can
        # join the space without knocking.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the member.
        #     Format: spaces/\\{space}/members/\\{member}
        # @!attribute [rw] email
        #   @return [::String]
        #     Email for the member. This is required for creating the member.
        # @!attribute [rw] role
        #   @return [::Google::Apps::Meet::V2beta::Member::Role]
        #     The meeting role assigned to the member.
        # @!attribute [rw] user
        #   @return [::String]
        #     [Developer Preview](https://developers.google.com/workspace/preview):
        #     Unique name for the user. Interoperable with Admin SDK API and People API.
        #     This will be empty for non google users. Setting both user and email in
        #     request will result in error. Format: `users/{user}`
        class Member
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Role of this member in the space.
          module Role
            # This is used to indicate the user hasn't specified any value and the
            # user’s role will be determined upon joining the meetings between
            # 'contributor' and 'viewer' role depending on meeting configuration. More
            # details about viewer role
            # https://support.google.com/meet/answer/13658394?hl=en.
            ROLE_UNSPECIFIED = 0

            # Co-host role.
            COHOST = 1
          end
        end

        # Single instance of a meeting held in a space.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the conference record.
        #     Format: `conferenceRecords/{conference_record}` where `{conference_record}`
        #     is a unique ID for each instance of a call within a space.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the conference started. Always set.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the conference ended.
        #     Set for past conferences. Unset if the conference is ongoing.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Server enforced expiration time for when this conference
        #     record resource is deleted. The resource is deleted 30 days after the
        #     conference ends.
        # @!attribute [r] space
        #   @return [::String]
        #     Output only. The space where the conference was held.
        class ConferenceRecord
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # User who attended or is attending a conference.
        # @!attribute [rw] signedin_user
        #   @return [::Google::Apps::Meet::V2beta::SignedinUser]
        #     Signed-in user.
        #
        #     Note: The following fields are mutually exclusive: `signedin_user`, `anonymous_user`, `phone_user`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] anonymous_user
        #   @return [::Google::Apps::Meet::V2beta::AnonymousUser]
        #     Anonymous user.
        #
        #     Note: The following fields are mutually exclusive: `anonymous_user`, `signedin_user`, `phone_user`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] phone_user
        #   @return [::Google::Apps::Meet::V2beta::PhoneUser]
        #     User calling from their phone.
        #
        #     Note: The following fields are mutually exclusive: `phone_user`, `signedin_user`, `anonymous_user`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the participant.
        #     Format: `conferenceRecords/{conference_record}/participants/{participant}`
        # @!attribute [r] earliest_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the participant first joined the meeting.
        # @!attribute [r] latest_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the participant left the meeting for the last time.
        #     This can be null if it's an active meeting.
        class Participant
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Refers to each unique join or leave session when a user joins a conference
        # from a device. Note that any time a user joins the conference a new unique ID
        # is assigned. That means if a user joins a space multiple times from the same
        # device, they're assigned different IDs, and are also be treated as different
        # participant sessions.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Session id.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the user session starts.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the user session ends. Unset if the user
        #     session hasn’t ended.
        class ParticipantSession
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A signed-in user can be:
        # a) An individual joining from a personal computer, mobile device, or through
        # companion mode.
        # b) A robot account used by conference room devices.
        # @!attribute [r] user
        #   @return [::String]
        #     Output only. Unique ID for the user. Interoperable with Admin SDK API and
        #     People API. Format: `users/{user}`
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. For a personal device, it's the user's first name and last
        #     name. For a robot account, it's the administrator-specified device name.
        #     For example, "Altostrat Room".
        class SignedinUser
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # User who joins anonymously (meaning not signed into a Google Account).
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. User provided name when they join a conference anonymously.
        class AnonymousUser
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # User dialing in from a phone where the user's identity is unknown because
        # they haven't signed in with a Google Account.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Partially redacted user's phone number when calling.
        class PhoneUser
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about a recording created during a conference.
        # @!attribute [r] drive_destination
        #   @return [::Google::Apps::Meet::V2beta::DriveDestination]
        #     Output only. Recording is saved to Google Drive as an MP4 file. The
        #     `drive_destination` includes the Drive `fileId` that can be used to
        #     download the file using the `files.get` method of the Drive API.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the recording.
        #     Format: `conferenceRecords/{conference_record}/recordings/{recording}`
        #     where `{recording}` is a 1:1 mapping to each unique recording session
        #     during the conference.
        # @!attribute [r] state
        #   @return [::Google::Apps::Meet::V2beta::Recording::State]
        #     Output only. Current state.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the recording started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the recording ended.
        class Recording
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Current state of the recording session.
          module State
            # Default, never used.
            STATE_UNSPECIFIED = 0

            # An active recording session has started.
            STARTED = 1

            # This recording session has ended, but the recording file hasn't been
            # generated yet.
            ENDED = 2

            # Recording file is generated and ready to download.
            FILE_GENERATED = 3
          end
        end

        # Export location where a recording file is saved in Google Drive.
        # @!attribute [r] file
        #   @return [::String]
        #     Output only. The `fileId` for the underlying MP4 file. For example,
        #     "1kuceFZohVoCh6FulBHxwy6I15Ogpc4hP". Use `$ GET
        #     https://www.googleapis.com/drive/v3/files/\\{$fileId}?alt=media` to download
        #     the blob. For more information, see
        #     https://developers.google.com/drive/api/v3/reference/files/get.
        # @!attribute [r] export_uri
        #   @return [::String]
        #     Output only. Link used to play back the recording file in the browser. For
        #     example, `https://drive.google.com/file/d/{$fileId}/view`.
        class DriveDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for a transcript generated from a conference. It refers to the ASR
        # (Automatic Speech Recognition) result of user's speech during the conference.
        # @!attribute [r] docs_destination
        #   @return [::Google::Apps::Meet::V2beta::DocsDestination]
        #     Output only. Where the Google Docs transcript is saved.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the transcript.
        #     Format: `conferenceRecords/{conference_record}/transcripts/{transcript}`,
        #     where `{transcript}` is a 1:1 mapping to each unique transcription session
        #     of the conference.
        # @!attribute [r] state
        #   @return [::Google::Apps::Meet::V2beta::Transcript::State]
        #     Output only. Current state.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the transcript started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the transcript stopped.
        class Transcript
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Current state of the transcript session.
          module State
            # Default, never used.
            STATE_UNSPECIFIED = 0

            # An active transcript session has started.
            STARTED = 1

            # This transcript session has ended, but the transcript file hasn't been
            # generated yet.
            ENDED = 2

            # Transcript file is generated and ready to download.
            FILE_GENERATED = 3
          end
        end

        # Google Docs location where the transcript file is saved.
        # @!attribute [r] document
        #   @return [::String]
        #     Output only. The document ID for the underlying Google Docs transcript
        #     file. For example, "1kuceFZohVoCh6FulBHxwy6I15Ogpc4hP". Use the
        #     `documents.get` method of the Google Docs API
        #     (https://developers.google.com/docs/api/reference/rest/v1/documents/get) to
        #     fetch the content.
        # @!attribute [r] export_uri
        #   @return [::String]
        #     Output only. URI for the Google Docs transcript file. Use
        #     `https://docs.google.com/document/d/{$DocumentId}/view` to browse the
        #     transcript in the browser.
        class DocsDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Single entry for one user’s speech during a transcript session.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the entry. Format:
        #     "conferenceRecords/\\{conference_record}/transcripts/\\{transcript}/entries/\\{entry}"
        # @!attribute [r] participant
        #   @return [::String]
        #     Output only. Refers to the participant who speaks.
        # @!attribute [r] text
        #   @return [::String]
        #     Output only. The transcribed text of the participant's voice, at maximum
        #     10K words. Note that the limit is subject to change.
        # @!attribute [r] language_code
        #   @return [::String]
        #     Output only. Language of spoken text, such as "en-US".
        #     IETF BCP 47 syntax (https://tools.ietf.org/html/bcp47)
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the transcript entry started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the transcript entry ended.
        class TranscriptEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
