# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Meet
      module V2beta
        module ConferenceRecordsService
          # Path helper methods for the ConferenceRecordsService API.
          module Paths
            ##
            # Create a fully-qualified ConferenceRecord resource string.
            #
            # The resource will be in the following format:
            #
            # `conferenceRecords/{conference_record}`
            #
            # @param conference_record [String]
            #
            # @return [::String]
            def conference_record_path conference_record:
              "conferenceRecords/#{conference_record}"
            end

            ##
            # Create a fully-qualified Participant resource string.
            #
            # The resource will be in the following format:
            #
            # `conferenceRecords/{conference_record}/participants/{participant}`
            #
            # @param conference_record [String]
            # @param participant [String]
            #
            # @return [::String]
            def participant_path conference_record:, participant:
              raise ::ArgumentError, "conference_record cannot contain /" if conference_record.to_s.include? "/"

              "conferenceRecords/#{conference_record}/participants/#{participant}"
            end

            ##
            # Create a fully-qualified ParticipantSession resource string.
            #
            # The resource will be in the following format:
            #
            # `conferenceRecords/{conference_record}/participants/{participant}/participantSessions/{participant_session}`
            #
            # @param conference_record [String]
            # @param participant [String]
            # @param participant_session [String]
            #
            # @return [::String]
            def participant_session_path conference_record:, participant:, participant_session:
              raise ::ArgumentError, "conference_record cannot contain /" if conference_record.to_s.include? "/"
              raise ::ArgumentError, "participant cannot contain /" if participant.to_s.include? "/"

              "conferenceRecords/#{conference_record}/participants/#{participant}/participantSessions/#{participant_session}"
            end

            ##
            # Create a fully-qualified Recording resource string.
            #
            # The resource will be in the following format:
            #
            # `conferenceRecords/{conference_record}/recordings/{recording}`
            #
            # @param conference_record [String]
            # @param recording [String]
            #
            # @return [::String]
            def recording_path conference_record:, recording:
              raise ::ArgumentError, "conference_record cannot contain /" if conference_record.to_s.include? "/"

              "conferenceRecords/#{conference_record}/recordings/#{recording}"
            end

            ##
            # Create a fully-qualified Transcript resource string.
            #
            # The resource will be in the following format:
            #
            # `conferenceRecords/{conference_record}/transcripts/{transcript}`
            #
            # @param conference_record [String]
            # @param transcript [String]
            #
            # @return [::String]
            def transcript_path conference_record:, transcript:
              raise ::ArgumentError, "conference_record cannot contain /" if conference_record.to_s.include? "/"

              "conferenceRecords/#{conference_record}/transcripts/#{transcript}"
            end

            ##
            # Create a fully-qualified TranscriptEntry resource string.
            #
            # The resource will be in the following format:
            #
            # `conferenceRecords/{conference_record}/transcripts/{transcript}/entries/{entry}`
            #
            # @param conference_record [String]
            # @param transcript [String]
            # @param entry [String]
            #
            # @return [::String]
            def transcript_entry_path conference_record:, transcript:, entry:
              raise ::ArgumentError, "conference_record cannot contain /" if conference_record.to_s.include? "/"
              raise ::ArgumentError, "transcript cannot contain /" if transcript.to_s.include? "/"

              "conferenceRecords/#{conference_record}/transcripts/#{transcript}/entries/#{entry}"
            end

            extend self
          end
        end
      end
    end
  end
end
