# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/apps/meet/v2beta/service_pb"

module Google
  module Apps
    module Meet
      module V2beta
        module ConferenceRecordsService
          ##
          # Client for the ConferenceRecordsService service.
          #
          # REST API for services dealing with conference records.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "meet.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :conference_records_service_stub

            ##
            # Configure the ConferenceRecordsService Client class.
            #
            # See {::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ConferenceRecordsService clients
            #   ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Apps", "Meet", "V2beta"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.get_conference_record.timeout = 60.0
                default_config.rpcs.get_conference_record.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_conference_records.timeout = 60.0
                default_config.rpcs.list_conference_records.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_participant.timeout = 60.0
                default_config.rpcs.get_participant.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_participants.timeout = 60.0
                default_config.rpcs.list_participants.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_participant_session.timeout = 60.0
                default_config.rpcs.get_participant_session.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_participant_sessions.timeout = 60.0
                default_config.rpcs.list_participant_sessions.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_recording.timeout = 60.0
                default_config.rpcs.get_recording.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_recordings.timeout = 60.0
                default_config.rpcs.list_recordings.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_transcript.timeout = 60.0
                default_config.rpcs.get_transcript.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_transcripts.timeout = 60.0
                default_config.rpcs.list_transcripts.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_transcript_entry.timeout = 60.0
                default_config.rpcs.get_transcript_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_transcript_entries.timeout = 60.0
                default_config.rpcs.list_transcript_entries.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ConferenceRecordsService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @conference_records_service_stub.universe_domain
            end

            ##
            # Create a new ConferenceRecordsService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ConferenceRecordsService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/apps/meet/v2beta/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @conference_records_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @conference_records_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @conference_records_service_stub.logger
            end

            # Service calls

            ##
            # Gets a conference record by conference ID.
            #
            # @overload get_conference_record(request, options = nil)
            #   Pass arguments to `get_conference_record` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::GetConferenceRecordRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::GetConferenceRecordRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_conference_record(name: nil)
            #   Pass arguments to `get_conference_record` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the conference.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Meet::V2beta::ConferenceRecord]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Meet::V2beta::ConferenceRecord]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::GetConferenceRecordRequest.new
            #
            #   # Call the get_conference_record method.
            #   result = client.get_conference_record request
            #
            #   # The returned object is of type Google::Apps::Meet::V2beta::ConferenceRecord.
            #   p result
            #
            def get_conference_record request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::GetConferenceRecordRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_conference_record.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_conference_record.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_conference_record.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :get_conference_record, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the conference records. By default, ordered by start time and in
            # descending order.
            #
            # @overload list_conference_records(request, options = nil)
            #   Pass arguments to `list_conference_records` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::ListConferenceRecordsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::ListConferenceRecordsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_conference_records(page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_conference_records` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param page_size [::Integer]
            #     Optional. Maximum number of conference records to return. The service might
            #     return fewer than this value. If unspecified, at most 25 conference records
            #     are returned. The maximum value is 100; values above 100 are coerced to
            #     100. Maximum might change in the future.
            #   @param page_token [::String]
            #     Optional. Page token returned from previous List Call.
            #   @param filter [::String]
            #     Optional. User specified filtering condition in [EBNF
            #     format](https://en.wikipedia.org/wiki/Extended_Backus%E2%80%93Naur_form).
            #     The following are the filterable fields:
            #
            #     * `space.meeting_code`
            #     * `space.name`
            #     * `start_time`
            #     * `end_time`
            #
            #     For example, consider the following filters:
            #
            #     * `space.name = "spaces/NAME"`
            #     * `space.meeting_code = "abc-mnop-xyz"`
            #     * `start_time>="2024-01-01T00:00:00.000Z" AND
            #     start_time<="2024-01-02T00:00:00.000Z"`
            #     * `end_time IS NULL`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::ConferenceRecord>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::ConferenceRecord>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::ListConferenceRecordsRequest.new
            #
            #   # Call the list_conference_records method.
            #   result = client.list_conference_records request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Meet::V2beta::ConferenceRecord.
            #     p item
            #   end
            #
            def list_conference_records request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::ListConferenceRecordsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_conference_records.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_conference_records.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_conference_records.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :list_conference_records, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @conference_records_service_stub, :list_conference_records, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a participant by participant ID.
            #
            # @overload get_participant(request, options = nil)
            #   Pass arguments to `get_participant` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::GetParticipantRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::GetParticipantRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_participant(name: nil)
            #   Pass arguments to `get_participant` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the participant.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Meet::V2beta::Participant]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Meet::V2beta::Participant]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::GetParticipantRequest.new
            #
            #   # Call the get_participant method.
            #   result = client.get_participant request
            #
            #   # The returned object is of type Google::Apps::Meet::V2beta::Participant.
            #   p result
            #
            def get_participant request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::GetParticipantRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_participant.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_participant.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_participant.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :get_participant, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the participants in a conference record. By default, ordered by join
            # time and in descending order. This API supports `fields` as standard
            # parameters like every other API. However, when the `fields` request
            # parameter is omitted, this API defaults to `'participants/*,
            # next_page_token'`.
            #
            # @overload list_participants(request, options = nil)
            #   Pass arguments to `list_participants` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::ListParticipantsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::ListParticipantsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_participants(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_participants` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format: `conferenceRecords/{conference_record}`
            #   @param page_size [::Integer]
            #     Maximum number of participants to return. The service might return fewer
            #     than this value.
            #     If unspecified, at most 100 participants are returned.
            #     The maximum value is 250; values above 250 are coerced to 250.
            #     Maximum might change in the future.
            #   @param page_token [::String]
            #     Page token returned from previous List Call.
            #   @param filter [::String]
            #     Optional. User specified filtering condition in [EBNF
            #     format](https://en.wikipedia.org/wiki/Extended_Backus%E2%80%93Naur_form).
            #     The following are the filterable fields:
            #
            #     * `earliest_start_time`
            #     * `latest_end_time`
            #
            #     For example, `latest_end_time IS NULL` returns active participants in
            #     the conference.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::Participant>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::Participant>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::ListParticipantsRequest.new
            #
            #   # Call the list_participants method.
            #   result = client.list_participants request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Meet::V2beta::Participant.
            #     p item
            #   end
            #
            def list_participants request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::ListParticipantsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_participants.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_participants.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_participants.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :list_participants, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @conference_records_service_stub, :list_participants, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a participant session by participant session ID.
            #
            # @overload get_participant_session(request, options = nil)
            #   Pass arguments to `get_participant_session` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::GetParticipantSessionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::GetParticipantSessionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_participant_session(name: nil)
            #   Pass arguments to `get_participant_session` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the participant.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Meet::V2beta::ParticipantSession]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Meet::V2beta::ParticipantSession]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::GetParticipantSessionRequest.new
            #
            #   # Call the get_participant_session method.
            #   result = client.get_participant_session request
            #
            #   # The returned object is of type Google::Apps::Meet::V2beta::ParticipantSession.
            #   p result
            #
            def get_participant_session request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::GetParticipantSessionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_participant_session.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_participant_session.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_participant_session.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :get_participant_session, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the participant sessions of a participant in a conference record. By
            # default, ordered by join time and in descending order. This API supports
            # `fields` as standard parameters like every other API. However, when the
            # `fields` request parameter is omitted this API defaults to
            # `'participantsessions/*, next_page_token'`.
            #
            # @overload list_participant_sessions(request, options = nil)
            #   Pass arguments to `list_participant_sessions` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::ListParticipantSessionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::ListParticipantSessionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_participant_sessions(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_participant_sessions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format:
            #     `conferenceRecords/{conference_record}/participants/{participant}`
            #   @param page_size [::Integer]
            #     Optional. Maximum number of participant sessions to return. The service
            #     might return fewer than this value. If unspecified, at most 100
            #     participants are returned. The maximum value is 250; values above 250 are
            #     coerced to 250. Maximum might change in the future.
            #   @param page_token [::String]
            #     Optional. Page token returned from previous List Call.
            #   @param filter [::String]
            #     Optional. User specified filtering condition in [EBNF
            #     format](https://en.wikipedia.org/wiki/Extended_Backus%E2%80%93Naur_form).
            #     The following are the filterable fields:
            #
            #     * `start_time`
            #     * `end_time`
            #
            #     For example, `end_time IS NULL` returns active participant sessions in
            #     the conference record.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::ParticipantSession>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::ParticipantSession>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::ListParticipantSessionsRequest.new
            #
            #   # Call the list_participant_sessions method.
            #   result = client.list_participant_sessions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Meet::V2beta::ParticipantSession.
            #     p item
            #   end
            #
            def list_participant_sessions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::ListParticipantSessionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_participant_sessions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_participant_sessions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_participant_sessions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :list_participant_sessions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @conference_records_service_stub, :list_participant_sessions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a recording by recording ID.
            #
            # @overload get_recording(request, options = nil)
            #   Pass arguments to `get_recording` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::GetRecordingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::GetRecordingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_recording(name: nil)
            #   Pass arguments to `get_recording` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the recording.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Meet::V2beta::Recording]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Meet::V2beta::Recording]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::GetRecordingRequest.new
            #
            #   # Call the get_recording method.
            #   result = client.get_recording request
            #
            #   # The returned object is of type Google::Apps::Meet::V2beta::Recording.
            #   p result
            #
            def get_recording request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::GetRecordingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_recording.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_recording.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_recording.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :get_recording, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the recording resources from the conference record. By default,
            # ordered by start time and in ascending order.
            #
            # @overload list_recordings(request, options = nil)
            #   Pass arguments to `list_recordings` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::ListRecordingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::ListRecordingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_recordings(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_recordings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format: `conferenceRecords/{conference_record}`
            #   @param page_size [::Integer]
            #     Maximum number of recordings to return. The service might return fewer
            #     than this value.
            #     If unspecified, at most 10 recordings are returned.
            #     The maximum value is 100; values above 100 are coerced to 100.
            #     Maximum might change in the future.
            #   @param page_token [::String]
            #     Page token returned from previous List Call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::Recording>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::Recording>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::ListRecordingsRequest.new
            #
            #   # Call the list_recordings method.
            #   result = client.list_recordings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Meet::V2beta::Recording.
            #     p item
            #   end
            #
            def list_recordings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::ListRecordingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_recordings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_recordings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_recordings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :list_recordings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @conference_records_service_stub, :list_recordings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a transcript by transcript ID.
            #
            # @overload get_transcript(request, options = nil)
            #   Pass arguments to `get_transcript` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::GetTranscriptRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::GetTranscriptRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_transcript(name: nil)
            #   Pass arguments to `get_transcript` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the transcript.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Meet::V2beta::Transcript]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Meet::V2beta::Transcript]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::GetTranscriptRequest.new
            #
            #   # Call the get_transcript method.
            #   result = client.get_transcript request
            #
            #   # The returned object is of type Google::Apps::Meet::V2beta::Transcript.
            #   p result
            #
            def get_transcript request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::GetTranscriptRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_transcript.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_transcript.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_transcript.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :get_transcript, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the set of transcripts from the conference record. By default,
            # ordered by start time and in ascending order.
            #
            # @overload list_transcripts(request, options = nil)
            #   Pass arguments to `list_transcripts` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::ListTranscriptsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::ListTranscriptsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_transcripts(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_transcripts` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format: `conferenceRecords/{conference_record}`
            #   @param page_size [::Integer]
            #     Maximum number of transcripts to return. The service might return fewer
            #     than this value.
            #     If unspecified, at most 10 transcripts are returned.
            #     The maximum value is 100; values above 100 are coerced to 100.
            #     Maximum might change in the future.
            #   @param page_token [::String]
            #     Page token returned from previous List Call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::Transcript>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::Transcript>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::ListTranscriptsRequest.new
            #
            #   # Call the list_transcripts method.
            #   result = client.list_transcripts request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Meet::V2beta::Transcript.
            #     p item
            #   end
            #
            def list_transcripts request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::ListTranscriptsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_transcripts.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_transcripts.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_transcripts.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :list_transcripts, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @conference_records_service_stub, :list_transcripts, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a `TranscriptEntry` resource by entry ID.
            #
            # Note: The transcript entries returned by the Google Meet API might not
            # match the transcription found in the Google Docs transcript file. This can
            # occur when the Google Docs transcript file is modified after generation.
            #
            # @overload get_transcript_entry(request, options = nil)
            #   Pass arguments to `get_transcript_entry` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::GetTranscriptEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::GetTranscriptEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_transcript_entry(name: nil)
            #   Pass arguments to `get_transcript_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the `TranscriptEntry`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Meet::V2beta::TranscriptEntry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Meet::V2beta::TranscriptEntry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::GetTranscriptEntryRequest.new
            #
            #   # Call the get_transcript_entry method.
            #   result = client.get_transcript_entry request
            #
            #   # The returned object is of type Google::Apps::Meet::V2beta::TranscriptEntry.
            #   p result
            #
            def get_transcript_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::GetTranscriptEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_transcript_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_transcript_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_transcript_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :get_transcript_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the structured transcript entries per transcript. By default, ordered
            # by start time and in ascending order.
            #
            # Note: The transcript entries returned by the Google Meet API might not
            # match the transcription found in the Google Docs transcript file. This can
            # occur when the Google Docs transcript file is modified after generation.
            #
            # @overload list_transcript_entries(request, options = nil)
            #   Pass arguments to `list_transcript_entries` via a request object, either of type
            #   {::Google::Apps::Meet::V2beta::ListTranscriptEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Meet::V2beta::ListTranscriptEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_transcript_entries(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_transcript_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format:
            #     `conferenceRecords/{conference_record}/transcripts/{transcript}`
            #   @param page_size [::Integer]
            #     Maximum number of entries to return. The service might return fewer than
            #     this value.
            #     If unspecified, at most 10 entries are returned.
            #     The maximum value is 100; values above 100 are coerced to 100.
            #     Maximum might change in the future.
            #   @param page_token [::String]
            #     Page token returned from previous List Call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::TranscriptEntry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Meet::V2beta::TranscriptEntry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/meet/v2beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Meet::V2beta::ListTranscriptEntriesRequest.new
            #
            #   # Call the list_transcript_entries method.
            #   result = client.list_transcript_entries request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Meet::V2beta::TranscriptEntry.
            #     p item
            #   end
            #
            def list_transcript_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Meet::V2beta::ListTranscriptEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_transcript_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Meet::V2beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_transcript_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_transcript_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @conference_records_service_stub.call_rpc :list_transcript_entries, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @conference_records_service_stub, :list_transcript_entries, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ConferenceRecordsService API.
            #
            # This class represents the configuration for ConferenceRecordsService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_conference_record to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_conference_record.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_conference_record.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Apps::Meet::V2beta::ConferenceRecordsService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "meet.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ConferenceRecordsService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_conference_record`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_conference_record
                ##
                # RPC-specific configuration for `list_conference_records`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_conference_records
                ##
                # RPC-specific configuration for `get_participant`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_participant
                ##
                # RPC-specific configuration for `list_participants`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_participants
                ##
                # RPC-specific configuration for `get_participant_session`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_participant_session
                ##
                # RPC-specific configuration for `list_participant_sessions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_participant_sessions
                ##
                # RPC-specific configuration for `get_recording`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_recording
                ##
                # RPC-specific configuration for `list_recordings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_recordings
                ##
                # RPC-specific configuration for `get_transcript`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_transcript
                ##
                # RPC-specific configuration for `list_transcripts`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_transcripts
                ##
                # RPC-specific configuration for `get_transcript_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_transcript_entry
                ##
                # RPC-specific configuration for `list_transcript_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_transcript_entries

                # @private
                def initialize parent_rpcs = nil
                  get_conference_record_config = parent_rpcs.get_conference_record if parent_rpcs.respond_to? :get_conference_record
                  @get_conference_record = ::Gapic::Config::Method.new get_conference_record_config
                  list_conference_records_config = parent_rpcs.list_conference_records if parent_rpcs.respond_to? :list_conference_records
                  @list_conference_records = ::Gapic::Config::Method.new list_conference_records_config
                  get_participant_config = parent_rpcs.get_participant if parent_rpcs.respond_to? :get_participant
                  @get_participant = ::Gapic::Config::Method.new get_participant_config
                  list_participants_config = parent_rpcs.list_participants if parent_rpcs.respond_to? :list_participants
                  @list_participants = ::Gapic::Config::Method.new list_participants_config
                  get_participant_session_config = parent_rpcs.get_participant_session if parent_rpcs.respond_to? :get_participant_session
                  @get_participant_session = ::Gapic::Config::Method.new get_participant_session_config
                  list_participant_sessions_config = parent_rpcs.list_participant_sessions if parent_rpcs.respond_to? :list_participant_sessions
                  @list_participant_sessions = ::Gapic::Config::Method.new list_participant_sessions_config
                  get_recording_config = parent_rpcs.get_recording if parent_rpcs.respond_to? :get_recording
                  @get_recording = ::Gapic::Config::Method.new get_recording_config
                  list_recordings_config = parent_rpcs.list_recordings if parent_rpcs.respond_to? :list_recordings
                  @list_recordings = ::Gapic::Config::Method.new list_recordings_config
                  get_transcript_config = parent_rpcs.get_transcript if parent_rpcs.respond_to? :get_transcript
                  @get_transcript = ::Gapic::Config::Method.new get_transcript_config
                  list_transcripts_config = parent_rpcs.list_transcripts if parent_rpcs.respond_to? :list_transcripts
                  @list_transcripts = ::Gapic::Config::Method.new list_transcripts_config
                  get_transcript_entry_config = parent_rpcs.get_transcript_entry if parent_rpcs.respond_to? :get_transcript_entry
                  @get_transcript_entry = ::Gapic::Config::Method.new get_transcript_entry_config
                  list_transcript_entries_config = parent_rpcs.list_transcript_entries if parent_rpcs.respond_to? :list_transcript_entries
                  @list_transcript_entries = ::Gapic::Config::Method.new list_transcript_entries_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
