# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/apps/meet/v2/service.proto for package 'Google.Apps.Meet.V2'
# Original file comments:
# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/apps/meet/v2/service_pb'

module Google
  module Apps
    module Meet
      module V2
        module SpacesService
          # REST API for services dealing with spaces.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.apps.meet.v2.SpacesService'

            # Creates a space.
            rpc :CreateSpace, ::Google::Apps::Meet::V2::CreateSpaceRequest, ::Google::Apps::Meet::V2::Space
            # Gets details about a meeting space.
            #
            # For an example, see [Get a meeting
            # space](https://developers.google.com/meet/api/guides/meeting-spaces#get-meeting-space).
            rpc :GetSpace, ::Google::Apps::Meet::V2::GetSpaceRequest, ::Google::Apps::Meet::V2::Space
            # Updates details about a meeting space.
            #
            # For an example, see [Update a meeting
            # space](https://developers.google.com/meet/api/guides/meeting-spaces#update-meeting-space).
            rpc :UpdateSpace, ::Google::Apps::Meet::V2::UpdateSpaceRequest, ::Google::Apps::Meet::V2::Space
            # Ends an active conference (if there's one).
            #
            # For an example, see [End active
            # conference](https://developers.google.com/meet/api/guides/meeting-spaces#end-active-conference).
            rpc :EndActiveConference, ::Google::Apps::Meet::V2::EndActiveConferenceRequest, ::Google::Protobuf::Empty
          end

          Stub = Service.rpc_stub_class
        end
        module ConferenceRecordsService
          # REST API for services dealing with conference records.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.apps.meet.v2.ConferenceRecordsService'

            # Gets a conference record by conference ID.
            rpc :GetConferenceRecord, ::Google::Apps::Meet::V2::GetConferenceRecordRequest, ::Google::Apps::Meet::V2::ConferenceRecord
            # Lists the conference records. By default, ordered by start time and in
            # descending order.
            rpc :ListConferenceRecords, ::Google::Apps::Meet::V2::ListConferenceRecordsRequest, ::Google::Apps::Meet::V2::ListConferenceRecordsResponse
            # Gets a participant by participant ID.
            rpc :GetParticipant, ::Google::Apps::Meet::V2::GetParticipantRequest, ::Google::Apps::Meet::V2::Participant
            # Lists the participants in a conference record. By default, ordered by join
            # time and in descending order. This API supports `fields` as standard
            # parameters like every other API. However, when the `fields` request
            # parameter is omitted, this API defaults to `'participants/*,
            # next_page_token'`.
            rpc :ListParticipants, ::Google::Apps::Meet::V2::ListParticipantsRequest, ::Google::Apps::Meet::V2::ListParticipantsResponse
            # Gets a participant session by participant session ID.
            rpc :GetParticipantSession, ::Google::Apps::Meet::V2::GetParticipantSessionRequest, ::Google::Apps::Meet::V2::ParticipantSession
            # Lists the participant sessions of a participant in a conference record. By
            # default, ordered by join time and in descending order. This API supports
            # `fields` as standard parameters like every other API. However, when the
            # `fields` request parameter is omitted this API defaults to
            # `'participantsessions/*, next_page_token'`.
            rpc :ListParticipantSessions, ::Google::Apps::Meet::V2::ListParticipantSessionsRequest, ::Google::Apps::Meet::V2::ListParticipantSessionsResponse
            # Gets a recording by recording ID.
            rpc :GetRecording, ::Google::Apps::Meet::V2::GetRecordingRequest, ::Google::Apps::Meet::V2::Recording
            # Lists the recording resources from the conference record. By default,
            # ordered by start time and in ascending order.
            rpc :ListRecordings, ::Google::Apps::Meet::V2::ListRecordingsRequest, ::Google::Apps::Meet::V2::ListRecordingsResponse
            # Gets a transcript by transcript ID.
            rpc :GetTranscript, ::Google::Apps::Meet::V2::GetTranscriptRequest, ::Google::Apps::Meet::V2::Transcript
            # Lists the set of transcripts from the conference record. By default,
            # ordered by start time and in ascending order.
            rpc :ListTranscripts, ::Google::Apps::Meet::V2::ListTranscriptsRequest, ::Google::Apps::Meet::V2::ListTranscriptsResponse
            # Gets a `TranscriptEntry` resource by entry ID.
            #
            # Note: The transcript entries returned by the Google Meet API might not
            # match the transcription found in the Google Docs transcript file. This can
            # occur when the Google Docs transcript file is modified after generation.
            rpc :GetTranscriptEntry, ::Google::Apps::Meet::V2::GetTranscriptEntryRequest, ::Google::Apps::Meet::V2::TranscriptEntry
            # Lists the structured transcript entries per transcript. By default, ordered
            # by start time and in ascending order.
            #
            # Note: The transcript entries returned by the Google Meet API might not
            # match the transcription found in the Google Docs transcript file. This can
            # occur when the Google Docs transcript file is modified after generation.
            rpc :ListTranscriptEntries, ::Google::Apps::Meet::V2::ListTranscriptEntriesRequest, ::Google::Apps::Meet::V2::ListTranscriptEntriesResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
