# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/apps/meet/v2/version"

require "google/apps/meet/v2/conference_records_service/credentials"
require "google/apps/meet/v2/conference_records_service/paths"
require "google/apps/meet/v2/conference_records_service/client"
require "google/apps/meet/v2/conference_records_service/rest"

module Google
  module Apps
    module Meet
      module V2
        ##
        # REST API for services dealing with conference records.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/apps/meet/v2/conference_records_service"
        #     client = ::Google::Apps::Meet::V2::ConferenceRecordsService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/apps/meet/v2/conference_records_service/rest"
        #     client = ::Google::Apps::Meet::V2::ConferenceRecordsService::Rest::Client.new
        #
        module ConferenceRecordsService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "conference_records_service", "helpers.rb"
require "google/apps/meet/v2/conference_records_service/helpers" if ::File.file? helper_path
