# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/apps/events/subscriptions/v1beta/subscriptions_service_pb"
require "google/apps/events/subscriptions/v1beta/subscriptions_service"

class ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = {}
    validate_only = true

    create_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_subscription, name
      assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::CreateSubscriptionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Events::Subscriptions::V1beta::Subscription), request["subscription"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_subscription_client_stub do
      # Create client
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_subscription({ subscription: subscription, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_subscription subscription: subscription, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_subscription ::Google::Apps::Events::Subscriptions::V1beta::CreateSubscriptionRequest.new(subscription: subscription, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_subscription({ subscription: subscription, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_subscription(::Google::Apps::Events::Subscriptions::V1beta::CreateSubscriptionRequest.new(subscription: subscription, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_subscription_client_stub.call_rpc_count
    end
  end

  def test_delete_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"

    delete_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_subscription, name
      assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::DeleteSubscriptionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_subscription_client_stub do
      # Create client
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_subscription({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_subscription name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_subscription ::Google::Apps::Events::Subscriptions::V1beta::DeleteSubscriptionRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_subscription({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_subscription(::Google::Apps::Events::Subscriptions::V1beta::DeleteSubscriptionRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_subscription_client_stub.call_rpc_count
    end
  end

  def test_get_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Events::Subscriptions::V1beta::Subscription.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_subscription, name
      assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::GetSubscriptionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_subscription_client_stub do
      # Create client
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_subscription({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_subscription name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_subscription ::Google::Apps::Events::Subscriptions::V1beta::GetSubscriptionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_subscription({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_subscription(::Google::Apps::Events::Subscriptions::V1beta::GetSubscriptionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_subscription_client_stub.call_rpc_count
    end
  end

  def test_list_subscriptions
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Events::Subscriptions::V1beta::ListSubscriptionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_subscriptions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subscriptions, name
      assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::ListSubscriptionsRequest, request
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subscriptions_client_stub do
      # Create client
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subscriptions({ page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subscriptions page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subscriptions ::Google::Apps::Events::Subscriptions::V1beta::ListSubscriptionsRequest.new(page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subscriptions({ page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subscriptions(::Google::Apps::Events::Subscriptions::V1beta::ListSubscriptionsRequest.new(page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subscriptions_client_stub.call_rpc_count
    end
  end

  def test_update_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = {}
    update_mask = {}
    validate_only = true

    update_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_subscription, name
      assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::UpdateSubscriptionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Events::Subscriptions::V1beta::Subscription), request["subscription"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_subscription_client_stub do
      # Create client
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_subscription({ subscription: subscription, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_subscription subscription: subscription, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_subscription ::Google::Apps::Events::Subscriptions::V1beta::UpdateSubscriptionRequest.new(subscription: subscription, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_subscription({ subscription: subscription, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_subscription(::Google::Apps::Events::Subscriptions::V1beta::UpdateSubscriptionRequest.new(subscription: subscription, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_subscription_client_stub.call_rpc_count
    end
  end

  def test_reactivate_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reactivate_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reactivate_subscription, name
      assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::ReactivateSubscriptionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reactivate_subscription_client_stub do
      # Create client
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reactivate_subscription({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reactivate_subscription name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reactivate_subscription ::Google::Apps::Events::Subscriptions::V1beta::ReactivateSubscriptionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reactivate_subscription({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reactivate_subscription(::Google::Apps::Events::Subscriptions::V1beta::ReactivateSubscriptionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reactivate_subscription_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Operations, client.operations_client
  end
end
