# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/apps/events/subscriptions/v1beta/subscriptions_service_pb"
require "google/apps/events/subscriptions/v1beta/subscriptions_service/rest/service_stub"

module Google
  module Apps
    module Events
      module Subscriptions
        module V1beta
          module SubscriptionsService
            module Rest
              ##
              # REST client for the SubscriptionsService service.
              #
              # A service that manages subscriptions to Google Workspace events.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "workspaceevents.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :subscriptions_service_stub

                ##
                # Configure the SubscriptionsService Client class.
                #
                # See {::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all SubscriptionsService clients
                #   ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Apps", "Events", "Subscriptions", "V1beta"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.create_subscription.timeout = 60.0

                    default_config.rpcs.delete_subscription.timeout = 60.0

                    default_config.rpcs.get_subscription.timeout = 60.0
                    default_config.rpcs.get_subscription.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_subscriptions.timeout = 60.0
                    default_config.rpcs.list_subscriptions.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.update_subscription.timeout = 60.0

                    default_config.rpcs.reactivate_subscription.timeout = 60.0

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the SubscriptionsService Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @subscriptions_service_stub.universe_domain
                end

                ##
                # Create a new SubscriptionsService REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the SubscriptionsService client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @operations_client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Operations.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @config.endpoint
                    config.universe_domain = @config.universe_domain
                  end

                  @subscriptions_service_stub = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @subscriptions_service_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end
                end

                ##
                # Get the associated client for long-running operations.
                #
                # @return [::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Operations]
                #
                attr_reader :operations_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @subscriptions_service_stub.logger
                end

                # Service calls

                ##
                # Creates a Google Workspace subscription. To learn how to use this
                # method, see [Create a Google Workspace
                # subscription](https://developers.google.com/workspace/events/guides/create-subscription).
                #
                # @overload create_subscription(request, options = nil)
                #   Pass arguments to `create_subscription` via a request object, either of type
                #   {::Google::Apps::Events::Subscriptions::V1beta::CreateSubscriptionRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Apps::Events::Subscriptions::V1beta::CreateSubscriptionRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_subscription(subscription: nil, validate_only: nil)
                #   Pass arguments to `create_subscription` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param subscription [::Google::Apps::Events::Subscriptions::V1beta::Subscription, ::Hash]
                #     Required. The subscription resource to create.
                #   @param validate_only [::Boolean]
                #     Optional. If set to `true`, validates and previews the request, but doesn't
                #     create the subscription.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/apps/events/subscriptions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Apps::Events::Subscriptions::V1beta::CreateSubscriptionRequest.new
                #
                #   # Call the create_subscription method.
                #   result = client.create_subscription request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def create_subscription request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1beta::CreateSubscriptionRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_subscription.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Apps::Events::Subscriptions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_subscription.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_subscription.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @subscriptions_service_stub.create_subscription request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a Google Workspace subscription.
                # To learn how to use this method, see [Delete a Google Workspace
                # subscription](https://developers.google.com/workspace/events/guides/delete-subscription).
                #
                # @overload delete_subscription(request, options = nil)
                #   Pass arguments to `delete_subscription` via a request object, either of type
                #   {::Google::Apps::Events::Subscriptions::V1beta::DeleteSubscriptionRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Apps::Events::Subscriptions::V1beta::DeleteSubscriptionRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_subscription(name: nil, validate_only: nil, allow_missing: nil, etag: nil)
                #   Pass arguments to `delete_subscription` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Resource name of the subscription to delete.
                #
                #     Format: `subscriptions/{subscription}`
                #   @param validate_only [::Boolean]
                #     Optional. If set to `true`, validates and previews the request, but doesn't
                #     delete the subscription.
                #   @param allow_missing [::Boolean]
                #     Optional. If set to `true` and the subscription isn't found, the request
                #     succeeds but doesn't delete the subscription.
                #   @param etag [::String]
                #     Optional. Etag of the subscription.
                #
                #     If present, it must match with the server's etag. Otherwise, request
                #     fails with the status `ABORTED`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/apps/events/subscriptions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Apps::Events::Subscriptions::V1beta::DeleteSubscriptionRequest.new
                #
                #   # Call the delete_subscription method.
                #   result = client.delete_subscription request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def delete_subscription request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1beta::DeleteSubscriptionRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_subscription.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Apps::Events::Subscriptions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_subscription.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_subscription.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @subscriptions_service_stub.delete_subscription request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets details about a Google Workspace subscription. To learn how to use
                # this method, see [Get details about a Google Workspace
                # subscription](https://developers.google.com/workspace/events/guides/get-subscription).
                #
                # @overload get_subscription(request, options = nil)
                #   Pass arguments to `get_subscription` via a request object, either of type
                #   {::Google::Apps::Events::Subscriptions::V1beta::GetSubscriptionRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Apps::Events::Subscriptions::V1beta::GetSubscriptionRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_subscription(name: nil)
                #   Pass arguments to `get_subscription` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Resource name of the subscription.
                #
                #     Format: `subscriptions/{subscription}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Apps::Events::Subscriptions::V1beta::Subscription]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Apps::Events::Subscriptions::V1beta::Subscription]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/apps/events/subscriptions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Apps::Events::Subscriptions::V1beta::GetSubscriptionRequest.new
                #
                #   # Call the get_subscription method.
                #   result = client.get_subscription request
                #
                #   # The returned object is of type Google::Apps::Events::Subscriptions::V1beta::Subscription.
                #   p result
                #
                def get_subscription request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1beta::GetSubscriptionRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_subscription.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Apps::Events::Subscriptions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_subscription.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_subscription.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @subscriptions_service_stub.get_subscription request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists Google Workspace subscriptions. To learn how to use this method, see
                # [List Google Workspace
                # subscriptions](https://developers.google.com/workspace/events/guides/list-subscriptions).
                #
                # @overload list_subscriptions(request, options = nil)
                #   Pass arguments to `list_subscriptions` via a request object, either of type
                #   {::Google::Apps::Events::Subscriptions::V1beta::ListSubscriptionsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Apps::Events::Subscriptions::V1beta::ListSubscriptionsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_subscriptions(page_size: nil, page_token: nil, filter: nil)
                #   Pass arguments to `list_subscriptions` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param page_size [::Integer]
                #     Optional. The maximum number of subscriptions to return. The service might
                #     return fewer than this value.
                #
                #     If unspecified or set to `0`, up to 50 subscriptions are returned.
                #
                #     The maximum value is 100. If you specify a value more than 100, the system
                #     only returns 100 subscriptions.
                #   @param page_token [::String]
                #     Optional. A page token, received from a previous list subscriptions call.
                #     Provide this parameter to retrieve the subsequent page.
                #
                #     When paginating, the filter value should match the call that provided the
                #     page token. Passing a different value might lead to unexpected results.
                #   @param filter [::String]
                #     Required. A query filter.
                #
                #     You can filter subscriptions by event type (`event_types`)
                #     and target resource (`target_resource`).
                #
                #     You must specify at least one event type in your query. To filter for
                #     multiple event types, use the `OR` operator.
                #
                #     To filter by both event type and target resource, use the `AND` operator
                #     and specify the full resource name, such as
                #     `//chat.googleapis.com/spaces/{space}`.
                #
                #     For example, the following queries are valid:
                #
                #     ```
                #     event_types:"google.workspace.chat.membership.v1.updated" OR
                #       event_types:"google.workspace.chat.message.v1.created"
                #
                #     event_types:"google.workspace.chat.message.v1.created" AND
                #       target_resource="//chat.googleapis.com/spaces/\\{space}"
                #
                #     ( event_types:"google.workspace.chat.membership.v1.updated" OR
                #       event_types:"google.workspace.chat.message.v1.created" ) AND
                #       target_resource="//chat.googleapis.com/spaces/\\{space}"
                #     ```
                #
                #     The server rejects invalid queries with an `INVALID_ARGUMENT`
                #     error.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Apps::Events::Subscriptions::V1beta::Subscription>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Apps::Events::Subscriptions::V1beta::Subscription>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/apps/events/subscriptions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Apps::Events::Subscriptions::V1beta::ListSubscriptionsRequest.new
                #
                #   # Call the list_subscriptions method.
                #   result = client.list_subscriptions request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Apps::Events::Subscriptions::V1beta::Subscription.
                #     p item
                #   end
                #
                def list_subscriptions request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1beta::ListSubscriptionsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_subscriptions.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Apps::Events::Subscriptions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_subscriptions.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_subscriptions.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @subscriptions_service_stub.list_subscriptions request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @subscriptions_service_stub, :list_subscriptions, "subscriptions", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates or renews a Google Workspace subscription. To learn how to use this
                # method, see [Update or renew a Google Workspace
                # subscription](https://developers.google.com/workspace/events/guides/update-subscription).
                #
                # @overload update_subscription(request, options = nil)
                #   Pass arguments to `update_subscription` via a request object, either of type
                #   {::Google::Apps::Events::Subscriptions::V1beta::UpdateSubscriptionRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Apps::Events::Subscriptions::V1beta::UpdateSubscriptionRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_subscription(subscription: nil, update_mask: nil, validate_only: nil)
                #   Pass arguments to `update_subscription` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param subscription [::Google::Apps::Events::Subscriptions::V1beta::Subscription, ::Hash]
                #     Required. The subscription to update.
                #
                #     The subscription's `name` field is used to identify the subscription to
                #     update.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Optional. The field to update. If omitted, updates any fields included in
                #     the request.
                #
                #     You can update one of the following fields in a subscription:
                #
                #     * {::Google::Apps::Events::Subscriptions::V1beta::Subscription#expire_time `expire_time`}: The timestamp when the
                #       subscription expires.
                #     * {::Google::Apps::Events::Subscriptions::V1beta::Subscription#ttl `ttl`}: The
                #     time-to-live (TTL) or duration of the
                #       subscription.
                #     * {::Google::Apps::Events::Subscriptions::V1beta::Subscription#event_types `event_types`}: The list of event types to
                #     receive about the target resource.
                #
                #     To fully replace the subscription (the equivalent of `PUT`), use `*`. Any
                #     omitted fields are updated with empty values.
                #   @param validate_only [::Boolean]
                #     Optional. If set to `true`, validates and previews the request, but doesn't
                #     update the subscription.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/apps/events/subscriptions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Apps::Events::Subscriptions::V1beta::UpdateSubscriptionRequest.new
                #
                #   # Call the update_subscription method.
                #   result = client.update_subscription request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def update_subscription request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1beta::UpdateSubscriptionRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_subscription.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Apps::Events::Subscriptions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_subscription.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_subscription.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @subscriptions_service_stub.update_subscription request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Reactivates a suspended Google Workspace subscription.
                #
                #  This method resets your subscription's `State` field to `ACTIVE`. Before
                #  you use this method, you must fix the error that suspended the
                #  subscription. This method will ignore or reject any subscription that
                #  isn't currently in a suspended state. To learn how to use this method, see
                # [Reactivate a Google Workspace
                #  subscription](https://developers.google.com/workspace/events/guides/reactivate-subscription).
                #
                # @overload reactivate_subscription(request, options = nil)
                #   Pass arguments to `reactivate_subscription` via a request object, either of type
                #   {::Google::Apps::Events::Subscriptions::V1beta::ReactivateSubscriptionRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Apps::Events::Subscriptions::V1beta::ReactivateSubscriptionRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload reactivate_subscription(name: nil)
                #   Pass arguments to `reactivate_subscription` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Resource name of the subscription.
                #
                #     Format: `subscriptions/{subscription}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/apps/events/subscriptions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Apps::Events::Subscriptions::V1beta::ReactivateSubscriptionRequest.new
                #
                #   # Call the reactivate_subscription method.
                #   result = client.reactivate_subscription request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def reactivate_subscription request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1beta::ReactivateSubscriptionRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.reactivate_subscription.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Apps::Events::Subscriptions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.reactivate_subscription.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.reactivate_subscription.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @subscriptions_service_stub.reactivate_subscription request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the SubscriptionsService REST API.
                #
                # This class represents the configuration for SubscriptionsService REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # create_subscription to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_subscription.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Apps::Events::Subscriptions::V1beta::SubscriptionsService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_subscription.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "workspaceevents.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the SubscriptionsService API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `create_subscription`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_subscription
                    ##
                    # RPC-specific configuration for `delete_subscription`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_subscription
                    ##
                    # RPC-specific configuration for `get_subscription`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_subscription
                    ##
                    # RPC-specific configuration for `list_subscriptions`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_subscriptions
                    ##
                    # RPC-specific configuration for `update_subscription`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_subscription
                    ##
                    # RPC-specific configuration for `reactivate_subscription`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :reactivate_subscription

                    # @private
                    def initialize parent_rpcs = nil
                      create_subscription_config = parent_rpcs.create_subscription if parent_rpcs.respond_to? :create_subscription
                      @create_subscription = ::Gapic::Config::Method.new create_subscription_config
                      delete_subscription_config = parent_rpcs.delete_subscription if parent_rpcs.respond_to? :delete_subscription
                      @delete_subscription = ::Gapic::Config::Method.new delete_subscription_config
                      get_subscription_config = parent_rpcs.get_subscription if parent_rpcs.respond_to? :get_subscription
                      @get_subscription = ::Gapic::Config::Method.new get_subscription_config
                      list_subscriptions_config = parent_rpcs.list_subscriptions if parent_rpcs.respond_to? :list_subscriptions
                      @list_subscriptions = ::Gapic::Config::Method.new list_subscriptions_config
                      update_subscription_config = parent_rpcs.update_subscription if parent_rpcs.respond_to? :update_subscription
                      @update_subscription = ::Gapic::Config::Method.new update_subscription_config
                      reactivate_subscription_config = parent_rpcs.reactivate_subscription if parent_rpcs.respond_to? :reactivate_subscription
                      @reactivate_subscription = ::Gapic::Config::Method.new reactivate_subscription_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
