# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/apps/events/subscriptions/v1/subscriptions_service_pb"
require "google/apps/events/subscriptions/v1/subscriptions_service/rest"


class ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_subscription
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    subscription = {}
    validate_only = true

    create_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::ServiceStub.stub :transcode_create_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_subscription_client_stub do
        # Create client
        client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_subscription({ subscription: subscription, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_subscription subscription: subscription, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_subscription ::Google::Apps::Events::Subscriptions::V1::CreateSubscriptionRequest.new(subscription: subscription, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_subscription({ subscription: subscription, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_subscription(::Google::Apps::Events::Subscriptions::V1::CreateSubscriptionRequest.new(subscription: subscription, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_subscription_client_stub.call_count
      end
    end
  end

  def test_delete_subscription
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"

    delete_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::ServiceStub.stub :transcode_delete_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_subscription_client_stub do
        # Create client
        client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_subscription({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_subscription name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_subscription ::Google::Apps::Events::Subscriptions::V1::DeleteSubscriptionRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_subscription({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_subscription(::Google::Apps::Events::Subscriptions::V1::DeleteSubscriptionRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_subscription_client_stub.call_count
      end
    end
  end

  def test_get_subscription
    # Create test objects.
    client_result = ::Google::Apps::Events::Subscriptions::V1::Subscription.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::ServiceStub.stub :transcode_get_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_subscription_client_stub do
        # Create client
        client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_subscription({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_subscription name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_subscription ::Google::Apps::Events::Subscriptions::V1::GetSubscriptionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_subscription({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_subscription(::Google::Apps::Events::Subscriptions::V1::GetSubscriptionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_subscription_client_stub.call_count
      end
    end
  end

  def test_list_subscriptions
    # Create test objects.
    client_result = ::Google::Apps::Events::Subscriptions::V1::ListSubscriptionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_subscriptions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::ServiceStub.stub :transcode_list_subscriptions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subscriptions_client_stub do
        # Create client
        client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subscriptions({ page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subscriptions page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subscriptions ::Google::Apps::Events::Subscriptions::V1::ListSubscriptionsRequest.new(page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subscriptions({ page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subscriptions(::Google::Apps::Events::Subscriptions::V1::ListSubscriptionsRequest.new(page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subscriptions_client_stub.call_count
      end
    end
  end

  def test_update_subscription
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    subscription = {}
    update_mask = {}
    validate_only = true

    update_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::ServiceStub.stub :transcode_update_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_subscription_client_stub do
        # Create client
        client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_subscription({ subscription: subscription, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_subscription subscription: subscription, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_subscription ::Google::Apps::Events::Subscriptions::V1::UpdateSubscriptionRequest.new(subscription: subscription, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_subscription({ subscription: subscription, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_subscription(::Google::Apps::Events::Subscriptions::V1::UpdateSubscriptionRequest.new(subscription: subscription, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_subscription_client_stub.call_count
      end
    end
  end

  def test_reactivate_subscription
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reactivate_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::ServiceStub.stub :transcode_reactivate_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reactivate_subscription_client_stub do
        # Create client
        client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reactivate_subscription({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reactivate_subscription name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reactivate_subscription ::Google::Apps::Events::Subscriptions::V1::ReactivateSubscriptionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reactivate_subscription({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reactivate_subscription(::Google::Apps::Events::Subscriptions::V1::ReactivateSubscriptionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reactivate_subscription_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Rest::Client::Configuration, config
  end
end
