# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Events
      module Subscriptions
        module V1
          # The request message for
          # {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client#create_subscription SubscriptionsService.CreateSubscription}.
          # @!attribute [rw] subscription
          #   @return [::Google::Apps::Events::Subscriptions::V1::Subscription]
          #     Required. The subscription resource to create.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set to `true`, validates and previews the request, but doesn't
          #     create the subscription.
          class CreateSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client#delete_subscription SubscriptionsService.DeleteSubscription}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the subscription to delete.
          #
          #     Format: `subscriptions/{subscription}`
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set to `true`, validates and previews the request, but doesn't
          #     delete the subscription.
          # @!attribute [rw] allow_missing
          #   @return [::Boolean]
          #     Optional. If set to `true` and the subscription isn't found, the request
          #     succeeds but doesn't delete the subscription.
          # @!attribute [rw] etag
          #   @return [::String]
          #     Optional. Etag of the subscription.
          #
          #     If present, it must match with the server's etag. Otherwise, request
          #     fails with the status `ABORTED`.
          class DeleteSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client#get_subscription SubscriptionsService.GetSubscription}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the subscription.
          #
          #     Format: `subscriptions/{subscription}`
          class GetSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client#update_subscription SubscriptionsService.UpdateSubscription}.
          # @!attribute [rw] subscription
          #   @return [::Google::Apps::Events::Subscriptions::V1::Subscription]
          #     Required. The subscription to update.
          #
          #     The subscription's `name` field is used to identify the subscription to
          #     update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. Required. The field to update.
          #
          #     You can update one of the following fields in a subscription:
          #
          #     * {::Google::Apps::Events::Subscriptions::V1::Subscription#expire_time `expire_time`}: The timestamp when the
          #       subscription expires.
          #     * {::Google::Apps::Events::Subscriptions::V1::Subscription#ttl `ttl`}: The
          #     time-to-live (TTL) or duration of the
          #       subscription.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set to `true`, validates and previews the request, but doesn't
          #     update the subscription.
          class UpdateSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client#reactivate_subscription SubscriptionsService.ReactivateSubscription}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the subscription.
          #
          #     Format: `subscriptions/{subscription}`
          class ReactivateSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client#list_subscriptions SubscriptionsService.ListSubscriptions}.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of subscriptions to return. The service might
          #     return fewer than this value.
          #
          #     If unspecified or set to `0`, up to 50 subscriptions are returned.
          #
          #     The maximum value is 100. If you specify a value more than 100, the system
          #     only returns 100 subscriptions.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous list subscriptions call.
          #     Provide this parameter to retrieve the subsequent page.
          #
          #     When paginating, the filter value should match the call that provided the
          #     page token. Passing a different value might lead to unexpected results.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Required. A query filter.
          #
          #     You can filter subscriptions by event type (`event_types`)
          #     and target resource (`target_resource`).
          #
          #     You must specify at least one event type in your query. To filter for
          #     multiple event types, use the `OR` operator.
          #
          #     To filter by both event type and target resource, use the `AND` operator
          #     and specify the full resource name, such as
          #     `//chat.googleapis.com/spaces/{space}`.
          #
          #     For example, the following queries are valid:
          #
          #     ```
          #     event_types:"google.workspace.chat.membership.v1.updated" OR
          #       event_types:"google.workspace.chat.message.v1.created"
          #
          #     event_types:"google.workspace.chat.message.v1.created" AND
          #       target_resource="//chat.googleapis.com/spaces/\\{space}"
          #
          #     ( event_types:"google.workspace.chat.membership.v1.updated" OR
          #       event_types:"google.workspace.chat.message.v1.created" ) AND
          #       target_resource="//chat.googleapis.com/spaces/\\{space}"
          #     ```
          #
          #     The server rejects invalid queries with an `INVALID_ARGUMENT`
          #     error.
          class ListSubscriptionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response message for
          # {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client#list_subscriptions SubscriptionsService.ListSubscriptions}.
          # @!attribute [rw] subscriptions
          #   @return [::Array<::Google::Apps::Events::Subscriptions::V1::Subscription>]
          #     List of subscriptions.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListSubscriptionsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for UpdateSubscription LRO.
          class UpdateSubscriptionMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for CreateSubscription LRO.
          class CreateSubscriptionMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for DeleteSubscription LRO.
          class DeleteSubscriptionMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for ReactivateSubscription LRO.
          class ReactivateSubscriptionMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
