# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Events
      module Subscriptions
        module V1
          # A subscription to receive events about a Google Workspace resource. To learn
          # more about subscriptions, see the [Google Workspace Events API
          # overview](https://developers.google.com/workspace/events).
          # @!attribute [rw] expire_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Non-empty default. The timestamp in UTC when the subscription expires.
          #     Always displayed on output, regardless of what was used on input.
          #
          #     Note: The following fields are mutually exclusive: `expire_time`, `ttl`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] ttl
          #   @return [::Google::Protobuf::Duration]
          #     Input only. The time-to-live (TTL) or duration for the subscription. If
          #     unspecified or set to `0`, uses the maximum possible duration.
          #
          #     Note: The following fields are mutually exclusive: `ttl`, `expire_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. Immutable. Identifier. Resource name of the subscription.
          #
          #     Format: `subscriptions/{subscription}`
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. System-assigned unique identifier for the subscription.
          # @!attribute [rw] target_resource
          #   @return [::String]
          #     Required. Immutable. The Google Workspace resource that's monitored for
          #     events, formatted as the [full resource
          #     name](https://google.aip.dev/122#full-resource-names). To learn about
          #     target resources and the events that they support, see [Supported Google
          #     Workspace
          #     events](https://developers.google.com/workspace/events#supported-events).
          #
          #     A user can only authorize your app to create one subscription for a given
          #     target resource. If your app tries to create another subscription with the
          #     same user credentials, the request returns an `ALREADY_EXISTS` error.
          # @!attribute [rw] event_types
          #   @return [::Array<::String>]
          #     Required. Immutable. Unordered list. Input for creating a subscription.
          #     Otherwise, output only. One or more types of events to receive about the
          #     target resource. Formatted according to the CloudEvents specification.
          #
          #     The supported event types depend on the target resource of your
          #     subscription. For details, see [Supported Google Workspace
          #     events](https://developers.google.com/workspace/events/guides#supported-events).
          #
          #     By default, you also receive events about the [lifecycle of your
          #     subscription](https://developers.google.com/workspace/events/guides/events-lifecycle).
          #     You don't need to specify lifecycle events for this field.
          #
          #     If you specify an event type that doesn't exist for the target resource,
          #     the request returns an HTTP `400 Bad Request` status code.
          # @!attribute [rw] payload_options
          #   @return [::Google::Apps::Events::Subscriptions::V1::PayloadOptions]
          #     Optional. Options about what data to include in the event payload. Only
          #     supported for Google Chat events.
          # @!attribute [rw] notification_endpoint
          #   @return [::Google::Apps::Events::Subscriptions::V1::NotificationEndpoint]
          #     Required. Immutable. The endpoint where the subscription delivers events,
          #     such as a Pub/Sub topic.
          # @!attribute [r] state
          #   @return [::Google::Apps::Events::Subscriptions::V1::Subscription::State]
          #     Output only. The state of the subscription. Determines whether the
          #     subscription can receive events and deliver them to the notification
          #     endpoint.
          # @!attribute [r] suspension_reason
          #   @return [::Google::Apps::Events::Subscriptions::V1::Subscription::ErrorType]
          #     Output only. The error that suspended the subscription.
          #
          #     To reactivate the subscription, resolve the error and call the
          #     {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client#reactivate_subscription `ReactivateSubscription`}
          #     method.
          # @!attribute [r] authority
          #   @return [::String]
          #     Output only. The user who authorized the creation of the
          #     subscription.
          #
          #     Format: `users/{user}`
          #
          #     For Google Workspace users, the `{user}` value is the
          #     [`user.id`](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users#User.FIELDS.ids)
          #     field from the Directory API.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the subscription is created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The last time that the subscription is updated.
          # @!attribute [r] reconciling
          #   @return [::Boolean]
          #     Output only. If `true`, the subscription is in the process of being
          #     updated.
          # @!attribute [rw] etag
          #   @return [::String]
          #     Optional. This checksum is computed by the server based on the value of
          #     other fields, and might be sent on update requests to ensure the client has
          #     an up-to-date value before proceeding.
          class Subscription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible states for the subscription.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # The subscription is active and can receive and deliver events to its
              # notification endpoint.
              ACTIVE = 1

              # The subscription is unable to receive events due to an error.
              # To identify the error, see the
              # {::Google::Apps::Events::Subscriptions::V1::Subscription#suspension_reason `suspension_reason`}
              # field.
              SUSPENDED = 2

              # The subscription is deleted.
              DELETED = 3
            end

            # Possible errors for a subscription.
            module ErrorType
              # Default value. This value is unused.
              ERROR_TYPE_UNSPECIFIED = 0

              # The authorizing user has revoked the grant of one or more OAuth scopes.
              # To learn more about authorization for Google Workspace, see [Configure
              # the OAuth consent
              # screen](https://developers.google.com/workspace/guides/configure-oauth-consent#choose-scopes).
              USER_SCOPE_REVOKED = 1

              # The target resource for the subscription no longer exists.
              RESOURCE_DELETED = 2

              # The user that authorized the creation of the subscription no longer has
              # access to the subscription's target resource.
              USER_AUTHORIZATION_FAILURE = 3

              # The Google Workspace application doesn't have access to deliver
              # events to your subscription's notification endpoint.
              ENDPOINT_PERMISSION_DENIED = 4

              # The subscription's notification endpoint doesn't exist, or the endpoint
              # can't be found in the Google Cloud project where you created the
              # subscription.
              ENDPOINT_NOT_FOUND = 6

              # The subscription's notification endpoint failed to receive events due to
              # insufficient quota or reaching rate limiting.
              ENDPOINT_RESOURCE_EXHAUSTED = 7

              # An unidentified error has occurred.
              OTHER = 5
            end
          end

          # Options about what data to include in the event payload. Only supported for
          # Google Chat events.
          # @!attribute [rw] include_resource
          #   @return [::Boolean]
          #     Optional. Whether the event payload includes data about the resource that
          #     changed. For example, for an event where a Google Chat message was created,
          #     whether the payload contains data about the
          #     [`Message`](https://developers.google.com/chat/api/reference/rest/v1/spaces.messages)
          #     resource. If false, the event payload only includes the name of the changed
          #     resource.
          # @!attribute [rw] field_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. If `include_resource` is set to `true`, the list of fields to
          #     include in the event payload. Separate fields with a comma. For example, to
          #     include a Google Chat message's sender and create time, enter
          #     `message.sender,message.createTime`. If omitted, the payload includes all
          #     fields for the resource.
          #
          #     If you specify a field that doesn't exist for the resource, the system
          #     ignores the field.
          class PayloadOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The endpoint where the subscription delivers events.
          # @!attribute [rw] pubsub_topic
          #   @return [::String]
          #     Immutable. The Cloud Pub/Sub topic that receives events for the
          #     subscription.
          #
          #     Format: `projects/{project}/topics/{topic}`
          #
          #
          #     You must create the topic in the same Google Cloud project where
          #     you create this subscription.
          #
          #     When the topic receives events, the events are encoded as Cloud Pub/Sub
          #     messages. For details, see the [Google Cloud Pub/Sub Protocol Binding for
          #     CloudEvents](https://github.com/googleapis/google-cloudevents/blob/main/docs/spec/pubsub.md).
          class NotificationEndpoint
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
