# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Events
      module Subscriptions
        module V1
          module SubscriptionsService
            # Path helper methods for the SubscriptionsService API.
            module Paths
              ##
              # Create a fully-qualified Subscription resource string.
              #
              # The resource will be in the following format:
              #
              # `subscriptions/{subscription}`
              #
              # @param subscription [String]
              #
              # @return [::String]
              def subscription_path subscription:
                "subscriptions/#{subscription}"
              end

              ##
              # Create a fully-qualified Topic resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/topics/{topic}`
              #
              # @param project [String]
              # @param topic [String]
              #
              # @return [::String]
              def topic_path project:, topic:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/topics/#{topic}"
              end

              ##
              # Create a fully-qualified User resource string.
              #
              # The resource will be in the following format:
              #
              # `users/{user}`
              #
              # @param user [String]
              #
              # @return [::String]
              def user_path user:
                "users/#{user}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
