# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/apps/events/subscriptions/v1/subscriptions_service_pb"

module Google
  module Apps
    module Events
      module Subscriptions
        module V1
          module SubscriptionsService
            ##
            # Client for the SubscriptionsService service.
            #
            # A service that manages subscriptions to Google Workspace events.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "workspaceevents.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :subscriptions_service_stub

              ##
              # Configure the SubscriptionsService Client class.
              #
              # See {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all SubscriptionsService clients
              #   ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Apps", "Events", "Subscriptions", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_subscription.timeout = 60.0

                  default_config.rpcs.delete_subscription.timeout = 60.0

                  default_config.rpcs.get_subscription.timeout = 60.0
                  default_config.rpcs.get_subscription.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_subscriptions.timeout = 60.0
                  default_config.rpcs.list_subscriptions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_subscription.timeout = 60.0

                  default_config.rpcs.reactivate_subscription.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the SubscriptionsService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @subscriptions_service_stub.universe_domain
              end

              ##
              # Create a new SubscriptionsService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the SubscriptionsService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/apps/events/subscriptions/v1/subscriptions_service_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @subscriptions_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @subscriptions_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @subscriptions_service_stub.logger
              end

              # Service calls

              ##
              # Creates a Google Workspace subscription. To learn how to use this
              # method, see [Create a Google Workspace
              # subscription](https://developers.google.com/workspace/events/guides/create-subscription).
              #
              # @overload create_subscription(request, options = nil)
              #   Pass arguments to `create_subscription` via a request object, either of type
              #   {::Google::Apps::Events::Subscriptions::V1::CreateSubscriptionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Apps::Events::Subscriptions::V1::CreateSubscriptionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_subscription(subscription: nil, validate_only: nil)
              #   Pass arguments to `create_subscription` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param subscription [::Google::Apps::Events::Subscriptions::V1::Subscription, ::Hash]
              #     Required. The subscription resource to create.
              #   @param validate_only [::Boolean]
              #     Optional. If set to `true`, validates and previews the request, but doesn't
              #     create the subscription.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/apps/events/subscriptions/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Apps::Events::Subscriptions::V1::CreateSubscriptionRequest.new
              #
              #   # Call the create_subscription method.
              #   result = client.create_subscription request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_subscription request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1::CreateSubscriptionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_subscription.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Apps::Events::Subscriptions::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_subscription.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_subscription.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @subscriptions_service_stub.call_rpc :create_subscription, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Google Workspace subscription.
              # To learn how to use this method, see [Delete a Google Workspace
              # subscription](https://developers.google.com/workspace/events/guides/delete-subscription).
              #
              # @overload delete_subscription(request, options = nil)
              #   Pass arguments to `delete_subscription` via a request object, either of type
              #   {::Google::Apps::Events::Subscriptions::V1::DeleteSubscriptionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Apps::Events::Subscriptions::V1::DeleteSubscriptionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_subscription(name: nil, validate_only: nil, allow_missing: nil, etag: nil)
              #   Pass arguments to `delete_subscription` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the subscription to delete.
              #
              #     Format: `subscriptions/{subscription}`
              #   @param validate_only [::Boolean]
              #     Optional. If set to `true`, validates and previews the request, but doesn't
              #     delete the subscription.
              #   @param allow_missing [::Boolean]
              #     Optional. If set to `true` and the subscription isn't found, the request
              #     succeeds but doesn't delete the subscription.
              #   @param etag [::String]
              #     Optional. Etag of the subscription.
              #
              #     If present, it must match with the server's etag. Otherwise, request
              #     fails with the status `ABORTED`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/apps/events/subscriptions/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Apps::Events::Subscriptions::V1::DeleteSubscriptionRequest.new
              #
              #   # Call the delete_subscription method.
              #   result = client.delete_subscription request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_subscription request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1::DeleteSubscriptionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_subscription.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Apps::Events::Subscriptions::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_subscription.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_subscription.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @subscriptions_service_stub.call_rpc :delete_subscription, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details about a Google Workspace subscription. To learn how to use
              # this method, see [Get details about a Google Workspace
              # subscription](https://developers.google.com/workspace/events/guides/get-subscription).
              #
              # @overload get_subscription(request, options = nil)
              #   Pass arguments to `get_subscription` via a request object, either of type
              #   {::Google::Apps::Events::Subscriptions::V1::GetSubscriptionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Apps::Events::Subscriptions::V1::GetSubscriptionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_subscription(name: nil)
              #   Pass arguments to `get_subscription` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the subscription.
              #
              #     Format: `subscriptions/{subscription}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Apps::Events::Subscriptions::V1::Subscription]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Apps::Events::Subscriptions::V1::Subscription]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/apps/events/subscriptions/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Apps::Events::Subscriptions::V1::GetSubscriptionRequest.new
              #
              #   # Call the get_subscription method.
              #   result = client.get_subscription request
              #
              #   # The returned object is of type Google::Apps::Events::Subscriptions::V1::Subscription.
              #   p result
              #
              def get_subscription request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1::GetSubscriptionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_subscription.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Apps::Events::Subscriptions::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_subscription.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_subscription.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @subscriptions_service_stub.call_rpc :get_subscription, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Google Workspace subscriptions. To learn how to use this method, see
              # [List Google Workspace
              # subscriptions](https://developers.google.com/workspace/events/guides/list-subscriptions).
              #
              # @overload list_subscriptions(request, options = nil)
              #   Pass arguments to `list_subscriptions` via a request object, either of type
              #   {::Google::Apps::Events::Subscriptions::V1::ListSubscriptionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Apps::Events::Subscriptions::V1::ListSubscriptionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_subscriptions(page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_subscriptions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param page_size [::Integer]
              #     Optional. The maximum number of subscriptions to return. The service might
              #     return fewer than this value.
              #
              #     If unspecified or set to `0`, up to 50 subscriptions are returned.
              #
              #     The maximum value is 100. If you specify a value more than 100, the system
              #     only returns 100 subscriptions.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous list subscriptions call.
              #     Provide this parameter to retrieve the subsequent page.
              #
              #     When paginating, the filter value should match the call that provided the
              #     page token. Passing a different value might lead to unexpected results.
              #   @param filter [::String]
              #     Required. A query filter.
              #
              #     You can filter subscriptions by event type (`event_types`)
              #     and target resource (`target_resource`).
              #
              #     You must specify at least one event type in your query. To filter for
              #     multiple event types, use the `OR` operator.
              #
              #     To filter by both event type and target resource, use the `AND` operator
              #     and specify the full resource name, such as
              #     `//chat.googleapis.com/spaces/{space}`.
              #
              #     For example, the following queries are valid:
              #
              #     ```
              #     event_types:"google.workspace.chat.membership.v1.updated" OR
              #       event_types:"google.workspace.chat.message.v1.created"
              #
              #     event_types:"google.workspace.chat.message.v1.created" AND
              #       target_resource="//chat.googleapis.com/spaces/\\{space}"
              #
              #     ( event_types:"google.workspace.chat.membership.v1.updated" OR
              #       event_types:"google.workspace.chat.message.v1.created" ) AND
              #       target_resource="//chat.googleapis.com/spaces/\\{space}"
              #     ```
              #
              #     The server rejects invalid queries with an `INVALID_ARGUMENT`
              #     error.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Events::Subscriptions::V1::Subscription>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Apps::Events::Subscriptions::V1::Subscription>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/apps/events/subscriptions/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Apps::Events::Subscriptions::V1::ListSubscriptionsRequest.new
              #
              #   # Call the list_subscriptions method.
              #   result = client.list_subscriptions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Apps::Events::Subscriptions::V1::Subscription.
              #     p item
              #   end
              #
              def list_subscriptions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1::ListSubscriptionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_subscriptions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Apps::Events::Subscriptions::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_subscriptions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_subscriptions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @subscriptions_service_stub.call_rpc :list_subscriptions, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @subscriptions_service_stub, :list_subscriptions, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates or renews a Google Workspace subscription. To learn how to use this
              # method, see [Update or renew a Google Workspace
              # subscription](https://developers.google.com/workspace/events/guides/update-subscription).
              #
              # @overload update_subscription(request, options = nil)
              #   Pass arguments to `update_subscription` via a request object, either of type
              #   {::Google::Apps::Events::Subscriptions::V1::UpdateSubscriptionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Apps::Events::Subscriptions::V1::UpdateSubscriptionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_subscription(subscription: nil, update_mask: nil, validate_only: nil)
              #   Pass arguments to `update_subscription` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param subscription [::Google::Apps::Events::Subscriptions::V1::Subscription, ::Hash]
              #     Required. The subscription to update.
              #
              #     The subscription's `name` field is used to identify the subscription to
              #     update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Required. The field to update.
              #
              #     You can update one of the following fields in a subscription:
              #
              #     * {::Google::Apps::Events::Subscriptions::V1::Subscription#expire_time `expire_time`}: The timestamp when the
              #       subscription expires.
              #     * {::Google::Apps::Events::Subscriptions::V1::Subscription#ttl `ttl`}: The
              #     time-to-live (TTL) or duration of the
              #       subscription.
              #   @param validate_only [::Boolean]
              #     Optional. If set to `true`, validates and previews the request, but doesn't
              #     update the subscription.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/apps/events/subscriptions/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Apps::Events::Subscriptions::V1::UpdateSubscriptionRequest.new
              #
              #   # Call the update_subscription method.
              #   result = client.update_subscription request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_subscription request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1::UpdateSubscriptionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_subscription.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Apps::Events::Subscriptions::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.subscription&.name
                  header_params["subscription.name"] = request.subscription.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_subscription.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_subscription.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @subscriptions_service_stub.call_rpc :update_subscription, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reactivates a suspended Google Workspace subscription.
              #
              # This method resets your subscription's `State` field to `ACTIVE`. Before
              # you use this method, you must fix the error that suspended the
              # subscription. To learn how to use this method, see [Reactivate a Google
              # Workspace
              # subscription](https://developers.google.com/workspace/events/guides/reactivate-subscription).
              #
              # @overload reactivate_subscription(request, options = nil)
              #   Pass arguments to `reactivate_subscription` via a request object, either of type
              #   {::Google::Apps::Events::Subscriptions::V1::ReactivateSubscriptionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Apps::Events::Subscriptions::V1::ReactivateSubscriptionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload reactivate_subscription(name: nil)
              #   Pass arguments to `reactivate_subscription` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the subscription.
              #
              #     Format: `subscriptions/{subscription}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/apps/events/subscriptions/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Apps::Events::Subscriptions::V1::ReactivateSubscriptionRequest.new
              #
              #   # Call the reactivate_subscription method.
              #   result = client.reactivate_subscription request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def reactivate_subscription request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Events::Subscriptions::V1::ReactivateSubscriptionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.reactivate_subscription.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Apps::Events::Subscriptions::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.reactivate_subscription.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.reactivate_subscription.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @subscriptions_service_stub.call_rpc :reactivate_subscription, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the SubscriptionsService API.
              #
              # This class represents the configuration for SubscriptionsService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_subscription to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_subscription.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_subscription.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Apps::Events::Subscriptions::V1::SubscriptionsService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "workspaceevents.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the SubscriptionsService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_subscription`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_subscription
                  ##
                  # RPC-specific configuration for `delete_subscription`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_subscription
                  ##
                  # RPC-specific configuration for `get_subscription`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_subscription
                  ##
                  # RPC-specific configuration for `list_subscriptions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_subscriptions
                  ##
                  # RPC-specific configuration for `update_subscription`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_subscription
                  ##
                  # RPC-specific configuration for `reactivate_subscription`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reactivate_subscription

                  # @private
                  def initialize parent_rpcs = nil
                    create_subscription_config = parent_rpcs.create_subscription if parent_rpcs.respond_to? :create_subscription
                    @create_subscription = ::Gapic::Config::Method.new create_subscription_config
                    delete_subscription_config = parent_rpcs.delete_subscription if parent_rpcs.respond_to? :delete_subscription
                    @delete_subscription = ::Gapic::Config::Method.new delete_subscription_config
                    get_subscription_config = parent_rpcs.get_subscription if parent_rpcs.respond_to? :get_subscription
                    @get_subscription = ::Gapic::Config::Method.new get_subscription_config
                    list_subscriptions_config = parent_rpcs.list_subscriptions if parent_rpcs.respond_to? :list_subscriptions
                    @list_subscriptions = ::Gapic::Config::Method.new list_subscriptions_config
                    update_subscription_config = parent_rpcs.update_subscription if parent_rpcs.respond_to? :update_subscription
                    @update_subscription = ::Gapic::Config::Method.new update_subscription_config
                    reactivate_subscription_config = parent_rpcs.reactivate_subscription if parent_rpcs.respond_to? :reactivate_subscription
                    @reactivate_subscription = ::Gapic::Config::Method.new reactivate_subscription_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
