# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/chat/v1/chat_service_pb"
require "google/apps/chat/v1/chat_service"

class ::Google::Apps::Chat::V1::ChatService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_message
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Message.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    message = {}
    thread_key = "hello world"
    request_id = "hello world"
    message_reply_option = :MESSAGE_REPLY_OPTION_UNSPECIFIED
    message_id = "hello world"

    create_message_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_message, name
      assert_kind_of ::Google::Apps::Chat::V1::CreateMessageRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::Message), request["message"]
      assert_equal "hello world", request["thread_key"]
      assert_equal "hello world", request["request_id"]
      assert_equal :MESSAGE_REPLY_OPTION_UNSPECIFIED, request["message_reply_option"]
      assert_equal "hello world", request["message_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_message_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_message({ parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_message parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_message ::Google::Apps::Chat::V1::CreateMessageRequest.new(parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_message({ parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_message(::Google::Apps::Chat::V1::CreateMessageRequest.new(parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_message_client_stub.call_rpc_count
    end
  end

  def test_list_messages
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::ListMessagesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    show_deleted = true

    list_messages_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_messages, name
      assert_kind_of ::Google::Apps::Chat::V1::ListMessagesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal true, request["show_deleted"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_messages_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_messages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_messages parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_messages ::Google::Apps::Chat::V1::ListMessagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_messages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_messages(::Google::Apps::Chat::V1::ListMessagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_messages_client_stub.call_rpc_count
    end
  end

  def test_list_memberships
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::ListMembershipsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    show_groups = true
    show_invited = true
    use_admin_access = true

    list_memberships_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_memberships, name
      assert_kind_of ::Google::Apps::Chat::V1::ListMembershipsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal true, request["show_groups"]
      assert_equal true, request["show_invited"]
      assert_equal true, request["use_admin_access"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_memberships_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_memberships({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_memberships parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_memberships ::Google::Apps::Chat::V1::ListMembershipsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_memberships({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_memberships(::Google::Apps::Chat::V1::ListMembershipsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_memberships_client_stub.call_rpc_count
    end
  end

  def test_get_membership
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Membership.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    use_admin_access = true

    get_membership_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_membership, name
      assert_kind_of ::Google::Apps::Chat::V1::GetMembershipRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["use_admin_access"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_membership_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_membership({ name: name, use_admin_access: use_admin_access }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_membership name: name, use_admin_access: use_admin_access do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_membership ::Google::Apps::Chat::V1::GetMembershipRequest.new(name: name, use_admin_access: use_admin_access) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_membership({ name: name, use_admin_access: use_admin_access }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_membership(::Google::Apps::Chat::V1::GetMembershipRequest.new(name: name, use_admin_access: use_admin_access), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_membership_client_stub.call_rpc_count
    end
  end

  def test_get_message
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Message.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_message_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_message, name
      assert_kind_of ::Google::Apps::Chat::V1::GetMessageRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_message_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_message({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_message name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_message ::Google::Apps::Chat::V1::GetMessageRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_message({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_message(::Google::Apps::Chat::V1::GetMessageRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_message_client_stub.call_rpc_count
    end
  end

  def test_update_message
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Message.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    message = {}
    update_mask = {}
    allow_missing = true

    update_message_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_message, name
      assert_kind_of ::Google::Apps::Chat::V1::UpdateMessageRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::Message), request["message"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_message_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_message({ message: message, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_message message: message, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_message ::Google::Apps::Chat::V1::UpdateMessageRequest.new(message: message, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_message({ message: message, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_message(::Google::Apps::Chat::V1::UpdateMessageRequest.new(message: message, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_message_client_stub.call_rpc_count
    end
  end

  def test_delete_message
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_message_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_message, name
      assert_kind_of ::Google::Apps::Chat::V1::DeleteMessageRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_message_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_message({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_message name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_message ::Google::Apps::Chat::V1::DeleteMessageRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_message({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_message(::Google::Apps::Chat::V1::DeleteMessageRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_message_client_stub.call_rpc_count
    end
  end

  def test_get_attachment
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Attachment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attachment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_attachment, name
      assert_kind_of ::Google::Apps::Chat::V1::GetAttachmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_attachment_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_attachment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_attachment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_attachment ::Google::Apps::Chat::V1::GetAttachmentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_attachment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_attachment(::Google::Apps::Chat::V1::GetAttachmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_attachment_client_stub.call_rpc_count
    end
  end

  def test_upload_attachment
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::UploadAttachmentResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filename = "hello world"

    upload_attachment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :upload_attachment, name
      assert_kind_of ::Google::Apps::Chat::V1::UploadAttachmentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filename"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, upload_attachment_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.upload_attachment({ parent: parent, filename: filename }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.upload_attachment parent: parent, filename: filename do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.upload_attachment ::Google::Apps::Chat::V1::UploadAttachmentRequest.new(parent: parent, filename: filename) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.upload_attachment({ parent: parent, filename: filename }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.upload_attachment(::Google::Apps::Chat::V1::UploadAttachmentRequest.new(parent: parent, filename: filename), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, upload_attachment_client_stub.call_rpc_count
    end
  end

  def test_list_spaces
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::ListSpacesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_spaces_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_spaces, name
      assert_kind_of ::Google::Apps::Chat::V1::ListSpacesRequest, request
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_spaces_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_spaces({ page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_spaces page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_spaces ::Google::Apps::Chat::V1::ListSpacesRequest.new(page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_spaces({ page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_spaces(::Google::Apps::Chat::V1::ListSpacesRequest.new(page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_spaces_client_stub.call_rpc_count
    end
  end

  def test_search_spaces
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::SearchSpacesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    use_admin_access = true
    page_size = 42
    page_token = "hello world"
    query = "hello world"
    order_by = "hello world"

    search_spaces_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_spaces, name
      assert_kind_of ::Google::Apps::Chat::V1::SearchSpacesRequest, request
      assert_equal true, request["use_admin_access"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["query"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_spaces_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_spaces({ use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_spaces use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_spaces ::Google::Apps::Chat::V1::SearchSpacesRequest.new(use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_spaces({ use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_spaces(::Google::Apps::Chat::V1::SearchSpacesRequest.new(use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_spaces_client_stub.call_rpc_count
    end
  end

  def test_get_space
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Space.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    use_admin_access = true

    get_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_space, name
      assert_kind_of ::Google::Apps::Chat::V1::GetSpaceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["use_admin_access"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_space_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_space({ name: name, use_admin_access: use_admin_access }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_space name: name, use_admin_access: use_admin_access do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_space ::Google::Apps::Chat::V1::GetSpaceRequest.new(name: name, use_admin_access: use_admin_access) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_space({ name: name, use_admin_access: use_admin_access }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_space(::Google::Apps::Chat::V1::GetSpaceRequest.new(name: name, use_admin_access: use_admin_access), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_space_client_stub.call_rpc_count
    end
  end

  def test_create_space
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Space.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    space = {}
    request_id = "hello world"

    create_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_space, name
      assert_kind_of ::Google::Apps::Chat::V1::CreateSpaceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::Space), request["space"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_space_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_space({ space: space, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_space space: space, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_space ::Google::Apps::Chat::V1::CreateSpaceRequest.new(space: space, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_space({ space: space, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_space(::Google::Apps::Chat::V1::CreateSpaceRequest.new(space: space, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_space_client_stub.call_rpc_count
    end
  end

  def test_set_up_space
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Space.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    space = {}
    request_id = "hello world"
    memberships = [{}]

    set_up_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_up_space, name
      assert_kind_of ::Google::Apps::Chat::V1::SetUpSpaceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::Space), request["space"]
      assert_equal "hello world", request["request_id"]
      assert_kind_of ::Google::Apps::Chat::V1::Membership, request["memberships"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_up_space_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_up_space({ space: space, request_id: request_id, memberships: memberships }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_up_space space: space, request_id: request_id, memberships: memberships do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_up_space ::Google::Apps::Chat::V1::SetUpSpaceRequest.new(space: space, request_id: request_id, memberships: memberships) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_up_space({ space: space, request_id: request_id, memberships: memberships }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_up_space(::Google::Apps::Chat::V1::SetUpSpaceRequest.new(space: space, request_id: request_id, memberships: memberships), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_up_space_client_stub.call_rpc_count
    end
  end

  def test_update_space
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Space.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    space = {}
    update_mask = {}
    use_admin_access = true

    update_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_space, name
      assert_kind_of ::Google::Apps::Chat::V1::UpdateSpaceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::Space), request["space"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["use_admin_access"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_space_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_space({ space: space, update_mask: update_mask, use_admin_access: use_admin_access }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_space space: space, update_mask: update_mask, use_admin_access: use_admin_access do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_space ::Google::Apps::Chat::V1::UpdateSpaceRequest.new(space: space, update_mask: update_mask, use_admin_access: use_admin_access) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_space({ space: space, update_mask: update_mask, use_admin_access: use_admin_access }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_space(::Google::Apps::Chat::V1::UpdateSpaceRequest.new(space: space, update_mask: update_mask, use_admin_access: use_admin_access), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_space_client_stub.call_rpc_count
    end
  end

  def test_delete_space
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    use_admin_access = true

    delete_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_space, name
      assert_kind_of ::Google::Apps::Chat::V1::DeleteSpaceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["use_admin_access"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_space_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_space({ name: name, use_admin_access: use_admin_access }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_space name: name, use_admin_access: use_admin_access do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_space ::Google::Apps::Chat::V1::DeleteSpaceRequest.new(name: name, use_admin_access: use_admin_access) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_space({ name: name, use_admin_access: use_admin_access }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_space(::Google::Apps::Chat::V1::DeleteSpaceRequest.new(name: name, use_admin_access: use_admin_access), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_space_client_stub.call_rpc_count
    end
  end

  def test_complete_import_space
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::CompleteImportSpaceResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    complete_import_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :complete_import_space, name
      assert_kind_of ::Google::Apps::Chat::V1::CompleteImportSpaceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, complete_import_space_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.complete_import_space({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.complete_import_space name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.complete_import_space ::Google::Apps::Chat::V1::CompleteImportSpaceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.complete_import_space({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.complete_import_space(::Google::Apps::Chat::V1::CompleteImportSpaceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, complete_import_space_client_stub.call_rpc_count
    end
  end

  def test_find_direct_message
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Space.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    find_direct_message_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :find_direct_message, name
      assert_kind_of ::Google::Apps::Chat::V1::FindDirectMessageRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, find_direct_message_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.find_direct_message({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.find_direct_message name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.find_direct_message ::Google::Apps::Chat::V1::FindDirectMessageRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.find_direct_message({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.find_direct_message(::Google::Apps::Chat::V1::FindDirectMessageRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, find_direct_message_client_stub.call_rpc_count
    end
  end

  def test_create_membership
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Membership.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    membership = {}
    use_admin_access = true

    create_membership_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_membership, name
      assert_kind_of ::Google::Apps::Chat::V1::CreateMembershipRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::Membership), request["membership"]
      assert_equal true, request["use_admin_access"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_membership_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_membership({ parent: parent, membership: membership, use_admin_access: use_admin_access }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_membership parent: parent, membership: membership, use_admin_access: use_admin_access do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_membership ::Google::Apps::Chat::V1::CreateMembershipRequest.new(parent: parent, membership: membership, use_admin_access: use_admin_access) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_membership({ parent: parent, membership: membership, use_admin_access: use_admin_access }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_membership(::Google::Apps::Chat::V1::CreateMembershipRequest.new(parent: parent, membership: membership, use_admin_access: use_admin_access), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_membership_client_stub.call_rpc_count
    end
  end

  def test_update_membership
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Membership.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    membership = {}
    update_mask = {}
    use_admin_access = true

    update_membership_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_membership, name
      assert_kind_of ::Google::Apps::Chat::V1::UpdateMembershipRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::Membership), request["membership"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["use_admin_access"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_membership_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_membership({ membership: membership, update_mask: update_mask, use_admin_access: use_admin_access }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_membership membership: membership, update_mask: update_mask, use_admin_access: use_admin_access do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_membership ::Google::Apps::Chat::V1::UpdateMembershipRequest.new(membership: membership, update_mask: update_mask, use_admin_access: use_admin_access) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_membership({ membership: membership, update_mask: update_mask, use_admin_access: use_admin_access }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_membership(::Google::Apps::Chat::V1::UpdateMembershipRequest.new(membership: membership, update_mask: update_mask, use_admin_access: use_admin_access), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_membership_client_stub.call_rpc_count
    end
  end

  def test_delete_membership
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Membership.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    use_admin_access = true

    delete_membership_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_membership, name
      assert_kind_of ::Google::Apps::Chat::V1::DeleteMembershipRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["use_admin_access"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_membership_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_membership({ name: name, use_admin_access: use_admin_access }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_membership name: name, use_admin_access: use_admin_access do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_membership ::Google::Apps::Chat::V1::DeleteMembershipRequest.new(name: name, use_admin_access: use_admin_access) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_membership({ name: name, use_admin_access: use_admin_access }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_membership(::Google::Apps::Chat::V1::DeleteMembershipRequest.new(name: name, use_admin_access: use_admin_access), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_membership_client_stub.call_rpc_count
    end
  end

  def test_create_reaction
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::Reaction.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reaction = {}

    create_reaction_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_reaction, name
      assert_kind_of ::Google::Apps::Chat::V1::CreateReactionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::Reaction), request["reaction"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_reaction_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_reaction({ parent: parent, reaction: reaction }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_reaction parent: parent, reaction: reaction do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_reaction ::Google::Apps::Chat::V1::CreateReactionRequest.new(parent: parent, reaction: reaction) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_reaction({ parent: parent, reaction: reaction }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_reaction(::Google::Apps::Chat::V1::CreateReactionRequest.new(parent: parent, reaction: reaction), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_reaction_client_stub.call_rpc_count
    end
  end

  def test_list_reactions
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::ListReactionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_reactions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_reactions, name
      assert_kind_of ::Google::Apps::Chat::V1::ListReactionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_reactions_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_reactions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_reactions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_reactions ::Google::Apps::Chat::V1::ListReactionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_reactions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_reactions(::Google::Apps::Chat::V1::ListReactionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_reactions_client_stub.call_rpc_count
    end
  end

  def test_delete_reaction
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reaction_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_reaction, name
      assert_kind_of ::Google::Apps::Chat::V1::DeleteReactionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_reaction_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_reaction({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_reaction name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_reaction ::Google::Apps::Chat::V1::DeleteReactionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_reaction({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_reaction(::Google::Apps::Chat::V1::DeleteReactionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_reaction_client_stub.call_rpc_count
    end
  end

  def test_create_custom_emoji
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::CustomEmoji.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    custom_emoji = {}

    create_custom_emoji_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_custom_emoji, name
      assert_kind_of ::Google::Apps::Chat::V1::CreateCustomEmojiRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::CustomEmoji), request["custom_emoji"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_custom_emoji_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_custom_emoji({ custom_emoji: custom_emoji }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_custom_emoji custom_emoji: custom_emoji do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_custom_emoji ::Google::Apps::Chat::V1::CreateCustomEmojiRequest.new(custom_emoji: custom_emoji) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_custom_emoji({ custom_emoji: custom_emoji }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_custom_emoji(::Google::Apps::Chat::V1::CreateCustomEmojiRequest.new(custom_emoji: custom_emoji), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_custom_emoji_client_stub.call_rpc_count
    end
  end

  def test_get_custom_emoji
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::CustomEmoji.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_emoji_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_custom_emoji, name
      assert_kind_of ::Google::Apps::Chat::V1::GetCustomEmojiRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_custom_emoji_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_custom_emoji({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_custom_emoji name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_custom_emoji ::Google::Apps::Chat::V1::GetCustomEmojiRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_custom_emoji({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_custom_emoji(::Google::Apps::Chat::V1::GetCustomEmojiRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_custom_emoji_client_stub.call_rpc_count
    end
  end

  def test_list_custom_emojis
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::ListCustomEmojisResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_custom_emojis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_custom_emojis, name
      assert_kind_of ::Google::Apps::Chat::V1::ListCustomEmojisRequest, request
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_custom_emojis_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_custom_emojis({ page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_custom_emojis page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_custom_emojis ::Google::Apps::Chat::V1::ListCustomEmojisRequest.new(page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_custom_emojis({ page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_custom_emojis(::Google::Apps::Chat::V1::ListCustomEmojisRequest.new(page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_custom_emojis_client_stub.call_rpc_count
    end
  end

  def test_delete_custom_emoji
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_custom_emoji_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_custom_emoji, name
      assert_kind_of ::Google::Apps::Chat::V1::DeleteCustomEmojiRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_custom_emoji_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_custom_emoji({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_custom_emoji name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_custom_emoji ::Google::Apps::Chat::V1::DeleteCustomEmojiRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_custom_emoji({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_custom_emoji(::Google::Apps::Chat::V1::DeleteCustomEmojiRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_custom_emoji_client_stub.call_rpc_count
    end
  end

  def test_get_space_read_state
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::SpaceReadState.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_space_read_state_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_space_read_state, name
      assert_kind_of ::Google::Apps::Chat::V1::GetSpaceReadStateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_space_read_state_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_space_read_state({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_space_read_state name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_space_read_state ::Google::Apps::Chat::V1::GetSpaceReadStateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_space_read_state({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_space_read_state(::Google::Apps::Chat::V1::GetSpaceReadStateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_space_read_state_client_stub.call_rpc_count
    end
  end

  def test_update_space_read_state
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::SpaceReadState.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    space_read_state = {}
    update_mask = {}

    update_space_read_state_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_space_read_state, name
      assert_kind_of ::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::SpaceReadState), request["space_read_state"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_space_read_state_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_space_read_state({ space_read_state: space_read_state, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_space_read_state space_read_state: space_read_state, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_space_read_state ::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest.new(space_read_state: space_read_state, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_space_read_state({ space_read_state: space_read_state, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_space_read_state(::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest.new(space_read_state: space_read_state, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_space_read_state_client_stub.call_rpc_count
    end
  end

  def test_get_thread_read_state
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::ThreadReadState.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_thread_read_state_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_thread_read_state, name
      assert_kind_of ::Google::Apps::Chat::V1::GetThreadReadStateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_thread_read_state_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_thread_read_state({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_thread_read_state name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_thread_read_state ::Google::Apps::Chat::V1::GetThreadReadStateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_thread_read_state({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_thread_read_state(::Google::Apps::Chat::V1::GetThreadReadStateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_thread_read_state_client_stub.call_rpc_count
    end
  end

  def test_get_space_event
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::SpaceEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_space_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_space_event, name
      assert_kind_of ::Google::Apps::Chat::V1::GetSpaceEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_space_event_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_space_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_space_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_space_event ::Google::Apps::Chat::V1::GetSpaceEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_space_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_space_event(::Google::Apps::Chat::V1::GetSpaceEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_space_event_client_stub.call_rpc_count
    end
  end

  def test_list_space_events
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::ListSpaceEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_space_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_space_events, name
      assert_kind_of ::Google::Apps::Chat::V1::ListSpaceEventsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_space_events_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_space_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_space_events parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_space_events ::Google::Apps::Chat::V1::ListSpaceEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_space_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_space_events(::Google::Apps::Chat::V1::ListSpaceEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_space_events_client_stub.call_rpc_count
    end
  end

  def test_get_space_notification_setting
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::SpaceNotificationSetting.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_space_notification_setting_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_space_notification_setting, name
      assert_kind_of ::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_space_notification_setting_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_space_notification_setting({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_space_notification_setting name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_space_notification_setting ::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_space_notification_setting({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_space_notification_setting(::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_space_notification_setting_client_stub.call_rpc_count
    end
  end

  def test_update_space_notification_setting
    # Create GRPC objects.
    grpc_response = ::Google::Apps::Chat::V1::SpaceNotificationSetting.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    space_notification_setting = {}
    update_mask = {}

    update_space_notification_setting_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_space_notification_setting, name
      assert_kind_of ::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Apps::Chat::V1::SpaceNotificationSetting), request["space_notification_setting"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_space_notification_setting_client_stub do
      # Create client
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_space_notification_setting({ space_notification_setting: space_notification_setting, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_space_notification_setting space_notification_setting: space_notification_setting, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_space_notification_setting ::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest.new(space_notification_setting: space_notification_setting, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_space_notification_setting({ space_notification_setting: space_notification_setting, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_space_notification_setting(::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest.new(space_notification_setting: space_notification_setting, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_space_notification_setting_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Apps::Chat::V1::ChatService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Apps::Chat::V1::ChatService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
