# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/chat/v1/chat_service_pb"
require "google/apps/chat/v1/chat_service/rest"


class ::Google::Apps::Chat::V1::ChatService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_message
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Message.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    message = {}
    thread_key = "hello world"
    request_id = "hello world"
    message_reply_option = :MESSAGE_REPLY_OPTION_UNSPECIFIED
    message_id = "hello world"

    create_message_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_create_message_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_message_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_message({ parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_message parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_message ::Google::Apps::Chat::V1::CreateMessageRequest.new(parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_message({ parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_message(::Google::Apps::Chat::V1::CreateMessageRequest.new(parent: parent, message: message, thread_key: thread_key, request_id: request_id, message_reply_option: message_reply_option, message_id: message_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_message_client_stub.call_count
      end
    end
  end

  def test_list_messages
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::ListMessagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    show_deleted = true

    list_messages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_list_messages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_messages_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_messages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_messages parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_messages ::Google::Apps::Chat::V1::ListMessagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_messages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_messages(::Google::Apps::Chat::V1::ListMessagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_messages_client_stub.call_count
      end
    end
  end

  def test_list_memberships
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::ListMembershipsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    show_groups = true
    show_invited = true
    use_admin_access = true

    list_memberships_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_list_memberships_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_memberships_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_memberships({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_memberships parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_memberships ::Google::Apps::Chat::V1::ListMembershipsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_memberships({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_memberships(::Google::Apps::Chat::V1::ListMembershipsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, show_groups: show_groups, show_invited: show_invited, use_admin_access: use_admin_access), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_memberships_client_stub.call_count
      end
    end
  end

  def test_get_membership
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Membership.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    use_admin_access = true

    get_membership_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_membership_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_membership_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_membership({ name: name, use_admin_access: use_admin_access }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_membership name: name, use_admin_access: use_admin_access do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_membership ::Google::Apps::Chat::V1::GetMembershipRequest.new(name: name, use_admin_access: use_admin_access) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_membership({ name: name, use_admin_access: use_admin_access }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_membership(::Google::Apps::Chat::V1::GetMembershipRequest.new(name: name, use_admin_access: use_admin_access), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_membership_client_stub.call_count
      end
    end
  end

  def test_get_message
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Message.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_message_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_message_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_message_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_message({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_message name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_message ::Google::Apps::Chat::V1::GetMessageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_message({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_message(::Google::Apps::Chat::V1::GetMessageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_message_client_stub.call_count
      end
    end
  end

  def test_update_message
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Message.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    message = {}
    update_mask = {}
    allow_missing = true

    update_message_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_update_message_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_message_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_message({ message: message, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_message message: message, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_message ::Google::Apps::Chat::V1::UpdateMessageRequest.new(message: message, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_message({ message: message, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_message(::Google::Apps::Chat::V1::UpdateMessageRequest.new(message: message, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_message_client_stub.call_count
      end
    end
  end

  def test_delete_message
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_message_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_delete_message_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_message_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_message({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_message name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_message ::Google::Apps::Chat::V1::DeleteMessageRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_message({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_message(::Google::Apps::Chat::V1::DeleteMessageRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_message_client_stub.call_count
      end
    end
  end

  def test_get_attachment
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Attachment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_attachment_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_attachment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_attachment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_attachment ::Google::Apps::Chat::V1::GetAttachmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_attachment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_attachment(::Google::Apps::Chat::V1::GetAttachmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_attachment_client_stub.call_count
      end
    end
  end

  def test_upload_attachment
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::UploadAttachmentResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filename = "hello world"

    upload_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_upload_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upload_attachment_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upload_attachment({ parent: parent, filename: filename }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upload_attachment parent: parent, filename: filename do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upload_attachment ::Google::Apps::Chat::V1::UploadAttachmentRequest.new(parent: parent, filename: filename) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upload_attachment({ parent: parent, filename: filename }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upload_attachment(::Google::Apps::Chat::V1::UploadAttachmentRequest.new(parent: parent, filename: filename), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upload_attachment_client_stub.call_count
      end
    end
  end

  def test_list_spaces
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::ListSpacesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_spaces_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_list_spaces_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_spaces_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_spaces({ page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_spaces page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_spaces ::Google::Apps::Chat::V1::ListSpacesRequest.new(page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_spaces({ page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_spaces(::Google::Apps::Chat::V1::ListSpacesRequest.new(page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_spaces_client_stub.call_count
      end
    end
  end

  def test_search_spaces
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::SearchSpacesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    use_admin_access = true
    page_size = 42
    page_token = "hello world"
    query = "hello world"
    order_by = "hello world"

    search_spaces_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_search_spaces_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_spaces_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_spaces({ use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_spaces use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_spaces ::Google::Apps::Chat::V1::SearchSpacesRequest.new(use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_spaces({ use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_spaces(::Google::Apps::Chat::V1::SearchSpacesRequest.new(use_admin_access: use_admin_access, page_size: page_size, page_token: page_token, query: query, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_spaces_client_stub.call_count
      end
    end
  end

  def test_get_space
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Space.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    use_admin_access = true

    get_space_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_space_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_space_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_space({ name: name, use_admin_access: use_admin_access }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_space name: name, use_admin_access: use_admin_access do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_space ::Google::Apps::Chat::V1::GetSpaceRequest.new(name: name, use_admin_access: use_admin_access) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_space({ name: name, use_admin_access: use_admin_access }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_space(::Google::Apps::Chat::V1::GetSpaceRequest.new(name: name, use_admin_access: use_admin_access), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_space_client_stub.call_count
      end
    end
  end

  def test_create_space
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Space.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    space = {}
    request_id = "hello world"

    create_space_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_create_space_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_space_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_space({ space: space, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_space space: space, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_space ::Google::Apps::Chat::V1::CreateSpaceRequest.new(space: space, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_space({ space: space, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_space(::Google::Apps::Chat::V1::CreateSpaceRequest.new(space: space, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_space_client_stub.call_count
      end
    end
  end

  def test_set_up_space
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Space.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    space = {}
    request_id = "hello world"
    memberships = [{}]

    set_up_space_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_set_up_space_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_up_space_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_up_space({ space: space, request_id: request_id, memberships: memberships }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_up_space space: space, request_id: request_id, memberships: memberships do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_up_space ::Google::Apps::Chat::V1::SetUpSpaceRequest.new(space: space, request_id: request_id, memberships: memberships) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_up_space({ space: space, request_id: request_id, memberships: memberships }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_up_space(::Google::Apps::Chat::V1::SetUpSpaceRequest.new(space: space, request_id: request_id, memberships: memberships), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_up_space_client_stub.call_count
      end
    end
  end

  def test_update_space
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Space.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    space = {}
    update_mask = {}
    use_admin_access = true

    update_space_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_update_space_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_space_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_space({ space: space, update_mask: update_mask, use_admin_access: use_admin_access }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_space space: space, update_mask: update_mask, use_admin_access: use_admin_access do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_space ::Google::Apps::Chat::V1::UpdateSpaceRequest.new(space: space, update_mask: update_mask, use_admin_access: use_admin_access) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_space({ space: space, update_mask: update_mask, use_admin_access: use_admin_access }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_space(::Google::Apps::Chat::V1::UpdateSpaceRequest.new(space: space, update_mask: update_mask, use_admin_access: use_admin_access), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_space_client_stub.call_count
      end
    end
  end

  def test_delete_space
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    use_admin_access = true

    delete_space_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_delete_space_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_space_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_space({ name: name, use_admin_access: use_admin_access }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_space name: name, use_admin_access: use_admin_access do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_space ::Google::Apps::Chat::V1::DeleteSpaceRequest.new(name: name, use_admin_access: use_admin_access) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_space({ name: name, use_admin_access: use_admin_access }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_space(::Google::Apps::Chat::V1::DeleteSpaceRequest.new(name: name, use_admin_access: use_admin_access), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_space_client_stub.call_count
      end
    end
  end

  def test_complete_import_space
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::CompleteImportSpaceResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    complete_import_space_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_complete_import_space_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, complete_import_space_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.complete_import_space({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.complete_import_space name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.complete_import_space ::Google::Apps::Chat::V1::CompleteImportSpaceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.complete_import_space({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.complete_import_space(::Google::Apps::Chat::V1::CompleteImportSpaceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, complete_import_space_client_stub.call_count
      end
    end
  end

  def test_find_direct_message
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Space.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    find_direct_message_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_find_direct_message_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, find_direct_message_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.find_direct_message({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.find_direct_message name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.find_direct_message ::Google::Apps::Chat::V1::FindDirectMessageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.find_direct_message({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.find_direct_message(::Google::Apps::Chat::V1::FindDirectMessageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, find_direct_message_client_stub.call_count
      end
    end
  end

  def test_create_membership
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Membership.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    membership = {}
    use_admin_access = true

    create_membership_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_create_membership_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_membership_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_membership({ parent: parent, membership: membership, use_admin_access: use_admin_access }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_membership parent: parent, membership: membership, use_admin_access: use_admin_access do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_membership ::Google::Apps::Chat::V1::CreateMembershipRequest.new(parent: parent, membership: membership, use_admin_access: use_admin_access) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_membership({ parent: parent, membership: membership, use_admin_access: use_admin_access }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_membership(::Google::Apps::Chat::V1::CreateMembershipRequest.new(parent: parent, membership: membership, use_admin_access: use_admin_access), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_membership_client_stub.call_count
      end
    end
  end

  def test_update_membership
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Membership.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    membership = {}
    update_mask = {}
    use_admin_access = true

    update_membership_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_update_membership_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_membership_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_membership({ membership: membership, update_mask: update_mask, use_admin_access: use_admin_access }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_membership membership: membership, update_mask: update_mask, use_admin_access: use_admin_access do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_membership ::Google::Apps::Chat::V1::UpdateMembershipRequest.new(membership: membership, update_mask: update_mask, use_admin_access: use_admin_access) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_membership({ membership: membership, update_mask: update_mask, use_admin_access: use_admin_access }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_membership(::Google::Apps::Chat::V1::UpdateMembershipRequest.new(membership: membership, update_mask: update_mask, use_admin_access: use_admin_access), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_membership_client_stub.call_count
      end
    end
  end

  def test_delete_membership
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Membership.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    use_admin_access = true

    delete_membership_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_delete_membership_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_membership_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_membership({ name: name, use_admin_access: use_admin_access }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_membership name: name, use_admin_access: use_admin_access do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_membership ::Google::Apps::Chat::V1::DeleteMembershipRequest.new(name: name, use_admin_access: use_admin_access) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_membership({ name: name, use_admin_access: use_admin_access }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_membership(::Google::Apps::Chat::V1::DeleteMembershipRequest.new(name: name, use_admin_access: use_admin_access), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_membership_client_stub.call_count
      end
    end
  end

  def test_create_reaction
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::Reaction.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reaction = {}

    create_reaction_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_create_reaction_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_reaction_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_reaction({ parent: parent, reaction: reaction }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_reaction parent: parent, reaction: reaction do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_reaction ::Google::Apps::Chat::V1::CreateReactionRequest.new(parent: parent, reaction: reaction) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_reaction({ parent: parent, reaction: reaction }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_reaction(::Google::Apps::Chat::V1::CreateReactionRequest.new(parent: parent, reaction: reaction), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_reaction_client_stub.call_count
      end
    end
  end

  def test_list_reactions
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::ListReactionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_reactions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_list_reactions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_reactions_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_reactions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_reactions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_reactions ::Google::Apps::Chat::V1::ListReactionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_reactions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_reactions(::Google::Apps::Chat::V1::ListReactionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_reactions_client_stub.call_count
      end
    end
  end

  def test_delete_reaction
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reaction_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_delete_reaction_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_reaction_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_reaction({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_reaction name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_reaction ::Google::Apps::Chat::V1::DeleteReactionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_reaction({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_reaction(::Google::Apps::Chat::V1::DeleteReactionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_reaction_client_stub.call_count
      end
    end
  end

  def test_create_custom_emoji
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::CustomEmoji.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    custom_emoji = {}

    create_custom_emoji_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_create_custom_emoji_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_custom_emoji_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_custom_emoji({ custom_emoji: custom_emoji }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_custom_emoji custom_emoji: custom_emoji do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_custom_emoji ::Google::Apps::Chat::V1::CreateCustomEmojiRequest.new(custom_emoji: custom_emoji) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_custom_emoji({ custom_emoji: custom_emoji }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_custom_emoji(::Google::Apps::Chat::V1::CreateCustomEmojiRequest.new(custom_emoji: custom_emoji), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_custom_emoji_client_stub.call_count
      end
    end
  end

  def test_get_custom_emoji
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::CustomEmoji.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_emoji_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_custom_emoji_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_custom_emoji_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_custom_emoji({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_custom_emoji name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_custom_emoji ::Google::Apps::Chat::V1::GetCustomEmojiRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_custom_emoji({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_custom_emoji(::Google::Apps::Chat::V1::GetCustomEmojiRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_custom_emoji_client_stub.call_count
      end
    end
  end

  def test_list_custom_emojis
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::ListCustomEmojisResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_custom_emojis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_list_custom_emojis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_custom_emojis_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_custom_emojis({ page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_custom_emojis page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_custom_emojis ::Google::Apps::Chat::V1::ListCustomEmojisRequest.new(page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_custom_emojis({ page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_custom_emojis(::Google::Apps::Chat::V1::ListCustomEmojisRequest.new(page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_custom_emojis_client_stub.call_count
      end
    end
  end

  def test_delete_custom_emoji
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_custom_emoji_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_delete_custom_emoji_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_custom_emoji_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_custom_emoji({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_custom_emoji name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_custom_emoji ::Google::Apps::Chat::V1::DeleteCustomEmojiRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_custom_emoji({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_custom_emoji(::Google::Apps::Chat::V1::DeleteCustomEmojiRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_custom_emoji_client_stub.call_count
      end
    end
  end

  def test_get_space_read_state
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::SpaceReadState.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_space_read_state_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_space_read_state_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_space_read_state_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_space_read_state({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_space_read_state name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_space_read_state ::Google::Apps::Chat::V1::GetSpaceReadStateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_space_read_state({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_space_read_state(::Google::Apps::Chat::V1::GetSpaceReadStateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_space_read_state_client_stub.call_count
      end
    end
  end

  def test_update_space_read_state
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::SpaceReadState.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    space_read_state = {}
    update_mask = {}

    update_space_read_state_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_update_space_read_state_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_space_read_state_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_space_read_state({ space_read_state: space_read_state, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_space_read_state space_read_state: space_read_state, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_space_read_state ::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest.new(space_read_state: space_read_state, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_space_read_state({ space_read_state: space_read_state, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_space_read_state(::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest.new(space_read_state: space_read_state, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_space_read_state_client_stub.call_count
      end
    end
  end

  def test_get_thread_read_state
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::ThreadReadState.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_thread_read_state_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_thread_read_state_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_thread_read_state_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_thread_read_state({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_thread_read_state name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_thread_read_state ::Google::Apps::Chat::V1::GetThreadReadStateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_thread_read_state({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_thread_read_state(::Google::Apps::Chat::V1::GetThreadReadStateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_thread_read_state_client_stub.call_count
      end
    end
  end

  def test_get_space_event
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::SpaceEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_space_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_space_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_space_event_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_space_event({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_space_event name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_space_event ::Google::Apps::Chat::V1::GetSpaceEventRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_space_event({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_space_event(::Google::Apps::Chat::V1::GetSpaceEventRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_space_event_client_stub.call_count
      end
    end
  end

  def test_list_space_events
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::ListSpaceEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_space_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_list_space_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_space_events_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_space_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_space_events parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_space_events ::Google::Apps::Chat::V1::ListSpaceEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_space_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_space_events(::Google::Apps::Chat::V1::ListSpaceEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_space_events_client_stub.call_count
      end
    end
  end

  def test_get_space_notification_setting
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::SpaceNotificationSetting.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_space_notification_setting_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_get_space_notification_setting_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_space_notification_setting_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_space_notification_setting({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_space_notification_setting name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_space_notification_setting ::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_space_notification_setting({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_space_notification_setting(::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_space_notification_setting_client_stub.call_count
      end
    end
  end

  def test_update_space_notification_setting
    # Create test objects.
    client_result = ::Google::Apps::Chat::V1::SpaceNotificationSetting.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    space_notification_setting = {}
    update_mask = {}

    update_space_notification_setting_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Apps::Chat::V1::ChatService::Rest::ServiceStub.stub :transcode_update_space_notification_setting_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_space_notification_setting_client_stub do
        # Create client
        client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_space_notification_setting({ space_notification_setting: space_notification_setting, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_space_notification_setting space_notification_setting: space_notification_setting, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_space_notification_setting ::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest.new(space_notification_setting: space_notification_setting, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_space_notification_setting({ space_notification_setting: space_notification_setting, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_space_notification_setting(::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest.new(space_notification_setting: space_notification_setting, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_space_notification_setting_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Apps::Chat::V1::ChatService::Rest::Client::Configuration, config
  end
end
