# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/apps/chat/v1/chat_service"

class ::Google::Apps::Chat::V1::ChatService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_attachment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.attachment_path space: "value0", message: "value1", attachment: "value2"
      assert_equal "spaces/value0/messages/value1/attachments/value2", path
    end
  end

  def test_custom_emoji_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.custom_emoji_path custom_emoji: "value0"
      assert_equal "customEmojis/value0", path
    end
  end

  def test_membership_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.membership_path space: "value0", member: "value1"
      assert_equal "spaces/value0/members/value1", path
    end
  end

  def test_message_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.message_path space: "value0", message: "value1"
      assert_equal "spaces/value0/messages/value1", path
    end
  end

  def test_quoted_message_metadata_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.quoted_message_metadata_path space: "value0", message: "value1", quoted_message_metadata: "value2"
      assert_equal "spaces/value0/messages/value1/quotedMessageMetadata/value2", path
    end
  end

  def test_reaction_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.reaction_path space: "value0", message: "value1", reaction: "value2"
      assert_equal "spaces/value0/messages/value1/reactions/value2", path
    end
  end

  def test_space_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.space_path space: "value0"
      assert_equal "spaces/value0", path
    end
  end

  def test_space_event_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.space_event_path space: "value0", space_event: "value1"
      assert_equal "spaces/value0/spaceEvents/value1", path
    end
  end

  def test_space_notification_setting_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.space_notification_setting_path user: "value0", space: "value1"
      assert_equal "users/value0/spaces/value1/spaceNotificationSetting", path
    end
  end

  def test_space_read_state_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.space_read_state_path user: "value0", space: "value1"
      assert_equal "users/value0/spaces/value1/spaceReadState", path
    end
  end

  def test_thread_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.thread_path space: "value0", thread: "value1"
      assert_equal "spaces/value0/threads/value1", path
    end
  end

  def test_thread_read_state_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.thread_read_state_path user: "value0", space: "value1", thread: "value2"
      assert_equal "users/value0/spaces/value1/threads/value2/threadReadState", path
    end
  end
end
