# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # A widget is a UI element that presents text and images.
        # @!attribute [rw] text_paragraph
        #   @return [::Google::Apps::Chat::V1::WidgetMarkup::TextParagraph]
        #     Display a text paragraph in this widget.
        #
        #     Note: The following fields are mutually exclusive: `text_paragraph`, `image`, `key_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image
        #   @return [::Google::Apps::Chat::V1::WidgetMarkup::Image]
        #     Display an image in this widget.
        #
        #     Note: The following fields are mutually exclusive: `image`, `text_paragraph`, `key_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] key_value
        #   @return [::Google::Apps::Chat::V1::WidgetMarkup::KeyValue]
        #     Display a key value item in this widget.
        #
        #     Note: The following fields are mutually exclusive: `key_value`, `text_paragraph`, `image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] buttons
        #   @return [::Array<::Google::Apps::Chat::V1::WidgetMarkup::Button>]
        #     A list of buttons. Buttons is also `oneof data` and only one of these
        #     fields should be set.
        class WidgetMarkup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A paragraph of text. Formatted text supported. For more information
          # about formatting text, see
          # [Formatting text in Google Chat
          # apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
          # and
          # [Formatting
          # text in Google Workspace
          # Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
          # @!attribute [rw] text
          #   @return [::String]
          class TextParagraph
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A button. Can be a text button or an image button.
          # @!attribute [rw] text_button
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::TextButton]
          #     A button with text and `onclick` action.
          #
          #     Note: The following fields are mutually exclusive: `text_button`, `image_button`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] image_button
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::ImageButton]
          #     A button with image and `onclick` action.
          #
          #     Note: The following fields are mutually exclusive: `image_button`, `text_button`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Button
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A button with text and `onclick` action.
          # @!attribute [rw] text
          #   @return [::String]
          #     The text of the button.
          # @!attribute [rw] on_click
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::OnClick]
          #     The `onclick` action of the button.
          class TextButton
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A UI element contains a key (label) and a value (content). This
          # element can also contain some actions such as `onclick` button.
          # @!attribute [rw] icon
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::Icon]
          #     An enum value that's replaced by the Chat API with the
          #     corresponding icon image.
          #
          #     Note: The following fields are mutually exclusive: `icon`, `icon_url`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] icon_url
          #   @return [::String]
          #     The icon specified by a URL.
          #
          #     Note: The following fields are mutually exclusive: `icon_url`, `icon`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] top_label
          #   @return [::String]
          #     The text of the top label. Formatted text supported. For more information
          #     about formatting text, see
          #     [Formatting text in Google Chat
          #     apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
          #     and
          #     [Formatting
          #     text in Google Workspace
          #     Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
          # @!attribute [rw] content
          #   @return [::String]
          #     The text of the content. Formatted text supported and always required.
          #     For more information
          #     about formatting text, see
          #     [Formatting text in Google Chat
          #     apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
          #     and
          #     [Formatting
          #     text in Google Workspace
          #     Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
          # @!attribute [rw] content_multiline
          #   @return [::Boolean]
          #     If the content should be multiline.
          # @!attribute [rw] bottom_label
          #   @return [::String]
          #     The text of the bottom label. Formatted text supported. For more
          #     information about formatting text, see [Formatting text in Google Chat
          #     apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
          #     and
          #     [Formatting
          #     text in Google Workspace
          #     Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
          # @!attribute [rw] on_click
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::OnClick]
          #     The `onclick` action. Only the top label, bottom label, and content
          #     region are clickable.
          # @!attribute [rw] button
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::Button]
          #     A button that can be clicked to trigger an action.
          class KeyValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An image that's specified by a URL and can have an `onclick` action.
          # @!attribute [rw] image_url
          #   @return [::String]
          #     The URL of the image.
          # @!attribute [rw] on_click
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::OnClick]
          #     The `onclick` action.
          # @!attribute [rw] aspect_ratio
          #   @return [::Float]
          #     The aspect ratio of this image (width and height). This field lets you
          #     reserve the right height for the image while waiting for it to load.
          #     It's not meant to override the built-in aspect ratio of the image.
          #     If unset, the server fills it by prefetching the image.
          class Image
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An image button with an `onclick` action.
          # @!attribute [rw] icon
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::Icon]
          #     The icon specified by an `enum` that indices to an icon provided by
          #     Chat API.
          #
          #     Note: The following fields are mutually exclusive: `icon`, `icon_url`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] icon_url
          #   @return [::String]
          #     The icon specified by a URL.
          #
          #     Note: The following fields are mutually exclusive: `icon_url`, `icon`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] on_click
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::OnClick]
          #     The `onclick` action.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of this `image_button` that's used for accessibility.
          #     Default value is provided if this name isn't specified.
          class ImageButton
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An `onclick` action (for example, open a link).
          # @!attribute [rw] action
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::FormAction]
          #     A form action is triggered by this `onclick` action if specified.
          #
          #     Note: The following fields are mutually exclusive: `action`, `open_link`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] open_link
          #   @return [::Google::Apps::Chat::V1::WidgetMarkup::OpenLink]
          #     This `onclick` action triggers an open link action if specified.
          #
          #     Note: The following fields are mutually exclusive: `open_link`, `action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class OnClick
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A link that opens a new window.
          # @!attribute [rw] url
          #   @return [::String]
          #     The URL to open.
          class OpenLink
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A form action describes the behavior when the form is submitted.
          # For example, you can invoke Apps Script to handle the form.
          # @!attribute [rw] action_method_name
          #   @return [::String]
          #     The method name is used to identify which part of the form triggered the
          #     form submission. This information is echoed back to the Chat app as part
          #     of the card click event. You can use the same method name for several
          #     elements that trigger a common behavior.
          # @!attribute [rw] parameters
          #   @return [::Array<::Google::Apps::Chat::V1::WidgetMarkup::FormAction::ActionParameter>]
          #     List of action parameters.
          class FormAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # List of string parameters to supply when the action method is invoked.
            # For example, consider three snooze buttons: snooze now, snooze one day,
            # snooze next week. You might use `action method = snooze()`, passing the
            # snooze type and snooze time in the list of string parameters.
            # @!attribute [rw] key
            #   @return [::String]
            #     The name of the parameter for the action script.
            # @!attribute [rw] value
            #   @return [::String]
            #     The value of the parameter.
            class ActionParameter
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The set of supported icons.
          module Icon
            ICON_UNSPECIFIED = 0

            AIRPLANE = 1

            BOOKMARK = 26

            BUS = 25

            CAR = 9

            CLOCK = 2

            CONFIRMATION_NUMBER_ICON = 12

            DOLLAR = 14

            DESCRIPTION = 27

            EMAIL = 10

            EVENT_PERFORMER = 20

            EVENT_SEAT = 21

            FLIGHT_ARRIVAL = 16

            FLIGHT_DEPARTURE = 15

            HOTEL = 6

            HOTEL_ROOM_TYPE = 17

            INVITE = 19

            MAP_PIN = 3

            MEMBERSHIP = 24

            MULTIPLE_PEOPLE = 18

            OFFER = 30

            PERSON = 11

            PHONE = 13

            RESTAURANT_ICON = 7

            SHOPPING_CART = 8

            STAR = 5

            STORE = 22

            TICKET = 4

            TRAIN = 23

            VIDEO_CAMERA = 28

            VIDEO_PLAY = 29
          end
        end
      end
    end
  end
end
