# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # A user's read state within a thread, used to identify read and unread
        # messages.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the thread read state.
        #
        #     Format: `users/{user}/spaces/{space}/threads/{thread}/threadReadState`
        # @!attribute [rw] last_read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the user's thread read state was updated. Usually this
        #     corresponds with the timestamp of the last read message in a thread.
        class ThreadReadState
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetThreadReadStateRequest API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the thread read state to retrieve.
        #
        #     Only supports getting read state for the calling user.
        #
        #     To refer to the calling user, set one of the following:
        #
        #     - The `me` alias. For example,
        #     `users/me/spaces/{space}/threads/{thread}/threadReadState`.
        #
        #     - Their Workspace email address. For example,
        #     `users/user@example.com/spaces/{space}/threads/{thread}/threadReadState`.
        #
        #     - Their user id. For example,
        #     `users/123456789/spaces/{space}/threads/{thread}/threadReadState`.
        #
        #     Format: users/\\{user}/spaces/\\{space}/threads/\\{thread}/threadReadState
        class GetThreadReadStateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
