# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # A user's read state within a space, used to identify read and unread
        # messages.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the space read state.
        #
        #     Format: `users/{user}/spaces/{space}/spaceReadState`
        # @!attribute [rw] last_read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The time when the user's space read state was updated. Usually
        #     this corresponds with either the timestamp of the last read message, or a
        #     timestamp specified by the user to mark the last read position in a space.
        class SpaceReadState
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetSpaceReadState API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the space read state to retrieve.
        #
        #     Only supports getting read state for the calling user.
        #
        #     To refer to the calling user, set one of the following:
        #
        #     - The `me` alias. For example, `users/me/spaces/{space}/spaceReadState`.
        #
        #     - Their Workspace email address. For example,
        #     `users/user@example.com/spaces/{space}/spaceReadState`.
        #
        #     - Their user id. For example,
        #     `users/123456789/spaces/{space}/spaceReadState`.
        #
        #     Format: users/\\{user}/spaces/\\{space}/spaceReadState
        class GetSpaceReadStateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateSpaceReadState API.
        # @!attribute [rw] space_read_state
        #   @return [::Google::Apps::Chat::V1::SpaceReadState]
        #     Required. The space read state and fields to update.
        #
        #     Only supports updating read state for the calling user.
        #
        #     To refer to the calling user, set one of the following:
        #
        #     - The `me` alias. For example, `users/me/spaces/{space}/spaceReadState`.
        #
        #     - Their Workspace email address. For example,
        #     `users/user@example.com/spaces/{space}/spaceReadState`.
        #
        #     - Their user id. For example,
        #     `users/123456789/spaces/{space}/spaceReadState`.
        #
        #     Format: users/\\{user}/spaces/\\{space}/spaceReadState
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The field paths to update. Currently supported field paths:
        #
        #     - `last_read_time`
        #
        #     When the `last_read_time` is before the latest message create time, the
        #     space appears as unread in the UI.
        #
        #     To mark the space as read, set `last_read_time` to any value later (larger)
        #     than the latest message create time. The `last_read_time` is coerced to
        #     match the latest message create time. Note that the space read state only
        #     affects the read state of messages that are visible in the space's
        #     top-level conversation. Replies in threads are unaffected by this
        #     timestamp, and instead rely on the thread read state.
        class UpdateSpaceReadStateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
