# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # A message in a Google Chat space.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the message.
        #
        #     Format: `spaces/{space}/messages/{message}`
        #
        #
        #     Where `{space}` is the ID of the space where the message is posted and
        #     `{message}` is a system-assigned ID for the message. For example,
        #     `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
        #
        #     If you set a custom ID when you create a message, you can use this ID to
        #     specify the message in a request by replacing `{message}` with the value
        #     from the `clientAssignedMessageId` field. For example,
        #     `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
        #     a
        #     message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
        # @!attribute [r] sender
        #   @return [::Google::Apps::Chat::V1::User]
        #     Output only. The user who created the message.
        #     If your Chat app [authenticates as a
        #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
        #     the output populates the
        #     [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
        #     `name` and `type`.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Immutable. For spaces created in Chat, the time at which the
        #     message was created. This field is output only, except when used in import
        #     mode spaces.
        #
        #     For import mode spaces, set this field to the historical timestamp at which
        #     the message was created in the source in order to preserve the original
        #     creation time.
        # @!attribute [r] last_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the message was last edited by a user. If
        #     the message has never been edited, this field is empty.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the message was deleted in
        #     Google Chat. If the message is never deleted, this field is empty.
        # @!attribute [rw] text
        #   @return [::String]
        #     Optional. Plain-text body of the message. The first link to an image,
        #     video, or web page generates a [preview
        #     chip](https://developers.google.com/workspace/chat/preview-links). You can
        #     also [@mention a Google Chat
        #     user](https://developers.google.com/workspace/chat/format-messages#messages-@mention),
        #     or everyone in the space.
        #
        #     To learn about creating text messages, see [Send a
        #     message](https://developers.google.com/workspace/chat/create-messages).
        # @!attribute [r] formatted_text
        #   @return [::String]
        #     Output only. Contains the message `text` with markups added to communicate
        #     formatting. This field might not capture all formatting visible in the UI,
        #     but includes the following:
        #
        #     * [Markup
        #     syntax](https://developers.google.com/workspace/chat/format-messages)
        #     for bold, italic, strikethrough, monospace, monospace block, and bulleted
        #     list.
        #
        #     * [User
        #     mentions](https://developers.google.com/workspace/chat/format-messages#messages-@mention)
        #     using the format `<users/{user}>`.
        #
        #     * Custom hyperlinks using the format `<{url}|{rendered_text}>` where the
        #     first string is the URL and the second is the rendered text—for example,
        #     `<http://example.com|custom text>`.
        #
        #     * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
        #     This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
        #     face emoji.
        #
        #     * Bullet list items using asterisks (`*`)—for example, `* item`.
        #
        #     For more information, see [View text formatting sent in a
        #     message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
        # @!attribute [rw] cards
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Apps::Chat::V1::ContextualAddOnMarkup::Card>]
        #     Deprecated: Use `cards_v2` instead.
        #
        #     Rich, formatted, and interactive cards that you can use to display UI
        #     elements such as: formatted texts, buttons, and clickable images. Cards are
        #     normally displayed below the plain-text body of the message. `cards` and
        #     `cards_v2` can have a maximum size of 32 KB.
        # @!attribute [rw] cards_v2
        #   @return [::Array<::Google::Apps::Chat::V1::CardWithId>]
        #     Optional. An array of
        #     [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
        #
        #     Only Chat apps can create cards. If your Chat app [authenticates as a
        #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
        #     the messages can't contain cards.
        #
        #     To learn how to create a message that contains cards, see [Send a
        #     message](https://developers.google.com/workspace/chat/create-messages).
        #
        #     [Card builder](https://addons.gsuite.google.com/uikit/builder)
        # @!attribute [r] annotations
        #   @return [::Array<::Google::Apps::Chat::V1::Annotation>]
        #     Output only. Annotations can be associated with the plain-text body of the
        #     message or with chips that link to Google Workspace resources like Google
        #     Docs or Sheets with `start_index` and `length` of 0.
        # @!attribute [rw] thread
        #   @return [::Google::Apps::Chat::V1::Thread]
        #     The thread the message belongs to. For example usage, see
        #     [Start or reply to a message
        #     thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
        # @!attribute [r] space
        #   @return [::Google::Apps::Chat::V1::Space]
        #     Output only. If your Chat app [authenticates as a
        #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
        #     the output only populates the
        #     [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
        #     `name`.
        # @!attribute [rw] fallback_text
        #   @return [::String]
        #     Optional. A plain-text description of the message's cards, used when the
        #     actual cards can't be displayed—for example, mobile notifications.
        # @!attribute [rw] action_response
        #   @return [::Google::Apps::Chat::V1::ActionResponse]
        #     Input only. Parameters that a Chat app can use to configure how its
        #     response is posted.
        # @!attribute [r] argument_text
        #   @return [::String]
        #     Output only. Plain-text body of the message with all Chat app mentions
        #     stripped out.
        # @!attribute [r] slash_command
        #   @return [::Google::Apps::Chat::V1::SlashCommand]
        #     Output only. Slash command information, if applicable.
        # @!attribute [rw] attachment
        #   @return [::Array<::Google::Apps::Chat::V1::Attachment>]
        #     Optional. User-uploaded attachment.
        # @!attribute [r] matched_url
        #   @return [::Google::Apps::Chat::V1::MatchedUrl]
        #     Output only. A URL in `spaces.messages.text` that matches a link preview
        #     pattern. For more information, see [Preview
        #     links](https://developers.google.com/workspace/chat/preview-links).
        # @!attribute [r] thread_reply
        #   @return [::Boolean]
        #     Output only. When `true`, the message is a response in a reply thread. When
        #     `false`, the message is visible in the space's top-level conversation as
        #     either the first message of a thread or a message with no threaded replies.
        #
        #     If the space doesn't support reply in threads, this field is always
        #     `false`.
        # @!attribute [rw] client_assigned_message_id
        #   @return [::String]
        #     Optional. A custom ID for the message. You can use field to identify a
        #     message, or to get, delete, or update a message. To set a custom ID,
        #     specify the
        #     [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
        #     field when you create the message. For details, see [Name a
        #     message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
        # @!attribute [r] emoji_reaction_summaries
        #   @return [::Array<::Google::Apps::Chat::V1::EmojiReactionSummary>]
        #     Output only. The list of emoji reaction summaries on the message.
        # @!attribute [rw] private_message_viewer
        #   @return [::Google::Apps::Chat::V1::User]
        #     Optional. Immutable. Input for creating a message, otherwise output only.
        #     The user that can view the message. When set, the message is private and
        #     only visible to the specified user and the Chat app. To include this field
        #     in your request, you must call the Chat API using [app
        #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
        #     and omit the following:
        #
        #     * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
        #
        #     For details, see [Send a message
        #     privately](https://developers.google.com/workspace/chat/create-messages#private).
        # @!attribute [r] deletion_metadata
        #   @return [::Google::Apps::Chat::V1::DeletionMetadata]
        #     Output only. Information about a deleted message. A message is deleted when
        #     `delete_time` is set.
        # @!attribute [rw] quoted_message_metadata
        #   @return [::Google::Apps::Chat::V1::QuotedMessageMetadata]
        #     Optional. Information about a message that another message quotes.
        #
        #     When you create a message, you can quote messages within the same
        #     thread, or quote a root message to create a new root message.
        #     However, you can't quote a message reply from a different thread.
        #
        #     When you update a message, you can't add or replace the
        #     `quotedMessageMetadata` field, but you can remove it.
        #
        #     For example usage, see [Quote another
        #     message](https://developers.google.com/workspace/chat/create-messages#quote-a-message).
        # @!attribute [r] attached_gifs
        #   @return [::Array<::Google::Apps::Chat::V1::AttachedGif>]
        #     Output only. GIF images that are attached to the message.
        # @!attribute [rw] accessory_widgets
        #   @return [::Array<::Google::Apps::Chat::V1::AccessoryWidget>]
        #     Optional. One or more interactive widgets that appear at the bottom of a
        #     message. You can add accessory widgets to messages that contain text,
        #     cards, or both text and cards. Not supported for messages that contain
        #     dialogs. For details, see [Add interactive widgets at the bottom of a
        #     message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
        #
        #     Creating a message with accessory widgets requires [app
        #     authentication]
        #     (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
        class Message
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A GIF image that's specified by a URL.
        # @!attribute [r] uri
        #   @return [::String]
        #     Output only. The URL that hosts the GIF image.
        class AttachedGif
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about a message that another message quotes.
        #
        # When you create a message, you can quote messages within the same
        # thread, or quote a root message to create a new root message.
        # However, you can't quote a message reply from a different thread.
        #
        # When you update a message, you can't add or replace the
        # `quotedMessageMetadata` field, but you can remove it.
        #
        # For example usage, see [Quote another
        # message](https://developers.google.com/workspace/chat/create-messages#quote-a-message).
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the message that is quoted.
        #
        #     Format: `spaces/{space}/messages/{message}`
        # @!attribute [rw] last_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. The timestamp when the quoted message was created or when the
        #     quoted message was last updated.
        #
        #     If the message was edited, use this field, `last_update_time`.
        #     If the message was never edited, use `create_time`.
        #
        #     If `last_update_time` doesn't match the latest version of the quoted
        #     message, the request fails.
        class QuotedMessageMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A thread in a Google Chat space. For example usage, see
        # [Start or reply to a message
        # thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
        #
        # If you specify a thread when creating a message, you can set the
        # [`messageReplyOption`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#messagereplyoption)
        # field to determine what happens if no matching thread is found.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the thread.
        #
        #     Example: `spaces/{space}/threads/{thread}`
        # @!attribute [rw] thread_key
        #   @return [::String]
        #     Optional. Input for creating or updating a thread. Otherwise, output only.
        #     ID for the thread. Supports up to 4000 characters.
        #
        #     This ID is unique to the Chat app that sets it. For example, if
        #     multiple Chat apps create a message using the same thread key,
        #     the messages are posted in different threads. To reply in a
        #     thread created by a person or another Chat app, specify the thread `name`
        #     field instead.
        class Thread
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Parameters that a Chat app can use to configure how its response is posted.
        # @!attribute [rw] type
        #   @return [::Google::Apps::Chat::V1::ActionResponse::ResponseType]
        #     Input only. The type of Chat app response.
        # @!attribute [rw] url
        #   @return [::String]
        #     Input only. URL for users to authenticate or configure. (Only for
        #     `REQUEST_CONFIG` response types.)
        # @!attribute [rw] dialog_action
        #   @return [::Google::Apps::Chat::V1::DialogAction]
        #     Input only. A response to an interaction event related to a
        #     [dialog](https://developers.google.com/workspace/chat/dialogs). Must be
        #     accompanied by `ResponseType.Dialog`.
        # @!attribute [rw] updated_widget
        #   @return [::Google::Apps::Chat::V1::ActionResponse::UpdatedWidget]
        #     Input only. The response of the updated widget.
        class ActionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # List of widget autocomplete results.
          # @!attribute [rw] items
          #   @return [::Array<::Google::Apps::Card::V1::SelectionInput::SelectionItem>]
          #     An array of the SelectionItem objects.
          class SelectionItems
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # For `selectionInput` widgets, returns autocomplete suggestions for a
          # multiselect menu.
          # @!attribute [rw] suggestions
          #   @return [::Google::Apps::Chat::V1::ActionResponse::SelectionItems]
          #     List of widget autocomplete results
          # @!attribute [rw] widget
          #   @return [::String]
          #     The ID of the updated widget. The ID must match the one for the
          #     widget that triggered the update request.
          class UpdatedWidget
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of Chat app response.
          module ResponseType
            # Default type that's handled as `NEW_MESSAGE`.
            TYPE_UNSPECIFIED = 0

            # Post as a new message in the topic.
            NEW_MESSAGE = 1

            # Update the Chat app's message. This is only permitted on a `CARD_CLICKED`
            # event where the message sender type is `BOT`.
            UPDATE_MESSAGE = 2

            # Update the cards on a user's message. This is only permitted as a
            # response to a `MESSAGE` event with a matched url, or a `CARD_CLICKED`
            # event where the message sender type is `HUMAN`. Text is ignored.
            UPDATE_USER_MESSAGE_CARDS = 6

            # Privately ask the user for additional authentication or configuration.
            REQUEST_CONFIG = 3

            # Presents a
            # [dialog](https://developers.google.com/workspace/chat/dialogs).
            DIALOG = 4

            # Widget text autocomplete options query.
            UPDATE_WIDGET = 7
          end
        end

        # One or more interactive widgets that appear at the bottom of a message. For
        # details, see [Add interactive widgets at the bottom of a
        # message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
        # @!attribute [rw] button_list
        #   @return [::Google::Apps::Card::V1::ButtonList]
        #     A list of buttons.
        class AccessoryWidget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the message.
        #
        #     Format: `spaces/{space}/messages/{message}`
        #
        #     If you've set a custom ID for your message, you can use the value from the
        #     `clientAssignedMessageId` field for `{message}`. For details, see [Name a
        #     message]
        #     (https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
        class GetMessageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to delete a message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the message.
        #
        #     Format: `spaces/{space}/messages/{message}`
        #
        #     If you've set a custom ID for your message, you can use the value from the
        #     `clientAssignedMessageId` field for `{message}`. For details, see [Name a
        #     message]
        #     (https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. When `true`, deleting a message also deletes its threaded
        #     replies. When `false`, if a message has threaded replies, deletion fails.
        #
        #     Only applies when [authenticating as a
        #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
        #     Has no effect when [authenticating as a Chat app]
        #     (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
        class DeleteMessageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to update a message.
        # @!attribute [rw] message
        #   @return [::Google::Apps::Chat::V1::Message]
        #     Required. Message with fields updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The field paths to update. Separate multiple values with commas
        #     or use `*` to update all field paths.
        #
        #     Currently supported field paths:
        #
        #     - `text`
        #
        #     - `attachment`
        #
        #     - `cards` (Requires [app
        #     authentication](/chat/api/guides/auth/service-accounts).)
        #
        #     - `cards_v2`  (Requires [app
        #     authentication](/chat/api/guides/auth/service-accounts).)
        #
        #     - `accessory_widgets`  (Requires [app
        #     authentication](/chat/api/guides/auth/service-accounts).)
        #
        #     - `quoted_message_metadata` (Only allows removal of the quoted message.)
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If `true` and the message isn't found, a new message is created
        #     and `updateMask` is ignored. The specified message ID must be
        #     [client-assigned](https://developers.google.com/workspace/chat/create-messages#name_a_created_message)
        #     or the request fails.
        class UpdateMessageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Creates a message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the space in which to create a message.
        #
        #     Format: `spaces/{space}`
        # @!attribute [rw] message
        #   @return [::Google::Apps::Chat::V1::Message]
        #     Required. Message body.
        # @!attribute [rw] thread_key
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Optional. Deprecated: Use
        #     {::Google::Apps::Chat::V1::Thread#thread_key thread.thread_key} instead. ID for the
        #     thread. Supports up to 4000 characters. To start or add to a thread, create
        #     a message and specify a `threadKey` or the
        #     {::Google::Apps::Chat::V1::Thread#name thread.name}. For example usage, see [Start or
        #     reply to a message
        #     thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique request ID for this message. Specifying an existing
        #     request ID returns the message created with that ID instead of creating a
        #     new message.
        # @!attribute [rw] message_reply_option
        #   @return [::Google::Apps::Chat::V1::CreateMessageRequest::MessageReplyOption]
        #     Optional. Specifies whether a message starts a thread or replies to one.
        #     Only supported in named spaces.
        #
        #     When [responding to user
        #     interactions](https://developers.google.com/workspace/chat/receive-respond-interactions),
        #     this field is ignored. For interactions within a thread, the reply is
        #     created in the same thread. Otherwise, the reply is created as a new
        #     thread.
        # @!attribute [rw] message_id
        #   @return [::String]
        #     Optional. A custom ID for a message. Lets Chat apps get, update, or delete
        #     a message without needing to store the system-assigned ID in the message's
        #     resource name (represented in the message `name` field).
        #
        #     The value for this field must meet the following requirements:
        #
        #     * Begins with `client-`. For example, `client-custom-name` is a valid
        #       custom ID, but `custom-name` is not.
        #     * Contains up to 63 characters and only lowercase letters, numbers, and
        #       hyphens.
        #     * Is unique within a space. A Chat app can't use the same custom ID for
        #     different messages.
        #
        #     For details, see [Name a
        #     message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
        class CreateMessageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how to reply to a message.
          # More states might be added in the future.
          module MessageReplyOption
            # Default. Starts a new thread. Using this option ignores any [thread
            # ID][google.chat.v1.Thread.name] or
            # {::Google::Apps::Chat::V1::Thread#thread_key `thread_key`} that's included.
            MESSAGE_REPLY_OPTION_UNSPECIFIED = 0

            # Creates the message as a reply to the thread specified by [thread
            # ID][google.chat.v1.Thread.name] or
            # {::Google::Apps::Chat::V1::Thread#thread_key `thread_key`}. If it fails, the
            # message starts a new thread instead.
            REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD = 1

            # Creates the message as a reply to the thread specified by [thread
            # ID][google.chat.v1.Thread.name] or
            # {::Google::Apps::Chat::V1::Thread#thread_key `thread_key`}. If a new `thread_key`
            # is used, a new thread is created. If the message creation fails, a
            # `NOT_FOUND` error is returned instead.
            REPLY_MESSAGE_OR_FAIL = 2
          end
        end

        # Lists messages in the specified space, that the user is a member of.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the space to list messages from.
        #
        #     Format: `spaces/{space}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of messages returned. The service might return
        #     fewer messages than this value.
        #
        #     If unspecified, at most 25 are returned.
        #
        #     The maximum value is 1000. If you use a value more than 1000, it's
        #     automatically changed to 1000.
        #
        #     Negative values return an `INVALID_ARGUMENT` error.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token received from a previous list messages call. Provide
        #     this parameter to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided should match the call that
        #     provided the page token. Passing different values to the other parameters
        #     might lead to unexpected results.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A query filter.
        #
        #     You can filter messages by date (`create_time`) and thread (`thread.name`).
        #
        #     To filter messages by the date they were created, specify the `create_time`
        #     with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
        #     format and double quotation marks. For example,
        #     `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `>` to
        #     list messages that were created after a timestamp, or the less than
        #     operator `<` to list messages that were created before a timestamp. To
        #     filter messages within a time interval, use the `AND` operator between two
        #     timestamps.
        #
        #     To filter by thread, specify the `thread.name`, formatted as
        #     `spaces/{space}/threads/{thread}`. You can only specify one
        #     `thread.name` per query.
        #
        #     To filter by both thread and date, use the `AND` operator in your query.
        #
        #     For example, the following queries are valid:
        #
        #     ```
        #     create_time > "2012-04-21T11:30:00-04:00"
        #
        #     create_time > "2012-04-21T11:30:00-04:00" AND
        #       thread.name = spaces/AAAAAAAAAAA/threads/123
        #
        #     create_time > "2012-04-21T11:30:00+00:00" AND
        #
        #     create_time < "2013-01-01T00:00:00+00:00" AND
        #       thread.name = spaces/AAAAAAAAAAA/threads/123
        #
        #     thread.name = spaces/AAAAAAAAAAA/threads/123
        #     ```
        #
        #     Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
        #     error.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. How the list of messages is ordered. Specify a value to order by
        #     an ordering operation. Valid ordering operation values are as follows:
        #
        #     - `ASC` for ascending.
        #
        #     - `DESC` for descending.
        #
        #     The default ordering is `create_time ASC`.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Optional. Whether to include deleted messages. Deleted messages include
        #     deleted time and metadata about their deletion, but message content is
        #     unavailable.
        class ListMessagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing messages.
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Apps::Chat::V1::Message>]
        #     List of messages.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     You can send a token as `pageToken` to retrieve the next page of
        #     results. If empty, there are no subsequent pages.
        class ListMessagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains a
        # [dialog](https://developers.google.com/workspace/chat/dialogs) and request
        # status code.
        # @!attribute [rw] dialog
        #   @return [::Google::Apps::Chat::V1::Dialog]
        #     Input only.
        #     [Dialog](https://developers.google.com/workspace/chat/dialogs) for the
        #     request.
        # @!attribute [rw] action_status
        #   @return [::Google::Apps::Chat::V1::ActionStatus]
        #     Input only. Status for a request to either invoke or submit a
        #     [dialog](https://developers.google.com/workspace/chat/dialogs). Displays
        #     a status and message to users, if necessary.
        #     For example, in case of an error or success.
        class DialogAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Wrapper around the card body of the dialog.
        # @!attribute [rw] body
        #   @return [::Google::Apps::Card::V1::Card]
        #     Input only. Body of the dialog, which is rendered in a modal.
        #     Google Chat apps don't support the following card entities:
        #     `DateTimePicker`, `OnChangeAction`.
        class Dialog
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A
        # [card](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards)
        # in a Google Chat message.
        #
        # Only Chat apps can create cards. If your Chat app [authenticates as a
        # user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
        # the message can't contain cards.
        #
        # [Card builder](https://addons.gsuite.google.com/uikit/builder)
        # @!attribute [rw] card_id
        #   @return [::String]
        #     Required if the message contains multiple cards. A unique identifier for
        #     a card in a message.
        # @!attribute [rw] card
        #   @return [::Google::Apps::Card::V1::Card]
        #     A card. Maximum size is 32 KB.
        class CardWithId
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
