# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # Represents a membership relation in Google Chat, such as whether a user or
        # Chat app is invited to, part of, or absent from a space.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the membership, assigned by the server.
        #
        #     Format: `spaces/{space}/members/{member}`
        # @!attribute [r] state
        #   @return [::Google::Apps::Chat::V1::Membership::MembershipState]
        #     Output only. State of the membership.
        # @!attribute [rw] role
        #   @return [::Google::Apps::Chat::V1::Membership::MembershipRole]
        #     Optional. User's role within a Chat space, which determines their permitted
        #     actions in the space.
        #
        #     This field can only be used as input in `UpdateMembership`.
        # @!attribute [rw] member
        #   @return [::Google::Apps::Chat::V1::User]
        #     Optional. The Google Chat user or app the membership corresponds to.
        #     If your Chat app [authenticates as a
        #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
        #     the output populates the
        #     [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
        #     `name` and `type`.
        #
        #     Note: The following fields are mutually exclusive: `member`, `group_member`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] group_member
        #   @return [::Google::Apps::Chat::V1::Group]
        #     Optional. The Google Group the membership corresponds to.
        #
        #     Reading or mutating memberships for Google Groups requires [user
        #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
        #
        #     Note: The following fields are mutually exclusive: `group_member`, `member`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Immutable. The creation time of the membership, such as when a
        #     member joined or was invited to join a space. This field is output only,
        #     except when used to import historical memberships in import mode spaces.
        # @!attribute [rw] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Immutable. The deletion time of the membership, such as when a
        #     member left or was removed from a space. This field is output only, except
        #     when used to import historical memberships in import mode spaces.
        class Membership
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the member's relationship with a space. Other membership states
          # might be supported in the future.
          module MembershipState
            # Default value. Don't use.
            MEMBERSHIP_STATE_UNSPECIFIED = 0

            # The user is added to the space, and can participate in the space.
            JOINED = 1

            # The user is invited to join the space, but hasn't joined it.
            INVITED = 2

            # The user doesn't belong to the space and doesn't have a pending
            # invitation to join the space.
            NOT_A_MEMBER = 3
          end

          # Represents a user's permitted actions in a Chat space. More enum values
          # might be added in the future.
          module MembershipRole
            # Default value. For {::Google::Apps::Chat::V1::Membership#member users}: they
            # aren't a member of the space, but can be invited. For
            # {::Google::Apps::Chat::V1::Membership#group_member Google Groups}: they're always
            #  assigned this role (other enum values might be used in the future).
            MEMBERSHIP_ROLE_UNSPECIFIED = 0

            # A member of the space. In the Chat UI, this role is called Member.
            #
            # The user has basic permissions, like sending
            # messages to the space.
            # Managers and owners can grant members additional permissions in a space,
            # including:
            #
            # - Add or remove members.
            # - Modify space details.
            # - Turn history on or off.
            # - Mention everyone in the space with `@all`.
            # - Manage Chat apps and webhooks installed in the space.
            #
            # In direct messages and unnamed group conversations, everyone
            # has this role.
            ROLE_MEMBER = 1

            # A space owner. In the Chat UI, this role is called Owner.
            #
            # The user has the complete set of space permissions to manage the space,
            # including:
            #
            # - Change the role of other members in the space to member, manager, or
            # owner.
            # - Delete the space.
            #
            # Only supported in
            # {::Google::Apps::Chat::V1::Space::SpaceType SpaceType.SPACE} (named spaces).
            #
            # To learn more, see
            # [Learn more about your role as a space
            # owner or manager](https://support.google.com/chat/answer/11833441).
            ROLE_MANAGER = 2

            # A space manager. In the Chat UI, this role is called Manager.
            #
            # The user has all basic permissions of `ROLE_MEMBER`,
            # and can be granted a subset of administrative permissions by an owner.
            # By default, managers have all the permissions of an owner except for the
            # ability to:
            #
            # - Delete the space.
            # - Make another space member an owner.
            # - Change an owner's role.
            #
            # By default, managers permissions include but aren't limited to:
            #
            # - Make another member a manager.
            # - Delete messages in the space.
            # - Manage space permissions.
            # - Receive notifications for requests to join the space if the manager
            #   has the "manage members" permission in the space settings.
            # - Make a space discoverable.
            #
            # Only supported in
            # {::Google::Apps::Chat::V1::Space::SpaceType SpaceType.SPACE} (named spaces).
            #
            # To learn more, see
            # [Manage space settings](https://support.google.com/chat/answer/13340792).
            ROLE_ASSISTANT_MANAGER = 4
          end
        end

        # Request message for creating a membership.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the space for which to create the
        #     membership.
        #
        #     Format: spaces/\\{space}
        # @!attribute [rw] membership
        #   @return [::Google::Apps::Chat::V1::Membership]
        #     Required. The membership relation to create.
        #
        #     The `memberType` field must contain a user with the `user.name` and
        #     `user.type` fields populated. The server will assign a resource name
        #     and overwrite anything specified.
        #
        #     When a Chat app creates a membership relation for a human user, it must use
        #     certain authorization scopes and set specific values for certain fields:
        #
        #     - When [authenticating as a
        #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
        #     the `chat.memberships` authorization scope is required.
        #
        #     - When [authenticating as an
        #     app](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app),
        #     the `chat.app.memberships` authorization scope is required.
        #
        #     - Set `user.type` to `HUMAN`, and set `user.name` with format
        #     `users/{user}`, where `{user}` can be the email address for the user. For
        #     users in the same Workspace organization `{user}` can also be the `id` of
        #     the [person](https://developers.google.com/people/api/rest/v1/people) from
        #     the People API, or the `id` for the user in the Directory API. For example,
        #     if the People API Person profile ID for `user@example.com` is `123456789`,
        #     you can add the user to the space by setting the `membership.member.name`
        #     to `users/user@example.com` or `users/123456789`.
        #
        #     Inviting users external to the Workspace organization that owns the space
        #     requires [user
        #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
        #
        #     When a Chat app creates a membership relation for itself, it must
        #     [authenticate as a
        #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
        #     and use the `chat.memberships.app` scope, set `user.type` to `BOT`, and set
        #     `user.name` to `users/app`.
        # @!attribute [rw] use_admin_access
        #   @return [::Boolean]
        #     Optional. When `true`, the method runs using the user's Google Workspace
        #     administrator privileges.
        #
        #     The calling user must be a Google Workspace administrator with the
        #     [manage chat and spaces conversations
        #     privilege](https://support.google.com/a/answer/13369245).
        #
        #     Requires the `chat.admin.memberships` [OAuth 2.0
        #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
        #
        #     Creating app memberships or creating memberships for users outside the
        #     administrator's Google Workspace organization isn't supported using admin
        #     access.
        class CreateMembershipRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a membership.
        # @!attribute [rw] membership
        #   @return [::Google::Apps::Chat::V1::Membership]
        #     Required. The membership to update. Only fields specified by `update_mask`
        #     are updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The field paths to update. Separate multiple values with commas
        #     or use `*` to update all field paths.
        #
        #     Currently supported field paths:
        #
        #     - `role`
        # @!attribute [rw] use_admin_access
        #   @return [::Boolean]
        #     Optional. When `true`, the method runs using the user's Google Workspace
        #     administrator privileges.
        #
        #     The calling user must be a Google Workspace administrator with the
        #     [manage chat and spaces conversations
        #     privilege](https://support.google.com/a/answer/13369245).
        #
        #     Requires the `chat.admin.memberships` [OAuth 2.0
        #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
        class UpdateMembershipRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing memberships.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the space for which to fetch a membership
        #     list.
        #
        #     Format: spaces/\\{space}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of memberships to return. The service might
        #     return fewer than this value.
        #
        #     If unspecified, at most 100 memberships are returned.
        #
        #     The maximum value is 1000. If you use a value more than 1000, it's
        #     automatically changed to 1000.
        #
        #     Negative values return an `INVALID_ARGUMENT` error.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous call to list memberships.
        #     Provide this parameter to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided should match the call that
        #     provided the page token. Passing different values to the other parameters
        #     might lead to unexpected results.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A query filter.
        #
        #     You can filter memberships by a member's role
        #     ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
        #     and type
        #     ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
        #
        #     To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
        #
        #     To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
        #     filter for `member.type` using the `!=` operator.
        #
        #     To filter by both role and type, use the `AND` operator. To filter by
        #     either role or type, use the `OR` operator.
        #
        #     Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
        #     when `use_admin_access` is set to true. Other member type filters will be
        #     rejected.
        #
        #     For example, the following queries are valid:
        #
        #     ```
        #     role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
        #     member.type = "HUMAN" AND role = "ROLE_MANAGER"
        #
        #     member.type != "BOT"
        #     ```
        #
        #     The following queries are invalid:
        #
        #     ```
        #     member.type = "HUMAN" AND member.type = "BOT"
        #     role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
        #     ```
        #
        #     Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
        #     error.
        # @!attribute [rw] show_groups
        #   @return [::Boolean]
        #     Optional. When `true`, also returns memberships associated with a
        #     {::Google::Apps::Chat::V1::Membership#group_member Google Group}, in
        #     addition to other types of memberships. If a
        #     {::Google::Apps::Chat::V1::ListMembershipsRequest#filter filter} is set,
        #     {::Google::Apps::Chat::V1::Membership#group_member Google Group}
        #     memberships that don't match the filter criteria aren't returned.
        # @!attribute [rw] show_invited
        #   @return [::Boolean]
        #     Optional. When `true`, also returns memberships associated with
        #     {::Google::Apps::Chat::V1::Membership::MembershipState::INVITED invited} members, in
        #     addition to other types of memberships. If a
        #     filter is set,
        #     {::Google::Apps::Chat::V1::Membership::MembershipState::INVITED invited} memberships
        #     that don't match the filter criteria aren't returned.
        #
        #     Currently requires [user
        #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
        # @!attribute [rw] use_admin_access
        #   @return [::Boolean]
        #     Optional. When `true`, the method runs using the user's Google Workspace
        #     administrator privileges.
        #
        #     The calling user must be a Google Workspace administrator with the
        #     [manage chat and spaces conversations
        #     privilege](https://support.google.com/a/answer/13369245).
        #
        #     Requires either the `chat.admin.memberships.readonly` or
        #     `chat.admin.memberships` [OAuth 2.0
        #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
        #
        #     Listing app memberships in a space isn't supported when using admin access.
        class ListMembershipsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to list memberships of the space.
        # @!attribute [rw] memberships
        #   @return [::Array<::Google::Apps::Chat::V1::Membership>]
        #     Unordered list. List of memberships in the requested (or first) page.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that you can send as `pageToken` to retrieve the next page of
        #     results. If empty, there are no subsequent pages.
        class ListMembershipsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a membership of a space.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the membership to retrieve.
        #
        #     To get the app's own membership [by using user
        #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
        #     you can optionally use `spaces/{space}/members/app`.
        #
        #     Format: `spaces/{space}/members/{member}` or `spaces/{space}/members/app`
        #
        #     You can use the user's email as an alias for `{member}`. For example,
        #     `spaces/{space}/members/example@gmail.com` where `example@gmail.com` is the
        #     email of the Google Chat user.
        # @!attribute [rw] use_admin_access
        #   @return [::Boolean]
        #     Optional. When `true`, the method runs using the user's Google Workspace
        #     administrator privileges.
        #
        #     The calling user must be a Google Workspace administrator with the
        #     [manage chat and spaces conversations
        #     privilege](https://support.google.com/a/answer/13369245).
        #
        #     Requires the `chat.admin.memberships` or `chat.admin.memberships.readonly`
        #     [OAuth 2.0
        #     scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
        #
        #     Getting app memberships in a space isn't supported when using admin access.
        class GetMembershipRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to delete a membership in a space.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the membership to delete. Chat apps can delete
        #     human users' or their own memberships. Chat apps can't delete other apps'
        #     memberships.
        #
        #     When deleting a human membership, requires the `chat.memberships` scope
        #     with [user
        #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
        #     or the `chat.memberships.app` scope with [app
        #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
        #     and the `spaces/{space}/members/{member}` format.
        #     You can use the email as an alias for `{member}`. For example,
        #     `spaces/{space}/members/example@gmail.com` where `example@gmail.com` is the
        #     email of the Google Chat user.
        #
        #     When deleting an app membership, requires the `chat.memberships.app` scope
        #     and `spaces/{space}/members/app` format.
        #
        #     Format: `spaces/{space}/members/{member}` or `spaces/{space}/members/app`.
        # @!attribute [rw] use_admin_access
        #   @return [::Boolean]
        #     Optional. When `true`, the method runs using the user's Google Workspace
        #     administrator privileges.
        #
        #     The calling user must be a Google Workspace administrator with the
        #     [manage chat and spaces conversations
        #     privilege](https://support.google.com/a/answer/13369245).
        #
        #     Requires the `chat.admin.memberships` [OAuth 2.0
        #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
        #
        #     Deleting app memberships in a space isn't supported using admin access.
        class DeleteMembershipRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
