# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # Event payload for a new membership.
        #
        # Event type: `google.workspace.chat.membership.v1.created`.
        # @!attribute [rw] membership
        #   @return [::Google::Apps::Chat::V1::Membership]
        #     The new membership.
        class MembershipCreatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for a deleted membership.
        #
        # Event type: `google.workspace.chat.membership.v1.deleted`
        # @!attribute [rw] membership
        #   @return [::Google::Apps::Chat::V1::Membership]
        #     The deleted membership. Only the `name` and `state` fields are populated.
        class MembershipDeletedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for an updated membership.
        #
        # Event type: `google.workspace.chat.membership.v1.updated`
        # @!attribute [rw] membership
        #   @return [::Google::Apps::Chat::V1::Membership]
        #     The updated membership.
        class MembershipUpdatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple new memberships.
        #
        # Event type: `google.workspace.chat.membership.v1.batchCreated`
        # @!attribute [rw] memberships
        #   @return [::Array<::Google::Apps::Chat::V1::MembershipCreatedEventData>]
        #     A list of new memberships.
        class MembershipBatchCreatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple updated memberships.
        #
        # Event type: `google.workspace.chat.membership.v1.batchUpdated`
        # @!attribute [rw] memberships
        #   @return [::Array<::Google::Apps::Chat::V1::MembershipUpdatedEventData>]
        #     A list of updated memberships.
        class MembershipBatchUpdatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple deleted memberships.
        #
        # Event type: `google.workspace.chat.membership.v1.batchDeleted`
        # @!attribute [rw] memberships
        #   @return [::Array<::Google::Apps::Chat::V1::MembershipDeletedEventData>]
        #     A list of deleted memberships.
        class MembershipBatchDeletedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for a new message.
        #
        # Event type: `google.workspace.chat.message.v1.created`
        # @!attribute [rw] message
        #   @return [::Google::Apps::Chat::V1::Message]
        #     The new message.
        class MessageCreatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for an updated message.
        #
        # Event type: `google.workspace.chat.message.v1.updated`
        # @!attribute [rw] message
        #   @return [::Google::Apps::Chat::V1::Message]
        #     The updated message.
        class MessageUpdatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for a deleted message.
        #
        # Event type: `google.workspace.chat.message.v1.deleted`
        # @!attribute [rw] message
        #   @return [::Google::Apps::Chat::V1::Message]
        #     The deleted message. Only the `name`, `createTime`, and
        #     `deletionMetadata` fields are populated.
        class MessageDeletedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple new messages.
        #
        # Event type: `google.workspace.chat.message.v1.batchCreated`
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Apps::Chat::V1::MessageCreatedEventData>]
        #     A list of new messages.
        class MessageBatchCreatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple updated messages.
        #
        # Event type: `google.workspace.chat.message.v1.batchUpdated`
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Apps::Chat::V1::MessageUpdatedEventData>]
        #     A list of updated messages.
        class MessageBatchUpdatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple deleted messages.
        #
        # Event type: `google.workspace.chat.message.v1.batchDeleted`
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Apps::Chat::V1::MessageDeletedEventData>]
        #     A list of deleted messages.
        class MessageBatchDeletedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for an updated space.
        #
        # Event type: `google.workspace.chat.space.v1.updated`
        # @!attribute [rw] space
        #   @return [::Google::Apps::Chat::V1::Space]
        #     The updated space.
        class SpaceUpdatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple updates to a space.
        #
        # Event type: `google.workspace.chat.space.v1.batchUpdated`
        # @!attribute [rw] spaces
        #   @return [::Array<::Google::Apps::Chat::V1::SpaceUpdatedEventData>]
        #     A list of updated spaces.
        class SpaceBatchUpdatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for a new reaction.
        #
        # Event type: `google.workspace.chat.reaction.v1.created`
        # @!attribute [rw] reaction
        #   @return [::Google::Apps::Chat::V1::Reaction]
        #     The new reaction.
        class ReactionCreatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for a deleted reaction.
        #
        # Type: `google.workspace.chat.reaction.v1.deleted`
        # @!attribute [rw] reaction
        #   @return [::Google::Apps::Chat::V1::Reaction]
        #     The deleted reaction.
        class ReactionDeletedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple new reactions.
        #
        # Event type: `google.workspace.chat.reaction.v1.batchCreated`
        # @!attribute [rw] reactions
        #   @return [::Array<::Google::Apps::Chat::V1::ReactionCreatedEventData>]
        #     A list of new reactions.
        class ReactionBatchCreatedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event payload for multiple deleted reactions.
        #
        # Event type: `google.workspace.chat.reaction.v1.batchDeleted`
        # @!attribute [rw] reactions
        #   @return [::Array<::Google::Apps::Chat::V1::ReactionDeletedEventData>]
        #     A list of deleted reactions.
        class ReactionBatchDeletedEventData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
