# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # Information about a deleted message. A message is deleted when `delete_time`
        # is set.
        # @!attribute [rw] deletion_type
        #   @return [::Google::Apps::Chat::V1::DeletionMetadata::DeletionType]
        #     Indicates who deleted the message.
        class DeletionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Who deleted the message and how it was deleted. More values may be added in
          # the future. See [Edit or delete a message in Google
          # Chat](https://support.google.com/chat/answer/7653281) for details on when
          # messages can be deleted.
          module DeletionType
            # This value is unused.
            DELETION_TYPE_UNSPECIFIED = 0

            # User deleted their own message.
            CREATOR = 1

            # An owner or manager deleted the message.
            SPACE_OWNER = 2

            # A Google Workspace administrator deleted the message. Administrators can
            # delete any message in the space, including messages sent by any space
            # member or Chat app.
            ADMIN = 3

            # A Chat app deleted its own message when it expired.
            APP_MESSAGE_EXPIRY = 4

            # A Chat app deleted the message on behalf of the creator (using user
            # authentication).
            CREATOR_VIA_APP = 5

            # A Chat app deleted the message on behalf of a space manager (using user
            # authentication).
            SPACE_OWNER_VIA_APP = 6

            # A member of the space deleted the message. Users can delete messages sent
            # by apps.
            SPACE_MEMBER = 7
          end
        end
      end
    end
  end
end
