# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # The markup for developers to specify the contents of a contextual AddOn.
        class ContextualAddOnMarkup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A card is a UI element that can contain UI widgets such as text and
          # images.
          # @!attribute [rw] header
          #   @return [::Google::Apps::Chat::V1::ContextualAddOnMarkup::Card::CardHeader]
          #     The header of the card. A header usually contains a title and an image.
          # @!attribute [rw] sections
          #   @return [::Array<::Google::Apps::Chat::V1::ContextualAddOnMarkup::Card::Section>]
          #     Sections are separated by a line divider.
          # @!attribute [rw] card_actions
          #   @return [::Array<::Google::Apps::Chat::V1::ContextualAddOnMarkup::Card::CardAction>]
          #     The actions of this card.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the card.
          class Card
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] title
            #   @return [::String]
            #     The title must be specified. The header has a fixed height: if both a
            #     title and subtitle is specified, each takes up one line. If only the
            #     title is specified, it takes up both lines.
            # @!attribute [rw] subtitle
            #   @return [::String]
            #     The subtitle of the card header.
            # @!attribute [rw] image_style
            #   @return [::Google::Apps::Chat::V1::ContextualAddOnMarkup::Card::CardHeader::ImageStyle]
            #     The image's type (for example, square border or circular border).
            # @!attribute [rw] image_url
            #   @return [::String]
            #     The URL of the image in the card header.
            class CardHeader
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              module ImageStyle
                IMAGE_STYLE_UNSPECIFIED = 0

                # Square border.
                IMAGE = 1

                # Circular border.
                AVATAR = 2
              end
            end

            # A section contains a collection of widgets that are rendered
            # (vertically) in the order that they are specified. Across all platforms,
            # cards have a narrow fixed width, so
            # there's currently no need for layout properties (for example, float).
            # @!attribute [rw] header
            #   @return [::String]
            #     The header of the section. Formatted text is
            #     supported. For more information
            #     about formatting text, see
            #     [Formatting text in Google Chat
            #     apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
            #     and
            #     [Formatting
            #     text in Google Workspace
            #     Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
            # @!attribute [rw] widgets
            #   @return [::Array<::Google::Apps::Chat::V1::WidgetMarkup>]
            #     A section must contain at least one widget.
            class Section
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A card action is
            # the action associated with the card. For an invoice card, a
            # typical action would be: delete invoice, email invoice or open the
            # invoice in browser.
            #
            # Not supported by Google Chat apps.
            # @!attribute [rw] action_label
            #   @return [::String]
            #     The label used to be displayed in the action menu item.
            # @!attribute [rw] on_click
            #   @return [::Google::Apps::Chat::V1::WidgetMarkup::OnClick]
            #     The onclick action for this action item.
            class CardAction
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
