# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # An attachment in Google Chat.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the attachment.
        #
        #     Format: `spaces/{space}/messages/{message}/attachments/{attachment}`.
        # @!attribute [r] content_name
        #   @return [::String]
        #     Output only. The original file name for the content, not the full path.
        # @!attribute [r] content_type
        #   @return [::String]
        #     Output only. The content type (MIME type) of the file.
        # @!attribute [rw] attachment_data_ref
        #   @return [::Google::Apps::Chat::V1::AttachmentDataRef]
        #     Optional. A reference to the attachment data. This field is used to
        #     create or update messages with attachments, or with the media API to
        #     download the attachment data.
        #
        #     Note: The following fields are mutually exclusive: `attachment_data_ref`, `drive_data_ref`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] drive_data_ref
        #   @return [::Google::Apps::Chat::V1::DriveDataRef]
        #     Output only. A reference to the Google Drive attachment. This field is
        #     used with the Google Drive API.
        #
        #     Note: The following fields are mutually exclusive: `drive_data_ref`, `attachment_data_ref`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] thumbnail_uri
        #   @return [::String]
        #     Output only. The thumbnail URL which should be used to preview the
        #     attachment to a human user. Chat apps shouldn't use this URL to download
        #     attachment content.
        # @!attribute [r] download_uri
        #   @return [::String]
        #     Output only. The download URL which should be used to allow a human user to
        #     download the attachment. Chat apps shouldn't use this URL to download
        #     attachment content.
        # @!attribute [r] source
        #   @return [::Google::Apps::Chat::V1::Attachment::Source]
        #     Output only. The source of the attachment.
        class Attachment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The source of the attachment.
          module Source
            # Reserved.
            SOURCE_UNSPECIFIED = 0

            # The file is a Google Drive file.
            DRIVE_FILE = 1

            # The file is uploaded to Chat.
            UPLOADED_CONTENT = 2
          end
        end

        # A reference to the data of a drive attachment.
        # @!attribute [rw] drive_file_id
        #   @return [::String]
        #     The ID for the drive file. Use with the Drive API.
        class DriveDataRef
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A reference to the attachment data.
        # @!attribute [rw] resource_name
        #   @return [::String]
        #     Optional. The resource name of the attachment data. This field is used with
        #     the media API to download the attachment data.
        # @!attribute [rw] attachment_upload_token
        #   @return [::String]
        #     Optional. Opaque token containing a reference to an uploaded attachment.
        #     Treated by clients as an opaque string and used to create or update Chat
        #     messages with attachments.
        class AttachmentDataRef
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get an attachment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the attachment, in the form
        #     `spaces/{space}/messages/{message}/attachments/{attachment}`.
        class GetAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to upload an attachment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the Chat space in which the attachment is
        #     uploaded. Format "spaces/\\{space}".
        # @!attribute [rw] filename
        #   @return [::String]
        #     Required. The filename of the attachment, including the file extension.
        class UploadAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of uploading an attachment.
        # @!attribute [rw] attachment_data_ref
        #   @return [::Google::Apps::Chat::V1::AttachmentDataRef]
        #     Reference to the uploaded attachment.
        class UploadAttachmentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
