# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Chat
      module V1
        # Output only. Annotations can be associated with the plain-text body of the
        # message or with chips that link to Google Workspace resources like Google
        # Docs or Sheets with `start_index` and `length` of 0. To add basic formatting
        # to a text message, see [Format text
        # messages](https://developers.google.com/workspace/chat/format-messages).
        #
        # Example plain-text message body:
        # ```
        # Hello @FooBot how are you!"
        # ```
        #
        # The corresponding annotations metadata:
        # ```
        # "annotations":[{
        #   "type":"USER_MENTION",
        #   "startIndex":6,
        #   "length":7,
        #   "userMention": {
        #     "user": {
        #       "name":"users/\\{user}",
        #       "displayName":"FooBot",
        #       "avatarUrl":"https://goo.gl/aeDtrS",
        #       "type":"BOT"
        #     },
        #     "type":"MENTION"
        #    }
        # }]
        # ```
        # @!attribute [rw] type
        #   @return [::Google::Apps::Chat::V1::AnnotationType]
        #     The type of this annotation.
        # @!attribute [rw] start_index
        #   @return [::Integer]
        #     Start index (0-based, inclusive) in the plain-text message body this
        #     annotation corresponds to.
        # @!attribute [rw] length
        #   @return [::Integer]
        #     Length of the substring in the plain-text message body this annotation
        #     corresponds to. If not present, indicates a length of 0.
        # @!attribute [rw] user_mention
        #   @return [::Google::Apps::Chat::V1::UserMentionMetadata]
        #     The metadata of user mention.
        #
        #     Note: The following fields are mutually exclusive: `user_mention`, `slash_command`, `rich_link_metadata`, `custom_emoji_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] slash_command
        #   @return [::Google::Apps::Chat::V1::SlashCommandMetadata]
        #     The metadata for a slash command.
        #
        #     Note: The following fields are mutually exclusive: `slash_command`, `user_mention`, `rich_link_metadata`, `custom_emoji_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] rich_link_metadata
        #   @return [::Google::Apps::Chat::V1::RichLinkMetadata]
        #     The metadata for a rich link.
        #
        #     Note: The following fields are mutually exclusive: `rich_link_metadata`, `user_mention`, `slash_command`, `custom_emoji_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] custom_emoji_metadata
        #   @return [::Google::Apps::Chat::V1::CustomEmojiMetadata]
        #     The metadata for a custom emoji.
        #
        #     Note: The following fields are mutually exclusive: `custom_emoji_metadata`, `user_mention`, `slash_command`, `rich_link_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Annotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Annotation metadata for user mentions (@).
        # @!attribute [rw] user
        #   @return [::Google::Apps::Chat::V1::User]
        #     The user mentioned.
        # @!attribute [rw] type
        #   @return [::Google::Apps::Chat::V1::UserMentionMetadata::Type]
        #     The type of user mention.
        class UserMentionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          module Type
            # Default value for the enum. Don't use.
            TYPE_UNSPECIFIED = 0

            # Add user to space.
            ADD = 1

            # Mention user in space.
            MENTION = 2
          end
        end

        # Annotation metadata for slash commands (/).
        # @!attribute [rw] bot
        #   @return [::Google::Apps::Chat::V1::User]
        #     The Chat app whose command was invoked.
        # @!attribute [rw] type
        #   @return [::Google::Apps::Chat::V1::SlashCommandMetadata::Type]
        #     The type of slash command.
        # @!attribute [rw] command_name
        #   @return [::String]
        #     The name of the invoked slash command.
        # @!attribute [rw] command_id
        #   @return [::Integer]
        #     The command ID of the invoked slash command.
        # @!attribute [rw] triggers_dialog
        #   @return [::Boolean]
        #     Indicates whether the slash command is for a dialog.
        class SlashCommandMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          module Type
            # Default value for the enum. Don't use.
            TYPE_UNSPECIFIED = 0

            # Add Chat app to space.
            ADD = 1

            # Invoke slash command in space.
            INVOKE = 2
          end
        end

        # A rich link to a resource. Rich links can be associated with the plain-text
        # body of the message or represent chips that link to Google Workspace
        # resources like Google Docs or Sheets with `start_index` and `length`
        # of 0.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of this link.
        # @!attribute [rw] rich_link_type
        #   @return [::Google::Apps::Chat::V1::RichLinkMetadata::RichLinkType]
        #     The rich link type.
        # @!attribute [rw] drive_link_data
        #   @return [::Google::Apps::Chat::V1::DriveLinkData]
        #     Data for a drive link.
        #
        #     Note: The following fields are mutually exclusive: `drive_link_data`, `chat_space_link_data`, `meet_space_link_data`, `calendar_event_link_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] chat_space_link_data
        #   @return [::Google::Apps::Chat::V1::ChatSpaceLinkData]
        #     Data for a chat space link.
        #
        #     Note: The following fields are mutually exclusive: `chat_space_link_data`, `drive_link_data`, `meet_space_link_data`, `calendar_event_link_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] meet_space_link_data
        #   @return [::Google::Apps::Chat::V1::MeetSpaceLinkData]
        #     Data for a Meet space link.
        #
        #     Note: The following fields are mutually exclusive: `meet_space_link_data`, `drive_link_data`, `chat_space_link_data`, `calendar_event_link_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] calendar_event_link_data
        #   @return [::Google::Apps::Chat::V1::CalendarEventLinkData]
        #     Data for a Calendar event link.
        #
        #     Note: The following fields are mutually exclusive: `calendar_event_link_data`, `drive_link_data`, `chat_space_link_data`, `meet_space_link_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RichLinkMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The rich link type. More types might be added in the future.
          module RichLinkType
            # Default value for the enum. Don't use.
            RICH_LINK_TYPE_UNSPECIFIED = 0

            # A Google Drive rich link type.
            DRIVE_FILE = 1

            # A Chat space rich link type. For example, a space smart chip.
            CHAT_SPACE = 2

            # A Gmail message rich link type. Specifically, a Gmail chip from [Share to
            # Chat](https://support.google.com/chat?p=chat_gmail). The API only
            # supports reading messages with GMAIL_MESSAGE rich links.
            GMAIL_MESSAGE = 3

            # A Meet message rich link type. For example, a Meet chip.
            MEET_SPACE = 4

            # A Calendar message rich link type. For example, a Calendar chip.
            CALENDAR_EVENT = 5
          end
        end

        # Annotation metadata for custom emoji.
        # @!attribute [rw] custom_emoji
        #   @return [::Google::Apps::Chat::V1::CustomEmoji]
        #     The custom emoji.
        class CustomEmojiMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Data for Google Drive links.
        # @!attribute [rw] drive_data_ref
        #   @return [::Google::Apps::Chat::V1::DriveDataRef]
        #     A
        #     [DriveDataRef](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments#drivedataref)
        #     which references a Google Drive file.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     The mime type of the linked Google Drive resource.
        class DriveLinkData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Data for Chat space links.
        # @!attribute [rw] space
        #   @return [::String]
        #     The space of the linked Chat space resource.
        #
        #     Format: `spaces/{space}`
        # @!attribute [rw] thread
        #   @return [::String]
        #     The thread of the linked Chat space resource.
        #
        #     Format: `spaces/{space}/threads/{thread}`
        # @!attribute [rw] message
        #   @return [::String]
        #     The message of the linked Chat space resource.
        #
        #     Format: `spaces/{space}/messages/{message}`
        class ChatSpaceLinkData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Data for Meet space links.
        # @!attribute [rw] meeting_code
        #   @return [::String]
        #     Meeting code of the linked Meet space.
        # @!attribute [rw] type
        #   @return [::Google::Apps::Chat::V1::MeetSpaceLinkData::Type]
        #     Indicates the type of the Meet space.
        # @!attribute [r] huddle_status
        #   @return [::Google::Apps::Chat::V1::MeetSpaceLinkData::HuddleStatus]
        #     Optional. Output only. If the Meet is a Huddle, indicates the status of the
        #     huddle. Otherwise, this is unset.
        class MeetSpaceLinkData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the Meet space.
          module Type
            # Default value for the enum. Don't use.
            TYPE_UNSPECIFIED = 0

            # The Meet space is a meeting.
            MEETING = 1

            # The Meet space is a huddle.
            HUDDLE = 2
          end

          # The status of the huddle
          module HuddleStatus
            # Default value for the enum. Don't use.
            HUDDLE_STATUS_UNSPECIFIED = 0

            # The huddle has started.
            STARTED = 1

            # The huddle has ended. In this case the Meet space URI and identifiers
            # will no longer be valid.
            ENDED = 2

            # The huddle has been missed. In this case the Meet space URI and
            # identifiers will no longer be valid.
            MISSED = 3
          end
        end

        # Data for Calendar event links.
        # @!attribute [rw] calendar_id
        #   @return [::String]
        #     The [Calendar
        #     identifier](https://developers.google.com/workspace/calendar/api/v3/reference/calendars)
        #     of the linked Calendar.
        # @!attribute [rw] event_id
        #   @return [::String]
        #     The [Event
        #     identifier](https://developers.google.com/workspace/calendar/api/v3/reference/events)
        #     of the linked Calendar event.
        class CalendarEventLinkData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Type of the annotation.
        module AnnotationType
          # Default value for the enum. Don't use.
          ANNOTATION_TYPE_UNSPECIFIED = 0

          # A user is mentioned.
          USER_MENTION = 1

          # A slash command is invoked.
          SLASH_COMMAND = 2

          # A rich link annotation.
          RICH_LINK = 3

          # A custom emoji annotation.
          CUSTOM_EMOJI = 4
        end
      end
    end
  end
end
