# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Card
      module V1
        # A card interface displayed in a Google Chat message or Google Workspace
        # add-on.
        #
        # Cards support a defined layout, interactive UI elements like buttons, and
        # rich media like images. Use cards to present detailed information,
        # gather information from users, and guide users to take a next step.
        #
        # [Card builder](https://addons.gsuite.google.com/uikit/builder)
        #
        # To learn how
        # to build cards, see the following documentation:
        #
        # * For Google Chat apps, see [Design the components of a card or
        #   dialog](https://developers.google.com/workspace/chat/design-components-card-dialog).
        # * For Google Workspace add-ons, see [Card-based
        # interfaces](https://developers.google.com/apps-script/add-ons/concepts/cards).
        #
        # Note: You can add up to 100 widgets per card. Any widgets beyond this
        # limit are ignored. This limit applies to both card messages and dialogs
        # in Google Chat apps, and to cards in Google Workspace add-ons.
        #
        # **Example: Card message for a Google Chat app**
        #
        # ![Example contact
        # card](https://developers.google.com/workspace/chat/images/card_api_reference.png)
        #
        # To create the sample card message in Google Chat, use the following JSON:
        #
        # ```
        # {
        #   "cardsV2": [
        #     {
        #       "cardId": "unique-card-id",
        #       "card": {
        #         "header": {
        #            "title": "Sasha",
        #            "subtitle": "Software Engineer",
        #            "imageUrl":
        #            "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
        #            "imageType": "CIRCLE",
        #            "imageAltText": "Avatar for Sasha"
        #          },
        #          "sections": [
        #            {
        #              "header": "Contact Info",
        #              "collapsible": true,
        #              "uncollapsibleWidgetsCount": 1,
        #              "widgets": [
        #                {
        #                  "decoratedText": {
        #                    "startIcon": {
        #                      "knownIcon": "EMAIL"
        #                    },
        #                    "text": "sasha@example.com"
        #                  }
        #                },
        #                {
        #                  "decoratedText": {
        #                    "startIcon": {
        #                      "knownIcon": "PERSON"
        #                    },
        #                    "text": "<font color=\"#80e27e\">Online</font>"
        #                  }
        #                },
        #                {
        #                  "decoratedText": {
        #                    "startIcon": {
        #                      "knownIcon": "PHONE"
        #                    },
        #                    "text": "+1 (555) 555-1234"
        #                  }
        #                },
        #                {
        #                  "buttonList": {
        #                    "buttons": [
        #                      {
        #                        "text": "Share",
        #                        "onClick": {
        #                         "openLink": {
        #                            "url": "https://example.com/share"
        #                          }
        #                        }
        #                      },
        #                      {
        #                        "text": "Edit",
        #                        "onClick": {
        #                          "action": {
        #                            "function": "goToView",
        #                            "parameters": [
        #                              {
        #                                "key": "viewType",
        #                                "value": "EDIT"
        #                              }
        #                            ]
        #                          }
        #                        }
        #                      }
        #                    ]
        #                  }
        #                }
        #              ]
        #            }
        #          ]
        #        }
        #     }
        #   ]
        # }
        # ```
        # @!attribute [rw] header
        #   @return [::Google::Apps::Card::V1::Card::CardHeader]
        #     The header of the card. A header usually contains a leading image and a
        #     title. Headers always appear at the top of a card.
        # @!attribute [rw] sections
        #   @return [::Array<::Google::Apps::Card::V1::Card::Section>]
        #     Contains a collection of widgets. Each section has its own, optional
        #     header. Sections are visually separated by a line divider. For an example
        #     in Google Chat apps, see [Define a section of a
        #     card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
        # @!attribute [rw] section_divider_style
        #   @return [::Google::Apps::Card::V1::Card::DividerStyle]
        #     The divider style between the header, sections and footer.
        # @!attribute [rw] card_actions
        #   @return [::Array<::Google::Apps::Card::V1::Card::CardAction>]
        #     The card's actions. Actions are added to the card's toolbar menu.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        #
        #     For example, the following JSON constructs a card action menu with
        #     `Settings` and `Send Feedback` options:
        #
        #     ```
        #     "card_actions": [
        #       {
        #         "actionLabel": "Settings",
        #         "onClick": {
        #           "action": {
        #             "functionName": "goToView",
        #             "parameters": [
        #               {
        #                 "key": "viewType",
        #                 "value": "SETTING"
        #              }
        #             ],
        #             "loadIndicator": "LoadIndicator.SPINNER"
        #           }
        #         }
        #       },
        #       {
        #         "actionLabel": "Send Feedback",
        #         "onClick": {
        #           "openLink": {
        #             "url": "https://example.com/feedback"
        #           }
        #         }
        #       }
        #     ]
        #     ```
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the card. Used as a card identifier in card navigation.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        # @!attribute [rw] fixed_footer
        #   @return [::Google::Apps::Card::V1::Card::CardFixedFooter]
        #     The fixed footer shown at the bottom of this card.
        #
        #     Setting `fixedFooter` without specifying a `primaryButton` or a
        #     `secondaryButton` causes an error. For Chat apps, you can use fixed footers
        #     in
        #     [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
        #     [card
        #     messages](https://developers.google.com/workspace/chat/create-messages#create).
        #
        #     [Google Workspace add-ons and Chat
        #     apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] display_style
        #   @return [::Google::Apps::Card::V1::Card::DisplayStyle]
        #     In Google Workspace add-ons, sets the display properties of the
        #     `peekCardHeader`.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        # @!attribute [rw] peek_card_header
        #   @return [::Google::Apps::Card::V1::Card::CardHeader]
        #     When displaying contextual content, the peek card header acts as a
        #     placeholder so that the user can navigate forward between the homepage
        #     cards and the contextual cards.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        class Card
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a card header. For an example in Google Chat apps, see [Add a
          # header](https://developers.google.com/workspace/chat/design-components-card-dialog#add_a_header).
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] title
          #   @return [::String]
          #     Required. The title of the card header.
          #     The header has a fixed height: if both a
          #     title and subtitle are specified, each takes up one line. If only the
          #     title is specified, it takes up both lines.
          # @!attribute [rw] subtitle
          #   @return [::String]
          #     The subtitle of the card header. If specified, appears on its own line
          #     below the `title`.
          # @!attribute [rw] image_type
          #   @return [::Google::Apps::Card::V1::Widget::ImageType]
          #     The shape used to crop the image.
          #
          #     [Google Workspace add-ons and Chat
          #     apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] image_url
          #   @return [::String]
          #     The HTTPS URL of the image in the card header.
          # @!attribute [rw] image_alt_text
          #   @return [::String]
          #     The alternative text of this image that's used for accessibility.
          class CardHeader
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A section contains a collection of widgets that are rendered
          # vertically in the order that they're specified.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] header
          #   @return [::String]
          #     Text that appears at the top of a section.
          #     Supports simple HTML formatted text. For more information
          #     about formatting text, see
          #     [Formatting text in Google Chat
          #     apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
          #     and
          #     [Formatting
          #     text in Google Workspace
          #     add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
          # @!attribute [rw] widgets
          #   @return [::Array<::Google::Apps::Card::V1::Widget>]
          #     All the widgets in the section.
          #     Must contain at least one widget.
          # @!attribute [rw] collapsible
          #   @return [::Boolean]
          #     Indicates whether this section is collapsible.
          #
          #     Collapsible sections hide some or all widgets, but users can expand the
          #     section to reveal the hidden widgets by clicking **Show more**. Users
          #     can hide the widgets again by clicking **Show less**.
          #
          #     To determine which widgets are hidden, specify
          #     `uncollapsibleWidgetsCount`.
          # @!attribute [rw] uncollapsible_widgets_count
          #   @return [::Integer]
          #     The number of uncollapsible widgets which remain visible even when a
          #     section is collapsed.
          #
          #     For example, when a section
          #     contains five widgets and the `uncollapsibleWidgetsCount` is set to `2`,
          #     the first two widgets are always shown and the last three are collapsed
          #     by default. The `uncollapsibleWidgetsCount` is taken into account only
          #     when `collapsible` is `true`.
          # @!attribute [rw] collapse_control
          #   @return [::Google::Apps::Card::V1::CollapseControl]
          #     Optional. Define the expand and collapse button of the section.
          #     This button will be shown only if the section is collapsible.
          #     If this field isn't set, the default button is used.
          class Section
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A card action is the action associated with the card. For example,
          # an invoice card might include actions such as delete invoice, email
          # invoice, or open the invoice in a browser.
          #
          # [Google Workspace
          # add-ons](https://developers.google.com/workspace/add-ons):
          # @!attribute [rw] action_label
          #   @return [::String]
          #     The label that displays as the action menu item.
          # @!attribute [rw] on_click
          #   @return [::Google::Apps::Card::V1::OnClick]
          #     The `onClick` action for this action item.
          class CardAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A list of widgets that can be displayed in a containing layout, such
          # as a `CarouselCard`.
          # [Google Chat apps](https://developers.google.com/workspace/chat):
          # @!attribute [rw] text_paragraph
          #   @return [::Google::Apps::Card::V1::TextParagraph]
          #     A text paragraph widget.
          #
          #     Note: The following fields are mutually exclusive: `text_paragraph`, `button_list`, `image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] button_list
          #   @return [::Google::Apps::Card::V1::ButtonList]
          #     A button list widget.
          #
          #     Note: The following fields are mutually exclusive: `button_list`, `text_paragraph`, `image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] image
          #   @return [::Google::Apps::Card::V1::Image]
          #     An image widget.
          #
          #     Note: The following fields are mutually exclusive: `image`, `text_paragraph`, `button_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class NestedWidget
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A persistent (sticky) footer that that appears at the bottom of the card.
          #
          # Setting `fixedFooter` without specifying a `primaryButton` or a
          # `secondaryButton` causes an error.
          #
          # For Chat apps, you can use fixed footers in
          # [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
          # [card
          # messages](https://developers.google.com/workspace/chat/create-messages#create).
          # For an example in Google Chat apps, see [Add a persistent
          # footer](https://developers.google.com/workspace/chat/design-components-card-dialog#add_a_persistent_footer).
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] primary_button
          #   @return [::Google::Apps::Card::V1::Button]
          #     The primary button of the fixed footer. The button must be a text button
          #     with text and color set.
          # @!attribute [rw] secondary_button
          #   @return [::Google::Apps::Card::V1::Button]
          #     The secondary button of the fixed footer.  The button must be a text
          #     button with text and color set.
          #     If `secondaryButton` is set, you must also set `primaryButton`.
          class CardFixedFooter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The divider style of a card. Currently only used for dividers betweens card
          # sections.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          module DividerStyle
            # Don't use. Unspecified.
            DIVIDER_STYLE_UNSPECIFIED = 0

            # Default option. Render a solid divider.
            SOLID_DIVIDER = 1

            # If set, no divider is rendered. This style completely removes the divider
            # from the layout. The result is equivalent to not adding a divider at all.
            NO_DIVIDER = 2
          end

          # In Google Workspace add-ons,
          # determines how a card is displayed.
          #
          # [Google Workspace
          # add-ons](https://developers.google.com/workspace/add-ons):
          module DisplayStyle
            # Don't use. Unspecified.
            DISPLAY_STYLE_UNSPECIFIED = 0

            # The header of the card appears at the bottom of the
            # sidebar, partially covering the current top card of the stack. Clicking
            # the header pops the card into the card stack. If the card has no header,
            # a generated header is used instead.
            PEEK = 1

            # Default value. The card is shown by replacing the view of the top card in
            # the card stack.
            REPLACE = 2
          end
        end

        # Each card is made up of widgets.
        #
        # A widget is a composite object that can represent one of text, images,
        # buttons, and other object types.
        # @!attribute [rw] text_paragraph
        #   @return [::Google::Apps::Card::V1::TextParagraph]
        #     Displays a text paragraph. Supports simple HTML formatted text. For more
        #     information about formatting text, see
        #     [Formatting text in Google Chat
        #     apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
        #     and
        #     [Formatting
        #     text in Google Workspace
        #     add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
        #
        #     For example, the following JSON creates a bolded text:
        #     ```
        #     "textParagraph": {
        #       "text": "  <b>bold text</b>"
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `divider`, `grid`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image
        #   @return [::Google::Apps::Card::V1::Image]
        #     Displays an image.
        #
        #     For example, the following JSON creates an image with alternative text:
        #     ```
        #     "image": {
        #       "imageUrl":
        #       "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
        #       "altText": "Chat app avatar"
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `image`, `text_paragraph`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `divider`, `grid`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] decorated_text
        #   @return [::Google::Apps::Card::V1::DecoratedText]
        #     Displays a decorated text item.
        #
        #     For example, the following JSON creates a decorated text widget showing
        #     email address:
        #
        #     ```
        #     "decoratedText": {
        #       "icon": {
        #         "knownIcon": "EMAIL"
        #       },
        #       "topLabel": "Email Address",
        #       "text": "sasha@example.com",
        #       "bottomLabel": "This is a new Email address!",
        #       "switchControl": {
        #         "name": "has_send_welcome_email_to_sasha",
        #         "selected": false,
        #         "controlType": "CHECKBOX"
        #       }
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `decorated_text`, `text_paragraph`, `image`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `divider`, `grid`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] button_list
        #   @return [::Google::Apps::Card::V1::ButtonList]
        #     A list of buttons.
        #
        #     For example, the following JSON creates two buttons. The first
        #     is a blue text button and the second is an image button that opens a
        #     link:
        #     ```
        #     "buttonList": {
        #       "buttons": [
        #         {
        #           "text": "Edit",
        #           "color": {
        #             "red": 0,
        #             "green": 0,
        #             "blue": 1,
        #           },
        #           "disabled": true,
        #         },
        #         {
        #           "icon": {
        #             "knownIcon": "INVITE",
        #             "altText": "check calendar"
        #           },
        #           "onClick": {
        #             "openLink": {
        #               "url": "https://example.com/calendar"
        #             }
        #           }
        #         }
        #       ]
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `button_list`, `text_paragraph`, `image`, `decorated_text`, `text_input`, `selection_input`, `date_time_picker`, `divider`, `grid`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_input
        #   @return [::Google::Apps::Card::V1::TextInput]
        #     Displays a text box that users can type into.
        #
        #     For example, the following JSON creates a text input for an email
        #     address:
        #
        #     ```
        #     "textInput": {
        #       "name": "mailing_address",
        #       "label": "Mailing Address"
        #     }
        #     ```
        #
        #     As another example, the following JSON creates a text input for a
        #     programming language with static suggestions:
        #     ```
        #     "textInput": {
        #       "name": "preferred_programing_language",
        #       "label": "Preferred Language",
        #       "initialSuggestions": {
        #         "items": [
        #           {
        #             "text": "C++"
        #           },
        #           {
        #             "text": "Java"
        #           },
        #           {
        #             "text": "JavaScript"
        #           },
        #           {
        #             "text": "Python"
        #           }
        #         ]
        #       }
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `text_input`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `selection_input`, `date_time_picker`, `divider`, `grid`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] selection_input
        #   @return [::Google::Apps::Card::V1::SelectionInput]
        #     Displays a selection control that lets users select items. Selection
        #     controls can be checkboxes, radio buttons, switches, or dropdown menus.
        #
        #     For example, the following JSON creates a dropdown menu that lets users
        #     choose a size:
        #
        #     ```
        #     "selectionInput": {
        #       "name": "size",
        #       "label": "Size"
        #       "type": "DROPDOWN",
        #       "items": [
        #         {
        #           "text": "S",
        #           "value": "small",
        #           "selected": false
        #         },
        #         {
        #           "text": "M",
        #           "value": "medium",
        #           "selected": true
        #         },
        #         {
        #           "text": "L",
        #           "value": "large",
        #           "selected": false
        #         },
        #         {
        #           "text": "XL",
        #           "value": "extra_large",
        #           "selected": false
        #         }
        #       ]
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `selection_input`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `date_time_picker`, `divider`, `grid`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] date_time_picker
        #   @return [::Google::Apps::Card::V1::DateTimePicker]
        #     Displays a widget that lets users input a date, time, or date and time.
        #
        #     For example, the following JSON creates a date time picker to schedule an
        #     appointment:
        #
        #
        #     ```
        #     "dateTimePicker": {
        #       "name": "appointment_time",
        #       "label": "Book your appointment at:",
        #       "type": "DATE_AND_TIME",
        #       "valueMsEpoch": 796435200000
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `date_time_picker`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `divider`, `grid`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] divider
        #   @return [::Google::Apps::Card::V1::Divider]
        #     Displays a horizontal line divider between widgets.
        #
        #     For example, the following JSON creates a divider:
        #     ```
        #     "divider": {
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `divider`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `grid`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] grid
        #   @return [::Google::Apps::Card::V1::Grid]
        #     Displays a grid with a collection of items.
        #
        #     A grid supports any number of columns and items. The number of rows is
        #     determined by the upper bounds of the number items divided by the number
        #     of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
        #     items and 2 columns has 6 rows.
        #
        #     [Google Workspace add-ons and
        #     Chat apps](https://developers.google.com/workspace/extend):
        #
        #     For example, the following JSON creates a 2 column grid with a single
        #     item:
        #
        #     ```
        #     "grid": {
        #       "title": "A fine collection of items",
        #       "columnCount": 2,
        #       "borderStyle": {
        #         "type": "STROKE",
        #         "cornerRadius": 4
        #       },
        #       "items": [
        #         {
        #           "image": {
        #             "imageUri": "https://www.example.com/image.png",
        #             "cropStyle": {
        #               "type": "SQUARE"
        #             },
        #             "borderStyle": {
        #               "type": "STROKE"
        #             }
        #           },
        #           "title": "An item",
        #           "textAlignment": "CENTER"
        #         }
        #       ],
        #       "onClick": {
        #         "openLink": {
        #           "url": "https://www.example.com"
        #         }
        #       }
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `grid`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `divider`, `columns`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] columns
        #   @return [::Google::Apps::Card::V1::Columns]
        #     Displays up to 2 columns.
        #
        #     To include more than 2 columns, or to use rows, use the `Grid` widget.
        #
        #     For example, the following JSON creates 2 columns that each contain
        #     text paragraphs:
        #
        #     ```
        #     "columns": {
        #       "columnItems": [
        #         {
        #           "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
        #           "horizontalAlignment": "CENTER",
        #           "verticalAlignment": "CENTER",
        #           "widgets": [
        #             {
        #               "textParagraph": {
        #                 "text": "First column text paragraph"
        #               }
        #             }
        #           ]
        #         },
        #         {
        #           "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
        #           "horizontalAlignment": "CENTER",
        #           "verticalAlignment": "CENTER",
        #           "widgets": [
        #             {
        #               "textParagraph": {
        #                 "text": "Second column text paragraph"
        #               }
        #             }
        #           ]
        #         }
        #       ]
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `columns`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `divider`, `grid`, `carousel`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] carousel
        #   @return [::Google::Apps::Card::V1::Carousel]
        #     A carousel contains a collection of nested widgets.
        #     For example, this is a JSON representation of a carousel that contains
        #     two text paragraphs.
        #
        #     ```
        #     {
        #       "widgets": [
        #         {
        #           "textParagraph": {
        #             "text": "First text paragraph in the carousel."
        #           }
        #         },
        #         {
        #           "textParagraph": {
        #             "text": "Second text paragraph in the carousel."
        #           }
        #         }
        #       ]
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `carousel`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `divider`, `grid`, `columns`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] chip_list
        #   @return [::Google::Apps::Card::V1::ChipList]
        #     A list of chips.
        #
        #     For example, the following JSON creates two chips. The first
        #     is a text chip and the second is an icon chip that opens a
        #     link:
        #     ```
        #     "chipList": {
        #       "chips": [
        #         {
        #           "text": "Edit",
        #           "disabled": true,
        #         },
        #         {
        #           "icon": {
        #             "knownIcon": "INVITE",
        #             "altText": "check calendar"
        #           },
        #           "onClick": {
        #             "openLink": {
        #               "url": "https://example.com/calendar"
        #             }
        #           }
        #         }
        #       ]
        #     }
        #     ```
        #
        #     Note: The following fields are mutually exclusive: `chip_list`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `divider`, `grid`, `columns`, `carousel`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] horizontal_alignment
        #   @return [::Google::Apps::Card::V1::Widget::HorizontalAlignment]
        #     Specifies whether widgets align to the left, right, or center of a column.
        class Widget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The shape used to crop the image.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          module ImageType
            # Default value. Applies a square mask to the image. For example, a 4x3
            # image becomes 3x3.
            SQUARE = 0

            # Applies a circular mask to the image. For example, a 4x3 image becomes a
            # circle with a diameter of 3.
            CIRCLE = 1
          end

          # Specifies whether widgets align to the left, right, or center of a column.
          #
          # [Google Chat apps](https://developers.google.com/workspace/chat):
          module HorizontalAlignment
            # Don't use. Unspecified.
            HORIZONTAL_ALIGNMENT_UNSPECIFIED = 0

            # Default value. Aligns widgets to the start position of the column. For
            # left-to-right layouts, aligns to the left. For right-to-left layouts,
            # aligns to the right.
            START = 1

            # Aligns widgets to the center of the column.
            CENTER = 2

            # Aligns widgets to the end position of the column. For left-to-right
            # layouts, aligns widgets to the right. For right-to-left layouts, aligns
            # widgets to the left.
            HorizontalAlignment::END = 3
          end

          # Represents vertical alignment attribute.
          module VerticalAlignment
            # Unspecified type. Do not use.
            VERTICAL_ALIGNMENT_UNSPECIFIED = 0

            # Alignment to the top position.
            TOP = 1

            # Alignment to the middle position.
            MIDDLE = 2

            # Alignment to the bottom position.
            BOTTOM = 3
          end
        end

        # A paragraph of text that supports formatting. For an example in
        # Google Chat apps, see [Add a paragraph of formatted
        # text](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_a_paragraph_of_formatted_text).
        # For more information
        # about formatting text, see
        # [Formatting text in Google Chat
        # apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
        # and
        # [Formatting
        # text in Google Workspace
        # add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
        #
        # [Google Workspace add-ons and
        # Chat apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] text
        #   @return [::String]
        #     The text that's shown in the widget.
        # @!attribute [rw] max_lines
        #   @return [::Integer]
        #     The maximum number of lines of text that are displayed in the widget. If
        #     the text exceeds the specified maximum number of lines, the excess
        #     content is concealed behind a **show more** button. If the text is equal or
        #     shorter than the specified maximum number of lines, a **show more** button
        #     isn't displayed.
        #
        #     The default value is 0, in which case
        #     all context is displayed. Negative values are ignored.
        # @!attribute [rw] text_syntax
        #   @return [::Google::Apps::Card::V1::TextParagraph::TextSyntax]
        #     The syntax of the text. If not set, the text is rendered as HTML.
        #
        #     [Google Chat apps](https://developers.google.com/workspace/chat):
        class TextParagraph
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Syntax to use for formatting text.
          #
          # [Google Chat apps](https://developers.google.com/workspace/chat):
          module TextSyntax
            # The text is rendered as HTML if unspecified.
            TEXT_SYNTAX_UNSPECIFIED = 0

            # The text is rendered as HTML. This is the default value.
            HTML = 1

            # The text is rendered as Markdown.
            MARKDOWN = 2
          end
        end

        # An image that is specified by a URL and can have an `onClick` action. For an
        # example, see [Add an
        # image](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_an_image).
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] image_url
        #   @return [::String]
        #     The HTTPS URL that hosts the image.
        #
        #     For example:
        #
        #     ```
        #     https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png
        #     ```
        # @!attribute [rw] on_click
        #   @return [::Google::Apps::Card::V1::OnClick]
        #     When a user clicks the image, the click triggers this action.
        # @!attribute [rw] alt_text
        #   @return [::String]
        #     The alternative text of this image that's used for accessibility.
        class Image
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Displays a divider between widgets as a horizontal line. For an example in
        # Google Chat apps, see
        # [Add a horizontal divider between
        # widgets](https://developers.google.com/workspace/chat/format-structure-card-dialog#add_a_horizontal_divider_between_widgets).
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        #
        # For example, the following JSON creates a divider:
        #
        # ```
        # "divider": {}
        # ```
        class Divider
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A widget that displays text with optional decorations such as a label above
        # or below the text, an icon in front of the text, a selection widget, or a
        # button after the text. For an example in
        # Google Chat apps, see [Display text with decorative
        # text](https://developers.google.com/workspace/chat/add-text-image-card-dialog#display_text_with_decorative_elements).
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] icon
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Apps::Card::V1::Icon]
        #     Deprecated in favor of `startIcon`.
        # @!attribute [rw] start_icon
        #   @return [::Google::Apps::Card::V1::Icon]
        #     The icon displayed in front of the text.
        # @!attribute [rw] start_icon_vertical_alignment
        #   @return [::Google::Apps::Card::V1::Widget::VerticalAlignment]
        #     Optional. Vertical alignment of the start icon. If not set, the icon
        #     will be vertically centered.
        #
        #     [Google Chat apps](https://developers.google.com/workspace/chat):
        # @!attribute [rw] top_label
        #   @return [::String]
        #     The text that appears above `text`. Always truncates.
        # @!attribute [rw] top_label_text
        #   @return [::Google::Apps::Card::V1::TextParagraph]
        #     `TextParagraph` equivalent of `top_label`. Always truncates. Allows for
        #     more complex formatting than `top_label`.
        #
        #     [Google Chat apps](https://developers.google.com/workspace/chat):
        # @!attribute [rw] text
        #   @return [::String]
        #     Required. The primary text.
        #
        #     Supports simple formatting. For more information
        #     about formatting text, see
        #     [Formatting text in Google Chat
        #     apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
        #     and
        #     [Formatting
        #     text in Google Workspace
        #     add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
        # @!attribute [rw] content_text
        #   @return [::Google::Apps::Card::V1::TextParagraph]
        #     `TextParagraph` equivalent of `text`. Allows for more complex formatting
        #     than `text`.
        #
        #     [Google Chat apps](https://developers.google.com/workspace/chat):
        # @!attribute [rw] wrap_text
        #   @return [::Boolean]
        #     The wrap text setting. If `true`, the text wraps and displays on
        #     multiple lines. Otherwise, the text is truncated.
        #
        #     Only applies to `text`, not `topLabel` and `bottomLabel`.
        # @!attribute [rw] bottom_label
        #   @return [::String]
        #     The text that appears below `text`. Always wraps.
        # @!attribute [rw] bottom_label_text
        #   @return [::Google::Apps::Card::V1::TextParagraph]
        #     `TextParagraph` equivalent of `bottom_label`. Always wraps. Allows for
        #     more complex formatting than `bottom_label`.
        #
        #     [Google Chat apps](https://developers.google.com/workspace/chat):
        # @!attribute [rw] on_click
        #   @return [::Google::Apps::Card::V1::OnClick]
        #     This action is triggered when users click `topLabel` or `bottomLabel`.
        # @!attribute [rw] button
        #   @return [::Google::Apps::Card::V1::Button]
        #     A button that a user can click to trigger an action.
        #
        #     Note: The following fields are mutually exclusive: `button`, `switch_control`, `end_icon`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] switch_control
        #   @return [::Google::Apps::Card::V1::DecoratedText::SwitchControl]
        #     A switch widget that a user can click to change its state and trigger an
        #     action.
        #
        #     Note: The following fields are mutually exclusive: `switch_control`, `button`, `end_icon`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] end_icon
        #   @return [::Google::Apps::Card::V1::Icon]
        #     An icon displayed after the text.
        #
        #     Supports
        #     [built-in](https://developers.google.com/workspace/chat/format-messages#builtinicons)
        #     and
        #     [custom](https://developers.google.com/workspace/chat/format-messages#customicons)
        #     icons.
        #
        #     Note: The following fields are mutually exclusive: `end_icon`, `button`, `switch_control`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DecoratedText
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Either a toggle-style switch or a checkbox inside a `decoratedText` widget.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          #
          # Only supported in the `decoratedText` widget.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name by which the switch widget is identified in a form input event.
          #
          #     For details about working with form inputs, see [Receive form
          #     data](https://developers.google.com/workspace/chat/read-form-data).
          # @!attribute [rw] value
          #   @return [::String]
          #     The value entered by a user, returned as part of a form input event.
          #
          #     For details about working with form inputs, see [Receive form
          #     data](https://developers.google.com/workspace/chat/read-form-data).
          # @!attribute [rw] selected
          #   @return [::Boolean]
          #     When `true`, the switch is selected.
          # @!attribute [rw] on_change_action
          #   @return [::Google::Apps::Card::V1::Action]
          #     The action to perform when the switch state is changed, such as what
          #      function to run.
          # @!attribute [rw] control_type
          #   @return [::Google::Apps::Card::V1::DecoratedText::SwitchControl::ControlType]
          #     How the switch appears in the user interface.
          #
          #     [Google Workspace add-ons
          #     and Chat apps](https://developers.google.com/workspace/extend):
          class SwitchControl
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # How the switch appears in the user interface.
            #
            # [Google Workspace add-ons
            # and Chat apps](https://developers.google.com/workspace/extend):
            module ControlType
              # A toggle-style switch.
              SWITCH = 0

              # Deprecated in favor of `CHECK_BOX`.
              CHECKBOX = 1

              # A checkbox.
              CHECK_BOX = 2
            end
          end
        end

        # A field in which users can enter text. Supports suggestions and on-change
        # actions.
        # Supports form submission validation. When `Action.all_widgets_are_required`
        # is set to `true` or this widget is specified in `Action.required_widgets`,
        # the submission action is blocked unless a value is entered. For an example in
        # Google Chat apps, see [Add a field in which a user can enter
        # text](https://developers.google.com/workspace/chat/design-interactive-card-dialog#add_a_field_in_which_a_user_can_enter_text).
        #
        # Chat apps receive and can process the value of entered text during form input
        # events. For details about working with form inputs, see [Receive form
        # data](https://developers.google.com/workspace/chat/read-form-data).
        #
        # When you need to collect undefined or abstract data from users,
        # use a text input. To collect defined or enumerated data from users, use the
        # {::Google::Apps::Card::V1::SelectionInput SelectionInput} widget.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] name
        #   @return [::String]
        #     The name by which the text input is identified in a form input event.
        #
        #     For details about working with form inputs, see [Receive form
        #     data](https://developers.google.com/workspace/chat/read-form-data).
        # @!attribute [rw] label
        #   @return [::String]
        #     The text that appears above the text input field in the user interface.
        #
        #     Specify text that helps the user enter the information your app needs.
        #     For example, if you are asking someone's name, but specifically need their
        #     surname, write `surname` instead of `name`.
        #
        #     Required if `hintText` is unspecified. Otherwise, optional.
        # @!attribute [rw] hint_text
        #   @return [::String]
        #     Text that appears below the text input field meant to assist users by
        #     prompting them to enter a certain value. This text is always visible.
        #
        #     Required if `label` is unspecified. Otherwise, optional.
        # @!attribute [rw] value
        #   @return [::String]
        #     The value entered by a user, returned as part of a form input event.
        #
        #     For details about working with form inputs, see [Receive form
        #     data](https://developers.google.com/workspace/chat/read-form-data).
        # @!attribute [rw] type
        #   @return [::Google::Apps::Card::V1::TextInput::Type]
        #     How a text input field appears in the user interface.
        #     For example, whether the field is single or multi-line.
        # @!attribute [rw] on_change_action
        #   @return [::Google::Apps::Card::V1::Action]
        #     What to do when a change occurs in the text input field. For example, a
        #     user adding to the field or deleting text.
        #
        #     Examples of actions to take include running a custom function or opening
        #     a [dialog](https://developers.google.com/workspace/chat/dialogs)
        #     in Google Chat.
        # @!attribute [rw] initial_suggestions
        #   @return [::Google::Apps::Card::V1::Suggestions]
        #     Suggested values that users can enter. These values appear when users click
        #     inside the text input field. As users type, the suggested values
        #     dynamically filter to match what the users have typed.
        #
        #     For example, a text input field for programming language might suggest
        #     Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
        #     of suggestions filters to show just `Java` and `JavaScript`.
        #
        #     Suggested values help guide users to enter values that your app can make
        #     sense of. When referring to JavaScript, some users might enter `javascript`
        #     and others `java script`. Suggesting `JavaScript` can standardize how users
        #     interact with your app.
        #
        #     When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
        #     to `MULTIPLE_LINE`.
        #
        #     [Google Workspace
        #     add-ons and Chat apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] auto_complete_action
        #   @return [::Google::Apps::Card::V1::Action]
        #     Optional. Specify what action to take when the text input field provides
        #     suggestions to users who interact with it.
        #
        #     If unspecified, the suggestions are set by `initialSuggestions` and
        #     are processed by the client.
        #
        #     If specified, the app takes the action specified here, such as running
        #     a custom function.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        # @!attribute [rw] validation
        #   @return [::Google::Apps::Card::V1::Validation]
        #     Specify the input format validation necessary for this text field.
        #
        #     [Google Workspace add-ons and Chat
        #     apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] placeholder_text
        #   @return [::String]
        #     Text that appears in the text input field when the field is empty.
        #     Use this text to prompt users to enter a value. For example, `Enter a
        #     number from 0 to 100`.
        #
        #     [Google Chat apps](https://developers.google.com/workspace/chat):
        class TextInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # How a text input field appears in the user interface. For example,
          # whether it's a single line input field, or a multi-line input. If
          # `initialSuggestions` is specified, `type` is always `SINGLE_LINE`,
          # even if it's set to `MULTIPLE_LINE`.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          module Type
            # The text input field has a fixed height of one line.
            SINGLE_LINE = 0

            # The text input field has a fixed height of multiple lines.
            MULTIPLE_LINE = 1
          end
        end

        # Suggested values that users can enter. These values appear when users click
        # inside the text input field. As users type, the suggested values
        # dynamically filter to match what the users have typed.
        #
        # For example, a text input field for programming language might suggest
        # Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
        # of suggestions filters to show `Java` and `JavaScript`.
        #
        # Suggested values help guide users to enter values that your app can make
        # sense of. When referring to JavaScript, some users might enter `javascript`
        # and others `java script`. Suggesting `JavaScript` can standardize how users
        # interact with your app.
        #
        # When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
        # to `MULTIPLE_LINE`.
        #
        # [Google Workspace
        # add-ons and Chat apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] items
        #   @return [::Array<::Google::Apps::Card::V1::Suggestions::SuggestionItem>]
        #     A list of suggestions used for autocomplete recommendations in text input
        #     fields.
        class Suggestions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # One suggested value that users can enter in a text input field.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] text
          #   @return [::String]
          #     The value of a suggested input to a text input field. This is
          #     equivalent to what users enter themselves.
          class SuggestionItem
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A list of buttons layed out horizontally. For an example in
        # Google Chat apps, see
        # [Add a
        # button](https://developers.google.com/workspace/chat/design-interactive-card-dialog#add_a_button).
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] buttons
        #   @return [::Array<::Google::Apps::Card::V1::Button>]
        #     An array of buttons.
        class ButtonList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A widget that creates one or more UI items that users can select.
        # Supports form submission validation for `dropdown` and `multiselect` menus
        # only. When `Action.all_widgets_are_required` is set to `true` or this widget
        # is specified in `Action.required_widgets`, the submission action is blocked
        # unless a value is selected. For example, a dropdown menu or checkboxes. You
        # can use this widget to collect data that can be predicted or enumerated. For
        # an example in Google Chat apps, see [Add selectable UI
        # elements](/workspace/chat/design-interactive-card-dialog#add_selectable_ui_elements).
        #
        # Chat apps can process the value of items that users select or input. For
        # details about working with form inputs, see [Receive form
        # data](https://developers.google.com/workspace/chat/read-form-data).
        #
        # To collect undefined or abstract data from users, use
        # the {::Google::Apps::Card::V1::TextInput TextInput} widget.
        #
        # [Google Workspace add-ons
        # and Chat apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name that identifies the selection input in a form input
        #     event.
        #
        #     For details about working with form inputs, see [Receive form
        #     data](https://developers.google.com/workspace/chat/read-form-data).
        # @!attribute [rw] label
        #   @return [::String]
        #     The text that appears above the selection input field in the user
        #     interface.
        #
        #     Specify text that helps the user enter the information your app needs.
        #     For example, if users are selecting the urgency of a work ticket from a
        #     drop-down menu, the label might be "Urgency" or "Select urgency".
        # @!attribute [rw] type
        #   @return [::Google::Apps::Card::V1::SelectionInput::SelectionType]
        #     The type of items that are displayed to users in a `SelectionInput` widget.
        #     Selection types support different types of interactions. For example, users
        #     can select one or more checkboxes, but they can only select one value from
        #     a dropdown menu.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Apps::Card::V1::SelectionInput::SelectionItem>]
        #     An array of selectable items. For example, an array of radio buttons or
        #     checkboxes. Supports up to 100 items.
        # @!attribute [rw] on_change_action
        #   @return [::Google::Apps::Card::V1::Action]
        #     If specified, the form is submitted when the selection changes. If not
        #     specified, you must specify a separate button that submits the form.
        #
        #     For details about working with form inputs, see [Receive form
        #     data](https://developers.google.com/workspace/chat/read-form-data).
        # @!attribute [rw] multi_select_max_selected_items
        #   @return [::Integer]
        #     For multiselect menus, the maximum number of items that a user can select.
        #     Minimum value is 1 item. If unspecified, defaults to 3 items.
        # @!attribute [rw] multi_select_min_query_length
        #   @return [::Integer]
        #     For multiselect menus, the number of text characters that a user inputs
        #     before the menu returns suggested selection items.
        #
        #     If unset, the multiselect menu uses the following default values:
        #
        #     * If the menu uses a static array of `SelectionInput` items, defaults to
        #       0 characters and immediately populates items from the array.
        #     * If the menu uses a dynamic data source (`multi_select_data_source`),
        #      defaults to 3 characters before querying the data source to return
        #      suggested items.
        # @!attribute [rw] external_data_source
        #   @return [::Google::Apps::Card::V1::Action]
        #     An external data source, such as a relational database.
        #
        #     Note: The following fields are mutually exclusive: `external_data_source`, `platform_data_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] platform_data_source
        #   @return [::Google::Apps::Card::V1::SelectionInput::PlatformDataSource]
        #     A data source from Google Workspace.
        #
        #     Note: The following fields are mutually exclusive: `platform_data_source`, `external_data_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SelectionInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An item that users can select in a selection input, such as a checkbox
          # or switch. Supports up to 100 items.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] text
          #   @return [::String]
          #     The text that identifies or describes the item to users.
          # @!attribute [rw] value
          #   @return [::String]
          #     The value associated with this item. The client should use this as a form
          #     input value.
          #
          #     For details about working with form inputs, see [Receive form
          #     data](https://developers.google.com/workspace/chat/read-form-data).
          # @!attribute [rw] selected
          #   @return [::Boolean]
          #     Whether the item is selected by default. If the selection input only
          #     accepts one value (such as for radio buttons or a dropdown menu), only
          #     set this field for one item.
          # @!attribute [rw] start_icon_uri
          #   @return [::String]
          # @!attribute [rw] bottom_text
          #   @return [::String]
          #     For multiselect menus, a text description or label that's
          #     displayed below the item's `text` field.
          class SelectionItem
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # For a
          # {::Google::Apps::Card::V1::SelectionInput `SelectionInput`} widget that uses a
          # multiselect menu, a data source from Google Workspace. Used to populate
          # items in a multiselect menu.
          #
          # [Google Chat apps](https://developers.google.com/workspace/chat):
          # @!attribute [rw] common_data_source
          #   @return [::Google::Apps::Card::V1::SelectionInput::PlatformDataSource::CommonDataSource]
          #     A data source shared by all Google Workspace applications, such as
          #     users in a Google Workspace organization.
          class PlatformDataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A data source shared by all [Google Workspace
            # applications]
            # (https://developers.google.com/workspace/chat/api/reference/rest/v1/HostApp).
            #
            # [Google Chat apps](https://developers.google.com/workspace/chat):
            module CommonDataSource
              # Default value. Don't use.
              UNKNOWN = 0

              # Google Workspace users. The user can only view and select users from
              # their Google Workspace organization.
              USER = 1
            end
          end

          # The format for the items that users can select. Different options support
          # different types of interactions. For example, users can select multiple
          # checkboxes, but can only select one item from a dropdown menu.
          #
          # Each selection input supports one type of selection. Mixing checkboxes
          # and switches, for example, isn't supported.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          module SelectionType
            # A set of checkboxes. Users can select one or more checkboxes.
            CHECK_BOX = 0

            # A set of radio buttons. Users can select one radio button.
            RADIO_BUTTON = 1

            # A set of switches. Users can turn on one or more switches.
            SWITCH = 2

            # A dropdown menu. Users can select one item from the menu.
            DROPDOWN = 3

            # A menu with a text box. Users can type and select one or more items.
            # For Google Workspace add-ons, you must populate items using a static
            # array of `SelectionItem` objects.
            #
            # For Google Chat apps, you can also populate items using a dynamic data
            # source and autosuggest items as users type in the menu. For example,
            # users can start typing the name of a Google Chat space and the widget
            # autosuggests the space. To dynamically populate items for a multiselect
            # menu, use one of the following types of data sources:
            #
            #  * Google Workspace data: Items are populated using data from Google
            #    Workspace, such as Google Workspace users or Google Chat spaces.
            #  * External data: Items are populated from an external data
            #    source outside of Google Workspace.
            #
            # For examples of how to implement multiselect menus for Chat apps, see
            # [Add a multiselect
            # menu](https://developers.google.com/workspace/chat/design-interactive-card-dialog#multiselect-menu).
            #
            # [Google Workspace add-ons and Chat
            # apps](https://developers.google.com/workspace/extend):
            MULTI_SELECT = 4
          end
        end

        # Lets users input a date, a time, or both a date and a time.
        # Supports form submission validation. When `Action.all_widgets_are_required`
        # is set to `true` or this widget is specified in `Action.required_widgets`,
        # the submission action is blocked unless a value is selected. For an example
        # in Google Chat apps, see [Let a user pick a date and
        # time](https://developers.google.com/workspace/chat/design-interactive-card-dialog#let_a_user_pick_a_date_and_time).
        #
        # Users can input text or use the picker to select dates and times. If users
        # input an invalid date or time, the picker shows an error that prompts users
        # to input the information correctly.
        #
        # [Google Workspace
        # add-ons and Chat apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] name
        #   @return [::String]
        #     The name by which the `DateTimePicker` is identified in a form input event.
        #
        #     For details about working with form inputs, see [Receive form
        #     data](https://developers.google.com/workspace/chat/read-form-data).
        # @!attribute [rw] label
        #   @return [::String]
        #     The text that prompts users to input a date, a time, or a date and time.
        #     For example, if users are scheduling an appointment, use a label such as
        #     `Appointment date` or `Appointment date and time`.
        # @!attribute [rw] type
        #   @return [::Google::Apps::Card::V1::DateTimePicker::DateTimePickerType]
        #     Whether the widget supports inputting a date, a time, or the date and time.
        # @!attribute [rw] value_ms_epoch
        #   @return [::Integer]
        #     Optional. The default value displayed in the widget, in milliseconds since
        #     [Unix epoch time](https://en.wikipedia.org/wiki/Unix_time).
        #
        #     Specify the value based on the type of picker (`DateTimePickerType`):
        #
        #     * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
        #       represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
        #     * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
        #       January 1, 2023, use `1672531200000`.
        #     * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
        #       `43200000` (or `12 * 60 * 60 * 1000`).
        # @!attribute [rw] timezone_offset_date
        #   @return [::Integer]
        #     The number representing the time zone offset from UTC, in minutes.
        #     If set, the `value_ms_epoch` is displayed in the specified time zone.
        #     If unset, the value defaults to the user's time zone setting.
        # @!attribute [rw] on_change_action
        #   @return [::Google::Apps::Card::V1::Action]
        #     Triggered when the user clicks **Save** or **Clear** from the
        #     `DateTimePicker` interface.
        class DateTimePicker
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The format for the date and time in the `DateTimePicker` widget.
          # Determines whether users can input a date, a time, or both a date and time.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          module DateTimePickerType
            # Users input a date and time.
            DATE_AND_TIME = 0

            # Users input a date.
            DATE_ONLY = 1

            # Users input a time.
            TIME_ONLY = 2
          end
        end

        # A widget that presents a pop-up menu with one or more actions that users can
        # invoke. For example, showing non-primary actions in a card. You can use this
        # widget when actions don't fit in the available space. To use, specify this
        # widget in the `OnClick` action of widgets that support it. For example, in a
        # `Button`.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] items
        #   @return [::Array<::Google::Apps::Card::V1::OverflowMenu::OverflowMenuItem>]
        #     Required. The list of menu options.
        class OverflowMenu
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An option that users can invoke in an overflow menu.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] start_icon
          #   @return [::Google::Apps::Card::V1::Icon]
          #     The icon displayed in front of the text.
          # @!attribute [rw] text
          #   @return [::String]
          #     Required. The text that identifies or describes the item to users.
          # @!attribute [rw] on_click
          #   @return [::Google::Apps::Card::V1::OnClick]
          #     Required. The action invoked when a menu option is selected.
          #     This `OnClick` cannot contain an `OverflowMenu`, any specified
          #     `OverflowMenu` is dropped and the menu item disabled.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Whether the menu option is disabled.
          #     Defaults to false.
          class OverflowMenuItem
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A text, icon, or text and icon button that users can click. For an example in
        # Google Chat apps, see
        # [Add a
        # button](https://developers.google.com/workspace/chat/design-interactive-card-dialog#add_a_button).
        #
        # To make an image a clickable button, specify an
        # {::Google::Apps::Card::V1::Image `Image`} (not an
        # {::Google::Apps::Card::V1::ImageComponent `ImageComponent`}) and set an
        # `onClick` action.
        #
        # [Google Workspace
        # add-ons and Chat apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] text
        #   @return [::String]
        #     The text displayed inside the button.
        # @!attribute [rw] icon
        #   @return [::Google::Apps::Card::V1::Icon]
        #     An icon displayed inside the button. If both `icon` and `text` are set,
        #     then the icon appears before the text.
        # @!attribute [rw] color
        #   @return [::Google::Type::Color]
        #     Optional. The color of the button. If set, the button `type` is set to
        #     `FILLED` and the color of `text` and `icon` fields are set to a
        #     contrasting color for readability. For example, if the button color is
        #     set to blue, any text or icons in the button are set to white.
        #
        #     To set the button color, specify a value for the `red`, `green`, and `blue`
        #     fields.
        #     The value must be a float number between 0 and 1 based on the RGB color
        #     value, where `0` (0/255) represents the absence of color  and `1` (255/255)
        #     represents the maximum intensity of the color.
        #
        #     For example, the following sets the color to red at its maximum intensity:
        #
        #     ```
        #     "color": {
        #        "red": 1,
        #        "green": 0,
        #        "blue": 0,
        #     }
        #     ```
        #
        #     The `alpha` field is unavailable for button color. If specified, this field
        #     is ignored.
        # @!attribute [rw] on_click
        #   @return [::Google::Apps::Card::V1::OnClick]
        #     Required. The action to perform when a user clicks the button, such as
        #     opening a hyperlink or running a custom function.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     If `true`, the button is displayed in an inactive state and doesn't respond
        #     to user actions.
        # @!attribute [rw] alt_text
        #   @return [::String]
        #     The alternative text that's used for accessibility.
        #
        #     Set descriptive text that lets users know what the button does. For
        #     example, if a button opens a hyperlink, you might write: "Opens a new
        #     browser tab and navigates to the Google Chat developer documentation at
        #     https://developers.google.com/workspace/chat".
        # @!attribute [rw] type
        #   @return [::Google::Apps::Card::V1::Button::Type]
        #     Optional. The type of a button. If unset, button type defaults to
        #     `OUTLINED`. If the `color` field is set, the button type is forced to
        #     `FILLED` and any value set for this field is ignored.
        class Button
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Optional. The
          # [type](https://m3.material.io/components/all-buttons#9134ac95-678e-49ae-a50a-e71948011b05)
          # of a button. If `color` field is set, the `type` is forced to `FILLED`.
          #
          # [Google Chat apps](https://developers.google.com/workspace/chat):
          module Type
            # Don't use. Unspecified.
            TYPE_UNSPECIFIED = 0

            # Outlined buttons are medium-emphasis buttons. They usually contain
            # actions that are important, but aren’t the primary action in a Chat app
            # or an add-on.
            OUTLINED = 1

            # A filled button has a container with a solid color. It has the most
            # visual impact and is recommended for the important and primary action in
            # a Chat app or an add-on.
            FILLED = 2

            # A filled tonal button is an alternative middle ground between filled and
            # outlined buttons. They’re useful in contexts where a lower-priority
            # button requires slightly more emphasis than an outline button would give.
            FILLED_TONAL = 3

            # A button does not have an invisible container in its default state. It is
            # often used for the lowest priority actions, especially when presenting
            # multiple options.
            BORDERLESS = 4
          end
        end

        # An icon displayed in a widget on a card. For an example in Google Chat apps,
        # see [Add an
        # icon](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_an_icon).
        #
        # Supports
        # [built-in](https://developers.google.com/workspace/chat/format-messages#builtinicons)
        # and
        # [custom](https://developers.google.com/workspace/chat/format-messages#customicons)
        # icons.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] known_icon
        #   @return [::String]
        #     Display one of the built-in icons provided by Google Workspace.
        #
        #     For example, to display an airplane icon, specify `AIRPLANE`.
        #     For a bus, specify `BUS`.
        #
        #     For a full list of supported icons, see [built-in
        #     icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
        #
        #     Note: The following fields are mutually exclusive: `known_icon`, `icon_url`, `material_icon`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] icon_url
        #   @return [::String]
        #     Display a custom icon hosted at an HTTPS URL.
        #
        #     For example:
        #
        #     ```
        #     "iconUrl":
        #     "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
        #     ```
        #
        #     Supported file types include `.png` and `.jpg`.
        #
        #     Note: The following fields are mutually exclusive: `icon_url`, `known_icon`, `material_icon`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] material_icon
        #   @return [::Google::Apps::Card::V1::MaterialIcon]
        #     Display one of the [Google Material
        #     Icons](https://fonts.google.com/icons).
        #
        #     For example, to display a [checkbox
        #     icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
        #     use
        #     ```
        #     "material_icon": {
        #       "name": "check_box"
        #     }
        #     ```
        #
        #     [Google Chat apps](https://developers.google.com/workspace/chat):
        #
        #     Note: The following fields are mutually exclusive: `material_icon`, `known_icon`, `icon_url`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] alt_text
        #   @return [::String]
        #     Optional. A description of the icon used for accessibility.
        #     If unspecified, the default value `Button` is provided. As a best practice,
        #     you should set a helpful description for what the icon displays, and if
        #     applicable, what it does. For example, `A user's account portrait`, or
        #     `Opens a new browser tab and navigates to the Google Chat developer
        #     documentation at https://developers.google.com/workspace/chat`.
        #
        #     If the icon is set in a {::Google::Apps::Card::V1::Button `Button`}, the
        #     `altText` appears as helper text when the user hovers over the button.
        #     However, if the button also sets `text`, the icon's `altText` is ignored.
        # @!attribute [rw] image_type
        #   @return [::Google::Apps::Card::V1::Widget::ImageType]
        #     The crop style applied to the image. In some cases, applying a
        #     `CIRCLE` crop causes the image to be drawn larger than a built-in
        #     icon.
        class Icon
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A [Google Material Icon](https://fonts.google.com/icons), which includes over
        # 2500+ options.
        #
        # For example, to display a [checkbox
        # icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048)
        # with customized weight and grade, write the following:
        #
        # ```
        # {
        #   "name": "check_box",
        #   "fill": true,
        #   "weight": 300,
        #   "grade": -25
        # }
        # ```
        #
        # [Google Chat apps](https://developers.google.com/workspace/chat):
        # @!attribute [rw] name
        #   @return [::String]
        #     The icon name defined in the [Google Material
        #     Icon](https://fonts.google.com/icons), for example, `check_box`. Any
        #     invalid names are abandoned and replaced with empty string and
        #     results in the icon failing to render.
        # @!attribute [rw] fill
        #   @return [::Boolean]
        #     Whether the icon renders as filled. Default value is false.
        #
        #     To preview different icon settings, go to
        #     [Google Font Icons](https://fonts.google.com/icons) and adjust the
        #     settings under **Customize**.
        # @!attribute [rw] weight
        #   @return [::Integer]
        #     The stroke weight of the icon. Choose from {100, 200, 300, 400,
        #     500, 600, 700}. If absent, default value is 400. If any other value is
        #     specified, the default value is used.
        #
        #     To preview different icon settings, go to
        #     [Google Font Icons](https://fonts.google.com/icons) and adjust the
        #     settings under **Customize**.
        # @!attribute [rw] grade
        #   @return [::Integer]
        #     Weight and grade affect a symbol’s thickness. Adjustments to grade are more
        #     granular than adjustments to weight and have a small impact on the size of
        #     the symbol. Choose from \\{-25, 0, 200}. If absent, default value is 0. If
        #     any other value is specified, the default value is used.
        #
        #     To preview different icon settings, go to
        #     [Google Font Icons](https://fonts.google.com/icons) and adjust the
        #     settings under **Customize**.
        class MaterialIcon
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the crop style applied to an image.
        #
        # [Google Workspace add-ons and
        # Chat apps](https://developers.google.com/workspace/extend):
        #
        # For example, here's how to apply a 16:9 aspect ratio:
        #
        # ```
        # cropStyle {
        #  "type": "RECTANGLE_CUSTOM",
        #  "aspectRatio": 16/9
        # }
        # ```
        # @!attribute [rw] type
        #   @return [::Google::Apps::Card::V1::ImageCropStyle::ImageCropType]
        #     The crop type.
        # @!attribute [rw] aspect_ratio
        #   @return [::Float]
        #     The aspect ratio to use if the crop type is `RECTANGLE_CUSTOM`.
        #
        #     For example, here's how to apply a 16:9 aspect ratio:
        #
        #     ```
        #     cropStyle {
        #      "type": "RECTANGLE_CUSTOM",
        #      "aspectRatio": 16/9
        #     }
        #     ```
        class ImageCropStyle
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the crop style applied to an image.
          #
          # [Google Workspace add-ons
          # and Chat apps](https://developers.google.com/workspace/extend):
          module ImageCropType
            # Don't use. Unspecified.
            IMAGE_CROP_TYPE_UNSPECIFIED = 0

            # Default value. Applies a square crop.
            SQUARE = 1

            # Applies a circular crop.
            CIRCLE = 2

            # Applies a rectangular crop with a custom aspect ratio. Set the custom
            # aspect ratio with `aspectRatio`.
            RECTANGLE_CUSTOM = 3

            # Applies a rectangular crop with a 4:3 aspect ratio.
            RECTANGLE_4_3 = 4
          end
        end

        # The style options for the border of a card or widget, including the border
        # type and color.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] type
        #   @return [::Google::Apps::Card::V1::BorderStyle::BorderType]
        #     The border type.
        # @!attribute [rw] stroke_color
        #   @return [::Google::Type::Color]
        #     The colors to use when the type is `BORDER_TYPE_STROKE`.
        #
        #     To set the stroke color, specify a value for the `red`, `green`, and `blue`
        #     fields.
        #     The value must be a float number between 0 and 1 based on the RGB color
        #     value, where `0` (0/255) represents the absence of color  and `1` (255/255)
        #     represents the maximum intensity of the color.
        #
        #     For example, the following sets the color to red at its maximum intensity:
        #
        #     ```
        #     "color": {
        #        "red": 1,
        #        "green": 0,
        #        "blue": 0,
        #     }
        #     ```
        #
        #     The `alpha` field is unavailable for stroke color. If specified, this field
        #     is ignored.
        # @!attribute [rw] corner_radius
        #   @return [::Integer]
        #     The corner radius for the border.
        class BorderStyle
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the border types applied to widgets.
          #
          # [Google Workspace add-ons
          # and Chat apps](https://developers.google.com/workspace/extend):
          module BorderType
            # Don't use. Unspecified.
            BORDER_TYPE_UNSPECIFIED = 0

            # No border.
            NO_BORDER = 1

            # Default value. Outline.
            STROKE = 2
          end
        end

        # Represents an image.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] image_uri
        #   @return [::String]
        #     The image URL.
        # @!attribute [rw] alt_text
        #   @return [::String]
        #     The accessibility label for the image.
        # @!attribute [rw] crop_style
        #   @return [::Google::Apps::Card::V1::ImageCropStyle]
        #     The crop style to apply to the image.
        # @!attribute [rw] border_style
        #   @return [::Google::Apps::Card::V1::BorderStyle]
        #     The border style to apply to the image.
        class ImageComponent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Displays a grid with a collection of items. Items can only include text or
        # images. For responsive columns, or to include more than text or images, use
        # {::Google::Apps::Card::V1::Columns `Columns`}. For an example in Google Chat apps,
        # see [Display a Grid with a collection of
        # items](https://developers.google.com/workspace/chat/format-structure-card-dialog#display_a_grid_with_a_collection_of_items).
        #
        # A grid supports any number of columns and items. The number of rows is
        # determined by items divided by columns. A grid with
        # 10 items and 2 columns has 5 rows. A grid with 11 items and 2 columns
        # has 6 rows.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        #
        # For example, the following JSON creates a 2 column grid with a single
        # item:
        #
        # ```
        # "grid": {
        #   "title": "A fine collection of items",
        #   "columnCount": 2,
        #   "borderStyle": {
        #     "type": "STROKE",
        #     "cornerRadius": 4
        #   },
        #   "items": [
        #     {
        #       "image": {
        #         "imageUri": "https://www.example.com/image.png",
        #         "cropStyle": {
        #           "type": "SQUARE"
        #         },
        #         "borderStyle": {
        #           "type": "STROKE"
        #         }
        #       },
        #       "title": "An item",
        #       "textAlignment": "CENTER"
        #     }
        #   ],
        #   "onClick": {
        #     "openLink": {
        #       "url": "https://www.example.com"
        #     }
        #   }
        # }
        # ```
        # @!attribute [rw] title
        #   @return [::String]
        #     The text that displays in the grid header.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Apps::Card::V1::Grid::GridItem>]
        #     The items to display in the grid.
        # @!attribute [rw] border_style
        #   @return [::Google::Apps::Card::V1::BorderStyle]
        #     The border style to apply to each grid item.
        # @!attribute [rw] column_count
        #   @return [::Integer]
        #     The number of columns to display in the grid. A default value
        #     is used if this field isn't specified, and that default value is
        #     different depending on where the grid is shown (dialog versus companion).
        # @!attribute [rw] on_click
        #   @return [::Google::Apps::Card::V1::OnClick]
        #     This callback is reused by each individual grid item, but with the
        #     item's identifier and index in the items list added to the callback's
        #     parameters.
        class Grid
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents an item in a grid layout. Items can contain text, an image, or
          # both text and an image.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] id
          #   @return [::String]
          #     A user-specified identifier for this grid item. This identifier is
          #     returned in the parent grid's `onClick` callback parameters.
          # @!attribute [rw] image
          #   @return [::Google::Apps::Card::V1::ImageComponent]
          #     The image that displays in the grid item.
          # @!attribute [rw] title
          #   @return [::String]
          #     The grid item's title.
          # @!attribute [rw] subtitle
          #   @return [::String]
          #     The grid item's subtitle.
          # @!attribute [rw] layout
          #   @return [::Google::Apps::Card::V1::Grid::GridItem::GridItemLayout]
          #     The layout to use for the grid item.
          class GridItem
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents the various layout options available for a grid item.
            #
            # [Google Workspace add-ons and Chat
            # apps](https://developers.google.com/workspace/extend):
            module GridItemLayout
              # Don't use. Unspecified.
              GRID_ITEM_LAYOUT_UNSPECIFIED = 0

              # The title and subtitle are shown below the grid item's image.
              TEXT_BELOW = 1

              # The title and subtitle are shown above the grid item's image.
              TEXT_ABOVE = 2
            end
          end
        end

        # The `Columns` widget displays up to 2 columns in a card or dialog. You can
        # add widgets to each column; the widgets appear in the order that they are
        # specified. For an example in Google Chat apps, see
        # [Display cards and dialogs in
        # columns](https://developers.google.com/workspace/chat/format-structure-card-dialog#display_cards_and_dialogs_in_columns).
        #
        # The height of each column is determined by the taller column. For example, if
        # the first column is taller than the second column, both columns have the
        # height of the first column. Because each column can contain a different
        # number of widgets, you can't define rows or align widgets between the
        # columns.
        #
        # Columns are displayed side-by-side. You can customize the width of each
        # column using the `HorizontalSizeStyle` field. If the user's
        # screen width is too narrow, the second column wraps below the first:
        #
        # * On web, the second column wraps if the screen width is less than or equal
        #   to 480 pixels.
        # * On iOS devices, the second column wraps if the screen width is
        #   less than or equal to 300 pt.
        # * On Android devices, the second column wraps if the screen width is
        #   less than or equal to 320 dp.
        #
        # To include more than two columns, or to use rows, use the
        # {::Google::Apps::Card::V1::Grid `Grid`} widget.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # The add-on UIs that support columns include:
        #
        # * The dialog displayed when users open the add-on from an email draft.
        # * The dialog displayed when users open the add-on from the
        # **Add attachment** menu in a Google Calendar event.
        # @!attribute [rw] column_items
        #   @return [::Array<::Google::Apps::Card::V1::Columns::Column>]
        #     An array of columns. You can include up to 2 columns in a card or dialog.
        class Columns
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A column.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend)
          # @!attribute [rw] horizontal_size_style
          #   @return [::Google::Apps::Card::V1::Columns::Column::HorizontalSizeStyle]
          #     Specifies how a column fills the width of the card.
          # @!attribute [rw] horizontal_alignment
          #   @return [::Google::Apps::Card::V1::Widget::HorizontalAlignment]
          #     Specifies whether widgets align to the left, right, or center of a
          #     column.
          # @!attribute [rw] vertical_alignment
          #   @return [::Google::Apps::Card::V1::Columns::Column::VerticalAlignment]
          #     Specifies whether widgets align to the top, bottom, or center of a
          #     column.
          # @!attribute [rw] widgets
          #   @return [::Array<::Google::Apps::Card::V1::Columns::Column::Widgets>]
          #     An array of widgets included in a column. Widgets appear in the order
          #     that they are specified.
          class Column
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The supported widgets that you can include in a column.
            #
            # [Google Workspace add-ons and Chat
            # apps](https://developers.google.com/workspace/extend)
            # @!attribute [rw] text_paragraph
            #   @return [::Google::Apps::Card::V1::TextParagraph]
            #     {::Google::Apps::Card::V1::TextParagraph TextParagraph} widget.
            #
            #     Note: The following fields are mutually exclusive: `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] image
            #   @return [::Google::Apps::Card::V1::Image]
            #     {::Google::Apps::Card::V1::Image Image} widget.
            #
            #     Note: The following fields are mutually exclusive: `image`, `text_paragraph`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] decorated_text
            #   @return [::Google::Apps::Card::V1::DecoratedText]
            #     {::Google::Apps::Card::V1::DecoratedText DecoratedText} widget.
            #
            #     Note: The following fields are mutually exclusive: `decorated_text`, `text_paragraph`, `image`, `button_list`, `text_input`, `selection_input`, `date_time_picker`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] button_list
            #   @return [::Google::Apps::Card::V1::ButtonList]
            #     {::Google::Apps::Card::V1::ButtonList ButtonList} widget.
            #
            #     Note: The following fields are mutually exclusive: `button_list`, `text_paragraph`, `image`, `decorated_text`, `text_input`, `selection_input`, `date_time_picker`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] text_input
            #   @return [::Google::Apps::Card::V1::TextInput]
            #     {::Google::Apps::Card::V1::TextInput TextInput} widget.
            #
            #     Note: The following fields are mutually exclusive: `text_input`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `selection_input`, `date_time_picker`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] selection_input
            #   @return [::Google::Apps::Card::V1::SelectionInput]
            #     {::Google::Apps::Card::V1::SelectionInput SelectionInput} widget.
            #
            #     Note: The following fields are mutually exclusive: `selection_input`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `date_time_picker`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] date_time_picker
            #   @return [::Google::Apps::Card::V1::DateTimePicker]
            #     {::Google::Apps::Card::V1::DateTimePicker DateTimePicker} widget.
            #
            #     Note: The following fields are mutually exclusive: `date_time_picker`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `chip_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] chip_list
            #   @return [::Google::Apps::Card::V1::ChipList]
            #     {::Google::Apps::Card::V1::ChipList ChipList} widget.
            #
            #     Note: The following fields are mutually exclusive: `chip_list`, `text_paragraph`, `image`, `decorated_text`, `button_list`, `text_input`, `selection_input`, `date_time_picker`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class Widgets
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specifies how a column fills the width of the card. The width of each
            # column depends on both the `HorizontalSizeStyle` and the width of the
            # widgets within the column.
            #
            # [Google Workspace add-ons and Chat
            # apps](https://developers.google.com/workspace/extend)
            module HorizontalSizeStyle
              # Don't use. Unspecified.
              HORIZONTAL_SIZE_STYLE_UNSPECIFIED = 0

              # Default value. Column fills the available space, up to 70% of the
              # card's width. If both columns are set to `FILL_AVAILABLE_SPACE`, each
              # column fills 50% of the space.
              FILL_AVAILABLE_SPACE = 1

              # Column fills the least amount of space possible and no more than 30% of
              # the card's width.
              FILL_MINIMUM_SPACE = 2
            end

            # Specifies whether widgets align to the top, bottom, or center of a
            # column.
            #
            # [Google Workspace add-ons and Chat
            # apps](https://developers.google.com/workspace/extend)
            module VerticalAlignment
              # Don't use. Unspecified.
              VERTICAL_ALIGNMENT_UNSPECIFIED = 0

              # Default value. Aligns widgets to the center of a column.
              CENTER = 1

              # Aligns widgets to the top of a column.
              TOP = 2

              # Aligns widgets to the bottom of a column.
              BOTTOM = 3
            end
          end
        end

        # A carousel, also known as a slider, rotates and displays a list of widgets in
        # a slideshow format, with buttons navigating to the previous or next widget.
        #
        # For example, this is a JSON representation of a carousel that contains three
        # text paragraph widgets.
        #
        # ```
        # {
        #   "carouselCards": [
        #     {
        #       "widgets": [
        #         {
        #           "textParagraph": {
        #             "text": "First text paragraph in carousel",
        #           }
        #         }
        #       ]
        #     },
        #     {
        #       "widgets": [
        #         {
        #           "textParagraph": {
        #             "text": "Second text paragraph in carousel",
        #           }
        #         }
        #       ]
        #     },
        #     {
        #       "widgets": [
        #         {
        #           "textParagraph": {
        #             "text": "Third text paragraph in carousel",
        #           }
        #         }
        #       ]
        #     }
        #   ]
        # }
        # ```
        #
        # [Google Chat apps](https://developers.google.com/workspace/chat):
        # @!attribute [rw] carousel_cards
        #   @return [::Array<::Google::Apps::Card::V1::Carousel::CarouselCard>]
        #     A list of cards included in the carousel.
        class Carousel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A card that can be displayed as a carousel item.
          # [Google Chat apps](https://developers.google.com/workspace/chat):
          # @!attribute [rw] widgets
          #   @return [::Array<::Google::Apps::Card::V1::Card::NestedWidget>]
          #     A list of widgets displayed in the carousel card. The widgets are
          #     displayed in the order that they are specified.
          # @!attribute [rw] footer_widgets
          #   @return [::Array<::Google::Apps::Card::V1::Card::NestedWidget>]
          #     A list of widgets displayed at the bottom of the carousel card. The
          #     widgets are displayed in the order that they are specified.
          class CarouselCard
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represent an expand and collapse control.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] horizontal_alignment
        #   @return [::Google::Apps::Card::V1::Widget::HorizontalAlignment]
        #     The horizontal alignment of the expand and collapse button.
        # @!attribute [rw] expand_button
        #   @return [::Google::Apps::Card::V1::Button]
        #     Optional. Define a customizable button to expand the section.
        #     Both expand_button and collapse_button field must be set. Only one
        #     field set will not take into effect.
        #     If this field isn't set, the default button is used.
        # @!attribute [rw] collapse_button
        #   @return [::Google::Apps::Card::V1::Button]
        #     Optional. Define a customizable button to collapse the section.
        #     Both expand_button and collapse_button field must be set. Only one
        #     field set will not take into effect.
        #     If this field isn't set, the default button is used.
        class CollapseControl
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents how to respond when users click an interactive element on
        # a card, such as a button.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] action
        #   @return [::Google::Apps::Card::V1::Action]
        #     If specified, an action is triggered by this `onClick`.
        #
        #     Note: The following fields are mutually exclusive: `action`, `open_link`, `open_dynamic_link_action`, `card`, `overflow_menu`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] open_link
        #   @return [::Google::Apps::Card::V1::OpenLink]
        #     If specified, this `onClick` triggers an open link action.
        #
        #     Note: The following fields are mutually exclusive: `open_link`, `action`, `open_dynamic_link_action`, `card`, `overflow_menu`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] open_dynamic_link_action
        #   @return [::Google::Apps::Card::V1::Action]
        #     An add-on triggers this action when the action needs to open a
        #     link. This differs from the `open_link` above in that this needs to talk
        #     to server to get the link. Thus some preparation work is required for
        #     web client to do before the open link action response comes back.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        #
        #     Note: The following fields are mutually exclusive: `open_dynamic_link_action`, `action`, `open_link`, `card`, `overflow_menu`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] card
        #   @return [::Google::Apps::Card::V1::Card]
        #     A new card is pushed to the card stack after clicking if specified.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        #
        #     Note: The following fields are mutually exclusive: `card`, `action`, `open_link`, `open_dynamic_link_action`, `overflow_menu`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] overflow_menu
        #   @return [::Google::Apps::Card::V1::OverflowMenu]
        #     If specified, this `onClick` opens an overflow menu.
        #
        #     Note: The following fields are mutually exclusive: `overflow_menu`, `action`, `open_link`, `open_dynamic_link_action`, `card`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class OnClick
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an `onClick` event that opens a hyperlink.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] url
        #   @return [::String]
        #     The URL to open.
        # @!attribute [rw] open_as
        #   @return [::Google::Apps::Card::V1::OpenLink::OpenAs]
        #     How to open a link.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        # @!attribute [rw] on_close
        #   @return [::Google::Apps::Card::V1::OpenLink::OnClose]
        #     Whether the client forgets about a link after opening it, or observes it
        #     until the window closes.
        #
        #     [Google Workspace
        #     add-ons](https://developers.google.com/workspace/add-ons):
        class OpenLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # When an `OnClick` action opens a link, then the client can either open it
          # as a full-size window (if that's the frame used by the client), or an
          # overlay (such as a pop-up). The implementation depends on the client
          # platform capabilities, and the value selected might be ignored if the
          # client doesn't support it. `FULL_SIZE` is supported by all clients.
          #
          # [Google Workspace
          # add-ons](https://developers.google.com/workspace/add-ons):
          module OpenAs
            # The link opens as a full-size window (if that's the frame used by the
            # client).
            FULL_SIZE = 0

            # The link opens as an overlay, such as a pop-up.
            OVERLAY = 1
          end

          # What the client does when a link opened by an `OnClick` action is closed.
          #
          # Implementation depends on client platform capabilities. For example, a web
          # browser might open a link in a pop-up window with an `OnClose` handler.
          #
          # If both `OnOpen` and `OnClose` handlers are set, and the client platform
          # can't support both values, `OnClose` takes precedence.
          #
          # [Google Workspace
          # add-ons](https://developers.google.com/workspace/add-ons):
          module OnClose
            # Default value. The card doesn't reload; nothing happens.
            NOTHING = 0

            # Reloads the card after the child window closes.
            #
            # If used in conjunction with
            # [`OpenAs.OVERLAY`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#openas),
            # the child window acts as a modal dialog and the parent card is blocked
            # until the child window closes.
            RELOAD = 1
          end
        end

        # An action that describes the behavior when the form is submitted.
        # For example, you can invoke an Apps Script script to handle the form.
        # If the action is triggered, the form values are sent to the server.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] function
        #   @return [::String]
        #     A custom function to invoke when the containing element is
        #     clicked or otherwise activated.
        #
        #     For example usage, see [Read form
        #     data](https://developers.google.com/workspace/chat/read-form-data).
        # @!attribute [rw] parameters
        #   @return [::Array<::Google::Apps::Card::V1::Action::ActionParameter>]
        #     List of action parameters.
        # @!attribute [rw] load_indicator
        #   @return [::Google::Apps::Card::V1::Action::LoadIndicator]
        #     Specifies the loading indicator that the action displays while
        #     making the call to the action.
        # @!attribute [rw] persist_values
        #   @return [::Boolean]
        #     Indicates whether form values persist after the action. The default value
        #     is `false`.
        #
        #     If `true`, form values remain after the action is triggered. To let the
        #     user make changes while the action is being processed, set
        #     [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
        #     to `NONE`. For [card
        #     messages](https://developers.google.com/workspace/chat/api/guides/v1/messages/create#create)
        #     in Chat apps, you must also set the action's
        #     [`ResponseType`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#responsetype)
        #     to `UPDATE_MESSAGE` and use the same
        #     [`card_id`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#CardWithId)
        #     from the card that contained the action.
        #
        #     If `false`, the form values are cleared when the action is triggered.
        #     To prevent the user from making changes while the action is being
        #     processed, set
        #     [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
        #     to `SPINNER`.
        # @!attribute [rw] interaction
        #   @return [::Google::Apps::Card::V1::Action::Interaction]
        #     Optional. Required when opening a
        #     [dialog](https://developers.google.com/workspace/chat/dialogs).
        #
        #     What to do in response to an interaction with a user, such as a user
        #     clicking a button in a card message.
        #
        #     If unspecified, the app responds by executing an `action`—like opening a
        #     link or running a function—as normal.
        #
        #     By specifying an `interaction`, the app can respond in special interactive
        #     ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
        #     open a [dialog](https://developers.google.com/workspace/chat/dialogs). When
        #     specified, a loading indicator isn't shown. If specified for
        #     an add-on, the entire card is stripped and nothing is shown in the client.
        #
        #     [Google Chat apps](https://developers.google.com/workspace/chat):
        # @!attribute [rw] required_widgets
        #   @return [::Array<::String>]
        #     Optional. Fill this list with the names of widgets that this Action
        #     needs for a valid submission.
        #
        #     If the widgets listed here don't have a value when this Action is invoked,
        #     the form submission is aborted.
        #
        #     [Google Workspace add-ons and Chat
        #     apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] all_widgets_are_required
        #   @return [::Boolean]
        #     Optional. If this is true, then all widgets are considered required by
        #     this action.
        #
        #     [Google Workspace add-ons and Chat
        #     apps](https://developers.google.com/workspace/extend):
        class Action
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # List of string parameters to supply when the action method is invoked.
          # For example, consider three snooze buttons: snooze now, snooze one day,
          # or snooze next week. You might use `action method = snooze()`, passing the
          # snooze type and snooze time in the list of string parameters.
          #
          # To learn more, see
          # [`CommonEventObject`](https://developers.google.com/workspace/chat/api/reference/rest/v1/Event#commoneventobject).
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          # @!attribute [rw] key
          #   @return [::String]
          #     The name of the parameter for the action script.
          # @!attribute [rw] value
          #   @return [::String]
          #     The value of the parameter.
          class ActionParameter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies the loading indicator that the action displays while
          # making the call to the action.
          #
          # [Google Workspace add-ons and Chat
          # apps](https://developers.google.com/workspace/extend):
          module LoadIndicator
            # Displays a spinner to indicate that content is loading.
            SPINNER = 0

            # Nothing is displayed.
            NONE = 1
          end

          # Optional. Required when opening a
          # [dialog](https://developers.google.com/workspace/chat/dialogs).
          #
          # What to do in response to an interaction with a user, such as a user
          # clicking a button in a card message.
          #
          # If unspecified, the app responds by executing an `action`—like opening a
          # link or running a function—as normal.
          #
          # By specifying an `interaction`, the app can respond in special interactive
          # ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
          # open a [dialog](https://developers.google.com/workspace/chat/dialogs).
          #
          # When specified, a loading indicator isn't shown. If specified for
          # an add-on, the entire card is stripped and nothing is shown in the client.
          #
          # [Google Chat apps](https://developers.google.com/workspace/chat):
          module Interaction
            # Default value. The `action` executes as normal.
            INTERACTION_UNSPECIFIED = 0

            # Opens a [dialog](https://developers.google.com/workspace/chat/dialogs), a
            # windowed, card-based interface that Chat apps use to interact with users.
            #
            # Only supported by Chat apps in response to button-clicks on card
            # messages. If specified for
            # an add-on, the entire card is stripped and nothing is shown in the
            # client.
            #
            # [Google Chat apps](https://developers.google.com/workspace/chat):
            OPEN_DIALOG = 1
          end
        end

        # Represents the necessary data for validating the widget it's attached to.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] character_limit
        #   @return [::Integer]
        #     Specify the character limit for text input widgets.  Note that this is
        #     only used for text input and is ignored for other widgets.
        #
        #     [Google Workspace add-ons and Chat
        #     apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] input_type
        #   @return [::Google::Apps::Card::V1::Validation::InputType]
        #     Specify the type of the input widgets.
        #
        #     [Google Workspace add-ons and Chat
        #     apps](https://developers.google.com/workspace/extend):
        class Validation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the input widget.
          module InputType
            # Unspecified type. Do not use.
            INPUT_TYPE_UNSPECIFIED = 0

            # Regular text that accepts all characters.
            TEXT = 1

            # An integer value.
            INTEGER = 2

            # A float value.
            FLOAT = 3

            # An email address.
            EMAIL = 4

            # A emoji selected from system-provided emoji picker.
            EMOJI_PICKER = 5
          end
        end

        # A list of chips layed out horizontally, which can either scroll horizontally
        # or wrap to the next line.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] layout
        #   @return [::Google::Apps::Card::V1::ChipList::Layout]
        #     Specified chip list layout.
        # @!attribute [rw] chips
        #   @return [::Array<::Google::Apps::Card::V1::Chip>]
        #     An array of chips.
        class ChipList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The chip list layout.
          module Layout
            # Don't use. Unspecified.
            LAYOUT_UNSPECIFIED = 0

            # Default value. The chip list wraps to the next line if there isn't enough
            # horizontal space.
            WRAPPED = 1

            # The chips scroll horizontally if they don't fit in the available space.
            HORIZONTAL_SCROLLABLE = 2
          end
        end

        # A text, icon, or text and icon chip that users can click.
        #
        # [Google Workspace add-ons and Chat
        # apps](https://developers.google.com/workspace/extend):
        # @!attribute [rw] icon
        #   @return [::Google::Apps::Card::V1::Icon]
        #     The icon image. If both `icon` and `text` are set, then the icon appears
        #     before the text.
        # @!attribute [rw] label
        #   @return [::String]
        #     The text displayed inside the chip.
        # @!attribute [rw] on_click
        #   @return [::Google::Apps::Card::V1::OnClick]
        #     Optional. The action to perform when a user clicks the chip, such as
        #     opening a hyperlink or running a custom function.
        # @!attribute [rw] enabled
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Whether the chip is in an active state and responds to user actions.
        #     Defaults to `true`.
        #     Deprecated. Use `disabled` instead.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Whether the chip is in an inactive state and ignores user actions.
        #     Defaults to `false`.
        # @!attribute [rw] alt_text
        #   @return [::String]
        #     The alternative text that's used for accessibility.
        #
        #     Set descriptive text that lets users know what the chip does. For
        #     example, if a chip opens a hyperlink, write: "Opens a new
        #     browser tab and navigates to the Google Chat developer documentation at
        #     https://developers.google.com/workspace/chat".
        class Chip
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
