# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/chat/v1/chat_service.proto for package 'Google.Apps.Chat.V1'
# Original file comments:
# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/chat/v1/chat_service_pb'

module Google
  module Apps
    module Chat
      module V1
        module ChatService
          # Enables developers to build Chat apps and
          # integrations on Google Chat Platform.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.chat.v1.ChatService'

            # Creates a message in a Google Chat space. For an example, see [Send a
            # message](https://developers.google.com/workspace/chat/create-messages).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages.create`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # Chat attributes the message sender differently depending on the type of
            # authentication that you use in your request.
            #
            # The following image shows how Chat attributes a message when you use app
            # authentication. Chat displays the Chat app as the message
            # sender. The content of the message can contain text (`text`), cards
            # (`cardsV2`), and accessory widgets (`accessoryWidgets`).
            #
            # ![Message sent with app
            # authentication](https://developers.google.com/workspace/chat/images/message-app-auth.svg)
            #
            # The following image shows how Chat attributes a message when you use user
            # authentication. Chat displays the user as the message sender and attributes
            # the Chat app to the message by displaying its name. The content of message
            # can only contain text (`text`).
            #
            # ![Message sent with user
            # authentication](https://developers.google.com/workspace/chat/images/message-user-auth.svg)
            #
            # The maximum message size, including the message contents, is 32,000 bytes.
            #
            # For
            # [webhook](https://developers.google.com/workspace/chat/quickstart/webhooks)
            # requests, the response doesn't contain the full message. The response only
            # populates the `name` and `thread.name` fields in addition to the
            # information that was in the request.
            rpc :CreateMessage, ::Google::Apps::Chat::V1::CreateMessageRequest, ::Google::Apps::Chat::V1::Message
            # Lists messages in a space that the caller is a member of, including
            # messages from blocked members and spaces. System messages, like those
            # announcing new space members, aren't included. If you list messages from a
            # space with no messages, the response is an empty object. When using a
            # REST/HTTP interface, the response contains an empty JSON object, `{}`.
            # For an example, see
            # [List
            # messages](https://developers.google.com/workspace/chat/api/guides/v1/messages/list).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) in
            # [Developer Preview](https://developers.google.com/workspace/preview)
            #  with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.messages.readonly`. When
            #     using this authentication scope, this method only returns public
            #     messages in a space. It doesn't include private messages.
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            rpc :ListMessages, ::Google::Apps::Chat::V1::ListMessagesRequest, ::Google::Apps::Chat::V1::ListMessagesResponse
            # Lists memberships in a space. For an example, see [List users and Google
            # Chat apps in a
            # space](https://developers.google.com/workspace/chat/list-members). Listing
            # memberships with [app
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # lists memberships in spaces that the Chat app has
            # access to, but excludes Chat app memberships,
            # including its own. Listing memberships with
            # [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # lists memberships in spaces that the authenticated user has access to.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #     - `https://www.googleapis.com/auth/chat.app.memberships` (requires
            #     [administrator approval](https://support.google.com/a?p=chat-app-auth))
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships.readonly`
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     one of the following authorization scopes is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships.readonly`
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            rpc :ListMemberships, ::Google::Apps::Chat::V1::ListMembershipsRequest, ::Google::Apps::Chat::V1::ListMembershipsResponse
            # Returns details about a membership. For an example, see
            # [Get details about a user's or Google Chat app's
            # membership](https://developers.google.com/workspace/chat/get-members).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #     - `https://www.googleapis.com/auth/chat.app.memberships` (requires
            #     [administrator approval](https://support.google.com/a?p=chat-app-auth))
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships.readonly`
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     one of the following authorization scopes is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships.readonly`
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            rpc :GetMembership, ::Google::Apps::Chat::V1::GetMembershipRequest, ::Google::Apps::Chat::V1::Membership
            # Returns details about a message.
            # For an example, see [Get details about a
            # message](https://developers.google.com/workspace/chat/get-messages).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.bot`: When using this
            #     authorization scope, this method returns details about a message the
            #     Chat app has access to, like direct messages and [slash
            #     commands](https://developers.google.com/workspace/chat/slash-commands)
            #     that invoke the Chat app.
            #     - `https://www.googleapis.com/auth/chat.app.messages.readonly`
            #     with [administrator
            #     approval](https://support.google.com/a?p=chat-app-auth) (available in
            #     [Developer Preview](https://developers.google.com/workspace/preview)).
            #     When using this authentication scope,
            #     this method returns details about a public message in a space.
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #
            # Note: Might return a message from a blocked member or space.
            rpc :GetMessage, ::Google::Apps::Chat::V1::GetMessageRequest, ::Google::Apps::Chat::V1::Message
            # Updates a message. There's a difference between the `patch` and `update`
            # methods. The `patch`
            # method uses a `patch` request while the `update` method uses a `put`
            # request. We recommend using the `patch` method. For an example, see
            # [Update a
            # message](https://developers.google.com/workspace/chat/update-messages).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # When using app authentication, requests can only update messages
            # created by the calling Chat app.
            rpc :UpdateMessage, ::Google::Apps::Chat::V1::UpdateMessageRequest, ::Google::Apps::Chat::V1::Message
            # Deletes a message.
            # For an example, see [Delete a
            # message](https://developers.google.com/workspace/chat/delete-messages).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # When using app authentication, requests can only delete messages
            # created by the calling Chat app.
            rpc :DeleteMessage, ::Google::Apps::Chat::V1::DeleteMessageRequest, ::Google::Protobuf::Empty
            # Gets the metadata of a message attachment. The attachment data is fetched
            # using the [media
            # API](https://developers.google.com/workspace/chat/api/reference/rest/v1/media/download).
            # For an example, see
            # [Get metadata about a message
            # attachment](https://developers.google.com/workspace/chat/get-media-attachments).
            #
            # Requires [app
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.bot`
            rpc :GetAttachment, ::Google::Apps::Chat::V1::GetAttachmentRequest, ::Google::Apps::Chat::V1::Attachment
            # Uploads an attachment. For an example, see
            # [Upload media as a file
            # attachment](https://developers.google.com/workspace/chat/upload-media-attachments).
            #
            # Requires user
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.messages.create`
            #   - `https://www.googleapis.com/auth/chat.messages`
            #   - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
            #
            # You can upload attachments up to 200 MB. Certain file types aren't
            # supported. For details, see [File types blocked by Google
            # Chat](https://support.google.com/chat/answer/7651457?&co=GENIE.Platform%3DDesktop#File%20types%20blocked%20in%20Google%20Chat).
            rpc :UploadAttachment, ::Google::Apps::Chat::V1::UploadAttachmentRequest, ::Google::Apps::Chat::V1::UploadAttachmentResponse
            # Lists spaces the caller is a member of. Group chats and DMs aren't listed
            # until the first message is sent. For an example, see
            # [List
            # spaces](https://developers.google.com/workspace/chat/list-spaces).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #
            # To list all named spaces by Google Workspace organization, use the
            # [`spaces.search()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/search)
            # method using Workspace administrator privileges instead.
            rpc :ListSpaces, ::Google::Apps::Chat::V1::ListSpacesRequest, ::Google::Apps::Chat::V1::ListSpacesResponse
            # Returns a list of spaces in a Google Workspace organization based on an
            # administrator's search. In the request, set `use_admin_access` to `true`.
            # For an example, see [Search for and manage
            # spaces](https://developers.google.com/workspace/chat/search-manage-admin).
            #
            # Requires [user
            # authentication with administrator
            # privileges](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user#admin-privileges)
            # and one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.admin.spaces.readonly`
            #   - `https://www.googleapis.com/auth/chat.admin.spaces`
            rpc :SearchSpaces, ::Google::Apps::Chat::V1::SearchSpacesRequest, ::Google::Apps::Chat::V1::SearchSpacesResponse
            # Returns details about a space. For an example, see
            # [Get details about a
            # space](https://developers.google.com/workspace/chat/get-spaces).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #     - `https://www.googleapis.com/auth/chat.app.spaces` with [administrator
            #     approval](https://support.google.com/a?p=chat-app-auth)
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     one of the following authorization scopes is used:
            #         - `https://www.googleapis.com/auth/chat.admin.spaces.readonly`
            #         - `https://www.googleapis.com/auth/chat.admin.spaces`
            #
            # App authentication has the following limitations:
            #
            # - `space.access_settings` is only populated when using the
            # `chat.app.spaces` scope.
            # - `space.predefind_permission_settings` and `space.permission_settings` are
            # only populated when using the `chat.app.spaces` scope, and only for
            # spaces the app created.
            rpc :GetSpace, ::Google::Apps::Chat::V1::GetSpaceRequest, ::Google::Apps::Chat::V1::Space
            # Creates a space. Can be used to create a named space, or a
            # group chat in `Import mode`. For an example, see [Create a
            # space](https://developers.google.com/workspace/chat/create-spaces).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator approval](https://support.google.com/a?p=chat-app-auth)
            # and one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.app.spaces.create`
            #     - `https://www.googleapis.com/auth/chat.app.spaces`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.create`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # When authenticating as an app, the `space.customer` field must be set in
            # the request.
            #
            # When authenticating as an app, the Chat app is added as a member of the
            # space. However, unlike human authentication, the Chat app is not added as a
            # space manager. By default, the Chat app can be removed from the space by
            # all space members. To allow only space managers to remove the app from a
            # space, set `space.permission_settings.manage_apps` to `managers_allowed`.
            #
            # Space membership upon creation depends on whether the space is created in
            # `Import mode`:
            #
            # * **Import mode:** No members are created.
            # * **All other modes:**  The calling user is added as a member. This is:
            #     * The app itself when using app authentication.
            #     * The human user when using user authentication.
            #
            #  If you receive the error message `ALREADY_EXISTS` when creating
            #  a space, try a different `displayName`. An existing space within
            #  the Google Workspace organization might already use this display name.
            rpc :CreateSpace, ::Google::Apps::Chat::V1::CreateSpaceRequest, ::Google::Apps::Chat::V1::Space
            # Creates a space and adds specified users to it. The calling user is
            # automatically added to the space, and shouldn't be specified as a
            # membership in the request. For an example, see
            # [Set up a space with initial
            # members](https://developers.google.com/workspace/chat/set-up-spaces).
            #
            # To specify the human members to add, add memberships with the appropriate
            # `membership.member.name`. To add a human user, use `users/{user}`, where
            # `{user}` can be the email address for the user. For users in the same
            # Workspace organization `{user}` can also be the `id` for the person from
            # the People API, or the `id` for the user in the Directory API. For example,
            # if the People API Person profile ID for `user@example.com` is `123456789`,
            # you can add the user to the space by setting the `membership.member.name`
            # to `users/user@example.com` or `users/123456789`.
            #
            # To specify the Google groups to add, add memberships with the
            # appropriate `membership.group_member.name`. To add or invite a Google
            # group, use `groups/{group}`, where `{group}` is the `id` for the group from
            # the Cloud Identity Groups API. For example, you can use [Cloud Identity
            # Groups lookup
            # API](https://cloud.google.com/identity/docs/reference/rest/v1/groups/lookup)
            # to retrieve the ID `123456789` for group email `group@example.com`, then
            # you can add the group to the space by setting the
            # `membership.group_member.name` to `groups/123456789`. Group email is not
            # supported, and Google groups can only be added as members in named spaces.
            #
            # For a named space or group chat, if the caller blocks, or is blocked
            # by some members, or doesn't have permission to add some members, then
            # those members aren't added to the created space.
            #
            # To create a direct message (DM) between the calling user and another human
            # user, specify exactly one membership to represent the human user. If
            # one user blocks the other, the request fails and the DM isn't created.
            #
            # To create a DM between the calling user and the calling app, set
            # `Space.singleUserBotDm` to `true` and don't specify any memberships. You
            # can only use this method to set up a DM with the calling app. To add the
            # calling app as a member of a space or an existing DM between two human
            # users, see
            # [Invite or add a user or app to a
            # space](https://developers.google.com/workspace/chat/create-members).
            #
            # If a DM already exists between two users, even when one user blocks the
            # other at the time a request is made, then the existing DM is returned.
            #
            # Spaces with threaded replies aren't supported. If you receive the error
            # message `ALREADY_EXISTS` when setting up a space, try a different
            # `displayName`. An existing space within the Google Workspace organization
            # might already use this display name.
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.spaces.create`
            #   - `https://www.googleapis.com/auth/chat.spaces`
            rpc :SetUpSpace, ::Google::Apps::Chat::V1::SetUpSpaceRequest, ::Google::Apps::Chat::V1::Space
            # Updates a space. For an example, see
            # [Update a
            # space](https://developers.google.com/workspace/chat/update-spaces).
            #
            # If you're updating the `displayName` field and receive the error message
            # `ALREADY_EXISTS`, try a different display name.. An existing space within
            # the Google Workspace organization might already use this display name.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator approval](https://support.google.com/a?p=chat-app-auth)
            # and one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.app.spaces`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scopes is used:
            #         - `https://www.googleapis.com/auth/chat.admin.spaces`
            #
            # App authentication has the following limitations:
            #
            # - To update either `space.predefined_permission_settings` or
            # `space.permission_settings`, the app must be the space creator.
            # - Updating the `space.access_settings.audience` is not supported for app
            # authentication.
            rpc :UpdateSpace, ::Google::Apps::Chat::V1::UpdateSpaceRequest, ::Google::Apps::Chat::V1::Space
            # Deletes a named space. Always performs a cascading delete, which means
            # that the space's child resources—like messages posted in the space and
            # memberships in the space—are also deleted. For an example, see
            # [Delete a
            # space](https://developers.google.com/workspace/chat/delete-spaces).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) and the
            # authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.delete` (only in
            #     spaces the app created)
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.delete`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scope is used:
            #         - `https://www.googleapis.com/auth/chat.admin.delete`
            rpc :DeleteSpace, ::Google::Apps::Chat::V1::DeleteSpaceRequest, ::Google::Protobuf::Empty
            # Completes the
            # [import process](https://developers.google.com/workspace/chat/import-data)
            # for the specified space and makes it visible to users.
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # and domain-wide delegation with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.import`
            #
            # For more information, see [Authorize Google
            # Chat apps to import
            # data](https://developers.google.com/workspace/chat/authorize-import).
            rpc :CompleteImportSpace, ::Google::Apps::Chat::V1::CompleteImportSpaceRequest, ::Google::Apps::Chat::V1::CompleteImportSpaceResponse
            # Returns the existing direct message with the specified user. If no direct
            # message space is found, returns a `404 NOT_FOUND` error. For an example,
            # see
            # [Find a direct message](/chat/api/guides/v1/spaces/find-direct-message).
            #
            # With [app
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app),
            # returns the direct message space between the specified user and the calling
            # Chat app.
            #
            # With [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
            # returns the direct message space between the specified user and the
            # authenticated user.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            rpc :FindDirectMessage, ::Google::Apps::Chat::V1::FindDirectMessageRequest, ::Google::Apps::Chat::V1::Space
            # Creates a membership for the calling Chat app, a user, or a Google Group.
            # Creating memberships for other Chat apps isn't supported.
            # When creating a membership, if the specified member has their auto-accept
            # policy turned off, then they're invited, and must accept the space
            # invitation before joining. Otherwise, creating a membership adds the member
            # directly to the specified space.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator approval](https://support.google.com/a?p=chat-app-auth)
            # and the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.memberships`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - `https://www.googleapis.com/auth/chat.memberships.app` (to add the
            #     calling app to the space)
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scope is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            #
            # App authentication is not supported for the following use cases:
            #
            # - Inviting users external to the Workspace organization that owns the
            # space.
            # - Adding a Google Group to a space.
            # - Adding a Chat app to a space.
            #
            # For example usage, see:
            #
            # - [Invite or add a user to a
            # space](https://developers.google.com/workspace/chat/create-members#create-user-membership).
            # - [Invite or add a Google Group to a
            # space](https://developers.google.com/workspace/chat/create-members#create-group-membership).
            # - [Add the Chat app to a
            # space](https://developers.google.com/workspace/chat/create-members#create-membership-calling-api).
            rpc :CreateMembership, ::Google::Apps::Chat::V1::CreateMembershipRequest, ::Google::Apps::Chat::V1::Membership
            # Updates a membership. For an example, see [Update a user's membership in
            # a space](https://developers.google.com/workspace/chat/update-members).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) and the
            # authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.memberships` (only in
            #     spaces the app created)
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scope is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            rpc :UpdateMembership, ::Google::Apps::Chat::V1::UpdateMembershipRequest, ::Google::Apps::Chat::V1::Membership
            # Deletes a membership. For an example, see
            # [Remove a user or a Google Chat app from a
            # space](https://developers.google.com/workspace/chat/delete-members).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator approval](https://support.google.com/a?p=chat-app-auth)
            # and the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.memberships`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - `https://www.googleapis.com/auth/chat.memberships.app` (to remove
            #     the calling app from the space)
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scope is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            #
            # App authentication is not supported for the following use cases:
            #
            # - Removing a Google Group from a space.
            # - Removing a Chat app from a space.
            #
            # To delete memberships for space managers, the requester
            # must be a space manager. If you're using [app
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # the Chat app must be the space creator.
            rpc :DeleteMembership, ::Google::Apps::Chat::V1::DeleteMembershipRequest, ::Google::Apps::Chat::V1::Membership
            # Creates a reaction and adds it to a message. For an example, see
            # [Add a reaction to a
            # message](https://developers.google.com/workspace/chat/create-reactions).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.messages.reactions.create`
            #   - `https://www.googleapis.com/auth/chat.messages.reactions`
            #   - `https://www.googleapis.com/auth/chat.messages`
            #   - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
            rpc :CreateReaction, ::Google::Apps::Chat::V1::CreateReactionRequest, ::Google::Apps::Chat::V1::Reaction
            # Lists reactions to a message. For an example, see
            # [List reactions for a
            # message](https://developers.google.com/workspace/chat/list-reactions).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
            #   - `https://www.googleapis.com/auth/chat.messages.reactions`
            #   - `https://www.googleapis.com/auth/chat.messages.readonly`
            #   - `https://www.googleapis.com/auth/chat.messages`
            rpc :ListReactions, ::Google::Apps::Chat::V1::ListReactionsRequest, ::Google::Apps::Chat::V1::ListReactionsResponse
            # Deletes a reaction to a message. For an example, see
            # [Delete a
            # reaction](https://developers.google.com/workspace/chat/delete-reactions).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.messages.reactions`
            #   - `https://www.googleapis.com/auth/chat.messages`
            #   - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
            rpc :DeleteReaction, ::Google::Apps::Chat::V1::DeleteReactionRequest, ::Google::Protobuf::Empty
            # Creates a custom emoji.
            #
            # Custom emojis are only available for Google Workspace accounts, and the
            # administrator must turn custom emojis on for the organization. For more
            # information, see [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149) and
            # [Manage custom emoji
            # permissions](https://support.google.com/a/answer/12850085).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.customemojis`
            rpc :CreateCustomEmoji, ::Google::Apps::Chat::V1::CreateCustomEmojiRequest, ::Google::Apps::Chat::V1::CustomEmoji
            # Returns details about a custom emoji.
            #
            # Custom emojis are only available for Google Workspace accounts, and the
            # administrator must turn custom emojis on for the organization. For more
            # information, see [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149) and
            # [Manage custom emoji
            # permissions](https://support.google.com/a/answer/12850085).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.customemojis.readonly`
            #   - `https://www.googleapis.com/auth/chat.customemojis`
            rpc :GetCustomEmoji, ::Google::Apps::Chat::V1::GetCustomEmojiRequest, ::Google::Apps::Chat::V1::CustomEmoji
            # Lists custom emojis visible to the authenticated user.
            #
            # Custom emojis are only available for Google Workspace accounts, and the
            # administrator must turn custom emojis on for the organization. For more
            # information, see [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149) and
            # [Manage custom emoji
            # permissions](https://support.google.com/a/answer/12850085).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.customemojis.readonly`
            #   - `https://www.googleapis.com/auth/chat.customemojis`
            rpc :ListCustomEmojis, ::Google::Apps::Chat::V1::ListCustomEmojisRequest, ::Google::Apps::Chat::V1::ListCustomEmojisResponse
            # Deletes a custom emoji. By default, users can only delete custom emoji they
            # created. [Emoji managers](https://support.google.com/a/answer/12850085)
            # assigned by the administrator can delete any custom emoji in the
            # organization. See [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149).
            #
            # Custom emojis are only available for Google Workspace accounts, and the
            # administrator must turn custom emojis on for the organization. For more
            # information, see [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149) and
            # [Manage custom emoji
            # permissions](https://support.google.com/a/answer/12850085).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.customemojis`
            rpc :DeleteCustomEmoji, ::Google::Apps::Chat::V1::DeleteCustomEmojiRequest, ::Google::Protobuf::Empty
            # Returns details about a user's read state within a space, used to identify
            # read and unread messages. For an example, see [Get details about a user's
            # space read
            # state](https://developers.google.com/workspace/chat/get-space-read-state).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.readstate.readonly`
            #   - `https://www.googleapis.com/auth/chat.users.readstate`
            rpc :GetSpaceReadState, ::Google::Apps::Chat::V1::GetSpaceReadStateRequest, ::Google::Apps::Chat::V1::SpaceReadState
            # Updates a user's read state within a space, used to identify read and
            # unread messages. For an example, see [Update a user's space read
            # state](https://developers.google.com/workspace/chat/update-space-read-state).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.readstate`
            rpc :UpdateSpaceReadState, ::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest, ::Google::Apps::Chat::V1::SpaceReadState
            # Returns details about a user's read state within a thread, used to identify
            # read and unread messages. For an example, see [Get details about a user's
            # thread read
            # state](https://developers.google.com/workspace/chat/get-thread-read-state).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.readstate.readonly`
            #   - `https://www.googleapis.com/auth/chat.users.readstate`
            rpc :GetThreadReadState, ::Google::Apps::Chat::V1::GetThreadReadStateRequest, ::Google::Apps::Chat::V1::ThreadReadState
            # Returns an event from a Google Chat space. The [event
            # payload](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.oneof_payload)
            # contains the most recent version of the resource that changed. For example,
            # if you request an event about a new message but the message was later
            # updated, the server returns the updated `Message` resource in the event
            # payload.
            #
            # Note: The `permissionSettings` field is not returned in the Space
            # object of the Space event data for this request.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize)
            # with an
            # [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes)
            # appropriate for reading the requested data:
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) in
            # [Developer Preview](https://developers.google.com/workspace/preview)
            #  with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.app.spaces`
            #     - `https://www.googleapis.com/auth/chat.app.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.app.memberships`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - `https://www.googleapis.com/auth/chat.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages.reactions`
            #     - `https://www.googleapis.com/auth/chat.memberships.readonly`
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #
            # To get an event, the authenticated caller must be a member of the space.
            #
            # For an example, see [Get details about an
            # event from a Google Chat
            # space](https://developers.google.com/workspace/chat/get-space-event).
            rpc :GetSpaceEvent, ::Google::Apps::Chat::V1::GetSpaceEventRequest, ::Google::Apps::Chat::V1::SpaceEvent
            # Lists events from a Google Chat space. For each event, the
            # [payload](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.oneof_payload)
            # contains the most recent version of the Chat resource. For example, if you
            # list events about new space members, the server returns `Membership`
            # resources that contain the latest membership details. If new members were
            # removed during the requested period, the event payload contains an empty
            # `Membership` resource.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize)
            # with an
            # [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes)
            # appropriate for reading the requested data:
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) in
            # [Developer Preview](https://developers.google.com/workspace/preview)
            #  with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.app.spaces`
            #     - `https://www.googleapis.com/auth/chat.app.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.app.memberships`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - `https://www.googleapis.com/auth/chat.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages.reactions`
            #     - `https://www.googleapis.com/auth/chat.memberships.readonly`
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #
            # To list events, the authenticated caller must be a member of the space.
            #
            # For an example, see [List events from a Google Chat
            # space](https://developers.google.com/workspace/chat/list-space-events).
            rpc :ListSpaceEvents, ::Google::Apps::Chat::V1::ListSpaceEventsRequest, ::Google::Apps::Chat::V1::ListSpaceEventsResponse
            # Gets the space notification setting. For an example, see [Get the
            # caller's space notification
            # setting](https://developers.google.com/workspace/chat/get-space-notification-setting).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.spacesettings`
            rpc :GetSpaceNotificationSetting, ::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest, ::Google::Apps::Chat::V1::SpaceNotificationSetting
            # Updates the space notification setting. For an example, see [Update
            # the caller's space notification
            # setting](https://developers.google.com/workspace/chat/update-space-notification-setting).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.spacesettings`
            rpc :UpdateSpaceNotificationSetting, ::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest, ::Google::Apps::Chat::V1::SpaceNotificationSetting
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
