# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/chat/v1/chat_service_pb"

module Google
  module Apps
    module Chat
      module V1
        module ChatService
          ##
          # Client for the ChatService service.
          #
          # Enables developers to build Chat apps and
          # integrations on Google Chat Platform.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "chat.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :chat_service_stub

            ##
            # Configure the ChatService Client class.
            #
            # See {::Google::Apps::Chat::V1::ChatService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ChatService clients
            #   ::Google::Apps::Chat::V1::ChatService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Apps", "Chat", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_message.timeout = 30.0
                default_config.rpcs.create_message.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_messages.timeout = 30.0
                default_config.rpcs.list_messages.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_memberships.timeout = 30.0
                default_config.rpcs.list_memberships.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_membership.timeout = 30.0
                default_config.rpcs.get_membership.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_message.timeout = 30.0
                default_config.rpcs.get_message.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_message.timeout = 30.0
                default_config.rpcs.update_message.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_message.timeout = 30.0
                default_config.rpcs.delete_message.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_attachment.timeout = 30.0
                default_config.rpcs.get_attachment.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.upload_attachment.timeout = 30.0
                default_config.rpcs.upload_attachment.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_spaces.timeout = 30.0
                default_config.rpcs.list_spaces.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.search_spaces.timeout = 30.0
                default_config.rpcs.search_spaces.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_space.timeout = 30.0
                default_config.rpcs.get_space.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_space.timeout = 30.0
                default_config.rpcs.create_space.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.set_up_space.timeout = 30.0
                default_config.rpcs.set_up_space.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_space.timeout = 30.0
                default_config.rpcs.update_space.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_space.timeout = 30.0
                default_config.rpcs.delete_space.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.complete_import_space.timeout = 30.0
                default_config.rpcs.complete_import_space.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.find_direct_message.timeout = 30.0
                default_config.rpcs.find_direct_message.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_membership.timeout = 30.0
                default_config.rpcs.create_membership.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_membership.timeout = 30.0
                default_config.rpcs.update_membership.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_membership.timeout = 30.0
                default_config.rpcs.delete_membership.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_reaction.timeout = 30.0
                default_config.rpcs.create_reaction.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_reactions.timeout = 30.0
                default_config.rpcs.list_reactions.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_reaction.timeout = 30.0
                default_config.rpcs.delete_reaction.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_custom_emoji.timeout = 30.0
                default_config.rpcs.create_custom_emoji.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_custom_emoji.timeout = 30.0
                default_config.rpcs.get_custom_emoji.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_custom_emojis.timeout = 30.0
                default_config.rpcs.list_custom_emojis.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_custom_emoji.timeout = 30.0
                default_config.rpcs.delete_custom_emoji.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_space_read_state.timeout = 30.0
                default_config.rpcs.get_space_read_state.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_space_read_state.timeout = 30.0
                default_config.rpcs.update_space_read_state.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_thread_read_state.timeout = 30.0
                default_config.rpcs.get_thread_read_state.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_space_event.timeout = 30.0
                default_config.rpcs.get_space_event.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_space_events.timeout = 30.0
                default_config.rpcs.list_space_events.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_space_notification_setting.timeout = 30.0
                default_config.rpcs.get_space_notification_setting.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_space_notification_setting.timeout = 30.0
                default_config.rpcs.update_space_notification_setting.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ChatService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Apps::Chat::V1::ChatService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @chat_service_stub.universe_domain
            end

            ##
            # Create a new ChatService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ChatService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/chat/v1/chat_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @chat_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Apps::Chat::V1::ChatService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @chat_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @chat_service_stub.logger
            end

            # Service calls

            ##
            # Creates a message in a Google Chat space. For an example, see [Send a
            # message](https://developers.google.com/workspace/chat/create-messages).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages.create`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # Chat attributes the message sender differently depending on the type of
            # authentication that you use in your request.
            #
            # The following image shows how Chat attributes a message when you use app
            # authentication. Chat displays the Chat app as the message
            # sender. The content of the message can contain text (`text`), cards
            # (`cardsV2`), and accessory widgets (`accessoryWidgets`).
            #
            # ![Message sent with app
            # authentication](https://developers.google.com/workspace/chat/images/message-app-auth.svg)
            #
            # The following image shows how Chat attributes a message when you use user
            # authentication. Chat displays the user as the message sender and attributes
            # the Chat app to the message by displaying its name. The content of message
            # can only contain text (`text`).
            #
            # ![Message sent with user
            # authentication](https://developers.google.com/workspace/chat/images/message-user-auth.svg)
            #
            # The maximum message size, including the message contents, is 32,000 bytes.
            #
            # For
            # [webhook](https://developers.google.com/workspace/chat/quickstart/webhooks)
            # requests, the response doesn't contain the full message. The response only
            # populates the `name` and `thread.name` fields in addition to the
            # information that was in the request.
            #
            # @overload create_message(request, options = nil)
            #   Pass arguments to `create_message` via a request object, either of type
            #   {::Google::Apps::Chat::V1::CreateMessageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::CreateMessageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_message(parent: nil, message: nil, thread_key: nil, request_id: nil, message_reply_option: nil, message_id: nil)
            #   Pass arguments to `create_message` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the space in which to create a message.
            #
            #     Format: `spaces/{space}`
            #   @param message [::Google::Apps::Chat::V1::Message, ::Hash]
            #     Required. Message body.
            #   @param thread_key [::String]
            #     Optional. Deprecated: Use
            #     {::Google::Apps::Chat::V1::Thread#thread_key thread.thread_key} instead. ID for the
            #     thread. Supports up to 4000 characters. To start or add to a thread, create
            #     a message and specify a `threadKey` or the
            #     {::Google::Apps::Chat::V1::Thread#name thread.name}. For example usage, see [Start or
            #     reply to a message
            #     thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
            #   @param request_id [::String]
            #     Optional. A unique request ID for this message. Specifying an existing
            #     request ID returns the message created with that ID instead of creating a
            #     new message.
            #   @param message_reply_option [::Google::Apps::Chat::V1::CreateMessageRequest::MessageReplyOption]
            #     Optional. Specifies whether a message starts a thread or replies to one.
            #     Only supported in named spaces.
            #
            #     When [responding to user
            #     interactions](https://developers.google.com/workspace/chat/receive-respond-interactions),
            #     this field is ignored. For interactions within a thread, the reply is
            #     created in the same thread. Otherwise, the reply is created as a new
            #     thread.
            #   @param message_id [::String]
            #     Optional. A custom ID for a message. Lets Chat apps get, update, or delete
            #     a message without needing to store the system-assigned ID in the message's
            #     resource name (represented in the message `name` field).
            #
            #     The value for this field must meet the following requirements:
            #
            #     * Begins with `client-`. For example, `client-custom-name` is a valid
            #       custom ID, but `custom-name` is not.
            #     * Contains up to 63 characters and only lowercase letters, numbers, and
            #       hyphens.
            #     * Is unique within a space. A Chat app can't use the same custom ID for
            #     different messages.
            #
            #     For details, see [Name a
            #     message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Message]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Message]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::CreateMessageRequest.new
            #
            #   # Call the create_message method.
            #   result = client.create_message request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Message.
            #   p result
            #
            def create_message request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::CreateMessageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_message.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_message.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_message.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :create_message, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists messages in a space that the caller is a member of, including
            # messages from blocked members and spaces. System messages, like those
            # announcing new space members, aren't included. If you list messages from a
            # space with no messages, the response is an empty object. When using a
            # REST/HTTP interface, the response contains an empty JSON object, `{}`.
            # For an example, see
            # [List
            # messages](https://developers.google.com/workspace/chat/api/guides/v1/messages/list).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) in
            # [Developer Preview](https://developers.google.com/workspace/preview)
            #  with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.messages.readonly`. When
            #     using this authentication scope, this method only returns public
            #     messages in a space. It doesn't include private messages.
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # @overload list_messages(request, options = nil)
            #   Pass arguments to `list_messages` via a request object, either of type
            #   {::Google::Apps::Chat::V1::ListMessagesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::ListMessagesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_messages(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, show_deleted: nil)
            #   Pass arguments to `list_messages` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the space to list messages from.
            #
            #     Format: `spaces/{space}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of messages returned. The service might return
            #     fewer messages than this value.
            #
            #     If unspecified, at most 25 are returned.
            #
            #     The maximum value is 1000. If you use a value more than 1000, it's
            #     automatically changed to 1000.
            #
            #     Negative values return an `INVALID_ARGUMENT` error.
            #   @param page_token [::String]
            #     Optional. A page token received from a previous list messages call. Provide
            #     this parameter to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided should match the call that
            #     provided the page token. Passing different values to the other parameters
            #     might lead to unexpected results.
            #   @param filter [::String]
            #     Optional. A query filter.
            #
            #     You can filter messages by date (`create_time`) and thread (`thread.name`).
            #
            #     To filter messages by the date they were created, specify the `create_time`
            #     with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
            #     format and double quotation marks. For example,
            #     `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `>` to
            #     list messages that were created after a timestamp, or the less than
            #     operator `<` to list messages that were created before a timestamp. To
            #     filter messages within a time interval, use the `AND` operator between two
            #     timestamps.
            #
            #     To filter by thread, specify the `thread.name`, formatted as
            #     `spaces/{space}/threads/{thread}`. You can only specify one
            #     `thread.name` per query.
            #
            #     To filter by both thread and date, use the `AND` operator in your query.
            #
            #     For example, the following queries are valid:
            #
            #     ```
            #     create_time > "2012-04-21T11:30:00-04:00"
            #
            #     create_time > "2012-04-21T11:30:00-04:00" AND
            #       thread.name = spaces/AAAAAAAAAAA/threads/123
            #
            #     create_time > "2012-04-21T11:30:00+00:00" AND
            #
            #     create_time < "2013-01-01T00:00:00+00:00" AND
            #       thread.name = spaces/AAAAAAAAAAA/threads/123
            #
            #     thread.name = spaces/AAAAAAAAAAA/threads/123
            #     ```
            #
            #     Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
            #     error.
            #   @param order_by [::String]
            #     Optional. How the list of messages is ordered. Specify a value to order by
            #     an ordering operation. Valid ordering operation values are as follows:
            #
            #     - `ASC` for ascending.
            #
            #     - `DESC` for descending.
            #
            #     The default ordering is `create_time ASC`.
            #   @param show_deleted [::Boolean]
            #     Optional. Whether to include deleted messages. Deleted messages include
            #     deleted time and metadata about their deletion, but message content is
            #     unavailable.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Message>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Message>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::ListMessagesRequest.new
            #
            #   # Call the list_messages method.
            #   result = client.list_messages request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Chat::V1::Message.
            #     p item
            #   end
            #
            def list_messages request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::ListMessagesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_messages.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_messages.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_messages.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :list_messages, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @chat_service_stub, :list_messages, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists memberships in a space. For an example, see [List users and Google
            # Chat apps in a
            # space](https://developers.google.com/workspace/chat/list-members). Listing
            # memberships with [app
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # lists memberships in spaces that the Chat app has
            # access to, but excludes Chat app memberships,
            # including its own. Listing memberships with
            # [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # lists memberships in spaces that the authenticated user has access to.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #     - `https://www.googleapis.com/auth/chat.app.memberships` (requires
            #     [administrator approval](https://support.google.com/a?p=chat-app-auth))
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships.readonly`
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     one of the following authorization scopes is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships.readonly`
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            #
            # @overload list_memberships(request, options = nil)
            #   Pass arguments to `list_memberships` via a request object, either of type
            #   {::Google::Apps::Chat::V1::ListMembershipsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::ListMembershipsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_memberships(parent: nil, page_size: nil, page_token: nil, filter: nil, show_groups: nil, show_invited: nil, use_admin_access: nil)
            #   Pass arguments to `list_memberships` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the space for which to fetch a membership
            #     list.
            #
            #     Format: spaces/\\{space}
            #   @param page_size [::Integer]
            #     Optional. The maximum number of memberships to return. The service might
            #     return fewer than this value.
            #
            #     If unspecified, at most 100 memberships are returned.
            #
            #     The maximum value is 1000. If you use a value more than 1000, it's
            #     automatically changed to 1000.
            #
            #     Negative values return an `INVALID_ARGUMENT` error.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous call to list memberships.
            #     Provide this parameter to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided should match the call that
            #     provided the page token. Passing different values to the other parameters
            #     might lead to unexpected results.
            #   @param filter [::String]
            #     Optional. A query filter.
            #
            #     You can filter memberships by a member's role
            #     ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
            #     and type
            #     ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
            #
            #     To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
            #
            #     To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
            #     filter for `member.type` using the `!=` operator.
            #
            #     To filter by both role and type, use the `AND` operator. To filter by
            #     either role or type, use the `OR` operator.
            #
            #     Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
            #     when `use_admin_access` is set to true. Other member type filters will be
            #     rejected.
            #
            #     For example, the following queries are valid:
            #
            #     ```
            #     role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
            #     member.type = "HUMAN" AND role = "ROLE_MANAGER"
            #
            #     member.type != "BOT"
            #     ```
            #
            #     The following queries are invalid:
            #
            #     ```
            #     member.type = "HUMAN" AND member.type = "BOT"
            #     role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
            #     ```
            #
            #     Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
            #     error.
            #   @param show_groups [::Boolean]
            #     Optional. When `true`, also returns memberships associated with a
            #     {::Google::Apps::Chat::V1::Membership#group_member Google Group}, in
            #     addition to other types of memberships. If a
            #     {::Google::Apps::Chat::V1::ListMembershipsRequest#filter filter} is set,
            #     {::Google::Apps::Chat::V1::Membership#group_member Google Group}
            #     memberships that don't match the filter criteria aren't returned.
            #   @param show_invited [::Boolean]
            #     Optional. When `true`, also returns memberships associated with
            #     {::Google::Apps::Chat::V1::Membership::MembershipState::INVITED invited} members, in
            #     addition to other types of memberships. If a
            #     filter is set,
            #     {::Google::Apps::Chat::V1::Membership::MembershipState::INVITED invited} memberships
            #     that don't match the filter criteria aren't returned.
            #
            #     Currently requires [user
            #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
            #   @param use_admin_access [::Boolean]
            #     Optional. When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires either the `chat.admin.memberships.readonly` or
            #     `chat.admin.memberships` [OAuth 2.0
            #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            #     Listing app memberships in a space isn't supported when using admin access.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Membership>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Membership>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::ListMembershipsRequest.new
            #
            #   # Call the list_memberships method.
            #   result = client.list_memberships request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Chat::V1::Membership.
            #     p item
            #   end
            #
            def list_memberships request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::ListMembershipsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_memberships.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_memberships.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_memberships.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :list_memberships, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @chat_service_stub, :list_memberships, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns details about a membership. For an example, see
            # [Get details about a user's or Google Chat app's
            # membership](https://developers.google.com/workspace/chat/get-members).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #     - `https://www.googleapis.com/auth/chat.app.memberships` (requires
            #     [administrator approval](https://support.google.com/a?p=chat-app-auth))
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships.readonly`
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     one of the following authorization scopes is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships.readonly`
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            #
            # @overload get_membership(request, options = nil)
            #   Pass arguments to `get_membership` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetMembershipRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetMembershipRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_membership(name: nil, use_admin_access: nil)
            #   Pass arguments to `get_membership` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the membership to retrieve.
            #
            #     To get the app's own membership [by using user
            #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
            #     you can optionally use `spaces/{space}/members/app`.
            #
            #     Format: `spaces/{space}/members/{member}` or `spaces/{space}/members/app`
            #
            #     You can use the user's email as an alias for `{member}`. For example,
            #     `spaces/{space}/members/example@gmail.com` where `example@gmail.com` is the
            #     email of the Google Chat user.
            #   @param use_admin_access [::Boolean]
            #     Optional. When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires the `chat.admin.memberships` or `chat.admin.memberships.readonly`
            #     [OAuth 2.0
            #     scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            #     Getting app memberships in a space isn't supported when using admin access.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Membership]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Membership]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetMembershipRequest.new
            #
            #   # Call the get_membership method.
            #   result = client.get_membership request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Membership.
            #   p result
            #
            def get_membership request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetMembershipRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_membership.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_membership.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_membership.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_membership, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns details about a message.
            # For an example, see [Get details about a
            # message](https://developers.google.com/workspace/chat/get-messages).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.bot`: When using this
            #     authorization scope, this method returns details about a message the
            #     Chat app has access to, like direct messages and [slash
            #     commands](https://developers.google.com/workspace/chat/slash-commands)
            #     that invoke the Chat app.
            #     - `https://www.googleapis.com/auth/chat.app.messages.readonly`
            #     with [administrator
            #     approval](https://support.google.com/a?p=chat-app-auth) (available in
            #     [Developer Preview](https://developers.google.com/workspace/preview)).
            #     When using this authentication scope,
            #     this method returns details about a public message in a space.
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #
            # Note: Might return a message from a blocked member or space.
            #
            # @overload get_message(request, options = nil)
            #   Pass arguments to `get_message` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetMessageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetMessageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_message(name: nil)
            #   Pass arguments to `get_message` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the message.
            #
            #     Format: `spaces/{space}/messages/{message}`
            #
            #     If you've set a custom ID for your message, you can use the value from the
            #     `clientAssignedMessageId` field for `{message}`. For details, see [Name a
            #     message]
            #     (https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Message]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Message]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetMessageRequest.new
            #
            #   # Call the get_message method.
            #   result = client.get_message request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Message.
            #   p result
            #
            def get_message request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetMessageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_message.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_message.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_message.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_message, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a message. There's a difference between the `patch` and `update`
            # methods. The `patch`
            # method uses a `patch` request while the `update` method uses a `put`
            # request. We recommend using the `patch` method. For an example, see
            # [Update a
            # message](https://developers.google.com/workspace/chat/update-messages).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # When using app authentication, requests can only update messages
            # created by the calling Chat app.
            #
            # @overload update_message(request, options = nil)
            #   Pass arguments to `update_message` via a request object, either of type
            #   {::Google::Apps::Chat::V1::UpdateMessageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::UpdateMessageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_message(message: nil, update_mask: nil, allow_missing: nil)
            #   Pass arguments to `update_message` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param message [::Google::Apps::Chat::V1::Message, ::Hash]
            #     Required. Message with fields updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The field paths to update. Separate multiple values with commas
            #     or use `*` to update all field paths.
            #
            #     Currently supported field paths:
            #
            #     - `text`
            #
            #     - `attachment`
            #
            #     - `cards` (Requires [app
            #     authentication](/chat/api/guides/auth/service-accounts).)
            #
            #     - `cards_v2`  (Requires [app
            #     authentication](/chat/api/guides/auth/service-accounts).)
            #
            #     - `accessory_widgets`  (Requires [app
            #     authentication](/chat/api/guides/auth/service-accounts).)
            #
            #     - `quoted_message_metadata` (Only allows removal of the quoted message.)
            #   @param allow_missing [::Boolean]
            #     Optional. If `true` and the message isn't found, a new message is created
            #     and `updateMask` is ignored. The specified message ID must be
            #     [client-assigned](https://developers.google.com/workspace/chat/create-messages#name_a_created_message)
            #     or the request fails.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Message]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Message]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::UpdateMessageRequest.new
            #
            #   # Call the update_message method.
            #   result = client.update_message request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Message.
            #   p result
            #
            def update_message request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::UpdateMessageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_message.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.message&.name
                header_params["message.name"] = request.message.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_message.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_message.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :update_message, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a message.
            # For an example, see [Delete a
            # message](https://developers.google.com/workspace/chat/delete-messages).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # When using app authentication, requests can only delete messages
            # created by the calling Chat app.
            #
            # @overload delete_message(request, options = nil)
            #   Pass arguments to `delete_message` via a request object, either of type
            #   {::Google::Apps::Chat::V1::DeleteMessageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::DeleteMessageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_message(name: nil, force: nil)
            #   Pass arguments to `delete_message` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the message.
            #
            #     Format: `spaces/{space}/messages/{message}`
            #
            #     If you've set a custom ID for your message, you can use the value from the
            #     `clientAssignedMessageId` field for `{message}`. For details, see [Name a
            #     message]
            #     (https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
            #   @param force [::Boolean]
            #     Optional. When `true`, deleting a message also deletes its threaded
            #     replies. When `false`, if a message has threaded replies, deletion fails.
            #
            #     Only applies when [authenticating as a
            #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
            #     Has no effect when [authenticating as a Chat app]
            #     (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::DeleteMessageRequest.new
            #
            #   # Call the delete_message method.
            #   result = client.delete_message request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_message request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::DeleteMessageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_message.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_message.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_message.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :delete_message, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the metadata of a message attachment. The attachment data is fetched
            # using the [media
            # API](https://developers.google.com/workspace/chat/api/reference/rest/v1/media/download).
            # For an example, see
            # [Get metadata about a message
            # attachment](https://developers.google.com/workspace/chat/get-media-attachments).
            #
            # Requires [app
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.bot`
            #
            # @overload get_attachment(request, options = nil)
            #   Pass arguments to `get_attachment` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetAttachmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetAttachmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_attachment(name: nil)
            #   Pass arguments to `get_attachment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the attachment, in the form
            #     `spaces/{space}/messages/{message}/attachments/{attachment}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Attachment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Attachment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetAttachmentRequest.new
            #
            #   # Call the get_attachment method.
            #   result = client.get_attachment request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Attachment.
            #   p result
            #
            def get_attachment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetAttachmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_attachment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_attachment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_attachment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_attachment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Uploads an attachment. For an example, see
            # [Upload media as a file
            # attachment](https://developers.google.com/workspace/chat/upload-media-attachments).
            #
            # Requires user
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.messages.create`
            #   - `https://www.googleapis.com/auth/chat.messages`
            #   - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
            #
            # You can upload attachments up to 200 MB. Certain file types aren't
            # supported. For details, see [File types blocked by Google
            # Chat](https://support.google.com/chat/answer/7651457?&co=GENIE.Platform%3DDesktop#File%20types%20blocked%20in%20Google%20Chat).
            #
            # @overload upload_attachment(request, options = nil)
            #   Pass arguments to `upload_attachment` via a request object, either of type
            #   {::Google::Apps::Chat::V1::UploadAttachmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::UploadAttachmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload upload_attachment(parent: nil, filename: nil)
            #   Pass arguments to `upload_attachment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the Chat space in which the attachment is
            #     uploaded. Format "spaces/\\{space}".
            #   @param filename [::String]
            #     Required. The filename of the attachment, including the file extension.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::UploadAttachmentResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::UploadAttachmentResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::UploadAttachmentRequest.new
            #
            #   # Call the upload_attachment method.
            #   result = client.upload_attachment request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::UploadAttachmentResponse.
            #   p result
            #
            def upload_attachment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::UploadAttachmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.upload_attachment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.upload_attachment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.upload_attachment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :upload_attachment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists spaces the caller is a member of. Group chats and DMs aren't listed
            # until the first message is sent. For an example, see
            # [List
            # spaces](https://developers.google.com/workspace/chat/list-spaces).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #
            # To list all named spaces by Google Workspace organization, use the
            # [`spaces.search()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/search)
            # method using Workspace administrator privileges instead.
            #
            # @overload list_spaces(request, options = nil)
            #   Pass arguments to `list_spaces` via a request object, either of type
            #   {::Google::Apps::Chat::V1::ListSpacesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::ListSpacesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_spaces(page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_spaces` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param page_size [::Integer]
            #     Optional. The maximum number of spaces to return. The service might return
            #     fewer than this value.
            #
            #     If unspecified, at most 100 spaces are returned.
            #
            #     The maximum value is 1000. If you use a value more than 1000, it's
            #     automatically changed to 1000.
            #
            #     Negative values return an `INVALID_ARGUMENT` error.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous list spaces call.
            #     Provide this parameter to retrieve the subsequent page.
            #
            #     When paginating, the filter value should match the call that provided the
            #     page token. Passing a different value may lead to unexpected results.
            #   @param filter [::String]
            #     Optional. A query filter.
            #
            #     You can filter spaces by the space type
            #     ([`space_type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#spacetype)).
            #
            #     To filter by space type, you must specify valid enum value, such as
            #     `SPACE` or `GROUP_CHAT` (the `space_type` can't be
            #     `SPACE_TYPE_UNSPECIFIED`). To query for multiple space types, use the `OR`
            #     operator.
            #
            #     For example, the following queries are valid:
            #
            #     ```
            #     space_type = "SPACE"
            #     spaceType = "GROUP_CHAT" OR spaceType = "DIRECT_MESSAGE"
            #     ```
            #
            #     Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
            #     error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Space>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Space>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::ListSpacesRequest.new
            #
            #   # Call the list_spaces method.
            #   result = client.list_spaces request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Chat::V1::Space.
            #     p item
            #   end
            #
            def list_spaces request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::ListSpacesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_spaces.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_spaces.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_spaces.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :list_spaces, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @chat_service_stub, :list_spaces, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of spaces in a Google Workspace organization based on an
            # administrator's search. In the request, set `use_admin_access` to `true`.
            # For an example, see [Search for and manage
            # spaces](https://developers.google.com/workspace/chat/search-manage-admin).
            #
            # Requires [user
            # authentication with administrator
            # privileges](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user#admin-privileges)
            # and one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.admin.spaces.readonly`
            #   - `https://www.googleapis.com/auth/chat.admin.spaces`
            #
            # @overload search_spaces(request, options = nil)
            #   Pass arguments to `search_spaces` via a request object, either of type
            #   {::Google::Apps::Chat::V1::SearchSpacesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::SearchSpacesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_spaces(use_admin_access: nil, page_size: nil, page_token: nil, query: nil, order_by: nil)
            #   Pass arguments to `search_spaces` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param use_admin_access [::Boolean]
            #     When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
            #     [OAuth 2.0
            #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            #     This method currently only supports admin access, thus only `true` is
            #     accepted for this field.
            #   @param page_size [::Integer]
            #     The maximum number of spaces to return. The service may return fewer than
            #     this value.
            #
            #     If unspecified, at most 100 spaces are returned.
            #
            #     The maximum value is 1000. If you use a value more than 1000, it's
            #     automatically changed to 1000.
            #   @param page_token [::String]
            #     A token, received from the previous search spaces call. Provide this
            #     parameter to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided should match the call that
            #     provided the page token. Passing different values to the other parameters
            #     might lead to unexpected results.
            #   @param query [::String]
            #     Required. A search query.
            #
            #     You can search by using the following parameters:
            #
            #     - `create_time`
            #     - `customer`
            #     - `display_name`
            #     - `external_user_allowed`
            #     - `last_active_time`
            #     - `space_history_state`
            #     - `space_type`
            #
            #     `create_time` and `last_active_time` accept a timestamp in
            #     [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
            #     comparison operators are: `=`, `<`, `>`, `<=`, `>=`.
            #
            #     `customer` is required and is used to indicate which customer
            #     to fetch spaces from. `customers/my_customer` is the only supported value.
            #
            #     `display_name` only accepts the `HAS` (`:`) operator. The text to
            #     match is first tokenized into tokens and each token is prefix-matched
            #     case-insensitively and independently as a substring anywhere in the space's
            #     `display_name`. For example, `Fun Eve` matches `Fun event` or `The
            #     evening was fun`, but not `notFun event` or `even`.
            #
            #     `external_user_allowed` accepts either `true` or `false`.
            #
            #     `space_history_state` only accepts values from the [`historyState`]
            #     (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
            #     field of a `space` resource.
            #
            #     `space_type` is required and the only valid value is `SPACE`.
            #
            #     Across different fields, only `AND` operators are supported. A valid
            #     example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
            #     example is `space_type = "SPACE" OR display_name:"Hello"`.
            #
            #     Among the same field,
            #     `space_type` doesn't support `AND` or `OR` operators.
            #     `display_name`, 'space_history_state', and 'external_user_allowed' only
            #     support `OR` operators.
            #     `last_active_time` and `create_time` support both `AND` and `OR` operators.
            #     `AND` can only be used to represent an interval, such as `last_active_time
            #     < "2022-01-01T00:00:00+00:00" AND last_active_time >
            #     "2023-01-01T00:00:00+00:00"`.
            #
            #     The following example queries are valid:
            #
            #     ```
            #     customer = "customers/my_customer" AND space_type = "SPACE"
            #
            #     customer = "customers/my_customer" AND space_type = "SPACE" AND
            #     display_name:"Hello World"
            #
            #     customer = "customers/my_customer" AND space_type = "SPACE" AND
            #     (last_active_time < "2020-01-01T00:00:00+00:00" OR last_active_time >
            #     "2022-01-01T00:00:00+00:00")
            #
            #     customer = "customers/my_customer" AND space_type = "SPACE" AND
            #     (display_name:"Hello World" OR display_name:"Fun event") AND
            #     (last_active_time > "2020-01-01T00:00:00+00:00" AND last_active_time <
            #     "2022-01-01T00:00:00+00:00")
            #
            #     customer = "customers/my_customer" AND space_type = "SPACE" AND
            #     (create_time > "2019-01-01T00:00:00+00:00" AND create_time <
            #     "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
            #     (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
            #     ```
            #   @param order_by [::String]
            #     Optional. How the list of spaces is ordered.
            #
            #     Supported attributes to order by are:
            #
            #     - `membership_count.joined_direct_human_user_count` — Denotes the count of
            #     human users that have directly joined a space.
            #     - `last_active_time` — Denotes the time when last eligible item is added to
            #     any topic of this space.
            #     - `create_time` — Denotes the time of the space creation.
            #
            #     Valid ordering operation values are:
            #
            #     - `ASC` for ascending. Default value.
            #
            #     - `DESC` for descending.
            #
            #     The supported syntax are:
            #
            #     - `membership_count.joined_direct_human_user_count DESC`
            #     - `membership_count.joined_direct_human_user_count ASC`
            #     - `last_active_time DESC`
            #     - `last_active_time ASC`
            #     - `create_time DESC`
            #     - `create_time ASC`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Space>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Space>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::SearchSpacesRequest.new
            #
            #   # Call the search_spaces method.
            #   result = client.search_spaces request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Chat::V1::Space.
            #     p item
            #   end
            #
            def search_spaces request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::SearchSpacesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_spaces.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.search_spaces.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_spaces.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :search_spaces, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @chat_service_stub, :search_spaces, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns details about a space. For an example, see
            # [Get details about a
            # space](https://developers.google.com/workspace/chat/get-spaces).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #     - `https://www.googleapis.com/auth/chat.app.spaces` with [administrator
            #     approval](https://support.google.com/a?p=chat-app-auth)
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     one of the following authorization scopes is used:
            #         - `https://www.googleapis.com/auth/chat.admin.spaces.readonly`
            #         - `https://www.googleapis.com/auth/chat.admin.spaces`
            #
            # App authentication has the following limitations:
            #
            # - `space.access_settings` is only populated when using the
            # `chat.app.spaces` scope.
            # - `space.predefind_permission_settings` and `space.permission_settings` are
            # only populated when using the `chat.app.spaces` scope, and only for
            # spaces the app created.
            #
            # @overload get_space(request, options = nil)
            #   Pass arguments to `get_space` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetSpaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetSpaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_space(name: nil, use_admin_access: nil)
            #   Pass arguments to `get_space` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the space, in the form `spaces/{space}`.
            #
            #     Format: `spaces/{space}`
            #   @param use_admin_access [::Boolean]
            #     Optional. When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires the `chat.admin.spaces` or `chat.admin.spaces.readonly` [OAuth 2.0
            #     scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Space]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Space]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetSpaceRequest.new
            #
            #   # Call the get_space method.
            #   result = client.get_space request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Space.
            #   p result
            #
            def get_space request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetSpaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_space.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_space.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_space.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_space, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a space. Can be used to create a named space, or a
            # group chat in `Import mode`. For an example, see [Create a
            # space](https://developers.google.com/workspace/chat/create-spaces).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator approval](https://support.google.com/a?p=chat-app-auth)
            # and one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.app.spaces.create`
            #     - `https://www.googleapis.com/auth/chat.app.spaces`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.create`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #
            # When authenticating as an app, the `space.customer` field must be set in
            # the request.
            #
            # When authenticating as an app, the Chat app is added as a member of the
            # space. However, unlike human authentication, the Chat app is not added as a
            # space manager. By default, the Chat app can be removed from the space by
            # all space members. To allow only space managers to remove the app from a
            # space, set `space.permission_settings.manage_apps` to `managers_allowed`.
            #
            # Space membership upon creation depends on whether the space is created in
            # `Import mode`:
            #
            # * **Import mode:** No members are created.
            # * **All other modes:**  The calling user is added as a member. This is:
            #     * The app itself when using app authentication.
            #     * The human user when using user authentication.
            #
            #  If you receive the error message `ALREADY_EXISTS` when creating
            #  a space, try a different `displayName`. An existing space within
            #  the Google Workspace organization might already use this display name.
            #
            # @overload create_space(request, options = nil)
            #   Pass arguments to `create_space` via a request object, either of type
            #   {::Google::Apps::Chat::V1::CreateSpaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::CreateSpaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_space(space: nil, request_id: nil)
            #   Pass arguments to `create_space` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param space [::Google::Apps::Chat::V1::Space, ::Hash]
            #     Required. The `displayName` and `spaceType` fields must be populated.  Only
            #     `SpaceType.SPACE`  and `SpaceType.GROUP_CHAT` are supported.
            #     `SpaceType.GROUP_CHAT` can only be used if `importMode` is set to true.
            #
            #     If you receive the error message `ALREADY_EXISTS`,
            #     try a different `displayName`. An existing space within the Google
            #     Workspace organization might already use this display name.
            #
            #
            #     The space `name` is assigned on the server so anything specified in this
            #     field will be ignored.
            #   @param request_id [::String]
            #     Optional. A unique identifier for this request.
            #     A random UUID is recommended.
            #     Specifying an existing request ID returns the space created with that ID
            #     instead of creating a new space.
            #     Specifying an existing request ID from the same Chat app with a different
            #     authenticated user returns an error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Space]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Space]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::CreateSpaceRequest.new
            #
            #   # Call the create_space method.
            #   result = client.create_space request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Space.
            #   p result
            #
            def create_space request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::CreateSpaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_space.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.create_space.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_space.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :create_space, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a space and adds specified users to it. The calling user is
            # automatically added to the space, and shouldn't be specified as a
            # membership in the request. For an example, see
            # [Set up a space with initial
            # members](https://developers.google.com/workspace/chat/set-up-spaces).
            #
            # To specify the human members to add, add memberships with the appropriate
            # `membership.member.name`. To add a human user, use `users/{user}`, where
            # `{user}` can be the email address for the user. For users in the same
            # Workspace organization `{user}` can also be the `id` for the person from
            # the People API, or the `id` for the user in the Directory API. For example,
            # if the People API Person profile ID for `user@example.com` is `123456789`,
            # you can add the user to the space by setting the `membership.member.name`
            # to `users/user@example.com` or `users/123456789`.
            #
            # To specify the Google groups to add, add memberships with the
            # appropriate `membership.group_member.name`. To add or invite a Google
            # group, use `groups/{group}`, where `{group}` is the `id` for the group from
            # the Cloud Identity Groups API. For example, you can use [Cloud Identity
            # Groups lookup
            # API](https://cloud.google.com/identity/docs/reference/rest/v1/groups/lookup)
            # to retrieve the ID `123456789` for group email `group@example.com`, then
            # you can add the group to the space by setting the
            # `membership.group_member.name` to `groups/123456789`. Group email is not
            # supported, and Google groups can only be added as members in named spaces.
            #
            # For a named space or group chat, if the caller blocks, or is blocked
            # by some members, or doesn't have permission to add some members, then
            # those members aren't added to the created space.
            #
            # To create a direct message (DM) between the calling user and another human
            # user, specify exactly one membership to represent the human user. If
            # one user blocks the other, the request fails and the DM isn't created.
            #
            # To create a DM between the calling user and the calling app, set
            # `Space.singleUserBotDm` to `true` and don't specify any memberships. You
            # can only use this method to set up a DM with the calling app. To add the
            # calling app as a member of a space or an existing DM between two human
            # users, see
            # [Invite or add a user or app to a
            # space](https://developers.google.com/workspace/chat/create-members).
            #
            # If a DM already exists between two users, even when one user blocks the
            # other at the time a request is made, then the existing DM is returned.
            #
            # Spaces with threaded replies aren't supported. If you receive the error
            # message `ALREADY_EXISTS` when setting up a space, try a different
            # `displayName`. An existing space within the Google Workspace organization
            # might already use this display name.
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.spaces.create`
            #   - `https://www.googleapis.com/auth/chat.spaces`
            #
            # @overload set_up_space(request, options = nil)
            #   Pass arguments to `set_up_space` via a request object, either of type
            #   {::Google::Apps::Chat::V1::SetUpSpaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::SetUpSpaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_up_space(space: nil, request_id: nil, memberships: nil)
            #   Pass arguments to `set_up_space` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param space [::Google::Apps::Chat::V1::Space, ::Hash]
            #     Required. The `Space.spaceType` field is required.
            #
            #     To create a space, set `Space.spaceType` to `SPACE` and set
            #     `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
            #     setting up a space, try a different `displayName`. An existing space
            #     within the Google Workspace organization might already use this display
            #     name.
            #
            #     To create a group chat, set `Space.spaceType` to
            #     `GROUP_CHAT`. Don't set `Space.displayName`.
            #
            #     To create a 1:1 conversation between humans,
            #     set `Space.spaceType` to `DIRECT_MESSAGE` and set
            #     `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
            #     `Space.spaceDetails`.
            #
            #     To create an 1:1 conversation between a human and the calling Chat app, set
            #     `Space.spaceType` to `DIRECT_MESSAGE` and
            #     `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
            #     `Space.spaceDetails`.
            #
            #     If a `DIRECT_MESSAGE` space already exists, that space is returned instead
            #     of creating a new space.
            #   @param request_id [::String]
            #     Optional. A unique identifier for this request.
            #     A random UUID is recommended.
            #     Specifying an existing request ID returns the space created with that ID
            #     instead of creating a new space.
            #     Specifying an existing request ID from the same Chat app with a different
            #     authenticated user returns an error.
            #   @param memberships [::Array<::Google::Apps::Chat::V1::Membership, ::Hash>]
            #     Optional. The Google Chat users or groups to invite to join the space. Omit
            #     the calling user, as they are added automatically.
            #
            #     The set currently allows up to 49 memberships (in addition to the caller).
            #
            #     For human membership, the `Membership.member` field must contain a `user`
            #     with `name` populated (format: `users/{user}`) and `type` set to
            #     `User.Type.HUMAN`. You can only add human users when setting up a space
            #     (adding Chat apps is only supported for direct message setup with the
            #     calling app). You can also add members using the user's email as an alias
            #     for \\{user}. For example, the `user.name` can be `users/example@gmail.com`.
            #     To invite Gmail users or users from external Google Workspace domains,
            #     user's email must be used for `{user}`.
            #
            #     For Google group membership, the `Membership.group_member` field must
            #     contain a `group` with `name` populated (format `groups/{group}`). You
            #     can only add Google groups when setting `Space.spaceType` to `SPACE`.
            #
            #     Optional when setting `Space.spaceType` to `SPACE`.
            #
            #     Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
            #     least two memberships.
            #
            #     Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
            #     user, along with exactly one membership.
            #
            #     Must be empty when creating a 1:1 conversation between a human and the
            #     calling Chat app (when setting `Space.spaceType` to
            #     `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Space]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Space]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::SetUpSpaceRequest.new
            #
            #   # Call the set_up_space method.
            #   result = client.set_up_space request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Space.
            #   p result
            #
            def set_up_space request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::SetUpSpaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_up_space.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.set_up_space.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_up_space.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :set_up_space, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a space. For an example, see
            # [Update a
            # space](https://developers.google.com/workspace/chat/update-spaces).
            #
            # If you're updating the `displayName` field and receive the error message
            # `ALREADY_EXISTS`, try a different display name.. An existing space within
            # the Google Workspace organization might already use this display name.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator approval](https://support.google.com/a?p=chat-app-auth)
            # and one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.app.spaces`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scopes is used:
            #         - `https://www.googleapis.com/auth/chat.admin.spaces`
            #
            # App authentication has the following limitations:
            #
            # - To update either `space.predefined_permission_settings` or
            # `space.permission_settings`, the app must be the space creator.
            # - Updating the `space.access_settings.audience` is not supported for app
            # authentication.
            #
            # @overload update_space(request, options = nil)
            #   Pass arguments to `update_space` via a request object, either of type
            #   {::Google::Apps::Chat::V1::UpdateSpaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::UpdateSpaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_space(space: nil, update_mask: nil, use_admin_access: nil)
            #   Pass arguments to `update_space` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param space [::Google::Apps::Chat::V1::Space, ::Hash]
            #     Required. Space with fields to be updated. `Space.name` must be
            #     populated in the form of `spaces/{space}`. Only fields
            #     specified by `update_mask` are updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The updated field paths, comma separated if there are
            #     multiple.
            #
            #     You can update the following fields for a space:
            #
            #     `space_details`: Updates the space's description and guidelines. You must
            #     pass both description and guidelines in the update request as
            #     {::Google::Apps::Chat::V1::Space::SpaceDetails `SpaceDetails`}. If you only want to
            #     update one of the fields, pass the existing value for the other field.
            #
            #     `display_name`: Only supports updating the display name for spaces where
            #     `spaceType` field is `SPACE`.
            #      If you receive the error message `ALREADY_EXISTS`, try a different
            #      value. An existing space within the
            #     Google Workspace organization might already use this display name.
            #
            #     `space_type`: Only supports changing a `GROUP_CHAT` space type to
            #     `SPACE`. Include `display_name` together
            #     with `space_type` in the update mask and ensure that the specified space
            #     has a non-empty display name and the `SPACE` space type. Including the
            #     `space_type` mask and the `SPACE` type in the specified space when updating
            #     the display name is optional if the existing space already has the `SPACE`
            #     type. Trying to update the space type in other ways results in an invalid
            #     argument error.
            #     `space_type` is not supported with `useAdminAccess`.
            #
            #     `space_history_state`: Updates [space history
            #     settings](https://support.google.com/chat/answer/7664687) by turning
            #     history on or off for the space. Only supported if history settings are
            #     enabled for the Google Workspace organization. To update the
            #     space history state, you must omit all other field masks in your request.
            #     `space_history_state` is not supported with `useAdminAccess`.
            #
            #     `access_settings.audience`: Updates the [access
            #     setting](https://support.google.com/chat/answer/11971020) of who can
            #     discover the space, join the space, and preview the messages in named space
            #     where `spaceType` field is `SPACE`. If the existing space has a
            #     target audience, you can remove the audience and restrict space access by
            #     omitting a value for this field mask. To update access settings for a
            #     space, the authenticating user must be a space manager and omit all other
            #     field masks in your request. You can't update this field if the space is in
            #     [import
            #     mode](https://developers.google.com/workspace/chat/import-data-overview).
            #     To learn more, see [Make a space discoverable to specific
            #     users](https://developers.google.com/workspace/chat/space-target-audience).
            #     `access_settings.audience` is not supported with `useAdminAccess`.
            #
            #     `permission_settings`: Supports changing the
            #     [permission settings](https://support.google.com/chat/answer/13340792)
            #     of a space.
            #     When updating permission settings, you can only specify
            #     `permissionSettings` field masks; you cannot update other field masks
            #     at the same time.
            #     The supported field masks include:
            #
            #     - `permission_settings.manageMembersAndGroups`
            #     - `permission_settings.modifySpaceDetails`
            #     - `permission_settings.toggleHistory`
            #     - `permission_settings.useAtMentionAll`
            #     - `permission_settings.manageApps`
            #     - `permission_settings.manageWebhooks`
            #     - `permission_settings.replyMessages`
            #   @param use_admin_access [::Boolean]
            #     Optional. When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires the `chat.admin.spaces` [OAuth 2.0
            #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            #     Some `FieldMask` values are not supported using admin access. For details,
            #     see the description of `update_mask`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Space]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Space]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::UpdateSpaceRequest.new
            #
            #   # Call the update_space method.
            #   result = client.update_space request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Space.
            #   p result
            #
            def update_space request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::UpdateSpaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_space.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.space&.name
                header_params["space.name"] = request.space.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_space.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_space.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :update_space, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a named space. Always performs a cascading delete, which means
            # that the space's child resources—like messages posted in the space and
            # memberships in the space—are also deleted. For an example, see
            # [Delete a
            # space](https://developers.google.com/workspace/chat/delete-spaces).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) and the
            # authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.delete` (only in
            #     spaces the app created)
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.delete`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scope is used:
            #         - `https://www.googleapis.com/auth/chat.admin.delete`
            #
            # @overload delete_space(request, options = nil)
            #   Pass arguments to `delete_space` via a request object, either of type
            #   {::Google::Apps::Chat::V1::DeleteSpaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::DeleteSpaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_space(name: nil, use_admin_access: nil)
            #   Pass arguments to `delete_space` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the space to delete.
            #
            #     Format: `spaces/{space}`
            #   @param use_admin_access [::Boolean]
            #     Optional. When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires the `chat.admin.delete` [OAuth 2.0
            #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::DeleteSpaceRequest.new
            #
            #   # Call the delete_space method.
            #   result = client.delete_space request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_space request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::DeleteSpaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_space.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_space.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_space.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :delete_space, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Completes the
            # [import process](https://developers.google.com/workspace/chat/import-data)
            # for the specified space and makes it visible to users.
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # and domain-wide delegation with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.import`
            #
            # For more information, see [Authorize Google
            # Chat apps to import
            # data](https://developers.google.com/workspace/chat/authorize-import).
            #
            # @overload complete_import_space(request, options = nil)
            #   Pass arguments to `complete_import_space` via a request object, either of type
            #   {::Google::Apps::Chat::V1::CompleteImportSpaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::CompleteImportSpaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload complete_import_space(name: nil)
            #   Pass arguments to `complete_import_space` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the import mode space.
            #
            #     Format: `spaces/{space}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::CompleteImportSpaceResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::CompleteImportSpaceResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::CompleteImportSpaceRequest.new
            #
            #   # Call the complete_import_space method.
            #   result = client.complete_import_space request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::CompleteImportSpaceResponse.
            #   p result
            #
            def complete_import_space request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::CompleteImportSpaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.complete_import_space.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.complete_import_space.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.complete_import_space.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :complete_import_space, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the existing direct message with the specified user. If no direct
            # message space is found, returns a `404 NOT_FOUND` error. For an example,
            # see
            # [Find a direct message](/chat/api/guides/v1/spaces/find-direct-message).
            #
            # With [app
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app),
            # returns the direct message space between the specified user and the calling
            # Chat app.
            #
            # With [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
            # returns the direct message space between the specified user and the
            # authenticated user.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.bot`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #
            # @overload find_direct_message(request, options = nil)
            #   Pass arguments to `find_direct_message` via a request object, either of type
            #   {::Google::Apps::Chat::V1::FindDirectMessageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::FindDirectMessageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload find_direct_message(name: nil)
            #   Pass arguments to `find_direct_message` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the user to find direct message with.
            #
            #     Format: `users/{user}`, where `{user}` is either the `id` for the
            #     [person](https://developers.google.com/people/api/rest/v1/people) from the
            #     People API, or the `id` for the
            #     [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
            #     in the Directory API. For example, if the People API profile ID is
            #     `123456789`, you can find a direct message with that person by using
            #     `users/123456789` as the `name`. When [authenticated as a
            #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
            #     you can use the email as an alias for `{user}`. For example,
            #     `users/example@gmail.com` where `example@gmail.com` is the email of the
            #     Google Chat user.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Space]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Space]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::FindDirectMessageRequest.new
            #
            #   # Call the find_direct_message method.
            #   result = client.find_direct_message request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Space.
            #   p result
            #
            def find_direct_message request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::FindDirectMessageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.find_direct_message.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.find_direct_message.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.find_direct_message.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :find_direct_message, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a membership for the calling Chat app, a user, or a Google Group.
            # Creating memberships for other Chat apps isn't supported.
            # When creating a membership, if the specified member has their auto-accept
            # policy turned off, then they're invited, and must accept the space
            # invitation before joining. Otherwise, creating a membership adds the member
            # directly to the specified space.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator approval](https://support.google.com/a?p=chat-app-auth)
            # and the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.memberships`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - `https://www.googleapis.com/auth/chat.memberships.app` (to add the
            #     calling app to the space)
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scope is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            #
            # App authentication is not supported for the following use cases:
            #
            # - Inviting users external to the Workspace organization that owns the
            # space.
            # - Adding a Google Group to a space.
            # - Adding a Chat app to a space.
            #
            # For example usage, see:
            #
            # - [Invite or add a user to a
            # space](https://developers.google.com/workspace/chat/create-members#create-user-membership).
            # - [Invite or add a Google Group to a
            # space](https://developers.google.com/workspace/chat/create-members#create-group-membership).
            # - [Add the Chat app to a
            # space](https://developers.google.com/workspace/chat/create-members#create-membership-calling-api).
            #
            # @overload create_membership(request, options = nil)
            #   Pass arguments to `create_membership` via a request object, either of type
            #   {::Google::Apps::Chat::V1::CreateMembershipRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::CreateMembershipRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_membership(parent: nil, membership: nil, use_admin_access: nil)
            #   Pass arguments to `create_membership` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the space for which to create the
            #     membership.
            #
            #     Format: spaces/\\{space}
            #   @param membership [::Google::Apps::Chat::V1::Membership, ::Hash]
            #     Required. The membership relation to create.
            #
            #     The `memberType` field must contain a user with the `user.name` and
            #     `user.type` fields populated. The server will assign a resource name
            #     and overwrite anything specified.
            #
            #     When a Chat app creates a membership relation for a human user, it must use
            #     certain authorization scopes and set specific values for certain fields:
            #
            #     - When [authenticating as a
            #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
            #     the `chat.memberships` authorization scope is required.
            #
            #     - When [authenticating as an
            #     app](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app),
            #     the `chat.app.memberships` authorization scope is required.
            #
            #     - Set `user.type` to `HUMAN`, and set `user.name` with format
            #     `users/{user}`, where `{user}` can be the email address for the user. For
            #     users in the same Workspace organization `{user}` can also be the `id` of
            #     the [person](https://developers.google.com/people/api/rest/v1/people) from
            #     the People API, or the `id` for the user in the Directory API. For example,
            #     if the People API Person profile ID for `user@example.com` is `123456789`,
            #     you can add the user to the space by setting the `membership.member.name`
            #     to `users/user@example.com` or `users/123456789`.
            #
            #     Inviting users external to the Workspace organization that owns the space
            #     requires [user
            #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
            #
            #     When a Chat app creates a membership relation for itself, it must
            #     [authenticate as a
            #     user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            #     and use the `chat.memberships.app` scope, set `user.type` to `BOT`, and set
            #     `user.name` to `users/app`.
            #   @param use_admin_access [::Boolean]
            #     Optional. When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires the `chat.admin.memberships` [OAuth 2.0
            #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            #     Creating app memberships or creating memberships for users outside the
            #     administrator's Google Workspace organization isn't supported using admin
            #     access.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Membership]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Membership]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::CreateMembershipRequest.new
            #
            #   # Call the create_membership method.
            #   result = client.create_membership request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Membership.
            #   p result
            #
            def create_membership request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::CreateMembershipRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_membership.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_membership.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_membership.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :create_membership, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a membership. For an example, see [Update a user's membership in
            # a space](https://developers.google.com/workspace/chat/update-members).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) and the
            # authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.memberships` (only in
            #     spaces the app created)
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scope is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            #
            # @overload update_membership(request, options = nil)
            #   Pass arguments to `update_membership` via a request object, either of type
            #   {::Google::Apps::Chat::V1::UpdateMembershipRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::UpdateMembershipRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_membership(membership: nil, update_mask: nil, use_admin_access: nil)
            #   Pass arguments to `update_membership` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param membership [::Google::Apps::Chat::V1::Membership, ::Hash]
            #     Required. The membership to update. Only fields specified by `update_mask`
            #     are updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The field paths to update. Separate multiple values with commas
            #     or use `*` to update all field paths.
            #
            #     Currently supported field paths:
            #
            #     - `role`
            #   @param use_admin_access [::Boolean]
            #     Optional. When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires the `chat.admin.memberships` [OAuth 2.0
            #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Membership]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Membership]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::UpdateMembershipRequest.new
            #
            #   # Call the update_membership method.
            #   result = client.update_membership request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Membership.
            #   p result
            #
            def update_membership request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::UpdateMembershipRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_membership.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.membership&.name
                header_params["membership.name"] = request.membership.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_membership.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_membership.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :update_membership, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a membership. For an example, see
            # [Remove a user or a Google Chat app from a
            # space](https://developers.google.com/workspace/chat/delete-members).
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator approval](https://support.google.com/a?p=chat-app-auth)
            # and the authorization scope:
            #     - `https://www.googleapis.com/auth/chat.app.memberships`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #     - `https://www.googleapis.com/auth/chat.memberships.app` (to remove
            #     the calling app from the space)
            #     - `https://www.googleapis.com/auth/chat.import` (import mode spaces
            #     only)
            #     - User authentication grants administrator privileges when an
            #     administrator account authenticates, `use_admin_access` is `true`, and
            #     the following authorization scope is used:
            #         - `https://www.googleapis.com/auth/chat.admin.memberships`
            #
            # App authentication is not supported for the following use cases:
            #
            # - Removing a Google Group from a space.
            # - Removing a Chat app from a space.
            #
            # To delete memberships for space managers, the requester
            # must be a space manager. If you're using [app
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # the Chat app must be the space creator.
            #
            # @overload delete_membership(request, options = nil)
            #   Pass arguments to `delete_membership` via a request object, either of type
            #   {::Google::Apps::Chat::V1::DeleteMembershipRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::DeleteMembershipRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_membership(name: nil, use_admin_access: nil)
            #   Pass arguments to `delete_membership` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the membership to delete. Chat apps can delete
            #     human users' or their own memberships. Chat apps can't delete other apps'
            #     memberships.
            #
            #     When deleting a human membership, requires the `chat.memberships` scope
            #     with [user
            #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            #     or the `chat.memberships.app` scope with [app
            #     authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            #     and the `spaces/{space}/members/{member}` format.
            #     You can use the email as an alias for `{member}`. For example,
            #     `spaces/{space}/members/example@gmail.com` where `example@gmail.com` is the
            #     email of the Google Chat user.
            #
            #     When deleting an app membership, requires the `chat.memberships.app` scope
            #     and `spaces/{space}/members/app` format.
            #
            #     Format: `spaces/{space}/members/{member}` or `spaces/{space}/members/app`.
            #   @param use_admin_access [::Boolean]
            #     Optional. When `true`, the method runs using the user's Google Workspace
            #     administrator privileges.
            #
            #     The calling user must be a Google Workspace administrator with the
            #     [manage chat and spaces conversations
            #     privilege](https://support.google.com/a/answer/13369245).
            #
            #     Requires the `chat.admin.memberships` [OAuth 2.0
            #     scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
            #
            #     Deleting app memberships in a space isn't supported using admin access.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Membership]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Membership]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::DeleteMembershipRequest.new
            #
            #   # Call the delete_membership method.
            #   result = client.delete_membership request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Membership.
            #   p result
            #
            def delete_membership request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::DeleteMembershipRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_membership.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_membership.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_membership.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :delete_membership, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a reaction and adds it to a message. For an example, see
            # [Add a reaction to a
            # message](https://developers.google.com/workspace/chat/create-reactions).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.messages.reactions.create`
            #   - `https://www.googleapis.com/auth/chat.messages.reactions`
            #   - `https://www.googleapis.com/auth/chat.messages`
            #   - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
            #
            # @overload create_reaction(request, options = nil)
            #   Pass arguments to `create_reaction` via a request object, either of type
            #   {::Google::Apps::Chat::V1::CreateReactionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::CreateReactionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_reaction(parent: nil, reaction: nil)
            #   Pass arguments to `create_reaction` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The message where the reaction is created.
            #
            #     Format: `spaces/{space}/messages/{message}`
            #   @param reaction [::Google::Apps::Chat::V1::Reaction, ::Hash]
            #     Required. The reaction to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::Reaction]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::Reaction]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::CreateReactionRequest.new
            #
            #   # Call the create_reaction method.
            #   result = client.create_reaction request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::Reaction.
            #   p result
            #
            def create_reaction request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::CreateReactionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_reaction.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_reaction.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_reaction.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :create_reaction, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists reactions to a message. For an example, see
            # [List reactions for a
            # message](https://developers.google.com/workspace/chat/list-reactions).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
            #   - `https://www.googleapis.com/auth/chat.messages.reactions`
            #   - `https://www.googleapis.com/auth/chat.messages.readonly`
            #   - `https://www.googleapis.com/auth/chat.messages`
            #
            # @overload list_reactions(request, options = nil)
            #   Pass arguments to `list_reactions` via a request object, either of type
            #   {::Google::Apps::Chat::V1::ListReactionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::ListReactionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_reactions(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_reactions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The message users reacted to.
            #
            #     Format: `spaces/{space}/messages/{message}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of reactions returned. The service can return
            #     fewer reactions than this value. If unspecified, the default value is 25.
            #     The maximum value is 200; values above 200 are changed to 200.
            #   @param page_token [::String]
            #     Optional. (If resuming from a previous query.)
            #
            #     A page token received from a previous list reactions call. Provide this
            #     to retrieve the subsequent page.
            #
            #     When paginating, the filter value should match the call that provided the
            #     page token. Passing a different value might lead to unexpected results.
            #   @param filter [::String]
            #     Optional. A query filter.
            #
            #     You can filter reactions by
            #     [emoji](https://developers.google.com/workspace/chat/api/reference/rest/v1/Emoji)
            #     (either `emoji.unicode` or `emoji.custom_emoji.uid`) and
            #     [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
            #     (`user.name`).
            #
            #     To filter reactions for multiple emojis or users, join similar fields
            #     with the `OR` operator, such as `emoji.unicode = "🙂" OR emoji.unicode =
            #     "👍"` and `user.name = "users/AAAAAA" OR user.name = "users/BBBBBB"`.
            #
            #     To filter reactions by emoji and user, use the `AND` operator, such as
            #     `emoji.unicode = "🙂" AND user.name = "users/AAAAAA"`.
            #
            #     If your query uses both `AND` and `OR`, group them with parentheses.
            #
            #     For example, the following queries are valid:
            #
            #     ```
            #     user.name = "users/\\{user}"
            #     emoji.unicode = "🙂"
            #     emoji.custom_emoji.uid = "\\{uid}"
            #     emoji.unicode = "🙂" OR emoji.unicode = "👍"
            #     emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "\\{uid}"
            #     emoji.unicode = "🙂" AND user.name = "users/\\{user}"
            #     (emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "\\{uid}")
            #     AND user.name = "users/\\{user}"
            #     ```
            #
            #     The following queries are invalid:
            #
            #     ```
            #     emoji.unicode = "🙂" AND emoji.unicode = "👍"
            #     emoji.unicode = "🙂" AND emoji.custom_emoji.uid = "\\{uid}"
            #     emoji.unicode = "🙂" OR user.name = "users/\\{user}"
            #     emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "\\{uid}" OR
            #     user.name = "users/\\{user}"
            #     emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "\\{uid}"
            #     AND user.name = "users/\\{user}"
            #     ```
            #
            #     Invalid queries are rejected with an `INVALID_ARGUMENT` error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Reaction>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::Reaction>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::ListReactionsRequest.new
            #
            #   # Call the list_reactions method.
            #   result = client.list_reactions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Chat::V1::Reaction.
            #     p item
            #   end
            #
            def list_reactions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::ListReactionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_reactions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_reactions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_reactions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :list_reactions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @chat_service_stub, :list_reactions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a reaction to a message. For an example, see
            # [Delete a
            # reaction](https://developers.google.com/workspace/chat/delete-reactions).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.messages.reactions`
            #   - `https://www.googleapis.com/auth/chat.messages`
            #   - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
            #
            # @overload delete_reaction(request, options = nil)
            #   Pass arguments to `delete_reaction` via a request object, either of type
            #   {::Google::Apps::Chat::V1::DeleteReactionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::DeleteReactionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_reaction(name: nil)
            #   Pass arguments to `delete_reaction` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the reaction to delete.
            #
            #     Format: `spaces/{space}/messages/{message}/reactions/{reaction}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::DeleteReactionRequest.new
            #
            #   # Call the delete_reaction method.
            #   result = client.delete_reaction request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_reaction request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::DeleteReactionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_reaction.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_reaction.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_reaction.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :delete_reaction, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a custom emoji.
            #
            # Custom emojis are only available for Google Workspace accounts, and the
            # administrator must turn custom emojis on for the organization. For more
            # information, see [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149) and
            # [Manage custom emoji
            # permissions](https://support.google.com/a/answer/12850085).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.customemojis`
            #
            # @overload create_custom_emoji(request, options = nil)
            #   Pass arguments to `create_custom_emoji` via a request object, either of type
            #   {::Google::Apps::Chat::V1::CreateCustomEmojiRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::CreateCustomEmojiRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_custom_emoji(custom_emoji: nil)
            #   Pass arguments to `create_custom_emoji` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param custom_emoji [::Google::Apps::Chat::V1::CustomEmoji, ::Hash]
            #     Required. The custom emoji to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::CustomEmoji]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::CustomEmoji]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::CreateCustomEmojiRequest.new
            #
            #   # Call the create_custom_emoji method.
            #   result = client.create_custom_emoji request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::CustomEmoji.
            #   p result
            #
            def create_custom_emoji request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::CreateCustomEmojiRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_custom_emoji.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.create_custom_emoji.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_custom_emoji.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :create_custom_emoji, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns details about a custom emoji.
            #
            # Custom emojis are only available for Google Workspace accounts, and the
            # administrator must turn custom emojis on for the organization. For more
            # information, see [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149) and
            # [Manage custom emoji
            # permissions](https://support.google.com/a/answer/12850085).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.customemojis.readonly`
            #   - `https://www.googleapis.com/auth/chat.customemojis`
            #
            # @overload get_custom_emoji(request, options = nil)
            #   Pass arguments to `get_custom_emoji` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetCustomEmojiRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetCustomEmojiRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_custom_emoji(name: nil)
            #   Pass arguments to `get_custom_emoji` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the custom emoji.
            #
            #     Format: `customEmojis/{customEmoji}`
            #
            #     You can use the emoji name as an alias for `{customEmoji}`. For example,
            #     `customEmojis/:example-emoji:` where `:example-emoji:` is the emoji name
            #     for a custom emoji.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::CustomEmoji]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::CustomEmoji]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetCustomEmojiRequest.new
            #
            #   # Call the get_custom_emoji method.
            #   result = client.get_custom_emoji request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::CustomEmoji.
            #   p result
            #
            def get_custom_emoji request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetCustomEmojiRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_custom_emoji.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_custom_emoji.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_custom_emoji.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_custom_emoji, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists custom emojis visible to the authenticated user.
            #
            # Custom emojis are only available for Google Workspace accounts, and the
            # administrator must turn custom emojis on for the organization. For more
            # information, see [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149) and
            # [Manage custom emoji
            # permissions](https://support.google.com/a/answer/12850085).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.customemojis.readonly`
            #   - `https://www.googleapis.com/auth/chat.customemojis`
            #
            # @overload list_custom_emojis(request, options = nil)
            #   Pass arguments to `list_custom_emojis` via a request object, either of type
            #   {::Google::Apps::Chat::V1::ListCustomEmojisRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::ListCustomEmojisRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_custom_emojis(page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_custom_emojis` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param page_size [::Integer]
            #     Optional. The maximum number of custom emojis returned. The service can
            #     return fewer custom emojis than this value. If unspecified, the default
            #     value is 25. The maximum value is 200; values above 200 are changed to 200.
            #   @param page_token [::String]
            #     Optional. (If resuming from a previous query.)
            #
            #     A page token received from a previous list custom emoji call. Provide this
            #     to retrieve the subsequent page.
            #
            #     When paginating, the filter value should match the call that provided the
            #     page token. Passing a different value might lead to unexpected results.
            #   @param filter [::String]
            #     Optional. A query filter.
            #
            #     Supports filtering by creator.
            #
            #     To filter by creator, you must specify a valid value. Currently only
            #     `creator("users/me")` and `NOT creator("users/me")` are accepted to filter
            #     custom emojis by whether they were created by the calling user or not.
            #
            #     For example, the following query returns custom emojis created by the
            #     caller:
            #     ```
            #     creator("users/me")
            #     ```
            #
            #     Invalid queries are rejected with an `INVALID_ARGUMENT` error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::CustomEmoji>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::CustomEmoji>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::ListCustomEmojisRequest.new
            #
            #   # Call the list_custom_emojis method.
            #   result = client.list_custom_emojis request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Chat::V1::CustomEmoji.
            #     p item
            #   end
            #
            def list_custom_emojis request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::ListCustomEmojisRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_custom_emojis.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_custom_emojis.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_custom_emojis.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :list_custom_emojis, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @chat_service_stub, :list_custom_emojis, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a custom emoji. By default, users can only delete custom emoji they
            # created. [Emoji managers](https://support.google.com/a/answer/12850085)
            # assigned by the administrator can delete any custom emoji in the
            # organization. See [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149).
            #
            # Custom emojis are only available for Google Workspace accounts, and the
            # administrator must turn custom emojis on for the organization. For more
            # information, see [Learn about custom emojis in Google
            # Chat](https://support.google.com/chat/answer/12800149) and
            # [Manage custom emoji
            # permissions](https://support.google.com/a/answer/12850085).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.customemojis`
            #
            # @overload delete_custom_emoji(request, options = nil)
            #   Pass arguments to `delete_custom_emoji` via a request object, either of type
            #   {::Google::Apps::Chat::V1::DeleteCustomEmojiRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::DeleteCustomEmojiRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_custom_emoji(name: nil)
            #   Pass arguments to `delete_custom_emoji` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the custom emoji to delete.
            #
            #     Format: `customEmojis/{customEmoji}`
            #
            #     You can use the emoji name as an alias for `{customEmoji}`. For example,
            #     `customEmojis/:example-emoji:` where `:example-emoji:` is the emoji name
            #     for a custom emoji.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::DeleteCustomEmojiRequest.new
            #
            #   # Call the delete_custom_emoji method.
            #   result = client.delete_custom_emoji request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_custom_emoji request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::DeleteCustomEmojiRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_custom_emoji.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_custom_emoji.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_custom_emoji.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :delete_custom_emoji, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns details about a user's read state within a space, used to identify
            # read and unread messages. For an example, see [Get details about a user's
            # space read
            # state](https://developers.google.com/workspace/chat/get-space-read-state).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.readstate.readonly`
            #   - `https://www.googleapis.com/auth/chat.users.readstate`
            #
            # @overload get_space_read_state(request, options = nil)
            #   Pass arguments to `get_space_read_state` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetSpaceReadStateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetSpaceReadStateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_space_read_state(name: nil)
            #   Pass arguments to `get_space_read_state` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the space read state to retrieve.
            #
            #     Only supports getting read state for the calling user.
            #
            #     To refer to the calling user, set one of the following:
            #
            #     - The `me` alias. For example, `users/me/spaces/{space}/spaceReadState`.
            #
            #     - Their Workspace email address. For example,
            #     `users/user@example.com/spaces/{space}/spaceReadState`.
            #
            #     - Their user id. For example,
            #     `users/123456789/spaces/{space}/spaceReadState`.
            #
            #     Format: users/\\{user}/spaces/\\{space}/spaceReadState
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::SpaceReadState]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::SpaceReadState]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetSpaceReadStateRequest.new
            #
            #   # Call the get_space_read_state method.
            #   result = client.get_space_read_state request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::SpaceReadState.
            #   p result
            #
            def get_space_read_state request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetSpaceReadStateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_space_read_state.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_space_read_state.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_space_read_state.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_space_read_state, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a user's read state within a space, used to identify read and
            # unread messages. For an example, see [Update a user's space read
            # state](https://developers.google.com/workspace/chat/update-space-read-state).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.readstate`
            #
            # @overload update_space_read_state(request, options = nil)
            #   Pass arguments to `update_space_read_state` via a request object, either of type
            #   {::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_space_read_state(space_read_state: nil, update_mask: nil)
            #   Pass arguments to `update_space_read_state` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param space_read_state [::Google::Apps::Chat::V1::SpaceReadState, ::Hash]
            #     Required. The space read state and fields to update.
            #
            #     Only supports updating read state for the calling user.
            #
            #     To refer to the calling user, set one of the following:
            #
            #     - The `me` alias. For example, `users/me/spaces/{space}/spaceReadState`.
            #
            #     - Their Workspace email address. For example,
            #     `users/user@example.com/spaces/{space}/spaceReadState`.
            #
            #     - Their user id. For example,
            #     `users/123456789/spaces/{space}/spaceReadState`.
            #
            #     Format: users/\\{user}/spaces/\\{space}/spaceReadState
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The field paths to update. Currently supported field paths:
            #
            #     - `last_read_time`
            #
            #     When the `last_read_time` is before the latest message create time, the
            #     space appears as unread in the UI.
            #
            #     To mark the space as read, set `last_read_time` to any value later (larger)
            #     than the latest message create time. The `last_read_time` is coerced to
            #     match the latest message create time. Note that the space read state only
            #     affects the read state of messages that are visible in the space's
            #     top-level conversation. Replies in threads are unaffected by this
            #     timestamp, and instead rely on the thread read state.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::SpaceReadState]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::SpaceReadState]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::UpdateSpaceReadStateRequest.new
            #
            #   # Call the update_space_read_state method.
            #   result = client.update_space_read_state request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::SpaceReadState.
            #   p result
            #
            def update_space_read_state request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::UpdateSpaceReadStateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_space_read_state.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.space_read_state&.name
                header_params["space_read_state.name"] = request.space_read_state.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_space_read_state.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_space_read_state.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :update_space_read_state, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns details about a user's read state within a thread, used to identify
            # read and unread messages. For an example, see [Get details about a user's
            # thread read
            # state](https://developers.google.com/workspace/chat/get-thread-read-state).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following [authorization
            # scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.readstate.readonly`
            #   - `https://www.googleapis.com/auth/chat.users.readstate`
            #
            # @overload get_thread_read_state(request, options = nil)
            #   Pass arguments to `get_thread_read_state` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetThreadReadStateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetThreadReadStateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_thread_read_state(name: nil)
            #   Pass arguments to `get_thread_read_state` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the thread read state to retrieve.
            #
            #     Only supports getting read state for the calling user.
            #
            #     To refer to the calling user, set one of the following:
            #
            #     - The `me` alias. For example,
            #     `users/me/spaces/{space}/threads/{thread}/threadReadState`.
            #
            #     - Their Workspace email address. For example,
            #     `users/user@example.com/spaces/{space}/threads/{thread}/threadReadState`.
            #
            #     - Their user id. For example,
            #     `users/123456789/spaces/{space}/threads/{thread}/threadReadState`.
            #
            #     Format: users/\\{user}/spaces/\\{space}/threads/\\{thread}/threadReadState
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::ThreadReadState]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::ThreadReadState]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetThreadReadStateRequest.new
            #
            #   # Call the get_thread_read_state method.
            #   result = client.get_thread_read_state request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::ThreadReadState.
            #   p result
            #
            def get_thread_read_state request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetThreadReadStateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_thread_read_state.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_thread_read_state.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_thread_read_state.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_thread_read_state, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns an event from a Google Chat space. The [event
            # payload](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.oneof_payload)
            # contains the most recent version of the resource that changed. For example,
            # if you request an event about a new message but the message was later
            # updated, the server returns the updated `Message` resource in the event
            # payload.
            #
            # Note: The `permissionSettings` field is not returned in the Space
            # object of the Space event data for this request.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize)
            # with an
            # [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes)
            # appropriate for reading the requested data:
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) in
            # [Developer Preview](https://developers.google.com/workspace/preview)
            #  with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.app.spaces`
            #     - `https://www.googleapis.com/auth/chat.app.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.app.memberships`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - `https://www.googleapis.com/auth/chat.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages.reactions`
            #     - `https://www.googleapis.com/auth/chat.memberships.readonly`
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #
            # To get an event, the authenticated caller must be a member of the space.
            #
            # For an example, see [Get details about an
            # event from a Google Chat
            # space](https://developers.google.com/workspace/chat/get-space-event).
            #
            # @overload get_space_event(request, options = nil)
            #   Pass arguments to `get_space_event` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetSpaceEventRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetSpaceEventRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_space_event(name: nil)
            #   Pass arguments to `get_space_event` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the space event.
            #
            #     Format: `spaces/{space}/spaceEvents/{spaceEvent}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::SpaceEvent]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::SpaceEvent]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetSpaceEventRequest.new
            #
            #   # Call the get_space_event method.
            #   result = client.get_space_event request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::SpaceEvent.
            #   p result
            #
            def get_space_event request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetSpaceEventRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_space_event.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_space_event.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_space_event.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_space_event, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists events from a Google Chat space. For each event, the
            # [payload](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.oneof_payload)
            # contains the most recent version of the Chat resource. For example, if you
            # list events about new space members, the server returns `Membership`
            # resources that contain the latest membership details. If new members were
            # removed during the requested period, the event payload contains an empty
            # `Membership` resource.
            #
            # Supports the following types of
            # [authentication](https://developers.google.com/workspace/chat/authenticate-authorize)
            # with an
            # [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes)
            # appropriate for reading the requested data:
            #
            # - [App
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
            # with [administrator
            # approval](https://support.google.com/a?p=chat-app-auth) in
            # [Developer Preview](https://developers.google.com/workspace/preview)
            #  with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.app.spaces`
            #     - `https://www.googleapis.com/auth/chat.app.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.app.memberships`
            #
            # - [User
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with one of the following authorization scopes:
            #     - `https://www.googleapis.com/auth/chat.spaces.readonly`
            #     - `https://www.googleapis.com/auth/chat.spaces`
            #     - `https://www.googleapis.com/auth/chat.messages.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages`
            #     - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
            #     - `https://www.googleapis.com/auth/chat.messages.reactions`
            #     - `https://www.googleapis.com/auth/chat.memberships.readonly`
            #     - `https://www.googleapis.com/auth/chat.memberships`
            #
            # To list events, the authenticated caller must be a member of the space.
            #
            # For an example, see [List events from a Google Chat
            # space](https://developers.google.com/workspace/chat/list-space-events).
            #
            # @overload list_space_events(request, options = nil)
            #   Pass arguments to `list_space_events` via a request object, either of type
            #   {::Google::Apps::Chat::V1::ListSpaceEventsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::ListSpaceEventsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_space_events(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_space_events` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the [Google Chat
            #     space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
            #     where the events occurred.
            #
            #     Format: `spaces/{space}`.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of space events returned. The service might
            #     return fewer than this value.
            #
            #     Negative values return an `INVALID_ARGUMENT` error.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous list space events call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to list space events must
            #     match the call that provided the page token. Passing different values to
            #     the other parameters might lead to unexpected results.
            #   @param filter [::String]
            #     Required. A query filter.
            #
            #     You must specify at least one event type (`event_type`)
            #     using the has `:` operator. To filter by multiple event types, use the `OR`
            #     operator. Omit batch event types in your filter. The request automatically
            #     returns any related batch events. For example, if you filter by new
            #     reactions
            #     (`google.workspace.chat.reaction.v1.created`), the server also returns
            #     batch new reactions events
            #     (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
            #     event types, see the [`SpaceEvents` reference
            #     documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
            #
            #     Optionally, you can also filter by start time (`start_time`) and
            #     end time (`end_time`):
            #
            #     * `start_time`: Exclusive timestamp from which to start listing space
            #     events.
            #      You can list events that occurred up to 28 days ago. If unspecified, lists
            #      space events from the past 28 days.
            #     * `end_time`: Inclusive timestamp until which space events are listed.
            #      If unspecified, lists events up to the time of the request.
            #
            #     To specify a start or end time, use the equals `=` operator and format in
            #     [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
            #     `start_time` and `end_time`, use the `AND` operator.
            #
            #     For example, the following queries are valid:
            #
            #     ```
            #     start_time="2023-08-23T19:20:33+00:00" AND
            #     end_time="2023-08-23T19:21:54+00:00"
            #     ```
            #     ```
            #     start_time="2023-08-23T19:20:33+00:00" AND
            #     (event_types:"google.workspace.chat.space.v1.updated" OR
            #     event_types:"google.workspace.chat.message.v1.created")
            #     ```
            #
            #     The following queries are invalid:
            #
            #     ```
            #     start_time="2023-08-23T19:20:33+00:00" OR
            #     end_time="2023-08-23T19:21:54+00:00"
            #     ```
            #     ```
            #     event_types:"google.workspace.chat.space.v1.updated" AND
            #     event_types:"google.workspace.chat.message.v1.created"
            #     ```
            #
            #     Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
            #     error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::SpaceEvent>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Apps::Chat::V1::SpaceEvent>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::ListSpaceEventsRequest.new
            #
            #   # Call the list_space_events method.
            #   result = client.list_space_events request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Apps::Chat::V1::SpaceEvent.
            #     p item
            #   end
            #
            def list_space_events request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::ListSpaceEventsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_space_events.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_space_events.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_space_events.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :list_space_events, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @chat_service_stub, :list_space_events, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the space notification setting. For an example, see [Get the
            # caller's space notification
            # setting](https://developers.google.com/workspace/chat/get-space-notification-setting).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.spacesettings`
            #
            # @overload get_space_notification_setting(request, options = nil)
            #   Pass arguments to `get_space_notification_setting` via a request object, either of type
            #   {::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_space_notification_setting(name: nil)
            #   Pass arguments to `get_space_notification_setting` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format: users/\\{user}/spaces/\\{space}/spaceNotificationSetting
            #
            #     - `users/me/spaces/{space}/spaceNotificationSetting`, OR
            #     - `users/user@example.com/spaces/{space}/spaceNotificationSetting`, OR
            #     - `users/123456789/spaces/{space}/spaceNotificationSetting`.
            #     Note: Only the caller's user id or email is allowed in the path.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::SpaceNotificationSetting]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::SpaceNotificationSetting]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest.new
            #
            #   # Call the get_space_notification_setting method.
            #   result = client.get_space_notification_setting request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::SpaceNotificationSetting.
            #   p result
            #
            def get_space_notification_setting request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::GetSpaceNotificationSettingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_space_notification_setting.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_space_notification_setting.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_space_notification_setting.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :get_space_notification_setting, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the space notification setting. For an example, see [Update
            # the caller's space notification
            # setting](https://developers.google.com/workspace/chat/update-space-notification-setting).
            #
            # Requires [user
            # authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
            # with the [authorization
            # scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
            #
            #   - `https://www.googleapis.com/auth/chat.users.spacesettings`
            #
            # @overload update_space_notification_setting(request, options = nil)
            #   Pass arguments to `update_space_notification_setting` via a request object, either of type
            #   {::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_space_notification_setting(space_notification_setting: nil, update_mask: nil)
            #   Pass arguments to `update_space_notification_setting` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param space_notification_setting [::Google::Apps::Chat::V1::SpaceNotificationSetting, ::Hash]
            #     Required. The resource name for the space notification settings must be
            #     populated in the form of
            #     `users/{user}/spaces/{space}/spaceNotificationSetting`. Only fields
            #     specified by `update_mask` are updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Supported field paths:
            #
            #     - `notification_setting`
            #
            #     - `mute_setting`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Apps::Chat::V1::SpaceNotificationSetting]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Apps::Chat::V1::SpaceNotificationSetting]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/apps/chat/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Apps::Chat::V1::ChatService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest.new
            #
            #   # Call the update_space_notification_setting method.
            #   result = client.update_space_notification_setting request
            #
            #   # The returned object is of type Google::Apps::Chat::V1::SpaceNotificationSetting.
            #   p result
            #
            def update_space_notification_setting request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Apps::Chat::V1::UpdateSpaceNotificationSettingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_space_notification_setting.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Apps::Chat::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.space_notification_setting&.name
                header_params["space_notification_setting.name"] = request.space_notification_setting.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_space_notification_setting.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_space_notification_setting.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @chat_service_stub.call_rpc :update_space_notification_setting, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ChatService API.
            #
            # This class represents the configuration for ChatService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Apps::Chat::V1::ChatService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_message to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Apps::Chat::V1::ChatService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_message.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_message.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Apps::Chat::V1::ChatService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "chat.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ChatService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_message`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_message
                ##
                # RPC-specific configuration for `list_messages`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_messages
                ##
                # RPC-specific configuration for `list_memberships`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_memberships
                ##
                # RPC-specific configuration for `get_membership`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_membership
                ##
                # RPC-specific configuration for `get_message`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_message
                ##
                # RPC-specific configuration for `update_message`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_message
                ##
                # RPC-specific configuration for `delete_message`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_message
                ##
                # RPC-specific configuration for `get_attachment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_attachment
                ##
                # RPC-specific configuration for `upload_attachment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :upload_attachment
                ##
                # RPC-specific configuration for `list_spaces`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_spaces
                ##
                # RPC-specific configuration for `search_spaces`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_spaces
                ##
                # RPC-specific configuration for `get_space`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_space
                ##
                # RPC-specific configuration for `create_space`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_space
                ##
                # RPC-specific configuration for `set_up_space`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_up_space
                ##
                # RPC-specific configuration for `update_space`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_space
                ##
                # RPC-specific configuration for `delete_space`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_space
                ##
                # RPC-specific configuration for `complete_import_space`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :complete_import_space
                ##
                # RPC-specific configuration for `find_direct_message`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :find_direct_message
                ##
                # RPC-specific configuration for `create_membership`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_membership
                ##
                # RPC-specific configuration for `update_membership`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_membership
                ##
                # RPC-specific configuration for `delete_membership`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_membership
                ##
                # RPC-specific configuration for `create_reaction`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_reaction
                ##
                # RPC-specific configuration for `list_reactions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_reactions
                ##
                # RPC-specific configuration for `delete_reaction`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_reaction
                ##
                # RPC-specific configuration for `create_custom_emoji`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_custom_emoji
                ##
                # RPC-specific configuration for `get_custom_emoji`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_custom_emoji
                ##
                # RPC-specific configuration for `list_custom_emojis`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_custom_emojis
                ##
                # RPC-specific configuration for `delete_custom_emoji`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_custom_emoji
                ##
                # RPC-specific configuration for `get_space_read_state`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_space_read_state
                ##
                # RPC-specific configuration for `update_space_read_state`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_space_read_state
                ##
                # RPC-specific configuration for `get_thread_read_state`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_thread_read_state
                ##
                # RPC-specific configuration for `get_space_event`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_space_event
                ##
                # RPC-specific configuration for `list_space_events`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_space_events
                ##
                # RPC-specific configuration for `get_space_notification_setting`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_space_notification_setting
                ##
                # RPC-specific configuration for `update_space_notification_setting`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_space_notification_setting

                # @private
                def initialize parent_rpcs = nil
                  create_message_config = parent_rpcs.create_message if parent_rpcs.respond_to? :create_message
                  @create_message = ::Gapic::Config::Method.new create_message_config
                  list_messages_config = parent_rpcs.list_messages if parent_rpcs.respond_to? :list_messages
                  @list_messages = ::Gapic::Config::Method.new list_messages_config
                  list_memberships_config = parent_rpcs.list_memberships if parent_rpcs.respond_to? :list_memberships
                  @list_memberships = ::Gapic::Config::Method.new list_memberships_config
                  get_membership_config = parent_rpcs.get_membership if parent_rpcs.respond_to? :get_membership
                  @get_membership = ::Gapic::Config::Method.new get_membership_config
                  get_message_config = parent_rpcs.get_message if parent_rpcs.respond_to? :get_message
                  @get_message = ::Gapic::Config::Method.new get_message_config
                  update_message_config = parent_rpcs.update_message if parent_rpcs.respond_to? :update_message
                  @update_message = ::Gapic::Config::Method.new update_message_config
                  delete_message_config = parent_rpcs.delete_message if parent_rpcs.respond_to? :delete_message
                  @delete_message = ::Gapic::Config::Method.new delete_message_config
                  get_attachment_config = parent_rpcs.get_attachment if parent_rpcs.respond_to? :get_attachment
                  @get_attachment = ::Gapic::Config::Method.new get_attachment_config
                  upload_attachment_config = parent_rpcs.upload_attachment if parent_rpcs.respond_to? :upload_attachment
                  @upload_attachment = ::Gapic::Config::Method.new upload_attachment_config
                  list_spaces_config = parent_rpcs.list_spaces if parent_rpcs.respond_to? :list_spaces
                  @list_spaces = ::Gapic::Config::Method.new list_spaces_config
                  search_spaces_config = parent_rpcs.search_spaces if parent_rpcs.respond_to? :search_spaces
                  @search_spaces = ::Gapic::Config::Method.new search_spaces_config
                  get_space_config = parent_rpcs.get_space if parent_rpcs.respond_to? :get_space
                  @get_space = ::Gapic::Config::Method.new get_space_config
                  create_space_config = parent_rpcs.create_space if parent_rpcs.respond_to? :create_space
                  @create_space = ::Gapic::Config::Method.new create_space_config
                  set_up_space_config = parent_rpcs.set_up_space if parent_rpcs.respond_to? :set_up_space
                  @set_up_space = ::Gapic::Config::Method.new set_up_space_config
                  update_space_config = parent_rpcs.update_space if parent_rpcs.respond_to? :update_space
                  @update_space = ::Gapic::Config::Method.new update_space_config
                  delete_space_config = parent_rpcs.delete_space if parent_rpcs.respond_to? :delete_space
                  @delete_space = ::Gapic::Config::Method.new delete_space_config
                  complete_import_space_config = parent_rpcs.complete_import_space if parent_rpcs.respond_to? :complete_import_space
                  @complete_import_space = ::Gapic::Config::Method.new complete_import_space_config
                  find_direct_message_config = parent_rpcs.find_direct_message if parent_rpcs.respond_to? :find_direct_message
                  @find_direct_message = ::Gapic::Config::Method.new find_direct_message_config
                  create_membership_config = parent_rpcs.create_membership if parent_rpcs.respond_to? :create_membership
                  @create_membership = ::Gapic::Config::Method.new create_membership_config
                  update_membership_config = parent_rpcs.update_membership if parent_rpcs.respond_to? :update_membership
                  @update_membership = ::Gapic::Config::Method.new update_membership_config
                  delete_membership_config = parent_rpcs.delete_membership if parent_rpcs.respond_to? :delete_membership
                  @delete_membership = ::Gapic::Config::Method.new delete_membership_config
                  create_reaction_config = parent_rpcs.create_reaction if parent_rpcs.respond_to? :create_reaction
                  @create_reaction = ::Gapic::Config::Method.new create_reaction_config
                  list_reactions_config = parent_rpcs.list_reactions if parent_rpcs.respond_to? :list_reactions
                  @list_reactions = ::Gapic::Config::Method.new list_reactions_config
                  delete_reaction_config = parent_rpcs.delete_reaction if parent_rpcs.respond_to? :delete_reaction
                  @delete_reaction = ::Gapic::Config::Method.new delete_reaction_config
                  create_custom_emoji_config = parent_rpcs.create_custom_emoji if parent_rpcs.respond_to? :create_custom_emoji
                  @create_custom_emoji = ::Gapic::Config::Method.new create_custom_emoji_config
                  get_custom_emoji_config = parent_rpcs.get_custom_emoji if parent_rpcs.respond_to? :get_custom_emoji
                  @get_custom_emoji = ::Gapic::Config::Method.new get_custom_emoji_config
                  list_custom_emojis_config = parent_rpcs.list_custom_emojis if parent_rpcs.respond_to? :list_custom_emojis
                  @list_custom_emojis = ::Gapic::Config::Method.new list_custom_emojis_config
                  delete_custom_emoji_config = parent_rpcs.delete_custom_emoji if parent_rpcs.respond_to? :delete_custom_emoji
                  @delete_custom_emoji = ::Gapic::Config::Method.new delete_custom_emoji_config
                  get_space_read_state_config = parent_rpcs.get_space_read_state if parent_rpcs.respond_to? :get_space_read_state
                  @get_space_read_state = ::Gapic::Config::Method.new get_space_read_state_config
                  update_space_read_state_config = parent_rpcs.update_space_read_state if parent_rpcs.respond_to? :update_space_read_state
                  @update_space_read_state = ::Gapic::Config::Method.new update_space_read_state_config
                  get_thread_read_state_config = parent_rpcs.get_thread_read_state if parent_rpcs.respond_to? :get_thread_read_state
                  @get_thread_read_state = ::Gapic::Config::Method.new get_thread_read_state_config
                  get_space_event_config = parent_rpcs.get_space_event if parent_rpcs.respond_to? :get_space_event
                  @get_space_event = ::Gapic::Config::Method.new get_space_event_config
                  list_space_events_config = parent_rpcs.list_space_events if parent_rpcs.respond_to? :list_space_events
                  @list_space_events = ::Gapic::Config::Method.new list_space_events_config
                  get_space_notification_setting_config = parent_rpcs.get_space_notification_setting if parent_rpcs.respond_to? :get_space_notification_setting
                  @get_space_notification_setting = ::Gapic::Config::Method.new get_space_notification_setting_config
                  update_space_notification_setting_config = parent_rpcs.update_space_notification_setting if parent_rpcs.respond_to? :update_space_notification_setting
                  @update_space_notification_setting = ::Gapic::Config::Method.new update_space_notification_setting_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
