# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/apps/chat/v1/version"

require "google/apps/chat/v1/chat_service/credentials"
require "google/apps/chat/v1/chat_service/paths"
require "google/apps/chat/v1/chat_service/client"
require "google/apps/chat/v1/chat_service/rest"

module Google
  module Apps
    module Chat
      module V1
        ##
        # Enables developers to build Chat apps and
        # integrations on Google Chat Platform.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/apps/chat/v1/chat_service"
        #     client = ::Google::Apps::Chat::V1::ChatService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/apps/chat/v1/chat_service/rest"
        #     client = ::Google::Apps::Chat::V1::ChatService::Rest::Client.new
        #
        module ChatService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "chat_service", "helpers.rb"
require "google/apps/chat/v1/chat_service/helpers" if ::File.file? helper_path
