# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Analytics
    module Data
      module V1beta
        # The request for compatibility information for a report's dimensions and
        # metrics. Check compatibility provides a preview of the compatibility of a
        # report; fields shared with the `runReport` request should be the same values
        # as in your `runReport` request.
        # @!attribute [rw] property
        #   @return [::String]
        #     A Google Analytics property identifier whose events are tracked. To
        #     learn more, see [where to find your Property
        #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
        #     `property` should be the same value as in your `runReport` request.
        #
        #     Example: properties/1234
        # @!attribute [rw] dimensions
        #   @return [::Array<::Google::Analytics::Data::V1beta::Dimension>]
        #     The dimensions in this report. `dimensions` should be the same value as in
        #     your `runReport` request.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Analytics::Data::V1beta::Metric>]
        #     The metrics in this report. `metrics` should be the same value as in your
        #     `runReport` request.
        # @!attribute [rw] dimension_filter
        #   @return [::Google::Analytics::Data::V1beta::FilterExpression]
        #     The filter clause of dimensions. `dimensionFilter` should be the same value
        #     as in your `runReport` request.
        # @!attribute [rw] metric_filter
        #   @return [::Google::Analytics::Data::V1beta::FilterExpression]
        #     The filter clause of metrics. `metricFilter` should be the same value as in
        #     your `runReport` request
        # @!attribute [rw] compatibility_filter
        #   @return [::Google::Analytics::Data::V1beta::Compatibility]
        #     Filters the dimensions and metrics in the response to just this
        #     compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
        #     to only return compatible dimensions & metrics.
        class CheckCompatibilityRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The compatibility response with the compatibility of each dimension & metric.
        # @!attribute [rw] dimension_compatibilities
        #   @return [::Array<::Google::Analytics::Data::V1beta::DimensionCompatibility>]
        #     The compatibility of each dimension.
        # @!attribute [rw] metric_compatibilities
        #   @return [::Array<::Google::Analytics::Data::V1beta::MetricCompatibility>]
        #     The compatibility of each metric.
        class CheckCompatibilityResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The dimensions, metrics and comparisons currently accepted in reporting
        # methods.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of this metadata.
        # @!attribute [rw] dimensions
        #   @return [::Array<::Google::Analytics::Data::V1beta::DimensionMetadata>]
        #     The dimension descriptions.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Analytics::Data::V1beta::MetricMetadata>]
        #     The metric descriptions.
        # @!attribute [rw] comparisons
        #   @return [::Array<::Google::Analytics::Data::V1beta::ComparisonMetadata>]
        #     The comparison descriptions.
        class Metadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to generate a report.
        # @!attribute [rw] property
        #   @return [::String]
        #     A Google Analytics property identifier whose events are tracked.
        #     Specified in the URL path and not the body. To learn more, see [where to
        #     find your Property
        #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
        #     Within a batch request, this property should either be unspecified or
        #     consistent with the batch-level property.
        #
        #     Example: properties/1234
        # @!attribute [rw] dimensions
        #   @return [::Array<::Google::Analytics::Data::V1beta::Dimension>]
        #     The dimensions requested and displayed.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Analytics::Data::V1beta::Metric>]
        #     The metrics requested and displayed.
        # @!attribute [rw] date_ranges
        #   @return [::Array<::Google::Analytics::Data::V1beta::DateRange>]
        #     Date ranges of data to read. If multiple date ranges are requested, each
        #     response row will contain a zero based date range index. If two date
        #     ranges overlap, the event data for the overlapping days is included in the
        #     response rows for both date ranges. In a cohort request, this `dateRanges`
        #     must be unspecified.
        # @!attribute [rw] dimension_filter
        #   @return [::Google::Analytics::Data::V1beta::FilterExpression]
        #     Dimension filters let you ask for only specific dimension values in
        #     the report. To learn more, see [Fundamentals of Dimension
        #     Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
        #     for examples. Metrics cannot be used in this filter.
        # @!attribute [rw] metric_filter
        #   @return [::Google::Analytics::Data::V1beta::FilterExpression]
        #     The filter clause of metrics. Applied after aggregating the report's rows,
        #     similar to SQL having-clause. Dimensions cannot be used in this filter.
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     The row count of the start row. The first row is counted as row 0.
        #
        #     When paging, the first request does not specify offset; or equivalently,
        #     sets offset to 0; the first request returns the first `limit` of rows. The
        #     second request sets offset to the `limit` of the first request; the second
        #     request returns the second `limit` of rows.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        # @!attribute [rw] limit
        #   @return [::Integer]
        #     The number of rows to return. If unspecified, 10,000 rows are returned. The
        #     API returns a maximum of 250,000 rows per request, no matter how many you
        #     ask for. `limit` must be positive.
        #
        #     The API can also return fewer rows than the requested `limit`, if there
        #     aren't as many dimension values as the `limit`. For instance, there are
        #     fewer than 300 possible values for the dimension `country`, so when
        #     reporting on only `country`, you can't get more than 300 rows, even if you
        #     set `limit` to a higher value.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        # @!attribute [rw] metric_aggregations
        #   @return [::Array<::Google::Analytics::Data::V1beta::MetricAggregation>]
        #     Aggregation of metrics. Aggregated metric values will be shown in rows
        #     where the dimension_values are set to "RESERVED_(MetricAggregation)".
        #     Aggregates including both comparisons and multiple date ranges will
        #     be aggregated based on the date ranges.
        # @!attribute [rw] order_bys
        #   @return [::Array<::Google::Analytics::Data::V1beta::OrderBy>]
        #     Specifies how rows are ordered in the response.
        #     Requests including both comparisons and multiple date ranges will
        #     have order bys applied on the comparisons.
        # @!attribute [rw] currency_code
        #   @return [::String]
        #     A currency code in ISO4217 format, such as "AED", "USD", "JPY".
        #     If the field is empty, the report uses the property's default currency.
        # @!attribute [rw] cohort_spec
        #   @return [::Google::Analytics::Data::V1beta::CohortSpec]
        #     Cohort group associated with this request. If there is a cohort group
        #     in the request the 'cohort' dimension must be present.
        # @!attribute [rw] keep_empty_rows
        #   @return [::Boolean]
        #     If false or unspecified, each row with all metrics equal to 0 will not be
        #     returned. If true, these rows will be returned if they are not separately
        #     removed by a filter.
        #
        #     Regardless of this `keep_empty_rows` setting, only data recorded by the
        #     Google Analytics property can be displayed in a report.
        #
        #     For example if a property never logs a `purchase` event, then a query for
        #     the `eventName` dimension and  `eventCount` metric will not have a row
        #     eventName: "purchase" and eventCount: 0.
        # @!attribute [rw] return_property_quota
        #   @return [::Boolean]
        #     Toggles whether to return the current state of this Google Analytics
        #     property's quota. Quota is returned in [PropertyQuota](#PropertyQuota).
        # @!attribute [rw] comparisons
        #   @return [::Array<::Google::Analytics::Data::V1beta::Comparison>]
        #     Optional. The configuration of comparisons requested and displayed. The
        #     request only requires a comparisons field in order to receive a comparison
        #     column in the response.
        class RunReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response report table corresponding to a request.
        # @!attribute [rw] dimension_headers
        #   @return [::Array<::Google::Analytics::Data::V1beta::DimensionHeader>]
        #     Describes dimension columns. The number of DimensionHeaders and ordering of
        #     DimensionHeaders matches the dimensions present in rows.
        # @!attribute [rw] metric_headers
        #   @return [::Array<::Google::Analytics::Data::V1beta::MetricHeader>]
        #     Describes metric columns. The number of MetricHeaders and ordering of
        #     MetricHeaders matches the metrics present in rows.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     Rows of dimension value combinations and metric values in the report.
        # @!attribute [rw] totals
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     If requested, the totaled values of metrics.
        # @!attribute [rw] maximums
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     If requested, the maximum values of metrics.
        # @!attribute [rw] minimums
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     If requested, the minimum values of metrics.
        # @!attribute [rw] row_count
        #   @return [::Integer]
        #     The total number of rows in the query result. `rowCount` is independent of
        #     the number of rows returned in the response, the `limit` request
        #     parameter, and the `offset` request parameter. For example if a query
        #     returns 175 rows and includes `limit` of 50 in the API request, the
        #     response will contain `rowCount` of 175 but only 50 rows.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        # @!attribute [rw] metadata
        #   @return [::Google::Analytics::Data::V1beta::ResponseMetaData]
        #     Metadata for the report.
        # @!attribute [rw] property_quota
        #   @return [::Google::Analytics::Data::V1beta::PropertyQuota]
        #     This Google Analytics property's quota state including this request.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Identifies what kind of resource this message is. This `kind` is always the
        #     fixed string "analyticsData#runReport". Useful to distinguish between
        #     response types in JSON.
        class RunReportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to generate a pivot report.
        # @!attribute [rw] property
        #   @return [::String]
        #     A Google Analytics property identifier whose events are tracked.
        #     Specified in the URL path and not the body. To learn more, see [where to
        #     find your Property
        #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
        #     Within a batch request, this property should either be unspecified or
        #     consistent with the batch-level property.
        #
        #     Example: properties/1234
        # @!attribute [rw] dimensions
        #   @return [::Array<::Google::Analytics::Data::V1beta::Dimension>]
        #     The dimensions requested. All defined dimensions must be used by one of the
        #     following: dimension_expression, dimension_filter, pivots, order_bys.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Analytics::Data::V1beta::Metric>]
        #     The metrics requested, at least one metric needs to be specified. All
        #     defined metrics must be used by one of the following: metric_expression,
        #     metric_filter, order_bys.
        # @!attribute [rw] date_ranges
        #   @return [::Array<::Google::Analytics::Data::V1beta::DateRange>]
        #     The date range to retrieve event data for the report. If multiple date
        #     ranges are specified, event data from each date range is used in the
        #     report. A special dimension with field name "dateRange" can be included in
        #     a Pivot's field names; if included, the report compares between date
        #     ranges. In a cohort request, this `dateRanges` must be unspecified.
        # @!attribute [rw] pivots
        #   @return [::Array<::Google::Analytics::Data::V1beta::Pivot>]
        #     Describes the visual format of the report's dimensions in columns or rows.
        #     The union of the fieldNames (dimension names) in all pivots must be a
        #     subset of dimension names defined in Dimensions. No two pivots can share a
        #     dimension. A dimension is only visible if it appears in a pivot.
        # @!attribute [rw] dimension_filter
        #   @return [::Google::Analytics::Data::V1beta::FilterExpression]
        #     The filter clause of dimensions. Dimensions must be requested to be used in
        #     this filter. Metrics cannot be used in this filter.
        # @!attribute [rw] metric_filter
        #   @return [::Google::Analytics::Data::V1beta::FilterExpression]
        #     The filter clause of metrics. Applied at post aggregation phase, similar to
        #     SQL having-clause. Metrics must be requested to be used in this filter.
        #     Dimensions cannot be used in this filter.
        # @!attribute [rw] currency_code
        #   @return [::String]
        #     A currency code in ISO4217 format, such as "AED", "USD", "JPY".
        #     If the field is empty, the report uses the property's default currency.
        # @!attribute [rw] cohort_spec
        #   @return [::Google::Analytics::Data::V1beta::CohortSpec]
        #     Cohort group associated with this request. If there is a cohort group
        #     in the request the 'cohort' dimension must be present.
        # @!attribute [rw] keep_empty_rows
        #   @return [::Boolean]
        #     If false or unspecified, each row with all metrics equal to 0 will not be
        #     returned. If true, these rows will be returned if they are not separately
        #     removed by a filter.
        #
        #     Regardless of this `keep_empty_rows` setting, only data recorded by the
        #     Google Analytics property can be displayed in a report.
        #
        #     For example if a property never logs a `purchase` event, then a query for
        #     the `eventName` dimension and  `eventCount` metric will not have a row
        #     eventName: "purchase" and eventCount: 0.
        # @!attribute [rw] return_property_quota
        #   @return [::Boolean]
        #     Toggles whether to return the current state of this Google Analytics
        #     property's quota. Quota is returned in [PropertyQuota](#PropertyQuota).
        # @!attribute [rw] comparisons
        #   @return [::Array<::Google::Analytics::Data::V1beta::Comparison>]
        #     Optional. The configuration of comparisons requested and displayed. The
        #     request requires both a comparisons field and a comparisons dimension to
        #     receive a comparison column in the response.
        class RunPivotReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response pivot report table corresponding to a pivot request.
        # @!attribute [rw] pivot_headers
        #   @return [::Array<::Google::Analytics::Data::V1beta::PivotHeader>]
        #     Summarizes the columns and rows created by a pivot. Each pivot in the
        #     request produces one header in the response. If we have a request like
        #     this:
        #
        #         "pivots": [{
        #           "fieldNames": ["country",
        #             "city"]
        #         },
        #         {
        #           "fieldNames": "eventName"
        #         }]
        #
        #     We will have the following `pivotHeaders` in the response:
        #
        #         "pivotHeaders" : [{
        #           "dimensionHeaders": [{
        #             "dimensionValues": [
        #                { "value": "United Kingdom" },
        #                { "value": "London" }
        #              ]
        #           },
        #           {
        #             "dimensionValues": [
        #             { "value": "Japan" },
        #             { "value": "Osaka" }
        #             ]
        #           }]
        #         },
        #         {
        #           "dimensionHeaders": [{
        #             "dimensionValues": [{ "value": "session_start" }]
        #           },
        #           {
        #             "dimensionValues": [{ "value": "scroll" }]
        #           }]
        #         }]
        # @!attribute [rw] dimension_headers
        #   @return [::Array<::Google::Analytics::Data::V1beta::DimensionHeader>]
        #     Describes dimension columns. The number of DimensionHeaders and ordering of
        #     DimensionHeaders matches the dimensions present in rows.
        # @!attribute [rw] metric_headers
        #   @return [::Array<::Google::Analytics::Data::V1beta::MetricHeader>]
        #     Describes metric columns. The number of MetricHeaders and ordering of
        #     MetricHeaders matches the metrics present in rows.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     Rows of dimension value combinations and metric values in the report.
        # @!attribute [rw] aggregates
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     Aggregation of metric values. Can be totals, minimums, or maximums. The
        #     returned aggregations are controlled by the metric_aggregations in the
        #     pivot. The type of aggregation returned in each row is shown by the
        #     dimension_values which are set to "RESERVED_<MetricAggregation>".
        # @!attribute [rw] metadata
        #   @return [::Google::Analytics::Data::V1beta::ResponseMetaData]
        #     Metadata for the report.
        # @!attribute [rw] property_quota
        #   @return [::Google::Analytics::Data::V1beta::PropertyQuota]
        #     This Google Analytics property's quota state including this request.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Identifies what kind of resource this message is. This `kind` is always the
        #     fixed string "analyticsData#runPivotReport". Useful to distinguish between
        #     response types in JSON.
        class RunPivotReportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The batch request containing multiple report requests.
        # @!attribute [rw] property
        #   @return [::String]
        #     A Google Analytics property identifier whose events are tracked.
        #     Specified in the URL path and not the body. To learn more, see [where to
        #     find your Property
        #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
        #     This property must be specified for the batch. The property within
        #     RunReportRequest may either be unspecified or consistent with this
        #     property.
        #
        #     Example: properties/1234
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Analytics::Data::V1beta::RunReportRequest>]
        #     Individual requests. Each request has a separate report response. Each
        #     batch request is allowed up to 5 requests.
        class BatchRunReportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The batch response containing multiple reports.
        # @!attribute [rw] reports
        #   @return [::Array<::Google::Analytics::Data::V1beta::RunReportResponse>]
        #     Individual responses. Each response has a separate report request.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Identifies what kind of resource this message is. This `kind` is always the
        #     fixed string "analyticsData#batchRunReports". Useful to distinguish between
        #     response types in JSON.
        class BatchRunReportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The batch request containing multiple pivot report requests.
        # @!attribute [rw] property
        #   @return [::String]
        #     A Google Analytics property identifier whose events are tracked.
        #     Specified in the URL path and not the body. To learn more, see [where to
        #     find your Property
        #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
        #     This property must be specified for the batch. The property within
        #     RunPivotReportRequest may either be unspecified or consistent with this
        #     property.
        #
        #     Example: properties/1234
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Analytics::Data::V1beta::RunPivotReportRequest>]
        #     Individual requests. Each request has a separate pivot report response.
        #     Each batch request is allowed up to 5 requests.
        class BatchRunPivotReportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The batch response containing multiple pivot reports.
        # @!attribute [rw] pivot_reports
        #   @return [::Array<::Google::Analytics::Data::V1beta::RunPivotReportResponse>]
        #     Individual responses. Each response has a separate pivot report request.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Identifies what kind of resource this message is. This `kind` is always the
        #     fixed string "analyticsData#batchRunPivotReports". Useful to distinguish
        #     between response types in JSON.
        class BatchRunPivotReportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for a property's dimension and metric metadata.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the metadata to retrieve. This name field is
        #     specified in the URL path and not URL parameters. Property is a numeric
        #     Google Analytics property identifier. To learn more, see [where to find
        #     your Property
        #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
        #
        #     Example: properties/1234/metadata
        #
        #     Set the Property ID to 0 for dimensions and metrics common to all
        #     properties. In this special mode, this method will not return custom
        #     dimensions and metrics.
        class GetMetadataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to generate a realtime report.
        # @!attribute [rw] property
        #   @return [::String]
        #     A Google Analytics property identifier whose events are tracked.
        #     Specified in the URL path and not the body. To learn more, see [where to
        #     find your Property
        #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
        #
        #     Example: properties/1234
        # @!attribute [rw] dimensions
        #   @return [::Array<::Google::Analytics::Data::V1beta::Dimension>]
        #     The dimensions requested and displayed.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Analytics::Data::V1beta::Metric>]
        #     The metrics requested and displayed.
        # @!attribute [rw] dimension_filter
        #   @return [::Google::Analytics::Data::V1beta::FilterExpression]
        #     The filter clause of dimensions. Metrics cannot be used in this filter.
        # @!attribute [rw] metric_filter
        #   @return [::Google::Analytics::Data::V1beta::FilterExpression]
        #     The filter clause of metrics. Applied at post aggregation phase, similar to
        #     SQL having-clause. Dimensions cannot be used in this filter.
        # @!attribute [rw] limit
        #   @return [::Integer]
        #     The number of rows to return. If unspecified, 10,000 rows are returned. The
        #     API returns a maximum of 250,000 rows per request, no matter how many you
        #     ask for. `limit` must be positive.
        #
        #     The API can also return fewer rows than the requested `limit`, if there
        #     aren't as many dimension values as the `limit`. For instance, there are
        #     fewer than 300 possible values for the dimension `country`, so when
        #     reporting on only `country`, you can't get more than 300 rows, even if you
        #     set `limit` to a higher value.
        # @!attribute [rw] metric_aggregations
        #   @return [::Array<::Google::Analytics::Data::V1beta::MetricAggregation>]
        #     Aggregation of metrics. Aggregated metric values will be shown in rows
        #     where the dimension_values are set to "RESERVED_(MetricAggregation)".
        # @!attribute [rw] order_bys
        #   @return [::Array<::Google::Analytics::Data::V1beta::OrderBy>]
        #     Specifies how rows are ordered in the response.
        # @!attribute [rw] return_property_quota
        #   @return [::Boolean]
        #     Toggles whether to return the current state of this Google Analytics
        #     property's Realtime quota. Quota is returned in
        #     [PropertyQuota](#PropertyQuota).
        # @!attribute [rw] minute_ranges
        #   @return [::Array<::Google::Analytics::Data::V1beta::MinuteRange>]
        #     The minute ranges of event data to read. If unspecified, one minute range
        #     for the last 30 minutes will be used. If multiple minute ranges are
        #     requested, each response row will contain a zero based minute range index.
        #     If two minute ranges overlap, the event data for the overlapping minutes is
        #     included in the response rows for both minute ranges.
        class RunRealtimeReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response realtime report table corresponding to a request.
        # @!attribute [rw] dimension_headers
        #   @return [::Array<::Google::Analytics::Data::V1beta::DimensionHeader>]
        #     Describes dimension columns. The number of DimensionHeaders and ordering of
        #     DimensionHeaders matches the dimensions present in rows.
        # @!attribute [rw] metric_headers
        #   @return [::Array<::Google::Analytics::Data::V1beta::MetricHeader>]
        #     Describes metric columns. The number of MetricHeaders and ordering of
        #     MetricHeaders matches the metrics present in rows.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     Rows of dimension value combinations and metric values in the report.
        # @!attribute [rw] totals
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     If requested, the totaled values of metrics.
        # @!attribute [rw] maximums
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     If requested, the maximum values of metrics.
        # @!attribute [rw] minimums
        #   @return [::Array<::Google::Analytics::Data::V1beta::Row>]
        #     If requested, the minimum values of metrics.
        # @!attribute [rw] row_count
        #   @return [::Integer]
        #     The total number of rows in the query result. `rowCount` is independent of
        #     the number of rows returned in the response and the `limit` request
        #     parameter. For example if a query returns 175 rows and includes `limit`
        #     of 50 in the API request, the response will contain `rowCount` of 175 but
        #     only 50 rows.
        # @!attribute [rw] property_quota
        #   @return [::Google::Analytics::Data::V1beta::PropertyQuota]
        #     This Google Analytics property's Realtime quota state including this
        #     request.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Identifies what kind of resource this message is. This `kind` is always the
        #     fixed string "analyticsData#runRealtimeReport". Useful to distinguish
        #     between response types in JSON.
        class RunRealtimeReportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to retrieve configuration metadata about a specific audience
        # export.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The audience export resource name.
        #     Format: `properties/{property}/audienceExports/{audience_export}`
        class GetAudienceExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list all audience exports for a property.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. All audience exports for this property will be listed in the
        #     response. Format: `properties/{property}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of audience exports to return. The service may
        #     return fewer than this value. If unspecified, at most 200 audience exports
        #     will be returned. The maximum value is 1000 (higher values will be coerced
        #     to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListAudienceExports`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListAudienceExports`
        #     must match the call that provided the page token.
        class ListAudienceExportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of all audience exports for a property.
        # @!attribute [rw] audience_exports
        #   @return [::Array<::Google::Analytics::Data::V1beta::AudienceExport>]
        #     Each audience export for a property.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAudienceExportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a new audience export.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this audience export will be created.
        #     Format: `properties/{property}`
        # @!attribute [rw] audience_export
        #   @return [::Google::Analytics::Data::V1beta::AudienceExport]
        #     Required. The audience export to create.
        class CreateAudienceExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An audience export is a list of users in an audience at the time of the
        # list's creation. One audience may have multiple audience exports created for
        # different days.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The audience export resource name assigned during
        #     creation. This resource name identifies this `AudienceExport`.
        #
        #     Format: `properties/{property}/audienceExports/{audience_export}`
        # @!attribute [rw] audience
        #   @return [::String]
        #     Required. The audience resource name. This resource name identifies the
        #     audience being listed and is shared between the Analytics Data & Admin
        #     APIs.
        #
        #     Format: `properties/{property}/audiences/{audience}`
        # @!attribute [r] audience_display_name
        #   @return [::String]
        #     Output only. The descriptive display name for this audience. For example,
        #     "Purchasers".
        # @!attribute [rw] dimensions
        #   @return [::Array<::Google::Analytics::Data::V1beta::AudienceDimension>]
        #     Required. The dimensions requested and displayed in the query response.
        # @!attribute [r] state
        #   @return [::Google::Analytics::Data::V1beta::AudienceExport::State]
        #     Output only. The current state for this AudienceExport.
        # @!attribute [r] begin_creating_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when CreateAudienceExport was called and the
        #     AudienceExport began the `CREATING` state.
        # @!attribute [r] creation_quota_tokens_charged
        #   @return [::Integer]
        #     Output only. The total quota tokens charged during creation of the
        #     AudienceExport. Because this token count is based on activity from the
        #     `CREATING` state, this tokens charged will be fixed once an AudienceExport
        #     enters the `ACTIVE` or `FAILED` states.
        # @!attribute [r] row_count
        #   @return [::Integer]
        #     Output only. The total number of rows in the AudienceExport result.
        # @!attribute [r] error_message
        #   @return [::String]
        #     Output only. Error message is populated when an audience export fails
        #     during creation. A common reason for such a failure is quota exhaustion.
        # @!attribute [r] percentage_completed
        #   @return [::Float]
        #     Output only. The percentage completed for this audience export ranging
        #     between 0 to 100.
        class AudienceExport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The AudienceExport currently exists in this state.
          module State
            # Unspecified state will never be used.
            STATE_UNSPECIFIED = 0

            # The AudienceExport is currently creating and will be available in the
            # future. Creating occurs immediately after the CreateAudienceExport call.
            CREATING = 1

            # The AudienceExport is fully created and ready for querying. An
            # AudienceExport is updated to active asynchronously from a request; this
            # occurs some time (for example 15 minutes) after the initial create call.
            ACTIVE = 2

            # The AudienceExport failed to be created. It is possible that
            # re-requesting this audience export will succeed.
            FAILED = 3
          end
        end

        # This metadata is currently blank.
        class AudienceExportMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list users in an audience export.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the audience export to retrieve users from.
        #     Format: `properties/{property}/audienceExports/{audience_export}`
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     Optional. The row count of the start row. The first row is counted as row
        #     0.
        #
        #     When paging, the first request does not specify offset; or equivalently,
        #     sets offset to 0; the first request returns the first `limit` of rows. The
        #     second request sets offset to the `limit` of the first request; the second
        #     request returns the second `limit` of rows.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        # @!attribute [rw] limit
        #   @return [::Integer]
        #     Optional. The number of rows to return. If unspecified, 10,000 rows are
        #     returned. The API returns a maximum of 250,000 rows per request, no matter
        #     how many you ask for. `limit` must be positive.
        #
        #     The API can also return fewer rows than the requested `limit`, if there
        #     aren't as many dimension values as the `limit`.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        class QueryAudienceExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of users in an audience export.
        # @!attribute [rw] audience_export
        #   @return [::Google::Analytics::Data::V1beta::AudienceExport]
        #     Configuration data about AudienceExport being queried. Returned to help
        #     interpret the audience rows in this response. For example, the dimensions
        #     in this AudienceExport correspond to the columns in the AudienceRows.
        # @!attribute [rw] audience_rows
        #   @return [::Array<::Google::Analytics::Data::V1beta::AudienceRow>]
        #     Rows for each user in an audience export. The number of rows in this
        #     response will be less than or equal to request's page size.
        # @!attribute [rw] row_count
        #   @return [::Integer]
        #     The total number of rows in the AudienceExport result. `rowCount` is
        #     independent of the number of rows returned in the response, the `limit`
        #     request parameter, and the `offset` request parameter. For example if a
        #     query returns 175 rows and includes `limit` of 50 in the API request, the
        #     response will contain `rowCount` of 175 but only 50 rows.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        class QueryAudienceExportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Dimension value attributes for the audience user row.
        # @!attribute [rw] dimension_values
        #   @return [::Array<::Google::Analytics::Data::V1beta::AudienceDimensionValue>]
        #     Each dimension value attribute for an audience user. One dimension value
        #     will be added for each dimension column requested.
        class AudienceRow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An audience dimension is a user attribute. Specific user attributed are
        # requested and then later returned in the `QueryAudienceExportResponse`.
        # @!attribute [rw] dimension_name
        #   @return [::String]
        #     Optional. The API name of the dimension. See the [API
        #     Dimensions](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-api-schema#dimensions)
        #     for the list of dimension names.
        class AudienceDimension
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The value of a dimension.
        # @!attribute [rw] value
        #   @return [::String]
        #     Value as a string if the dimension type is a string.
        class AudienceDimensionValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
