# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Analytics
    module Data
      module V1beta
        module AnalyticsData
          # Path helper methods for the AnalyticsData API.
          module Paths
            ##
            # Create a fully-qualified AudienceExport resource string.
            #
            # The resource will be in the following format:
            #
            # `properties/{property}/audienceExports/{audience_export}`
            #
            # @param property [String]
            # @param audience_export [String]
            #
            # @return [::String]
            def audience_export_path property:, audience_export:
              raise ::ArgumentError, "property cannot contain /" if property.to_s.include? "/"

              "properties/#{property}/audienceExports/#{audience_export}"
            end

            ##
            # Create a fully-qualified Metadata resource string.
            #
            # The resource will be in the following format:
            #
            # `properties/{property}/metadata`
            #
            # @param property [String]
            #
            # @return [::String]
            def metadata_path property:
              "properties/#{property}/metadata"
            end

            ##
            # Create a fully-qualified Property resource string.
            #
            # The resource will be in the following format:
            #
            # `properties/{property}`
            #
            # @param property [String]
            #
            # @return [::String]
            def property_path property:
              "properties/#{property}"
            end

            extend self
          end
        end
      end
    end
  end
end
