# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/analytics/data/v1beta/analytics_data_api_pb"

module Google
  module Analytics
    module Data
      module V1beta
        module AnalyticsData
          ##
          # Client for the AnalyticsData service.
          #
          # Google Analytics reporting data service.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "analyticsdata.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :analytics_data_stub

            ##
            # Configure the AnalyticsData Client class.
            #
            # See {::Google::Analytics::Data::V1beta::AnalyticsData::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all AnalyticsData clients
            #   ::Google::Analytics::Data::V1beta::AnalyticsData::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Analytics", "Data", "V1beta"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [2]
                }

                default_config.rpcs.run_report.timeout = 60.0

                default_config.rpcs.run_pivot_report.timeout = 60.0

                default_config.rpcs.batch_run_reports.timeout = 60.0

                default_config.rpcs.batch_run_pivot_reports.timeout = 60.0

                default_config.rpcs.get_metadata.timeout = 60.0

                default_config.rpcs.run_realtime_report.timeout = 60.0

                default_config.rpcs.check_compatibility.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the AnalyticsData Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Analytics::Data::V1beta::AnalyticsData::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @analytics_data_stub.universe_domain
            end

            ##
            # Create a new AnalyticsData client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Analytics::Data::V1beta::AnalyticsData::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the AnalyticsData client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/analytics/data/v1beta/analytics_data_api_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @analytics_data_stub = ::Gapic::ServiceStub.new(
                ::Google::Analytics::Data::V1beta::BetaAnalyticsData::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @analytics_data_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Analytics::Data::V1beta::AnalyticsData::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @analytics_data_stub.logger
            end

            # Service calls

            ##
            # Returns a customized report of your Google Analytics event data. Reports
            # contain statistics derived from data collected by the Google Analytics
            # tracking code. The data returned from the API is as a table with columns
            # for the requested dimensions and metrics. Metrics are individual
            # measurements of user activity on your property, such as active users or
            # event count. Dimensions break down metrics across some common criteria,
            # such as country or event name.
            #
            # For a guide to constructing requests & understanding responses, see
            # [Creating a
            # Report](https://developers.google.com/analytics/devguides/reporting/data/v1/basics).
            #
            # @overload run_report(request, options = nil)
            #   Pass arguments to `run_report` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::RunReportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::RunReportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload run_report(property: nil, dimensions: nil, metrics: nil, date_ranges: nil, dimension_filter: nil, metric_filter: nil, offset: nil, limit: nil, metric_aggregations: nil, order_bys: nil, currency_code: nil, cohort_spec: nil, keep_empty_rows: nil, return_property_quota: nil, comparisons: nil)
            #   Pass arguments to `run_report` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param property [::String]
            #     A Google Analytics property identifier whose events are tracked.
            #     Specified in the URL path and not the body. To learn more, see [where to
            #     find your Property
            #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
            #     Within a batch request, this property should either be unspecified or
            #     consistent with the batch-level property.
            #
            #     Example: properties/1234
            #   @param dimensions [::Array<::Google::Analytics::Data::V1beta::Dimension, ::Hash>]
            #     The dimensions requested and displayed.
            #   @param metrics [::Array<::Google::Analytics::Data::V1beta::Metric, ::Hash>]
            #     The metrics requested and displayed.
            #   @param date_ranges [::Array<::Google::Analytics::Data::V1beta::DateRange, ::Hash>]
            #     Date ranges of data to read. If multiple date ranges are requested, each
            #     response row will contain a zero based date range index. If two date
            #     ranges overlap, the event data for the overlapping days is included in the
            #     response rows for both date ranges. In a cohort request, this `dateRanges`
            #     must be unspecified.
            #   @param dimension_filter [::Google::Analytics::Data::V1beta::FilterExpression, ::Hash]
            #     Dimension filters let you ask for only specific dimension values in
            #     the report. To learn more, see [Fundamentals of Dimension
            #     Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
            #     for examples. Metrics cannot be used in this filter.
            #   @param metric_filter [::Google::Analytics::Data::V1beta::FilterExpression, ::Hash]
            #     The filter clause of metrics. Applied after aggregating the report's rows,
            #     similar to SQL having-clause. Dimensions cannot be used in this filter.
            #   @param offset [::Integer]
            #     The row count of the start row. The first row is counted as row 0.
            #
            #     When paging, the first request does not specify offset; or equivalently,
            #     sets offset to 0; the first request returns the first `limit` of rows. The
            #     second request sets offset to the `limit` of the first request; the second
            #     request returns the second `limit` of rows.
            #
            #     To learn more about this pagination parameter, see
            #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
            #   @param limit [::Integer]
            #     The number of rows to return. If unspecified, 10,000 rows are returned. The
            #     API returns a maximum of 250,000 rows per request, no matter how many you
            #     ask for. `limit` must be positive.
            #
            #     The API can also return fewer rows than the requested `limit`, if there
            #     aren't as many dimension values as the `limit`. For instance, there are
            #     fewer than 300 possible values for the dimension `country`, so when
            #     reporting on only `country`, you can't get more than 300 rows, even if you
            #     set `limit` to a higher value.
            #
            #     To learn more about this pagination parameter, see
            #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
            #   @param metric_aggregations [::Array<::Google::Analytics::Data::V1beta::MetricAggregation>]
            #     Aggregation of metrics. Aggregated metric values will be shown in rows
            #     where the dimension_values are set to "RESERVED_(MetricAggregation)".
            #     Aggregates including both comparisons and multiple date ranges will
            #     be aggregated based on the date ranges.
            #   @param order_bys [::Array<::Google::Analytics::Data::V1beta::OrderBy, ::Hash>]
            #     Specifies how rows are ordered in the response.
            #     Requests including both comparisons and multiple date ranges will
            #     have order bys applied on the comparisons.
            #   @param currency_code [::String]
            #     A currency code in ISO4217 format, such as "AED", "USD", "JPY".
            #     If the field is empty, the report uses the property's default currency.
            #   @param cohort_spec [::Google::Analytics::Data::V1beta::CohortSpec, ::Hash]
            #     Cohort group associated with this request. If there is a cohort group
            #     in the request the 'cohort' dimension must be present.
            #   @param keep_empty_rows [::Boolean]
            #     If false or unspecified, each row with all metrics equal to 0 will not be
            #     returned. If true, these rows will be returned if they are not separately
            #     removed by a filter.
            #
            #     Regardless of this `keep_empty_rows` setting, only data recorded by the
            #     Google Analytics property can be displayed in a report.
            #
            #     For example if a property never logs a `purchase` event, then a query for
            #     the `eventName` dimension and  `eventCount` metric will not have a row
            #     eventName: "purchase" and eventCount: 0.
            #   @param return_property_quota [::Boolean]
            #     Toggles whether to return the current state of this Google Analytics
            #     property's quota. Quota is returned in [PropertyQuota](#PropertyQuota).
            #   @param comparisons [::Array<::Google::Analytics::Data::V1beta::Comparison, ::Hash>]
            #     Optional. The configuration of comparisons requested and displayed. The
            #     request only requires a comparisons field in order to receive a comparison
            #     column in the response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::RunReportResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::RunReportResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::RunReportRequest.new
            #
            #   # Call the run_report method.
            #   result = client.run_report request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::RunReportResponse.
            #   p result
            #
            def run_report request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::RunReportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.run_report.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.property
                header_params["property"] = request.property
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.run_report.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.run_report.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :run_report, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a customized pivot report of your Google Analytics event data.
            # Pivot reports are more advanced and expressive formats than regular
            # reports. In a pivot report, dimensions are only visible if they are
            # included in a pivot. Multiple pivots can be specified to further dissect
            # your data.
            #
            # @overload run_pivot_report(request, options = nil)
            #   Pass arguments to `run_pivot_report` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::RunPivotReportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::RunPivotReportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload run_pivot_report(property: nil, dimensions: nil, metrics: nil, date_ranges: nil, pivots: nil, dimension_filter: nil, metric_filter: nil, currency_code: nil, cohort_spec: nil, keep_empty_rows: nil, return_property_quota: nil, comparisons: nil)
            #   Pass arguments to `run_pivot_report` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param property [::String]
            #     A Google Analytics property identifier whose events are tracked.
            #     Specified in the URL path and not the body. To learn more, see [where to
            #     find your Property
            #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
            #     Within a batch request, this property should either be unspecified or
            #     consistent with the batch-level property.
            #
            #     Example: properties/1234
            #   @param dimensions [::Array<::Google::Analytics::Data::V1beta::Dimension, ::Hash>]
            #     The dimensions requested. All defined dimensions must be used by one of the
            #     following: dimension_expression, dimension_filter, pivots, order_bys.
            #   @param metrics [::Array<::Google::Analytics::Data::V1beta::Metric, ::Hash>]
            #     The metrics requested, at least one metric needs to be specified. All
            #     defined metrics must be used by one of the following: metric_expression,
            #     metric_filter, order_bys.
            #   @param date_ranges [::Array<::Google::Analytics::Data::V1beta::DateRange, ::Hash>]
            #     The date range to retrieve event data for the report. If multiple date
            #     ranges are specified, event data from each date range is used in the
            #     report. A special dimension with field name "dateRange" can be included in
            #     a Pivot's field names; if included, the report compares between date
            #     ranges. In a cohort request, this `dateRanges` must be unspecified.
            #   @param pivots [::Array<::Google::Analytics::Data::V1beta::Pivot, ::Hash>]
            #     Describes the visual format of the report's dimensions in columns or rows.
            #     The union of the fieldNames (dimension names) in all pivots must be a
            #     subset of dimension names defined in Dimensions. No two pivots can share a
            #     dimension. A dimension is only visible if it appears in a pivot.
            #   @param dimension_filter [::Google::Analytics::Data::V1beta::FilterExpression, ::Hash]
            #     The filter clause of dimensions. Dimensions must be requested to be used in
            #     this filter. Metrics cannot be used in this filter.
            #   @param metric_filter [::Google::Analytics::Data::V1beta::FilterExpression, ::Hash]
            #     The filter clause of metrics. Applied at post aggregation phase, similar to
            #     SQL having-clause. Metrics must be requested to be used in this filter.
            #     Dimensions cannot be used in this filter.
            #   @param currency_code [::String]
            #     A currency code in ISO4217 format, such as "AED", "USD", "JPY".
            #     If the field is empty, the report uses the property's default currency.
            #   @param cohort_spec [::Google::Analytics::Data::V1beta::CohortSpec, ::Hash]
            #     Cohort group associated with this request. If there is a cohort group
            #     in the request the 'cohort' dimension must be present.
            #   @param keep_empty_rows [::Boolean]
            #     If false or unspecified, each row with all metrics equal to 0 will not be
            #     returned. If true, these rows will be returned if they are not separately
            #     removed by a filter.
            #
            #     Regardless of this `keep_empty_rows` setting, only data recorded by the
            #     Google Analytics property can be displayed in a report.
            #
            #     For example if a property never logs a `purchase` event, then a query for
            #     the `eventName` dimension and  `eventCount` metric will not have a row
            #     eventName: "purchase" and eventCount: 0.
            #   @param return_property_quota [::Boolean]
            #     Toggles whether to return the current state of this Google Analytics
            #     property's quota. Quota is returned in [PropertyQuota](#PropertyQuota).
            #   @param comparisons [::Array<::Google::Analytics::Data::V1beta::Comparison, ::Hash>]
            #     Optional. The configuration of comparisons requested and displayed. The
            #     request requires both a comparisons field and a comparisons dimension to
            #     receive a comparison column in the response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::RunPivotReportResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::RunPivotReportResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::RunPivotReportRequest.new
            #
            #   # Call the run_pivot_report method.
            #   result = client.run_pivot_report request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::RunPivotReportResponse.
            #   p result
            #
            def run_pivot_report request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::RunPivotReportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.run_pivot_report.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.property
                header_params["property"] = request.property
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.run_pivot_report.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.run_pivot_report.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :run_pivot_report, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns multiple reports in a batch. All reports must be for the same
            # Google Analytics property.
            #
            # @overload batch_run_reports(request, options = nil)
            #   Pass arguments to `batch_run_reports` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::BatchRunReportsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::BatchRunReportsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_run_reports(property: nil, requests: nil)
            #   Pass arguments to `batch_run_reports` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param property [::String]
            #     A Google Analytics property identifier whose events are tracked.
            #     Specified in the URL path and not the body. To learn more, see [where to
            #     find your Property
            #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
            #     This property must be specified for the batch. The property within
            #     RunReportRequest may either be unspecified or consistent with this
            #     property.
            #
            #     Example: properties/1234
            #   @param requests [::Array<::Google::Analytics::Data::V1beta::RunReportRequest, ::Hash>]
            #     Individual requests. Each request has a separate report response. Each
            #     batch request is allowed up to 5 requests.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::BatchRunReportsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::BatchRunReportsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::BatchRunReportsRequest.new
            #
            #   # Call the batch_run_reports method.
            #   result = client.batch_run_reports request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::BatchRunReportsResponse.
            #   p result
            #
            def batch_run_reports request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::BatchRunReportsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_run_reports.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.property
                header_params["property"] = request.property
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_run_reports.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_run_reports.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :batch_run_reports, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns multiple pivot reports in a batch. All reports must be for the same
            # Google Analytics property.
            #
            # @overload batch_run_pivot_reports(request, options = nil)
            #   Pass arguments to `batch_run_pivot_reports` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::BatchRunPivotReportsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::BatchRunPivotReportsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_run_pivot_reports(property: nil, requests: nil)
            #   Pass arguments to `batch_run_pivot_reports` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param property [::String]
            #     A Google Analytics property identifier whose events are tracked.
            #     Specified in the URL path and not the body. To learn more, see [where to
            #     find your Property
            #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
            #     This property must be specified for the batch. The property within
            #     RunPivotReportRequest may either be unspecified or consistent with this
            #     property.
            #
            #     Example: properties/1234
            #   @param requests [::Array<::Google::Analytics::Data::V1beta::RunPivotReportRequest, ::Hash>]
            #     Individual requests. Each request has a separate pivot report response.
            #     Each batch request is allowed up to 5 requests.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::BatchRunPivotReportsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::BatchRunPivotReportsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::BatchRunPivotReportsRequest.new
            #
            #   # Call the batch_run_pivot_reports method.
            #   result = client.batch_run_pivot_reports request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::BatchRunPivotReportsResponse.
            #   p result
            #
            def batch_run_pivot_reports request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::BatchRunPivotReportsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_run_pivot_reports.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.property
                header_params["property"] = request.property
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_run_pivot_reports.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_run_pivot_reports.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :batch_run_pivot_reports, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns metadata for dimensions and metrics available in reporting methods.
            # Used to explore the dimensions and metrics. In this method, a Google
            # Analytics property identifier is specified in the request, and
            # the metadata response includes Custom dimensions and metrics as well as
            # Universal metadata.
            #
            # For example if a custom metric with parameter name `levels_unlocked` is
            # registered to a property, the Metadata response will contain
            # `customEvent:levels_unlocked`. Universal metadata are dimensions and
            # metrics applicable to any property such as `country` and `totalUsers`.
            #
            # @overload get_metadata(request, options = nil)
            #   Pass arguments to `get_metadata` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::GetMetadataRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::GetMetadataRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_metadata(name: nil)
            #   Pass arguments to `get_metadata` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the metadata to retrieve. This name field is
            #     specified in the URL path and not URL parameters. Property is a numeric
            #     Google Analytics property identifier. To learn more, see [where to find
            #     your Property
            #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
            #
            #     Example: properties/1234/metadata
            #
            #     Set the Property ID to 0 for dimensions and metrics common to all
            #     properties. In this special mode, this method will not return custom
            #     dimensions and metrics.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::Metadata]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::Metadata]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::GetMetadataRequest.new
            #
            #   # Call the get_metadata method.
            #   result = client.get_metadata request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::Metadata.
            #   p result
            #
            def get_metadata request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::GetMetadataRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_metadata.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_metadata.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_metadata.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :get_metadata, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a customized report of realtime event data for your property.
            # Events appear in realtime reports seconds after they have been sent to
            # the Google Analytics. Realtime reports show events and usage data for the
            # periods of time ranging from the present moment to 30 minutes ago (up to
            # 60 minutes for Google Analytics 360 properties).
            #
            # For a guide to constructing realtime requests & understanding responses,
            # see [Creating a Realtime
            # Report](https://developers.google.com/analytics/devguides/reporting/data/v1/realtime-basics).
            #
            # @overload run_realtime_report(request, options = nil)
            #   Pass arguments to `run_realtime_report` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::RunRealtimeReportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::RunRealtimeReportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload run_realtime_report(property: nil, dimensions: nil, metrics: nil, dimension_filter: nil, metric_filter: nil, limit: nil, metric_aggregations: nil, order_bys: nil, return_property_quota: nil, minute_ranges: nil)
            #   Pass arguments to `run_realtime_report` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param property [::String]
            #     A Google Analytics property identifier whose events are tracked.
            #     Specified in the URL path and not the body. To learn more, see [where to
            #     find your Property
            #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
            #
            #     Example: properties/1234
            #   @param dimensions [::Array<::Google::Analytics::Data::V1beta::Dimension, ::Hash>]
            #     The dimensions requested and displayed.
            #   @param metrics [::Array<::Google::Analytics::Data::V1beta::Metric, ::Hash>]
            #     The metrics requested and displayed.
            #   @param dimension_filter [::Google::Analytics::Data::V1beta::FilterExpression, ::Hash]
            #     The filter clause of dimensions. Metrics cannot be used in this filter.
            #   @param metric_filter [::Google::Analytics::Data::V1beta::FilterExpression, ::Hash]
            #     The filter clause of metrics. Applied at post aggregation phase, similar to
            #     SQL having-clause. Dimensions cannot be used in this filter.
            #   @param limit [::Integer]
            #     The number of rows to return. If unspecified, 10,000 rows are returned. The
            #     API returns a maximum of 250,000 rows per request, no matter how many you
            #     ask for. `limit` must be positive.
            #
            #     The API can also return fewer rows than the requested `limit`, if there
            #     aren't as many dimension values as the `limit`. For instance, there are
            #     fewer than 300 possible values for the dimension `country`, so when
            #     reporting on only `country`, you can't get more than 300 rows, even if you
            #     set `limit` to a higher value.
            #   @param metric_aggregations [::Array<::Google::Analytics::Data::V1beta::MetricAggregation>]
            #     Aggregation of metrics. Aggregated metric values will be shown in rows
            #     where the dimension_values are set to "RESERVED_(MetricAggregation)".
            #   @param order_bys [::Array<::Google::Analytics::Data::V1beta::OrderBy, ::Hash>]
            #     Specifies how rows are ordered in the response.
            #   @param return_property_quota [::Boolean]
            #     Toggles whether to return the current state of this Google Analytics
            #     property's Realtime quota. Quota is returned in
            #     [PropertyQuota](#PropertyQuota).
            #   @param minute_ranges [::Array<::Google::Analytics::Data::V1beta::MinuteRange, ::Hash>]
            #     The minute ranges of event data to read. If unspecified, one minute range
            #     for the last 30 minutes will be used. If multiple minute ranges are
            #     requested, each response row will contain a zero based minute range index.
            #     If two minute ranges overlap, the event data for the overlapping minutes is
            #     included in the response rows for both minute ranges.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::RunRealtimeReportResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::RunRealtimeReportResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::RunRealtimeReportRequest.new
            #
            #   # Call the run_realtime_report method.
            #   result = client.run_realtime_report request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::RunRealtimeReportResponse.
            #   p result
            #
            def run_realtime_report request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::RunRealtimeReportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.run_realtime_report.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.property
                header_params["property"] = request.property
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.run_realtime_report.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.run_realtime_report.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :run_realtime_report, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # This compatibility method lists dimensions and metrics that can be added to
            # a report request and maintain compatibility. This method fails if the
            # request's dimensions and metrics are incompatible.
            #
            # In Google Analytics, reports fail if they request incompatible dimensions
            # and/or metrics; in that case, you will need to remove dimensions and/or
            # metrics from the incompatible report until the report is compatible.
            #
            # The Realtime and Core reports have different compatibility rules. This
            # method checks compatibility for Core reports.
            #
            # @overload check_compatibility(request, options = nil)
            #   Pass arguments to `check_compatibility` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::CheckCompatibilityRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::CheckCompatibilityRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload check_compatibility(property: nil, dimensions: nil, metrics: nil, dimension_filter: nil, metric_filter: nil, compatibility_filter: nil)
            #   Pass arguments to `check_compatibility` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param property [::String]
            #     A Google Analytics property identifier whose events are tracked. To
            #     learn more, see [where to find your Property
            #     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
            #     `property` should be the same value as in your `runReport` request.
            #
            #     Example: properties/1234
            #   @param dimensions [::Array<::Google::Analytics::Data::V1beta::Dimension, ::Hash>]
            #     The dimensions in this report. `dimensions` should be the same value as in
            #     your `runReport` request.
            #   @param metrics [::Array<::Google::Analytics::Data::V1beta::Metric, ::Hash>]
            #     The metrics in this report. `metrics` should be the same value as in your
            #     `runReport` request.
            #   @param dimension_filter [::Google::Analytics::Data::V1beta::FilterExpression, ::Hash]
            #     The filter clause of dimensions. `dimensionFilter` should be the same value
            #     as in your `runReport` request.
            #   @param metric_filter [::Google::Analytics::Data::V1beta::FilterExpression, ::Hash]
            #     The filter clause of metrics. `metricFilter` should be the same value as in
            #     your `runReport` request
            #   @param compatibility_filter [::Google::Analytics::Data::V1beta::Compatibility]
            #     Filters the dimensions and metrics in the response to just this
            #     compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
            #     to only return compatible dimensions & metrics.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::CheckCompatibilityResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::CheckCompatibilityResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::CheckCompatibilityRequest.new
            #
            #   # Call the check_compatibility method.
            #   result = client.check_compatibility request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::CheckCompatibilityResponse.
            #   p result
            #
            def check_compatibility request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::CheckCompatibilityRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.check_compatibility.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.property
                header_params["property"] = request.property
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.check_compatibility.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.check_compatibility.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :check_compatibility, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an audience export for later retrieval. This method quickly returns
            # the audience export's resource name and initiates a long running
            # asynchronous request to form an audience export. To export the users in an
            # audience export, first create the audience export through this method and
            # then send the audience resource name to the `QueryAudienceExport` method.
            #
            # See [Creating an Audience
            # Export](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
            # for an introduction to Audience Exports with examples.
            #
            # An audience export is a snapshot of the users currently in the audience at
            # the time of audience export creation. Creating audience exports for one
            # audience on different days will return different results as users enter and
            # exit the audience.
            #
            # Audiences in Google Analytics 4 allow you to segment your users in the ways
            # that are important to your business. To learn more, see
            # https://support.google.com/analytics/answer/9267572. Audience exports
            # contain the users in each audience.
            #
            # Audience Export APIs have some methods at alpha and other methods at beta
            # stability. The intention is to advance methods to beta stability after some
            # feedback and adoption. To give your feedback on this API, complete the
            # [Google Analytics Audience Export API
            # Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
            #
            # @overload create_audience_export(request, options = nil)
            #   Pass arguments to `create_audience_export` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::CreateAudienceExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::CreateAudienceExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_audience_export(parent: nil, audience_export: nil)
            #   Pass arguments to `create_audience_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this audience export will be created.
            #     Format: `properties/{property}`
            #   @param audience_export [::Google::Analytics::Data::V1beta::AudienceExport, ::Hash]
            #     Required. The audience export to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::CreateAudienceExportRequest.new
            #
            #   # Call the create_audience_export method.
            #   result = client.create_audience_export request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_audience_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::CreateAudienceExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_audience_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_audience_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_audience_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :create_audience_export, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves an audience export of users. After creating an audience, the
            # users are not immediately available for exporting. First, a request to
            # `CreateAudienceExport` is necessary to create an audience export of users,
            # and then second, this method is used to retrieve the users in the audience
            # export.
            #
            # See [Creating an Audience
            # Export](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
            # for an introduction to Audience Exports with examples.
            #
            # Audiences in Google Analytics 4 allow you to segment your users in the ways
            # that are important to your business. To learn more, see
            # https://support.google.com/analytics/answer/9267572.
            #
            # Audience Export APIs have some methods at alpha and other methods at beta
            # stability. The intention is to advance methods to beta stability after some
            # feedback and adoption. To give your feedback on this API, complete the
            # [Google Analytics Audience Export API
            # Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
            #
            # @overload query_audience_export(request, options = nil)
            #   Pass arguments to `query_audience_export` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::QueryAudienceExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::QueryAudienceExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_audience_export(name: nil, offset: nil, limit: nil)
            #   Pass arguments to `query_audience_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the audience export to retrieve users from.
            #     Format: `properties/{property}/audienceExports/{audience_export}`
            #   @param offset [::Integer]
            #     Optional. The row count of the start row. The first row is counted as row
            #     0.
            #
            #     When paging, the first request does not specify offset; or equivalently,
            #     sets offset to 0; the first request returns the first `limit` of rows. The
            #     second request sets offset to the `limit` of the first request; the second
            #     request returns the second `limit` of rows.
            #
            #     To learn more about this pagination parameter, see
            #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
            #   @param limit [::Integer]
            #     Optional. The number of rows to return. If unspecified, 10,000 rows are
            #     returned. The API returns a maximum of 250,000 rows per request, no matter
            #     how many you ask for. `limit` must be positive.
            #
            #     The API can also return fewer rows than the requested `limit`, if there
            #     aren't as many dimension values as the `limit`.
            #
            #     To learn more about this pagination parameter, see
            #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::QueryAudienceExportResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::QueryAudienceExportResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::QueryAudienceExportRequest.new
            #
            #   # Call the query_audience_export method.
            #   result = client.query_audience_export request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::QueryAudienceExportResponse.
            #   p result
            #
            def query_audience_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::QueryAudienceExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_audience_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_audience_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_audience_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :query_audience_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets configuration metadata about a specific audience export. This method
            # can be used to understand an audience export after it has been created.
            #
            # See [Creating an Audience
            # Export](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
            # for an introduction to Audience Exports with examples.
            #
            # Audience Export APIs have some methods at alpha and other methods at beta
            # stability. The intention is to advance methods to beta stability after some
            # feedback and adoption. To give your feedback on this API, complete the
            # [Google Analytics Audience Export API
            # Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
            #
            # @overload get_audience_export(request, options = nil)
            #   Pass arguments to `get_audience_export` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::GetAudienceExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::GetAudienceExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_audience_export(name: nil)
            #   Pass arguments to `get_audience_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The audience export resource name.
            #     Format: `properties/{property}/audienceExports/{audience_export}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Analytics::Data::V1beta::AudienceExport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Analytics::Data::V1beta::AudienceExport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::GetAudienceExportRequest.new
            #
            #   # Call the get_audience_export method.
            #   result = client.get_audience_export request
            #
            #   # The returned object is of type Google::Analytics::Data::V1beta::AudienceExport.
            #   p result
            #
            def get_audience_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::GetAudienceExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_audience_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_audience_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_audience_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :get_audience_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all audience exports for a property. This method can be used for you
            # to find and reuse existing audience exports rather than creating
            # unnecessary new audience exports. The same audience can have multiple
            # audience exports that represent the export of users that were in an
            # audience on different days.
            #
            # See [Creating an Audience
            # Export](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
            # for an introduction to Audience Exports with examples.
            #
            # Audience Export APIs have some methods at alpha and other methods at beta
            # stability. The intention is to advance methods to beta stability after some
            # feedback and adoption. To give your feedback on this API, complete the
            # [Google Analytics Audience Export API
            # Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
            #
            # @overload list_audience_exports(request, options = nil)
            #   Pass arguments to `list_audience_exports` via a request object, either of type
            #   {::Google::Analytics::Data::V1beta::ListAudienceExportsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Analytics::Data::V1beta::ListAudienceExportsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_audience_exports(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_audience_exports` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. All audience exports for this property will be listed in the
            #     response. Format: `properties/{property}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of audience exports to return. The service may
            #     return fewer than this value. If unspecified, at most 200 audience exports
            #     will be returned. The maximum value is 1000 (higher values will be coerced
            #     to the maximum).
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous `ListAudienceExports`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListAudienceExports`
            #     must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Analytics::Data::V1beta::AudienceExport>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Analytics::Data::V1beta::AudienceExport>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/analytics/data/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Analytics::Data::V1beta::AnalyticsData::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Analytics::Data::V1beta::ListAudienceExportsRequest.new
            #
            #   # Call the list_audience_exports method.
            #   result = client.list_audience_exports request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Analytics::Data::V1beta::AudienceExport.
            #     p item
            #   end
            #
            def list_audience_exports request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Data::V1beta::ListAudienceExportsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_audience_exports.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Analytics::Data::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_audience_exports.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_audience_exports.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @analytics_data_stub.call_rpc :list_audience_exports, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @analytics_data_stub, :list_audience_exports, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the AnalyticsData API.
            #
            # This class represents the configuration for AnalyticsData,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Analytics::Data::V1beta::AnalyticsData::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # run_report to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Analytics::Data::V1beta::AnalyticsData::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.run_report.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Analytics::Data::V1beta::AnalyticsData::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.run_report.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Analytics::Data::V1beta::AnalyticsData::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "analyticsdata.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the AnalyticsData API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `run_report`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :run_report
                ##
                # RPC-specific configuration for `run_pivot_report`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :run_pivot_report
                ##
                # RPC-specific configuration for `batch_run_reports`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_run_reports
                ##
                # RPC-specific configuration for `batch_run_pivot_reports`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_run_pivot_reports
                ##
                # RPC-specific configuration for `get_metadata`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_metadata
                ##
                # RPC-specific configuration for `run_realtime_report`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :run_realtime_report
                ##
                # RPC-specific configuration for `check_compatibility`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :check_compatibility
                ##
                # RPC-specific configuration for `create_audience_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_audience_export
                ##
                # RPC-specific configuration for `query_audience_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_audience_export
                ##
                # RPC-specific configuration for `get_audience_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_audience_export
                ##
                # RPC-specific configuration for `list_audience_exports`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_audience_exports

                # @private
                def initialize parent_rpcs = nil
                  run_report_config = parent_rpcs.run_report if parent_rpcs.respond_to? :run_report
                  @run_report = ::Gapic::Config::Method.new run_report_config
                  run_pivot_report_config = parent_rpcs.run_pivot_report if parent_rpcs.respond_to? :run_pivot_report
                  @run_pivot_report = ::Gapic::Config::Method.new run_pivot_report_config
                  batch_run_reports_config = parent_rpcs.batch_run_reports if parent_rpcs.respond_to? :batch_run_reports
                  @batch_run_reports = ::Gapic::Config::Method.new batch_run_reports_config
                  batch_run_pivot_reports_config = parent_rpcs.batch_run_pivot_reports if parent_rpcs.respond_to? :batch_run_pivot_reports
                  @batch_run_pivot_reports = ::Gapic::Config::Method.new batch_run_pivot_reports_config
                  get_metadata_config = parent_rpcs.get_metadata if parent_rpcs.respond_to? :get_metadata
                  @get_metadata = ::Gapic::Config::Method.new get_metadata_config
                  run_realtime_report_config = parent_rpcs.run_realtime_report if parent_rpcs.respond_to? :run_realtime_report
                  @run_realtime_report = ::Gapic::Config::Method.new run_realtime_report_config
                  check_compatibility_config = parent_rpcs.check_compatibility if parent_rpcs.respond_to? :check_compatibility
                  @check_compatibility = ::Gapic::Config::Method.new check_compatibility_config
                  create_audience_export_config = parent_rpcs.create_audience_export if parent_rpcs.respond_to? :create_audience_export
                  @create_audience_export = ::Gapic::Config::Method.new create_audience_export_config
                  query_audience_export_config = parent_rpcs.query_audience_export if parent_rpcs.respond_to? :query_audience_export
                  @query_audience_export = ::Gapic::Config::Method.new query_audience_export_config
                  get_audience_export_config = parent_rpcs.get_audience_export if parent_rpcs.respond_to? :get_audience_export
                  @get_audience_export = ::Gapic::Config::Method.new get_audience_export_config
                  list_audience_exports_config = parent_rpcs.list_audience_exports if parent_rpcs.respond_to? :list_audience_exports
                  @list_audience_exports = ::Gapic::Config::Method.new list_audience_exports_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
