# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/analytics/admin/v1alpha/analytics_admin_pb"
require "google/analytics/admin/v1alpha/analytics_admin_service"

class ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_account
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Account.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_account_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_account, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetAccountRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_account_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_account({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_account name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_account ::Google::Analytics::Admin::V1alpha::GetAccountRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_account({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_account(::Google::Analytics::Admin::V1alpha::GetAccountRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_account_client_stub.call_rpc_count
    end
  end

  def test_list_accounts
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListAccountsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_accounts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_accounts, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListAccountsRequest, request
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["show_deleted"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_accounts_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_accounts({ page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_accounts page_size: page_size, page_token: page_token, show_deleted: show_deleted do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_accounts ::Google::Analytics::Admin::V1alpha::ListAccountsRequest.new(page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_accounts({ page_size: page_size, page_token: page_token, show_deleted: show_deleted }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_accounts(::Google::Analytics::Admin::V1alpha::ListAccountsRequest.new(page_size: page_size, page_token: page_token, show_deleted: show_deleted), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_accounts_client_stub.call_rpc_count
    end
  end

  def test_delete_account
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_account_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_account, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteAccountRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_account_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_account({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_account name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_account ::Google::Analytics::Admin::V1alpha::DeleteAccountRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_account({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_account(::Google::Analytics::Admin::V1alpha::DeleteAccountRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_account_client_stub.call_rpc_count
    end
  end

  def test_update_account
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Account.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    account = {}
    update_mask = {}

    update_account_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_account, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateAccountRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::Account), request["account"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_account_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_account({ account: account, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_account account: account, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_account ::Google::Analytics::Admin::V1alpha::UpdateAccountRequest.new(account: account, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_account({ account: account, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_account(::Google::Analytics::Admin::V1alpha::UpdateAccountRequest.new(account: account, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_account_client_stub.call_rpc_count
    end
  end

  def test_provision_account_ticket
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    account = {}
    redirect_uri = "hello world"

    provision_account_ticket_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :provision_account_ticket, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::Account), request["account"]
      assert_equal "hello world", request["redirect_uri"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, provision_account_ticket_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.provision_account_ticket({ account: account, redirect_uri: redirect_uri }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.provision_account_ticket account: account, redirect_uri: redirect_uri do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.provision_account_ticket ::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest.new(account: account, redirect_uri: redirect_uri) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.provision_account_ticket({ account: account, redirect_uri: redirect_uri }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.provision_account_ticket(::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest.new(account: account, redirect_uri: redirect_uri), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, provision_account_ticket_client_stub.call_rpc_count
    end
  end

  def test_list_account_summaries
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListAccountSummariesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"

    list_account_summaries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_account_summaries, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest, request
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_account_summaries_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_account_summaries({ page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_account_summaries page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_account_summaries ::Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest.new(page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_account_summaries({ page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_account_summaries(::Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest.new(page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_account_summaries_client_stub.call_rpc_count
    end
  end

  def test_get_property
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Property.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_property_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_property, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetPropertyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_property_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_property({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_property name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_property ::Google::Analytics::Admin::V1alpha::GetPropertyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_property({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_property(::Google::Analytics::Admin::V1alpha::GetPropertyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_property_client_stub.call_rpc_count
    end
  end

  def test_list_properties
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListPropertiesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_properties_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_properties, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListPropertiesRequest, request
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["show_deleted"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_properties_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_properties({ filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_properties filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_properties ::Google::Analytics::Admin::V1alpha::ListPropertiesRequest.new(filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_properties({ filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_properties(::Google::Analytics::Admin::V1alpha::ListPropertiesRequest.new(filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_properties_client_stub.call_rpc_count
    end
  end

  def test_create_property
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Property.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    property = {}

    create_property_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_property, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreatePropertyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::Property), request["property"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_property_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_property({ property: property }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_property property: property do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_property ::Google::Analytics::Admin::V1alpha::CreatePropertyRequest.new(property: property) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_property({ property: property }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_property(::Google::Analytics::Admin::V1alpha::CreatePropertyRequest.new(property: property), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_property_client_stub.call_rpc_count
    end
  end

  def test_delete_property
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Property.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_property_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_property, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeletePropertyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_property_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_property({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_property name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_property ::Google::Analytics::Admin::V1alpha::DeletePropertyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_property({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_property(::Google::Analytics::Admin::V1alpha::DeletePropertyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_property_client_stub.call_rpc_count
    end
  end

  def test_update_property
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Property.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    property = {}
    update_mask = {}

    update_property_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_property, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdatePropertyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::Property), request["property"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_property_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_property({ property: property, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_property property: property, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_property ::Google::Analytics::Admin::V1alpha::UpdatePropertyRequest.new(property: property, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_property({ property: property, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_property(::Google::Analytics::Admin::V1alpha::UpdatePropertyRequest.new(property: property, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_property_client_stub.call_rpc_count
    end
  end

  def test_create_firebase_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::FirebaseLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    firebase_link = {}

    create_firebase_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_firebase_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::FirebaseLink), request["firebase_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_firebase_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_firebase_link({ parent: parent, firebase_link: firebase_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_firebase_link parent: parent, firebase_link: firebase_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_firebase_link ::Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest.new(parent: parent, firebase_link: firebase_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_firebase_link({ parent: parent, firebase_link: firebase_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_firebase_link(::Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest.new(parent: parent, firebase_link: firebase_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_firebase_link_client_stub.call_rpc_count
    end
  end

  def test_delete_firebase_link
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_firebase_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_firebase_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_firebase_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_firebase_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_firebase_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_firebase_link ::Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_firebase_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_firebase_link(::Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_firebase_link_client_stub.call_rpc_count
    end
  end

  def test_list_firebase_links
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListFirebaseLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_firebase_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_firebase_links, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_firebase_links_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_firebase_links({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_firebase_links parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_firebase_links ::Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_firebase_links({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_firebase_links(::Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_firebase_links_client_stub.call_rpc_count
    end
  end

  def test_get_global_site_tag
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::GlobalSiteTag.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_global_site_tag_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_global_site_tag, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_global_site_tag_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_global_site_tag({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_global_site_tag name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_global_site_tag ::Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_global_site_tag({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_global_site_tag(::Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_global_site_tag_client_stub.call_rpc_count
    end
  end

  def test_create_google_ads_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::GoogleAdsLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    google_ads_link = {}

    create_google_ads_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_google_ads_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::GoogleAdsLink), request["google_ads_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_google_ads_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_google_ads_link({ parent: parent, google_ads_link: google_ads_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_google_ads_link parent: parent, google_ads_link: google_ads_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_google_ads_link ::Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest.new(parent: parent, google_ads_link: google_ads_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_google_ads_link({ parent: parent, google_ads_link: google_ads_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_google_ads_link(::Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest.new(parent: parent, google_ads_link: google_ads_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_google_ads_link_client_stub.call_rpc_count
    end
  end

  def test_update_google_ads_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::GoogleAdsLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    google_ads_link = {}
    update_mask = {}

    update_google_ads_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_google_ads_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::GoogleAdsLink), request["google_ads_link"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_google_ads_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_google_ads_link({ google_ads_link: google_ads_link, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_google_ads_link google_ads_link: google_ads_link, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_google_ads_link ::Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest.new(google_ads_link: google_ads_link, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_google_ads_link({ google_ads_link: google_ads_link, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_google_ads_link(::Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest.new(google_ads_link: google_ads_link, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_google_ads_link_client_stub.call_rpc_count
    end
  end

  def test_delete_google_ads_link
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_google_ads_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_google_ads_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_google_ads_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_google_ads_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_google_ads_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_google_ads_link ::Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_google_ads_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_google_ads_link(::Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_google_ads_link_client_stub.call_rpc_count
    end
  end

  def test_list_google_ads_links
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_google_ads_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_google_ads_links, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_google_ads_links_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_google_ads_links({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_google_ads_links parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_google_ads_links ::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_google_ads_links({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_google_ads_links(::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_google_ads_links_client_stub.call_rpc_count
    end
  end

  def test_get_data_sharing_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DataSharingSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_sharing_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_sharing_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_sharing_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_sharing_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_sharing_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_sharing_settings ::Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_sharing_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_sharing_settings(::Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_sharing_settings_client_stub.call_rpc_count
    end
  end

  def test_get_measurement_protocol_secret
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_measurement_protocol_secret_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_measurement_protocol_secret, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_measurement_protocol_secret_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_measurement_protocol_secret({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_measurement_protocol_secret name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_measurement_protocol_secret ::Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_measurement_protocol_secret({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_measurement_protocol_secret(::Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_measurement_protocol_secret_client_stub.call_rpc_count
    end
  end

  def test_list_measurement_protocol_secrets
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_measurement_protocol_secrets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_measurement_protocol_secrets, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_measurement_protocol_secrets_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_measurement_protocol_secrets({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_measurement_protocol_secrets parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_measurement_protocol_secrets ::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_measurement_protocol_secrets({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_measurement_protocol_secrets(::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_measurement_protocol_secrets_client_stub.call_rpc_count
    end
  end

  def test_create_measurement_protocol_secret
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    measurement_protocol_secret = {}

    create_measurement_protocol_secret_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_measurement_protocol_secret, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret), request["measurement_protocol_secret"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_measurement_protocol_secret_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_measurement_protocol_secret({ parent: parent, measurement_protocol_secret: measurement_protocol_secret }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_measurement_protocol_secret parent: parent, measurement_protocol_secret: measurement_protocol_secret do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_measurement_protocol_secret ::Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest.new(parent: parent, measurement_protocol_secret: measurement_protocol_secret) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_measurement_protocol_secret({ parent: parent, measurement_protocol_secret: measurement_protocol_secret }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_measurement_protocol_secret(::Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest.new(parent: parent, measurement_protocol_secret: measurement_protocol_secret), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_measurement_protocol_secret_client_stub.call_rpc_count
    end
  end

  def test_delete_measurement_protocol_secret
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_measurement_protocol_secret_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_measurement_protocol_secret, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_measurement_protocol_secret_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_measurement_protocol_secret({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_measurement_protocol_secret name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_measurement_protocol_secret ::Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_measurement_protocol_secret({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_measurement_protocol_secret(::Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_measurement_protocol_secret_client_stub.call_rpc_count
    end
  end

  def test_update_measurement_protocol_secret
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    measurement_protocol_secret = {}
    update_mask = {}

    update_measurement_protocol_secret_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_measurement_protocol_secret, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret), request["measurement_protocol_secret"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_measurement_protocol_secret_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_measurement_protocol_secret({ measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_measurement_protocol_secret measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_measurement_protocol_secret ::Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest.new(measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_measurement_protocol_secret({ measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_measurement_protocol_secret(::Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest.new(measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_measurement_protocol_secret_client_stub.call_rpc_count
    end
  end

  def test_acknowledge_user_data_collection
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    property = "hello world"
    acknowledgement = "hello world"

    acknowledge_user_data_collection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :acknowledge_user_data_collection, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest, request
      assert_equal "hello world", request["property"]
      assert_equal "hello world", request["acknowledgement"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, acknowledge_user_data_collection_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.acknowledge_user_data_collection({ property: property, acknowledgement: acknowledgement }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.acknowledge_user_data_collection property: property, acknowledgement: acknowledgement do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.acknowledge_user_data_collection ::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest.new(property: property, acknowledgement: acknowledgement) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.acknowledge_user_data_collection({ property: property, acknowledgement: acknowledgement }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.acknowledge_user_data_collection(::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest.new(property: property, acknowledgement: acknowledgement), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, acknowledge_user_data_collection_client_stub.call_rpc_count
    end
  end

  def test_get_sk_ad_network_conversion_value_schema
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_sk_ad_network_conversion_value_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_sk_ad_network_conversion_value_schema, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_sk_ad_network_conversion_value_schema_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_sk_ad_network_conversion_value_schema({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_sk_ad_network_conversion_value_schema name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_sk_ad_network_conversion_value_schema ::Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_sk_ad_network_conversion_value_schema({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_sk_ad_network_conversion_value_schema(::Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_sk_ad_network_conversion_value_schema_client_stub.call_rpc_count
    end
  end

  def test_create_sk_ad_network_conversion_value_schema
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    skadnetwork_conversion_value_schema = {}

    create_sk_ad_network_conversion_value_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_sk_ad_network_conversion_value_schema, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema), request["skadnetwork_conversion_value_schema"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_sk_ad_network_conversion_value_schema_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_sk_ad_network_conversion_value_schema({ parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_sk_ad_network_conversion_value_schema parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_sk_ad_network_conversion_value_schema ::Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest.new(parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_sk_ad_network_conversion_value_schema({ parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_sk_ad_network_conversion_value_schema(::Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest.new(parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_sk_ad_network_conversion_value_schema_client_stub.call_rpc_count
    end
  end

  def test_delete_sk_ad_network_conversion_value_schema
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_sk_ad_network_conversion_value_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_sk_ad_network_conversion_value_schema, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_sk_ad_network_conversion_value_schema_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_sk_ad_network_conversion_value_schema({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_sk_ad_network_conversion_value_schema name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_sk_ad_network_conversion_value_schema ::Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_sk_ad_network_conversion_value_schema({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_sk_ad_network_conversion_value_schema(::Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_sk_ad_network_conversion_value_schema_client_stub.call_rpc_count
    end
  end

  def test_update_sk_ad_network_conversion_value_schema
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    skadnetwork_conversion_value_schema = {}
    update_mask = {}

    update_sk_ad_network_conversion_value_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_sk_ad_network_conversion_value_schema, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema), request["skadnetwork_conversion_value_schema"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_sk_ad_network_conversion_value_schema_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_sk_ad_network_conversion_value_schema({ skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_sk_ad_network_conversion_value_schema skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_sk_ad_network_conversion_value_schema ::Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest.new(skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_sk_ad_network_conversion_value_schema({ skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_sk_ad_network_conversion_value_schema(::Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest.new(skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_sk_ad_network_conversion_value_schema_client_stub.call_rpc_count
    end
  end

  def test_list_sk_ad_network_conversion_value_schemas
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_sk_ad_network_conversion_value_schemas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sk_ad_network_conversion_value_schemas, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sk_ad_network_conversion_value_schemas_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sk_ad_network_conversion_value_schemas({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sk_ad_network_conversion_value_schemas parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sk_ad_network_conversion_value_schemas ::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sk_ad_network_conversion_value_schemas({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sk_ad_network_conversion_value_schemas(::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sk_ad_network_conversion_value_schemas_client_stub.call_rpc_count
    end
  end

  def test_search_change_history_events
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    property = "hello world"
    resource_type = [:CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED]
    action = [:ACTION_TYPE_UNSPECIFIED]
    actor_email = ["hello world"]
    earliest_change_time = {}
    latest_change_time = {}
    page_size = 42
    page_token = "hello world"

    search_change_history_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_change_history_events, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest, request
      assert_equal "hello world", request["account"]
      assert_equal "hello world", request["property"]
      assert_equal [:CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED], request["resource_type"]
      assert_equal [:ACTION_TYPE_UNSPECIFIED], request["action"]
      assert_equal ["hello world"], request["actor_email"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["earliest_change_time"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["latest_change_time"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_change_history_events_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_change_history_events({ account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_change_history_events account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_change_history_events ::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest.new(account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_change_history_events({ account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_change_history_events(::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest.new(account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_change_history_events_client_stub.call_rpc_count
    end
  end

  def test_get_google_signals_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_google_signals_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_google_signals_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_google_signals_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_google_signals_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_google_signals_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_google_signals_settings ::Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_google_signals_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_google_signals_settings(::Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_google_signals_settings_client_stub.call_rpc_count
    end
  end

  def test_update_google_signals_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    google_signals_settings = {}
    update_mask = {}

    update_google_signals_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_google_signals_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings), request["google_signals_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_google_signals_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_google_signals_settings({ google_signals_settings: google_signals_settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_google_signals_settings google_signals_settings: google_signals_settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_google_signals_settings ::Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest.new(google_signals_settings: google_signals_settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_google_signals_settings({ google_signals_settings: google_signals_settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_google_signals_settings(::Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest.new(google_signals_settings: google_signals_settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_google_signals_settings_client_stub.call_rpc_count
    end
  end

  def test_create_conversion_event
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ConversionEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversion_event = {}
    parent = "hello world"

    create_conversion_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_conversion_event, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateConversionEventRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::ConversionEvent), request["conversion_event"]
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_conversion_event_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_conversion_event({ conversion_event: conversion_event, parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_conversion_event conversion_event: conversion_event, parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_conversion_event ::Google::Analytics::Admin::V1alpha::CreateConversionEventRequest.new(conversion_event: conversion_event, parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_conversion_event({ conversion_event: conversion_event, parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_conversion_event(::Google::Analytics::Admin::V1alpha::CreateConversionEventRequest.new(conversion_event: conversion_event, parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_conversion_event_client_stub.call_rpc_count
    end
  end

  def test_update_conversion_event
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ConversionEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversion_event = {}
    update_mask = {}

    update_conversion_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_conversion_event, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::ConversionEvent), request["conversion_event"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_conversion_event_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_conversion_event({ conversion_event: conversion_event, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_conversion_event conversion_event: conversion_event, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_conversion_event ::Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest.new(conversion_event: conversion_event, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_conversion_event({ conversion_event: conversion_event, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_conversion_event(::Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest.new(conversion_event: conversion_event, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_conversion_event_client_stub.call_rpc_count
    end
  end

  def test_get_conversion_event
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ConversionEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_conversion_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_conversion_event, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetConversionEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_conversion_event_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_conversion_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_conversion_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_conversion_event ::Google::Analytics::Admin::V1alpha::GetConversionEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_conversion_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_conversion_event(::Google::Analytics::Admin::V1alpha::GetConversionEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_conversion_event_client_stub.call_rpc_count
    end
  end

  def test_delete_conversion_event
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_conversion_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_conversion_event, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_conversion_event_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_conversion_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_conversion_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_conversion_event ::Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_conversion_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_conversion_event(::Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_conversion_event_client_stub.call_rpc_count
    end
  end

  def test_list_conversion_events
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListConversionEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_conversion_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_conversion_events, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListConversionEventsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_conversion_events_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_conversion_events({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_conversion_events parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_conversion_events ::Google::Analytics::Admin::V1alpha::ListConversionEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_conversion_events({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_conversion_events(::Google::Analytics::Admin::V1alpha::ListConversionEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_conversion_events_client_stub.call_rpc_count
    end
  end

  def test_create_key_event
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::KeyEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    key_event = {}
    parent = "hello world"

    create_key_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_key_event, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateKeyEventRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::KeyEvent), request["key_event"]
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_key_event_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_key_event({ key_event: key_event, parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_key_event key_event: key_event, parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_key_event ::Google::Analytics::Admin::V1alpha::CreateKeyEventRequest.new(key_event: key_event, parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_key_event({ key_event: key_event, parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_key_event(::Google::Analytics::Admin::V1alpha::CreateKeyEventRequest.new(key_event: key_event, parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_key_event_client_stub.call_rpc_count
    end
  end

  def test_update_key_event
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::KeyEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    key_event = {}
    update_mask = {}

    update_key_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_key_event, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::KeyEvent), request["key_event"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_key_event_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_key_event({ key_event: key_event, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_key_event key_event: key_event, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_key_event ::Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest.new(key_event: key_event, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_key_event({ key_event: key_event, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_key_event(::Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest.new(key_event: key_event, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_key_event_client_stub.call_rpc_count
    end
  end

  def test_get_key_event
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::KeyEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_key_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_key_event, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetKeyEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_key_event_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_key_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_key_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_key_event ::Google::Analytics::Admin::V1alpha::GetKeyEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_key_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_key_event(::Google::Analytics::Admin::V1alpha::GetKeyEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_key_event_client_stub.call_rpc_count
    end
  end

  def test_delete_key_event
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_key_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_key_event, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_key_event_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_key_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_key_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_key_event ::Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_key_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_key_event(::Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_key_event_client_stub.call_rpc_count
    end
  end

  def test_list_key_events
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListKeyEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_key_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_key_events, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListKeyEventsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_key_events_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_key_events({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_key_events parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_key_events ::Google::Analytics::Admin::V1alpha::ListKeyEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_key_events({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_key_events(::Google::Analytics::Admin::V1alpha::ListKeyEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_key_events_client_stub.call_rpc_count
    end
  end

  def test_get_display_video360_advertiser_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_display_video360_advertiser_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_display_video360_advertiser_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_display_video360_advertiser_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_display_video360_advertiser_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_display_video360_advertiser_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_display_video360_advertiser_link ::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_display_video360_advertiser_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_display_video360_advertiser_link(::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_display_video360_advertiser_link_client_stub.call_rpc_count
    end
  end

  def test_list_display_video360_advertiser_links
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_display_video360_advertiser_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_display_video360_advertiser_links, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_display_video360_advertiser_links_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_display_video360_advertiser_links({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_display_video360_advertiser_links parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_display_video360_advertiser_links ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_display_video360_advertiser_links({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_display_video360_advertiser_links(::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_display_video360_advertiser_links_client_stub.call_rpc_count
    end
  end

  def test_create_display_video360_advertiser_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    display_video_360_advertiser_link = {}

    create_display_video360_advertiser_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_display_video360_advertiser_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink), request["display_video_360_advertiser_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_display_video360_advertiser_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_display_video360_advertiser_link({ parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_display_video360_advertiser_link parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_display_video360_advertiser_link ::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest.new(parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_display_video360_advertiser_link({ parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_display_video360_advertiser_link(::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest.new(parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_display_video360_advertiser_link_client_stub.call_rpc_count
    end
  end

  def test_delete_display_video360_advertiser_link
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_display_video360_advertiser_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_display_video360_advertiser_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_display_video360_advertiser_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_display_video360_advertiser_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_display_video360_advertiser_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_display_video360_advertiser_link ::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_display_video360_advertiser_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_display_video360_advertiser_link(::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_display_video360_advertiser_link_client_stub.call_rpc_count
    end
  end

  def test_update_display_video360_advertiser_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    display_video_360_advertiser_link = {}
    update_mask = {}

    update_display_video360_advertiser_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_display_video360_advertiser_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink), request["display_video_360_advertiser_link"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_display_video360_advertiser_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_display_video360_advertiser_link({ display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_display_video360_advertiser_link display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_display_video360_advertiser_link ::Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest.new(display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_display_video360_advertiser_link({ display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_display_video360_advertiser_link(::Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest.new(display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_display_video360_advertiser_link_client_stub.call_rpc_count
    end
  end

  def test_get_display_video360_advertiser_link_proposal
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_display_video360_advertiser_link_proposal_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_display_video360_advertiser_link_proposal, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_display_video360_advertiser_link_proposal_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_display_video360_advertiser_link_proposal({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_display_video360_advertiser_link_proposal name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_display_video360_advertiser_link_proposal({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_display_video360_advertiser_link_proposal_client_stub.call_rpc_count
    end
  end

  def test_list_display_video360_advertiser_link_proposals
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_display_video360_advertiser_link_proposals_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_display_video360_advertiser_link_proposals, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_display_video360_advertiser_link_proposals_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_display_video360_advertiser_link_proposals({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_display_video360_advertiser_link_proposals parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_display_video360_advertiser_link_proposals ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_display_video360_advertiser_link_proposals({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_display_video360_advertiser_link_proposals(::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_display_video360_advertiser_link_proposals_client_stub.call_rpc_count
    end
  end

  def test_create_display_video360_advertiser_link_proposal
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    display_video_360_advertiser_link_proposal = {}

    create_display_video360_advertiser_link_proposal_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_display_video360_advertiser_link_proposal, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal), request["display_video_360_advertiser_link_proposal"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_display_video360_advertiser_link_proposal_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_display_video360_advertiser_link_proposal({ parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_display_video360_advertiser_link_proposal parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest.new(parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_display_video360_advertiser_link_proposal({ parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest.new(parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_display_video360_advertiser_link_proposal_client_stub.call_rpc_count
    end
  end

  def test_delete_display_video360_advertiser_link_proposal
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_display_video360_advertiser_link_proposal_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_display_video360_advertiser_link_proposal, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_display_video360_advertiser_link_proposal_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_display_video360_advertiser_link_proposal({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_display_video360_advertiser_link_proposal name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_display_video360_advertiser_link_proposal({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_display_video360_advertiser_link_proposal_client_stub.call_rpc_count
    end
  end

  def test_approve_display_video360_advertiser_link_proposal
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    approve_display_video360_advertiser_link_proposal_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :approve_display_video360_advertiser_link_proposal, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, approve_display_video360_advertiser_link_proposal_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.approve_display_video360_advertiser_link_proposal({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.approve_display_video360_advertiser_link_proposal name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.approve_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.approve_display_video360_advertiser_link_proposal({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.approve_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, approve_display_video360_advertiser_link_proposal_client_stub.call_rpc_count
    end
  end

  def test_cancel_display_video360_advertiser_link_proposal
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_display_video360_advertiser_link_proposal_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_display_video360_advertiser_link_proposal, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_display_video360_advertiser_link_proposal_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_display_video360_advertiser_link_proposal({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_display_video360_advertiser_link_proposal name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_display_video360_advertiser_link_proposal({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_display_video360_advertiser_link_proposal_client_stub.call_rpc_count
    end
  end

  def test_create_custom_dimension
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CustomDimension.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_dimension = {}

    create_custom_dimension_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_custom_dimension, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::CustomDimension), request["custom_dimension"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_custom_dimension_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_custom_dimension({ parent: parent, custom_dimension: custom_dimension }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_custom_dimension parent: parent, custom_dimension: custom_dimension do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_custom_dimension ::Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest.new(parent: parent, custom_dimension: custom_dimension) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_custom_dimension({ parent: parent, custom_dimension: custom_dimension }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_custom_dimension(::Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest.new(parent: parent, custom_dimension: custom_dimension), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_custom_dimension_client_stub.call_rpc_count
    end
  end

  def test_update_custom_dimension
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CustomDimension.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    custom_dimension = {}
    update_mask = {}

    update_custom_dimension_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_custom_dimension, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::CustomDimension), request["custom_dimension"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_custom_dimension_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_custom_dimension({ custom_dimension: custom_dimension, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_custom_dimension custom_dimension: custom_dimension, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_custom_dimension ::Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest.new(custom_dimension: custom_dimension, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_custom_dimension({ custom_dimension: custom_dimension, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_custom_dimension(::Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest.new(custom_dimension: custom_dimension, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_custom_dimension_client_stub.call_rpc_count
    end
  end

  def test_list_custom_dimensions
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListCustomDimensionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_custom_dimensions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_custom_dimensions, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_custom_dimensions_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_custom_dimensions({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_custom_dimensions parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_custom_dimensions ::Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_custom_dimensions({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_custom_dimensions(::Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_custom_dimensions_client_stub.call_rpc_count
    end
  end

  def test_archive_custom_dimension
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    archive_custom_dimension_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :archive_custom_dimension, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, archive_custom_dimension_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.archive_custom_dimension({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.archive_custom_dimension name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.archive_custom_dimension ::Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.archive_custom_dimension({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.archive_custom_dimension(::Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, archive_custom_dimension_client_stub.call_rpc_count
    end
  end

  def test_get_custom_dimension
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CustomDimension.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_dimension_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_custom_dimension, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_custom_dimension_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_custom_dimension({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_custom_dimension name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_custom_dimension ::Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_custom_dimension({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_custom_dimension(::Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_custom_dimension_client_stub.call_rpc_count
    end
  end

  def test_create_custom_metric
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CustomMetric.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_metric = {}

    create_custom_metric_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_custom_metric, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::CustomMetric), request["custom_metric"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_custom_metric_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_custom_metric({ parent: parent, custom_metric: custom_metric }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_custom_metric parent: parent, custom_metric: custom_metric do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_custom_metric ::Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest.new(parent: parent, custom_metric: custom_metric) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_custom_metric({ parent: parent, custom_metric: custom_metric }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_custom_metric(::Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest.new(parent: parent, custom_metric: custom_metric), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_custom_metric_client_stub.call_rpc_count
    end
  end

  def test_update_custom_metric
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CustomMetric.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    custom_metric = {}
    update_mask = {}

    update_custom_metric_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_custom_metric, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::CustomMetric), request["custom_metric"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_custom_metric_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_custom_metric({ custom_metric: custom_metric, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_custom_metric custom_metric: custom_metric, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_custom_metric ::Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest.new(custom_metric: custom_metric, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_custom_metric({ custom_metric: custom_metric, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_custom_metric(::Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest.new(custom_metric: custom_metric, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_custom_metric_client_stub.call_rpc_count
    end
  end

  def test_list_custom_metrics
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListCustomMetricsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_custom_metrics_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_custom_metrics, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_custom_metrics_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_custom_metrics({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_custom_metrics parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_custom_metrics ::Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_custom_metrics({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_custom_metrics(::Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_custom_metrics_client_stub.call_rpc_count
    end
  end

  def test_archive_custom_metric
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    archive_custom_metric_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :archive_custom_metric, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, archive_custom_metric_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.archive_custom_metric({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.archive_custom_metric name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.archive_custom_metric ::Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.archive_custom_metric({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.archive_custom_metric(::Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, archive_custom_metric_client_stub.call_rpc_count
    end
  end

  def test_get_custom_metric
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CustomMetric.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_metric_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_custom_metric, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetCustomMetricRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_custom_metric_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_custom_metric({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_custom_metric name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_custom_metric ::Google::Analytics::Admin::V1alpha::GetCustomMetricRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_custom_metric({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_custom_metric(::Google::Analytics::Admin::V1alpha::GetCustomMetricRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_custom_metric_client_stub.call_rpc_count
    end
  end

  def test_get_data_retention_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DataRetentionSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_retention_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_retention_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_retention_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_retention_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_retention_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_retention_settings ::Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_retention_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_retention_settings(::Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_retention_settings_client_stub.call_rpc_count
    end
  end

  def test_update_data_retention_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DataRetentionSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    data_retention_settings = {}
    update_mask = {}

    update_data_retention_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_retention_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::DataRetentionSettings), request["data_retention_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_retention_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_retention_settings({ data_retention_settings: data_retention_settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_retention_settings data_retention_settings: data_retention_settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_retention_settings ::Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest.new(data_retention_settings: data_retention_settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_retention_settings({ data_retention_settings: data_retention_settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_retention_settings(::Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest.new(data_retention_settings: data_retention_settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_retention_settings_client_stub.call_rpc_count
    end
  end

  def test_create_data_stream
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DataStream.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_stream = {}

    create_data_stream_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_stream, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateDataStreamRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::DataStream), request["data_stream"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_stream_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_stream({ parent: parent, data_stream: data_stream }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_stream parent: parent, data_stream: data_stream do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_stream ::Google::Analytics::Admin::V1alpha::CreateDataStreamRequest.new(parent: parent, data_stream: data_stream) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_stream({ parent: parent, data_stream: data_stream }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_stream(::Google::Analytics::Admin::V1alpha::CreateDataStreamRequest.new(parent: parent, data_stream: data_stream), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_stream_client_stub.call_rpc_count
    end
  end

  def test_delete_data_stream
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_stream_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_stream, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_stream_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_stream({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_stream name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_stream ::Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_stream({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_stream(::Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_stream_client_stub.call_rpc_count
    end
  end

  def test_update_data_stream
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DataStream.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    data_stream = {}
    update_mask = {}

    update_data_stream_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_stream, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::DataStream), request["data_stream"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_stream_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_stream({ data_stream: data_stream, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_stream data_stream: data_stream, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_stream ::Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest.new(data_stream: data_stream, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_stream({ data_stream: data_stream, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_stream(::Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest.new(data_stream: data_stream, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_stream_client_stub.call_rpc_count
    end
  end

  def test_list_data_streams
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListDataStreamsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_data_streams_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_streams, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListDataStreamsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_streams_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_streams({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_streams parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_streams ::Google::Analytics::Admin::V1alpha::ListDataStreamsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_streams({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_streams(::Google::Analytics::Admin::V1alpha::ListDataStreamsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_streams_client_stub.call_rpc_count
    end
  end

  def test_get_data_stream
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DataStream.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_stream_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_stream, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetDataStreamRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_stream_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_stream({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_stream name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_stream ::Google::Analytics::Admin::V1alpha::GetDataStreamRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_stream({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_stream(::Google::Analytics::Admin::V1alpha::GetDataStreamRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_stream_client_stub.call_rpc_count
    end
  end

  def test_get_audience
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Audience.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_audience_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_audience, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetAudienceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_audience_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_audience({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_audience name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_audience ::Google::Analytics::Admin::V1alpha::GetAudienceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_audience({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_audience(::Google::Analytics::Admin::V1alpha::GetAudienceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_audience_client_stub.call_rpc_count
    end
  end

  def test_list_audiences
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListAudiencesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_audiences_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_audiences, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListAudiencesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_audiences_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_audiences({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_audiences parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_audiences ::Google::Analytics::Admin::V1alpha::ListAudiencesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_audiences({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_audiences(::Google::Analytics::Admin::V1alpha::ListAudiencesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_audiences_client_stub.call_rpc_count
    end
  end

  def test_create_audience
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Audience.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    audience = {}

    create_audience_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_audience, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateAudienceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::Audience), request["audience"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_audience_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_audience({ parent: parent, audience: audience }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_audience parent: parent, audience: audience do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_audience ::Google::Analytics::Admin::V1alpha::CreateAudienceRequest.new(parent: parent, audience: audience) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_audience({ parent: parent, audience: audience }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_audience(::Google::Analytics::Admin::V1alpha::CreateAudienceRequest.new(parent: parent, audience: audience), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_audience_client_stub.call_rpc_count
    end
  end

  def test_update_audience
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::Audience.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    audience = {}
    update_mask = {}

    update_audience_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_audience, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateAudienceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::Audience), request["audience"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_audience_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_audience({ audience: audience, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_audience audience: audience, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_audience ::Google::Analytics::Admin::V1alpha::UpdateAudienceRequest.new(audience: audience, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_audience({ audience: audience, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_audience(::Google::Analytics::Admin::V1alpha::UpdateAudienceRequest.new(audience: audience, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_audience_client_stub.call_rpc_count
    end
  end

  def test_archive_audience
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    archive_audience_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :archive_audience, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, archive_audience_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.archive_audience({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.archive_audience name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.archive_audience ::Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.archive_audience({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.archive_audience(::Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, archive_audience_client_stub.call_rpc_count
    end
  end

  def test_get_search_ads360_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SearchAds360Link.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_search_ads360_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_search_ads360_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_search_ads360_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_search_ads360_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_search_ads360_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_search_ads360_link ::Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_search_ads360_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_search_ads360_link(::Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_search_ads360_link_client_stub.call_rpc_count
    end
  end

  def test_list_search_ads360_links
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_search_ads360_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_search_ads360_links, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_search_ads360_links_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_search_ads360_links({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_search_ads360_links parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_search_ads360_links ::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_search_ads360_links({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_search_ads360_links(::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_search_ads360_links_client_stub.call_rpc_count
    end
  end

  def test_create_search_ads360_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SearchAds360Link.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    search_ads_360_link = {}

    create_search_ads360_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_search_ads360_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::SearchAds360Link), request["search_ads_360_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_search_ads360_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_search_ads360_link({ parent: parent, search_ads_360_link: search_ads_360_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_search_ads360_link parent: parent, search_ads_360_link: search_ads_360_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_search_ads360_link ::Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest.new(parent: parent, search_ads_360_link: search_ads_360_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_search_ads360_link({ parent: parent, search_ads_360_link: search_ads_360_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_search_ads360_link(::Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest.new(parent: parent, search_ads_360_link: search_ads_360_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_search_ads360_link_client_stub.call_rpc_count
    end
  end

  def test_delete_search_ads360_link
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_search_ads360_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_search_ads360_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_search_ads360_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_search_ads360_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_search_ads360_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_search_ads360_link ::Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_search_ads360_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_search_ads360_link(::Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_search_ads360_link_client_stub.call_rpc_count
    end
  end

  def test_update_search_ads360_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SearchAds360Link.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    search_ads_360_link = {}
    update_mask = {}

    update_search_ads360_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_search_ads360_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::SearchAds360Link), request["search_ads_360_link"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_search_ads360_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_search_ads360_link({ search_ads_360_link: search_ads_360_link, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_search_ads360_link search_ads_360_link: search_ads_360_link, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_search_ads360_link ::Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest.new(search_ads_360_link: search_ads_360_link, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_search_ads360_link({ search_ads_360_link: search_ads_360_link, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_search_ads360_link(::Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest.new(search_ads_360_link: search_ads_360_link, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_search_ads360_link_client_stub.call_rpc_count
    end
  end

  def test_get_attribution_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::AttributionSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attribution_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_attribution_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_attribution_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_attribution_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_attribution_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_attribution_settings ::Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_attribution_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_attribution_settings(::Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_attribution_settings_client_stub.call_rpc_count
    end
  end

  def test_update_attribution_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::AttributionSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    attribution_settings = {}
    update_mask = {}

    update_attribution_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_attribution_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::AttributionSettings), request["attribution_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_attribution_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_attribution_settings({ attribution_settings: attribution_settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_attribution_settings attribution_settings: attribution_settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_attribution_settings ::Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest.new(attribution_settings: attribution_settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_attribution_settings({ attribution_settings: attribution_settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_attribution_settings(::Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest.new(attribution_settings: attribution_settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_attribution_settings_client_stub.call_rpc_count
    end
  end

  def test_run_access_report
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::RunAccessReportResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    entity = "hello world"
    dimensions = [{}]
    metrics = [{}]
    date_ranges = [{}]
    dimension_filter = {}
    metric_filter = {}
    offset = 42
    limit = 42
    time_zone = "hello world"
    order_bys = [{}]
    return_entity_quota = true
    include_all_users = true
    expand_groups = true

    run_access_report_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :run_access_report, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::RunAccessReportRequest, request
      assert_equal "hello world", request["entity"]
      assert_kind_of ::Google::Analytics::Admin::V1alpha::AccessDimension, request["dimensions"].first
      assert_kind_of ::Google::Analytics::Admin::V1alpha::AccessMetric, request["metrics"].first
      assert_kind_of ::Google::Analytics::Admin::V1alpha::AccessDateRange, request["date_ranges"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::AccessFilterExpression), request["dimension_filter"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::AccessFilterExpression), request["metric_filter"]
      assert_equal 42, request["offset"]
      assert_equal 42, request["limit"]
      assert_equal "hello world", request["time_zone"]
      assert_kind_of ::Google::Analytics::Admin::V1alpha::AccessOrderBy, request["order_bys"].first
      assert_equal true, request["return_entity_quota"]
      assert_equal true, request["include_all_users"]
      assert_equal true, request["expand_groups"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_access_report_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_access_report({ entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_access_report entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_access_report ::Google::Analytics::Admin::V1alpha::RunAccessReportRequest.new(entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_access_report({ entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_access_report(::Google::Analytics::Admin::V1alpha::RunAccessReportRequest.new(entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_access_report_client_stub.call_rpc_count
    end
  end

  def test_create_access_binding
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::AccessBinding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    access_binding = {}

    create_access_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_access_binding, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::AccessBinding), request["access_binding"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_access_binding_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_access_binding({ parent: parent, access_binding: access_binding }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_access_binding parent: parent, access_binding: access_binding do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_access_binding ::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest.new(parent: parent, access_binding: access_binding) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_access_binding({ parent: parent, access_binding: access_binding }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_access_binding(::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest.new(parent: parent, access_binding: access_binding), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_access_binding_client_stub.call_rpc_count
    end
  end

  def test_get_access_binding
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::AccessBinding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_access_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_access_binding, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetAccessBindingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_access_binding_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_access_binding({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_access_binding name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_access_binding ::Google::Analytics::Admin::V1alpha::GetAccessBindingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_access_binding({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_access_binding(::Google::Analytics::Admin::V1alpha::GetAccessBindingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_access_binding_client_stub.call_rpc_count
    end
  end

  def test_update_access_binding
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::AccessBinding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    access_binding = {}

    update_access_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_access_binding, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::AccessBinding), request["access_binding"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_access_binding_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_access_binding({ access_binding: access_binding }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_access_binding access_binding: access_binding do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_access_binding ::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest.new(access_binding: access_binding) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_access_binding({ access_binding: access_binding }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_access_binding(::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest.new(access_binding: access_binding), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_access_binding_client_stub.call_rpc_count
    end
  end

  def test_delete_access_binding
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_access_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_access_binding, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_access_binding_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_access_binding({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_access_binding name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_access_binding ::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_access_binding({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_access_binding(::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_access_binding_client_stub.call_rpc_count
    end
  end

  def test_list_access_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListAccessBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_access_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_access_bindings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_access_bindings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_access_bindings({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_access_bindings parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_access_bindings ::Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_access_bindings({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_access_bindings(::Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_access_bindings_client_stub.call_rpc_count
    end
  end

  def test_batch_create_access_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_access_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_access_bindings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_access_bindings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_access_bindings({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_access_bindings parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_access_bindings ::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_access_bindings({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_access_bindings(::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_access_bindings_client_stub.call_rpc_count
    end
  end

  def test_batch_get_access_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]

    batch_get_access_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_get_access_bindings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["names"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_get_access_bindings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_get_access_bindings({ parent: parent, names: names }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_get_access_bindings parent: parent, names: names do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_get_access_bindings ::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest.new(parent: parent, names: names) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_get_access_bindings({ parent: parent, names: names }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_get_access_bindings(::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest.new(parent: parent, names: names), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_get_access_bindings_client_stub.call_rpc_count
    end
  end

  def test_batch_update_access_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_update_access_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_update_access_bindings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_update_access_bindings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_update_access_bindings({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_update_access_bindings parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_update_access_bindings ::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_update_access_bindings({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_update_access_bindings(::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_update_access_bindings_client_stub.call_rpc_count
    end
  end

  def test_batch_delete_access_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_delete_access_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_delete_access_bindings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_delete_access_bindings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_delete_access_bindings({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_delete_access_bindings parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_delete_access_bindings ::Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_delete_access_bindings({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_delete_access_bindings(::Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_delete_access_bindings_client_stub.call_rpc_count
    end
  end

  def test_get_expanded_data_set
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ExpandedDataSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_expanded_data_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_expanded_data_set, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_expanded_data_set_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_expanded_data_set({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_expanded_data_set name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_expanded_data_set ::Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_expanded_data_set({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_expanded_data_set(::Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_expanded_data_set_client_stub.call_rpc_count
    end
  end

  def test_list_expanded_data_sets
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_expanded_data_sets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_expanded_data_sets, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_expanded_data_sets_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_expanded_data_sets({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_expanded_data_sets parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_expanded_data_sets ::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_expanded_data_sets({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_expanded_data_sets(::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_expanded_data_sets_client_stub.call_rpc_count
    end
  end

  def test_create_expanded_data_set
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ExpandedDataSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    expanded_data_set = {}

    create_expanded_data_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_expanded_data_set, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::ExpandedDataSet), request["expanded_data_set"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_expanded_data_set_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_expanded_data_set({ parent: parent, expanded_data_set: expanded_data_set }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_expanded_data_set parent: parent, expanded_data_set: expanded_data_set do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_expanded_data_set ::Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest.new(parent: parent, expanded_data_set: expanded_data_set) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_expanded_data_set({ parent: parent, expanded_data_set: expanded_data_set }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_expanded_data_set(::Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest.new(parent: parent, expanded_data_set: expanded_data_set), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_expanded_data_set_client_stub.call_rpc_count
    end
  end

  def test_update_expanded_data_set
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ExpandedDataSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    expanded_data_set = {}
    update_mask = {}

    update_expanded_data_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_expanded_data_set, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::ExpandedDataSet), request["expanded_data_set"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_expanded_data_set_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_expanded_data_set({ expanded_data_set: expanded_data_set, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_expanded_data_set expanded_data_set: expanded_data_set, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_expanded_data_set ::Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest.new(expanded_data_set: expanded_data_set, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_expanded_data_set({ expanded_data_set: expanded_data_set, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_expanded_data_set(::Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest.new(expanded_data_set: expanded_data_set, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_expanded_data_set_client_stub.call_rpc_count
    end
  end

  def test_delete_expanded_data_set
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_expanded_data_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_expanded_data_set, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_expanded_data_set_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_expanded_data_set({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_expanded_data_set name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_expanded_data_set ::Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_expanded_data_set({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_expanded_data_set(::Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_expanded_data_set_client_stub.call_rpc_count
    end
  end

  def test_get_channel_group
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ChannelGroup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_channel_group, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetChannelGroupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_channel_group_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_channel_group({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_channel_group name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_channel_group ::Google::Analytics::Admin::V1alpha::GetChannelGroupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_channel_group({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_channel_group(::Google::Analytics::Admin::V1alpha::GetChannelGroupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_channel_group_client_stub.call_rpc_count
    end
  end

  def test_list_channel_groups
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListChannelGroupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_channel_groups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_channel_groups, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_channel_groups_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_channel_groups({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_channel_groups parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_channel_groups ::Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_channel_groups({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_channel_groups(::Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_channel_groups_client_stub.call_rpc_count
    end
  end

  def test_create_channel_group
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ChannelGroup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel_group = {}

    create_channel_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_channel_group, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::ChannelGroup), request["channel_group"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_channel_group_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_channel_group({ parent: parent, channel_group: channel_group }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_channel_group parent: parent, channel_group: channel_group do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_channel_group ::Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest.new(parent: parent, channel_group: channel_group) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_channel_group({ parent: parent, channel_group: channel_group }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_channel_group(::Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest.new(parent: parent, channel_group: channel_group), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_channel_group_client_stub.call_rpc_count
    end
  end

  def test_update_channel_group
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ChannelGroup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    channel_group = {}
    update_mask = {}

    update_channel_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_channel_group, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::ChannelGroup), request["channel_group"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_channel_group_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_channel_group({ channel_group: channel_group, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_channel_group channel_group: channel_group, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_channel_group ::Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest.new(channel_group: channel_group, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_channel_group({ channel_group: channel_group, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_channel_group(::Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest.new(channel_group: channel_group, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_channel_group_client_stub.call_rpc_count
    end
  end

  def test_delete_channel_group
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_channel_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_channel_group, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_channel_group_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_channel_group({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_channel_group name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_channel_group ::Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_channel_group({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_channel_group(::Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_channel_group_client_stub.call_rpc_count
    end
  end

  def test_create_big_query_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::BigQueryLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    bigquery_link = {}

    create_big_query_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_big_query_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::BigQueryLink), request["bigquery_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_big_query_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_big_query_link({ parent: parent, bigquery_link: bigquery_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_big_query_link parent: parent, bigquery_link: bigquery_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_big_query_link ::Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest.new(parent: parent, bigquery_link: bigquery_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_big_query_link({ parent: parent, bigquery_link: bigquery_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_big_query_link(::Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest.new(parent: parent, bigquery_link: bigquery_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_big_query_link_client_stub.call_rpc_count
    end
  end

  def test_get_big_query_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::BigQueryLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_big_query_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_big_query_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_big_query_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_big_query_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_big_query_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_big_query_link ::Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_big_query_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_big_query_link(::Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_big_query_link_client_stub.call_rpc_count
    end
  end

  def test_list_big_query_links
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListBigQueryLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_big_query_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_big_query_links, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_big_query_links_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_big_query_links({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_big_query_links parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_big_query_links ::Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_big_query_links({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_big_query_links(::Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_big_query_links_client_stub.call_rpc_count
    end
  end

  def test_delete_big_query_link
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_big_query_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_big_query_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_big_query_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_big_query_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_big_query_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_big_query_link ::Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_big_query_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_big_query_link(::Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_big_query_link_client_stub.call_rpc_count
    end
  end

  def test_update_big_query_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::BigQueryLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    bigquery_link = {}
    update_mask = {}

    update_big_query_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_big_query_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::BigQueryLink), request["bigquery_link"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_big_query_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_big_query_link({ bigquery_link: bigquery_link, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_big_query_link bigquery_link: bigquery_link, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_big_query_link ::Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest.new(bigquery_link: bigquery_link, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_big_query_link({ bigquery_link: bigquery_link, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_big_query_link(::Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest.new(bigquery_link: bigquery_link, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_big_query_link_client_stub.call_rpc_count
    end
  end

  def test_get_enhanced_measurement_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_enhanced_measurement_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_enhanced_measurement_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_enhanced_measurement_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_enhanced_measurement_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_enhanced_measurement_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_enhanced_measurement_settings ::Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_enhanced_measurement_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_enhanced_measurement_settings(::Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_enhanced_measurement_settings_client_stub.call_rpc_count
    end
  end

  def test_update_enhanced_measurement_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    enhanced_measurement_settings = {}
    update_mask = {}

    update_enhanced_measurement_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_enhanced_measurement_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings), request["enhanced_measurement_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_enhanced_measurement_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_enhanced_measurement_settings({ enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_enhanced_measurement_settings enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_enhanced_measurement_settings ::Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest.new(enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_enhanced_measurement_settings({ enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_enhanced_measurement_settings(::Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest.new(enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_enhanced_measurement_settings_client_stub.call_rpc_count
    end
  end

  def test_get_ad_sense_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::AdSenseLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ad_sense_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_ad_sense_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_ad_sense_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_ad_sense_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_ad_sense_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_ad_sense_link ::Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_ad_sense_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_ad_sense_link(::Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_ad_sense_link_client_stub.call_rpc_count
    end
  end

  def test_create_ad_sense_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::AdSenseLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    adsense_link = {}

    create_ad_sense_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_ad_sense_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::AdSenseLink), request["adsense_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_ad_sense_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_ad_sense_link({ parent: parent, adsense_link: adsense_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_ad_sense_link parent: parent, adsense_link: adsense_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_ad_sense_link ::Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest.new(parent: parent, adsense_link: adsense_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_ad_sense_link({ parent: parent, adsense_link: adsense_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_ad_sense_link(::Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest.new(parent: parent, adsense_link: adsense_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_ad_sense_link_client_stub.call_rpc_count
    end
  end

  def test_delete_ad_sense_link
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_ad_sense_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_ad_sense_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_ad_sense_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_ad_sense_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_ad_sense_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_ad_sense_link ::Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_ad_sense_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_ad_sense_link(::Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_ad_sense_link_client_stub.call_rpc_count
    end
  end

  def test_list_ad_sense_links
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListAdSenseLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_ad_sense_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_ad_sense_links, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_ad_sense_links_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_ad_sense_links({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_ad_sense_links parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_ad_sense_links ::Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_ad_sense_links({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_ad_sense_links(::Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_ad_sense_links_client_stub.call_rpc_count
    end
  end

  def test_get_event_create_rule
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::EventCreateRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_create_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_event_create_rule, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_event_create_rule_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_event_create_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_event_create_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_event_create_rule ::Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_event_create_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_event_create_rule(::Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_event_create_rule_client_stub.call_rpc_count
    end
  end

  def test_list_event_create_rules
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListEventCreateRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_event_create_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_event_create_rules, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_event_create_rules_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_event_create_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_event_create_rules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_event_create_rules ::Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_event_create_rules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_event_create_rules(::Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_event_create_rules_client_stub.call_rpc_count
    end
  end

  def test_create_event_create_rule
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::EventCreateRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_create_rule = {}

    create_event_create_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_event_create_rule, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::EventCreateRule), request["event_create_rule"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_event_create_rule_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_event_create_rule({ parent: parent, event_create_rule: event_create_rule }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_event_create_rule parent: parent, event_create_rule: event_create_rule do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_event_create_rule ::Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest.new(parent: parent, event_create_rule: event_create_rule) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_event_create_rule({ parent: parent, event_create_rule: event_create_rule }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_event_create_rule(::Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest.new(parent: parent, event_create_rule: event_create_rule), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_event_create_rule_client_stub.call_rpc_count
    end
  end

  def test_update_event_create_rule
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::EventCreateRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    event_create_rule = {}
    update_mask = {}

    update_event_create_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_event_create_rule, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::EventCreateRule), request["event_create_rule"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_event_create_rule_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_event_create_rule({ event_create_rule: event_create_rule, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_event_create_rule event_create_rule: event_create_rule, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_event_create_rule ::Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest.new(event_create_rule: event_create_rule, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_event_create_rule({ event_create_rule: event_create_rule, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_event_create_rule(::Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest.new(event_create_rule: event_create_rule, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_event_create_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_event_create_rule
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_event_create_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_event_create_rule, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_event_create_rule_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_event_create_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_event_create_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_event_create_rule ::Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_event_create_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_event_create_rule(::Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_event_create_rule_client_stub.call_rpc_count
    end
  end

  def test_get_event_edit_rule
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::EventEditRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_edit_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_event_edit_rule, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_event_edit_rule_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_event_edit_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_event_edit_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_event_edit_rule ::Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_event_edit_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_event_edit_rule(::Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_event_edit_rule_client_stub.call_rpc_count
    end
  end

  def test_list_event_edit_rules
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListEventEditRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_event_edit_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_event_edit_rules, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_event_edit_rules_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_event_edit_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_event_edit_rules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_event_edit_rules ::Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_event_edit_rules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_event_edit_rules(::Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_event_edit_rules_client_stub.call_rpc_count
    end
  end

  def test_create_event_edit_rule
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::EventEditRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_edit_rule = {}

    create_event_edit_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_event_edit_rule, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::EventEditRule), request["event_edit_rule"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_event_edit_rule_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_event_edit_rule({ parent: parent, event_edit_rule: event_edit_rule }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_event_edit_rule parent: parent, event_edit_rule: event_edit_rule do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_event_edit_rule ::Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest.new(parent: parent, event_edit_rule: event_edit_rule) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_event_edit_rule({ parent: parent, event_edit_rule: event_edit_rule }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_event_edit_rule(::Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest.new(parent: parent, event_edit_rule: event_edit_rule), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_event_edit_rule_client_stub.call_rpc_count
    end
  end

  def test_update_event_edit_rule
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::EventEditRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    event_edit_rule = {}
    update_mask = {}

    update_event_edit_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_event_edit_rule, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::EventEditRule), request["event_edit_rule"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_event_edit_rule_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_event_edit_rule({ event_edit_rule: event_edit_rule, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_event_edit_rule event_edit_rule: event_edit_rule, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_event_edit_rule ::Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest.new(event_edit_rule: event_edit_rule, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_event_edit_rule({ event_edit_rule: event_edit_rule, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_event_edit_rule(::Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest.new(event_edit_rule: event_edit_rule, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_event_edit_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_event_edit_rule
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_event_edit_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_event_edit_rule, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_event_edit_rule_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_event_edit_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_event_edit_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_event_edit_rule ::Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_event_edit_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_event_edit_rule(::Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_event_edit_rule_client_stub.call_rpc_count
    end
  end

  def test_reorder_event_edit_rules
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_edit_rules = ["hello world"]

    reorder_event_edit_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reorder_event_edit_rules, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["event_edit_rules"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reorder_event_edit_rules_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reorder_event_edit_rules({ parent: parent, event_edit_rules: event_edit_rules }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reorder_event_edit_rules parent: parent, event_edit_rules: event_edit_rules do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reorder_event_edit_rules ::Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest.new(parent: parent, event_edit_rules: event_edit_rules) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reorder_event_edit_rules({ parent: parent, event_edit_rules: event_edit_rules }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reorder_event_edit_rules(::Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest.new(parent: parent, event_edit_rules: event_edit_rules), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reorder_event_edit_rules_client_stub.call_rpc_count
    end
  end

  def test_update_data_redaction_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DataRedactionSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    data_redaction_settings = {}
    update_mask = {}

    update_data_redaction_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_redaction_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::DataRedactionSettings), request["data_redaction_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_redaction_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_redaction_settings({ data_redaction_settings: data_redaction_settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_redaction_settings data_redaction_settings: data_redaction_settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_redaction_settings ::Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest.new(data_redaction_settings: data_redaction_settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_redaction_settings({ data_redaction_settings: data_redaction_settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_redaction_settings(::Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest.new(data_redaction_settings: data_redaction_settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_redaction_settings_client_stub.call_rpc_count
    end
  end

  def test_get_data_redaction_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::DataRedactionSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_redaction_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_redaction_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_redaction_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_redaction_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_redaction_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_redaction_settings ::Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_redaction_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_redaction_settings(::Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_redaction_settings_client_stub.call_rpc_count
    end
  end

  def test_get_calculated_metric
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CalculatedMetric.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_calculated_metric_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_calculated_metric, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_calculated_metric_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_calculated_metric({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_calculated_metric name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_calculated_metric ::Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_calculated_metric({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_calculated_metric(::Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_calculated_metric_client_stub.call_rpc_count
    end
  end

  def test_create_calculated_metric
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CalculatedMetric.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    calculated_metric_id = "hello world"
    calculated_metric = {}

    create_calculated_metric_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_calculated_metric, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["calculated_metric_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::CalculatedMetric), request["calculated_metric"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_calculated_metric_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_calculated_metric({ parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_calculated_metric parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_calculated_metric ::Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest.new(parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_calculated_metric({ parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_calculated_metric(::Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest.new(parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_calculated_metric_client_stub.call_rpc_count
    end
  end

  def test_list_calculated_metrics
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_calculated_metrics_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_calculated_metrics, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_calculated_metrics_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_calculated_metrics({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_calculated_metrics parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_calculated_metrics ::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_calculated_metrics({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_calculated_metrics(::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_calculated_metrics_client_stub.call_rpc_count
    end
  end

  def test_update_calculated_metric
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CalculatedMetric.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    calculated_metric = {}
    update_mask = {}

    update_calculated_metric_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_calculated_metric, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::CalculatedMetric), request["calculated_metric"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_calculated_metric_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_calculated_metric({ calculated_metric: calculated_metric, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_calculated_metric calculated_metric: calculated_metric, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_calculated_metric ::Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest.new(calculated_metric: calculated_metric, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_calculated_metric({ calculated_metric: calculated_metric, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_calculated_metric(::Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest.new(calculated_metric: calculated_metric, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_calculated_metric_client_stub.call_rpc_count
    end
  end

  def test_delete_calculated_metric
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_calculated_metric_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_calculated_metric, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_calculated_metric_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_calculated_metric({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_calculated_metric name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_calculated_metric ::Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_calculated_metric({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_calculated_metric(::Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_calculated_metric_client_stub.call_rpc_count
    end
  end

  def test_create_rollup_property
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::CreateRollupPropertyResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rollup_property = {}
    source_properties = ["hello world"]

    create_rollup_property_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_rollup_property, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::Property), request["rollup_property"]
      assert_equal ["hello world"], request["source_properties"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_rollup_property_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_rollup_property({ rollup_property: rollup_property, source_properties: source_properties }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_rollup_property rollup_property: rollup_property, source_properties: source_properties do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_rollup_property ::Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest.new(rollup_property: rollup_property, source_properties: source_properties) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_rollup_property({ rollup_property: rollup_property, source_properties: source_properties }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_rollup_property(::Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest.new(rollup_property: rollup_property, source_properties: source_properties), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_rollup_property_client_stub.call_rpc_count
    end
  end

  def test_get_rollup_property_source_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollup_property_source_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rollup_property_source_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rollup_property_source_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rollup_property_source_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rollup_property_source_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rollup_property_source_link ::Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rollup_property_source_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rollup_property_source_link(::Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rollup_property_source_link_client_stub.call_rpc_count
    end
  end

  def test_list_rollup_property_source_links
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_rollup_property_source_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rollup_property_source_links, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rollup_property_source_links_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rollup_property_source_links({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rollup_property_source_links parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rollup_property_source_links ::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rollup_property_source_links({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rollup_property_source_links(::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rollup_property_source_links_client_stub.call_rpc_count
    end
  end

  def test_create_rollup_property_source_link
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rollup_property_source_link = {}

    create_rollup_property_source_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_rollup_property_source_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink), request["rollup_property_source_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_rollup_property_source_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_rollup_property_source_link({ parent: parent, rollup_property_source_link: rollup_property_source_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_rollup_property_source_link parent: parent, rollup_property_source_link: rollup_property_source_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_rollup_property_source_link ::Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest.new(parent: parent, rollup_property_source_link: rollup_property_source_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_rollup_property_source_link({ parent: parent, rollup_property_source_link: rollup_property_source_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_rollup_property_source_link(::Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest.new(parent: parent, rollup_property_source_link: rollup_property_source_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_rollup_property_source_link_client_stub.call_rpc_count
    end
  end

  def test_delete_rollup_property_source_link
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_rollup_property_source_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_rollup_property_source_link, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_rollup_property_source_link_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_rollup_property_source_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_rollup_property_source_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_rollup_property_source_link ::Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_rollup_property_source_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_rollup_property_source_link(::Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_rollup_property_source_link_client_stub.call_rpc_count
    end
  end

  def test_provision_subproperty
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subproperty = {}
    subproperty_event_filter = {}
    custom_dimension_and_metric_synchronization_mode = :SYNCHRONIZATION_MODE_UNSPECIFIED

    provision_subproperty_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :provision_subproperty, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::Property), request["subproperty"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter), request["subproperty_event_filter"]
      assert_equal :SYNCHRONIZATION_MODE_UNSPECIFIED, request["custom_dimension_and_metric_synchronization_mode"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, provision_subproperty_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.provision_subproperty({ subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.provision_subproperty subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.provision_subproperty ::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest.new(subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.provision_subproperty({ subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.provision_subproperty(::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest.new(subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, provision_subproperty_client_stub.call_rpc_count
    end
  end

  def test_create_subproperty_event_filter
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subproperty_event_filter = {}

    create_subproperty_event_filter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_subproperty_event_filter, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter), request["subproperty_event_filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_subproperty_event_filter_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_subproperty_event_filter({ parent: parent, subproperty_event_filter: subproperty_event_filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_subproperty_event_filter parent: parent, subproperty_event_filter: subproperty_event_filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_subproperty_event_filter ::Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest.new(parent: parent, subproperty_event_filter: subproperty_event_filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_subproperty_event_filter({ parent: parent, subproperty_event_filter: subproperty_event_filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_subproperty_event_filter(::Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest.new(parent: parent, subproperty_event_filter: subproperty_event_filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_subproperty_event_filter_client_stub.call_rpc_count
    end
  end

  def test_get_subproperty_event_filter
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subproperty_event_filter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_subproperty_event_filter, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_subproperty_event_filter_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_subproperty_event_filter({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_subproperty_event_filter name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_subproperty_event_filter ::Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_subproperty_event_filter({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_subproperty_event_filter(::Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_subproperty_event_filter_client_stub.call_rpc_count
    end
  end

  def test_list_subproperty_event_filters
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subproperty_event_filters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subproperty_event_filters, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subproperty_event_filters_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subproperty_event_filters({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subproperty_event_filters parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subproperty_event_filters ::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subproperty_event_filters({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subproperty_event_filters(::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subproperty_event_filters_client_stub.call_rpc_count
    end
  end

  def test_update_subproperty_event_filter
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subproperty_event_filter = {}
    update_mask = {}

    update_subproperty_event_filter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_subproperty_event_filter, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter), request["subproperty_event_filter"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_subproperty_event_filter_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_subproperty_event_filter({ subproperty_event_filter: subproperty_event_filter, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_subproperty_event_filter subproperty_event_filter: subproperty_event_filter, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_subproperty_event_filter ::Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest.new(subproperty_event_filter: subproperty_event_filter, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_subproperty_event_filter({ subproperty_event_filter: subproperty_event_filter, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_subproperty_event_filter(::Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest.new(subproperty_event_filter: subproperty_event_filter, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_subproperty_event_filter_client_stub.call_rpc_count
    end
  end

  def test_delete_subproperty_event_filter
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_subproperty_event_filter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_subproperty_event_filter, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_subproperty_event_filter_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_subproperty_event_filter({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_subproperty_event_filter name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_subproperty_event_filter ::Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_subproperty_event_filter({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_subproperty_event_filter(::Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_subproperty_event_filter_client_stub.call_rpc_count
    end
  end

  def test_create_reporting_data_annotation
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reporting_data_annotation = {}

    create_reporting_data_annotation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_reporting_data_annotation, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation), request["reporting_data_annotation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_reporting_data_annotation_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_reporting_data_annotation({ parent: parent, reporting_data_annotation: reporting_data_annotation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_reporting_data_annotation parent: parent, reporting_data_annotation: reporting_data_annotation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_reporting_data_annotation ::Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest.new(parent: parent, reporting_data_annotation: reporting_data_annotation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_reporting_data_annotation({ parent: parent, reporting_data_annotation: reporting_data_annotation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_reporting_data_annotation(::Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest.new(parent: parent, reporting_data_annotation: reporting_data_annotation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_reporting_data_annotation_client_stub.call_rpc_count
    end
  end

  def test_get_reporting_data_annotation
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reporting_data_annotation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_reporting_data_annotation, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_reporting_data_annotation_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_reporting_data_annotation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_reporting_data_annotation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_reporting_data_annotation ::Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_reporting_data_annotation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_reporting_data_annotation(::Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_reporting_data_annotation_client_stub.call_rpc_count
    end
  end

  def test_list_reporting_data_annotations
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_reporting_data_annotations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_reporting_data_annotations, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_reporting_data_annotations_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_reporting_data_annotations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_reporting_data_annotations parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_reporting_data_annotations ::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_reporting_data_annotations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_reporting_data_annotations(::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_reporting_data_annotations_client_stub.call_rpc_count
    end
  end

  def test_update_reporting_data_annotation
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    reporting_data_annotation = {}
    update_mask = {}

    update_reporting_data_annotation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_reporting_data_annotation, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation), request["reporting_data_annotation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_reporting_data_annotation_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_reporting_data_annotation({ reporting_data_annotation: reporting_data_annotation, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_reporting_data_annotation reporting_data_annotation: reporting_data_annotation, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_reporting_data_annotation ::Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest.new(reporting_data_annotation: reporting_data_annotation, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_reporting_data_annotation({ reporting_data_annotation: reporting_data_annotation, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_reporting_data_annotation(::Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest.new(reporting_data_annotation: reporting_data_annotation, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_reporting_data_annotation_client_stub.call_rpc_count
    end
  end

  def test_delete_reporting_data_annotation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reporting_data_annotation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_reporting_data_annotation, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_reporting_data_annotation_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_reporting_data_annotation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_reporting_data_annotation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_reporting_data_annotation ::Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_reporting_data_annotation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_reporting_data_annotation(::Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_reporting_data_annotation_client_stub.call_rpc_count
    end
  end

  def test_submit_user_deletion
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SubmitUserDeletionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    user_id = "hello world"
    name = "hello world"

    submit_user_deletion_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :submit_user_deletion, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest, request
      assert_equal "hello world", request["user_id"]
      assert_equal :user_id, request.user
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, submit_user_deletion_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.submit_user_deletion({ user_id: user_id, name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.submit_user_deletion user_id: user_id, name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.submit_user_deletion ::Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest.new(user_id: user_id, name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.submit_user_deletion({ user_id: user_id, name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.submit_user_deletion(::Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest.new(user_id: user_id, name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, submit_user_deletion_client_stub.call_rpc_count
    end
  end

  def test_list_subproperty_sync_configs
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subproperty_sync_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subproperty_sync_configs, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subproperty_sync_configs_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subproperty_sync_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subproperty_sync_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subproperty_sync_configs ::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subproperty_sync_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subproperty_sync_configs(::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subproperty_sync_configs_client_stub.call_rpc_count
    end
  end

  def test_update_subproperty_sync_config
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subproperty_sync_config = {}
    update_mask = {}

    update_subproperty_sync_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_subproperty_sync_config, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig), request["subproperty_sync_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_subproperty_sync_config_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_subproperty_sync_config({ subproperty_sync_config: subproperty_sync_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_subproperty_sync_config subproperty_sync_config: subproperty_sync_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_subproperty_sync_config ::Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest.new(subproperty_sync_config: subproperty_sync_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_subproperty_sync_config({ subproperty_sync_config: subproperty_sync_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_subproperty_sync_config(::Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest.new(subproperty_sync_config: subproperty_sync_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_subproperty_sync_config_client_stub.call_rpc_count
    end
  end

  def test_get_subproperty_sync_config
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subproperty_sync_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_subproperty_sync_config, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_subproperty_sync_config_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_subproperty_sync_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_subproperty_sync_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_subproperty_sync_config ::Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_subproperty_sync_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_subproperty_sync_config(::Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_subproperty_sync_config_client_stub.call_rpc_count
    end
  end

  def test_get_reporting_identity_settings
    # Create GRPC objects.
    grpc_response = ::Google::Analytics::Admin::V1alpha::ReportingIdentitySettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reporting_identity_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_reporting_identity_settings, name
      assert_kind_of ::Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_reporting_identity_settings_client_stub do
      # Create client
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_reporting_identity_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_reporting_identity_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_reporting_identity_settings ::Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_reporting_identity_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_reporting_identity_settings(::Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_reporting_identity_settings_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
