# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/analytics/admin/v1alpha/analytics_admin_pb"
require "google/analytics/admin/v1alpha/analytics_admin_service/rest"


class ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_account
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Account.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_account_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_account({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_account name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_account ::Google::Analytics::Admin::V1alpha::GetAccountRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_account({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_account(::Google::Analytics::Admin::V1alpha::GetAccountRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_account_client_stub.call_count
      end
    end
  end

  def test_list_accounts
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListAccountsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_accounts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_accounts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_accounts_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_accounts({ page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_accounts page_size: page_size, page_token: page_token, show_deleted: show_deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_accounts ::Google::Analytics::Admin::V1alpha::ListAccountsRequest.new(page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_accounts({ page_size: page_size, page_token: page_token, show_deleted: show_deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_accounts(::Google::Analytics::Admin::V1alpha::ListAccountsRequest.new(page_size: page_size, page_token: page_token, show_deleted: show_deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_accounts_client_stub.call_count
      end
    end
  end

  def test_delete_account
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_account_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_account({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_account name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_account ::Google::Analytics::Admin::V1alpha::DeleteAccountRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_account({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_account(::Google::Analytics::Admin::V1alpha::DeleteAccountRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_account_client_stub.call_count
      end
    end
  end

  def test_update_account
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Account.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = {}
    update_mask = {}

    update_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_account_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_account({ account: account, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_account account: account, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_account ::Google::Analytics::Admin::V1alpha::UpdateAccountRequest.new(account: account, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_account({ account: account, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_account(::Google::Analytics::Admin::V1alpha::UpdateAccountRequest.new(account: account, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_account_client_stub.call_count
      end
    end
  end

  def test_provision_account_ticket
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = {}
    redirect_uri = "hello world"

    provision_account_ticket_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_provision_account_ticket_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, provision_account_ticket_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.provision_account_ticket({ account: account, redirect_uri: redirect_uri }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.provision_account_ticket account: account, redirect_uri: redirect_uri do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.provision_account_ticket ::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest.new(account: account, redirect_uri: redirect_uri) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.provision_account_ticket({ account: account, redirect_uri: redirect_uri }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.provision_account_ticket(::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest.new(account: account, redirect_uri: redirect_uri), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, provision_account_ticket_client_stub.call_count
      end
    end
  end

  def test_list_account_summaries
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListAccountSummariesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"

    list_account_summaries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_account_summaries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_account_summaries_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_account_summaries({ page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_account_summaries page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_account_summaries ::Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest.new(page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_account_summaries({ page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_account_summaries(::Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest.new(page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_account_summaries_client_stub.call_count
      end
    end
  end

  def test_get_property
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Property.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_property_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_property_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_property_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_property({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_property name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_property ::Google::Analytics::Admin::V1alpha::GetPropertyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_property({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_property(::Google::Analytics::Admin::V1alpha::GetPropertyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_property_client_stub.call_count
      end
    end
  end

  def test_list_properties
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListPropertiesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_properties_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_properties_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_properties_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_properties({ filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_properties filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_properties ::Google::Analytics::Admin::V1alpha::ListPropertiesRequest.new(filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_properties({ filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_properties(::Google::Analytics::Admin::V1alpha::ListPropertiesRequest.new(filter: filter, page_size: page_size, page_token: page_token, show_deleted: show_deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_properties_client_stub.call_count
      end
    end
  end

  def test_create_property
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Property.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    property = {}

    create_property_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_property_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_property_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_property({ property: property }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_property property: property do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_property ::Google::Analytics::Admin::V1alpha::CreatePropertyRequest.new(property: property) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_property({ property: property }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_property(::Google::Analytics::Admin::V1alpha::CreatePropertyRequest.new(property: property), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_property_client_stub.call_count
      end
    end
  end

  def test_delete_property
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Property.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_property_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_property_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_property_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_property({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_property name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_property ::Google::Analytics::Admin::V1alpha::DeletePropertyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_property({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_property(::Google::Analytics::Admin::V1alpha::DeletePropertyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_property_client_stub.call_count
      end
    end
  end

  def test_update_property
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Property.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    property = {}
    update_mask = {}

    update_property_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_property_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_property_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_property({ property: property, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_property property: property, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_property ::Google::Analytics::Admin::V1alpha::UpdatePropertyRequest.new(property: property, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_property({ property: property, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_property(::Google::Analytics::Admin::V1alpha::UpdatePropertyRequest.new(property: property, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_property_client_stub.call_count
      end
    end
  end

  def test_create_firebase_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::FirebaseLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    firebase_link = {}

    create_firebase_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_firebase_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_firebase_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_firebase_link({ parent: parent, firebase_link: firebase_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_firebase_link parent: parent, firebase_link: firebase_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_firebase_link ::Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest.new(parent: parent, firebase_link: firebase_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_firebase_link({ parent: parent, firebase_link: firebase_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_firebase_link(::Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest.new(parent: parent, firebase_link: firebase_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_firebase_link_client_stub.call_count
      end
    end
  end

  def test_delete_firebase_link
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_firebase_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_firebase_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_firebase_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_firebase_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_firebase_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_firebase_link ::Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_firebase_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_firebase_link(::Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_firebase_link_client_stub.call_count
      end
    end
  end

  def test_list_firebase_links
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListFirebaseLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_firebase_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_firebase_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_firebase_links_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_firebase_links({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_firebase_links parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_firebase_links ::Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_firebase_links({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_firebase_links(::Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_firebase_links_client_stub.call_count
      end
    end
  end

  def test_get_global_site_tag
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::GlobalSiteTag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_global_site_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_global_site_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_global_site_tag_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_global_site_tag({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_global_site_tag name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_global_site_tag ::Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_global_site_tag({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_global_site_tag(::Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_global_site_tag_client_stub.call_count
      end
    end
  end

  def test_create_google_ads_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::GoogleAdsLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    google_ads_link = {}

    create_google_ads_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_google_ads_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_google_ads_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_google_ads_link({ parent: parent, google_ads_link: google_ads_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_google_ads_link parent: parent, google_ads_link: google_ads_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_google_ads_link ::Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest.new(parent: parent, google_ads_link: google_ads_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_google_ads_link({ parent: parent, google_ads_link: google_ads_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_google_ads_link(::Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest.new(parent: parent, google_ads_link: google_ads_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_google_ads_link_client_stub.call_count
      end
    end
  end

  def test_update_google_ads_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::GoogleAdsLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    google_ads_link = {}
    update_mask = {}

    update_google_ads_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_google_ads_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_google_ads_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_google_ads_link({ google_ads_link: google_ads_link, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_google_ads_link google_ads_link: google_ads_link, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_google_ads_link ::Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest.new(google_ads_link: google_ads_link, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_google_ads_link({ google_ads_link: google_ads_link, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_google_ads_link(::Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest.new(google_ads_link: google_ads_link, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_google_ads_link_client_stub.call_count
      end
    end
  end

  def test_delete_google_ads_link
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_google_ads_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_google_ads_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_google_ads_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_google_ads_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_google_ads_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_google_ads_link ::Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_google_ads_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_google_ads_link(::Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_google_ads_link_client_stub.call_count
      end
    end
  end

  def test_list_google_ads_links
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_google_ads_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_google_ads_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_google_ads_links_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_google_ads_links({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_google_ads_links parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_google_ads_links ::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_google_ads_links({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_google_ads_links(::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_google_ads_links_client_stub.call_count
      end
    end
  end

  def test_get_data_sharing_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DataSharingSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_sharing_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_data_sharing_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_sharing_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_sharing_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_sharing_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_sharing_settings ::Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_sharing_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_sharing_settings(::Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_sharing_settings_client_stub.call_count
      end
    end
  end

  def test_get_measurement_protocol_secret
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_measurement_protocol_secret_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_measurement_protocol_secret_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_measurement_protocol_secret_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_measurement_protocol_secret({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_measurement_protocol_secret name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_measurement_protocol_secret ::Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_measurement_protocol_secret({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_measurement_protocol_secret(::Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_measurement_protocol_secret_client_stub.call_count
      end
    end
  end

  def test_list_measurement_protocol_secrets
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_measurement_protocol_secrets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_measurement_protocol_secrets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_measurement_protocol_secrets_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_measurement_protocol_secrets({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_measurement_protocol_secrets parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_measurement_protocol_secrets ::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_measurement_protocol_secrets({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_measurement_protocol_secrets(::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_measurement_protocol_secrets_client_stub.call_count
      end
    end
  end

  def test_create_measurement_protocol_secret
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    measurement_protocol_secret = {}

    create_measurement_protocol_secret_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_measurement_protocol_secret_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_measurement_protocol_secret_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_measurement_protocol_secret({ parent: parent, measurement_protocol_secret: measurement_protocol_secret }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_measurement_protocol_secret parent: parent, measurement_protocol_secret: measurement_protocol_secret do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_measurement_protocol_secret ::Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest.new(parent: parent, measurement_protocol_secret: measurement_protocol_secret) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_measurement_protocol_secret({ parent: parent, measurement_protocol_secret: measurement_protocol_secret }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_measurement_protocol_secret(::Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest.new(parent: parent, measurement_protocol_secret: measurement_protocol_secret), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_measurement_protocol_secret_client_stub.call_count
      end
    end
  end

  def test_delete_measurement_protocol_secret
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_measurement_protocol_secret_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_measurement_protocol_secret_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_measurement_protocol_secret_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_measurement_protocol_secret({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_measurement_protocol_secret name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_measurement_protocol_secret ::Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_measurement_protocol_secret({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_measurement_protocol_secret(::Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_measurement_protocol_secret_client_stub.call_count
      end
    end
  end

  def test_update_measurement_protocol_secret
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    measurement_protocol_secret = {}
    update_mask = {}

    update_measurement_protocol_secret_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_measurement_protocol_secret_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_measurement_protocol_secret_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_measurement_protocol_secret({ measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_measurement_protocol_secret measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_measurement_protocol_secret ::Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest.new(measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_measurement_protocol_secret({ measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_measurement_protocol_secret(::Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest.new(measurement_protocol_secret: measurement_protocol_secret, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_measurement_protocol_secret_client_stub.call_count
      end
    end
  end

  def test_acknowledge_user_data_collection
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    property = "hello world"
    acknowledgement = "hello world"

    acknowledge_user_data_collection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_acknowledge_user_data_collection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, acknowledge_user_data_collection_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.acknowledge_user_data_collection({ property: property, acknowledgement: acknowledgement }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.acknowledge_user_data_collection property: property, acknowledgement: acknowledgement do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.acknowledge_user_data_collection ::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest.new(property: property, acknowledgement: acknowledgement) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.acknowledge_user_data_collection({ property: property, acknowledgement: acknowledgement }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.acknowledge_user_data_collection(::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest.new(property: property, acknowledgement: acknowledgement), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, acknowledge_user_data_collection_client_stub.call_count
      end
    end
  end

  def test_get_sk_ad_network_conversion_value_schema
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_sk_ad_network_conversion_value_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_sk_ad_network_conversion_value_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_sk_ad_network_conversion_value_schema_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_sk_ad_network_conversion_value_schema({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_sk_ad_network_conversion_value_schema name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_sk_ad_network_conversion_value_schema ::Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_sk_ad_network_conversion_value_schema({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_sk_ad_network_conversion_value_schema(::Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_sk_ad_network_conversion_value_schema_client_stub.call_count
      end
    end
  end

  def test_create_sk_ad_network_conversion_value_schema
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    skadnetwork_conversion_value_schema = {}

    create_sk_ad_network_conversion_value_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_sk_ad_network_conversion_value_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_sk_ad_network_conversion_value_schema_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_sk_ad_network_conversion_value_schema({ parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_sk_ad_network_conversion_value_schema parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_sk_ad_network_conversion_value_schema ::Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest.new(parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_sk_ad_network_conversion_value_schema({ parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_sk_ad_network_conversion_value_schema(::Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest.new(parent: parent, skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_sk_ad_network_conversion_value_schema_client_stub.call_count
      end
    end
  end

  def test_delete_sk_ad_network_conversion_value_schema
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_sk_ad_network_conversion_value_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_sk_ad_network_conversion_value_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_sk_ad_network_conversion_value_schema_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_sk_ad_network_conversion_value_schema({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_sk_ad_network_conversion_value_schema name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_sk_ad_network_conversion_value_schema ::Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_sk_ad_network_conversion_value_schema({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_sk_ad_network_conversion_value_schema(::Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_sk_ad_network_conversion_value_schema_client_stub.call_count
      end
    end
  end

  def test_update_sk_ad_network_conversion_value_schema
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    skadnetwork_conversion_value_schema = {}
    update_mask = {}

    update_sk_ad_network_conversion_value_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_sk_ad_network_conversion_value_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_sk_ad_network_conversion_value_schema_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_sk_ad_network_conversion_value_schema({ skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_sk_ad_network_conversion_value_schema skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_sk_ad_network_conversion_value_schema ::Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest.new(skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_sk_ad_network_conversion_value_schema({ skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_sk_ad_network_conversion_value_schema(::Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest.new(skadnetwork_conversion_value_schema: skadnetwork_conversion_value_schema, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_sk_ad_network_conversion_value_schema_client_stub.call_count
      end
    end
  end

  def test_list_sk_ad_network_conversion_value_schemas
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_sk_ad_network_conversion_value_schemas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_sk_ad_network_conversion_value_schemas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sk_ad_network_conversion_value_schemas_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sk_ad_network_conversion_value_schemas({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sk_ad_network_conversion_value_schemas parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sk_ad_network_conversion_value_schemas ::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sk_ad_network_conversion_value_schemas({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sk_ad_network_conversion_value_schemas(::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sk_ad_network_conversion_value_schemas_client_stub.call_count
      end
    end
  end

  def test_search_change_history_events
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    property = "hello world"
    resource_type = [:CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED]
    action = [:ACTION_TYPE_UNSPECIFIED]
    actor_email = ["hello world"]
    earliest_change_time = {}
    latest_change_time = {}
    page_size = 42
    page_token = "hello world"

    search_change_history_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_search_change_history_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_change_history_events_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_change_history_events({ account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_change_history_events account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_change_history_events ::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest.new(account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_change_history_events({ account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_change_history_events(::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest.new(account: account, property: property, resource_type: resource_type, action: action, actor_email: actor_email, earliest_change_time: earliest_change_time, latest_change_time: latest_change_time, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_change_history_events_client_stub.call_count
      end
    end
  end

  def test_get_google_signals_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_google_signals_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_google_signals_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_google_signals_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_google_signals_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_google_signals_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_google_signals_settings ::Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_google_signals_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_google_signals_settings(::Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_google_signals_settings_client_stub.call_count
      end
    end
  end

  def test_update_google_signals_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    google_signals_settings = {}
    update_mask = {}

    update_google_signals_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_google_signals_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_google_signals_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_google_signals_settings({ google_signals_settings: google_signals_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_google_signals_settings google_signals_settings: google_signals_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_google_signals_settings ::Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest.new(google_signals_settings: google_signals_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_google_signals_settings({ google_signals_settings: google_signals_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_google_signals_settings(::Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest.new(google_signals_settings: google_signals_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_google_signals_settings_client_stub.call_count
      end
    end
  end

  def test_create_conversion_event
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ConversionEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    conversion_event = {}
    parent = "hello world"

    create_conversion_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_conversion_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_conversion_event_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_conversion_event({ conversion_event: conversion_event, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_conversion_event conversion_event: conversion_event, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_conversion_event ::Google::Analytics::Admin::V1alpha::CreateConversionEventRequest.new(conversion_event: conversion_event, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_conversion_event({ conversion_event: conversion_event, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_conversion_event(::Google::Analytics::Admin::V1alpha::CreateConversionEventRequest.new(conversion_event: conversion_event, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_conversion_event_client_stub.call_count
      end
    end
  end

  def test_update_conversion_event
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ConversionEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    conversion_event = {}
    update_mask = {}

    update_conversion_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_conversion_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_conversion_event_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_conversion_event({ conversion_event: conversion_event, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_conversion_event conversion_event: conversion_event, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_conversion_event ::Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest.new(conversion_event: conversion_event, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_conversion_event({ conversion_event: conversion_event, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_conversion_event(::Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest.new(conversion_event: conversion_event, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_conversion_event_client_stub.call_count
      end
    end
  end

  def test_get_conversion_event
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ConversionEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_conversion_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_conversion_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_conversion_event_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_conversion_event({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_conversion_event name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_conversion_event ::Google::Analytics::Admin::V1alpha::GetConversionEventRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_conversion_event({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_conversion_event(::Google::Analytics::Admin::V1alpha::GetConversionEventRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_conversion_event_client_stub.call_count
      end
    end
  end

  def test_delete_conversion_event
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_conversion_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_conversion_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_conversion_event_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_conversion_event({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_conversion_event name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_conversion_event ::Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_conversion_event({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_conversion_event(::Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_conversion_event_client_stub.call_count
      end
    end
  end

  def test_list_conversion_events
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListConversionEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_conversion_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_conversion_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_conversion_events_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_conversion_events({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_conversion_events parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_conversion_events ::Google::Analytics::Admin::V1alpha::ListConversionEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_conversion_events({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_conversion_events(::Google::Analytics::Admin::V1alpha::ListConversionEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_conversion_events_client_stub.call_count
      end
    end
  end

  def test_create_key_event
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::KeyEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    key_event = {}
    parent = "hello world"

    create_key_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_key_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_key_event_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_key_event({ key_event: key_event, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_key_event key_event: key_event, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_key_event ::Google::Analytics::Admin::V1alpha::CreateKeyEventRequest.new(key_event: key_event, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_key_event({ key_event: key_event, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_key_event(::Google::Analytics::Admin::V1alpha::CreateKeyEventRequest.new(key_event: key_event, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_key_event_client_stub.call_count
      end
    end
  end

  def test_update_key_event
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::KeyEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    key_event = {}
    update_mask = {}

    update_key_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_key_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_key_event_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_key_event({ key_event: key_event, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_key_event key_event: key_event, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_key_event ::Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest.new(key_event: key_event, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_key_event({ key_event: key_event, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_key_event(::Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest.new(key_event: key_event, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_key_event_client_stub.call_count
      end
    end
  end

  def test_get_key_event
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::KeyEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_key_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_key_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_key_event_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_key_event({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_key_event name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_key_event ::Google::Analytics::Admin::V1alpha::GetKeyEventRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_key_event({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_key_event(::Google::Analytics::Admin::V1alpha::GetKeyEventRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_key_event_client_stub.call_count
      end
    end
  end

  def test_delete_key_event
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_key_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_key_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_key_event_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_key_event({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_key_event name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_key_event ::Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_key_event({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_key_event(::Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_key_event_client_stub.call_count
      end
    end
  end

  def test_list_key_events
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListKeyEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_key_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_key_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_key_events_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_key_events({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_key_events parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_key_events ::Google::Analytics::Admin::V1alpha::ListKeyEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_key_events({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_key_events(::Google::Analytics::Admin::V1alpha::ListKeyEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_key_events_client_stub.call_count
      end
    end
  end

  def test_get_display_video360_advertiser_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_display_video360_advertiser_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_display_video360_advertiser_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_display_video360_advertiser_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_display_video360_advertiser_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_display_video360_advertiser_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_display_video360_advertiser_link ::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_display_video360_advertiser_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_display_video360_advertiser_link(::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_display_video360_advertiser_link_client_stub.call_count
      end
    end
  end

  def test_list_display_video360_advertiser_links
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_display_video360_advertiser_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_display_video360_advertiser_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_display_video360_advertiser_links_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_display_video360_advertiser_links({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_display_video360_advertiser_links parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_display_video360_advertiser_links ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_display_video360_advertiser_links({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_display_video360_advertiser_links(::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_display_video360_advertiser_links_client_stub.call_count
      end
    end
  end

  def test_create_display_video360_advertiser_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    display_video_360_advertiser_link = {}

    create_display_video360_advertiser_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_display_video360_advertiser_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_display_video360_advertiser_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_display_video360_advertiser_link({ parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_display_video360_advertiser_link parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_display_video360_advertiser_link ::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest.new(parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_display_video360_advertiser_link({ parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_display_video360_advertiser_link(::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest.new(parent: parent, display_video_360_advertiser_link: display_video_360_advertiser_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_display_video360_advertiser_link_client_stub.call_count
      end
    end
  end

  def test_delete_display_video360_advertiser_link
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_display_video360_advertiser_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_display_video360_advertiser_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_display_video360_advertiser_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_display_video360_advertiser_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_display_video360_advertiser_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_display_video360_advertiser_link ::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_display_video360_advertiser_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_display_video360_advertiser_link(::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_display_video360_advertiser_link_client_stub.call_count
      end
    end
  end

  def test_update_display_video360_advertiser_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    display_video_360_advertiser_link = {}
    update_mask = {}

    update_display_video360_advertiser_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_display_video360_advertiser_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_display_video360_advertiser_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_display_video360_advertiser_link({ display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_display_video360_advertiser_link display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_display_video360_advertiser_link ::Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest.new(display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_display_video360_advertiser_link({ display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_display_video360_advertiser_link(::Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest.new(display_video_360_advertiser_link: display_video_360_advertiser_link, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_display_video360_advertiser_link_client_stub.call_count
      end
    end
  end

  def test_get_display_video360_advertiser_link_proposal
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_display_video360_advertiser_link_proposal_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_display_video360_advertiser_link_proposal_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_display_video360_advertiser_link_proposal_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_display_video360_advertiser_link_proposal({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_display_video360_advertiser_link_proposal name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_display_video360_advertiser_link_proposal({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_display_video360_advertiser_link_proposal_client_stub.call_count
      end
    end
  end

  def test_list_display_video360_advertiser_link_proposals
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_display_video360_advertiser_link_proposals_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_display_video360_advertiser_link_proposals_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_display_video360_advertiser_link_proposals_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_display_video360_advertiser_link_proposals({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_display_video360_advertiser_link_proposals parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_display_video360_advertiser_link_proposals ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_display_video360_advertiser_link_proposals({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_display_video360_advertiser_link_proposals(::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_display_video360_advertiser_link_proposals_client_stub.call_count
      end
    end
  end

  def test_create_display_video360_advertiser_link_proposal
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    display_video_360_advertiser_link_proposal = {}

    create_display_video360_advertiser_link_proposal_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_display_video360_advertiser_link_proposal_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_display_video360_advertiser_link_proposal_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_display_video360_advertiser_link_proposal({ parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_display_video360_advertiser_link_proposal parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest.new(parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_display_video360_advertiser_link_proposal({ parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest.new(parent: parent, display_video_360_advertiser_link_proposal: display_video_360_advertiser_link_proposal), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_display_video360_advertiser_link_proposal_client_stub.call_count
      end
    end
  end

  def test_delete_display_video360_advertiser_link_proposal
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_display_video360_advertiser_link_proposal_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_display_video360_advertiser_link_proposal_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_display_video360_advertiser_link_proposal_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_display_video360_advertiser_link_proposal({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_display_video360_advertiser_link_proposal name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_display_video360_advertiser_link_proposal({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_display_video360_advertiser_link_proposal_client_stub.call_count
      end
    end
  end

  def test_approve_display_video360_advertiser_link_proposal
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    approve_display_video360_advertiser_link_proposal_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_approve_display_video360_advertiser_link_proposal_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, approve_display_video360_advertiser_link_proposal_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.approve_display_video360_advertiser_link_proposal({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.approve_display_video360_advertiser_link_proposal name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.approve_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.approve_display_video360_advertiser_link_proposal({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.approve_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, approve_display_video360_advertiser_link_proposal_client_stub.call_count
      end
    end
  end

  def test_cancel_display_video360_advertiser_link_proposal
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_display_video360_advertiser_link_proposal_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_cancel_display_video360_advertiser_link_proposal_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_display_video360_advertiser_link_proposal_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_display_video360_advertiser_link_proposal({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_display_video360_advertiser_link_proposal name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_display_video360_advertiser_link_proposal ::Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_display_video360_advertiser_link_proposal({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_display_video360_advertiser_link_proposal(::Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_display_video360_advertiser_link_proposal_client_stub.call_count
      end
    end
  end

  def test_create_custom_dimension
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CustomDimension.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_dimension = {}

    create_custom_dimension_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_custom_dimension_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_custom_dimension_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_custom_dimension({ parent: parent, custom_dimension: custom_dimension }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_custom_dimension parent: parent, custom_dimension: custom_dimension do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_custom_dimension ::Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest.new(parent: parent, custom_dimension: custom_dimension) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_custom_dimension({ parent: parent, custom_dimension: custom_dimension }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_custom_dimension(::Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest.new(parent: parent, custom_dimension: custom_dimension), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_custom_dimension_client_stub.call_count
      end
    end
  end

  def test_update_custom_dimension
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CustomDimension.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    custom_dimension = {}
    update_mask = {}

    update_custom_dimension_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_custom_dimension_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_custom_dimension_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_custom_dimension({ custom_dimension: custom_dimension, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_custom_dimension custom_dimension: custom_dimension, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_custom_dimension ::Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest.new(custom_dimension: custom_dimension, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_custom_dimension({ custom_dimension: custom_dimension, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_custom_dimension(::Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest.new(custom_dimension: custom_dimension, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_custom_dimension_client_stub.call_count
      end
    end
  end

  def test_list_custom_dimensions
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListCustomDimensionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_custom_dimensions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_custom_dimensions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_custom_dimensions_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_custom_dimensions({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_custom_dimensions parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_custom_dimensions ::Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_custom_dimensions({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_custom_dimensions(::Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_custom_dimensions_client_stub.call_count
      end
    end
  end

  def test_archive_custom_dimension
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    archive_custom_dimension_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_archive_custom_dimension_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, archive_custom_dimension_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.archive_custom_dimension({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.archive_custom_dimension name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.archive_custom_dimension ::Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.archive_custom_dimension({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.archive_custom_dimension(::Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, archive_custom_dimension_client_stub.call_count
      end
    end
  end

  def test_get_custom_dimension
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CustomDimension.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_dimension_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_custom_dimension_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_custom_dimension_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_custom_dimension({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_custom_dimension name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_custom_dimension ::Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_custom_dimension({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_custom_dimension(::Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_custom_dimension_client_stub.call_count
      end
    end
  end

  def test_create_custom_metric
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CustomMetric.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_metric = {}

    create_custom_metric_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_custom_metric_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_custom_metric_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_custom_metric({ parent: parent, custom_metric: custom_metric }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_custom_metric parent: parent, custom_metric: custom_metric do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_custom_metric ::Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest.new(parent: parent, custom_metric: custom_metric) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_custom_metric({ parent: parent, custom_metric: custom_metric }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_custom_metric(::Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest.new(parent: parent, custom_metric: custom_metric), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_custom_metric_client_stub.call_count
      end
    end
  end

  def test_update_custom_metric
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CustomMetric.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    custom_metric = {}
    update_mask = {}

    update_custom_metric_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_custom_metric_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_custom_metric_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_custom_metric({ custom_metric: custom_metric, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_custom_metric custom_metric: custom_metric, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_custom_metric ::Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest.new(custom_metric: custom_metric, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_custom_metric({ custom_metric: custom_metric, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_custom_metric(::Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest.new(custom_metric: custom_metric, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_custom_metric_client_stub.call_count
      end
    end
  end

  def test_list_custom_metrics
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListCustomMetricsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_custom_metrics_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_custom_metrics_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_custom_metrics_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_custom_metrics({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_custom_metrics parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_custom_metrics ::Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_custom_metrics({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_custom_metrics(::Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_custom_metrics_client_stub.call_count
      end
    end
  end

  def test_archive_custom_metric
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    archive_custom_metric_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_archive_custom_metric_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, archive_custom_metric_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.archive_custom_metric({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.archive_custom_metric name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.archive_custom_metric ::Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.archive_custom_metric({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.archive_custom_metric(::Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, archive_custom_metric_client_stub.call_count
      end
    end
  end

  def test_get_custom_metric
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CustomMetric.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_metric_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_custom_metric_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_custom_metric_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_custom_metric({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_custom_metric name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_custom_metric ::Google::Analytics::Admin::V1alpha::GetCustomMetricRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_custom_metric({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_custom_metric(::Google::Analytics::Admin::V1alpha::GetCustomMetricRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_custom_metric_client_stub.call_count
      end
    end
  end

  def test_get_data_retention_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DataRetentionSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_retention_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_data_retention_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_retention_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_retention_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_retention_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_retention_settings ::Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_retention_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_retention_settings(::Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_retention_settings_client_stub.call_count
      end
    end
  end

  def test_update_data_retention_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DataRetentionSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    data_retention_settings = {}
    update_mask = {}

    update_data_retention_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_data_retention_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_retention_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_retention_settings({ data_retention_settings: data_retention_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_retention_settings data_retention_settings: data_retention_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_retention_settings ::Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest.new(data_retention_settings: data_retention_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_retention_settings({ data_retention_settings: data_retention_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_retention_settings(::Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest.new(data_retention_settings: data_retention_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_retention_settings_client_stub.call_count
      end
    end
  end

  def test_create_data_stream
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DataStream.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_stream = {}

    create_data_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_data_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_stream_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_stream({ parent: parent, data_stream: data_stream }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_stream parent: parent, data_stream: data_stream do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_stream ::Google::Analytics::Admin::V1alpha::CreateDataStreamRequest.new(parent: parent, data_stream: data_stream) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_stream({ parent: parent, data_stream: data_stream }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_stream(::Google::Analytics::Admin::V1alpha::CreateDataStreamRequest.new(parent: parent, data_stream: data_stream), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_stream_client_stub.call_count
      end
    end
  end

  def test_delete_data_stream
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_data_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_stream_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_stream({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_stream name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_stream ::Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_stream({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_stream(::Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_stream_client_stub.call_count
      end
    end
  end

  def test_update_data_stream
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DataStream.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    data_stream = {}
    update_mask = {}

    update_data_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_data_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_stream_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_stream({ data_stream: data_stream, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_stream data_stream: data_stream, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_stream ::Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest.new(data_stream: data_stream, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_stream({ data_stream: data_stream, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_stream(::Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest.new(data_stream: data_stream, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_stream_client_stub.call_count
      end
    end
  end

  def test_list_data_streams
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListDataStreamsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_data_streams_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_data_streams_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_streams_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_streams({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_streams parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_streams ::Google::Analytics::Admin::V1alpha::ListDataStreamsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_streams({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_streams(::Google::Analytics::Admin::V1alpha::ListDataStreamsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_streams_client_stub.call_count
      end
    end
  end

  def test_get_data_stream
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DataStream.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_data_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_stream_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_stream({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_stream name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_stream ::Google::Analytics::Admin::V1alpha::GetDataStreamRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_stream({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_stream(::Google::Analytics::Admin::V1alpha::GetDataStreamRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_stream_client_stub.call_count
      end
    end
  end

  def test_get_audience
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Audience.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_audience_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_audience_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_audience_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_audience({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_audience name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_audience ::Google::Analytics::Admin::V1alpha::GetAudienceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_audience({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_audience(::Google::Analytics::Admin::V1alpha::GetAudienceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_audience_client_stub.call_count
      end
    end
  end

  def test_list_audiences
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListAudiencesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_audiences_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_audiences_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_audiences_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_audiences({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_audiences parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_audiences ::Google::Analytics::Admin::V1alpha::ListAudiencesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_audiences({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_audiences(::Google::Analytics::Admin::V1alpha::ListAudiencesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_audiences_client_stub.call_count
      end
    end
  end

  def test_create_audience
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Audience.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    audience = {}

    create_audience_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_audience_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_audience_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_audience({ parent: parent, audience: audience }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_audience parent: parent, audience: audience do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_audience ::Google::Analytics::Admin::V1alpha::CreateAudienceRequest.new(parent: parent, audience: audience) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_audience({ parent: parent, audience: audience }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_audience(::Google::Analytics::Admin::V1alpha::CreateAudienceRequest.new(parent: parent, audience: audience), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_audience_client_stub.call_count
      end
    end
  end

  def test_update_audience
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::Audience.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    audience = {}
    update_mask = {}

    update_audience_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_audience_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_audience_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_audience({ audience: audience, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_audience audience: audience, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_audience ::Google::Analytics::Admin::V1alpha::UpdateAudienceRequest.new(audience: audience, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_audience({ audience: audience, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_audience(::Google::Analytics::Admin::V1alpha::UpdateAudienceRequest.new(audience: audience, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_audience_client_stub.call_count
      end
    end
  end

  def test_archive_audience
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    archive_audience_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_archive_audience_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, archive_audience_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.archive_audience({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.archive_audience name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.archive_audience ::Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.archive_audience({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.archive_audience(::Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, archive_audience_client_stub.call_count
      end
    end
  end

  def test_get_search_ads360_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SearchAds360Link.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_search_ads360_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_search_ads360_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_search_ads360_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_search_ads360_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_search_ads360_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_search_ads360_link ::Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_search_ads360_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_search_ads360_link(::Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_search_ads360_link_client_stub.call_count
      end
    end
  end

  def test_list_search_ads360_links
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_search_ads360_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_search_ads360_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_search_ads360_links_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_search_ads360_links({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_search_ads360_links parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_search_ads360_links ::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_search_ads360_links({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_search_ads360_links(::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_search_ads360_links_client_stub.call_count
      end
    end
  end

  def test_create_search_ads360_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SearchAds360Link.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    search_ads_360_link = {}

    create_search_ads360_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_search_ads360_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_search_ads360_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_search_ads360_link({ parent: parent, search_ads_360_link: search_ads_360_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_search_ads360_link parent: parent, search_ads_360_link: search_ads_360_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_search_ads360_link ::Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest.new(parent: parent, search_ads_360_link: search_ads_360_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_search_ads360_link({ parent: parent, search_ads_360_link: search_ads_360_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_search_ads360_link(::Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest.new(parent: parent, search_ads_360_link: search_ads_360_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_search_ads360_link_client_stub.call_count
      end
    end
  end

  def test_delete_search_ads360_link
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_search_ads360_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_search_ads360_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_search_ads360_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_search_ads360_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_search_ads360_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_search_ads360_link ::Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_search_ads360_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_search_ads360_link(::Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_search_ads360_link_client_stub.call_count
      end
    end
  end

  def test_update_search_ads360_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SearchAds360Link.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    search_ads_360_link = {}
    update_mask = {}

    update_search_ads360_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_search_ads360_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_search_ads360_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_search_ads360_link({ search_ads_360_link: search_ads_360_link, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_search_ads360_link search_ads_360_link: search_ads_360_link, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_search_ads360_link ::Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest.new(search_ads_360_link: search_ads_360_link, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_search_ads360_link({ search_ads_360_link: search_ads_360_link, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_search_ads360_link(::Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest.new(search_ads_360_link: search_ads_360_link, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_search_ads360_link_client_stub.call_count
      end
    end
  end

  def test_get_attribution_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::AttributionSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attribution_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_attribution_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_attribution_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_attribution_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_attribution_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_attribution_settings ::Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_attribution_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_attribution_settings(::Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_attribution_settings_client_stub.call_count
      end
    end
  end

  def test_update_attribution_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::AttributionSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    attribution_settings = {}
    update_mask = {}

    update_attribution_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_attribution_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_attribution_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_attribution_settings({ attribution_settings: attribution_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_attribution_settings attribution_settings: attribution_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_attribution_settings ::Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest.new(attribution_settings: attribution_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_attribution_settings({ attribution_settings: attribution_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_attribution_settings(::Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest.new(attribution_settings: attribution_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_attribution_settings_client_stub.call_count
      end
    end
  end

  def test_run_access_report
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::RunAccessReportResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    entity = "hello world"
    dimensions = [{}]
    metrics = [{}]
    date_ranges = [{}]
    dimension_filter = {}
    metric_filter = {}
    offset = 42
    limit = 42
    time_zone = "hello world"
    order_bys = [{}]
    return_entity_quota = true
    include_all_users = true
    expand_groups = true

    run_access_report_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_run_access_report_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_access_report_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_access_report({ entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_access_report entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_access_report ::Google::Analytics::Admin::V1alpha::RunAccessReportRequest.new(entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_access_report({ entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_access_report(::Google::Analytics::Admin::V1alpha::RunAccessReportRequest.new(entity: entity, dimensions: dimensions, metrics: metrics, date_ranges: date_ranges, dimension_filter: dimension_filter, metric_filter: metric_filter, offset: offset, limit: limit, time_zone: time_zone, order_bys: order_bys, return_entity_quota: return_entity_quota, include_all_users: include_all_users, expand_groups: expand_groups), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_access_report_client_stub.call_count
      end
    end
  end

  def test_create_access_binding
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::AccessBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    access_binding = {}

    create_access_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_access_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_access_binding_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_access_binding({ parent: parent, access_binding: access_binding }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_access_binding parent: parent, access_binding: access_binding do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_access_binding ::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest.new(parent: parent, access_binding: access_binding) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_access_binding({ parent: parent, access_binding: access_binding }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_access_binding(::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest.new(parent: parent, access_binding: access_binding), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_access_binding_client_stub.call_count
      end
    end
  end

  def test_get_access_binding
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::AccessBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_access_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_access_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_access_binding_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_access_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_access_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_access_binding ::Google::Analytics::Admin::V1alpha::GetAccessBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_access_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_access_binding(::Google::Analytics::Admin::V1alpha::GetAccessBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_access_binding_client_stub.call_count
      end
    end
  end

  def test_update_access_binding
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::AccessBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    access_binding = {}

    update_access_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_access_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_access_binding_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_access_binding({ access_binding: access_binding }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_access_binding access_binding: access_binding do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_access_binding ::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest.new(access_binding: access_binding) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_access_binding({ access_binding: access_binding }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_access_binding(::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest.new(access_binding: access_binding), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_access_binding_client_stub.call_count
      end
    end
  end

  def test_delete_access_binding
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_access_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_access_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_access_binding_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_access_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_access_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_access_binding ::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_access_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_access_binding(::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_access_binding_client_stub.call_count
      end
    end
  end

  def test_list_access_bindings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListAccessBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_access_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_access_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_access_bindings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_access_bindings({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_access_bindings parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_access_bindings ::Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_access_bindings({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_access_bindings(::Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_access_bindings_client_stub.call_count
      end
    end
  end

  def test_batch_create_access_bindings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_access_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_batch_create_access_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_access_bindings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_access_bindings({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_access_bindings parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_access_bindings ::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_access_bindings({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_access_bindings(::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_access_bindings_client_stub.call_count
      end
    end
  end

  def test_batch_get_access_bindings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]

    batch_get_access_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_batch_get_access_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_get_access_bindings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_get_access_bindings({ parent: parent, names: names }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_get_access_bindings parent: parent, names: names do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_get_access_bindings ::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest.new(parent: parent, names: names) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_get_access_bindings({ parent: parent, names: names }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_get_access_bindings(::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest.new(parent: parent, names: names), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_get_access_bindings_client_stub.call_count
      end
    end
  end

  def test_batch_update_access_bindings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_update_access_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_batch_update_access_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_update_access_bindings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_update_access_bindings({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_update_access_bindings parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_update_access_bindings ::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_update_access_bindings({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_update_access_bindings(::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_update_access_bindings_client_stub.call_count
      end
    end
  end

  def test_batch_delete_access_bindings
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_delete_access_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_batch_delete_access_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_delete_access_bindings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_delete_access_bindings({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_delete_access_bindings parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_delete_access_bindings ::Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_delete_access_bindings({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_delete_access_bindings(::Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_delete_access_bindings_client_stub.call_count
      end
    end
  end

  def test_get_expanded_data_set
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ExpandedDataSet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_expanded_data_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_expanded_data_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_expanded_data_set_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_expanded_data_set({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_expanded_data_set name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_expanded_data_set ::Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_expanded_data_set({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_expanded_data_set(::Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_expanded_data_set_client_stub.call_count
      end
    end
  end

  def test_list_expanded_data_sets
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_expanded_data_sets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_expanded_data_sets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_expanded_data_sets_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_expanded_data_sets({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_expanded_data_sets parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_expanded_data_sets ::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_expanded_data_sets({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_expanded_data_sets(::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_expanded_data_sets_client_stub.call_count
      end
    end
  end

  def test_create_expanded_data_set
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ExpandedDataSet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    expanded_data_set = {}

    create_expanded_data_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_expanded_data_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_expanded_data_set_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_expanded_data_set({ parent: parent, expanded_data_set: expanded_data_set }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_expanded_data_set parent: parent, expanded_data_set: expanded_data_set do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_expanded_data_set ::Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest.new(parent: parent, expanded_data_set: expanded_data_set) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_expanded_data_set({ parent: parent, expanded_data_set: expanded_data_set }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_expanded_data_set(::Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest.new(parent: parent, expanded_data_set: expanded_data_set), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_expanded_data_set_client_stub.call_count
      end
    end
  end

  def test_update_expanded_data_set
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ExpandedDataSet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    expanded_data_set = {}
    update_mask = {}

    update_expanded_data_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_expanded_data_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_expanded_data_set_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_expanded_data_set({ expanded_data_set: expanded_data_set, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_expanded_data_set expanded_data_set: expanded_data_set, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_expanded_data_set ::Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest.new(expanded_data_set: expanded_data_set, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_expanded_data_set({ expanded_data_set: expanded_data_set, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_expanded_data_set(::Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest.new(expanded_data_set: expanded_data_set, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_expanded_data_set_client_stub.call_count
      end
    end
  end

  def test_delete_expanded_data_set
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_expanded_data_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_expanded_data_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_expanded_data_set_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_expanded_data_set({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_expanded_data_set name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_expanded_data_set ::Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_expanded_data_set({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_expanded_data_set(::Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_expanded_data_set_client_stub.call_count
      end
    end
  end

  def test_get_channel_group
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ChannelGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_channel_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_channel_group_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_channel_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_channel_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_channel_group ::Google::Analytics::Admin::V1alpha::GetChannelGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_channel_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_channel_group(::Google::Analytics::Admin::V1alpha::GetChannelGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_channel_group_client_stub.call_count
      end
    end
  end

  def test_list_channel_groups
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListChannelGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_channel_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_channel_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_channel_groups_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_channel_groups({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_channel_groups parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_channel_groups ::Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_channel_groups({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_channel_groups(::Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_channel_groups_client_stub.call_count
      end
    end
  end

  def test_create_channel_group
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ChannelGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel_group = {}

    create_channel_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_channel_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_channel_group_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_channel_group({ parent: parent, channel_group: channel_group }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_channel_group parent: parent, channel_group: channel_group do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_channel_group ::Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest.new(parent: parent, channel_group: channel_group) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_channel_group({ parent: parent, channel_group: channel_group }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_channel_group(::Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest.new(parent: parent, channel_group: channel_group), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_channel_group_client_stub.call_count
      end
    end
  end

  def test_update_channel_group
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ChannelGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    channel_group = {}
    update_mask = {}

    update_channel_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_channel_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_channel_group_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_channel_group({ channel_group: channel_group, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_channel_group channel_group: channel_group, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_channel_group ::Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest.new(channel_group: channel_group, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_channel_group({ channel_group: channel_group, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_channel_group(::Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest.new(channel_group: channel_group, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_channel_group_client_stub.call_count
      end
    end
  end

  def test_delete_channel_group
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_channel_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_channel_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_channel_group_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_channel_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_channel_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_channel_group ::Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_channel_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_channel_group(::Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_channel_group_client_stub.call_count
      end
    end
  end

  def test_create_big_query_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::BigQueryLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    bigquery_link = {}

    create_big_query_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_big_query_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_big_query_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_big_query_link({ parent: parent, bigquery_link: bigquery_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_big_query_link parent: parent, bigquery_link: bigquery_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_big_query_link ::Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest.new(parent: parent, bigquery_link: bigquery_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_big_query_link({ parent: parent, bigquery_link: bigquery_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_big_query_link(::Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest.new(parent: parent, bigquery_link: bigquery_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_big_query_link_client_stub.call_count
      end
    end
  end

  def test_get_big_query_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::BigQueryLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_big_query_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_big_query_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_big_query_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_big_query_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_big_query_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_big_query_link ::Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_big_query_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_big_query_link(::Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_big_query_link_client_stub.call_count
      end
    end
  end

  def test_list_big_query_links
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListBigQueryLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_big_query_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_big_query_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_big_query_links_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_big_query_links({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_big_query_links parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_big_query_links ::Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_big_query_links({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_big_query_links(::Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_big_query_links_client_stub.call_count
      end
    end
  end

  def test_delete_big_query_link
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_big_query_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_big_query_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_big_query_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_big_query_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_big_query_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_big_query_link ::Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_big_query_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_big_query_link(::Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_big_query_link_client_stub.call_count
      end
    end
  end

  def test_update_big_query_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::BigQueryLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    bigquery_link = {}
    update_mask = {}

    update_big_query_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_big_query_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_big_query_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_big_query_link({ bigquery_link: bigquery_link, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_big_query_link bigquery_link: bigquery_link, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_big_query_link ::Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest.new(bigquery_link: bigquery_link, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_big_query_link({ bigquery_link: bigquery_link, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_big_query_link(::Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest.new(bigquery_link: bigquery_link, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_big_query_link_client_stub.call_count
      end
    end
  end

  def test_get_enhanced_measurement_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_enhanced_measurement_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_enhanced_measurement_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_enhanced_measurement_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_enhanced_measurement_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_enhanced_measurement_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_enhanced_measurement_settings ::Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_enhanced_measurement_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_enhanced_measurement_settings(::Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_enhanced_measurement_settings_client_stub.call_count
      end
    end
  end

  def test_update_enhanced_measurement_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    enhanced_measurement_settings = {}
    update_mask = {}

    update_enhanced_measurement_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_enhanced_measurement_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_enhanced_measurement_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_enhanced_measurement_settings({ enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_enhanced_measurement_settings enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_enhanced_measurement_settings ::Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest.new(enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_enhanced_measurement_settings({ enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_enhanced_measurement_settings(::Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest.new(enhanced_measurement_settings: enhanced_measurement_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_enhanced_measurement_settings_client_stub.call_count
      end
    end
  end

  def test_get_ad_sense_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::AdSenseLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ad_sense_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_ad_sense_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_ad_sense_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_ad_sense_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_ad_sense_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_ad_sense_link ::Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_ad_sense_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_ad_sense_link(::Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_ad_sense_link_client_stub.call_count
      end
    end
  end

  def test_create_ad_sense_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::AdSenseLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    adsense_link = {}

    create_ad_sense_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_ad_sense_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_ad_sense_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_ad_sense_link({ parent: parent, adsense_link: adsense_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_ad_sense_link parent: parent, adsense_link: adsense_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_ad_sense_link ::Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest.new(parent: parent, adsense_link: adsense_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_ad_sense_link({ parent: parent, adsense_link: adsense_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_ad_sense_link(::Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest.new(parent: parent, adsense_link: adsense_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_ad_sense_link_client_stub.call_count
      end
    end
  end

  def test_delete_ad_sense_link
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_ad_sense_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_ad_sense_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_ad_sense_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_ad_sense_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_ad_sense_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_ad_sense_link ::Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_ad_sense_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_ad_sense_link(::Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_ad_sense_link_client_stub.call_count
      end
    end
  end

  def test_list_ad_sense_links
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListAdSenseLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_ad_sense_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_ad_sense_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_ad_sense_links_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_ad_sense_links({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_ad_sense_links parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_ad_sense_links ::Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_ad_sense_links({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_ad_sense_links(::Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_ad_sense_links_client_stub.call_count
      end
    end
  end

  def test_get_event_create_rule
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::EventCreateRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_create_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_event_create_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_event_create_rule_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_event_create_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_event_create_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_event_create_rule ::Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_event_create_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_event_create_rule(::Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_event_create_rule_client_stub.call_count
      end
    end
  end

  def test_list_event_create_rules
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListEventCreateRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_event_create_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_event_create_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_event_create_rules_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_event_create_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_event_create_rules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_event_create_rules ::Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_event_create_rules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_event_create_rules(::Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_event_create_rules_client_stub.call_count
      end
    end
  end

  def test_create_event_create_rule
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::EventCreateRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_create_rule = {}

    create_event_create_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_event_create_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_event_create_rule_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_event_create_rule({ parent: parent, event_create_rule: event_create_rule }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_event_create_rule parent: parent, event_create_rule: event_create_rule do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_event_create_rule ::Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest.new(parent: parent, event_create_rule: event_create_rule) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_event_create_rule({ parent: parent, event_create_rule: event_create_rule }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_event_create_rule(::Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest.new(parent: parent, event_create_rule: event_create_rule), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_event_create_rule_client_stub.call_count
      end
    end
  end

  def test_update_event_create_rule
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::EventCreateRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    event_create_rule = {}
    update_mask = {}

    update_event_create_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_event_create_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_event_create_rule_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_event_create_rule({ event_create_rule: event_create_rule, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_event_create_rule event_create_rule: event_create_rule, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_event_create_rule ::Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest.new(event_create_rule: event_create_rule, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_event_create_rule({ event_create_rule: event_create_rule, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_event_create_rule(::Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest.new(event_create_rule: event_create_rule, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_event_create_rule_client_stub.call_count
      end
    end
  end

  def test_delete_event_create_rule
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_event_create_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_event_create_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_event_create_rule_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_event_create_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_event_create_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_event_create_rule ::Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_event_create_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_event_create_rule(::Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_event_create_rule_client_stub.call_count
      end
    end
  end

  def test_get_event_edit_rule
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::EventEditRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_edit_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_event_edit_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_event_edit_rule_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_event_edit_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_event_edit_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_event_edit_rule ::Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_event_edit_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_event_edit_rule(::Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_event_edit_rule_client_stub.call_count
      end
    end
  end

  def test_list_event_edit_rules
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListEventEditRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_event_edit_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_event_edit_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_event_edit_rules_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_event_edit_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_event_edit_rules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_event_edit_rules ::Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_event_edit_rules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_event_edit_rules(::Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_event_edit_rules_client_stub.call_count
      end
    end
  end

  def test_create_event_edit_rule
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::EventEditRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_edit_rule = {}

    create_event_edit_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_event_edit_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_event_edit_rule_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_event_edit_rule({ parent: parent, event_edit_rule: event_edit_rule }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_event_edit_rule parent: parent, event_edit_rule: event_edit_rule do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_event_edit_rule ::Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest.new(parent: parent, event_edit_rule: event_edit_rule) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_event_edit_rule({ parent: parent, event_edit_rule: event_edit_rule }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_event_edit_rule(::Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest.new(parent: parent, event_edit_rule: event_edit_rule), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_event_edit_rule_client_stub.call_count
      end
    end
  end

  def test_update_event_edit_rule
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::EventEditRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    event_edit_rule = {}
    update_mask = {}

    update_event_edit_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_event_edit_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_event_edit_rule_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_event_edit_rule({ event_edit_rule: event_edit_rule, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_event_edit_rule event_edit_rule: event_edit_rule, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_event_edit_rule ::Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest.new(event_edit_rule: event_edit_rule, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_event_edit_rule({ event_edit_rule: event_edit_rule, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_event_edit_rule(::Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest.new(event_edit_rule: event_edit_rule, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_event_edit_rule_client_stub.call_count
      end
    end
  end

  def test_delete_event_edit_rule
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_event_edit_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_event_edit_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_event_edit_rule_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_event_edit_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_event_edit_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_event_edit_rule ::Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_event_edit_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_event_edit_rule(::Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_event_edit_rule_client_stub.call_count
      end
    end
  end

  def test_reorder_event_edit_rules
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_edit_rules = ["hello world"]

    reorder_event_edit_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_reorder_event_edit_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reorder_event_edit_rules_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reorder_event_edit_rules({ parent: parent, event_edit_rules: event_edit_rules }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reorder_event_edit_rules parent: parent, event_edit_rules: event_edit_rules do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reorder_event_edit_rules ::Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest.new(parent: parent, event_edit_rules: event_edit_rules) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reorder_event_edit_rules({ parent: parent, event_edit_rules: event_edit_rules }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reorder_event_edit_rules(::Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest.new(parent: parent, event_edit_rules: event_edit_rules), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reorder_event_edit_rules_client_stub.call_count
      end
    end
  end

  def test_update_data_redaction_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DataRedactionSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    data_redaction_settings = {}
    update_mask = {}

    update_data_redaction_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_data_redaction_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_redaction_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_redaction_settings({ data_redaction_settings: data_redaction_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_redaction_settings data_redaction_settings: data_redaction_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_redaction_settings ::Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest.new(data_redaction_settings: data_redaction_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_redaction_settings({ data_redaction_settings: data_redaction_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_redaction_settings(::Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest.new(data_redaction_settings: data_redaction_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_redaction_settings_client_stub.call_count
      end
    end
  end

  def test_get_data_redaction_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::DataRedactionSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_redaction_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_data_redaction_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_redaction_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_redaction_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_redaction_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_redaction_settings ::Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_redaction_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_redaction_settings(::Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_redaction_settings_client_stub.call_count
      end
    end
  end

  def test_get_calculated_metric
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CalculatedMetric.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_calculated_metric_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_calculated_metric_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_calculated_metric_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_calculated_metric({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_calculated_metric name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_calculated_metric ::Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_calculated_metric({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_calculated_metric(::Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_calculated_metric_client_stub.call_count
      end
    end
  end

  def test_create_calculated_metric
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CalculatedMetric.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    calculated_metric_id = "hello world"
    calculated_metric = {}

    create_calculated_metric_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_calculated_metric_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_calculated_metric_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_calculated_metric({ parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_calculated_metric parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_calculated_metric ::Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest.new(parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_calculated_metric({ parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_calculated_metric(::Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest.new(parent: parent, calculated_metric_id: calculated_metric_id, calculated_metric: calculated_metric), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_calculated_metric_client_stub.call_count
      end
    end
  end

  def test_list_calculated_metrics
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_calculated_metrics_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_calculated_metrics_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_calculated_metrics_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_calculated_metrics({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_calculated_metrics parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_calculated_metrics ::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_calculated_metrics({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_calculated_metrics(::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_calculated_metrics_client_stub.call_count
      end
    end
  end

  def test_update_calculated_metric
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CalculatedMetric.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    calculated_metric = {}
    update_mask = {}

    update_calculated_metric_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_calculated_metric_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_calculated_metric_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_calculated_metric({ calculated_metric: calculated_metric, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_calculated_metric calculated_metric: calculated_metric, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_calculated_metric ::Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest.new(calculated_metric: calculated_metric, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_calculated_metric({ calculated_metric: calculated_metric, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_calculated_metric(::Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest.new(calculated_metric: calculated_metric, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_calculated_metric_client_stub.call_count
      end
    end
  end

  def test_delete_calculated_metric
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_calculated_metric_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_calculated_metric_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_calculated_metric_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_calculated_metric({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_calculated_metric name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_calculated_metric ::Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_calculated_metric({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_calculated_metric(::Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_calculated_metric_client_stub.call_count
      end
    end
  end

  def test_create_rollup_property
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::CreateRollupPropertyResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    rollup_property = {}
    source_properties = ["hello world"]

    create_rollup_property_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_rollup_property_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_rollup_property_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_rollup_property({ rollup_property: rollup_property, source_properties: source_properties }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_rollup_property rollup_property: rollup_property, source_properties: source_properties do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_rollup_property ::Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest.new(rollup_property: rollup_property, source_properties: source_properties) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_rollup_property({ rollup_property: rollup_property, source_properties: source_properties }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_rollup_property(::Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest.new(rollup_property: rollup_property, source_properties: source_properties), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_rollup_property_client_stub.call_count
      end
    end
  end

  def test_get_rollup_property_source_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollup_property_source_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_rollup_property_source_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rollup_property_source_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rollup_property_source_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rollup_property_source_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rollup_property_source_link ::Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rollup_property_source_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rollup_property_source_link(::Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rollup_property_source_link_client_stub.call_count
      end
    end
  end

  def test_list_rollup_property_source_links
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_rollup_property_source_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_rollup_property_source_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_rollup_property_source_links_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_rollup_property_source_links({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_rollup_property_source_links parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_rollup_property_source_links ::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_rollup_property_source_links({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_rollup_property_source_links(::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_rollup_property_source_links_client_stub.call_count
      end
    end
  end

  def test_create_rollup_property_source_link
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rollup_property_source_link = {}

    create_rollup_property_source_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_rollup_property_source_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_rollup_property_source_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_rollup_property_source_link({ parent: parent, rollup_property_source_link: rollup_property_source_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_rollup_property_source_link parent: parent, rollup_property_source_link: rollup_property_source_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_rollup_property_source_link ::Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest.new(parent: parent, rollup_property_source_link: rollup_property_source_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_rollup_property_source_link({ parent: parent, rollup_property_source_link: rollup_property_source_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_rollup_property_source_link(::Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest.new(parent: parent, rollup_property_source_link: rollup_property_source_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_rollup_property_source_link_client_stub.call_count
      end
    end
  end

  def test_delete_rollup_property_source_link
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_rollup_property_source_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_rollup_property_source_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_rollup_property_source_link_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_rollup_property_source_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_rollup_property_source_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_rollup_property_source_link ::Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_rollup_property_source_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_rollup_property_source_link(::Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_rollup_property_source_link_client_stub.call_count
      end
    end
  end

  def test_provision_subproperty
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    subproperty = {}
    subproperty_event_filter = {}
    custom_dimension_and_metric_synchronization_mode = :SYNCHRONIZATION_MODE_UNSPECIFIED

    provision_subproperty_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_provision_subproperty_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, provision_subproperty_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.provision_subproperty({ subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.provision_subproperty subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.provision_subproperty ::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest.new(subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.provision_subproperty({ subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.provision_subproperty(::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest.new(subproperty: subproperty, subproperty_event_filter: subproperty_event_filter, custom_dimension_and_metric_synchronization_mode: custom_dimension_and_metric_synchronization_mode), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, provision_subproperty_client_stub.call_count
      end
    end
  end

  def test_create_subproperty_event_filter
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subproperty_event_filter = {}

    create_subproperty_event_filter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_subproperty_event_filter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_subproperty_event_filter_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_subproperty_event_filter({ parent: parent, subproperty_event_filter: subproperty_event_filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_subproperty_event_filter parent: parent, subproperty_event_filter: subproperty_event_filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_subproperty_event_filter ::Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest.new(parent: parent, subproperty_event_filter: subproperty_event_filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_subproperty_event_filter({ parent: parent, subproperty_event_filter: subproperty_event_filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_subproperty_event_filter(::Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest.new(parent: parent, subproperty_event_filter: subproperty_event_filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_subproperty_event_filter_client_stub.call_count
      end
    end
  end

  def test_get_subproperty_event_filter
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subproperty_event_filter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_subproperty_event_filter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_subproperty_event_filter_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_subproperty_event_filter({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_subproperty_event_filter name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_subproperty_event_filter ::Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_subproperty_event_filter({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_subproperty_event_filter(::Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_subproperty_event_filter_client_stub.call_count
      end
    end
  end

  def test_list_subproperty_event_filters
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subproperty_event_filters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_subproperty_event_filters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subproperty_event_filters_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subproperty_event_filters({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subproperty_event_filters parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subproperty_event_filters ::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subproperty_event_filters({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subproperty_event_filters(::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subproperty_event_filters_client_stub.call_count
      end
    end
  end

  def test_update_subproperty_event_filter
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    subproperty_event_filter = {}
    update_mask = {}

    update_subproperty_event_filter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_subproperty_event_filter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_subproperty_event_filter_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_subproperty_event_filter({ subproperty_event_filter: subproperty_event_filter, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_subproperty_event_filter subproperty_event_filter: subproperty_event_filter, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_subproperty_event_filter ::Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest.new(subproperty_event_filter: subproperty_event_filter, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_subproperty_event_filter({ subproperty_event_filter: subproperty_event_filter, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_subproperty_event_filter(::Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest.new(subproperty_event_filter: subproperty_event_filter, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_subproperty_event_filter_client_stub.call_count
      end
    end
  end

  def test_delete_subproperty_event_filter
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_subproperty_event_filter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_subproperty_event_filter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_subproperty_event_filter_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_subproperty_event_filter({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_subproperty_event_filter name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_subproperty_event_filter ::Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_subproperty_event_filter({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_subproperty_event_filter(::Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_subproperty_event_filter_client_stub.call_count
      end
    end
  end

  def test_create_reporting_data_annotation
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reporting_data_annotation = {}

    create_reporting_data_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_create_reporting_data_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_reporting_data_annotation_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_reporting_data_annotation({ parent: parent, reporting_data_annotation: reporting_data_annotation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_reporting_data_annotation parent: parent, reporting_data_annotation: reporting_data_annotation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_reporting_data_annotation ::Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest.new(parent: parent, reporting_data_annotation: reporting_data_annotation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_reporting_data_annotation({ parent: parent, reporting_data_annotation: reporting_data_annotation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_reporting_data_annotation(::Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest.new(parent: parent, reporting_data_annotation: reporting_data_annotation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_reporting_data_annotation_client_stub.call_count
      end
    end
  end

  def test_get_reporting_data_annotation
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reporting_data_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_reporting_data_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_reporting_data_annotation_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_reporting_data_annotation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_reporting_data_annotation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_reporting_data_annotation ::Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_reporting_data_annotation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_reporting_data_annotation(::Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_reporting_data_annotation_client_stub.call_count
      end
    end
  end

  def test_list_reporting_data_annotations
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_reporting_data_annotations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_reporting_data_annotations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_reporting_data_annotations_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_reporting_data_annotations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_reporting_data_annotations parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_reporting_data_annotations ::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_reporting_data_annotations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_reporting_data_annotations(::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_reporting_data_annotations_client_stub.call_count
      end
    end
  end

  def test_update_reporting_data_annotation
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    reporting_data_annotation = {}
    update_mask = {}

    update_reporting_data_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_reporting_data_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_reporting_data_annotation_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_reporting_data_annotation({ reporting_data_annotation: reporting_data_annotation, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_reporting_data_annotation reporting_data_annotation: reporting_data_annotation, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_reporting_data_annotation ::Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest.new(reporting_data_annotation: reporting_data_annotation, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_reporting_data_annotation({ reporting_data_annotation: reporting_data_annotation, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_reporting_data_annotation(::Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest.new(reporting_data_annotation: reporting_data_annotation, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_reporting_data_annotation_client_stub.call_count
      end
    end
  end

  def test_delete_reporting_data_annotation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reporting_data_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_delete_reporting_data_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_reporting_data_annotation_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_reporting_data_annotation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_reporting_data_annotation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_reporting_data_annotation ::Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_reporting_data_annotation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_reporting_data_annotation(::Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_reporting_data_annotation_client_stub.call_count
      end
    end
  end

  def test_submit_user_deletion
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SubmitUserDeletionResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    user_id = "hello world"
    name = "hello world"

    submit_user_deletion_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_submit_user_deletion_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, submit_user_deletion_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.submit_user_deletion({ user_id: user_id, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.submit_user_deletion user_id: user_id, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.submit_user_deletion ::Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest.new(user_id: user_id, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.submit_user_deletion({ user_id: user_id, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.submit_user_deletion(::Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest.new(user_id: user_id, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, submit_user_deletion_client_stub.call_count
      end
    end
  end

  def test_list_subproperty_sync_configs
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subproperty_sync_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_list_subproperty_sync_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subproperty_sync_configs_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subproperty_sync_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subproperty_sync_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subproperty_sync_configs ::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subproperty_sync_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subproperty_sync_configs(::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subproperty_sync_configs_client_stub.call_count
      end
    end
  end

  def test_update_subproperty_sync_config
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    subproperty_sync_config = {}
    update_mask = {}

    update_subproperty_sync_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_update_subproperty_sync_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_subproperty_sync_config_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_subproperty_sync_config({ subproperty_sync_config: subproperty_sync_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_subproperty_sync_config subproperty_sync_config: subproperty_sync_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_subproperty_sync_config ::Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest.new(subproperty_sync_config: subproperty_sync_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_subproperty_sync_config({ subproperty_sync_config: subproperty_sync_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_subproperty_sync_config(::Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest.new(subproperty_sync_config: subproperty_sync_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_subproperty_sync_config_client_stub.call_count
      end
    end
  end

  def test_get_subproperty_sync_config
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subproperty_sync_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_subproperty_sync_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_subproperty_sync_config_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_subproperty_sync_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_subproperty_sync_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_subproperty_sync_config ::Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_subproperty_sync_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_subproperty_sync_config(::Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_subproperty_sync_config_client_stub.call_count
      end
    end
  end

  def test_get_reporting_identity_settings
    # Create test objects.
    client_result = ::Google::Analytics::Admin::V1alpha::ReportingIdentitySettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reporting_identity_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.stub :transcode_get_reporting_identity_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_reporting_identity_settings_client_stub do
        # Create client
        client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_reporting_identity_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_reporting_identity_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_reporting_identity_settings ::Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_reporting_identity_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_reporting_identity_settings(::Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_reporting_identity_settings_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client::Configuration, config
  end
end
