# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Analytics
    module Admin
      module V1alpha
        # A resource message representing a Google Analytics account.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this account.
        #     Format: accounts/\\{account}
        #     Example: "accounts/100"
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this account was originally created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when account payload fields were last updated.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Human-readable display name for this account.
        # @!attribute [rw] region_code
        #   @return [::String]
        #     Country of business. Must be a Unicode CLDR region code.
        # @!attribute [r] deleted
        #   @return [::Boolean]
        #     Output only. Indicates whether this Account is soft-deleted or not. Deleted
        #     accounts are excluded from List results unless specifically requested.
        # @!attribute [r] gmp_organization
        #   @return [::String]
        #     Output only. The URI for a Google Marketing Platform organization resource.
        #     Only set when this account is connected to a GMP organization.
        #     Format: marketingplatformadmin.googleapis.com/organizations/\\{org_id}
        class Account
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource message representing a Google Analytics property.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this property.
        #     Format: properties/\\{property_id}
        #     Example: "properties/1000"
        # @!attribute [rw] property_type
        #   @return [::Google::Analytics::Admin::V1alpha::PropertyType]
        #     Immutable. The property type for this Property resource. When creating a
        #     property, if the type is "PROPERTY_TYPE_UNSPECIFIED", then
        #     "ORDINARY_PROPERTY" will be implied.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the entity was originally created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when entity payload fields were last updated.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Immutable. Resource name of this property's logical parent.
        #
        #     Note: The Property-Moving UI can be used to change the parent.
        #     Format: accounts/\\{account}, properties/\\{property}
        #     Example: "accounts/100", "properties/101"
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Human-readable display name for this property.
        #
        #     The max allowed display name length is 100 UTF-16 code units.
        # @!attribute [rw] industry_category
        #   @return [::Google::Analytics::Admin::V1alpha::IndustryCategory]
        #     Industry associated with this property
        #     Example: AUTOMOTIVE, FOOD_AND_DRINK
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Required. Reporting Time Zone, used as the day boundary for reports,
        #     regardless of where the data originates. If the time zone honors DST,
        #     Analytics will automatically adjust for the changes.
        #
        #     NOTE: Changing the time zone only affects data going forward, and is not
        #     applied retroactively.
        #
        #     Format: https://www.iana.org/time-zones
        #     Example: "America/Los_Angeles"
        # @!attribute [rw] currency_code
        #   @return [::String]
        #     The currency type used in reports involving monetary values.
        #
        #
        #     Format: https://en.wikipedia.org/wiki/ISO_4217
        #     Examples: "USD", "EUR", "JPY"
        # @!attribute [r] service_level
        #   @return [::Google::Analytics::Admin::V1alpha::ServiceLevel]
        #     Output only. The Google Analytics service level that applies to this
        #     property.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. If set, the time at which this property was trashed. If not
        #     set, then this property is not currently in the trash can.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. If set, the time at which this trashed property will be
        #     permanently deleted. If not set, then this property is not currently in the
        #     trash can and is not slated to be deleted.
        # @!attribute [rw] account
        #   @return [::String]
        #     Immutable. The resource name of the parent account
        #     Format: accounts/\\{account_id}
        #     Example: "accounts/123"
        class Property
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource message representing a data stream.
        # @!attribute [rw] web_stream_data
        #   @return [::Google::Analytics::Admin::V1alpha::DataStream::WebStreamData]
        #     Data specific to web streams. Must be populated if type is
        #     WEB_DATA_STREAM.
        #
        #     Note: The following fields are mutually exclusive: `web_stream_data`, `android_app_stream_data`, `ios_app_stream_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] android_app_stream_data
        #   @return [::Google::Analytics::Admin::V1alpha::DataStream::AndroidAppStreamData]
        #     Data specific to Android app streams. Must be populated if type is
        #     ANDROID_APP_DATA_STREAM.
        #
        #     Note: The following fields are mutually exclusive: `android_app_stream_data`, `web_stream_data`, `ios_app_stream_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ios_app_stream_data
        #   @return [::Google::Analytics::Admin::V1alpha::DataStream::IosAppStreamData]
        #     Data specific to iOS app streams. Must be populated if type is
        #     IOS_APP_DATA_STREAM.
        #
        #     Note: The following fields are mutually exclusive: `ios_app_stream_data`, `web_stream_data`, `android_app_stream_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this Data Stream.
        #     Format: properties/\\{property_id}/dataStreams/\\{stream_id}
        #     Example: "properties/1000/dataStreams/2000"
        # @!attribute [rw] type
        #   @return [::Google::Analytics::Admin::V1alpha::DataStream::DataStreamType]
        #     Required. Immutable. The type of this DataStream resource.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Human-readable display name for the Data Stream.
        #
        #     Required for web data streams.
        #
        #     The max allowed display name length is 255 UTF-16 code units.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this stream was originally created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when stream payload fields were last updated.
        class DataStream
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Data specific to web streams.
          # @!attribute [r] measurement_id
          #   @return [::String]
          #     Output only. Analytics Measurement ID.
          #
          #     Example: "G-1A2BCD345E"
          # @!attribute [r] firebase_app_id
          #   @return [::String]
          #     Output only. ID of the corresponding web app in Firebase, if any.
          #     This ID can change if the web app is deleted and recreated.
          # @!attribute [rw] default_uri
          #   @return [::String]
          #     Domain name of the web app being measured, or empty.
          #     Example: "http://www.google.com", "https://www.google.com"
          class WebStreamData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Data specific to Android app streams.
          # @!attribute [r] firebase_app_id
          #   @return [::String]
          #     Output only. ID of the corresponding Android app in Firebase, if any.
          #     This ID can change if the Android app is deleted and recreated.
          # @!attribute [rw] package_name
          #   @return [::String]
          #     Immutable. The package name for the app being measured.
          #     Example: "com.example.myandroidapp"
          class AndroidAppStreamData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Data specific to iOS app streams.
          # @!attribute [r] firebase_app_id
          #   @return [::String]
          #     Output only. ID of the corresponding iOS app in Firebase, if any.
          #     This ID can change if the iOS app is deleted and recreated.
          # @!attribute [rw] bundle_id
          #   @return [::String]
          #     Required. Immutable. The Apple App Store Bundle ID for the app
          #     Example: "com.example.myiosapp"
          class IosAppStreamData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of the data stream.
          module DataStreamType
            # Type unknown or not specified.
            DATA_STREAM_TYPE_UNSPECIFIED = 0

            # Web data stream.
            WEB_DATA_STREAM = 1

            # Android app data stream.
            ANDROID_APP_DATA_STREAM = 2

            # iOS app data stream.
            IOS_APP_DATA_STREAM = 3
          end
        end

        # A link between a Google Analytics property and a Firebase project.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Example format: properties/1234/firebaseLinks/5678
        # @!attribute [rw] project
        #   @return [::String]
        #     Immutable. Firebase project resource name. When creating a FirebaseLink,
        #     you may provide this resource name using either a project number or project
        #     ID. Once this resource has been created, returned FirebaseLinks will always
        #     have a project_name that contains a project number.
        #
        #     Format: 'projects/\\{project number}'
        #     Example: 'projects/1234'
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this FirebaseLink was originally created.
        class FirebaseLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Read-only resource with the tag for sending data from a website to a
        # DataStream. Only present for web DataStream resources.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name for this GlobalSiteTag resource.
        #     Format: properties/\\{property_id}/dataStreams/\\{stream_id}/globalSiteTag
        #     Example: "properties/123/dataStreams/456/globalSiteTag"
        # @!attribute [rw] snippet
        #   @return [::String]
        #     Immutable. JavaScript code snippet to be pasted as the first item into the
        #     head tag of every webpage to measure.
        class GlobalSiteTag
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A link between a Google Analytics property and a Google Ads account.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Format:
        #     properties/\\{propertyId}/googleAdsLinks/\\{googleAdsLinkId}
        #
        #     Note: googleAdsLinkId is not the Google Ads customer ID.
        # @!attribute [rw] customer_id
        #   @return [::String]
        #     Immutable. Google Ads customer ID.
        # @!attribute [r] can_manage_clients
        #   @return [::Boolean]
        #     Output only. If true, this link is for a Google Ads manager account.
        # @!attribute [rw] ads_personalization_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Enable personalized advertising features with this integration.
        #     Automatically publish my Google Analytics audience lists and Google
        #     Analytics remarketing events/parameters to the linked Google Ads account.
        #     If this field is not set on create/update, it will be defaulted to true.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this link was originally created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this link was last updated.
        # @!attribute [r] creator_email_address
        #   @return [::String]
        #     Output only. Email address of the user that created the link.
        #     An empty string will be returned if the email address can't be retrieved.
        class GoogleAdsLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource message representing data sharing settings of a Google Analytics
        # account.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name.
        #     Format: accounts/\\{account}/dataSharingSettings
        #     Example: "accounts/1000/dataSharingSettings"
        # @!attribute [rw] sharing_with_google_support_enabled
        #   @return [::Boolean]
        #     Allows Google technical support representatives access to your Google
        #     Analytics data and account when necessary to provide service and find
        #     solutions to technical issues.
        #
        #     This field maps to the "Technical support" field in the Google Analytics
        #     Admin UI.
        # @!attribute [rw] sharing_with_google_assigned_sales_enabled
        #   @return [::Boolean]
        #     Allows Google access to your Google Analytics account data, including
        #     account usage and configuration data, product spending, and users
        #     associated with your Google Analytics account, so that Google can help you
        #     make the most of Google products, providing you with insights, offers,
        #     recommendations, and optimization tips across Google Analytics and other
        #     Google products for business.
        #
        #     This field maps to the "Recommendations for your business" field in the
        #     Google Analytics Admin UI.
        # @!attribute [rw] sharing_with_google_any_sales_enabled
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Deprecated. This field is no longer used and always returns false.
        # @!attribute [rw] sharing_with_google_products_enabled
        #   @return [::Boolean]
        #     Allows Google to use the data to improve other Google products or services.
        #
        #     This fields maps to the "Google products & services" field in the Google
        #     Analytics Admin UI.
        # @!attribute [rw] sharing_with_others_enabled
        #   @return [::Boolean]
        #     Enable features like predictions, modeled data, and benchmarking that can
        #     provide you with richer business insights when you contribute aggregated
        #     measurement data. The data you share (including information about the
        #     property from which it is shared) is aggregated and de-identified before
        #     being used to generate business insights.
        #
        #     This field maps to the "Modeling contributions & business insights" field
        #     in the Google Analytics Admin UI.
        class DataSharingSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A virtual resource representing an overview of an account and
        # all its child Google Analytics properties.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name for this account summary.
        #     Format: accountSummaries/\\{account_id}
        #     Example: "accountSummaries/1000"
        # @!attribute [rw] account
        #   @return [::String]
        #     Resource name of account referred to by this account summary
        #     Format: accounts/\\{account_id}
        #     Example: "accounts/1000"
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name for the account referred to in this account summary.
        # @!attribute [rw] property_summaries
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::PropertySummary>]
        #     List of summaries for child accounts of this account.
        class AccountSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A virtual resource representing metadata for a Google Analytics property.
        # @!attribute [rw] property
        #   @return [::String]
        #     Resource name of property referred to by this property summary
        #     Format: properties/\\{property_id}
        #     Example: "properties/1000"
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name for the property referred to in this property summary.
        # @!attribute [rw] property_type
        #   @return [::Google::Analytics::Admin::V1alpha::PropertyType]
        #     The property's property type.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Resource name of this property's logical parent.
        #
        #     Note: The Property-Moving UI can be used to change the parent.
        #     Format: accounts/\\{account}, properties/\\{property}
        #     Example: "accounts/100", "properties/200"
        class PropertySummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A secret value used for sending hits to Measurement Protocol.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this secret. This secret may be a child of
        #     any type of stream. Format:
        #     properties/\\{property}/dataStreams/\\{dataStream}/measurementProtocolSecrets/\\{measurementProtocolSecret}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Human-readable display name for this secret.
        # @!attribute [r] secret_value
        #   @return [::String]
        #     Output only. The measurement protocol secret value. Pass this value to the
        #     api_secret field of the Measurement Protocol API when sending hits to this
        #     secret's parent property.
        class MeasurementProtocolSecret
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SKAdNetwork conversion value schema of an iOS stream.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the schema. This will be child of ONLY an iOS
        #     stream, and there can be at most one such child under an iOS stream.
        #     Format:
        #     properties/\\{property}/dataStreams/\\{dataStream}/sKAdNetworkConversionValueSchema
        # @!attribute [rw] postback_window_one
        #   @return [::Google::Analytics::Admin::V1alpha::PostbackWindow]
        #     Required. The conversion value settings for the first postback window.
        #     These differ from values for postback window two and three in that they
        #     contain a "Fine" grained conversion value (a numeric value).
        #
        #     Conversion values for this postback window must be set.  The other windows
        #     are optional and may inherit this window's settings if unset or disabled.
        # @!attribute [rw] postback_window_two
        #   @return [::Google::Analytics::Admin::V1alpha::PostbackWindow]
        #     The conversion value settings for the second postback window.
        #
        #     This field should only be configured if there is a need to define different
        #     conversion values for this postback window.
        #
        #     If enable_postback_window_settings is set to false for this postback
        #     window, the values from postback_window_one will be used.
        # @!attribute [rw] postback_window_three
        #   @return [::Google::Analytics::Admin::V1alpha::PostbackWindow]
        #     The conversion value settings for the third postback window.
        #
        #     This field should only be set if the user chose to define different
        #     conversion values for this postback window. It is allowed to configure
        #     window 3 without setting window 2. In case window 1 & 2 settings are set
        #     and enable_postback_window_settings for this postback window is set to
        #     false, the schema will inherit settings from postback_window_two.
        # @!attribute [rw] apply_conversion_values
        #   @return [::Boolean]
        #     If enabled, the GA SDK will set conversion values using this schema
        #     definition, and schema will be exported to any Google Ads accounts linked
        #     to this property. If disabled, the GA SDK will not automatically set
        #     conversion values, and also the schema will not be exported to Ads.
        class SKAdNetworkConversionValueSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for a SKAdNetwork conversion postback window.
        # @!attribute [rw] conversion_values
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ConversionValues>]
        #     Ordering of the repeated field will be used to prioritize the conversion
        #     value settings. Lower indexed entries are prioritized higher. The first
        #     conversion value setting that evaluates to true will be selected. It must
        #     have at least one entry if enable_postback_window_settings is set to
        #     true. It can have maximum of 128 entries.
        # @!attribute [rw] postback_window_settings_enabled
        #   @return [::Boolean]
        #     If enable_postback_window_settings is true, conversion_values
        #     must be populated and will be used for determining when and how to set the
        #     Conversion Value on a client device and exporting schema to linked Ads
        #     accounts. If false, the settings are not used, but are retained in case
        #     they may be used in the future. This must always be true for
        #     postback_window_one.
        class PostbackWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Conversion value settings for a postback window for SKAdNetwork conversion
        # value schema.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name of the SKAdNetwork conversion value.
        #     The max allowed display name length is 50 UTF-16 code units.
        # @!attribute [rw] fine_value
        #   @return [::Integer]
        #     The fine-grained conversion value.  This is applicable only to the first
        #     postback window. Its valid values are [0,63], both inclusive. It must be
        #     set for postback window 1, and must not be set for postback window 2 & 3.
        #     This value is not guaranteed to be unique.
        #
        #     If the configuration for the first postback window is re-used for second or
        #     third postback windows this field has no effect.
        # @!attribute [rw] coarse_value
        #   @return [::Google::Analytics::Admin::V1alpha::CoarseValue]
        #     Required. A coarse grained conversion value.
        #
        #     This value is not guaranteed to be unique.
        # @!attribute [rw] event_mappings
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::EventMapping>]
        #     Event conditions that must be met for this Conversion Value to be achieved.
        #     The conditions in this list are ANDed together. It must have minimum of 1
        #     entry and maximum of 3 entries, if the postback window is enabled.
        # @!attribute [rw] lock_enabled
        #   @return [::Boolean]
        #     If true, the SDK should lock to this conversion value for the current
        #     postback window.
        class ConversionValues
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event setting conditions to match an event.
        # @!attribute [rw] event_name
        #   @return [::String]
        #     Required. Name of the Google Analytics event. It must always be set.
        #     The max allowed display name length is 40 UTF-16 code units.
        # @!attribute [rw] min_event_count
        #   @return [::Integer]
        #     At least one of the following four min/max values must be set. The
        #     values set will be ANDed together to qualify an event.
        #     The minimum number of times the event occurred. If not set, minimum event
        #     count won't be checked.
        # @!attribute [rw] max_event_count
        #   @return [::Integer]
        #     The maximum number of times the event occurred. If not set, maximum event
        #     count won't be checked.
        # @!attribute [rw] min_event_value
        #   @return [::Float]
        #     The minimum revenue generated due to the event. Revenue currency will be
        #     defined at the property level. If not set, minimum event value won't be
        #     checked.
        # @!attribute [rw] max_event_value
        #   @return [::Float]
        #     The maximum revenue generated due to the event. Revenue currency will be
        #     defined at the property level. If not set, maximum event value won't be
        #     checked.
        class EventMapping
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of changes within a Google Analytics account or its child properties
        # that resulted from the same cause. Common causes would be updates made in the
        # Google Analytics UI, changes from customer support, or automatic Google
        # Analytics system changes.
        # @!attribute [rw] id
        #   @return [::String]
        #     ID of this change history event. This ID is unique across Google Analytics.
        # @!attribute [rw] change_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when change was made.
        # @!attribute [rw] actor_type
        #   @return [::Google::Analytics::Admin::V1alpha::ActorType]
        #     The type of actor that made this change.
        # @!attribute [rw] user_actor_email
        #   @return [::String]
        #     Email address of the Google account that made the change. This will be a
        #     valid email address if the actor field is set to USER, and empty otherwise.
        #     Google accounts that have been deleted will cause an error.
        # @!attribute [rw] changes_filtered
        #   @return [::Boolean]
        #     If true, then the list of changes returned was filtered, and does not
        #     represent all changes that occurred in this event.
        # @!attribute [rw] changes
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ChangeHistoryChange>]
        #     A list of changes made in this change history event that fit the filters
        #     specified in SearchChangeHistoryEventsRequest.
        class ChangeHistoryEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A description of a change to a single Google Analytics resource.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Resource name of the resource whose changes are described by this entry.
        # @!attribute [rw] action
        #   @return [::Google::Analytics::Admin::V1alpha::ActionType]
        #     The type of action that changed this resource.
        # @!attribute [rw] resource_before_change
        #   @return [::Google::Analytics::Admin::V1alpha::ChangeHistoryChange::ChangeHistoryResource]
        #     Resource contents from before the change was made. If this resource was
        #     created in this change, this field will be missing.
        # @!attribute [rw] resource_after_change
        #   @return [::Google::Analytics::Admin::V1alpha::ChangeHistoryChange::ChangeHistoryResource]
        #     Resource contents from after the change was made. If this resource was
        #     deleted in this change, this field will be missing.
        class ChangeHistoryChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A snapshot of a resource as before or after the result of a change in
          # change history.
          # @!attribute [rw] account
          #   @return [::Google::Analytics::Admin::V1alpha::Account]
          #     A snapshot of an Account resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] property
          #   @return [::Google::Analytics::Admin::V1alpha::Property]
          #     A snapshot of a Property resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `property`, `account`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] firebase_link
          #   @return [::Google::Analytics::Admin::V1alpha::FirebaseLink]
          #     A snapshot of a FirebaseLink resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `firebase_link`, `account`, `property`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] google_ads_link
          #   @return [::Google::Analytics::Admin::V1alpha::GoogleAdsLink]
          #     A snapshot of a GoogleAdsLink resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `google_ads_link`, `account`, `property`, `firebase_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] google_signals_settings
          #   @return [::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings]
          #     A snapshot of a GoogleSignalsSettings resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `google_signals_settings`, `account`, `property`, `firebase_link`, `google_ads_link`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] display_video_360_advertiser_link
          #   @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
          #     A snapshot of a DisplayVideo360AdvertiserLink resource in change
          #     history.
          #
          #     Note: The following fields are mutually exclusive: `display_video_360_advertiser_link`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] display_video_360_advertiser_link_proposal
          #   @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal]
          #     A snapshot of a DisplayVideo360AdvertiserLinkProposal resource in
          #     change history.
          #
          #     Note: The following fields are mutually exclusive: `display_video_360_advertiser_link_proposal`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] conversion_event
          #   @return [::Google::Analytics::Admin::V1alpha::ConversionEvent]
          #     A snapshot of a ConversionEvent resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `conversion_event`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] measurement_protocol_secret
          #   @return [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
          #     A snapshot of a MeasurementProtocolSecret resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `measurement_protocol_secret`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] custom_dimension
          #   @return [::Google::Analytics::Admin::V1alpha::CustomDimension]
          #     A snapshot of a CustomDimension resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `custom_dimension`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] custom_metric
          #   @return [::Google::Analytics::Admin::V1alpha::CustomMetric]
          #     A snapshot of a CustomMetric resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `custom_metric`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] data_retention_settings
          #   @return [::Google::Analytics::Admin::V1alpha::DataRetentionSettings]
          #     A snapshot of a data retention settings resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `data_retention_settings`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] search_ads_360_link
          #   @return [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
          #     A snapshot of a SearchAds360Link resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `search_ads_360_link`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] data_stream
          #   @return [::Google::Analytics::Admin::V1alpha::DataStream]
          #     A snapshot of a DataStream resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `data_stream`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] attribution_settings
          #   @return [::Google::Analytics::Admin::V1alpha::AttributionSettings]
          #     A snapshot of AttributionSettings resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `attribution_settings`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] expanded_data_set
          #   @return [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
          #     A snapshot of an ExpandedDataSet resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `expanded_data_set`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] channel_group
          #   @return [::Google::Analytics::Admin::V1alpha::ChannelGroup]
          #     A snapshot of a ChannelGroup resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `channel_group`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] bigquery_link
          #   @return [::Google::Analytics::Admin::V1alpha::BigQueryLink]
          #     A snapshot of a BigQuery link resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `bigquery_link`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] enhanced_measurement_settings
          #   @return [::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings]
          #     A snapshot of EnhancedMeasurementSettings resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `enhanced_measurement_settings`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] data_redaction_settings
          #   @return [::Google::Analytics::Admin::V1alpha::DataRedactionSettings]
          #     A snapshot of DataRedactionSettings resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `data_redaction_settings`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] skadnetwork_conversion_value_schema
          #   @return [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
          #     A snapshot of SKAdNetworkConversionValueSchema resource in change
          #     history.
          #
          #     Note: The following fields are mutually exclusive: `skadnetwork_conversion_value_schema`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] adsense_link
          #   @return [::Google::Analytics::Admin::V1alpha::AdSenseLink]
          #     A snapshot of an AdSenseLink resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `adsense_link`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] audience
          #   @return [::Google::Analytics::Admin::V1alpha::Audience]
          #     A snapshot of an Audience resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `audience`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] event_create_rule
          #   @return [::Google::Analytics::Admin::V1alpha::EventCreateRule]
          #     A snapshot of an EventCreateRule resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `event_create_rule`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] key_event
          #   @return [::Google::Analytics::Admin::V1alpha::KeyEvent]
          #     A snapshot of a KeyEvent resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `key_event`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] calculated_metric
          #   @return [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
          #     A snapshot of a CalculatedMetric resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `calculated_metric`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `reporting_data_annotation`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] reporting_data_annotation
          #   @return [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
          #     A snapshot of a ReportingDataAnnotation resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `reporting_data_annotation`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `subproperty_sync_config`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] subproperty_sync_config
          #   @return [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig]
          #     A snapshot of a SubpropertySyncConfig resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `subproperty_sync_config`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `reporting_identity_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] reporting_identity_settings
          #   @return [::Google::Analytics::Admin::V1alpha::ReportingIdentitySettings]
          #     A snapshot of a ReportingIdentitySettings resource in change history.
          #
          #     Note: The following fields are mutually exclusive: `reporting_identity_settings`, `account`, `property`, `firebase_link`, `google_ads_link`, `google_signals_settings`, `display_video_360_advertiser_link`, `display_video_360_advertiser_link_proposal`, `conversion_event`, `measurement_protocol_secret`, `custom_dimension`, `custom_metric`, `data_retention_settings`, `search_ads_360_link`, `data_stream`, `attribution_settings`, `expanded_data_set`, `channel_group`, `bigquery_link`, `enhanced_measurement_settings`, `data_redaction_settings`, `skadnetwork_conversion_value_schema`, `adsense_link`, `audience`, `event_create_rule`, `key_event`, `calculated_metric`, `reporting_data_annotation`, `subproperty_sync_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ChangeHistoryResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A link between a Google Analytics property and a Display & Video 360
        # advertiser.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this DisplayVideo360AdvertiserLink
        #     resource. Format:
        #     properties/\\{propertyId}/displayVideo360AdvertiserLinks/\\{linkId}
        #
        #     Note: linkId is not the Display & Video 360 Advertiser ID
        # @!attribute [rw] advertiser_id
        #   @return [::String]
        #     Immutable. The Display & Video 360 Advertiser's advertiser ID.
        # @!attribute [r] advertiser_display_name
        #   @return [::String]
        #     Output only. The display name of the Display & Video 360 Advertiser.
        # @!attribute [rw] ads_personalization_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Enables personalized advertising features with this integration.
        #     If this field is not set on create/update, it will be defaulted to true.
        # @!attribute [rw] campaign_data_sharing_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Immutable. Enables the import of campaign data from Display & Video 360
        #     into the Google Analytics property. After link creation, this can only be
        #     updated from the Display & Video 360 product. If this field is not set on
        #     create, it will be defaulted to true.
        # @!attribute [rw] cost_data_sharing_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Immutable. Enables the import of cost data from Display & Video 360 into
        #     the Google Analytics property. This can only be enabled if
        #     `campaign_data_sharing_enabled` is true. After link creation, this can
        #     only be updated from the Display & Video 360 product. If this field is not
        #     set on create, it will be defaulted to true.
        class DisplayVideo360AdvertiserLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A proposal for a link between a Google Analytics property and a Display &
        # Video 360 advertiser.
        #
        # A proposal is converted to a DisplayVideo360AdvertiserLink once approved.
        # Google Analytics admins approve inbound proposals while Display & Video 360
        # admins approve outbound proposals.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this
        #     DisplayVideo360AdvertiserLinkProposal resource. Format:
        #     properties/\\{propertyId}/displayVideo360AdvertiserLinkProposals/\\{proposalId}
        #
        #     Note: proposalId is not the Display & Video 360 Advertiser ID
        # @!attribute [rw] advertiser_id
        #   @return [::String]
        #     Immutable. The Display & Video 360 Advertiser's advertiser ID.
        # @!attribute [r] link_proposal_status_details
        #   @return [::Google::Analytics::Admin::V1alpha::LinkProposalStatusDetails]
        #     Output only. The status information for this link proposal.
        # @!attribute [r] advertiser_display_name
        #   @return [::String]
        #     Output only. The display name of the Display & Video Advertiser.
        #     Only populated for proposals that originated from Display & Video 360.
        # @!attribute [rw] validation_email
        #   @return [::String]
        #     Input only. On a proposal being sent to Display & Video 360, this field
        #     must be set to the email address of an admin on the target advertiser. This
        #     is used to verify that the Google Analytics admin is aware of at least one
        #     admin on the Display & Video 360 Advertiser. This does not restrict
        #     approval of the proposal to a single user. Any admin on the Display & Video
        #     360 Advertiser may approve the proposal.
        # @!attribute [rw] ads_personalization_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Immutable. Enables personalized advertising features with this integration.
        #     If this field is not set on create, it will be defaulted to true.
        # @!attribute [rw] campaign_data_sharing_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Immutable. Enables the import of campaign data from Display & Video 360.
        #     If this field is not set on create, it will be defaulted to true.
        # @!attribute [rw] cost_data_sharing_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Immutable. Enables the import of cost data from Display & Video 360.
        #     This can only be enabled if campaign_data_sharing_enabled is enabled.
        #     If this field is not set on create, it will be defaulted to true.
        class DisplayVideo360AdvertiserLinkProposal
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A link between a Google Analytics property and a Search Ads 360 entity.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this SearchAds360Link resource.
        #     Format: properties/\\{propertyId}/searchAds360Links/\\{linkId}
        #
        #     Note: linkId is not the Search Ads 360 advertiser ID
        # @!attribute [rw] advertiser_id
        #   @return [::String]
        #     Immutable. This field represents the Advertiser ID of the Search Ads 360
        #     Advertiser. that has been linked.
        # @!attribute [rw] campaign_data_sharing_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Immutable. Enables the import of campaign data from Search Ads 360 into the
        #     Google Analytics property. After link creation, this can only be updated
        #     from the Search Ads 360 product. If this field is not set on create, it
        #     will be defaulted to true.
        # @!attribute [rw] cost_data_sharing_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Immutable. Enables the import of cost data from Search Ads 360 to the
        #     Google Analytics property. This can only be enabled if
        #     campaign_data_sharing_enabled is enabled. After link creation, this can
        #     only be updated from the Search Ads 360 product. If this field is not set
        #     on create, it will be defaulted to true.
        # @!attribute [r] advertiser_display_name
        #   @return [::String]
        #     Output only. The display name of the Search Ads 360 Advertiser.
        #     Allows users to easily identify the linked resource.
        # @!attribute [rw] ads_personalization_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Enables personalized advertising features with this integration.
        #     If this field is not set on create, it will be defaulted to true.
        # @!attribute [rw] site_stats_sharing_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Enables export of site stats with this integration.
        #     If this field is not set on create, it will be defaulted to true.
        class SearchAds360Link
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Status information for a link proposal.
        # @!attribute [r] link_proposal_initiating_product
        #   @return [::Google::Analytics::Admin::V1alpha::LinkProposalInitiatingProduct]
        #     Output only. The source of this proposal.
        # @!attribute [r] requestor_email
        #   @return [::String]
        #     Output only. The email address of the user that proposed this linkage.
        # @!attribute [r] link_proposal_state
        #   @return [::Google::Analytics::Admin::V1alpha::LinkProposalState]
        #     Output only. The state of this proposal.
        class LinkProposalStatusDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A conversion event in a Google Analytics property.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this conversion event.
        #     Format: properties/\\{property}/conversionEvents/\\{conversion_event}
        # @!attribute [rw] event_name
        #   @return [::String]
        #     Immutable. The event name for this conversion event.
        #     Examples: 'click', 'purchase'
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this conversion event was created in the property.
        # @!attribute [r] deletable
        #   @return [::Boolean]
        #     Output only. If set, this event can currently be deleted with
        #     DeleteConversionEvent.
        # @!attribute [r] custom
        #   @return [::Boolean]
        #     Output only. If set to true, this conversion event refers to a custom
        #     event.  If set to false, this conversion event refers to a default event in
        #     GA. Default events typically have special meaning in GA. Default events are
        #     usually created for you by the GA system, but in some cases can be created
        #     by property admins. Custom events count towards the maximum number of
        #     custom conversion events that may be created per property.
        # @!attribute [rw] counting_method
        #   @return [::Google::Analytics::Admin::V1alpha::ConversionEvent::ConversionCountingMethod]
        #     Optional. The method by which conversions will be counted across multiple
        #     events within a session. If this value is not provided, it will be set to
        #     `ONCE_PER_EVENT`.
        # @!attribute [rw] default_conversion_value
        #   @return [::Google::Analytics::Admin::V1alpha::ConversionEvent::DefaultConversionValue]
        #     Optional. Defines a default value/currency for a conversion event.
        class ConversionEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines a default value/currency for a conversion event. Both value and
          # currency must be provided.
          # @!attribute [rw] value
          #   @return [::Float]
          #     This value will be used to populate the value for all conversions
          #     of the specified event_name where the event "value" parameter is unset.
          # @!attribute [rw] currency_code
          #   @return [::String]
          #     When a conversion event for this event_name has no set currency,
          #     this currency will be applied as the default. Must be in ISO 4217
          #     currency code format. See https://en.wikipedia.org/wiki/ISO_4217 for
          #     more information.
          class DefaultConversionValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The method by which conversions will be counted across multiple events
          # within a session.
          module ConversionCountingMethod
            # Counting method not specified.
            CONVERSION_COUNTING_METHOD_UNSPECIFIED = 0

            # Each Event instance is considered a Conversion.
            ONCE_PER_EVENT = 1

            # An Event instance is considered a Conversion at most once per session per
            # user.
            ONCE_PER_SESSION = 2
          end
        end

        # A key event in a Google Analytics property.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this key event.
        #     Format: properties/\\{property}/keyEvents/\\{key_event}
        # @!attribute [rw] event_name
        #   @return [::String]
        #     Immutable. The event name for this key event.
        #     Examples: 'click', 'purchase'
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this key event was created in the property.
        # @!attribute [r] deletable
        #   @return [::Boolean]
        #     Output only. If set to true, this event can be deleted.
        # @!attribute [r] custom
        #   @return [::Boolean]
        #     Output only. If set to true, this key event refers to a custom event.  If
        #     set to false, this key event refers to a default event in GA. Default
        #     events typically have special meaning in GA. Default events are usually
        #     created for you by the GA system, but in some cases can be created by
        #     property admins. Custom events count towards the maximum number of
        #     custom key events that may be created per property.
        # @!attribute [rw] counting_method
        #   @return [::Google::Analytics::Admin::V1alpha::KeyEvent::CountingMethod]
        #     Required. The method by which Key Events will be counted across multiple
        #     events within a session.
        # @!attribute [rw] default_value
        #   @return [::Google::Analytics::Admin::V1alpha::KeyEvent::DefaultValue]
        #     Optional. Defines a default value/currency for a key event.
        class KeyEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines a default value/currency for a key event.
          # @!attribute [rw] numeric_value
          #   @return [::Float]
          #     Required. This will be used to populate the "value" parameter for all
          #     occurrences of this Key Event (specified by event_name) where that
          #     parameter is unset.
          # @!attribute [rw] currency_code
          #   @return [::String]
          #     Required. When an occurrence of this Key Event (specified by event_name)
          #     has no set currency this currency will be applied as the default. Must be
          #     in ISO 4217 currency code format.
          #
          #     See https://en.wikipedia.org/wiki/ISO_4217 for more information.
          class DefaultValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The method by which Key Events will be counted across multiple events
          # within a session.
          module CountingMethod
            # Counting method not specified.
            COUNTING_METHOD_UNSPECIFIED = 0

            # Each Event instance is considered a Key Event.
            ONCE_PER_EVENT = 1

            # An Event instance is considered a Key Event at most once per session per
            # user.
            ONCE_PER_SESSION = 2
          end
        end

        # Settings values for Google Signals.  This is a singleton resource.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this setting.
        #     Format: properties/\\{property_id}/googleSignalsSettings
        #     Example: "properties/1000/googleSignalsSettings"
        # @!attribute [rw] state
        #   @return [::Google::Analytics::Admin::V1alpha::GoogleSignalsState]
        #     Status of this setting.
        # @!attribute [r] consent
        #   @return [::Google::Analytics::Admin::V1alpha::GoogleSignalsConsent]
        #     Output only. Terms of Service acceptance.
        class GoogleSignalsSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A definition for a CustomDimension.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name for this CustomDimension resource.
        #     Format: properties/\\{property}/customDimensions/\\{customDimension}
        # @!attribute [rw] parameter_name
        #   @return [::String]
        #     Required. Immutable. Tagging parameter name for this custom dimension.
        #
        #     If this is a user-scoped dimension, then this is the user property name.
        #     If this is an event-scoped dimension, then this is the event parameter
        #     name.
        #
        #     If this is an item-scoped dimension, then this is the parameter
        #     name found in the eCommerce items array.
        #
        #     May only contain alphanumeric and underscore characters, starting with a
        #     letter. Max length of 24 characters for user-scoped dimensions, 40
        #     characters for event-scoped dimensions.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name for this custom dimension as shown in the Analytics
        #     UI. Max length of 82 characters, alphanumeric plus space and underscore
        #     starting with a letter. Legacy system-generated display names may contain
        #     square brackets, but updates to this field will never permit square
        #     brackets.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description for this custom dimension. Max length of 150
        #     characters.
        # @!attribute [rw] scope
        #   @return [::Google::Analytics::Admin::V1alpha::CustomDimension::DimensionScope]
        #     Required. Immutable. The scope of this dimension.
        # @!attribute [rw] disallow_ads_personalization
        #   @return [::Boolean]
        #     Optional. If set to true, sets this dimension as NPA and excludes it from
        #     ads personalization.
        #
        #     This is currently only supported by user-scoped custom dimensions.
        class CustomDimension
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid values for the scope of this dimension.
          module DimensionScope
            # Scope unknown or not specified.
            DIMENSION_SCOPE_UNSPECIFIED = 0

            # Dimension scoped to an event.
            EVENT = 1

            # Dimension scoped to a user.
            USER = 2

            # Dimension scoped to eCommerce items
            ITEM = 3
          end
        end

        # A definition for a custom metric.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name for this CustomMetric resource.
        #     Format: properties/\\{property}/customMetrics/\\{customMetric}
        # @!attribute [rw] parameter_name
        #   @return [::String]
        #     Required. Immutable. Tagging name for this custom metric.
        #
        #     If this is an event-scoped metric, then this is the event parameter
        #     name.
        #
        #     May only contain alphanumeric and underscore charactes, starting with a
        #     letter. Max length of 40 characters for event-scoped metrics.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name for this custom metric as shown in the Analytics UI.
        #     Max length of 82 characters, alphanumeric plus space and underscore
        #     starting with a letter. Legacy system-generated display names may contain
        #     square brackets, but updates to this field will never permit square
        #     brackets.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description for this custom dimension.
        #     Max length of 150 characters.
        # @!attribute [rw] measurement_unit
        #   @return [::Google::Analytics::Admin::V1alpha::CustomMetric::MeasurementUnit]
        #     Required. The type for the custom metric's value.
        # @!attribute [rw] scope
        #   @return [::Google::Analytics::Admin::V1alpha::CustomMetric::MetricScope]
        #     Required. Immutable. The scope of this custom metric.
        # @!attribute [rw] restricted_metric_type
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::CustomMetric::RestrictedMetricType>]
        #     Optional. Types of restricted data that this metric may contain. Required
        #     for metrics with CURRENCY measurement unit. Must be empty for metrics with
        #     a non-CURRENCY measurement unit.
        class CustomMetric
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible types of representing the custom metric's value.
          #
          # Currency representation may change in the future, requiring a breaking API
          # change.
          module MeasurementUnit
            # MeasurementUnit unspecified or missing.
            MEASUREMENT_UNIT_UNSPECIFIED = 0

            # This metric uses default units.
            STANDARD = 1

            # This metric measures a currency.
            CURRENCY = 2

            # This metric measures feet.
            FEET = 3

            # This metric measures meters.
            METERS = 4

            # This metric measures kilometers.
            KILOMETERS = 5

            # This metric measures miles.
            MILES = 6

            # This metric measures milliseconds.
            MILLISECONDS = 7

            # This metric measures seconds.
            SECONDS = 8

            # This metric measures minutes.
            MINUTES = 9

            # This metric measures hours.
            HOURS = 10
          end

          # The scope of this metric.
          module MetricScope
            # Scope unknown or not specified.
            METRIC_SCOPE_UNSPECIFIED = 0

            # Metric scoped to an event.
            EVENT = 1
          end

          # Labels that mark the data in this custom metric as data that should be
          # restricted to specific users.
          module RestrictedMetricType
            # Type unknown or unspecified.
            RESTRICTED_METRIC_TYPE_UNSPECIFIED = 0

            # Metric reports cost data.
            COST_DATA = 1

            # Metric reports revenue data.
            REVENUE_DATA = 2
          end
        end

        # A definition for a calculated metric.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name for this CalculatedMetric.
        #     Format: 'properties/\\{property_id}/calculatedMetrics/\\{calculated_metric_id}'
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description for this calculated metric.
        #     Max length of 4096 characters.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name for this calculated metric as shown in the
        #     Google Analytics UI. Max length 82 characters.
        # @!attribute [r] calculated_metric_id
        #   @return [::String]
        #     Output only. The ID to use for the calculated metric. In the UI, this is
        #     referred to as the "API name."
        #
        #     The calculated_metric_id is used when referencing this calculated metric
        #     from external APIs. For example, "calcMetric:\\{calculated_metric_id}".
        # @!attribute [rw] metric_unit
        #   @return [::Google::Analytics::Admin::V1alpha::CalculatedMetric::MetricUnit]
        #     Required. The type for the calculated metric's value.
        # @!attribute [r] restricted_metric_type
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::CalculatedMetric::RestrictedMetricType>]
        #     Output only. Types of restricted data that this metric contains.
        # @!attribute [rw] formula
        #   @return [::String]
        #     Required. The calculated metric's definition. Maximum number of unique
        #     referenced custom metrics is 5. Formulas supports the following operations:
        #     + (addition),  - (subtraction), - (negative),  * (multiplication), /
        #     (division), () (parenthesis). Any valid real numbers are acceptable that
        #     fit in a Long (64bit integer) or a Double (64 bit floating point number).
        #     Example formula:
        #       "( customEvent:parameter_name + cartPurchaseQuantity ) / 2.0"
        # @!attribute [r] invalid_metric_reference
        #   @return [::Boolean]
        #     Output only. If true, this calculated metric has a invalid metric
        #     reference. Anything using a calculated metric with invalid_metric_reference
        #     set to true may fail, produce warnings, or produce unexpected results.
        class CalculatedMetric
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible types of representing the calculated metric's value.
          module MetricUnit
            # MetricUnit unspecified or missing.
            METRIC_UNIT_UNSPECIFIED = 0

            # This metric uses default units.
            STANDARD = 1

            # This metric measures a currency.
            CURRENCY = 2

            # This metric measures feet.
            FEET = 3

            # This metric measures miles.
            MILES = 4

            # This metric measures meters.
            METERS = 5

            # This metric measures kilometers.
            KILOMETERS = 6

            # This metric measures milliseconds.
            MILLISECONDS = 7

            # This metric measures seconds.
            SECONDS = 8

            # This metric measures minutes.
            MINUTES = 9

            # This metric measures hours.
            HOURS = 10
          end

          # Labels that mark the data in calculated metric used in conjunction with
          # user roles that restrict access to cost and/or revenue metrics.
          module RestrictedMetricType
            # Type unknown or unspecified.
            RESTRICTED_METRIC_TYPE_UNSPECIFIED = 0

            # Metric reports cost data.
            COST_DATA = 1

            # Metric reports revenue data.
            REVENUE_DATA = 2
          end
        end

        # Settings values for data retention. This is a singleton resource.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name for this DataRetentionSetting resource.
        #     Format: properties/\\{property}/dataRetentionSettings
        # @!attribute [rw] event_data_retention
        #   @return [::Google::Analytics::Admin::V1alpha::DataRetentionSettings::RetentionDuration]
        #     Required. The length of time that event-level data is retained.
        # @!attribute [rw] user_data_retention
        #   @return [::Google::Analytics::Admin::V1alpha::DataRetentionSettings::RetentionDuration]
        #     Required. The length of time that user-level data is retained.
        # @!attribute [rw] reset_user_data_on_new_activity
        #   @return [::Boolean]
        #     If true, reset the retention period for the user identifier with every
        #     event from that user.
        class DataRetentionSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid values for the data retention duration.
          module RetentionDuration
            # Data retention time duration is not specified.
            RETENTION_DURATION_UNSPECIFIED = 0

            # The data retention time duration is 2 months.
            TWO_MONTHS = 1

            # The data retention time duration is 14 months.
            FOURTEEN_MONTHS = 3

            # The data retention time duration is 26 months.
            # Available to 360 properties only. Available for event data only.
            TWENTY_SIX_MONTHS = 4

            # The data retention time duration is 38 months.
            # Available to 360 properties only. Available for event data only.
            THIRTY_EIGHT_MONTHS = 5

            # The data retention time duration is 50 months.
            # Available to 360 properties only. Available for event data only.
            FIFTY_MONTHS = 6
          end
        end

        # The attribution settings used for a given property. This is a singleton
        # resource.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this attribution settings resource.
        #     Format: properties/\\{property_id}/attributionSettings
        #     Example: "properties/1000/attributionSettings"
        # @!attribute [rw] acquisition_conversion_event_lookback_window
        #   @return [::Google::Analytics::Admin::V1alpha::AttributionSettings::AcquisitionConversionEventLookbackWindow]
        #     Required. The lookback window configuration for acquisition conversion
        #     events. The default window size is 30 days.
        # @!attribute [rw] other_conversion_event_lookback_window
        #   @return [::Google::Analytics::Admin::V1alpha::AttributionSettings::OtherConversionEventLookbackWindow]
        #     Required. The lookback window for all other, non-acquisition conversion
        #     events. The default window size is 90 days.
        # @!attribute [rw] reporting_attribution_model
        #   @return [::Google::Analytics::Admin::V1alpha::AttributionSettings::ReportingAttributionModel]
        #     Required. The reporting attribution model used to calculate conversion
        #     credit in this property's reports.
        #
        #     Changing the attribution model will apply to both historical and future
        #     data. These changes will be reflected in reports with conversion and
        #     revenue data. User and session data will be unaffected.
        # @!attribute [rw] ads_web_conversion_data_export_scope
        #   @return [::Google::Analytics::Admin::V1alpha::AttributionSettings::AdsWebConversionDataExportScope]
        #     Required. The Conversion Export Scope for data exported to linked Ads
        #     Accounts.
        class AttributionSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # How far back in time events should be considered for inclusion in a
          # converting path which leads to the first install of an app or the first
          # visit to a site.
          module AcquisitionConversionEventLookbackWindow
            # Lookback window size unspecified.
            ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED = 0

            # 7-day lookback window.
            ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_7_DAYS = 1

            # 30-day lookback window.
            ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS = 2
          end

          # How far back in time events should be considered for inclusion in a
          # converting path for all conversions other than first app install/first site
          # visit.
          module OtherConversionEventLookbackWindow
            # Lookback window size unspecified.
            OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED = 0

            # 30-day lookback window.
            OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS = 1

            # 60-day lookback window.
            OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_60_DAYS = 2

            # 90-day lookback window.
            OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_90_DAYS = 3
          end

          # The reporting attribution model used to calculate conversion credit in this
          # property's reports.
          module ReportingAttributionModel
            # Reporting attribution model unspecified.
            REPORTING_ATTRIBUTION_MODEL_UNSPECIFIED = 0

            # Data-driven attribution distributes credit for the conversion based on
            # data for each conversion event. Each Data-driven model is specific to
            # each advertiser and each conversion event.
            # Previously CROSS_CHANNEL_DATA_DRIVEN
            PAID_AND_ORGANIC_CHANNELS_DATA_DRIVEN = 1

            # Ignores direct traffic and attributes 100% of the conversion value to the
            # last channel that the customer clicked through (or engaged view through
            # for YouTube) before converting.
            # Previously CROSS_CHANNEL_LAST_CLICK
            PAID_AND_ORGANIC_CHANNELS_LAST_CLICK = 2

            # Attributes 100% of the conversion value to the last Google Paid channel
            # that the customer clicked through before converting.
            # Previously ADS_PREFERRED_LAST_CLICK
            GOOGLE_PAID_CHANNELS_LAST_CLICK = 7
          end

          # The Conversion Export Scope for data exported to linked Ads Accounts.
          module AdsWebConversionDataExportScope
            # Default value. This value is unused.
            ADS_WEB_CONVERSION_DATA_EXPORT_SCOPE_UNSPECIFIED = 0

            # No data export scope selected yet.
            # Export scope can never be changed back to this value.
            NOT_SELECTED_YET = 1

            # Paid and organic channels are eligible to receive conversion credit, but
            # only credit assigned to Google Ads channels will appear in your Ads
            # accounts. To learn more, see [Paid and Organic
            # channels](https://support.google.com/analytics/answer/10632359).
            PAID_AND_ORGANIC_CHANNELS = 2

            # Only Google Ads paid channels are eligible to receive conversion credit.
            # To learn more, see [Google Paid
            # channels](https://support.google.com/analytics/answer/10632359).
            GOOGLE_PAID_CHANNELS = 3
          end
        end

        # A binding of a user to a set of roles.
        # @!attribute [rw] user
        #   @return [::String]
        #     If set, the email address of the user to set roles for.
        #     Format: "someuser@gmail.com"
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this binding.
        #
        #     Format: accounts/\\{account}/accessBindings/\\{access_binding} or
        #     properties/\\{property}/accessBindings/\\{access_binding}
        #
        #     Example:
        #     "accounts/100/accessBindings/200"
        # @!attribute [rw] roles
        #   @return [::Array<::String>]
        #     A list of roles for to grant to the parent resource.
        #
        #     Valid values:
        #     predefinedRoles/viewer
        #     predefinedRoles/analyst
        #     predefinedRoles/editor
        #     predefinedRoles/admin
        #     predefinedRoles/no-cost-data
        #     predefinedRoles/no-revenue-data
        #
        #     For users, if an empty list of roles is set, this AccessBinding will be
        #     deleted.
        class AccessBinding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A link between a Google Analytics property and BigQuery project.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this BigQuery link.
        #     Format: 'properties/\\{property_id}/bigQueryLinks/\\{bigquery_link_id}'
        #     Format: 'properties/1234/bigQueryLinks/abc567'
        # @!attribute [rw] project
        #   @return [::String]
        #     Immutable. The linked Google Cloud project. When creating a BigQueryLink,
        #     you may provide this resource name using either a project number or project
        #     ID. Once this resource has been created, the returned project will always
        #     have a project that contains a project number.
        #     Format: 'projects/\\{project number}'
        #     Example: 'projects/1234'
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the link was created.
        # @!attribute [rw] daily_export_enabled
        #   @return [::Boolean]
        #     If set true, enables daily data export to the linked Google Cloud project.
        # @!attribute [rw] streaming_export_enabled
        #   @return [::Boolean]
        #     If set true, enables streaming export to the linked Google Cloud project.
        # @!attribute [rw] fresh_daily_export_enabled
        #   @return [::Boolean]
        #     If set true, enables fresh daily export to the linked Google Cloud project.
        # @!attribute [rw] include_advertising_id
        #   @return [::Boolean]
        #     If set true, exported data will include advertising identifiers for mobile
        #     app streams.
        # @!attribute [rw] export_streams
        #   @return [::Array<::String>]
        #     The list of streams under the parent property for which data will be
        #     exported.
        #     Format: properties/\\{property_id}/dataStreams/\\{stream_id}
        #     Example: ['properties/1000/dataStreams/2000']
        # @!attribute [rw] excluded_events
        #   @return [::Array<::String>]
        #     The list of event names that will be excluded from exports.
        # @!attribute [rw] dataset_location
        #   @return [::String]
        #     Required. Immutable. The geographic location where the created BigQuery
        #     dataset should reside. See https://cloud.google.com/bigquery/docs/locations
        #     for supported locations.
        class BigQueryLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Singleton resource under a web DataStream, configuring measurement of
        # additional site interactions and content.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the Enhanced Measurement Settings.
        #     Format:
        #     properties/\\{property_id}/dataStreams/\\{data_stream}/enhancedMeasurementSettings
        #     Example: "properties/1000/dataStreams/2000/enhancedMeasurementSettings"
        # @!attribute [rw] stream_enabled
        #   @return [::Boolean]
        #     Indicates whether Enhanced Measurement Settings will be used to
        #     automatically measure interactions and content on this web stream.
        #
        #     Changing this value does not affect the settings themselves, but determines
        #     whether they are respected.
        # @!attribute [rw] scrolls_enabled
        #   @return [::Boolean]
        #     If enabled, capture scroll events each time a visitor gets to the bottom of
        #     a page.
        # @!attribute [rw] outbound_clicks_enabled
        #   @return [::Boolean]
        #     If enabled, capture an outbound click event each time a visitor clicks a
        #     link that leads them away from your domain.
        # @!attribute [rw] site_search_enabled
        #   @return [::Boolean]
        #     If enabled, capture a view search results event each time a visitor
        #     performs a search on your site (based on a query parameter).
        # @!attribute [rw] video_engagement_enabled
        #   @return [::Boolean]
        #     If enabled, capture video play, progress, and complete events as visitors
        #     view embedded videos on your site.
        # @!attribute [rw] file_downloads_enabled
        #   @return [::Boolean]
        #     If enabled, capture a file download event each time a link is clicked with
        #     a common document, compressed file, application, video, or audio extension.
        # @!attribute [rw] page_changes_enabled
        #   @return [::Boolean]
        #     If enabled, capture a page view event each time the website changes the
        #     browser history state.
        # @!attribute [rw] form_interactions_enabled
        #   @return [::Boolean]
        #     If enabled, capture a form interaction event each time a visitor interacts
        #     with a form on your website.
        #     False by default.
        # @!attribute [rw] search_query_parameter
        #   @return [::String]
        #     Required. URL query parameters to interpret as site search parameters.
        #     Max length is 1024 characters. Must not be empty.
        # @!attribute [rw] uri_query_parameter
        #   @return [::String]
        #     Additional URL query parameters.
        #     Max length is 1024 characters.
        class EnhancedMeasurementSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for client-side data redaction. Singleton resource under a Web
        # Stream.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of this Data Redaction Settings resource.
        #     Format:
        #     properties/\\{property_id}/dataStreams/\\{data_stream}/dataRedactionSettings
        #     Example: "properties/1000/dataStreams/2000/dataRedactionSettings"
        # @!attribute [rw] email_redaction_enabled
        #   @return [::Boolean]
        #     If enabled, any event parameter or user property values that look like an
        #     email will be redacted.
        # @!attribute [rw] query_parameter_redaction_enabled
        #   @return [::Boolean]
        #     Query Parameter redaction removes the key and value portions of a
        #     query parameter if it is in the configured set of query parameters.
        #
        #     If enabled, URL query replacement logic will be run for the Stream. Any
        #     query parameters defined in query_parameter_keys will be redacted.
        # @!attribute [rw] query_parameter_keys
        #   @return [::Array<::String>]
        #     The query parameter keys to apply redaction logic to if present in the URL.
        #     Query parameter matching is case-insensitive.
        #
        #     Must contain at least one element if query_parameter_replacement_enabled
        #     is true. Keys cannot contain commas.
        class DataRedactionSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A link between a Google Analytics property and an AdSense for Content ad
        # client.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this AdSense Link resource.
        #     Format: properties/\\{propertyId}/adSenseLinks/\\{linkId}
        #     Example: properties/1234/adSenseLinks/6789
        # @!attribute [rw] ad_client_code
        #   @return [::String]
        #     Immutable. The AdSense ad client code that the Google Analytics property is
        #     linked to. Example format: "ca-pub-1234567890"
        class AdSenseLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A link that references a source property under the parent rollup property.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of this RollupPropertySourceLink.
        #     Format:
        #     'properties/\\{property_id}/rollupPropertySourceLinks/\\{rollup_property_source_link}'
        #     Format: 'properties/123/rollupPropertySourceLinks/456'
        # @!attribute [rw] source_property
        #   @return [::String]
        #     Immutable. Resource name of the source property.
        #     Format: properties/\\{property_id}
        #     Example: "properties/789"
        class RollupPropertySourceLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Reporting Data Annotation is a comment connected to certain dates for
        # reporting data.
        # @!attribute [rw] annotation_date
        #   @return [::Google::Type::Date]
        #     If set, the Reporting Data Annotation is for a specific date represented
        #     by this field. The date must be a valid date with year, month and day
        #     set. The date may be in the past, present, or future.
        #
        #     Note: The following fields are mutually exclusive: `annotation_date`, `annotation_date_range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] annotation_date_range
        #   @return [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation::DateRange]
        #     If set, the Reporting Data Annotation is for a range of dates represented
        #     by this field.
        #
        #     Note: The following fields are mutually exclusive: `annotation_date_range`, `annotation_date`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Identifier. Resource name of this Reporting Data Annotation.
        #     Format:
        #     'properties/\\{property_id}/reportingDataAnnotations/\\{reporting_data_annotation}'
        #     Format: 'properties/123/reportingDataAnnotations/456'
        # @!attribute [rw] title
        #   @return [::String]
        #     Required. Human-readable title for this Reporting Data Annotation.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description for this Reporting Data Annotation.
        # @!attribute [rw] color
        #   @return [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation::Color]
        #     Required. The color used for display of this Reporting Data Annotation.
        # @!attribute [r] system_generated
        #   @return [::Boolean]
        #     Output only. If true, this annotation was generated by the Google Analytics
        #     system. System-generated annotations cannot be updated or deleted.
        class ReportingDataAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a Reporting Data Annotation's date range, both start and end
          # dates are inclusive. Time zones are based on the parent property.
          # @!attribute [rw] start_date
          #   @return [::Google::Type::Date]
          #     Required. The start date for this range. Must be a valid date with
          #     year, month, and day set. The date may be in the past, present, or
          #     future.
          # @!attribute [rw] end_date
          #   @return [::Google::Type::Date]
          #     Required. The end date for this range. Must be a valid date with
          #     year, month, and day set. This date must be greater than or equal to
          #     the start date.
          class DateRange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Colors that may be used for this Reporting Data Annotation
          module Color
            # Color unknown or not specified.
            COLOR_UNSPECIFIED = 0

            # Purple color.
            PURPLE = 1

            # Brown color.
            BROWN = 2

            # Blue color.
            BLUE = 3

            # Green color.
            GREEN = 4

            # Red color.
            RED = 5

            # Cyan color.
            CYAN = 6

            # Orange color. (Only used for system-generated annotations)
            ORANGE = 7
          end
        end

        # Subproperty synchronization configuration controls how ordinary property
        # configurations are synchronized to subproperties. This resource is
        # provisioned automatically for each subproperty.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Format:
        #     properties/\\{ordinary_property_id}/subpropertySyncConfigs/\\{subproperty_id}
        #     Example: properties/1234/subpropertySyncConfigs/5678
        # @!attribute [r] apply_to_property
        #   @return [::String]
        #     Output only. Immutable. Resource name of the subproperty that these
        #     settings apply to.
        # @!attribute [rw] custom_dimension_and_metric_sync_mode
        #   @return [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig::SynchronizationMode]
        #     Required. Specifies the Custom Dimension / Metric synchronization mode for
        #     the subproperty.
        #
        #     If set to ALL, Custom Dimension / Metric synchronization will be
        #     immediately enabled.  Local configuration of Custom Dimensions / Metrics
        #     will not be allowed on the subproperty so long as the synchronization mode
        #     is set to ALL.
        #
        #     If set to NONE, Custom Dimensions / Metric synchronization is disabled.
        #     Custom Dimensions / Metrics must be configured explicitly on the
        #     Subproperty.
        class SubpropertySyncConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Synchronization modes for a subproperty
          module SynchronizationMode
            # Synchronization mode unknown or not specified.
            SYNCHRONIZATION_MODE_UNSPECIFIED = 0

            # Entities are not synchronized.
            # Local edits are allowed on the subproperty.
            NONE = 1

            # Entities are synchronized from parent property.
            # Local mutations are not allowed on the subproperty (Create / Update /
            # Delete)
            ALL = 2
          end
        end

        # A resource containing settings related to reporting identity.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Resource name for this reporting identity settings
        #     singleton resource. Format:
        #     properties/\\{property_id}/reportingIdentitySettings Example:
        #     "properties/1234/reportingIdentitySettings"
        # @!attribute [rw] reporting_identity
        #   @return [::Google::Analytics::Admin::V1alpha::ReportingIdentitySettings::ReportingIdentity]
        #     The strategy used for identifying user identities in reports.
        class ReportingIdentitySettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Various strategies for identifying user identities in reports.
          module ReportingIdentity
            # Unspecified blending strategy.
            IDENTITY_BLENDING_STRATEGY_UNSPECIFIED = 0

            # Blended reporting identity strategy.
            BLENDED = 1

            # Observed reporting identity strategy.
            OBSERVED = 2

            # Device-based reporting identity strategy.
            DEVICE_BASED = 3
          end
        end

        # The category selected for this property, used for industry benchmarking.
        module IndustryCategory
          # Industry category unspecified
          INDUSTRY_CATEGORY_UNSPECIFIED = 0

          # Automotive
          AUTOMOTIVE = 1

          # Business and industrial markets
          BUSINESS_AND_INDUSTRIAL_MARKETS = 2

          # Finance
          FINANCE = 3

          # Healthcare
          HEALTHCARE = 4

          # Technology
          TECHNOLOGY = 5

          # Travel
          TRAVEL = 6

          # Other
          OTHER = 7

          # Arts and entertainment
          ARTS_AND_ENTERTAINMENT = 8

          # Beauty and fitness
          BEAUTY_AND_FITNESS = 9

          # Books and literature
          BOOKS_AND_LITERATURE = 10

          # Food and drink
          FOOD_AND_DRINK = 11

          # Games
          GAMES = 12

          # Hobbies and leisure
          HOBBIES_AND_LEISURE = 13

          # Home and garden
          HOME_AND_GARDEN = 14

          # Internet and telecom
          INTERNET_AND_TELECOM = 15

          # Law and government
          LAW_AND_GOVERNMENT = 16

          # News
          NEWS = 17

          # Online communities
          ONLINE_COMMUNITIES = 18

          # People and society
          PEOPLE_AND_SOCIETY = 19

          # Pets and animals
          PETS_AND_ANIMALS = 20

          # Real estate
          REAL_ESTATE = 21

          # Reference
          REFERENCE = 22

          # Science
          SCIENCE = 23

          # Sports
          SPORTS = 24

          # Jobs and education
          JOBS_AND_EDUCATION = 25

          # Shopping
          SHOPPING = 26
        end

        # Various levels of service for Google Analytics.
        module ServiceLevel
          # Service level not specified or invalid.
          SERVICE_LEVEL_UNSPECIFIED = 0

          # The standard version of Google Analytics.
          GOOGLE_ANALYTICS_STANDARD = 1

          # The paid, premium version of Google Analytics.
          GOOGLE_ANALYTICS_360 = 2
        end

        # Different kinds of actors that can make changes to Google Analytics
        # resources.
        module ActorType
          # Unknown or unspecified actor type.
          ACTOR_TYPE_UNSPECIFIED = 0

          # Changes made by the user specified in actor_email.
          USER = 1

          # Changes made by the Google Analytics system.
          SYSTEM = 2

          # Changes made by Google Analytics support team staff.
          SUPPORT = 3
        end

        # Types of actions that may change a resource.
        module ActionType
          # Action type unknown or not specified.
          ACTION_TYPE_UNSPECIFIED = 0

          # Resource was created in this change.
          CREATED = 1

          # Resource was updated in this change.
          UPDATED = 2

          # Resource was deleted in this change.
          DELETED = 3
        end

        # Types of resources whose changes may be returned from change history.
        module ChangeHistoryResourceType
          # Resource type unknown or not specified.
          CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED = 0

          # Account resource
          ACCOUNT = 1

          # Property resource
          PROPERTY = 2

          # FirebaseLink resource
          FIREBASE_LINK = 6

          # GoogleAdsLink resource
          GOOGLE_ADS_LINK = 7

          # GoogleSignalsSettings resource
          GOOGLE_SIGNALS_SETTINGS = 8

          # ConversionEvent resource
          CONVERSION_EVENT = 9

          # MeasurementProtocolSecret resource
          MEASUREMENT_PROTOCOL_SECRET = 10

          # CustomDimension resource
          CUSTOM_DIMENSION = 11

          # CustomMetric resource
          CUSTOM_METRIC = 12

          # DataRetentionSettings resource
          DATA_RETENTION_SETTINGS = 13

          # DisplayVideo360AdvertiserLink resource
          DISPLAY_VIDEO_360_ADVERTISER_LINK = 14

          # DisplayVideo360AdvertiserLinkProposal resource
          DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL = 15

          # SearchAds360Link resource
          SEARCH_ADS_360_LINK = 16

          # DataStream resource
          DATA_STREAM = 18

          # AttributionSettings resource
          ATTRIBUTION_SETTINGS = 20

          # ExpandedDataSet resource
          EXPANDED_DATA_SET = 21

          # ChannelGroup resource
          CHANNEL_GROUP = 22

          # BigQuery link resource
          BIGQUERY_LINK = 23

          # EnhancedMeasurementSettings resource
          ENHANCED_MEASUREMENT_SETTINGS = 24

          # DataRedactionSettings resource
          DATA_REDACTION_SETTINGS = 25

          # SKAdNetworkConversionValueSchema resource
          SKADNETWORK_CONVERSION_VALUE_SCHEMA = 26

          # AdSenseLink resource
          ADSENSE_LINK = 27

          # Audience resource
          AUDIENCE = 28

          # EventCreateRule resource
          EVENT_CREATE_RULE = 29

          # KeyEvent resource
          KEY_EVENT = 30

          # CalculatedMetric resource
          CALCULATED_METRIC = 31

          # ReportingDataAnnotation resource
          REPORTING_DATA_ANNOTATION = 32

          # SubpropertySyncConfig resource
          SUBPROPERTY_SYNC_CONFIG = 33

          # ReportingIdentitySettings resource
          REPORTING_IDENTITY_SETTINGS = 34
        end

        # Status of the Google Signals settings.
        module GoogleSignalsState
          # Google Signals status defaults to GOOGLE_SIGNALS_STATE_UNSPECIFIED to
          # represent that the user has not made an explicit choice.
          GOOGLE_SIGNALS_STATE_UNSPECIFIED = 0

          # Google Signals is enabled.
          GOOGLE_SIGNALS_ENABLED = 1

          # Google Signals is disabled.
          GOOGLE_SIGNALS_DISABLED = 2
        end

        # Consent field of the Google Signals settings.
        module GoogleSignalsConsent
          # Google Signals consent value defaults to
          # GOOGLE_SIGNALS_CONSENT_UNSPECIFIED.  This will be treated as
          # GOOGLE_SIGNALS_CONSENT_NOT_CONSENTED.
          GOOGLE_SIGNALS_CONSENT_UNSPECIFIED = 0

          # Terms of service have been accepted
          GOOGLE_SIGNALS_CONSENT_CONSENTED = 2

          # Terms of service have not been accepted
          GOOGLE_SIGNALS_CONSENT_NOT_CONSENTED = 1
        end

        # An indication of which product the user initiated a link proposal from.
        module LinkProposalInitiatingProduct
          # Unspecified product.
          LINK_PROPOSAL_INITIATING_PRODUCT_UNSPECIFIED = 0

          # This proposal was created by a user from Google Analytics.
          GOOGLE_ANALYTICS = 1

          # This proposal was created by a user from a linked product (not Google
          # Analytics).
          LINKED_PRODUCT = 2
        end

        # The state of a link proposal resource.
        module LinkProposalState
          # Unspecified state
          LINK_PROPOSAL_STATE_UNSPECIFIED = 0

          # This proposal is awaiting review from a Google Analytics user. This
          # proposal will automatically expire after some time.
          AWAITING_REVIEW_FROM_GOOGLE_ANALYTICS = 1

          # This proposal is awaiting review from a user of a linked product. This
          # proposal will automatically expire after some time.
          AWAITING_REVIEW_FROM_LINKED_PRODUCT = 2

          # This proposal has been withdrawn by an admin on the initiating product.
          # This proposal will be automatically deleted after some time.
          WITHDRAWN = 3

          # This proposal has been declined by an admin on the receiving product. This
          # proposal will be automatically deleted after some time.
          DECLINED = 4

          # This proposal expired due to lack of response from an admin on the
          # receiving product. This proposal will be automatically deleted after some
          # time.
          EXPIRED = 5

          # This proposal has become obsolete because a link was directly created to
          # the same external product resource that this proposal specifies. This
          # proposal will be automatically deleted after some time.
          OBSOLETE = 6
        end

        # Types of `Property` resources.
        module PropertyType
          # Unknown or unspecified property type
          PROPERTY_TYPE_UNSPECIFIED = 0

          # Ordinary Google Analytics property
          PROPERTY_TYPE_ORDINARY = 1

          # Google Analytics subproperty
          PROPERTY_TYPE_SUBPROPERTY = 2

          # Google Analytics rollup property
          PROPERTY_TYPE_ROLLUP = 3
        end

        # The coarse conversion value set on the updatePostbackConversionValue SDK call
        # when a ConversionValues.event_mappings conditions are satisfied. For
        # more information, see
        # [SKAdNetwork.CoarseConversionValue](https://developer.apple.com/documentation/storekit/skadnetwork/coarseconversionvalue).
        module CoarseValue
          # Coarse value not specified.
          COARSE_VALUE_UNSPECIFIED = 0

          # Coarse value of low.
          COARSE_VALUE_LOW = 1

          # Coarse value of medium.
          COARSE_VALUE_MEDIUM = 2

          # Coarse value of high.
          COARSE_VALUE_HIGH = 3
        end
      end
    end
  end
end
