# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Analytics
    module Admin
      module V1alpha
        # A specific filter for a single dimension or metric.
        # @!attribute [rw] string_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::StringFilter]
        #     A filter for a string-type dimension that matches a particular pattern.
        #
        #     Note: The following fields are mutually exclusive: `string_filter`, `in_list_filter`, `numeric_filter`, `between_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] in_list_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::InListFilter]
        #     A filter for a string dimension that matches a particular list of
        #     options.
        #
        #     Note: The following fields are mutually exclusive: `in_list_filter`, `string_filter`, `numeric_filter`, `between_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] numeric_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::NumericFilter]
        #     A filter for numeric or date values on a dimension or metric.
        #
        #     Note: The following fields are mutually exclusive: `numeric_filter`, `string_filter`, `in_list_filter`, `between_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] between_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::BetweenFilter]
        #     A filter for numeric or date values between certain values on a dimension
        #     or metric.
        #
        #     Note: The following fields are mutually exclusive: `between_filter`, `string_filter`, `in_list_filter`, `numeric_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] field_name
        #   @return [::String]
        #     Required. Immutable. The dimension name or metric name to filter. If the
        #     field name refers to a custom dimension or metric, a scope prefix will be
        #     added to the front of the custom dimensions or metric name. For more on
        #     scope prefixes or custom dimensions/metrics, reference the [Google
        #     Analytics Data API documentation]
        #     (https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#custom_dimensions).
        # @!attribute [rw] at_any_point_in_time
        #   @return [::Boolean]
        #     Optional. Indicates whether this filter needs dynamic evaluation or not. If
        #     set to true, users join the Audience if they ever met the condition (static
        #     evaluation). If unset or set to false, user evaluation for an Audience is
        #     dynamic; users are added to an Audience when they meet the conditions and
        #     then removed when they no longer meet them.
        #
        #     This can only be set when Audience scope is ACROSS_ALL_SESSIONS.
        # @!attribute [rw] in_any_n_day_period
        #   @return [::Integer]
        #     Optional. If set, specifies the time window for which to evaluate data in
        #     number of days. If not set, then audience data is evaluated against
        #     lifetime data (For example, infinite time window).
        #
        #     For example, if set to 1 day, only the current day's data is evaluated. The
        #     reference point is the current day when at_any_point_in_time is unset or
        #     false.
        #
        #     It can only be set when Audience scope is ACROSS_ALL_SESSIONS and cannot be
        #     greater than 60 days.
        class AudienceDimensionOrMetricFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A filter for a string-type dimension that matches a particular pattern.
          # @!attribute [rw] match_type
          #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::StringFilter::MatchType]
          #     Required. The match type for the string filter.
          # @!attribute [rw] value
          #   @return [::String]
          #     Required. The string value to be matched against.
          # @!attribute [rw] case_sensitive
          #   @return [::Boolean]
          #     Optional. If true, the match is case-sensitive. If false, the match is
          #     case-insensitive.
          class StringFilter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The match type for the string filter.
            module MatchType
              # Unspecified
              MATCH_TYPE_UNSPECIFIED = 0

              # Exact match of the string value.
              EXACT = 1

              # Begins with the string value.
              BEGINS_WITH = 2

              # Ends with the string value.
              ENDS_WITH = 3

              # Contains the string value.
              CONTAINS = 4

              # Full regular expression matches with the string value.
              FULL_REGEXP = 5
            end
          end

          # A filter for a string dimension that matches a particular list of options.
          # @!attribute [rw] values
          #   @return [::Array<::String>]
          #     Required. The list of possible string values to match against. Must be
          #     non-empty.
          # @!attribute [rw] case_sensitive
          #   @return [::Boolean]
          #     Optional. If true, the match is case-sensitive. If false, the match is
          #     case-insensitive.
          class InListFilter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # To represent a number.
          # @!attribute [rw] int64_value
          #   @return [::Integer]
          #     Integer value.
          #
          #     Note: The following fields are mutually exclusive: `int64_value`, `double_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] double_value
          #   @return [::Float]
          #     Double value.
          #
          #     Note: The following fields are mutually exclusive: `double_value`, `int64_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class NumericValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A filter for numeric or date values on a dimension or metric.
          # @!attribute [rw] operation
          #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::NumericFilter::Operation]
          #     Required. The operation applied to a numeric filter.
          # @!attribute [rw] value
          #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::NumericValue]
          #     Required. The numeric or date value to match against.
          class NumericFilter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The operation applied to a numeric filter.
            module Operation
              # Unspecified.
              OPERATION_UNSPECIFIED = 0

              # Equal.
              EQUAL = 1

              # Less than.
              LESS_THAN = 2

              # Greater than.
              GREATER_THAN = 4
            end
          end

          # A filter for numeric or date values between certain values on a dimension
          # or metric.
          # @!attribute [rw] from_value
          #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::NumericValue]
          #     Required. Begins with this number, inclusive.
          # @!attribute [rw] to_value
          #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter::NumericValue]
          #     Required. Ends with this number, inclusive.
          class BetweenFilter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A filter that matches events of a single event name. If an event parameter
        # is specified, only the subset of events that match both the single event name
        # and the parameter filter expressions match this event filter.
        # @!attribute [rw] event_name
        #   @return [::String]
        #     Required. Immutable. The name of the event to match against.
        # @!attribute [rw] event_parameter_filter_expression
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterExpression]
        #     Optional. If specified, this filter matches events that match both the
        #     single event name and the parameter filter expressions. AudienceEventFilter
        #     inside the parameter filter expression cannot be set (For example, nested
        #     event filters are not supported). This should be a single and_group of
        #     dimension_or_metric_filter or not_expression; ANDs of ORs are not
        #     supported. Also, if it includes a filter for "eventCount", only that one
        #     will be considered; all the other filters will be ignored.
        class AudienceEventFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A logical expression of Audience dimension, metric, or event filters.
        # @!attribute [rw] and_group
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterExpressionList]
        #     A list of expressions to be AND’ed together. It can only contain
        #     AudienceFilterExpressions with or_group. This must be set for the top
        #     level AudienceFilterExpression.
        #
        #     Note: The following fields are mutually exclusive: `and_group`, `or_group`, `not_expression`, `dimension_or_metric_filter`, `event_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] or_group
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterExpressionList]
        #     A list of expressions to OR’ed together. It cannot contain
        #     AudienceFilterExpressions with and_group or or_group.
        #
        #     Note: The following fields are mutually exclusive: `or_group`, `and_group`, `not_expression`, `dimension_or_metric_filter`, `event_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] not_expression
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterExpression]
        #     A filter expression to be NOT'ed (For example, inverted, complemented).
        #     It can only include a dimension_or_metric_filter. This cannot be set on
        #     the top level AudienceFilterExpression.
        #
        #     Note: The following fields are mutually exclusive: `not_expression`, `and_group`, `or_group`, `dimension_or_metric_filter`, `event_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] dimension_or_metric_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceDimensionOrMetricFilter]
        #     A filter on a single dimension or metric. This cannot be set on the top
        #     level AudienceFilterExpression.
        #
        #     Note: The following fields are mutually exclusive: `dimension_or_metric_filter`, `and_group`, `or_group`, `not_expression`, `event_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] event_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceEventFilter]
        #     Creates a filter that matches a specific event. This cannot be set on the
        #     top level AudienceFilterExpression.
        #
        #     Note: The following fields are mutually exclusive: `event_filter`, `and_group`, `or_group`, `not_expression`, `dimension_or_metric_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AudienceFilterExpression
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of Audience filter expressions.
        # @!attribute [rw] filter_expressions
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AudienceFilterExpression>]
        #     A list of Audience filter expressions.
        class AudienceFilterExpressionList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines a simple filter that a user must satisfy to be a member of the
        # Audience.
        # @!attribute [rw] scope
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterScope]
        #     Required. Immutable. Specifies the scope for this filter.
        # @!attribute [rw] filter_expression
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterExpression]
        #     Required. Immutable. A logical expression of Audience dimension, metric, or
        #     event filters.
        class AudienceSimpleFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines filters that must occur in a specific order for the user to be a
        # member of the Audience.
        # @!attribute [rw] scope
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterScope]
        #     Required. Immutable. Specifies the scope for this filter.
        # @!attribute [rw] sequence_maximum_duration
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Defines the time period in which the whole sequence must occur.
        # @!attribute [rw] sequence_steps
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AudienceSequenceFilter::AudienceSequenceStep>]
        #     Required. An ordered sequence of steps. A user must complete each step in
        #     order to join the sequence filter.
        class AudienceSequenceFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A condition that must occur in the specified step order for this user
          # to match the sequence.
          # @!attribute [rw] scope
          #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterScope]
          #     Required. Immutable. Specifies the scope for this step.
          # @!attribute [rw] immediately_follows
          #   @return [::Boolean]
          #     Optional. If true, the event satisfying this step must be the very next
          #     event after the event satisfying the last step. If unset or false, this
          #     step indirectly follows the prior step; for example, there may be
          #     events between the prior step and this step. It is ignored for the
          #     first step.
          # @!attribute [rw] constraint_duration
          #   @return [::Google::Protobuf::Duration]
          #     Optional. When set, this step must be satisfied within the
          #     constraint_duration of the previous step (For example,  t[i] - t[i-1] <=
          #     constraint_duration). If not set, there is no duration requirement (the
          #     duration is effectively unlimited). It is ignored for the first step.
          # @!attribute [rw] filter_expression
          #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterExpression]
          #     Required. Immutable. A logical expression of Audience dimension, metric,
          #     or event filters in each step.
          class AudienceSequenceStep
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A clause for defining either a simple or sequence filter. A filter can be
        # inclusive (For example, users satisfying the filter clause are included in
        # the Audience) or exclusive (For example, users satisfying the filter clause
        # are excluded from the Audience).
        # @!attribute [rw] simple_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceSimpleFilter]
        #     A simple filter that a user must satisfy to be a member of the Audience.
        #
        #     Note: The following fields are mutually exclusive: `simple_filter`, `sequence_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sequence_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceSequenceFilter]
        #     Filters that must occur in a specific order for the user to be a member
        #     of the Audience.
        #
        #     Note: The following fields are mutually exclusive: `sequence_filter`, `simple_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] clause_type
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceFilterClause::AudienceClauseType]
        #     Required. Specifies whether this is an include or exclude filter clause.
        class AudienceFilterClause
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies whether this is an include or exclude filter clause.
          module AudienceClauseType
            # Unspecified clause type.
            AUDIENCE_CLAUSE_TYPE_UNSPECIFIED = 0

            # Users will be included in the Audience if the filter clause is met.
            INCLUDE = 1

            # Users will be excluded from the Audience if the filter clause is met.
            EXCLUDE = 2
          end
        end

        # Specifies an event to log when a user joins the Audience.
        # @!attribute [rw] event_name
        #   @return [::String]
        #     Required. The event name that will be logged.
        # @!attribute [rw] log_condition
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceEventTrigger::LogCondition]
        #     Required. When to log the event.
        class AudienceEventTrigger
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Determines when to log the event.
          module LogCondition
            # Log condition is not specified.
            LOG_CONDITION_UNSPECIFIED = 0

            # The event should be logged only when a user is joined.
            AUDIENCE_JOINED = 1

            # The event should be logged whenever the Audience condition is met, even
            # if the user is already a member of the Audience.
            AUDIENCE_MEMBERSHIP_RENEWED = 2
          end
        end

        # A resource message representing an Audience.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this Audience resource.
        #     Format: properties/\\{propertyId}/audiences/\\{audienceId}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the Audience.
        # @!attribute [rw] description
        #   @return [::String]
        #     Required. The description of the Audience.
        # @!attribute [rw] membership_duration_days
        #   @return [::Integer]
        #     Required. Immutable. The duration a user should stay in an Audience. It
        #     cannot be set to more than 540 days.
        # @!attribute [r] ads_personalization_enabled
        #   @return [::Boolean]
        #     Output only. It is automatically set by GA to false if this is an NPA
        #     Audience and is excluded from ads personalization.
        # @!attribute [rw] event_trigger
        #   @return [::Google::Analytics::Admin::V1alpha::AudienceEventTrigger]
        #     Optional. Specifies an event to log when a user joins the Audience. If not
        #     set, no event is logged when a user joins the Audience.
        # @!attribute [rw] exclusion_duration_mode
        #   @return [::Google::Analytics::Admin::V1alpha::Audience::AudienceExclusionDurationMode]
        #     Immutable. Specifies how long an exclusion lasts for users that meet the
        #     exclusion filter. It is applied to all EXCLUDE filter clauses and is
        #     ignored when there is no EXCLUDE filter clause in the Audience.
        # @!attribute [rw] filter_clauses
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AudienceFilterClause>]
        #     Required. Immutable. Unordered list. Filter clauses that define the
        #     Audience. All clauses will be AND’ed together.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the Audience was created.
        class Audience
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how long an exclusion lasts for users that meet the exclusion
          # filter.
          module AudienceExclusionDurationMode
            # Not specified.
            AUDIENCE_EXCLUSION_DURATION_MODE_UNSPECIFIED = 0

            # Exclude users from the Audience during periods when they meet the
            # filter clause.
            EXCLUDE_TEMPORARILY = 1

            # Exclude users from the Audience if they've ever met the filter clause.
            EXCLUDE_PERMANENTLY = 2
          end
        end

        # Specifies how to evaluate users for joining an Audience.
        module AudienceFilterScope
          # Scope is not specified.
          AUDIENCE_FILTER_SCOPE_UNSPECIFIED = 0

          # User joins the Audience if the filter condition is met within one
          # event.
          AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT = 1

          # User joins the Audience if the filter condition is met within one
          # session.
          AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION = 2

          # User joins the Audience if the filter condition is met by any event
          # across any session.
          AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS = 3
        end
      end
    end
  end
end
