# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Analytics
    module Admin
      module V1alpha
        # The request for a Data Access Record Report.
        # @!attribute [rw] entity
        #   @return [::String]
        #     The Data Access Report supports requesting at the property level or account
        #     level. If requested at the account level, Data Access Reports include all
        #     access for all properties under that account.
        #
        #     To request at the property level, entity should be for example
        #     'properties/123' if "123" is your Google Analytics property ID. To request
        #     at the account level, entity should be for example 'accounts/1234' if
        #     "1234" is your Google Analytics Account ID.
        # @!attribute [rw] dimensions
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessDimension>]
        #     The dimensions requested and displayed in the response. Requests are
        #     allowed up to 9 dimensions.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessMetric>]
        #     The metrics requested and displayed in the response. Requests are allowed
        #     up to 10 metrics.
        # @!attribute [rw] date_ranges
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessDateRange>]
        #     Date ranges of access records to read. If multiple date ranges are
        #     requested, each response row will contain a zero based date range index. If
        #     two date ranges overlap, the access records for the overlapping days is
        #     included in the response rows for both date ranges. Requests are allowed up
        #     to 2 date ranges.
        # @!attribute [rw] dimension_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AccessFilterExpression]
        #     Dimension filters let you restrict report response to specific
        #     dimension values which match the filter. For example, filtering on access
        #     records of a single user. To learn more, see [Fundamentals of Dimension
        #     Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
        #     for examples. Metrics cannot be used in this filter.
        # @!attribute [rw] metric_filter
        #   @return [::Google::Analytics::Admin::V1alpha::AccessFilterExpression]
        #     Metric filters allow you to restrict report response to specific metric
        #     values which match the filter. Metric filters are applied after aggregating
        #     the report's rows, similar to SQL having-clause. Dimensions cannot be used
        #     in this filter.
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     The row count of the start row. The first row is counted as row 0. If
        #     offset is unspecified, it is treated as 0. If offset is zero, then this
        #     method will return the first page of results with `limit` entries.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        # @!attribute [rw] limit
        #   @return [::Integer]
        #     The number of rows to return. If unspecified, 10,000 rows are returned. The
        #     API returns a maximum of 100,000 rows per request, no matter how many you
        #     ask for. `limit` must be positive.
        #
        #     The API may return fewer rows than the requested `limit`, if there aren't
        #     as many remaining rows as the `limit`. For instance, there are fewer than
        #     300 possible values for the dimension `country`, so when reporting on only
        #     `country`, you can't get more than 300 rows, even if you set `limit` to a
        #     higher value.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     This request's time zone if specified. If unspecified, the property's time
        #     zone is used. The request's time zone is used to interpret the start & end
        #     dates of the report.
        #
        #     Formatted as strings from the IANA Time Zone database
        #     (https://www.iana.org/time-zones); for example "America/New_York" or
        #     "Asia/Tokyo".
        # @!attribute [rw] order_bys
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessOrderBy>]
        #     Specifies how rows are ordered in the response.
        # @!attribute [rw] return_entity_quota
        #   @return [::Boolean]
        #     Toggles whether to return the current state of this Analytics Property's
        #     quota. Quota is returned in [AccessQuota](#AccessQuota). For account-level
        #     requests, this field must be false.
        # @!attribute [rw] include_all_users
        #   @return [::Boolean]
        #     Optional. Determines whether to include users who have never made an API
        #     call in the response. If true, all users with access to the specified
        #     property or account are included in the response, regardless of whether
        #     they have made an API call or not. If false, only the users who have made
        #     an API call will be included.
        # @!attribute [rw] expand_groups
        #   @return [::Boolean]
        #     Optional. Decides whether to return the users within user groups. This
        #     field works only when include_all_users is set to true. If true, it will
        #     return all users with access to the specified property or account.
        #     If false, only the users with direct access will be returned.
        class RunAccessReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The customized Data Access Record Report response.
        # @!attribute [rw] dimension_headers
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessDimensionHeader>]
        #     The header for a column in the report that corresponds to a specific
        #     dimension. The number of DimensionHeaders and ordering of DimensionHeaders
        #     matches the dimensions present in rows.
        # @!attribute [rw] metric_headers
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessMetricHeader>]
        #     The header for a column in the report that corresponds to a specific
        #     metric. The number of MetricHeaders and ordering of MetricHeaders matches
        #     the metrics present in rows.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessRow>]
        #     Rows of dimension value combinations and metric values in the report.
        # @!attribute [rw] row_count
        #   @return [::Integer]
        #     The total number of rows in the query result. `rowCount` is independent of
        #     the number of rows returned in the response, the `limit` request
        #     parameter, and the `offset` request parameter. For example if a query
        #     returns 175 rows and includes `limit` of 50 in the API request, the
        #     response will contain `rowCount` of 175 but only 50 rows.
        #
        #     To learn more about this pagination parameter, see
        #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
        # @!attribute [rw] quota
        #   @return [::Google::Analytics::Admin::V1alpha::AccessQuota]
        #     The quota state for this Analytics property including this request. This
        #     field doesn't work with account-level requests.
        class RunAccessReportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetAccount RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the account to lookup.
        #     Format: accounts/\\{account}
        #     Example: "accounts/100"
        class GetAccountRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListAccounts RPC.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAccounts` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListAccounts` must
        #     match the call that provided the page token.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Whether to include soft-deleted (ie: "trashed") Accounts in the
        #     results. Accounts can be inspected to determine whether they are deleted or
        #     not.
        class ListAccountsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListAccounts RPC.
        # @!attribute [rw] accounts
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::Account>]
        #     Results that were accessible to the caller.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAccountsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteAccount RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Account to soft-delete.
        #     Format: accounts/\\{account}
        #     Example: "accounts/100"
        class DeleteAccountRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateAccount RPC.
        # @!attribute [rw] account
        #   @return [::Google::Analytics::Admin::V1alpha::Account]
        #     Required. The account to update.
        #     The account's `name` field is used to identify the account.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (for example, "field_to_update"). Omitted fields will not be updated.
        #     To replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateAccountRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ProvisionAccountTicket RPC.
        # @!attribute [rw] account
        #   @return [::Google::Analytics::Admin::V1alpha::Account]
        #     The account to create.
        # @!attribute [rw] redirect_uri
        #   @return [::String]
        #     Redirect URI where the user will be sent after accepting Terms of Service.
        #     Must be configured in Cloud Console as a Redirect URI.
        class ProvisionAccountTicketRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ProvisionAccountTicket RPC.
        # @!attribute [rw] account_ticket_id
        #   @return [::String]
        #     The param to be passed in the ToS link.
        class ProvisionAccountTicketResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetProperty RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the property to lookup.
        #     Format: properties/\\{property_id}
        #     Example: "properties/1000"
        class GetPropertyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListProperties RPC.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. An expression for filtering the results of the request.
        #     Fields eligible for filtering are:
        #     `parent:`(The resource name of the parent account/property) or
        #     `ancestor:`(The resource name of the parent account) or
        #     `firebase_project:`(The id or number of the linked firebase project).
        #     Some examples of filters:
        #
        #     ```
        #     | Filter                      | Description                               |
        #     |-----------------------------|-------------------------------------------|
        #     | parent:accounts/123         | The account with account id: 123.       |
        #     | parent:properties/123       | The property with property id: 123.       |
        #     | ancestor:accounts/123       | The account with account id: 123.         |
        #     | firebase_project:project-id | The firebase project with id: project-id. |
        #     | firebase_project:123        | The firebase project with number: 123.    |
        #     ```
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListProperties` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListProperties` must
        #     match the call that provided the page token.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Whether to include soft-deleted (ie: "trashed") Properties in the
        #     results. Properties can be inspected to determine whether they are deleted
        #     or not.
        class ListPropertiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListProperties RPC.
        # @!attribute [rw] properties
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::Property>]
        #     Results that matched the filter criteria and were accessible to the caller.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListPropertiesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateProperty RPC.
        # @!attribute [rw] property
        #   @return [::Google::Analytics::Admin::V1alpha::Property]
        #     Required. The property to update.
        #     The property's `name` field is used to identify the property to be
        #     updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdatePropertyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateProperty RPC.
        # @!attribute [rw] property
        #   @return [::Google::Analytics::Admin::V1alpha::Property]
        #     Required. The property to create.
        #     Note: the supplied property must specify its parent.
        class CreatePropertyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteProperty RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Property to soft-delete.
        #     Format: properties/\\{property_id}
        #     Example: "properties/1000"
        class DeletePropertyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateFirebaseLink RPC
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: properties/\\{property_id}
        #
        #     Example: `properties/1234`
        # @!attribute [rw] firebase_link
        #   @return [::Google::Analytics::Admin::V1alpha::FirebaseLink]
        #     Required. The Firebase link to create.
        class CreateFirebaseLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteFirebaseLink RPC
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Format: properties/\\{property_id}/firebaseLinks/\\{firebase_link_id}
        #
        #     Example: `properties/1234/firebaseLinks/5678`
        class DeleteFirebaseLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListFirebaseLinks RPC
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: properties/\\{property_id}
        #
        #     Example: `properties/1234`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListFirebaseLinks` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListFirebaseLinks` must
        #     match the call that provided the page token.
        class ListFirebaseLinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListFirebaseLinks RPC
        # @!attribute [rw] firebase_links
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::FirebaseLink>]
        #     List of FirebaseLinks. This will have at most one value.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        #     Currently, Google Analytics supports only one FirebaseLink per property,
        #     so this will never be populated.
        class ListFirebaseLinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetGlobalSiteTag RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the site tag to lookup.
        #     Note that site tags are singletons and do not have unique IDs.
        #     Format: properties/\\{property_id}/dataStreams/\\{stream_id}/globalSiteTag
        #
        #     Example: `properties/123/dataStreams/456/globalSiteTag`
        class GetGlobalSiteTagRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateGoogleAdsLink RPC
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] google_ads_link
        #   @return [::Google::Analytics::Admin::V1alpha::GoogleAdsLink]
        #     Required. The GoogleAdsLink to create.
        class CreateGoogleAdsLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateGoogleAdsLink RPC
        # @!attribute [rw] google_ads_link
        #   @return [::Google::Analytics::Admin::V1alpha::GoogleAdsLink]
        #     The GoogleAdsLink to update
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateGoogleAdsLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteGoogleAdsLink RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Example format: properties/1234/googleAdsLinks/5678
        class DeleteGoogleAdsLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListGoogleAdsLinks RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListGoogleAdsLinks` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListGoogleAdsLinks` must
        #     match the call that provided the page token.
        class ListGoogleAdsLinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListGoogleAdsLinks RPC.
        # @!attribute [rw] google_ads_links
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::GoogleAdsLink>]
        #     List of GoogleAdsLinks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListGoogleAdsLinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDataSharingSettings RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the settings to lookup.
        #     Format: accounts/\\{account}/dataSharingSettings
        #
        #     Example: `accounts/1000/dataSharingSettings`
        class GetDataSharingSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListAccountSummaries RPC.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of AccountSummary resources to return. The service may
        #     return fewer than this value, even if there are additional pages.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAccountSummaries` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListAccountSummaries`
        #     must match the call that provided the page token.
        class ListAccountSummariesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListAccountSummaries RPC.
        # @!attribute [rw] account_summaries
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccountSummary>]
        #     Account summaries of all accounts the caller has access to.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAccountSummariesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for AcknowledgeUserDataCollection RPC.
        # @!attribute [rw] property
        #   @return [::String]
        #     Required. The property for which to acknowledge user data collection.
        # @!attribute [rw] acknowledgement
        #   @return [::String]
        #     Required. An acknowledgement that the caller of this method understands the
        #     terms of user data collection.
        #
        #     This field must contain the exact value:
        #     "I acknowledge that I have the necessary privacy disclosures and rights
        #     from my end users for the collection and processing of their data,
        #     including the association of such data with the visitation information
        #     Google Analytics collects from my site and/or app property."
        class AcknowledgeUserDataCollectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for AcknowledgeUserDataCollection RPC.
        class AcknowledgeUserDataCollectionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for SearchChangeHistoryEvents RPC.
        # @!attribute [rw] account
        #   @return [::String]
        #     Required. The account resource for which to return change history
        #     resources. Format: accounts/\\{account}
        #
        #     Example: `accounts/100`
        # @!attribute [rw] property
        #   @return [::String]
        #     Optional. Resource name for a child property. If set, only return changes
        #     made to this property or its child resources.
        #     Format: properties/\\{propertyId}
        #
        #     Example: `properties/100`
        # @!attribute [rw] resource_type
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ChangeHistoryResourceType>]
        #     Optional. If set, only return changes if they are for a resource that
        #     matches at least one of these types.
        # @!attribute [rw] action
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ActionType>]
        #     Optional. If set, only return changes that match one or more of these types
        #     of actions.
        # @!attribute [rw] actor_email
        #   @return [::Array<::String>]
        #     Optional. If set, only return changes if they are made by a user in this
        #     list.
        # @!attribute [rw] earliest_change_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. If set, only return changes made after this time (inclusive).
        # @!attribute [rw] latest_change_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. If set, only return changes made before this time (inclusive).
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of ChangeHistoryEvent items to return.
        #     If unspecified, at most 50 items will be returned. The maximum value is 200
        #     (higher values will be coerced to the maximum).
        #
        #     Note that the service may return a page with fewer items than this value
        #     specifies (potentially even zero), and that there still may be additional
        #     pages. If you want a particular number of items, you'll need to continue
        #     requesting additional pages using `page_token` until you get the needed
        #     number.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `SearchChangeHistoryEvents` call. Provide this to retrieve the subsequent
        #     page. When paginating, all other parameters provided to
        #     `SearchChangeHistoryEvents` must match the call that provided the page
        #     token.
        class SearchChangeHistoryEventsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for SearchAccounts RPC.
        # @!attribute [rw] change_history_events
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ChangeHistoryEvent>]
        #     Results that were accessible to the caller.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class SearchChangeHistoryEventsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetMeasurementProtocolSecret RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the measurement protocol secret to lookup.
        #     Format:
        #     properties/\\{property}/dataStreams/\\{dataStream}/measurementProtocolSecrets/\\{measurementProtocolSecret}
        class GetMeasurementProtocolSecretRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateMeasurementProtocolSecret RPC
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this secret will be created.
        #     Format: properties/\\{property}/dataStreams/\\{dataStream}
        # @!attribute [rw] measurement_protocol_secret
        #   @return [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
        #     Required. The measurement protocol secret to create.
        class CreateMeasurementProtocolSecretRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteMeasurementProtocolSecret RPC
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the MeasurementProtocolSecret to delete.
        #     Format:
        #     properties/\\{property}/dataStreams/\\{dataStream}/measurementProtocolSecrets/\\{measurementProtocolSecret}
        class DeleteMeasurementProtocolSecretRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateMeasurementProtocolSecret RPC
        # @!attribute [rw] measurement_protocol_secret
        #   @return [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
        #     Required. The measurement protocol secret to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Omitted fields will not be
        #     updated.
        class UpdateMeasurementProtocolSecretRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListMeasurementProtocolSecret RPC
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent stream.
        #     Format:
        #     properties/\\{property}/dataStreams/\\{dataStream}/measurementProtocolSecrets
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 10 resources will be returned.
        #     The maximum value is 10. Higher values will be coerced to the maximum.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListMeasurementProtocolSecrets`
        #     call. Provide this to retrieve the subsequent page. When paginating, all
        #     other parameters provided to `ListMeasurementProtocolSecrets` must match
        #     the call that provided the page token.
        class ListMeasurementProtocolSecretsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListMeasurementProtocolSecret RPC
        # @!attribute [rw] measurement_protocol_secrets
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret>]
        #     A list of secrets for the parent stream specified in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListMeasurementProtocolSecretsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetSKAdNetworkConversionValueSchema RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of SKAdNetwork conversion value schema to look
        #     up. Format:
        #     properties/\\{property}/dataStreams/\\{dataStream}/sKAdNetworkConversionValueSchema/\\{skadnetwork_conversion_value_schema}
        class GetSKAdNetworkConversionValueSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateSKAdNetworkConversionValueSchema RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this schema will be created.
        #     Format: properties/\\{property}/dataStreams/\\{dataStream}
        # @!attribute [rw] skadnetwork_conversion_value_schema
        #   @return [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
        #     Required. SKAdNetwork conversion value schema to create.
        class CreateSKAdNetworkConversionValueSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteSKAdNetworkConversionValueSchema RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the SKAdNetworkConversionValueSchema to delete.
        #     Format:
        #     properties/\\{property}/dataStreams/\\{dataStream}/sKAdNetworkConversionValueSchema/\\{skadnetwork_conversion_value_schema}
        class DeleteSKAdNetworkConversionValueSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateSKAdNetworkConversionValueSchema RPC.
        # @!attribute [rw] skadnetwork_conversion_value_schema
        #   @return [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
        #     Required. SKAdNetwork conversion value schema to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Omitted fields will not be
        #     updated.
        class UpdateSKAdNetworkConversionValueSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListSKAdNetworkConversionValueSchemas RPC
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The DataStream resource to list schemas for.
        #     Format:
        #     properties/\\{property_id}/dataStreams/\\{dataStream}
        #     Example: properties/1234/dataStreams/5678
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     `ListSKAdNetworkConversionValueSchemas` call. Provide this to retrieve the
        #     subsequent page. When paginating, all other parameters provided to
        #     `ListSKAdNetworkConversionValueSchema` must match the call that provided
        #     the page token.
        class ListSKAdNetworkConversionValueSchemasRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListSKAdNetworkConversionValueSchemas RPC
        # @!attribute [rw] skadnetwork_conversion_value_schemas
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema>]
        #     List of SKAdNetworkConversionValueSchemas. This will have at most one
        #     value.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        #     Currently, Google Analytics supports only one
        #     SKAdNetworkConversionValueSchema per dataStream, so this will never be
        #     populated.
        class ListSKAdNetworkConversionValueSchemasResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetGoogleSignalsSettings RPC
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the google signals settings to retrieve.
        #     Format: properties/\\{property}/googleSignalsSettings
        class GetGoogleSignalsSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateGoogleSignalsSettings RPC
        # @!attribute [rw] google_signals_settings
        #   @return [::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings]
        #     Required. The settings to update.
        #     The `name` field is used to identify the settings to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateGoogleSignalsSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateConversionEvent RPC
        # @!attribute [rw] conversion_event
        #   @return [::Google::Analytics::Admin::V1alpha::ConversionEvent]
        #     Required. The conversion event to create.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent property where this conversion
        #     event will be created. Format: properties/123
        class CreateConversionEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateConversionEvent RPC
        # @!attribute [rw] conversion_event
        #   @return [::Google::Analytics::Admin::V1alpha::ConversionEvent]
        #     Required. The conversion event to update.
        #     The `name` field is used to identify the settings to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateConversionEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetConversionEvent RPC
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the conversion event to retrieve.
        #     Format: properties/\\{property}/conversionEvents/\\{conversion_event}
        #     Example: "properties/123/conversionEvents/456"
        class GetConversionEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteConversionEvent RPC
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the conversion event to delete.
        #     Format: properties/\\{property}/conversionEvents/\\{conversion_event}
        #     Example: "properties/123/conversionEvents/456"
        class DeleteConversionEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListConversionEvents RPC
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent property.
        #     Example: 'properties/123'
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListConversionEvents` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListConversionEvents`
        #     must match the call that provided the page token.
        class ListConversionEventsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListConversionEvents RPC.
        # @!attribute [rw] conversion_events
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ConversionEvent>]
        #     The requested conversion events
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListConversionEventsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateKeyEvent RPC
        # @!attribute [rw] key_event
        #   @return [::Google::Analytics::Admin::V1alpha::KeyEvent]
        #     Required. The Key Event to create.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent property where this Key Event
        #     will be created. Format: properties/123
        class CreateKeyEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateKeyEvent RPC
        # @!attribute [rw] key_event
        #   @return [::Google::Analytics::Admin::V1alpha::KeyEvent]
        #     Required. The Key Event to update.
        #     The `name` field is used to identify the settings to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateKeyEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetKeyEvent RPC
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Key Event to retrieve.
        #     Format: properties/\\{property}/keyEvents/\\{key_event}
        #     Example: "properties/123/keyEvents/456"
        class GetKeyEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteKeyEvent RPC
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Key Event to delete.
        #     Format: properties/\\{property}/keyEvents/\\{key_event}
        #     Example: "properties/123/keyEvents/456"
        class DeleteKeyEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListKeyEvents RPC
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent property.
        #     Example: 'properties/123'
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListKeyEvents` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListKeyEvents`
        #     must match the call that provided the page token.
        class ListKeyEventsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListKeyEvents RPC.
        # @!attribute [rw] key_events
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::KeyEvent>]
        #     The requested Key Events
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListKeyEventsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDisplayVideo360AdvertiserLink RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DisplayVideo360AdvertiserLink to get.
        #     Example format: properties/1234/displayVideo360AdvertiserLink/5678
        class GetDisplayVideo360AdvertiserLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDisplayVideo360AdvertiserLinks RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDisplayVideo360AdvertiserLinks`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListDisplayVideo360AdvertiserLinks` must match the call that provided the
        #     page token.
        class ListDisplayVideo360AdvertiserLinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDisplayVideo360AdvertiserLinks RPC.
        # @!attribute [rw] display_video_360_advertiser_links
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink>]
        #     List of DisplayVideo360AdvertiserLinks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDisplayVideo360AdvertiserLinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDisplayVideo360AdvertiserLink RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] display_video_360_advertiser_link
        #   @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
        #     Required. The DisplayVideo360AdvertiserLink to create.
        class CreateDisplayVideo360AdvertiserLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteDisplayVideo360AdvertiserLink RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DisplayVideo360AdvertiserLink to delete.
        #     Example format: properties/1234/displayVideo360AdvertiserLinks/5678
        class DeleteDisplayVideo360AdvertiserLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDisplayVideo360AdvertiserLink RPC.
        # @!attribute [rw] display_video_360_advertiser_link
        #   @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
        #     The DisplayVideo360AdvertiserLink to update
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Omitted fields will not be
        #     updated. To replace the entire entity, use one path with the string "*" to
        #     match all fields.
        class UpdateDisplayVideo360AdvertiserLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDisplayVideo360AdvertiserLinkProposal RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DisplayVideo360AdvertiserLinkProposal to get.
        #     Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
        class GetDisplayVideo360AdvertiserLinkProposalRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDisplayVideo360AdvertiserLinkProposals RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     `ListDisplayVideo360AdvertiserLinkProposals` call. Provide this to retrieve
        #     the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListDisplayVideo360AdvertiserLinkProposals` must match the call that
        #     provided the page token.
        class ListDisplayVideo360AdvertiserLinkProposalsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDisplayVideo360AdvertiserLinkProposals RPC.
        # @!attribute [rw] display_video_360_advertiser_link_proposals
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal>]
        #     List of DisplayVideo360AdvertiserLinkProposals.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDisplayVideo360AdvertiserLinkProposalsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDisplayVideo360AdvertiserLinkProposal RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] display_video_360_advertiser_link_proposal
        #   @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal]
        #     Required. The DisplayVideo360AdvertiserLinkProposal to create.
        class CreateDisplayVideo360AdvertiserLinkProposalRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteDisplayVideo360AdvertiserLinkProposal RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DisplayVideo360AdvertiserLinkProposal to delete.
        #     Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
        class DeleteDisplayVideo360AdvertiserLinkProposalRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ApproveDisplayVideo360AdvertiserLinkProposal RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DisplayVideo360AdvertiserLinkProposal to approve.
        #     Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
        class ApproveDisplayVideo360AdvertiserLinkProposalRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ApproveDisplayVideo360AdvertiserLinkProposal RPC.
        # @!attribute [rw] display_video_360_advertiser_link
        #   @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
        #     The DisplayVideo360AdvertiserLink created as a result of approving the
        #     proposal.
        class ApproveDisplayVideo360AdvertiserLinkProposalResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CancelDisplayVideo360AdvertiserLinkProposal RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DisplayVideo360AdvertiserLinkProposal to cancel.
        #     Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
        class CancelDisplayVideo360AdvertiserLinkProposalRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetSearchAds360Link RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the SearchAds360Link to get.
        #     Example format: properties/1234/SearchAds360Link/5678
        class GetSearchAds360LinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListSearchAds360Links RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListSearchAds360Links`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListSearchAds360Links` must match the call that provided the
        #     page token.
        class ListSearchAds360LinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListSearchAds360Links RPC.
        # @!attribute [rw] search_ads_360_links
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::SearchAds360Link>]
        #     List of SearchAds360Links.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListSearchAds360LinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateSearchAds360Link RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] search_ads_360_link
        #   @return [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
        #     Required. The SearchAds360Link to create.
        class CreateSearchAds360LinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteSearchAds360Link RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the SearchAds360Link to delete.
        #     Example format: properties/1234/SearchAds360Links/5678
        class DeleteSearchAds360LinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateSearchAds360Link RPC.
        # @!attribute [rw] search_ads_360_link
        #   @return [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
        #     The SearchAds360Link to update
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Omitted fields will not be
        #     updated. To replace the entire entity, use one path with the string "*" to
        #     match all fields.
        class UpdateSearchAds360LinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateCustomDimension RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] custom_dimension
        #   @return [::Google::Analytics::Admin::V1alpha::CustomDimension]
        #     Required. The CustomDimension to create.
        class CreateCustomDimensionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateCustomDimension RPC.
        # @!attribute [rw] custom_dimension
        #   @return [::Google::Analytics::Admin::V1alpha::CustomDimension]
        #     The CustomDimension to update
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Omitted fields will not be
        #     updated. To replace the entire entity, use one path with the string "*" to
        #     match all fields.
        class UpdateCustomDimensionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListCustomDimensions RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListCustomDimensions` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCustomDimensions`
        #     must match the call that provided the page token.
        class ListCustomDimensionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListCustomDimensions RPC.
        # @!attribute [rw] custom_dimensions
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::CustomDimension>]
        #     List of CustomDimensions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListCustomDimensionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ArchiveCustomDimension RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CustomDimension to archive.
        #     Example format: properties/1234/customDimensions/5678
        class ArchiveCustomDimensionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetCustomDimension RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CustomDimension to get.
        #     Example format: properties/1234/customDimensions/5678
        class GetCustomDimensionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateCustomMetric RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] custom_metric
        #   @return [::Google::Analytics::Admin::V1alpha::CustomMetric]
        #     Required. The CustomMetric to create.
        class CreateCustomMetricRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateCustomMetric RPC.
        # @!attribute [rw] custom_metric
        #   @return [::Google::Analytics::Admin::V1alpha::CustomMetric]
        #     The CustomMetric to update
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Omitted fields will not be
        #     updated. To replace the entire entity, use one path with the string "*" to
        #     match all fields.
        class UpdateCustomMetricRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListCustomMetrics RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListCustomMetrics` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCustomMetrics` must
        #     match the call that provided the page token.
        class ListCustomMetricsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListCustomMetrics RPC.
        # @!attribute [rw] custom_metrics
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::CustomMetric>]
        #     List of CustomMetrics.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListCustomMetricsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ArchiveCustomMetric RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CustomMetric to archive.
        #     Example format: properties/1234/customMetrics/5678
        class ArchiveCustomMetricRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetCustomMetric RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CustomMetric to get.
        #     Example format: properties/1234/customMetrics/5678
        class GetCustomMetricRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateCalculatedMetric RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: properties/\\{property_id}
        #     Example: properties/1234
        # @!attribute [rw] calculated_metric_id
        #   @return [::String]
        #     Required. The ID to use for the calculated metric which will become the
        #     final component of the calculated metric's resource name.
        #
        #     This value should be 1-80 characters and valid characters are
        #     /[a-zA-Z0-9_]/, no spaces allowed. calculated_metric_id must be unique
        #     between all calculated metrics under a property. The calculated_metric_id
        #     is used when referencing this calculated metric from external APIs, for
        #     example, "calcMetric:\\{calculated_metric_id}".
        # @!attribute [rw] calculated_metric
        #   @return [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
        #     Required. The CalculatedMetric to create.
        class CreateCalculatedMetricRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateCalculatedMetric RPC.
        # @!attribute [rw] calculated_metric
        #   @return [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
        #     Required. The CalculatedMetric to update
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Omitted fields will not be
        #     updated. To replace the entire entity, use one path with the string "*" to
        #     match all fields.
        class UpdateCalculatedMetricRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteCalculatedMetric RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CalculatedMetric to delete.
        #     Format: properties/\\{property_id}/calculatedMetrics/\\{calculated_metric_id}
        #     Example: properties/1234/calculatedMetrics/Metric01
        class DeleteCalculatedMetricRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListCalculatedMetrics RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListCalculatedMetrics`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCalculatedMetrics`
        #     must match the call that provided the page token.
        class ListCalculatedMetricsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListCalculatedMetrics RPC.
        # @!attribute [rw] calculated_metrics
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::CalculatedMetric>]
        #     List of CalculatedMetrics.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListCalculatedMetricsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetCalculatedMetric RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CalculatedMetric to get.
        #     Format: properties/\\{property_id}/calculatedMetrics/\\{calculated_metric_id}
        #     Example: properties/1234/calculatedMetrics/Metric01
        class GetCalculatedMetricRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDataRetentionSettings RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the settings to lookup.
        #     Format:
        #     properties/\\{property}/dataRetentionSettings
        #     Example: "properties/1000/dataRetentionSettings"
        class GetDataRetentionSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDataRetentionSettings RPC.
        # @!attribute [rw] data_retention_settings
        #   @return [::Google::Analytics::Admin::V1alpha::DataRetentionSettings]
        #     Required. The settings to update.
        #     The `name` field is used to identify the settings to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateDataRetentionSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDataStream RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] data_stream
        #   @return [::Google::Analytics::Admin::V1alpha::DataStream]
        #     Required. The DataStream to create.
        class CreateDataStreamRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteDataStream RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DataStream to delete.
        #     Example format: properties/1234/dataStreams/5678
        class DeleteDataStreamRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDataStream RPC.
        # @!attribute [rw] data_stream
        #   @return [::Google::Analytics::Admin::V1alpha::DataStream]
        #     The DataStream to update
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Omitted fields will not be
        #     updated. To replace the entire entity, use one path with the string "*" to
        #     match all fields.
        class UpdateDataStreamRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDataStreams RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDataStreams` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListDataStreams` must
        #     match the call that provided the page token.
        class ListDataStreamsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDataStreams RPC.
        # @!attribute [rw] data_streams
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::DataStream>]
        #     List of DataStreams.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDataStreamsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDataStream RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DataStream to get.
        #     Example format: properties/1234/dataStreams/5678
        class GetDataStreamRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetAudience RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Audience to get.
        #     Example format: properties/1234/audiences/5678
        class GetAudienceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListAudiences RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAudiences` call. Provide this
        #     to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListAudiences` must
        #     match the call that provided the page token.
        class ListAudiencesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListAudiences RPC.
        # @!attribute [rw] audiences
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::Audience>]
        #     List of Audiences.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAudiencesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateAudience RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] audience
        #   @return [::Google::Analytics::Admin::V1alpha::Audience]
        #     Required. The audience to create.
        class CreateAudienceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateAudience RPC.
        # @!attribute [rw] audience
        #   @return [::Google::Analytics::Admin::V1alpha::Audience]
        #     Required. The audience to update.
        #     The audience's `name` field is used to identify the audience to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateAudienceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ArchiveAudience RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Example format: properties/1234/audiences/5678
        class ArchiveAudienceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetAttributionSettings RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the attribution settings to retrieve.
        #     Format: properties/\\{property}/attributionSettings
        class GetAttributionSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateAttributionSettings RPC
        # @!attribute [rw] attribution_settings
        #   @return [::Google::Analytics::Admin::V1alpha::AttributionSettings]
        #     Required. The attribution settings to update.
        #     The `name` field is used to identify the settings to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateAttributionSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetAccessBinding RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the access binding to retrieve.
        #     Formats:
        #     - accounts/\\{account}/accessBindings/\\{accessBinding}
        #     - properties/\\{property}/accessBindings/\\{accessBinding}
        class GetAccessBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for BatchGetAccessBindings RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The account or property that owns the access bindings. The parent
        #     of all provided values for the 'names' field must match this field.
        #     Formats:
        #     - accounts/\\{account}
        #     - properties/\\{property}
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The names of the access bindings to retrieve.
        #     A maximum of 1000 access bindings can be retrieved in a batch.
        #     Formats:
        #     - accounts/\\{account}/accessBindings/\\{accessBinding}
        #     - properties/\\{property}/accessBindings/\\{accessBinding}
        class BatchGetAccessBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for BatchGetAccessBindings RPC.
        # @!attribute [rw] access_bindings
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessBinding>]
        #     The requested access bindings.
        class BatchGetAccessBindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListAccessBindings RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Formats:
        #     - accounts/\\{account}
        #     - properties/\\{property}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of access bindings to return.
        #     The service may return fewer than this value.
        #     If unspecified, at most 200 access bindings will be returned.
        #     The maximum value is 500; values above 500 will be coerced to 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAccessBindings` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListAccessBindings` must
        #     match the call that provided the page token.
        class ListAccessBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListAccessBindings RPC.
        # @!attribute [rw] access_bindings
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessBinding>]
        #     List of AccessBindings. These will be ordered stably, but in an arbitrary
        #     order.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAccessBindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateAccessBinding RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Formats:
        #     - accounts/\\{account}
        #     - properties/\\{property}
        # @!attribute [rw] access_binding
        #   @return [::Google::Analytics::Admin::V1alpha::AccessBinding]
        #     Required. The access binding to create.
        class CreateAccessBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for BatchCreateAccessBindings RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The account or property that owns the access bindings. The parent
        #     field in the CreateAccessBindingRequest messages must either be empty or
        #     match this field. Formats:
        #     - accounts/\\{account}
        #     - properties/\\{property}
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest>]
        #     Required. The requests specifying the access bindings to create.
        #     A maximum of 1000 access bindings can be created in a batch.
        class BatchCreateAccessBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for BatchCreateAccessBindings RPC.
        # @!attribute [rw] access_bindings
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessBinding>]
        #     The access bindings created.
        class BatchCreateAccessBindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateAccessBinding RPC.
        # @!attribute [rw] access_binding
        #   @return [::Google::Analytics::Admin::V1alpha::AccessBinding]
        #     Required. The access binding to update.
        class UpdateAccessBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for BatchUpdateAccessBindings RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The account or property that owns the access bindings. The parent
        #     of all provided AccessBinding in UpdateAccessBindingRequest messages must
        #     match this field.
        #     Formats:
        #     - accounts/\\{account}
        #     - properties/\\{property}
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest>]
        #     Required. The requests specifying the access bindings to update.
        #     A maximum of 1000 access bindings can be updated in a batch.
        class BatchUpdateAccessBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for BatchUpdateAccessBindings RPC.
        # @!attribute [rw] access_bindings
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AccessBinding>]
        #     The access bindings updated.
        class BatchUpdateAccessBindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteAccessBinding RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Formats:
        #     - accounts/\\{account}/accessBindings/\\{accessBinding}
        #     - properties/\\{property}/accessBindings/\\{accessBinding}
        class DeleteAccessBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for BatchDeleteAccessBindings RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The account or property that owns the access bindings. The parent
        #     of all provided values for the 'names' field in DeleteAccessBindingRequest
        #     messages must match this field. Formats:
        #     - accounts/\\{account}
        #     - properties/\\{property}
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest>]
        #     Required. The requests specifying the access bindings to delete.
        #     A maximum of 1000 access bindings can be deleted in a batch.
        class BatchDeleteAccessBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateExpandedDataSet RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] expanded_data_set
        #   @return [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
        #     Required. The ExpandedDataSet to create.
        class CreateExpandedDataSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateExpandedDataSet RPC.
        # @!attribute [rw] expanded_data_set
        #   @return [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
        #     Required. The ExpandedDataSet to update.
        #     The resource's `name` field is used to identify the ExpandedDataSet to be
        #     updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateExpandedDataSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteExpandedDataSet RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Example format: properties/1234/expandedDataSets/5678
        class DeleteExpandedDataSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetExpandedDataSet RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ExpandedDataSet to get.
        #     Example format: properties/1234/expandedDataSets/5678
        class GetExpandedDataSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListExpandedDataSets RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListExpandedDataSets` call. Provide
        #     this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListExpandedDataSet`
        #     must match the call that provided the page token.
        class ListExpandedDataSetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListExpandedDataSets RPC.
        # @!attribute [rw] expanded_data_sets
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ExpandedDataSet>]
        #     List of ExpandedDataSet. These will be ordered stably, but in an arbitrary
        #     order.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListExpandedDataSetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateChannelGroup RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The property for which to create a ChannelGroup.
        #     Example format: properties/1234
        # @!attribute [rw] channel_group
        #   @return [::Google::Analytics::Admin::V1alpha::ChannelGroup]
        #     Required. The ChannelGroup to create.
        class CreateChannelGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateChannelGroup RPC.
        # @!attribute [rw] channel_group
        #   @return [::Google::Analytics::Admin::V1alpha::ChannelGroup]
        #     Required. The ChannelGroup to update.
        #     The resource's `name` field is used to identify the ChannelGroup to be
        #     updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateChannelGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteChannelGroup RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ChannelGroup to delete.
        #     Example format: properties/1234/channelGroups/5678
        class DeleteChannelGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetChannelGroup RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ChannelGroup to get.
        #     Example format: properties/1234/channelGroups/5678
        class GetChannelGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListChannelGroups RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The property for which to list ChannelGroups.
        #     Example format: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListChannelGroups` call. Provide
        #     this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListChannelGroups`
        #     must match the call that provided the page token.
        class ListChannelGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListChannelGroups RPC.
        # @!attribute [rw] channel_groups
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ChannelGroup>]
        #     List of ChannelGroup. These will be ordered stably, but in an arbitrary
        #     order.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListChannelGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateBigQueryLink RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/1234
        # @!attribute [rw] bigquery_link
        #   @return [::Google::Analytics::Admin::V1alpha::BigQueryLink]
        #     Required. The BigQueryLink to create.
        class CreateBigQueryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetBigQueryLink RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the BigQuery link to lookup.
        #     Format: properties/\\{property_id}/bigQueryLinks/\\{bigquery_link_id}
        #     Example: properties/123/bigQueryLinks/456
        class GetBigQueryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListBigQueryLinks RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the property to list BigQuery links under.
        #     Format: properties/\\{property_id}
        #     Example: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListBigQueryLinks` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListBigQueryLinks` must
        #     match the call that provided the page token.
        class ListBigQueryLinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListBigQueryLinks RPC
        # @!attribute [rw] bigquery_links
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::BigQueryLink>]
        #     List of BigQueryLinks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListBigQueryLinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateBigQueryLink RPC.
        # @!attribute [rw] bigquery_link
        #   @return [::Google::Analytics::Admin::V1alpha::BigQueryLink]
        #     Required. The settings to update.
        #     The `name` field is used to identify the settings to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateBigQueryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteBigQueryLink RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The BigQueryLink to delete.
        #     Example format: properties/1234/bigQueryLinks/5678
        class DeleteBigQueryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetEnhancedMeasurementSettings RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the settings to lookup.
        #     Format:
        #     properties/\\{property}/dataStreams/\\{data_stream}/enhancedMeasurementSettings
        #     Example: "properties/1000/dataStreams/2000/enhancedMeasurementSettings"
        class GetEnhancedMeasurementSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateEnhancedMeasurementSettings RPC.
        # @!attribute [rw] enhanced_measurement_settings
        #   @return [::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings]
        #     Required. The settings to update.
        #     The `name` field is used to identify the settings to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateEnhancedMeasurementSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDataRedactionSettings RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the settings to lookup.
        #     Format:
        #     properties/\\{property}/dataStreams/\\{data_stream}/dataRedactionSettings
        #     Example: "properties/1000/dataStreams/2000/dataRedactionSettings"
        class GetDataRedactionSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDataRedactionSettings RPC.
        # @!attribute [rw] data_redaction_settings
        #   @return [::Google::Analytics::Admin::V1alpha::DataRedactionSettings]
        #     Required. The settings to update.
        #     The `name` field is used to identify the settings to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateDataRedactionSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to be passed to CreateAdSenseLink method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The property for which to create an AdSense Link.
        #     Format: properties/\\{propertyId}
        #     Example: properties/1234
        # @!attribute [rw] adsense_link
        #   @return [::Google::Analytics::Admin::V1alpha::AdSenseLink]
        #     Required. The AdSense Link to create
        class CreateAdSenseLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to be passed to GetAdSenseLink method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Unique identifier for the AdSense Link requested.
        #     Format: properties/\\{propertyId}/adSenseLinks/\\{linkId}
        #     Example: properties/1234/adSenseLinks/5678
        class GetAdSenseLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to be passed to DeleteAdSenseLink method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Unique identifier for the AdSense Link to be deleted.
        #     Format: properties/\\{propertyId}/adSenseLinks/\\{linkId}
        #     Example: properties/1234/adSenseLinks/5678
        class DeleteAdSenseLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to be passed to ListAdSenseLinks method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent property.
        #     Format: properties/\\{propertyId}
        #     Example: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token received from a previous `ListAdSenseLinks` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListAdSenseLinks` must
        #     match the call that provided the page token.
        class ListAdSenseLinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListAdSenseLinks method.
        # @!attribute [rw] adsense_links
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::AdSenseLink>]
        #     List of AdSenseLinks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAdSenseLinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateEventCreateRule RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/123/dataStreams/456
        # @!attribute [rw] event_create_rule
        #   @return [::Google::Analytics::Admin::V1alpha::EventCreateRule]
        #     Required. The EventCreateRule to create.
        class CreateEventCreateRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateEventCreateRule RPC.
        # @!attribute [rw] event_create_rule
        #   @return [::Google::Analytics::Admin::V1alpha::EventCreateRule]
        #     Required. The EventCreateRule to update.
        #     The resource's `name` field is used to identify the EventCreateRule to be
        #     updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateEventCreateRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteEventCreateRule RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Example format:
        #     properties/123/dataStreams/456/eventCreateRules/789
        class DeleteEventCreateRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetEventCreateRule RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the EventCreateRule to get.
        #     Example format: properties/123/dataStreams/456/eventCreateRules/789
        class GetEventCreateRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListEventCreateRules RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/123/dataStreams/456
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListEventCreateRules` call. Provide
        #     this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListEventCreateRules`
        #     must match the call that provided the page token.
        class ListEventCreateRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListEventCreateRules RPC.
        # @!attribute [rw] event_create_rules
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::EventCreateRule>]
        #     List of EventCreateRules. These will be ordered stably, but in an arbitrary
        #     order.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListEventCreateRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateEventEditRule RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/123/dataStreams/456
        # @!attribute [rw] event_edit_rule
        #   @return [::Google::Analytics::Admin::V1alpha::EventEditRule]
        #     Required. The EventEditRule to create.
        class CreateEventEditRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateEventEditRule RPC.
        # @!attribute [rw] event_edit_rule
        #   @return [::Google::Analytics::Admin::V1alpha::EventEditRule]
        #     Required. The EventEditRule to update.
        #     The resource's `name` field is used to identify the EventEditRule to be
        #     updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. Field names must be in snake
        #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateEventEditRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteEventEditRule RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Example format: properties/123/dataStreams/456/eventEditRules/789
        class DeleteEventEditRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetEventEditRule RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the EventEditRule to get.
        #     Example format: properties/123/dataStreams/456/eventEditRules/789
        class GetEventEditRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListEventEditRules RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/123/dataStreams/456
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of resources to return.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200 (higher values will be coerced to the maximum).
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListEventEditRules` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListEventEditRules`
        #     must match the call that provided the page token.
        class ListEventEditRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListEventEditRules RPC.
        # @!attribute [rw] event_edit_rules
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::EventEditRule>]
        #     List of EventEditRules. These will be ordered stably, but in an arbitrary
        #     order.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListEventEditRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ReorderEventEditRules RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Example format: properties/123/dataStreams/456
        # @!attribute [rw] event_edit_rules
        #   @return [::Array<::String>]
        #     Required. EventEditRule resource names for the specified data stream, in
        #     the needed processing order. All EventEditRules for the stream must be
        #     present in the list.
        class ReorderEventEditRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateRollupProperty RPC.
        # @!attribute [rw] rollup_property
        #   @return [::Google::Analytics::Admin::V1alpha::Property]
        #     Required. The roll-up property to create.
        # @!attribute [rw] source_properties
        #   @return [::Array<::String>]
        #     Optional. The resource names of properties that will be sources to the
        #     created roll-up property.
        class CreateRollupPropertyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for CreateRollupProperty RPC.
        # @!attribute [rw] rollup_property
        #   @return [::Google::Analytics::Admin::V1alpha::Property]
        #     The created roll-up property.
        # @!attribute [rw] rollup_property_source_links
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink>]
        #     The created roll-up property source links.
        class CreateRollupPropertyResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetRollupPropertySourceLink RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the roll-up property source link to lookup.
        #     Format:
        #     properties/\\{property_id}/rollupPropertySourceLinks/\\{rollup_property_source_link_id}
        #     Example: properties/123/rollupPropertySourceLinks/456
        class GetRollupPropertySourceLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRollupPropertySourceLinks RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the roll-up property to list roll-up property source
        #     links under. Format: properties/\\{property_id} Example: properties/1234
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages.
        #     If unspecified, at most 50 resources will be returned.
        #     The maximum value is 200; (higher values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListRollupPropertySourceLinks` call. Provide this to retrieve the
        #     subsequent page. When paginating, all other parameters provided to
        #     `ListRollupPropertySourceLinks` must match the call that provided the page
        #     token.
        class ListRollupPropertySourceLinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRollupPropertySourceLinks RPC.
        # @!attribute [rw] rollup_property_source_links
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink>]
        #     List of RollupPropertySourceLinks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListRollupPropertySourceLinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateRollupPropertySourceLink RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: properties/\\{property_id}
        #     Example: properties/1234
        # @!attribute [rw] rollup_property_source_link
        #   @return [::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink]
        #     Required. The roll-up property source link to create.
        class CreateRollupPropertySourceLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteRollupPropertySourceLink RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Format:
        #     properties/\\{property_id}/rollupPropertySourceLinks/\\{rollup_property_source_link_id}
        #     Example: properties/1234/rollupPropertySourceLinks/5678
        class DeleteRollupPropertySourceLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateSubproperty RPC.
        # @!attribute [rw] subproperty
        #   @return [::Google::Analytics::Admin::V1alpha::Property]
        #     Required. The subproperty to create.
        # @!attribute [rw] subproperty_event_filter
        #   @return [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
        #     Optional. The subproperty event filter to create on an ordinary property.
        # @!attribute [rw] custom_dimension_and_metric_synchronization_mode
        #   @return [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig::SynchronizationMode]
        #     Optional. The subproperty feature synchronization mode for Custom
        #     Dimensions and Metrics
        class ProvisionSubpropertyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ProvisionSubproperty RPC.
        # @!attribute [rw] subproperty
        #   @return [::Google::Analytics::Admin::V1alpha::Property]
        #     The created subproperty.
        # @!attribute [rw] subproperty_event_filter
        #   @return [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
        #     The created subproperty event filter.
        class ProvisionSubpropertyResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateSubpropertyEventFilter RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The ordinary property for which to create a subproperty event
        #     filter. Format: properties/property_id Example: properties/123
        # @!attribute [rw] subproperty_event_filter
        #   @return [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
        #     Required. The subproperty event filter to create.
        class CreateSubpropertyEventFilterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetSubpropertyEventFilter RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the subproperty event filter to lookup.
        #     Format:
        #     properties/property_id/subpropertyEventFilters/subproperty_event_filter
        #     Example: properties/123/subpropertyEventFilters/456
        class GetSubpropertyEventFilterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListSubpropertyEventFilters RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the ordinary property.
        #     Format: properties/property_id
        #     Example: properties/123
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages. If unspecified,
        #     at most 50 resources will be returned. The maximum value is 200; (higher
        #     values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListSubpropertyEventFilters` call. Provide this to retrieve the subsequent
        #     page. When paginating, all other parameters provided to
        #     `ListSubpropertyEventFilters` must match the call that provided the page
        #     token.
        class ListSubpropertyEventFiltersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListSubpropertyEventFilter RPC.
        # @!attribute [rw] subproperty_event_filters
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter>]
        #     List of subproperty event filters.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page. If
        #     this field is omitted, there are no subsequent pages.
        class ListSubpropertyEventFiltersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateSubpropertyEventFilter RPC.
        # @!attribute [rw] subproperty_event_filter
        #   @return [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
        #     Required. The subproperty event filter to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update. Field names must be in snake case
        #     (for example, "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateSubpropertyEventFilterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteSubpropertyEventFilter RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the subproperty event filter to delete.
        #     Format:
        #     properties/property_id/subpropertyEventFilters/subproperty_event_filter
        #     Example: properties/123/subpropertyEventFilters/456
        class DeleteSubpropertyEventFilterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateReportingDataAnnotation RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The property for which to create a Reporting Data Annotation.
        #     Format: properties/property_id
        #     Example: properties/123
        # @!attribute [rw] reporting_data_annotation
        #   @return [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
        #     Required. The Reporting Data Annotation to create.
        class CreateReportingDataAnnotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetReportingDataAnnotation RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the Reporting Data Annotation to lookup.
        #     Format:
        #     properties/property_id/reportingDataAnnotations/reportingDataAnnotation
        #     Example: properties/123/reportingDataAnnotations/456
        class GetReportingDataAnnotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListReportingDataAnnotation RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the property.
        #     Format: properties/property_id
        #     Example: properties/123
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter that restricts which reporting data annotations under the
        #     parent property are listed.
        #
        #     Supported fields are:
        #
        #       * 'name'
        #       * `title`
        #       * `description`
        #       * `annotation_date`
        #       * `annotation_date_range`
        #       * `color`
        #
        #     Additionally, this API provides the following helper functions:
        #
        #       * annotation_duration() : the duration that this annotation marks,
        #       [durations](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/duration.proto).
        #       expect a numeric representation of seconds followed by an `s` suffix.
        #       * is_annotation_in_range(start_date, end_date)  : if the annotation is in
        #       the range specified by the `start_date` and `end_date`. The dates are in
        #       ISO-8601 format, for example `2031-06-28`.
        #
        #     Supported operations:
        #
        #     * `=` : equals
        #     * `!=` : not equals
        #     * `<` : less than
        #     * `>` : greater than
        #     * `<=` :  less than or equals
        #     * `>=` : greater than or equals
        #     * `:` : has operator
        #     * `=~` : [regular expression](https://github.com/google/re2/wiki/Syntax)
        #     match
        #     * `!~` : [regular expression](https://github.com/google/re2/wiki/Syntax)
        #     does not match
        #     * `NOT` : Logical not
        #     * `AND` : Logical and
        #     * `OR` : Logical or
        #
        #     Examples:
        #
        #       1. `title="Holiday Sale"`
        #       2. `description=~"[Bb]ig [Gg]ame.*[Ss]ale"`
        #       3. `is_annotation_in_range("2025-12-25", "2026-01-16") = true`
        #       4. `annotation_duration() >= 172800s AND title:BOGO`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages. If unspecified,
        #     at most 50 resources will be returned. The maximum value is 200; (higher
        #     values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListReportingDataAnnotations` call. Provide this to retrieve the
        #     subsequent page. When paginating, all other parameters provided to
        #     `ListReportingDataAnnotations` must match the call that provided the page
        #     token.
        class ListReportingDataAnnotationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListReportingDataAnnotation RPC.
        # @!attribute [rw] reporting_data_annotations
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation>]
        #     List of Reporting Data Annotations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page. If
        #     this field is omitted, there are no subsequent pages.
        class ListReportingDataAnnotationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateReportingDataAnnotation RPC.
        # @!attribute [rw] reporting_data_annotation
        #   @return [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
        #     Required. The Reporting Data Annotation to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update. Field names must be in snake case
        #     (for example, "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateReportingDataAnnotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteReportingDataAnnotation RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the Reporting Data Annotation to delete.
        #     Format:
        #     properties/property_id/reportingDataAnnotations/reporting_data_annotation
        #     Example: properties/123/reportingDataAnnotations/456
        class DeleteReportingDataAnnotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for SubmitUserDeletion RPC.
        # @!attribute [rw] user_id
        #   @return [::String]
        #     Google Analytics [user
        #     ID](https://firebase.google.com/docs/analytics/userid).
        #
        #     Note: The following fields are mutually exclusive: `user_id`, `client_id`, `app_instance_id`, `user_provided_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] client_id
        #   @return [::String]
        #     Google Analytics [client
        #     ID](https://support.google.com/analytics/answer/11593727).
        #
        #     Note: The following fields are mutually exclusive: `client_id`, `user_id`, `app_instance_id`, `user_provided_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] app_instance_id
        #   @return [::String]
        #     Firebase [application instance
        #     ID](https://firebase.google.com/docs/reference/android/com/google/firebase/analytics/FirebaseAnalytics.html#getAppInstanceId).
        #
        #     Note: The following fields are mutually exclusive: `app_instance_id`, `user_id`, `client_id`, `user_provided_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] user_provided_data
        #   @return [::String]
        #     [User-provided
        #     data](https://support.google.com/analytics/answer/14077171).  May contain
        #     either one email address or one phone number.
        #
        #     Email addresses should be normalized as such:
        #
        #     * lowercase
        #     * remove periods before @ for gmail.com/googlemail.com addresses
        #     * remove all spaces
        #
        #     Phone numbers should be normalized as such:
        #
        #     * remove all non digit characters
        #     * add + prefix
        #
        #     Note: The following fields are mutually exclusive: `user_provided_data`, `user_id`, `client_id`, `app_instance_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the property to submit user deletion for.
        class SubmitUserDeletionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for SubmitUserDeletion RPC.
        # @!attribute [rw] deletion_request_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Marks the moment for which all visitor data before this point should be
        #     deleted. This is set to the time at which the deletion request was
        #     received.
        class SubmitUserDeletionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetSubpropertySyncConfig RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the SubpropertySyncConfig to lookup.
        #     Format:
        #     properties/\\{ordinary_property_id}/subpropertySyncConfigs/\\{subproperty_id}
        #     Example: properties/1234/subpropertySyncConfigs/5678
        class GetSubpropertySyncConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListSubpropertySyncConfigs RPC.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the property.
        #     Format: properties/property_id
        #     Example: properties/123
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of resources to return. The service may return
        #     fewer than this value, even if there are additional pages. If unspecified,
        #     at most 50 resources will be returned. The maximum value is 200; (higher
        #     values will be coerced to the maximum)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListSubpropertySyncConfig` call. Provide this to retrieve the subsequent
        #     page. When paginating, all other parameters provided to
        #     `ListSubpropertySyncConfig` must match the call that provided the page
        #     token.
        class ListSubpropertySyncConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListSubpropertySyncConfigs RPC.
        # @!attribute [rw] subproperty_sync_configs
        #   @return [::Array<::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig>]
        #     List of `SubpropertySyncConfig` resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page. If
        #     this field is omitted, there are no subsequent pages.
        class ListSubpropertySyncConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateSubpropertySyncConfig RPC.
        # @!attribute [rw] subproperty_sync_config
        #   @return [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig]
        #     Required. The `SubpropertySyncConfig` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update. Field names must be in snake case
        #     (for example, "field_to_update"). Omitted fields will not be updated. To
        #     replace the entire entity, use one path with the string "*" to match all
        #     fields.
        class UpdateSubpropertySyncConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetReportingIdentitySettings RPC.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the settings to lookup.
        #     Format:
        #     properties/\\{property}/reportingIdentitySettings
        #     Example: "properties/1000/reportingIdentitySettings"
        class GetReportingIdentitySettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
