# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/analytics/admin/v1alpha/analytics_admin_pb"
require "google/analytics/admin/v1alpha/analytics_admin_service/rest/service_stub"

module Google
  module Analytics
    module Admin
      module V1alpha
        module AnalyticsAdminService
          module Rest
            ##
            # REST client for the AnalyticsAdminService service.
            #
            # Service Interface for the Google Analytics Admin API.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "analyticsadmin.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :analytics_admin_service_stub

              ##
              # Configure the AnalyticsAdminService Client class.
              #
              # See {::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AnalyticsAdminService clients
              #   ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Analytics", "Admin", "V1alpha"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                  }

                  default_config.rpcs.get_account.timeout = 60.0

                  default_config.rpcs.list_accounts.timeout = 60.0

                  default_config.rpcs.delete_account.timeout = 60.0

                  default_config.rpcs.update_account.timeout = 60.0

                  default_config.rpcs.provision_account_ticket.timeout = 60.0

                  default_config.rpcs.get_property.timeout = 60.0

                  default_config.rpcs.list_properties.timeout = 60.0

                  default_config.rpcs.create_property.timeout = 60.0

                  default_config.rpcs.delete_property.timeout = 60.0

                  default_config.rpcs.update_property.timeout = 60.0

                  default_config.rpcs.create_firebase_link.timeout = 60.0

                  default_config.rpcs.delete_firebase_link.timeout = 60.0

                  default_config.rpcs.list_firebase_links.timeout = 60.0

                  default_config.rpcs.get_global_site_tag.timeout = 60.0

                  default_config.rpcs.create_google_ads_link.timeout = 60.0

                  default_config.rpcs.update_google_ads_link.timeout = 60.0

                  default_config.rpcs.delete_google_ads_link.timeout = 60.0

                  default_config.rpcs.list_google_ads_links.timeout = 60.0

                  default_config.rpcs.get_enhanced_measurement_settings.timeout = 60.0

                  default_config.rpcs.update_enhanced_measurement_settings.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AnalyticsAdminService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @analytics_admin_service_stub.universe_domain
              end

              ##
              # Create a new AnalyticsAdminService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AnalyticsAdminService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @analytics_admin_service_stub = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @analytics_admin_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @analytics_admin_service_stub.logger
              end

              # Service calls

              ##
              # Lookup for a single Account.
              #
              # @overload get_account(request, options = nil)
              #   Pass arguments to `get_account` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_account(name: nil)
              #   Pass arguments to `get_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the account to lookup.
              #     Format: accounts/\\{account}
              #     Example: "accounts/100"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Account]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Account]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetAccountRequest.new
              #
              #   # Call the get_account method.
              #   result = client.get_account request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Account.
              #   p result
              #
              def get_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns all accounts accessible by the caller.
              #
              # Note that these accounts might not currently have GA properties.
              # Soft-deleted (ie: "trashed") accounts are excluded by default.
              # Returns an empty list if no relevant accounts are found.
              #
              # @overload list_accounts(request, options = nil)
              #   Pass arguments to `list_accounts` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListAccountsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListAccountsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_accounts(page_size: nil, page_token: nil, show_deleted: nil)
              #   Pass arguments to `list_accounts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param page_size [::Integer]
              #     The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     A page token, received from a previous `ListAccounts` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListAccounts` must
              #     match the call that provided the page token.
              #   @param show_deleted [::Boolean]
              #     Whether to include soft-deleted (ie: "trashed") Accounts in the
              #     results. Accounts can be inspected to determine whether they are deleted or
              #     not.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::Account>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::Account>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListAccountsRequest.new
              #
              #   # Call the list_accounts method.
              #   result = client.list_accounts request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::Account.
              #     p item
              #   end
              #
              def list_accounts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListAccountsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_accounts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_accounts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_accounts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_accounts request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_accounts, "accounts", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks target Account as soft-deleted (ie: "trashed") and returns it.
              #
              # This API does not have a method to restore soft-deleted accounts.
              # However, they can be restored using the Trash Can UI.
              #
              # If the accounts are not restored before the expiration time, the account
              # and all child resources (eg: Properties, GoogleAdsLinks, Streams,
              # AccessBindings) will be permanently purged.
              # https://support.google.com/analytics/answer/6154772
              #
              # Returns an error if the target is not found.
              #
              # @overload delete_account(request, options = nil)
              #   Pass arguments to `delete_account` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_account(name: nil)
              #   Pass arguments to `delete_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Account to soft-delete.
              #     Format: accounts/\\{account}
              #     Example: "accounts/100"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteAccountRequest.new
              #
              #   # Call the delete_account method.
              #   result = client.delete_account request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an account.
              #
              # @overload update_account(request, options = nil)
              #   Pass arguments to `update_account` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_account(account: nil, update_mask: nil)
              #   Pass arguments to `update_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param account [::Google::Analytics::Admin::V1alpha::Account, ::Hash]
              #     Required. The account to update.
              #     The account's `name` field is used to identify the account.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (for example, "field_to_update"). Omitted fields will not be updated.
              #     To replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Account]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Account]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateAccountRequest.new
              #
              #   # Call the update_account method.
              #   result = client.update_account request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Account.
              #   p result
              #
              def update_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Requests a ticket for creating an account.
              #
              # @overload provision_account_ticket(request, options = nil)
              #   Pass arguments to `provision_account_ticket` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload provision_account_ticket(account: nil, redirect_uri: nil)
              #   Pass arguments to `provision_account_ticket` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param account [::Google::Analytics::Admin::V1alpha::Account, ::Hash]
              #     The account to create.
              #   @param redirect_uri [::String]
              #     Redirect URI where the user will be sent after accepting Terms of Service.
              #     Must be configured in Cloud Console as a Redirect URI.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest.new
              #
              #   # Call the provision_account_ticket method.
              #   result = client.provision_account_ticket request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ProvisionAccountTicketResponse.
              #   p result
              #
              def provision_account_ticket request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ProvisionAccountTicketRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.provision_account_ticket.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.provision_account_ticket.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.provision_account_ticket.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.provision_account_ticket request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns summaries of all accounts accessible by the caller.
              #
              # @overload list_account_summaries(request, options = nil)
              #   Pass arguments to `list_account_summaries` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_account_summaries(page_size: nil, page_token: nil)
              #   Pass arguments to `list_account_summaries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param page_size [::Integer]
              #     The maximum number of AccountSummary resources to return. The service may
              #     return fewer than this value, even if there are additional pages.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     A page token, received from a previous `ListAccountSummaries` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListAccountSummaries`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::AccountSummary>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::AccountSummary>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest.new
              #
              #   # Call the list_account_summaries method.
              #   result = client.list_account_summaries request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::AccountSummary.
              #     p item
              #   end
              #
              def list_account_summaries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListAccountSummariesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_account_summaries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_account_summaries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_account_summaries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_account_summaries request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_account_summaries, "account_summaries", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single GA Property.
              #
              # @overload get_property(request, options = nil)
              #   Pass arguments to `get_property` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetPropertyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetPropertyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_property(name: nil)
              #   Pass arguments to `get_property` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the property to lookup.
              #     Format: properties/\\{property_id}
              #     Example: "properties/1000"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Property]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Property]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetPropertyRequest.new
              #
              #   # Call the get_property method.
              #   result = client.get_property request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Property.
              #   p result
              #
              def get_property request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetPropertyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_property.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_property.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_property.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_property request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns child Properties under the specified parent Account.
              #
              # Properties will be excluded if the caller does not have access.
              # Soft-deleted (ie: "trashed") properties are excluded by default.
              # Returns an empty list if no relevant properties are found.
              #
              # @overload list_properties(request, options = nil)
              #   Pass arguments to `list_properties` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListPropertiesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListPropertiesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_properties(filter: nil, page_size: nil, page_token: nil, show_deleted: nil)
              #   Pass arguments to `list_properties` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param filter [::String]
              #     Required. An expression for filtering the results of the request.
              #     Fields eligible for filtering are:
              #     `parent:`(The resource name of the parent account/property) or
              #     `ancestor:`(The resource name of the parent account) or
              #     `firebase_project:`(The id or number of the linked firebase project).
              #     Some examples of filters:
              #
              #     ```
              #     | Filter                      | Description                               |
              #     |-----------------------------|-------------------------------------------|
              #     | parent:accounts/123         | The account with account id: 123.       |
              #     | parent:properties/123       | The property with property id: 123.       |
              #     | ancestor:accounts/123       | The account with account id: 123.         |
              #     | firebase_project:project-id | The firebase project with id: project-id. |
              #     | firebase_project:123        | The firebase project with number: 123.    |
              #     ```
              #   @param page_size [::Integer]
              #     The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     A page token, received from a previous `ListProperties` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListProperties` must
              #     match the call that provided the page token.
              #   @param show_deleted [::Boolean]
              #     Whether to include soft-deleted (ie: "trashed") Properties in the
              #     results. Properties can be inspected to determine whether they are deleted
              #     or not.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::Property>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::Property>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListPropertiesRequest.new
              #
              #   # Call the list_properties method.
              #   result = client.list_properties request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::Property.
              #     p item
              #   end
              #
              def list_properties request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListPropertiesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_properties.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_properties.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_properties.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_properties request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_properties, "properties", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Google Analytics property with the specified location and
              # attributes.
              #
              # @overload create_property(request, options = nil)
              #   Pass arguments to `create_property` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreatePropertyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreatePropertyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_property(property: nil)
              #   Pass arguments to `create_property` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param property [::Google::Analytics::Admin::V1alpha::Property, ::Hash]
              #     Required. The property to create.
              #     Note: the supplied property must specify its parent.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Property]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Property]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreatePropertyRequest.new
              #
              #   # Call the create_property method.
              #   result = client.create_property request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Property.
              #   p result
              #
              def create_property request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreatePropertyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_property.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_property.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_property.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_property request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks target Property as soft-deleted (ie: "trashed") and returns it.
              #
              # This API does not have a method to restore soft-deleted properties.
              # However, they can be restored using the Trash Can UI.
              #
              # If the properties are not restored before the expiration time, the Property
              # and all child resources (eg: GoogleAdsLinks, Streams, AccessBindings)
              # will be permanently purged.
              # https://support.google.com/analytics/answer/6154772
              #
              # Returns an error if the target is not found.
              #
              # @overload delete_property(request, options = nil)
              #   Pass arguments to `delete_property` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeletePropertyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeletePropertyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_property(name: nil)
              #   Pass arguments to `delete_property` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Property to soft-delete.
              #     Format: properties/\\{property_id}
              #     Example: "properties/1000"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Property]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Property]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeletePropertyRequest.new
              #
              #   # Call the delete_property method.
              #   result = client.delete_property request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Property.
              #   p result
              #
              def delete_property request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeletePropertyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_property.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_property.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_property.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_property request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a property.
              #
              # @overload update_property(request, options = nil)
              #   Pass arguments to `update_property` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdatePropertyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdatePropertyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_property(property: nil, update_mask: nil)
              #   Pass arguments to `update_property` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param property [::Google::Analytics::Admin::V1alpha::Property, ::Hash]
              #     Required. The property to update.
              #     The property's `name` field is used to identify the property to be
              #     updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Property]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Property]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdatePropertyRequest.new
              #
              #   # Call the update_property method.
              #   result = client.update_property request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Property.
              #   p result
              #
              def update_property request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdatePropertyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_property.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_property.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_property.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_property request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a FirebaseLink.
              #
              # Properties can have at most one FirebaseLink.
              #
              # @overload create_firebase_link(request, options = nil)
              #   Pass arguments to `create_firebase_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_firebase_link(parent: nil, firebase_link: nil)
              #   Pass arguments to `create_firebase_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format: properties/\\{property_id}
              #
              #     Example: `properties/1234`
              #   @param firebase_link [::Google::Analytics::Admin::V1alpha::FirebaseLink, ::Hash]
              #     Required. The Firebase link to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::FirebaseLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::FirebaseLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest.new
              #
              #   # Call the create_firebase_link method.
              #   result = client.create_firebase_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::FirebaseLink.
              #   p result
              #
              def create_firebase_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateFirebaseLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_firebase_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_firebase_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_firebase_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_firebase_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a FirebaseLink on a property
              #
              # @overload delete_firebase_link(request, options = nil)
              #   Pass arguments to `delete_firebase_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_firebase_link(name: nil)
              #   Pass arguments to `delete_firebase_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format: properties/\\{property_id}/firebaseLinks/\\{firebase_link_id}
              #
              #     Example: `properties/1234/firebaseLinks/5678`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest.new
              #
              #   # Call the delete_firebase_link method.
              #   result = client.delete_firebase_link request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_firebase_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteFirebaseLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_firebase_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_firebase_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_firebase_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_firebase_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists FirebaseLinks on a property.
              # Properties can have at most one FirebaseLink.
              #
              # @overload list_firebase_links(request, options = nil)
              #   Pass arguments to `list_firebase_links` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_firebase_links(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_firebase_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format: properties/\\{property_id}
              #
              #     Example: `properties/1234`
              #   @param page_size [::Integer]
              #     The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     A page token, received from a previous `ListFirebaseLinks` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListFirebaseLinks` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::FirebaseLink>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::FirebaseLink>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest.new
              #
              #   # Call the list_firebase_links method.
              #   result = client.list_firebase_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::FirebaseLink.
              #     p item
              #   end
              #
              def list_firebase_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListFirebaseLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_firebase_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_firebase_links.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_firebase_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_firebase_links request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_firebase_links, "firebase_links", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the Site Tag for the specified web stream.
              # Site Tags are immutable singletons.
              #
              # @overload get_global_site_tag(request, options = nil)
              #   Pass arguments to `get_global_site_tag` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_global_site_tag(name: nil)
              #   Pass arguments to `get_global_site_tag` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the site tag to lookup.
              #     Note that site tags are singletons and do not have unique IDs.
              #     Format: properties/\\{property_id}/dataStreams/\\{stream_id}/globalSiteTag
              #
              #     Example: `properties/123/dataStreams/456/globalSiteTag`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::GlobalSiteTag]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::GlobalSiteTag]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest.new
              #
              #   # Call the get_global_site_tag method.
              #   result = client.get_global_site_tag request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::GlobalSiteTag.
              #   p result
              #
              def get_global_site_tag request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetGlobalSiteTagRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_global_site_tag.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_global_site_tag.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_global_site_tag.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_global_site_tag request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a GoogleAdsLink.
              #
              # @overload create_google_ads_link(request, options = nil)
              #   Pass arguments to `create_google_ads_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_google_ads_link(parent: nil, google_ads_link: nil)
              #   Pass arguments to `create_google_ads_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param google_ads_link [::Google::Analytics::Admin::V1alpha::GoogleAdsLink, ::Hash]
              #     Required. The GoogleAdsLink to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::GoogleAdsLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::GoogleAdsLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest.new
              #
              #   # Call the create_google_ads_link method.
              #   result = client.create_google_ads_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::GoogleAdsLink.
              #   p result
              #
              def create_google_ads_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateGoogleAdsLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_google_ads_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_google_ads_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_google_ads_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_google_ads_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a GoogleAdsLink on a property
              #
              # @overload update_google_ads_link(request, options = nil)
              #   Pass arguments to `update_google_ads_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_google_ads_link(google_ads_link: nil, update_mask: nil)
              #   Pass arguments to `update_google_ads_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param google_ads_link [::Google::Analytics::Admin::V1alpha::GoogleAdsLink, ::Hash]
              #     The GoogleAdsLink to update
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::GoogleAdsLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::GoogleAdsLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest.new
              #
              #   # Call the update_google_ads_link method.
              #   result = client.update_google_ads_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::GoogleAdsLink.
              #   p result
              #
              def update_google_ads_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateGoogleAdsLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_google_ads_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_google_ads_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_google_ads_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_google_ads_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a GoogleAdsLink on a property
              #
              # @overload delete_google_ads_link(request, options = nil)
              #   Pass arguments to `delete_google_ads_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_google_ads_link(name: nil)
              #   Pass arguments to `delete_google_ads_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Example format: properties/1234/googleAdsLinks/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest.new
              #
              #   # Call the delete_google_ads_link method.
              #   result = client.delete_google_ads_link request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_google_ads_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteGoogleAdsLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_google_ads_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_google_ads_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_google_ads_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_google_ads_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists GoogleAdsLinks on a property.
              #
              # @overload list_google_ads_links(request, options = nil)
              #   Pass arguments to `list_google_ads_links` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_google_ads_links(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_google_ads_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListGoogleAdsLinks` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListGoogleAdsLinks` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::GoogleAdsLink>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::GoogleAdsLink>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest.new
              #
              #   # Call the list_google_ads_links method.
              #   result = client.list_google_ads_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::GoogleAdsLink.
              #     p item
              #   end
              #
              def list_google_ads_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListGoogleAdsLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_google_ads_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_google_ads_links.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_google_ads_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_google_ads_links request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_google_ads_links, "google_ads_links", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get data sharing settings on an account.
              # Data sharing settings are singletons.
              #
              # @overload get_data_sharing_settings(request, options = nil)
              #   Pass arguments to `get_data_sharing_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_data_sharing_settings(name: nil)
              #   Pass arguments to `get_data_sharing_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the settings to lookup.
              #     Format: accounts/\\{account}/dataSharingSettings
              #
              #     Example: `accounts/1000/dataSharingSettings`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DataSharingSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DataSharingSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest.new
              #
              #   # Call the get_data_sharing_settings method.
              #   result = client.get_data_sharing_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DataSharingSettings.
              #   p result
              #
              def get_data_sharing_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetDataSharingSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_data_sharing_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_data_sharing_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_data_sharing_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_data_sharing_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single MeasurementProtocolSecret.
              #
              # @overload get_measurement_protocol_secret(request, options = nil)
              #   Pass arguments to `get_measurement_protocol_secret` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_measurement_protocol_secret(name: nil)
              #   Pass arguments to `get_measurement_protocol_secret` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the measurement protocol secret to lookup.
              #     Format:
              #     properties/\\{property}/dataStreams/\\{dataStream}/measurementProtocolSecrets/\\{measurementProtocolSecret}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest.new
              #
              #   # Call the get_measurement_protocol_secret method.
              #   result = client.get_measurement_protocol_secret request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.
              #   p result
              #
              def get_measurement_protocol_secret request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetMeasurementProtocolSecretRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_measurement_protocol_secret.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_measurement_protocol_secret.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_measurement_protocol_secret.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_measurement_protocol_secret request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns child MeasurementProtocolSecrets under the specified parent
              # Property.
              #
              # @overload list_measurement_protocol_secrets(request, options = nil)
              #   Pass arguments to `list_measurement_protocol_secrets` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_measurement_protocol_secrets(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_measurement_protocol_secrets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent stream.
              #     Format:
              #     properties/\\{property}/dataStreams/\\{dataStream}/measurementProtocolSecrets
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 10 resources will be returned.
              #     The maximum value is 10. Higher values will be coerced to the maximum.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListMeasurementProtocolSecrets`
              #     call. Provide this to retrieve the subsequent page. When paginating, all
              #     other parameters provided to `ListMeasurementProtocolSecrets` must match
              #     the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest.new
              #
              #   # Call the list_measurement_protocol_secrets method.
              #   result = client.list_measurement_protocol_secrets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.
              #     p item
              #   end
              #
              def list_measurement_protocol_secrets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListMeasurementProtocolSecretsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_measurement_protocol_secrets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_measurement_protocol_secrets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_measurement_protocol_secrets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_measurement_protocol_secrets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_measurement_protocol_secrets, "measurement_protocol_secrets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a measurement protocol secret.
              #
              # @overload create_measurement_protocol_secret(request, options = nil)
              #   Pass arguments to `create_measurement_protocol_secret` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_measurement_protocol_secret(parent: nil, measurement_protocol_secret: nil)
              #   Pass arguments to `create_measurement_protocol_secret` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this secret will be created.
              #     Format: properties/\\{property}/dataStreams/\\{dataStream}
              #   @param measurement_protocol_secret [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret, ::Hash]
              #     Required. The measurement protocol secret to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest.new
              #
              #   # Call the create_measurement_protocol_secret method.
              #   result = client.create_measurement_protocol_secret request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.
              #   p result
              #
              def create_measurement_protocol_secret request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateMeasurementProtocolSecretRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_measurement_protocol_secret.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_measurement_protocol_secret.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_measurement_protocol_secret.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_measurement_protocol_secret request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes target MeasurementProtocolSecret.
              #
              # @overload delete_measurement_protocol_secret(request, options = nil)
              #   Pass arguments to `delete_measurement_protocol_secret` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_measurement_protocol_secret(name: nil)
              #   Pass arguments to `delete_measurement_protocol_secret` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the MeasurementProtocolSecret to delete.
              #     Format:
              #     properties/\\{property}/dataStreams/\\{dataStream}/measurementProtocolSecrets/\\{measurementProtocolSecret}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest.new
              #
              #   # Call the delete_measurement_protocol_secret method.
              #   result = client.delete_measurement_protocol_secret request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_measurement_protocol_secret request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteMeasurementProtocolSecretRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_measurement_protocol_secret.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_measurement_protocol_secret.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_measurement_protocol_secret.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_measurement_protocol_secret request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a measurement protocol secret.
              #
              # @overload update_measurement_protocol_secret(request, options = nil)
              #   Pass arguments to `update_measurement_protocol_secret` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_measurement_protocol_secret(measurement_protocol_secret: nil, update_mask: nil)
              #   Pass arguments to `update_measurement_protocol_secret` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param measurement_protocol_secret [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret, ::Hash]
              #     Required. The measurement protocol secret to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Omitted fields will not be
              #     updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest.new
              #
              #   # Call the update_measurement_protocol_secret method.
              #   result = client.update_measurement_protocol_secret request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::MeasurementProtocolSecret.
              #   p result
              #
              def update_measurement_protocol_secret request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateMeasurementProtocolSecretRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_measurement_protocol_secret.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_measurement_protocol_secret.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_measurement_protocol_secret.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_measurement_protocol_secret request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Acknowledges the terms of user data collection for the specified property.
              #
              # This acknowledgement must be completed (either in the Google Analytics UI
              # or through this API) before MeasurementProtocolSecret resources may be
              # created.
              #
              # @overload acknowledge_user_data_collection(request, options = nil)
              #   Pass arguments to `acknowledge_user_data_collection` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload acknowledge_user_data_collection(property: nil, acknowledgement: nil)
              #   Pass arguments to `acknowledge_user_data_collection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param property [::String]
              #     Required. The property for which to acknowledge user data collection.
              #   @param acknowledgement [::String]
              #     Required. An acknowledgement that the caller of this method understands the
              #     terms of user data collection.
              #
              #     This field must contain the exact value:
              #     "I acknowledge that I have the necessary privacy disclosures and rights
              #     from my end users for the collection and processing of their data,
              #     including the association of such data with the visitation information
              #     Google Analytics collects from my site and/or app property."
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest.new
              #
              #   # Call the acknowledge_user_data_collection method.
              #   result = client.acknowledge_user_data_collection request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionResponse.
              #   p result
              #
              def acknowledge_user_data_collection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::AcknowledgeUserDataCollectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.acknowledge_user_data_collection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.acknowledge_user_data_collection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.acknowledge_user_data_collection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.acknowledge_user_data_collection request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Looks up a single SKAdNetworkConversionValueSchema.
              #
              # @overload get_sk_ad_network_conversion_value_schema(request, options = nil)
              #   Pass arguments to `get_sk_ad_network_conversion_value_schema` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_sk_ad_network_conversion_value_schema(name: nil)
              #   Pass arguments to `get_sk_ad_network_conversion_value_schema` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of SKAdNetwork conversion value schema to look
              #     up. Format:
              #     properties/\\{property}/dataStreams/\\{dataStream}/sKAdNetworkConversionValueSchema/\\{skadnetwork_conversion_value_schema}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest.new
              #
              #   # Call the get_sk_ad_network_conversion_value_schema method.
              #   result = client.get_sk_ad_network_conversion_value_schema request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.
              #   p result
              #
              def get_sk_ad_network_conversion_value_schema request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetSKAdNetworkConversionValueSchemaRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_sk_ad_network_conversion_value_schema.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_sk_ad_network_conversion_value_schema.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_sk_ad_network_conversion_value_schema.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_sk_ad_network_conversion_value_schema request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a SKAdNetworkConversionValueSchema.
              #
              # @overload create_sk_ad_network_conversion_value_schema(request, options = nil)
              #   Pass arguments to `create_sk_ad_network_conversion_value_schema` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_sk_ad_network_conversion_value_schema(parent: nil, skadnetwork_conversion_value_schema: nil)
              #   Pass arguments to `create_sk_ad_network_conversion_value_schema` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this schema will be created.
              #     Format: properties/\\{property}/dataStreams/\\{dataStream}
              #   @param skadnetwork_conversion_value_schema [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema, ::Hash]
              #     Required. SKAdNetwork conversion value schema to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest.new
              #
              #   # Call the create_sk_ad_network_conversion_value_schema method.
              #   result = client.create_sk_ad_network_conversion_value_schema request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.
              #   p result
              #
              def create_sk_ad_network_conversion_value_schema request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateSKAdNetworkConversionValueSchemaRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_sk_ad_network_conversion_value_schema.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_sk_ad_network_conversion_value_schema.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_sk_ad_network_conversion_value_schema.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_sk_ad_network_conversion_value_schema request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes target SKAdNetworkConversionValueSchema.
              #
              # @overload delete_sk_ad_network_conversion_value_schema(request, options = nil)
              #   Pass arguments to `delete_sk_ad_network_conversion_value_schema` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_sk_ad_network_conversion_value_schema(name: nil)
              #   Pass arguments to `delete_sk_ad_network_conversion_value_schema` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the SKAdNetworkConversionValueSchema to delete.
              #     Format:
              #     properties/\\{property}/dataStreams/\\{dataStream}/sKAdNetworkConversionValueSchema/\\{skadnetwork_conversion_value_schema}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest.new
              #
              #   # Call the delete_sk_ad_network_conversion_value_schema method.
              #   result = client.delete_sk_ad_network_conversion_value_schema request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_sk_ad_network_conversion_value_schema request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteSKAdNetworkConversionValueSchemaRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_sk_ad_network_conversion_value_schema.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_sk_ad_network_conversion_value_schema.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_sk_ad_network_conversion_value_schema.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_sk_ad_network_conversion_value_schema request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a SKAdNetworkConversionValueSchema.
              #
              # @overload update_sk_ad_network_conversion_value_schema(request, options = nil)
              #   Pass arguments to `update_sk_ad_network_conversion_value_schema` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_sk_ad_network_conversion_value_schema(skadnetwork_conversion_value_schema: nil, update_mask: nil)
              #   Pass arguments to `update_sk_ad_network_conversion_value_schema` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param skadnetwork_conversion_value_schema [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema, ::Hash]
              #     Required. SKAdNetwork conversion value schema to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Omitted fields will not be
              #     updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest.new
              #
              #   # Call the update_sk_ad_network_conversion_value_schema method.
              #   result = client.update_sk_ad_network_conversion_value_schema request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.
              #   p result
              #
              def update_sk_ad_network_conversion_value_schema request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateSKAdNetworkConversionValueSchemaRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_sk_ad_network_conversion_value_schema.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_sk_ad_network_conversion_value_schema.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_sk_ad_network_conversion_value_schema.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_sk_ad_network_conversion_value_schema request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists SKAdNetworkConversionValueSchema on a stream.
              # Properties can have at most one SKAdNetworkConversionValueSchema.
              #
              # @overload list_sk_ad_network_conversion_value_schemas(request, options = nil)
              #   Pass arguments to `list_sk_ad_network_conversion_value_schemas` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_sk_ad_network_conversion_value_schemas(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_sk_ad_network_conversion_value_schemas` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The DataStream resource to list schemas for.
              #     Format:
              #     properties/\\{property_id}/dataStreams/\\{dataStream}
              #     Example: properties/1234/dataStreams/5678
              #   @param page_size [::Integer]
              #     The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     A page token, received from a previous
              #     `ListSKAdNetworkConversionValueSchemas` call. Provide this to retrieve the
              #     subsequent page. When paginating, all other parameters provided to
              #     `ListSKAdNetworkConversionValueSchema` must match the call that provided
              #     the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest.new
              #
              #   # Call the list_sk_ad_network_conversion_value_schemas method.
              #   result = client.list_sk_ad_network_conversion_value_schemas request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::SKAdNetworkConversionValueSchema.
              #     p item
              #   end
              #
              def list_sk_ad_network_conversion_value_schemas request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListSKAdNetworkConversionValueSchemasRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_sk_ad_network_conversion_value_schemas.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_sk_ad_network_conversion_value_schemas.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_sk_ad_network_conversion_value_schemas.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_sk_ad_network_conversion_value_schemas request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_sk_ad_network_conversion_value_schemas, "skadnetwork_conversion_value_schemas", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Searches through all changes to an account or its children given the
              # specified set of filters.
              #
              # Only returns the subset of changes supported by the API. The UI may return
              # additional changes.
              #
              # @overload search_change_history_events(request, options = nil)
              #   Pass arguments to `search_change_history_events` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_change_history_events(account: nil, property: nil, resource_type: nil, action: nil, actor_email: nil, earliest_change_time: nil, latest_change_time: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `search_change_history_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param account [::String]
              #     Required. The account resource for which to return change history
              #     resources. Format: accounts/\\{account}
              #
              #     Example: `accounts/100`
              #   @param property [::String]
              #     Optional. Resource name for a child property. If set, only return changes
              #     made to this property or its child resources.
              #     Format: properties/\\{propertyId}
              #
              #     Example: `properties/100`
              #   @param resource_type [::Array<::Google::Analytics::Admin::V1alpha::ChangeHistoryResourceType>]
              #     Optional. If set, only return changes if they are for a resource that
              #     matches at least one of these types.
              #   @param action [::Array<::Google::Analytics::Admin::V1alpha::ActionType>]
              #     Optional. If set, only return changes that match one or more of these types
              #     of actions.
              #   @param actor_email [::Array<::String>]
              #     Optional. If set, only return changes if they are made by a user in this
              #     list.
              #   @param earliest_change_time [::Google::Protobuf::Timestamp, ::Hash]
              #     Optional. If set, only return changes made after this time (inclusive).
              #   @param latest_change_time [::Google::Protobuf::Timestamp, ::Hash]
              #     Optional. If set, only return changes made before this time (inclusive).
              #   @param page_size [::Integer]
              #     Optional. The maximum number of ChangeHistoryEvent items to return.
              #     If unspecified, at most 50 items will be returned. The maximum value is 200
              #     (higher values will be coerced to the maximum).
              #
              #     Note that the service may return a page with fewer items than this value
              #     specifies (potentially even zero), and that there still may be additional
              #     pages. If you want a particular number of items, you'll need to continue
              #     requesting additional pages using `page_token` until you get the needed
              #     number.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     `SearchChangeHistoryEvents` call. Provide this to retrieve the subsequent
              #     page. When paginating, all other parameters provided to
              #     `SearchChangeHistoryEvents` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ChangeHistoryEvent>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ChangeHistoryEvent>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest.new
              #
              #   # Call the search_change_history_events method.
              #   result = client.search_change_history_events request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::ChangeHistoryEvent.
              #     p item
              #   end
              #
              def search_change_history_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::SearchChangeHistoryEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_change_history_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_change_history_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_change_history_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.search_change_history_events request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :search_change_history_events, "change_history_events", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for Google Signals settings for a property.
              #
              # @overload get_google_signals_settings(request, options = nil)
              #   Pass arguments to `get_google_signals_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_google_signals_settings(name: nil)
              #   Pass arguments to `get_google_signals_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the google signals settings to retrieve.
              #     Format: properties/\\{property}/googleSignalsSettings
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest.new
              #
              #   # Call the get_google_signals_settings method.
              #   result = client.get_google_signals_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::GoogleSignalsSettings.
              #   p result
              #
              def get_google_signals_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetGoogleSignalsSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_google_signals_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_google_signals_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_google_signals_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_google_signals_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates Google Signals settings for a property.
              #
              # @overload update_google_signals_settings(request, options = nil)
              #   Pass arguments to `update_google_signals_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_google_signals_settings(google_signals_settings: nil, update_mask: nil)
              #   Pass arguments to `update_google_signals_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param google_signals_settings [::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings, ::Hash]
              #     Required. The settings to update.
              #     The `name` field is used to identify the settings to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::GoogleSignalsSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest.new
              #
              #   # Call the update_google_signals_settings method.
              #   result = client.update_google_signals_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::GoogleSignalsSettings.
              #   p result
              #
              def update_google_signals_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateGoogleSignalsSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_google_signals_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_google_signals_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_google_signals_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_google_signals_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: Use `CreateKeyEvent` instead.
              # Creates a conversion event with the specified attributes.
              #
              # @overload create_conversion_event(request, options = nil)
              #   Pass arguments to `create_conversion_event` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateConversionEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateConversionEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_conversion_event(conversion_event: nil, parent: nil)
              #   Pass arguments to `create_conversion_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param conversion_event [::Google::Analytics::Admin::V1alpha::ConversionEvent, ::Hash]
              #     Required. The conversion event to create.
              #   @param parent [::String]
              #     Required. The resource name of the parent property where this conversion
              #     event will be created. Format: properties/123
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ConversionEvent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ConversionEvent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateConversionEventRequest.new
              #
              #   # Call the create_conversion_event method.
              #   result = client.create_conversion_event request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ConversionEvent.
              #   p result
              #
              def create_conversion_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateConversionEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_conversion_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_conversion_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_conversion_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_conversion_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: Use `UpdateKeyEvent` instead.
              # Updates a conversion event with the specified attributes.
              #
              # @overload update_conversion_event(request, options = nil)
              #   Pass arguments to `update_conversion_event` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_conversion_event(conversion_event: nil, update_mask: nil)
              #   Pass arguments to `update_conversion_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param conversion_event [::Google::Analytics::Admin::V1alpha::ConversionEvent, ::Hash]
              #     Required. The conversion event to update.
              #     The `name` field is used to identify the settings to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ConversionEvent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ConversionEvent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest.new
              #
              #   # Call the update_conversion_event method.
              #   result = client.update_conversion_event request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ConversionEvent.
              #   p result
              #
              def update_conversion_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateConversionEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_conversion_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_conversion_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_conversion_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_conversion_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: Use `GetKeyEvent` instead.
              # Retrieve a single conversion event.
              #
              # @overload get_conversion_event(request, options = nil)
              #   Pass arguments to `get_conversion_event` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetConversionEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetConversionEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_conversion_event(name: nil)
              #   Pass arguments to `get_conversion_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the conversion event to retrieve.
              #     Format: properties/\\{property}/conversionEvents/\\{conversion_event}
              #     Example: "properties/123/conversionEvents/456"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ConversionEvent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ConversionEvent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetConversionEventRequest.new
              #
              #   # Call the get_conversion_event method.
              #   result = client.get_conversion_event request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ConversionEvent.
              #   p result
              #
              def get_conversion_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetConversionEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_conversion_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_conversion_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_conversion_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_conversion_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: Use `DeleteKeyEvent` instead.
              # Deletes a conversion event in a property.
              #
              # @overload delete_conversion_event(request, options = nil)
              #   Pass arguments to `delete_conversion_event` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_conversion_event(name: nil)
              #   Pass arguments to `delete_conversion_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the conversion event to delete.
              #     Format: properties/\\{property}/conversionEvents/\\{conversion_event}
              #     Example: "properties/123/conversionEvents/456"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest.new
              #
              #   # Call the delete_conversion_event method.
              #   result = client.delete_conversion_event request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_conversion_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteConversionEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_conversion_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_conversion_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_conversion_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_conversion_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: Use `ListKeyEvents` instead.
              # Returns a list of conversion events in the specified parent property.
              #
              # Returns an empty list if no conversion events are found.
              #
              # @overload list_conversion_events(request, options = nil)
              #   Pass arguments to `list_conversion_events` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListConversionEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListConversionEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_conversion_events(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_conversion_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent property.
              #     Example: 'properties/123'
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     A page token, received from a previous `ListConversionEvents` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListConversionEvents`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ConversionEvent>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ConversionEvent>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListConversionEventsRequest.new
              #
              #   # Call the list_conversion_events method.
              #   result = client.list_conversion_events request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::ConversionEvent.
              #     p item
              #   end
              #
              def list_conversion_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListConversionEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_conversion_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_conversion_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_conversion_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_conversion_events request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_conversion_events, "conversion_events", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Key Event.
              #
              # @overload create_key_event(request, options = nil)
              #   Pass arguments to `create_key_event` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateKeyEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateKeyEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_key_event(key_event: nil, parent: nil)
              #   Pass arguments to `create_key_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param key_event [::Google::Analytics::Admin::V1alpha::KeyEvent, ::Hash]
              #     Required. The Key Event to create.
              #   @param parent [::String]
              #     Required. The resource name of the parent property where this Key Event
              #     will be created. Format: properties/123
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::KeyEvent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::KeyEvent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateKeyEventRequest.new
              #
              #   # Call the create_key_event method.
              #   result = client.create_key_event request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::KeyEvent.
              #   p result
              #
              def create_key_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateKeyEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_key_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_key_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_key_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_key_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a Key Event.
              #
              # @overload update_key_event(request, options = nil)
              #   Pass arguments to `update_key_event` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_key_event(key_event: nil, update_mask: nil)
              #   Pass arguments to `update_key_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param key_event [::Google::Analytics::Admin::V1alpha::KeyEvent, ::Hash]
              #     Required. The Key Event to update.
              #     The `name` field is used to identify the settings to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::KeyEvent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::KeyEvent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest.new
              #
              #   # Call the update_key_event method.
              #   result = client.update_key_event request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::KeyEvent.
              #   p result
              #
              def update_key_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateKeyEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_key_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_key_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_key_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_key_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieve a single Key Event.
              #
              # @overload get_key_event(request, options = nil)
              #   Pass arguments to `get_key_event` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetKeyEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetKeyEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_key_event(name: nil)
              #   Pass arguments to `get_key_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Key Event to retrieve.
              #     Format: properties/\\{property}/keyEvents/\\{key_event}
              #     Example: "properties/123/keyEvents/456"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::KeyEvent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::KeyEvent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetKeyEventRequest.new
              #
              #   # Call the get_key_event method.
              #   result = client.get_key_event request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::KeyEvent.
              #   p result
              #
              def get_key_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetKeyEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_key_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_key_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_key_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_key_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Key Event.
              #
              # @overload delete_key_event(request, options = nil)
              #   Pass arguments to `delete_key_event` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_key_event(name: nil)
              #   Pass arguments to `delete_key_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Key Event to delete.
              #     Format: properties/\\{property}/keyEvents/\\{key_event}
              #     Example: "properties/123/keyEvents/456"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest.new
              #
              #   # Call the delete_key_event method.
              #   result = client.delete_key_event request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_key_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteKeyEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_key_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_key_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_key_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_key_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of Key Events in the specified parent property.
              # Returns an empty list if no Key Events are found.
              #
              # @overload list_key_events(request, options = nil)
              #   Pass arguments to `list_key_events` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListKeyEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListKeyEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_key_events(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_key_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent property.
              #     Example: 'properties/123'
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     A page token, received from a previous `ListKeyEvents` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListKeyEvents`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::KeyEvent>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::KeyEvent>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListKeyEventsRequest.new
              #
              #   # Call the list_key_events method.
              #   result = client.list_key_events request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::KeyEvent.
              #     p item
              #   end
              #
              def list_key_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListKeyEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_key_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_key_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_key_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_key_events request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_key_events, "key_events", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Look up a single DisplayVideo360AdvertiserLink
              #
              # @overload get_display_video360_advertiser_link(request, options = nil)
              #   Pass arguments to `get_display_video360_advertiser_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_display_video360_advertiser_link(name: nil)
              #   Pass arguments to `get_display_video360_advertiser_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DisplayVideo360AdvertiserLink to get.
              #     Example format: properties/1234/displayVideo360AdvertiserLink/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest.new
              #
              #   # Call the get_display_video360_advertiser_link method.
              #   result = client.get_display_video360_advertiser_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.
              #   p result
              #
              def get_display_video360_advertiser_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_display_video360_advertiser_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_display_video360_advertiser_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_display_video360_advertiser_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_display_video360_advertiser_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all DisplayVideo360AdvertiserLinks on a property.
              #
              # @overload list_display_video360_advertiser_links(request, options = nil)
              #   Pass arguments to `list_display_video360_advertiser_links` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_display_video360_advertiser_links(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_display_video360_advertiser_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListDisplayVideo360AdvertiserLinks`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListDisplayVideo360AdvertiserLinks` must match the call that provided the
              #     page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest.new
              #
              #   # Call the list_display_video360_advertiser_links method.
              #   result = client.list_display_video360_advertiser_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.
              #     p item
              #   end
              #
              def list_display_video360_advertiser_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_display_video360_advertiser_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_display_video360_advertiser_links.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_display_video360_advertiser_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_display_video360_advertiser_links request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_display_video360_advertiser_links, "display_video_360_advertiser_links", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a DisplayVideo360AdvertiserLink.
              # This can only be utilized by users who have proper authorization both on
              # the Google Analytics property and on the Display & Video 360 advertiser.
              # Users who do not have access to the Display & Video 360 advertiser should
              # instead seek to create a DisplayVideo360LinkProposal.
              #
              # @overload create_display_video360_advertiser_link(request, options = nil)
              #   Pass arguments to `create_display_video360_advertiser_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_display_video360_advertiser_link(parent: nil, display_video_360_advertiser_link: nil)
              #   Pass arguments to `create_display_video360_advertiser_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param display_video_360_advertiser_link [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink, ::Hash]
              #     Required. The DisplayVideo360AdvertiserLink to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest.new
              #
              #   # Call the create_display_video360_advertiser_link method.
              #   result = client.create_display_video360_advertiser_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.
              #   p result
              #
              def create_display_video360_advertiser_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_display_video360_advertiser_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_display_video360_advertiser_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_display_video360_advertiser_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_display_video360_advertiser_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a DisplayVideo360AdvertiserLink on a property.
              #
              # @overload delete_display_video360_advertiser_link(request, options = nil)
              #   Pass arguments to `delete_display_video360_advertiser_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_display_video360_advertiser_link(name: nil)
              #   Pass arguments to `delete_display_video360_advertiser_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DisplayVideo360AdvertiserLink to delete.
              #     Example format: properties/1234/displayVideo360AdvertiserLinks/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest.new
              #
              #   # Call the delete_display_video360_advertiser_link method.
              #   result = client.delete_display_video360_advertiser_link request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_display_video360_advertiser_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_display_video360_advertiser_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_display_video360_advertiser_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_display_video360_advertiser_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_display_video360_advertiser_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a DisplayVideo360AdvertiserLink on a property.
              #
              # @overload update_display_video360_advertiser_link(request, options = nil)
              #   Pass arguments to `update_display_video360_advertiser_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_display_video360_advertiser_link(display_video_360_advertiser_link: nil, update_mask: nil)
              #   Pass arguments to `update_display_video360_advertiser_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param display_video_360_advertiser_link [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink, ::Hash]
              #     The DisplayVideo360AdvertiserLink to update
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Omitted fields will not be
              #     updated. To replace the entire entity, use one path with the string "*" to
              #     match all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest.new
              #
              #   # Call the update_display_video360_advertiser_link method.
              #   result = client.update_display_video360_advertiser_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLink.
              #   p result
              #
              def update_display_video360_advertiser_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateDisplayVideo360AdvertiserLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_display_video360_advertiser_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_display_video360_advertiser_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_display_video360_advertiser_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_display_video360_advertiser_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single DisplayVideo360AdvertiserLinkProposal.
              #
              # @overload get_display_video360_advertiser_link_proposal(request, options = nil)
              #   Pass arguments to `get_display_video360_advertiser_link_proposal` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_display_video360_advertiser_link_proposal(name: nil)
              #   Pass arguments to `get_display_video360_advertiser_link_proposal` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DisplayVideo360AdvertiserLinkProposal to get.
              #     Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest.new
              #
              #   # Call the get_display_video360_advertiser_link_proposal method.
              #   result = client.get_display_video360_advertiser_link_proposal request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.
              #   p result
              #
              def get_display_video360_advertiser_link_proposal request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetDisplayVideo360AdvertiserLinkProposalRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_display_video360_advertiser_link_proposal.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_display_video360_advertiser_link_proposal.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_display_video360_advertiser_link_proposal.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_display_video360_advertiser_link_proposal request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DisplayVideo360AdvertiserLinkProposals on a property.
              #
              # @overload list_display_video360_advertiser_link_proposals(request, options = nil)
              #   Pass arguments to `list_display_video360_advertiser_link_proposals` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_display_video360_advertiser_link_proposals(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_display_video360_advertiser_link_proposals` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous
              #     `ListDisplayVideo360AdvertiserLinkProposals` call. Provide this to retrieve
              #     the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListDisplayVideo360AdvertiserLinkProposals` must match the call that
              #     provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest.new
              #
              #   # Call the list_display_video360_advertiser_link_proposals method.
              #   result = client.list_display_video360_advertiser_link_proposals request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.
              #     p item
              #   end
              #
              def list_display_video360_advertiser_link_proposals request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListDisplayVideo360AdvertiserLinkProposalsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_display_video360_advertiser_link_proposals.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_display_video360_advertiser_link_proposals.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_display_video360_advertiser_link_proposals.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_display_video360_advertiser_link_proposals request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_display_video360_advertiser_link_proposals, "display_video_360_advertiser_link_proposals", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a DisplayVideo360AdvertiserLinkProposal.
              #
              # @overload create_display_video360_advertiser_link_proposal(request, options = nil)
              #   Pass arguments to `create_display_video360_advertiser_link_proposal` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_display_video360_advertiser_link_proposal(parent: nil, display_video_360_advertiser_link_proposal: nil)
              #   Pass arguments to `create_display_video360_advertiser_link_proposal` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param display_video_360_advertiser_link_proposal [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal, ::Hash]
              #     Required. The DisplayVideo360AdvertiserLinkProposal to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest.new
              #
              #   # Call the create_display_video360_advertiser_link_proposal method.
              #   result = client.create_display_video360_advertiser_link_proposal request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.
              #   p result
              #
              def create_display_video360_advertiser_link_proposal request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateDisplayVideo360AdvertiserLinkProposalRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_display_video360_advertiser_link_proposal.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_display_video360_advertiser_link_proposal.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_display_video360_advertiser_link_proposal.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_display_video360_advertiser_link_proposal request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
              # This can only be used on cancelled proposals.
              #
              # @overload delete_display_video360_advertiser_link_proposal(request, options = nil)
              #   Pass arguments to `delete_display_video360_advertiser_link_proposal` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_display_video360_advertiser_link_proposal(name: nil)
              #   Pass arguments to `delete_display_video360_advertiser_link_proposal` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DisplayVideo360AdvertiserLinkProposal to delete.
              #     Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest.new
              #
              #   # Call the delete_display_video360_advertiser_link_proposal method.
              #   result = client.delete_display_video360_advertiser_link_proposal request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_display_video360_advertiser_link_proposal request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteDisplayVideo360AdvertiserLinkProposalRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_display_video360_advertiser_link_proposal.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_display_video360_advertiser_link_proposal.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_display_video360_advertiser_link_proposal.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_display_video360_advertiser_link_proposal request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Approves a DisplayVideo360AdvertiserLinkProposal.
              # The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
              # DisplayVideo360AdvertiserLink will be created.
              #
              # @overload approve_display_video360_advertiser_link_proposal(request, options = nil)
              #   Pass arguments to `approve_display_video360_advertiser_link_proposal` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload approve_display_video360_advertiser_link_proposal(name: nil)
              #   Pass arguments to `approve_display_video360_advertiser_link_proposal` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DisplayVideo360AdvertiserLinkProposal to approve.
              #     Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest.new
              #
              #   # Call the approve_display_video360_advertiser_link_proposal method.
              #   result = client.approve_display_video360_advertiser_link_proposal request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalResponse.
              #   p result
              #
              def approve_display_video360_advertiser_link_proposal request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ApproveDisplayVideo360AdvertiserLinkProposalRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.approve_display_video360_advertiser_link_proposal.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.approve_display_video360_advertiser_link_proposal.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.approve_display_video360_advertiser_link_proposal.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.approve_display_video360_advertiser_link_proposal request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Cancels a DisplayVideo360AdvertiserLinkProposal.
              # Cancelling can mean either:
              # - Declining a proposal initiated from Display & Video 360
              # - Withdrawing a proposal initiated from Google Analytics
              # After being cancelled, a proposal will eventually be deleted automatically.
              #
              # @overload cancel_display_video360_advertiser_link_proposal(request, options = nil)
              #   Pass arguments to `cancel_display_video360_advertiser_link_proposal` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_display_video360_advertiser_link_proposal(name: nil)
              #   Pass arguments to `cancel_display_video360_advertiser_link_proposal` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DisplayVideo360AdvertiserLinkProposal to cancel.
              #     Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest.new
              #
              #   # Call the cancel_display_video360_advertiser_link_proposal method.
              #   result = client.cancel_display_video360_advertiser_link_proposal request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DisplayVideo360AdvertiserLinkProposal.
              #   p result
              #
              def cancel_display_video360_advertiser_link_proposal request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CancelDisplayVideo360AdvertiserLinkProposalRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_display_video360_advertiser_link_proposal.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_display_video360_advertiser_link_proposal.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_display_video360_advertiser_link_proposal.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.cancel_display_video360_advertiser_link_proposal request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a CustomDimension.
              #
              # @overload create_custom_dimension(request, options = nil)
              #   Pass arguments to `create_custom_dimension` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_custom_dimension(parent: nil, custom_dimension: nil)
              #   Pass arguments to `create_custom_dimension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param custom_dimension [::Google::Analytics::Admin::V1alpha::CustomDimension, ::Hash]
              #     Required. The CustomDimension to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CustomDimension]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CustomDimension]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest.new
              #
              #   # Call the create_custom_dimension method.
              #   result = client.create_custom_dimension request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CustomDimension.
              #   p result
              #
              def create_custom_dimension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateCustomDimensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_custom_dimension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_custom_dimension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_custom_dimension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_custom_dimension request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a CustomDimension on a property.
              #
              # @overload update_custom_dimension(request, options = nil)
              #   Pass arguments to `update_custom_dimension` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_custom_dimension(custom_dimension: nil, update_mask: nil)
              #   Pass arguments to `update_custom_dimension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param custom_dimension [::Google::Analytics::Admin::V1alpha::CustomDimension, ::Hash]
              #     The CustomDimension to update
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Omitted fields will not be
              #     updated. To replace the entire entity, use one path with the string "*" to
              #     match all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CustomDimension]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CustomDimension]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest.new
              #
              #   # Call the update_custom_dimension method.
              #   result = client.update_custom_dimension request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CustomDimension.
              #   p result
              #
              def update_custom_dimension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateCustomDimensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_custom_dimension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_custom_dimension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_custom_dimension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_custom_dimension request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists CustomDimensions on a property.
              #
              # @overload list_custom_dimensions(request, options = nil)
              #   Pass arguments to `list_custom_dimensions` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_custom_dimensions(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_custom_dimensions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListCustomDimensions` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListCustomDimensions`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::CustomDimension>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::CustomDimension>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest.new
              #
              #   # Call the list_custom_dimensions method.
              #   result = client.list_custom_dimensions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::CustomDimension.
              #     p item
              #   end
              #
              def list_custom_dimensions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListCustomDimensionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_custom_dimensions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_custom_dimensions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_custom_dimensions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_custom_dimensions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_custom_dimensions, "custom_dimensions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Archives a CustomDimension on a property.
              #
              # @overload archive_custom_dimension(request, options = nil)
              #   Pass arguments to `archive_custom_dimension` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload archive_custom_dimension(name: nil)
              #   Pass arguments to `archive_custom_dimension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CustomDimension to archive.
              #     Example format: properties/1234/customDimensions/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest.new
              #
              #   # Call the archive_custom_dimension method.
              #   result = client.archive_custom_dimension request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def archive_custom_dimension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ArchiveCustomDimensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.archive_custom_dimension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.archive_custom_dimension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.archive_custom_dimension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.archive_custom_dimension request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single CustomDimension.
              #
              # @overload get_custom_dimension(request, options = nil)
              #   Pass arguments to `get_custom_dimension` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_custom_dimension(name: nil)
              #   Pass arguments to `get_custom_dimension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CustomDimension to get.
              #     Example format: properties/1234/customDimensions/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CustomDimension]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CustomDimension]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest.new
              #
              #   # Call the get_custom_dimension method.
              #   result = client.get_custom_dimension request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CustomDimension.
              #   p result
              #
              def get_custom_dimension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetCustomDimensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_custom_dimension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_custom_dimension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_custom_dimension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_custom_dimension request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a CustomMetric.
              #
              # @overload create_custom_metric(request, options = nil)
              #   Pass arguments to `create_custom_metric` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_custom_metric(parent: nil, custom_metric: nil)
              #   Pass arguments to `create_custom_metric` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param custom_metric [::Google::Analytics::Admin::V1alpha::CustomMetric, ::Hash]
              #     Required. The CustomMetric to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CustomMetric]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CustomMetric]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest.new
              #
              #   # Call the create_custom_metric method.
              #   result = client.create_custom_metric request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CustomMetric.
              #   p result
              #
              def create_custom_metric request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateCustomMetricRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_custom_metric.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_custom_metric.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_custom_metric.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_custom_metric request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a CustomMetric on a property.
              #
              # @overload update_custom_metric(request, options = nil)
              #   Pass arguments to `update_custom_metric` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_custom_metric(custom_metric: nil, update_mask: nil)
              #   Pass arguments to `update_custom_metric` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param custom_metric [::Google::Analytics::Admin::V1alpha::CustomMetric, ::Hash]
              #     The CustomMetric to update
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Omitted fields will not be
              #     updated. To replace the entire entity, use one path with the string "*" to
              #     match all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CustomMetric]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CustomMetric]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest.new
              #
              #   # Call the update_custom_metric method.
              #   result = client.update_custom_metric request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CustomMetric.
              #   p result
              #
              def update_custom_metric request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateCustomMetricRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_custom_metric.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_custom_metric.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_custom_metric.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_custom_metric request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists CustomMetrics on a property.
              #
              # @overload list_custom_metrics(request, options = nil)
              #   Pass arguments to `list_custom_metrics` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_custom_metrics(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_custom_metrics` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListCustomMetrics` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListCustomMetrics` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::CustomMetric>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::CustomMetric>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest.new
              #
              #   # Call the list_custom_metrics method.
              #   result = client.list_custom_metrics request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::CustomMetric.
              #     p item
              #   end
              #
              def list_custom_metrics request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListCustomMetricsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_custom_metrics.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_custom_metrics.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_custom_metrics.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_custom_metrics request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_custom_metrics, "custom_metrics", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Archives a CustomMetric on a property.
              #
              # @overload archive_custom_metric(request, options = nil)
              #   Pass arguments to `archive_custom_metric` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload archive_custom_metric(name: nil)
              #   Pass arguments to `archive_custom_metric` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CustomMetric to archive.
              #     Example format: properties/1234/customMetrics/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest.new
              #
              #   # Call the archive_custom_metric method.
              #   result = client.archive_custom_metric request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def archive_custom_metric request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ArchiveCustomMetricRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.archive_custom_metric.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.archive_custom_metric.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.archive_custom_metric.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.archive_custom_metric request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single CustomMetric.
              #
              # @overload get_custom_metric(request, options = nil)
              #   Pass arguments to `get_custom_metric` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetCustomMetricRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetCustomMetricRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_custom_metric(name: nil)
              #   Pass arguments to `get_custom_metric` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CustomMetric to get.
              #     Example format: properties/1234/customMetrics/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CustomMetric]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CustomMetric]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetCustomMetricRequest.new
              #
              #   # Call the get_custom_metric method.
              #   result = client.get_custom_metric request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CustomMetric.
              #   p result
              #
              def get_custom_metric request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetCustomMetricRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_custom_metric.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_custom_metric.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_custom_metric.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_custom_metric request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the singleton data retention settings for this property.
              #
              # @overload get_data_retention_settings(request, options = nil)
              #   Pass arguments to `get_data_retention_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_data_retention_settings(name: nil)
              #   Pass arguments to `get_data_retention_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the settings to lookup.
              #     Format:
              #     properties/\\{property}/dataRetentionSettings
              #     Example: "properties/1000/dataRetentionSettings"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DataRetentionSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DataRetentionSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest.new
              #
              #   # Call the get_data_retention_settings method.
              #   result = client.get_data_retention_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DataRetentionSettings.
              #   p result
              #
              def get_data_retention_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetDataRetentionSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_data_retention_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_data_retention_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_data_retention_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_data_retention_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the singleton data retention settings for this property.
              #
              # @overload update_data_retention_settings(request, options = nil)
              #   Pass arguments to `update_data_retention_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_data_retention_settings(data_retention_settings: nil, update_mask: nil)
              #   Pass arguments to `update_data_retention_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param data_retention_settings [::Google::Analytics::Admin::V1alpha::DataRetentionSettings, ::Hash]
              #     Required. The settings to update.
              #     The `name` field is used to identify the settings to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DataRetentionSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DataRetentionSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest.new
              #
              #   # Call the update_data_retention_settings method.
              #   result = client.update_data_retention_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DataRetentionSettings.
              #   p result
              #
              def update_data_retention_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateDataRetentionSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_data_retention_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_data_retention_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_data_retention_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_data_retention_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a DataStream.
              #
              # @overload create_data_stream(request, options = nil)
              #   Pass arguments to `create_data_stream` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateDataStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateDataStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_data_stream(parent: nil, data_stream: nil)
              #   Pass arguments to `create_data_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param data_stream [::Google::Analytics::Admin::V1alpha::DataStream, ::Hash]
              #     Required. The DataStream to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DataStream]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DataStream]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateDataStreamRequest.new
              #
              #   # Call the create_data_stream method.
              #   result = client.create_data_stream request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DataStream.
              #   p result
              #
              def create_data_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateDataStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_data_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_data_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_data_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_data_stream request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a DataStream on a property.
              #
              # @overload delete_data_stream(request, options = nil)
              #   Pass arguments to `delete_data_stream` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_data_stream(name: nil)
              #   Pass arguments to `delete_data_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DataStream to delete.
              #     Example format: properties/1234/dataStreams/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest.new
              #
              #   # Call the delete_data_stream method.
              #   result = client.delete_data_stream request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_data_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteDataStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_data_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_data_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_data_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_data_stream request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a DataStream on a property.
              #
              # @overload update_data_stream(request, options = nil)
              #   Pass arguments to `update_data_stream` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_data_stream(data_stream: nil, update_mask: nil)
              #   Pass arguments to `update_data_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param data_stream [::Google::Analytics::Admin::V1alpha::DataStream, ::Hash]
              #     The DataStream to update
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Omitted fields will not be
              #     updated. To replace the entire entity, use one path with the string "*" to
              #     match all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DataStream]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DataStream]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest.new
              #
              #   # Call the update_data_stream method.
              #   result = client.update_data_stream request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DataStream.
              #   p result
              #
              def update_data_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateDataStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_data_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_data_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_data_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_data_stream request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DataStreams on a property.
              #
              # @overload list_data_streams(request, options = nil)
              #   Pass arguments to `list_data_streams` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListDataStreamsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListDataStreamsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_data_streams(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_data_streams` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListDataStreams` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListDataStreams` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::DataStream>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::DataStream>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListDataStreamsRequest.new
              #
              #   # Call the list_data_streams method.
              #   result = client.list_data_streams request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::DataStream.
              #     p item
              #   end
              #
              def list_data_streams request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListDataStreamsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_data_streams.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_data_streams.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_data_streams.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_data_streams request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_data_streams, "data_streams", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single DataStream.
              #
              # @overload get_data_stream(request, options = nil)
              #   Pass arguments to `get_data_stream` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetDataStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetDataStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_data_stream(name: nil)
              #   Pass arguments to `get_data_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DataStream to get.
              #     Example format: properties/1234/dataStreams/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DataStream]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DataStream]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetDataStreamRequest.new
              #
              #   # Call the get_data_stream method.
              #   result = client.get_data_stream request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DataStream.
              #   p result
              #
              def get_data_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetDataStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_data_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_data_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_data_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_data_stream request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single Audience.
              # Audiences created before 2020 may not be supported.
              # Default audiences will not show filter definitions.
              #
              # @overload get_audience(request, options = nil)
              #   Pass arguments to `get_audience` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetAudienceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetAudienceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_audience(name: nil)
              #   Pass arguments to `get_audience` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Audience to get.
              #     Example format: properties/1234/audiences/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Audience]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Audience]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetAudienceRequest.new
              #
              #   # Call the get_audience method.
              #   result = client.get_audience request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Audience.
              #   p result
              #
              def get_audience request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetAudienceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_audience.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_audience.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_audience.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_audience request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Audiences on a property.
              # Audiences created before 2020 may not be supported.
              # Default audiences will not show filter definitions.
              #
              # @overload list_audiences(request, options = nil)
              #   Pass arguments to `list_audiences` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListAudiencesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListAudiencesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_audiences(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_audiences` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListAudiences` call. Provide this
              #     to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListAudiences` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::Audience>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::Audience>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListAudiencesRequest.new
              #
              #   # Call the list_audiences method.
              #   result = client.list_audiences request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::Audience.
              #     p item
              #   end
              #
              def list_audiences request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListAudiencesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_audiences.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_audiences.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_audiences.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_audiences request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_audiences, "audiences", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an Audience.
              #
              # @overload create_audience(request, options = nil)
              #   Pass arguments to `create_audience` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateAudienceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateAudienceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_audience(parent: nil, audience: nil)
              #   Pass arguments to `create_audience` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param audience [::Google::Analytics::Admin::V1alpha::Audience, ::Hash]
              #     Required. The audience to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Audience]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Audience]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateAudienceRequest.new
              #
              #   # Call the create_audience method.
              #   result = client.create_audience request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Audience.
              #   p result
              #
              def create_audience request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateAudienceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_audience.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_audience.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_audience.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_audience request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an Audience on a property.
              #
              # @overload update_audience(request, options = nil)
              #   Pass arguments to `update_audience` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateAudienceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateAudienceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_audience(audience: nil, update_mask: nil)
              #   Pass arguments to `update_audience` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param audience [::Google::Analytics::Admin::V1alpha::Audience, ::Hash]
              #     Required. The audience to update.
              #     The audience's `name` field is used to identify the audience to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::Audience]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::Audience]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateAudienceRequest.new
              #
              #   # Call the update_audience method.
              #   result = client.update_audience request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::Audience.
              #   p result
              #
              def update_audience request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateAudienceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_audience.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_audience.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_audience.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_audience request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Archives an Audience on a property.
              #
              # @overload archive_audience(request, options = nil)
              #   Pass arguments to `archive_audience` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload archive_audience(name: nil)
              #   Pass arguments to `archive_audience` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Example format: properties/1234/audiences/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest.new
              #
              #   # Call the archive_audience method.
              #   result = client.archive_audience request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def archive_audience request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ArchiveAudienceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.archive_audience.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.archive_audience.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.archive_audience.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.archive_audience request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Look up a single SearchAds360Link
              #
              # @overload get_search_ads360_link(request, options = nil)
              #   Pass arguments to `get_search_ads360_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_search_ads360_link(name: nil)
              #   Pass arguments to `get_search_ads360_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the SearchAds360Link to get.
              #     Example format: properties/1234/SearchAds360Link/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest.new
              #
              #   # Call the get_search_ads360_link method.
              #   result = client.get_search_ads360_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SearchAds360Link.
              #   p result
              #
              def get_search_ads360_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetSearchAds360LinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_search_ads360_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_search_ads360_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_search_ads360_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_search_ads360_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all SearchAds360Links on a property.
              #
              # @overload list_search_ads360_links(request, options = nil)
              #   Pass arguments to `list_search_ads360_links` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_search_ads360_links(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_search_ads360_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListSearchAds360Links`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListSearchAds360Links` must match the call that provided the
              #     page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::SearchAds360Link>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::SearchAds360Link>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest.new
              #
              #   # Call the list_search_ads360_links method.
              #   result = client.list_search_ads360_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::SearchAds360Link.
              #     p item
              #   end
              #
              def list_search_ads360_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListSearchAds360LinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_search_ads360_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_search_ads360_links.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_search_ads360_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_search_ads360_links request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_search_ads360_links, "search_ads_360_links", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a SearchAds360Link.
              #
              # @overload create_search_ads360_link(request, options = nil)
              #   Pass arguments to `create_search_ads360_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_search_ads360_link(parent: nil, search_ads_360_link: nil)
              #   Pass arguments to `create_search_ads360_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param search_ads_360_link [::Google::Analytics::Admin::V1alpha::SearchAds360Link, ::Hash]
              #     Required. The SearchAds360Link to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest.new
              #
              #   # Call the create_search_ads360_link method.
              #   result = client.create_search_ads360_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SearchAds360Link.
              #   p result
              #
              def create_search_ads360_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateSearchAds360LinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_search_ads360_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_search_ads360_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_search_ads360_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_search_ads360_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a SearchAds360Link on a property.
              #
              # @overload delete_search_ads360_link(request, options = nil)
              #   Pass arguments to `delete_search_ads360_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_search_ads360_link(name: nil)
              #   Pass arguments to `delete_search_ads360_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the SearchAds360Link to delete.
              #     Example format: properties/1234/SearchAds360Links/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest.new
              #
              #   # Call the delete_search_ads360_link method.
              #   result = client.delete_search_ads360_link request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_search_ads360_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteSearchAds360LinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_search_ads360_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_search_ads360_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_search_ads360_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_search_ads360_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a SearchAds360Link on a property.
              #
              # @overload update_search_ads360_link(request, options = nil)
              #   Pass arguments to `update_search_ads360_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_search_ads360_link(search_ads_360_link: nil, update_mask: nil)
              #   Pass arguments to `update_search_ads360_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param search_ads_360_link [::Google::Analytics::Admin::V1alpha::SearchAds360Link, ::Hash]
              #     The SearchAds360Link to update
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Omitted fields will not be
              #     updated. To replace the entire entity, use one path with the string "*" to
              #     match all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SearchAds360Link]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest.new
              #
              #   # Call the update_search_ads360_link method.
              #   result = client.update_search_ads360_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SearchAds360Link.
              #   p result
              #
              def update_search_ads360_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateSearchAds360LinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_search_ads360_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_search_ads360_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_search_ads360_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_search_ads360_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a AttributionSettings singleton.
              #
              # @overload get_attribution_settings(request, options = nil)
              #   Pass arguments to `get_attribution_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_attribution_settings(name: nil)
              #   Pass arguments to `get_attribution_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the attribution settings to retrieve.
              #     Format: properties/\\{property}/attributionSettings
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::AttributionSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::AttributionSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest.new
              #
              #   # Call the get_attribution_settings method.
              #   result = client.get_attribution_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::AttributionSettings.
              #   p result
              #
              def get_attribution_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetAttributionSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_attribution_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_attribution_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_attribution_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_attribution_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates attribution settings on a property.
              #
              # @overload update_attribution_settings(request, options = nil)
              #   Pass arguments to `update_attribution_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_attribution_settings(attribution_settings: nil, update_mask: nil)
              #   Pass arguments to `update_attribution_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param attribution_settings [::Google::Analytics::Admin::V1alpha::AttributionSettings, ::Hash]
              #     Required. The attribution settings to update.
              #     The `name` field is used to identify the settings to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::AttributionSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::AttributionSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest.new
              #
              #   # Call the update_attribution_settings method.
              #   result = client.update_attribution_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::AttributionSettings.
              #   p result
              #
              def update_attribution_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateAttributionSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_attribution_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_attribution_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_attribution_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_attribution_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a customized report of data access records. The report provides
              # records of each time a user reads Google Analytics reporting data. Access
              # records are retained for up to 2 years.
              #
              # Data Access Reports can be requested for a property. Reports may be
              # requested for any property, but dimensions that aren't related to quota can
              # only be requested on Google Analytics 360 properties. This method is only
              # available to Administrators.
              #
              # These data access records include GA UI Reporting, GA UI Explorations,
              # GA Data API, and other products like Firebase & Admob that can retrieve
              # data from Google Analytics through a linkage. These records don't include
              # property configuration changes like adding a stream or changing a
              # property's time zone. For configuration change history, see
              # [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
              #
              # To give your feedback on this API, complete the [Google Analytics Access
              # Reports
              # feedback](https://docs.google.com/forms/d/e/1FAIpQLSdmEBUrMzAEdiEKk5TV5dEHvDUZDRlgWYdQdAeSdtR4hVjEhw/viewform)
              # form.
              #
              # @overload run_access_report(request, options = nil)
              #   Pass arguments to `run_access_report` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::RunAccessReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::RunAccessReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_access_report(entity: nil, dimensions: nil, metrics: nil, date_ranges: nil, dimension_filter: nil, metric_filter: nil, offset: nil, limit: nil, time_zone: nil, order_bys: nil, return_entity_quota: nil, include_all_users: nil, expand_groups: nil)
              #   Pass arguments to `run_access_report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param entity [::String]
              #     The Data Access Report supports requesting at the property level or account
              #     level. If requested at the account level, Data Access Reports include all
              #     access for all properties under that account.
              #
              #     To request at the property level, entity should be for example
              #     'properties/123' if "123" is your Google Analytics property ID. To request
              #     at the account level, entity should be for example 'accounts/1234' if
              #     "1234" is your Google Analytics Account ID.
              #   @param dimensions [::Array<::Google::Analytics::Admin::V1alpha::AccessDimension, ::Hash>]
              #     The dimensions requested and displayed in the response. Requests are
              #     allowed up to 9 dimensions.
              #   @param metrics [::Array<::Google::Analytics::Admin::V1alpha::AccessMetric, ::Hash>]
              #     The metrics requested and displayed in the response. Requests are allowed
              #     up to 10 metrics.
              #   @param date_ranges [::Array<::Google::Analytics::Admin::V1alpha::AccessDateRange, ::Hash>]
              #     Date ranges of access records to read. If multiple date ranges are
              #     requested, each response row will contain a zero based date range index. If
              #     two date ranges overlap, the access records for the overlapping days is
              #     included in the response rows for both date ranges. Requests are allowed up
              #     to 2 date ranges.
              #   @param dimension_filter [::Google::Analytics::Admin::V1alpha::AccessFilterExpression, ::Hash]
              #     Dimension filters let you restrict report response to specific
              #     dimension values which match the filter. For example, filtering on access
              #     records of a single user. To learn more, see [Fundamentals of Dimension
              #     Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
              #     for examples. Metrics cannot be used in this filter.
              #   @param metric_filter [::Google::Analytics::Admin::V1alpha::AccessFilterExpression, ::Hash]
              #     Metric filters allow you to restrict report response to specific metric
              #     values which match the filter. Metric filters are applied after aggregating
              #     the report's rows, similar to SQL having-clause. Dimensions cannot be used
              #     in this filter.
              #   @param offset [::Integer]
              #     The row count of the start row. The first row is counted as row 0. If
              #     offset is unspecified, it is treated as 0. If offset is zero, then this
              #     method will return the first page of results with `limit` entries.
              #
              #     To learn more about this pagination parameter, see
              #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
              #   @param limit [::Integer]
              #     The number of rows to return. If unspecified, 10,000 rows are returned. The
              #     API returns a maximum of 100,000 rows per request, no matter how many you
              #     ask for. `limit` must be positive.
              #
              #     The API may return fewer rows than the requested `limit`, if there aren't
              #     as many remaining rows as the `limit`. For instance, there are fewer than
              #     300 possible values for the dimension `country`, so when reporting on only
              #     `country`, you can't get more than 300 rows, even if you set `limit` to a
              #     higher value.
              #
              #     To learn more about this pagination parameter, see
              #     [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
              #   @param time_zone [::String]
              #     This request's time zone if specified. If unspecified, the property's time
              #     zone is used. The request's time zone is used to interpret the start & end
              #     dates of the report.
              #
              #     Formatted as strings from the IANA Time Zone database
              #     (https://www.iana.org/time-zones); for example "America/New_York" or
              #     "Asia/Tokyo".
              #   @param order_bys [::Array<::Google::Analytics::Admin::V1alpha::AccessOrderBy, ::Hash>]
              #     Specifies how rows are ordered in the response.
              #   @param return_entity_quota [::Boolean]
              #     Toggles whether to return the current state of this Analytics Property's
              #     quota. Quota is returned in [AccessQuota](#AccessQuota). For account-level
              #     requests, this field must be false.
              #   @param include_all_users [::Boolean]
              #     Optional. Determines whether to include users who have never made an API
              #     call in the response. If true, all users with access to the specified
              #     property or account are included in the response, regardless of whether
              #     they have made an API call or not. If false, only the users who have made
              #     an API call will be included.
              #   @param expand_groups [::Boolean]
              #     Optional. Decides whether to return the users within user groups. This
              #     field works only when include_all_users is set to true. If true, it will
              #     return all users with access to the specified property or account.
              #     If false, only the users with direct access will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::RunAccessReportResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::RunAccessReportResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::RunAccessReportRequest.new
              #
              #   # Call the run_access_report method.
              #   result = client.run_access_report request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::RunAccessReportResponse.
              #   p result
              #
              def run_access_report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::RunAccessReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_access_report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_access_report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_access_report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.run_access_report request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an access binding on an account or property.
              #
              # @overload create_access_binding(request, options = nil)
              #   Pass arguments to `create_access_binding` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_access_binding(parent: nil, access_binding: nil)
              #   Pass arguments to `create_access_binding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Formats:
              #     - accounts/\\{account}
              #     - properties/\\{property}
              #   @param access_binding [::Google::Analytics::Admin::V1alpha::AccessBinding, ::Hash]
              #     Required. The access binding to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::AccessBinding]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::AccessBinding]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest.new
              #
              #   # Call the create_access_binding method.
              #   result = client.create_access_binding request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::AccessBinding.
              #   p result
              #
              def create_access_binding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_access_binding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_access_binding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_access_binding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_access_binding request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about an access binding.
              #
              # @overload get_access_binding(request, options = nil)
              #   Pass arguments to `get_access_binding` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetAccessBindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetAccessBindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_access_binding(name: nil)
              #   Pass arguments to `get_access_binding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the access binding to retrieve.
              #     Formats:
              #     - accounts/\\{account}/accessBindings/\\{accessBinding}
              #     - properties/\\{property}/accessBindings/\\{accessBinding}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::AccessBinding]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::AccessBinding]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetAccessBindingRequest.new
              #
              #   # Call the get_access_binding method.
              #   result = client.get_access_binding request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::AccessBinding.
              #   p result
              #
              def get_access_binding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetAccessBindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_access_binding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_access_binding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_access_binding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_access_binding request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an access binding on an account or property.
              #
              # @overload update_access_binding(request, options = nil)
              #   Pass arguments to `update_access_binding` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_access_binding(access_binding: nil)
              #   Pass arguments to `update_access_binding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param access_binding [::Google::Analytics::Admin::V1alpha::AccessBinding, ::Hash]
              #     Required. The access binding to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::AccessBinding]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::AccessBinding]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest.new
              #
              #   # Call the update_access_binding method.
              #   result = client.update_access_binding request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::AccessBinding.
              #   p result
              #
              def update_access_binding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_access_binding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_access_binding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_access_binding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_access_binding request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an access binding on an account or property.
              #
              # @overload delete_access_binding(request, options = nil)
              #   Pass arguments to `delete_access_binding` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_access_binding(name: nil)
              #   Pass arguments to `delete_access_binding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Formats:
              #     - accounts/\\{account}/accessBindings/\\{accessBinding}
              #     - properties/\\{property}/accessBindings/\\{accessBinding}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest.new
              #
              #   # Call the delete_access_binding method.
              #   result = client.delete_access_binding request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_access_binding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_access_binding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_access_binding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_access_binding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_access_binding request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all access bindings on an account or property.
              #
              # @overload list_access_bindings(request, options = nil)
              #   Pass arguments to `list_access_bindings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_access_bindings(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_access_bindings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Formats:
              #     - accounts/\\{account}
              #     - properties/\\{property}
              #   @param page_size [::Integer]
              #     The maximum number of access bindings to return.
              #     The service may return fewer than this value.
              #     If unspecified, at most 200 access bindings will be returned.
              #     The maximum value is 500; values above 500 will be coerced to 500.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListAccessBindings` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListAccessBindings` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::AccessBinding>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::AccessBinding>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest.new
              #
              #   # Call the list_access_bindings method.
              #   result = client.list_access_bindings request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::AccessBinding.
              #     p item
              #   end
              #
              def list_access_bindings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListAccessBindingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_access_bindings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_access_bindings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_access_bindings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_access_bindings request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_access_bindings, "access_bindings", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates information about multiple access bindings to an account or
              # property.
              #
              # This method is transactional. If any AccessBinding cannot be created, none
              # of the AccessBindings will be created.
              #
              # @overload batch_create_access_bindings(request, options = nil)
              #   Pass arguments to `batch_create_access_bindings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_create_access_bindings(parent: nil, requests: nil)
              #   Pass arguments to `batch_create_access_bindings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The account or property that owns the access bindings. The parent
              #     field in the CreateAccessBindingRequest messages must either be empty or
              #     match this field. Formats:
              #     - accounts/\\{account}
              #     - properties/\\{property}
              #   @param requests [::Array<::Google::Analytics::Admin::V1alpha::CreateAccessBindingRequest, ::Hash>]
              #     Required. The requests specifying the access bindings to create.
              #     A maximum of 1000 access bindings can be created in a batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest.new
              #
              #   # Call the batch_create_access_bindings method.
              #   result = client.batch_create_access_bindings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsResponse.
              #   p result
              #
              def batch_create_access_bindings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::BatchCreateAccessBindingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_create_access_bindings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_create_access_bindings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_create_access_bindings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.batch_create_access_bindings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about multiple access bindings to an account or property.
              #
              # @overload batch_get_access_bindings(request, options = nil)
              #   Pass arguments to `batch_get_access_bindings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_get_access_bindings(parent: nil, names: nil)
              #   Pass arguments to `batch_get_access_bindings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The account or property that owns the access bindings. The parent
              #     of all provided values for the 'names' field must match this field.
              #     Formats:
              #     - accounts/\\{account}
              #     - properties/\\{property}
              #   @param names [::Array<::String>]
              #     Required. The names of the access bindings to retrieve.
              #     A maximum of 1000 access bindings can be retrieved in a batch.
              #     Formats:
              #     - accounts/\\{account}/accessBindings/\\{accessBinding}
              #     - properties/\\{property}/accessBindings/\\{accessBinding}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest.new
              #
              #   # Call the batch_get_access_bindings method.
              #   result = client.batch_get_access_bindings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsResponse.
              #   p result
              #
              def batch_get_access_bindings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::BatchGetAccessBindingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_get_access_bindings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_get_access_bindings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_get_access_bindings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.batch_get_access_bindings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates information about multiple access bindings to an account or
              # property.
              #
              # @overload batch_update_access_bindings(request, options = nil)
              #   Pass arguments to `batch_update_access_bindings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_update_access_bindings(parent: nil, requests: nil)
              #   Pass arguments to `batch_update_access_bindings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The account or property that owns the access bindings. The parent
              #     of all provided AccessBinding in UpdateAccessBindingRequest messages must
              #     match this field.
              #     Formats:
              #     - accounts/\\{account}
              #     - properties/\\{property}
              #   @param requests [::Array<::Google::Analytics::Admin::V1alpha::UpdateAccessBindingRequest, ::Hash>]
              #     Required. The requests specifying the access bindings to update.
              #     A maximum of 1000 access bindings can be updated in a batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest.new
              #
              #   # Call the batch_update_access_bindings method.
              #   result = client.batch_update_access_bindings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsResponse.
              #   p result
              #
              def batch_update_access_bindings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::BatchUpdateAccessBindingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_update_access_bindings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_update_access_bindings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_update_access_bindings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.batch_update_access_bindings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes information about multiple users' links to an account or property.
              #
              # @overload batch_delete_access_bindings(request, options = nil)
              #   Pass arguments to `batch_delete_access_bindings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_delete_access_bindings(parent: nil, requests: nil)
              #   Pass arguments to `batch_delete_access_bindings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The account or property that owns the access bindings. The parent
              #     of all provided values for the 'names' field in DeleteAccessBindingRequest
              #     messages must match this field. Formats:
              #     - accounts/\\{account}
              #     - properties/\\{property}
              #   @param requests [::Array<::Google::Analytics::Admin::V1alpha::DeleteAccessBindingRequest, ::Hash>]
              #     Required. The requests specifying the access bindings to delete.
              #     A maximum of 1000 access bindings can be deleted in a batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest.new
              #
              #   # Call the batch_delete_access_bindings method.
              #   result = client.batch_delete_access_bindings request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def batch_delete_access_bindings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::BatchDeleteAccessBindingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_delete_access_bindings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_delete_access_bindings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_delete_access_bindings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.batch_delete_access_bindings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single ExpandedDataSet.
              #
              # @overload get_expanded_data_set(request, options = nil)
              #   Pass arguments to `get_expanded_data_set` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_expanded_data_set(name: nil)
              #   Pass arguments to `get_expanded_data_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the ExpandedDataSet to get.
              #     Example format: properties/1234/expandedDataSets/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest.new
              #
              #   # Call the get_expanded_data_set method.
              #   result = client.get_expanded_data_set request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ExpandedDataSet.
              #   p result
              #
              def get_expanded_data_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetExpandedDataSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_expanded_data_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_expanded_data_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_expanded_data_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_expanded_data_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ExpandedDataSets on a property.
              #
              # @overload list_expanded_data_sets(request, options = nil)
              #   Pass arguments to `list_expanded_data_sets` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_expanded_data_sets(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_expanded_data_sets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListExpandedDataSets` call. Provide
              #     this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListExpandedDataSet`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ExpandedDataSet>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ExpandedDataSet>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest.new
              #
              #   # Call the list_expanded_data_sets method.
              #   result = client.list_expanded_data_sets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::ExpandedDataSet.
              #     p item
              #   end
              #
              def list_expanded_data_sets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListExpandedDataSetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_expanded_data_sets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_expanded_data_sets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_expanded_data_sets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_expanded_data_sets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_expanded_data_sets, "expanded_data_sets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a ExpandedDataSet.
              #
              # @overload create_expanded_data_set(request, options = nil)
              #   Pass arguments to `create_expanded_data_set` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_expanded_data_set(parent: nil, expanded_data_set: nil)
              #   Pass arguments to `create_expanded_data_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param expanded_data_set [::Google::Analytics::Admin::V1alpha::ExpandedDataSet, ::Hash]
              #     Required. The ExpandedDataSet to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest.new
              #
              #   # Call the create_expanded_data_set method.
              #   result = client.create_expanded_data_set request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ExpandedDataSet.
              #   p result
              #
              def create_expanded_data_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateExpandedDataSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_expanded_data_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_expanded_data_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_expanded_data_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_expanded_data_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a ExpandedDataSet on a property.
              #
              # @overload update_expanded_data_set(request, options = nil)
              #   Pass arguments to `update_expanded_data_set` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_expanded_data_set(expanded_data_set: nil, update_mask: nil)
              #   Pass arguments to `update_expanded_data_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param expanded_data_set [::Google::Analytics::Admin::V1alpha::ExpandedDataSet, ::Hash]
              #     Required. The ExpandedDataSet to update.
              #     The resource's `name` field is used to identify the ExpandedDataSet to be
              #     updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ExpandedDataSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest.new
              #
              #   # Call the update_expanded_data_set method.
              #   result = client.update_expanded_data_set request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ExpandedDataSet.
              #   p result
              #
              def update_expanded_data_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateExpandedDataSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_expanded_data_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_expanded_data_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_expanded_data_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_expanded_data_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a ExpandedDataSet on a property.
              #
              # @overload delete_expanded_data_set(request, options = nil)
              #   Pass arguments to `delete_expanded_data_set` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_expanded_data_set(name: nil)
              #   Pass arguments to `delete_expanded_data_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Example format: properties/1234/expandedDataSets/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest.new
              #
              #   # Call the delete_expanded_data_set method.
              #   result = client.delete_expanded_data_set request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_expanded_data_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteExpandedDataSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_expanded_data_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_expanded_data_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_expanded_data_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_expanded_data_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single ChannelGroup.
              #
              # @overload get_channel_group(request, options = nil)
              #   Pass arguments to `get_channel_group` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetChannelGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetChannelGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_channel_group(name: nil)
              #   Pass arguments to `get_channel_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The ChannelGroup to get.
              #     Example format: properties/1234/channelGroups/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ChannelGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ChannelGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetChannelGroupRequest.new
              #
              #   # Call the get_channel_group method.
              #   result = client.get_channel_group request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ChannelGroup.
              #   p result
              #
              def get_channel_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetChannelGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_channel_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_channel_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_channel_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_channel_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ChannelGroups on a property.
              #
              # @overload list_channel_groups(request, options = nil)
              #   Pass arguments to `list_channel_groups` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_channel_groups(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_channel_groups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The property for which to list ChannelGroups.
              #     Example format: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListChannelGroups` call. Provide
              #     this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListChannelGroups`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ChannelGroup>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ChannelGroup>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest.new
              #
              #   # Call the list_channel_groups method.
              #   result = client.list_channel_groups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::ChannelGroup.
              #     p item
              #   end
              #
              def list_channel_groups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListChannelGroupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_channel_groups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_channel_groups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_channel_groups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_channel_groups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_channel_groups, "channel_groups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a ChannelGroup.
              #
              # @overload create_channel_group(request, options = nil)
              #   Pass arguments to `create_channel_group` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_channel_group(parent: nil, channel_group: nil)
              #   Pass arguments to `create_channel_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The property for which to create a ChannelGroup.
              #     Example format: properties/1234
              #   @param channel_group [::Google::Analytics::Admin::V1alpha::ChannelGroup, ::Hash]
              #     Required. The ChannelGroup to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ChannelGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ChannelGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest.new
              #
              #   # Call the create_channel_group method.
              #   result = client.create_channel_group request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ChannelGroup.
              #   p result
              #
              def create_channel_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateChannelGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_channel_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_channel_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_channel_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_channel_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a ChannelGroup.
              #
              # @overload update_channel_group(request, options = nil)
              #   Pass arguments to `update_channel_group` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_channel_group(channel_group: nil, update_mask: nil)
              #   Pass arguments to `update_channel_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param channel_group [::Google::Analytics::Admin::V1alpha::ChannelGroup, ::Hash]
              #     Required. The ChannelGroup to update.
              #     The resource's `name` field is used to identify the ChannelGroup to be
              #     updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ChannelGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ChannelGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest.new
              #
              #   # Call the update_channel_group method.
              #   result = client.update_channel_group request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ChannelGroup.
              #   p result
              #
              def update_channel_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateChannelGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_channel_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_channel_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_channel_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_channel_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a ChannelGroup on a property.
              #
              # @overload delete_channel_group(request, options = nil)
              #   Pass arguments to `delete_channel_group` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_channel_group(name: nil)
              #   Pass arguments to `delete_channel_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The ChannelGroup to delete.
              #     Example format: properties/1234/channelGroups/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest.new
              #
              #   # Call the delete_channel_group method.
              #   result = client.delete_channel_group request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_channel_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteChannelGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_channel_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_channel_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_channel_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_channel_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a BigQueryLink.
              #
              # @overload create_big_query_link(request, options = nil)
              #   Pass arguments to `create_big_query_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_big_query_link(parent: nil, bigquery_link: nil)
              #   Pass arguments to `create_big_query_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param bigquery_link [::Google::Analytics::Admin::V1alpha::BigQueryLink, ::Hash]
              #     Required. The BigQueryLink to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::BigQueryLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::BigQueryLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest.new
              #
              #   # Call the create_big_query_link method.
              #   result = client.create_big_query_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::BigQueryLink.
              #   p result
              #
              def create_big_query_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateBigQueryLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_big_query_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_big_query_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_big_query_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_big_query_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single BigQuery Link.
              #
              # @overload get_big_query_link(request, options = nil)
              #   Pass arguments to `get_big_query_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_big_query_link(name: nil)
              #   Pass arguments to `get_big_query_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the BigQuery link to lookup.
              #     Format: properties/\\{property_id}/bigQueryLinks/\\{bigquery_link_id}
              #     Example: properties/123/bigQueryLinks/456
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::BigQueryLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::BigQueryLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest.new
              #
              #   # Call the get_big_query_link method.
              #   result = client.get_big_query_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::BigQueryLink.
              #   p result
              #
              def get_big_query_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetBigQueryLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_big_query_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_big_query_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_big_query_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_big_query_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists BigQuery Links on a property.
              #
              # @overload list_big_query_links(request, options = nil)
              #   Pass arguments to `list_big_query_links` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_big_query_links(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_big_query_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the property to list BigQuery links under.
              #     Format: properties/\\{property_id}
              #     Example: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     A page token, received from a previous `ListBigQueryLinks` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListBigQueryLinks` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::BigQueryLink>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::BigQueryLink>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest.new
              #
              #   # Call the list_big_query_links method.
              #   result = client.list_big_query_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::BigQueryLink.
              #     p item
              #   end
              #
              def list_big_query_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListBigQueryLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_big_query_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_big_query_links.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_big_query_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_big_query_links request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_big_query_links, "bigquery_links", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a BigQueryLink on a property.
              #
              # @overload delete_big_query_link(request, options = nil)
              #   Pass arguments to `delete_big_query_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_big_query_link(name: nil)
              #   Pass arguments to `delete_big_query_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The BigQueryLink to delete.
              #     Example format: properties/1234/bigQueryLinks/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest.new
              #
              #   # Call the delete_big_query_link method.
              #   result = client.delete_big_query_link request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_big_query_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteBigQueryLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_big_query_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_big_query_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_big_query_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_big_query_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a BigQueryLink.
              #
              # @overload update_big_query_link(request, options = nil)
              #   Pass arguments to `update_big_query_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_big_query_link(bigquery_link: nil, update_mask: nil)
              #   Pass arguments to `update_big_query_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param bigquery_link [::Google::Analytics::Admin::V1alpha::BigQueryLink, ::Hash]
              #     Required. The settings to update.
              #     The `name` field is used to identify the settings to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::BigQueryLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::BigQueryLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest.new
              #
              #   # Call the update_big_query_link method.
              #   result = client.update_big_query_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::BigQueryLink.
              #   p result
              #
              def update_big_query_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateBigQueryLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_big_query_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_big_query_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_big_query_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_big_query_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the enhanced measurement settings for this data stream.
              # Note that the stream must enable enhanced measurement for these settings to
              # take effect.
              #
              # @overload get_enhanced_measurement_settings(request, options = nil)
              #   Pass arguments to `get_enhanced_measurement_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_enhanced_measurement_settings(name: nil)
              #   Pass arguments to `get_enhanced_measurement_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the settings to lookup.
              #     Format:
              #     properties/\\{property}/dataStreams/\\{data_stream}/enhancedMeasurementSettings
              #     Example: "properties/1000/dataStreams/2000/enhancedMeasurementSettings"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest.new
              #
              #   # Call the get_enhanced_measurement_settings method.
              #   result = client.get_enhanced_measurement_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings.
              #   p result
              #
              def get_enhanced_measurement_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetEnhancedMeasurementSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_enhanced_measurement_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_enhanced_measurement_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_enhanced_measurement_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_enhanced_measurement_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the enhanced measurement settings for this data stream.
              # Note that the stream must enable enhanced measurement for these settings to
              # take effect.
              #
              # @overload update_enhanced_measurement_settings(request, options = nil)
              #   Pass arguments to `update_enhanced_measurement_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_enhanced_measurement_settings(enhanced_measurement_settings: nil, update_mask: nil)
              #   Pass arguments to `update_enhanced_measurement_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param enhanced_measurement_settings [::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings, ::Hash]
              #     Required. The settings to update.
              #     The `name` field is used to identify the settings to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest.new
              #
              #   # Call the update_enhanced_measurement_settings method.
              #   result = client.update_enhanced_measurement_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::EnhancedMeasurementSettings.
              #   p result
              #
              def update_enhanced_measurement_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateEnhancedMeasurementSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_enhanced_measurement_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_enhanced_measurement_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_enhanced_measurement_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_enhanced_measurement_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Looks up a single AdSenseLink.
              #
              # @overload get_ad_sense_link(request, options = nil)
              #   Pass arguments to `get_ad_sense_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_ad_sense_link(name: nil)
              #   Pass arguments to `get_ad_sense_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Unique identifier for the AdSense Link requested.
              #     Format: properties/\\{propertyId}/adSenseLinks/\\{linkId}
              #     Example: properties/1234/adSenseLinks/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::AdSenseLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::AdSenseLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest.new
              #
              #   # Call the get_ad_sense_link method.
              #   result = client.get_ad_sense_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::AdSenseLink.
              #   p result
              #
              def get_ad_sense_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetAdSenseLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_ad_sense_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_ad_sense_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_ad_sense_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_ad_sense_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an AdSenseLink.
              #
              # @overload create_ad_sense_link(request, options = nil)
              #   Pass arguments to `create_ad_sense_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_ad_sense_link(parent: nil, adsense_link: nil)
              #   Pass arguments to `create_ad_sense_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The property for which to create an AdSense Link.
              #     Format: properties/\\{propertyId}
              #     Example: properties/1234
              #   @param adsense_link [::Google::Analytics::Admin::V1alpha::AdSenseLink, ::Hash]
              #     Required. The AdSense Link to create
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::AdSenseLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::AdSenseLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest.new
              #
              #   # Call the create_ad_sense_link method.
              #   result = client.create_ad_sense_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::AdSenseLink.
              #   p result
              #
              def create_ad_sense_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateAdSenseLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_ad_sense_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_ad_sense_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_ad_sense_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_ad_sense_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an AdSenseLink.
              #
              # @overload delete_ad_sense_link(request, options = nil)
              #   Pass arguments to `delete_ad_sense_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_ad_sense_link(name: nil)
              #   Pass arguments to `delete_ad_sense_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Unique identifier for the AdSense Link to be deleted.
              #     Format: properties/\\{propertyId}/adSenseLinks/\\{linkId}
              #     Example: properties/1234/adSenseLinks/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest.new
              #
              #   # Call the delete_ad_sense_link method.
              #   result = client.delete_ad_sense_link request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_ad_sense_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteAdSenseLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_ad_sense_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_ad_sense_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_ad_sense_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_ad_sense_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists AdSenseLinks on a property.
              #
              # @overload list_ad_sense_links(request, options = nil)
              #   Pass arguments to `list_ad_sense_links` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_ad_sense_links(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_ad_sense_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the parent property.
              #     Format: properties/\\{propertyId}
              #     Example: properties/1234
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token received from a previous `ListAdSenseLinks` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListAdSenseLinks` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::AdSenseLink>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::AdSenseLink>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest.new
              #
              #   # Call the list_ad_sense_links method.
              #   result = client.list_ad_sense_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::AdSenseLink.
              #     p item
              #   end
              #
              def list_ad_sense_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListAdSenseLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_ad_sense_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_ad_sense_links.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_ad_sense_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_ad_sense_links request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_ad_sense_links, "adsense_links", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single EventCreateRule.
              #
              # @overload get_event_create_rule(request, options = nil)
              #   Pass arguments to `get_event_create_rule` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_event_create_rule(name: nil)
              #   Pass arguments to `get_event_create_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the EventCreateRule to get.
              #     Example format: properties/123/dataStreams/456/eventCreateRules/789
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::EventCreateRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::EventCreateRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest.new
              #
              #   # Call the get_event_create_rule method.
              #   result = client.get_event_create_rule request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::EventCreateRule.
              #   p result
              #
              def get_event_create_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetEventCreateRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_event_create_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_event_create_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_event_create_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_event_create_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists EventCreateRules on a web data stream.
              #
              # @overload list_event_create_rules(request, options = nil)
              #   Pass arguments to `list_event_create_rules` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_event_create_rules(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_event_create_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/123/dataStreams/456
              #   @param page_size [::Integer]
              #     The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     A page token, received from a previous `ListEventCreateRules` call. Provide
              #     this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListEventCreateRules`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::EventCreateRule>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::EventCreateRule>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest.new
              #
              #   # Call the list_event_create_rules method.
              #   result = client.list_event_create_rules request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::EventCreateRule.
              #     p item
              #   end
              #
              def list_event_create_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListEventCreateRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_event_create_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_event_create_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_event_create_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_event_create_rules request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_event_create_rules, "event_create_rules", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an EventCreateRule.
              #
              # @overload create_event_create_rule(request, options = nil)
              #   Pass arguments to `create_event_create_rule` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_event_create_rule(parent: nil, event_create_rule: nil)
              #   Pass arguments to `create_event_create_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/123/dataStreams/456
              #   @param event_create_rule [::Google::Analytics::Admin::V1alpha::EventCreateRule, ::Hash]
              #     Required. The EventCreateRule to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::EventCreateRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::EventCreateRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest.new
              #
              #   # Call the create_event_create_rule method.
              #   result = client.create_event_create_rule request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::EventCreateRule.
              #   p result
              #
              def create_event_create_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateEventCreateRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_event_create_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_event_create_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_event_create_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_event_create_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an EventCreateRule.
              #
              # @overload update_event_create_rule(request, options = nil)
              #   Pass arguments to `update_event_create_rule` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_event_create_rule(event_create_rule: nil, update_mask: nil)
              #   Pass arguments to `update_event_create_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param event_create_rule [::Google::Analytics::Admin::V1alpha::EventCreateRule, ::Hash]
              #     Required. The EventCreateRule to update.
              #     The resource's `name` field is used to identify the EventCreateRule to be
              #     updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::EventCreateRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::EventCreateRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest.new
              #
              #   # Call the update_event_create_rule method.
              #   result = client.update_event_create_rule request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::EventCreateRule.
              #   p result
              #
              def update_event_create_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateEventCreateRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_event_create_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_event_create_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_event_create_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_event_create_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an EventCreateRule.
              #
              # @overload delete_event_create_rule(request, options = nil)
              #   Pass arguments to `delete_event_create_rule` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_event_create_rule(name: nil)
              #   Pass arguments to `delete_event_create_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Example format:
              #     properties/123/dataStreams/456/eventCreateRules/789
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest.new
              #
              #   # Call the delete_event_create_rule method.
              #   result = client.delete_event_create_rule request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_event_create_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteEventCreateRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_event_create_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_event_create_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_event_create_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_event_create_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single EventEditRule.
              #
              # @overload get_event_edit_rule(request, options = nil)
              #   Pass arguments to `get_event_edit_rule` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_event_edit_rule(name: nil)
              #   Pass arguments to `get_event_edit_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the EventEditRule to get.
              #     Example format: properties/123/dataStreams/456/eventEditRules/789
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::EventEditRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::EventEditRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest.new
              #
              #   # Call the get_event_edit_rule method.
              #   result = client.get_event_edit_rule request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::EventEditRule.
              #   p result
              #
              def get_event_edit_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetEventEditRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_event_edit_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_event_edit_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_event_edit_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_event_edit_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists EventEditRules on a web data stream.
              #
              # @overload list_event_edit_rules(request, options = nil)
              #   Pass arguments to `list_event_edit_rules` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_event_edit_rules(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_event_edit_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/123/dataStreams/456
              #   @param page_size [::Integer]
              #     Optional. The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListEventEditRules` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListEventEditRules`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::EventEditRule>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::EventEditRule>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest.new
              #
              #   # Call the list_event_edit_rules method.
              #   result = client.list_event_edit_rules request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::EventEditRule.
              #     p item
              #   end
              #
              def list_event_edit_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListEventEditRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_event_edit_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_event_edit_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_event_edit_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_event_edit_rules request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_event_edit_rules, "event_edit_rules", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an EventEditRule.
              #
              # @overload create_event_edit_rule(request, options = nil)
              #   Pass arguments to `create_event_edit_rule` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_event_edit_rule(parent: nil, event_edit_rule: nil)
              #   Pass arguments to `create_event_edit_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/123/dataStreams/456
              #   @param event_edit_rule [::Google::Analytics::Admin::V1alpha::EventEditRule, ::Hash]
              #     Required. The EventEditRule to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::EventEditRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::EventEditRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest.new
              #
              #   # Call the create_event_edit_rule method.
              #   result = client.create_event_edit_rule request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::EventEditRule.
              #   p result
              #
              def create_event_edit_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateEventEditRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_event_edit_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_event_edit_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_event_edit_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_event_edit_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an EventEditRule.
              #
              # @overload update_event_edit_rule(request, options = nil)
              #   Pass arguments to `update_event_edit_rule` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_event_edit_rule(event_edit_rule: nil, update_mask: nil)
              #   Pass arguments to `update_event_edit_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param event_edit_rule [::Google::Analytics::Admin::V1alpha::EventEditRule, ::Hash]
              #     Required. The EventEditRule to update.
              #     The resource's `name` field is used to identify the EventEditRule to be
              #     updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::EventEditRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::EventEditRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest.new
              #
              #   # Call the update_event_edit_rule method.
              #   result = client.update_event_edit_rule request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::EventEditRule.
              #   p result
              #
              def update_event_edit_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateEventEditRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_event_edit_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_event_edit_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_event_edit_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_event_edit_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an EventEditRule.
              #
              # @overload delete_event_edit_rule(request, options = nil)
              #   Pass arguments to `delete_event_edit_rule` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_event_edit_rule(name: nil)
              #   Pass arguments to `delete_event_edit_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Example format: properties/123/dataStreams/456/eventEditRules/789
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest.new
              #
              #   # Call the delete_event_edit_rule method.
              #   result = client.delete_event_edit_rule request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_event_edit_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteEventEditRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_event_edit_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_event_edit_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_event_edit_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_event_edit_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Changes the processing order of event edit rules on the specified stream.
              #
              # @overload reorder_event_edit_rules(request, options = nil)
              #   Pass arguments to `reorder_event_edit_rules` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reorder_event_edit_rules(parent: nil, event_edit_rules: nil)
              #   Pass arguments to `reorder_event_edit_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/123/dataStreams/456
              #   @param event_edit_rules [::Array<::String>]
              #     Required. EventEditRule resource names for the specified data stream, in
              #     the needed processing order. All EventEditRules for the stream must be
              #     present in the list.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest.new
              #
              #   # Call the reorder_event_edit_rules method.
              #   result = client.reorder_event_edit_rules request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def reorder_event_edit_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ReorderEventEditRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reorder_event_edit_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reorder_event_edit_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reorder_event_edit_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.reorder_event_edit_rules request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a DataRedactionSettings on a property.
              #
              # @overload update_data_redaction_settings(request, options = nil)
              #   Pass arguments to `update_data_redaction_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_data_redaction_settings(data_redaction_settings: nil, update_mask: nil)
              #   Pass arguments to `update_data_redaction_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param data_redaction_settings [::Google::Analytics::Admin::V1alpha::DataRedactionSettings, ::Hash]
              #     Required. The settings to update.
              #     The `name` field is used to identify the settings to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Field names must be in snake
              #     case (e.g., "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DataRedactionSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DataRedactionSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest.new
              #
              #   # Call the update_data_redaction_settings method.
              #   result = client.update_data_redaction_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DataRedactionSettings.
              #   p result
              #
              def update_data_redaction_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateDataRedactionSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_data_redaction_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_data_redaction_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_data_redaction_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_data_redaction_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single DataRedactionSettings.
              #
              # @overload get_data_redaction_settings(request, options = nil)
              #   Pass arguments to `get_data_redaction_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_data_redaction_settings(name: nil)
              #   Pass arguments to `get_data_redaction_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the settings to lookup.
              #     Format:
              #     properties/\\{property}/dataStreams/\\{data_stream}/dataRedactionSettings
              #     Example: "properties/1000/dataStreams/2000/dataRedactionSettings"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::DataRedactionSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::DataRedactionSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest.new
              #
              #   # Call the get_data_redaction_settings method.
              #   result = client.get_data_redaction_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::DataRedactionSettings.
              #   p result
              #
              def get_data_redaction_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetDataRedactionSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_data_redaction_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_data_redaction_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_data_redaction_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_data_redaction_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single CalculatedMetric.
              #
              # @overload get_calculated_metric(request, options = nil)
              #   Pass arguments to `get_calculated_metric` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_calculated_metric(name: nil)
              #   Pass arguments to `get_calculated_metric` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CalculatedMetric to get.
              #     Format: properties/\\{property_id}/calculatedMetrics/\\{calculated_metric_id}
              #     Example: properties/1234/calculatedMetrics/Metric01
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest.new
              #
              #   # Call the get_calculated_metric method.
              #   result = client.get_calculated_metric request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CalculatedMetric.
              #   p result
              #
              def get_calculated_metric request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetCalculatedMetricRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_calculated_metric.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_calculated_metric.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_calculated_metric.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_calculated_metric request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a CalculatedMetric.
              #
              # @overload create_calculated_metric(request, options = nil)
              #   Pass arguments to `create_calculated_metric` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_calculated_metric(parent: nil, calculated_metric_id: nil, calculated_metric: nil)
              #   Pass arguments to `create_calculated_metric` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format: properties/\\{property_id}
              #     Example: properties/1234
              #   @param calculated_metric_id [::String]
              #     Required. The ID to use for the calculated metric which will become the
              #     final component of the calculated metric's resource name.
              #
              #     This value should be 1-80 characters and valid characters are
              #     /[a-zA-Z0-9_]/, no spaces allowed. calculated_metric_id must be unique
              #     between all calculated metrics under a property. The calculated_metric_id
              #     is used when referencing this calculated metric from external APIs, for
              #     example, "calcMetric:\\{calculated_metric_id}".
              #   @param calculated_metric [::Google::Analytics::Admin::V1alpha::CalculatedMetric, ::Hash]
              #     Required. The CalculatedMetric to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest.new
              #
              #   # Call the create_calculated_metric method.
              #   result = client.create_calculated_metric request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CalculatedMetric.
              #   p result
              #
              def create_calculated_metric request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateCalculatedMetricRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_calculated_metric.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_calculated_metric.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_calculated_metric.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_calculated_metric request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists CalculatedMetrics on a property.
              #
              # @overload list_calculated_metrics(request, options = nil)
              #   Pass arguments to `list_calculated_metrics` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_calculated_metrics(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_calculated_metrics` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example format: properties/1234
              #   @param page_size [::Integer]
              #     Optional. The maximum number of resources to return.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200 (higher values will be coerced to the maximum).
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListCalculatedMetrics`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListCalculatedMetrics`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::CalculatedMetric>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::CalculatedMetric>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest.new
              #
              #   # Call the list_calculated_metrics method.
              #   result = client.list_calculated_metrics request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::CalculatedMetric.
              #     p item
              #   end
              #
              def list_calculated_metrics request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListCalculatedMetricsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_calculated_metrics.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_calculated_metrics.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_calculated_metrics.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_calculated_metrics request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_calculated_metrics, "calculated_metrics", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a CalculatedMetric on a property.
              #
              # @overload update_calculated_metric(request, options = nil)
              #   Pass arguments to `update_calculated_metric` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_calculated_metric(calculated_metric: nil, update_mask: nil)
              #   Pass arguments to `update_calculated_metric` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param calculated_metric [::Google::Analytics::Admin::V1alpha::CalculatedMetric, ::Hash]
              #     Required. The CalculatedMetric to update
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. Omitted fields will not be
              #     updated. To replace the entire entity, use one path with the string "*" to
              #     match all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CalculatedMetric]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest.new
              #
              #   # Call the update_calculated_metric method.
              #   result = client.update_calculated_metric request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CalculatedMetric.
              #   p result
              #
              def update_calculated_metric request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateCalculatedMetricRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_calculated_metric.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_calculated_metric.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_calculated_metric.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_calculated_metric request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a CalculatedMetric on a property.
              #
              # @overload delete_calculated_metric(request, options = nil)
              #   Pass arguments to `delete_calculated_metric` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_calculated_metric(name: nil)
              #   Pass arguments to `delete_calculated_metric` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CalculatedMetric to delete.
              #     Format: properties/\\{property_id}/calculatedMetrics/\\{calculated_metric_id}
              #     Example: properties/1234/calculatedMetrics/Metric01
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest.new
              #
              #   # Call the delete_calculated_metric method.
              #   result = client.delete_calculated_metric request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_calculated_metric request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteCalculatedMetricRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_calculated_metric.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_calculated_metric.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_calculated_metric.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_calculated_metric request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a roll-up property and all roll-up property source links.
              #
              # @overload create_rollup_property(request, options = nil)
              #   Pass arguments to `create_rollup_property` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_rollup_property(rollup_property: nil, source_properties: nil)
              #   Pass arguments to `create_rollup_property` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param rollup_property [::Google::Analytics::Admin::V1alpha::Property, ::Hash]
              #     Required. The roll-up property to create.
              #   @param source_properties [::Array<::String>]
              #     Optional. The resource names of properties that will be sources to the
              #     created roll-up property.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::CreateRollupPropertyResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::CreateRollupPropertyResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest.new
              #
              #   # Call the create_rollup_property method.
              #   result = client.create_rollup_property request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::CreateRollupPropertyResponse.
              #   p result
              #
              def create_rollup_property request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateRollupPropertyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_rollup_property.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_rollup_property.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_rollup_property.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_rollup_property request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single roll-up property source Link.
              # Only roll-up properties can have source links, so this method will throw an
              # error if used on other types of properties.
              #
              # @overload get_rollup_property_source_link(request, options = nil)
              #   Pass arguments to `get_rollup_property_source_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_rollup_property_source_link(name: nil)
              #   Pass arguments to `get_rollup_property_source_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the roll-up property source link to lookup.
              #     Format:
              #     properties/\\{property_id}/rollupPropertySourceLinks/\\{rollup_property_source_link_id}
              #     Example: properties/123/rollupPropertySourceLinks/456
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest.new
              #
              #   # Call the get_rollup_property_source_link method.
              #   result = client.get_rollup_property_source_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::RollupPropertySourceLink.
              #   p result
              #
              def get_rollup_property_source_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetRollupPropertySourceLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_rollup_property_source_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_rollup_property_source_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_rollup_property_source_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_rollup_property_source_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists roll-up property source Links on a property.
              # Only roll-up properties can have source links, so this method will throw an
              # error if used on other types of properties.
              #
              # @overload list_rollup_property_source_links(request, options = nil)
              #   Pass arguments to `list_rollup_property_source_links` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_rollup_property_source_links(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_rollup_property_source_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the roll-up property to list roll-up property source
              #     links under. Format: properties/\\{property_id} Example: properties/1234
              #   @param page_size [::Integer]
              #     Optional. The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages.
              #     If unspecified, at most 50 resources will be returned.
              #     The maximum value is 200; (higher values will be coerced to the maximum)
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     `ListRollupPropertySourceLinks` call. Provide this to retrieve the
              #     subsequent page. When paginating, all other parameters provided to
              #     `ListRollupPropertySourceLinks` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest.new
              #
              #   # Call the list_rollup_property_source_links method.
              #   result = client.list_rollup_property_source_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink.
              #     p item
              #   end
              #
              def list_rollup_property_source_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListRollupPropertySourceLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_rollup_property_source_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_rollup_property_source_links.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_rollup_property_source_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_rollup_property_source_links request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_rollup_property_source_links, "rollup_property_source_links", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a roll-up property source link.
              # Only roll-up properties can have source links, so this method will throw an
              # error if used on other types of properties.
              #
              # @overload create_rollup_property_source_link(request, options = nil)
              #   Pass arguments to `create_rollup_property_source_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_rollup_property_source_link(parent: nil, rollup_property_source_link: nil)
              #   Pass arguments to `create_rollup_property_source_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format: properties/\\{property_id}
              #     Example: properties/1234
              #   @param rollup_property_source_link [::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink, ::Hash]
              #     Required. The roll-up property source link to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::RollupPropertySourceLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest.new
              #
              #   # Call the create_rollup_property_source_link method.
              #   result = client.create_rollup_property_source_link request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::RollupPropertySourceLink.
              #   p result
              #
              def create_rollup_property_source_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateRollupPropertySourceLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_rollup_property_source_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_rollup_property_source_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_rollup_property_source_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_rollup_property_source_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a roll-up property source link.
              # Only roll-up properties can have source links, so this method will throw an
              # error if used on other types of properties.
              #
              # @overload delete_rollup_property_source_link(request, options = nil)
              #   Pass arguments to `delete_rollup_property_source_link` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_rollup_property_source_link(name: nil)
              #   Pass arguments to `delete_rollup_property_source_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     properties/\\{property_id}/rollupPropertySourceLinks/\\{rollup_property_source_link_id}
              #     Example: properties/1234/rollupPropertySourceLinks/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest.new
              #
              #   # Call the delete_rollup_property_source_link method.
              #   result = client.delete_rollup_property_source_link request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_rollup_property_source_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteRollupPropertySourceLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_rollup_property_source_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_rollup_property_source_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_rollup_property_source_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_rollup_property_source_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a subproperty and a subproperty event filter that applies to the
              # created subproperty.
              #
              # @overload provision_subproperty(request, options = nil)
              #   Pass arguments to `provision_subproperty` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload provision_subproperty(subproperty: nil, subproperty_event_filter: nil, custom_dimension_and_metric_synchronization_mode: nil)
              #   Pass arguments to `provision_subproperty` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param subproperty [::Google::Analytics::Admin::V1alpha::Property, ::Hash]
              #     Required. The subproperty to create.
              #   @param subproperty_event_filter [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter, ::Hash]
              #     Optional. The subproperty event filter to create on an ordinary property.
              #   @param custom_dimension_and_metric_synchronization_mode [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig::SynchronizationMode]
              #     Optional. The subproperty feature synchronization mode for Custom
              #     Dimensions and Metrics
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest.new
              #
              #   # Call the provision_subproperty method.
              #   result = client.provision_subproperty request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ProvisionSubpropertyResponse.
              #   p result
              #
              def provision_subproperty request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ProvisionSubpropertyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.provision_subproperty.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.provision_subproperty.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.provision_subproperty.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.provision_subproperty request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a subproperty Event Filter.
              #
              # @overload create_subproperty_event_filter(request, options = nil)
              #   Pass arguments to `create_subproperty_event_filter` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_subproperty_event_filter(parent: nil, subproperty_event_filter: nil)
              #   Pass arguments to `create_subproperty_event_filter` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The ordinary property for which to create a subproperty event
              #     filter. Format: properties/property_id Example: properties/123
              #   @param subproperty_event_filter [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter, ::Hash]
              #     Required. The subproperty event filter to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest.new
              #
              #   # Call the create_subproperty_event_filter method.
              #   result = client.create_subproperty_event_filter request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.
              #   p result
              #
              def create_subproperty_event_filter request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateSubpropertyEventFilterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_subproperty_event_filter.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_subproperty_event_filter.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_subproperty_event_filter.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_subproperty_event_filter request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single subproperty Event Filter.
              #
              # @overload get_subproperty_event_filter(request, options = nil)
              #   Pass arguments to `get_subproperty_event_filter` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_subproperty_event_filter(name: nil)
              #   Pass arguments to `get_subproperty_event_filter` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the subproperty event filter to lookup.
              #     Format:
              #     properties/property_id/subpropertyEventFilters/subproperty_event_filter
              #     Example: properties/123/subpropertyEventFilters/456
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest.new
              #
              #   # Call the get_subproperty_event_filter method.
              #   result = client.get_subproperty_event_filter request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.
              #   p result
              #
              def get_subproperty_event_filter request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetSubpropertyEventFilterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_subproperty_event_filter.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_subproperty_event_filter.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_subproperty_event_filter.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_subproperty_event_filter request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List all subproperty Event Filters on a property.
              #
              # @overload list_subproperty_event_filters(request, options = nil)
              #   Pass arguments to `list_subproperty_event_filters` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_subproperty_event_filters(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_subproperty_event_filters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the ordinary property.
              #     Format: properties/property_id
              #     Example: properties/123
              #   @param page_size [::Integer]
              #     Optional. The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages. If unspecified,
              #     at most 50 resources will be returned. The maximum value is 200; (higher
              #     values will be coerced to the maximum)
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     `ListSubpropertyEventFilters` call. Provide this to retrieve the subsequent
              #     page. When paginating, all other parameters provided to
              #     `ListSubpropertyEventFilters` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest.new
              #
              #   # Call the list_subproperty_event_filters method.
              #   result = client.list_subproperty_event_filters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.
              #     p item
              #   end
              #
              def list_subproperty_event_filters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListSubpropertyEventFiltersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_subproperty_event_filters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_subproperty_event_filters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_subproperty_event_filters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_subproperty_event_filters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_subproperty_event_filters, "subproperty_event_filters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a subproperty Event Filter.
              #
              # @overload update_subproperty_event_filter(request, options = nil)
              #   Pass arguments to `update_subproperty_event_filter` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_subproperty_event_filter(subproperty_event_filter: nil, update_mask: nil)
              #   Pass arguments to `update_subproperty_event_filter` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param subproperty_event_filter [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter, ::Hash]
              #     Required. The subproperty event filter to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update. Field names must be in snake case
              #     (for example, "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SubpropertyEventFilter]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest.new
              #
              #   # Call the update_subproperty_event_filter method.
              #   result = client.update_subproperty_event_filter request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SubpropertyEventFilter.
              #   p result
              #
              def update_subproperty_event_filter request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateSubpropertyEventFilterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_subproperty_event_filter.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_subproperty_event_filter.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_subproperty_event_filter.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_subproperty_event_filter request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a subproperty event filter.
              #
              # @overload delete_subproperty_event_filter(request, options = nil)
              #   Pass arguments to `delete_subproperty_event_filter` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_subproperty_event_filter(name: nil)
              #   Pass arguments to `delete_subproperty_event_filter` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the subproperty event filter to delete.
              #     Format:
              #     properties/property_id/subpropertyEventFilters/subproperty_event_filter
              #     Example: properties/123/subpropertyEventFilters/456
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest.new
              #
              #   # Call the delete_subproperty_event_filter method.
              #   result = client.delete_subproperty_event_filter request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_subproperty_event_filter request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteSubpropertyEventFilterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_subproperty_event_filter.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_subproperty_event_filter.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_subproperty_event_filter.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_subproperty_event_filter request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Reporting Data Annotation.
              #
              # @overload create_reporting_data_annotation(request, options = nil)
              #   Pass arguments to `create_reporting_data_annotation` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_reporting_data_annotation(parent: nil, reporting_data_annotation: nil)
              #   Pass arguments to `create_reporting_data_annotation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The property for which to create a Reporting Data Annotation.
              #     Format: properties/property_id
              #     Example: properties/123
              #   @param reporting_data_annotation [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation, ::Hash]
              #     Required. The Reporting Data Annotation to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest.new
              #
              #   # Call the create_reporting_data_annotation method.
              #   result = client.create_reporting_data_annotation request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.
              #   p result
              #
              def create_reporting_data_annotation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::CreateReportingDataAnnotationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_reporting_data_annotation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_reporting_data_annotation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_reporting_data_annotation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.create_reporting_data_annotation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup a single Reporting Data Annotation.
              #
              # @overload get_reporting_data_annotation(request, options = nil)
              #   Pass arguments to `get_reporting_data_annotation` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_reporting_data_annotation(name: nil)
              #   Pass arguments to `get_reporting_data_annotation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the Reporting Data Annotation to lookup.
              #     Format:
              #     properties/property_id/reportingDataAnnotations/reportingDataAnnotation
              #     Example: properties/123/reportingDataAnnotations/456
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest.new
              #
              #   # Call the get_reporting_data_annotation method.
              #   result = client.get_reporting_data_annotation request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.
              #   p result
              #
              def get_reporting_data_annotation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetReportingDataAnnotationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_reporting_data_annotation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_reporting_data_annotation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_reporting_data_annotation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_reporting_data_annotation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List all Reporting Data Annotations on a property.
              #
              # @overload list_reporting_data_annotations(request, options = nil)
              #   Pass arguments to `list_reporting_data_annotations` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_reporting_data_annotations(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_reporting_data_annotations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the property.
              #     Format: properties/property_id
              #     Example: properties/123
              #   @param filter [::String]
              #     Optional. Filter that restricts which reporting data annotations under the
              #     parent property are listed.
              #
              #     Supported fields are:
              #
              #       * 'name'
              #       * `title`
              #       * `description`
              #       * `annotation_date`
              #       * `annotation_date_range`
              #       * `color`
              #
              #     Additionally, this API provides the following helper functions:
              #
              #       * annotation_duration() : the duration that this annotation marks,
              #       [durations](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/duration.proto).
              #       expect a numeric representation of seconds followed by an `s` suffix.
              #       * is_annotation_in_range(start_date, end_date)  : if the annotation is in
              #       the range specified by the `start_date` and `end_date`. The dates are in
              #       ISO-8601 format, for example `2031-06-28`.
              #
              #     Supported operations:
              #
              #     * `=` : equals
              #     * `!=` : not equals
              #     * `<` : less than
              #     * `>` : greater than
              #     * `<=` :  less than or equals
              #     * `>=` : greater than or equals
              #     * `:` : has operator
              #     * `=~` : [regular expression](https://github.com/google/re2/wiki/Syntax)
              #     match
              #     * `!~` : [regular expression](https://github.com/google/re2/wiki/Syntax)
              #     does not match
              #     * `NOT` : Logical not
              #     * `AND` : Logical and
              #     * `OR` : Logical or
              #
              #     Examples:
              #
              #       1. `title="Holiday Sale"`
              #       2. `description=~"[Bb]ig [Gg]ame.*[Ss]ale"`
              #       3. `is_annotation_in_range("2025-12-25", "2026-01-16") = true`
              #       4. `annotation_duration() >= 172800s AND title:BOGO`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages. If unspecified,
              #     at most 50 resources will be returned. The maximum value is 200; (higher
              #     values will be coerced to the maximum)
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     `ListReportingDataAnnotations` call. Provide this to retrieve the
              #     subsequent page. When paginating, all other parameters provided to
              #     `ListReportingDataAnnotations` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest.new
              #
              #   # Call the list_reporting_data_annotations method.
              #   result = client.list_reporting_data_annotations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.
              #     p item
              #   end
              #
              def list_reporting_data_annotations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListReportingDataAnnotationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_reporting_data_annotations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_reporting_data_annotations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_reporting_data_annotations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_reporting_data_annotations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_reporting_data_annotations, "reporting_data_annotations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a Reporting Data Annotation.
              #
              # @overload update_reporting_data_annotation(request, options = nil)
              #   Pass arguments to `update_reporting_data_annotation` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_reporting_data_annotation(reporting_data_annotation: nil, update_mask: nil)
              #   Pass arguments to `update_reporting_data_annotation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param reporting_data_annotation [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation, ::Hash]
              #     Required. The Reporting Data Annotation to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to update. Field names must be in snake case
              #     (for example, "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ReportingDataAnnotation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest.new
              #
              #   # Call the update_reporting_data_annotation method.
              #   result = client.update_reporting_data_annotation request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ReportingDataAnnotation.
              #   p result
              #
              def update_reporting_data_annotation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateReportingDataAnnotationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_reporting_data_annotation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_reporting_data_annotation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_reporting_data_annotation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_reporting_data_annotation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Reporting Data Annotation.
              #
              # @overload delete_reporting_data_annotation(request, options = nil)
              #   Pass arguments to `delete_reporting_data_annotation` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_reporting_data_annotation(name: nil)
              #   Pass arguments to `delete_reporting_data_annotation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the Reporting Data Annotation to delete.
              #     Format:
              #     properties/property_id/reportingDataAnnotations/reporting_data_annotation
              #     Example: properties/123/reportingDataAnnotations/456
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest.new
              #
              #   # Call the delete_reporting_data_annotation method.
              #   result = client.delete_reporting_data_annotation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_reporting_data_annotation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::DeleteReportingDataAnnotationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_reporting_data_annotation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_reporting_data_annotation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_reporting_data_annotation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.delete_reporting_data_annotation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Submits a request for user deletion for a property.
              #
              # @overload submit_user_deletion(request, options = nil)
              #   Pass arguments to `submit_user_deletion` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload submit_user_deletion(user_id: nil, client_id: nil, app_instance_id: nil, user_provided_data: nil, name: nil)
              #   Pass arguments to `submit_user_deletion` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param user_id [::String]
              #     Google Analytics [user
              #     ID](https://firebase.google.com/docs/analytics/userid).
              #
              #     Note: The following parameters are mutually exclusive: `user_id`, `client_id`, `app_instance_id`, `user_provided_data`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param client_id [::String]
              #     Google Analytics [client
              #     ID](https://support.google.com/analytics/answer/11593727).
              #
              #     Note: The following parameters are mutually exclusive: `client_id`, `user_id`, `app_instance_id`, `user_provided_data`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param app_instance_id [::String]
              #     Firebase [application instance
              #     ID](https://firebase.google.com/docs/reference/android/com/google/firebase/analytics/FirebaseAnalytics.html#getAppInstanceId).
              #
              #     Note: The following parameters are mutually exclusive: `app_instance_id`, `user_id`, `client_id`, `user_provided_data`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param user_provided_data [::String]
              #     [User-provided
              #     data](https://support.google.com/analytics/answer/14077171).  May contain
              #     either one email address or one phone number.
              #
              #     Email addresses should be normalized as such:
              #
              #     * lowercase
              #     * remove periods before @ for gmail.com/googlemail.com addresses
              #     * remove all spaces
              #
              #     Phone numbers should be normalized as such:
              #
              #     * remove all non digit characters
              #     * add + prefix
              #
              #     Note: The following parameters are mutually exclusive: `user_provided_data`, `user_id`, `client_id`, `app_instance_id`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param name [::String]
              #     Required. The name of the property to submit user deletion for.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SubmitUserDeletionResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SubmitUserDeletionResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest.new
              #
              #   # Call the submit_user_deletion method.
              #   result = client.submit_user_deletion request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SubmitUserDeletionResponse.
              #   p result
              #
              def submit_user_deletion request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::SubmitUserDeletionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.submit_user_deletion.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.submit_user_deletion.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.submit_user_deletion.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.submit_user_deletion request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List all `SubpropertySyncConfig` resources for a property.
              #
              # @overload list_subproperty_sync_configs(request, options = nil)
              #   Pass arguments to `list_subproperty_sync_configs` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_subproperty_sync_configs(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_subproperty_sync_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the property.
              #     Format: properties/property_id
              #     Example: properties/123
              #   @param page_size [::Integer]
              #     Optional. The maximum number of resources to return. The service may return
              #     fewer than this value, even if there are additional pages. If unspecified,
              #     at most 50 resources will be returned. The maximum value is 200; (higher
              #     values will be coerced to the maximum)
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     `ListSubpropertySyncConfig` call. Provide this to retrieve the subsequent
              #     page. When paginating, all other parameters provided to
              #     `ListSubpropertySyncConfig` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest.new
              #
              #   # Call the list_subproperty_sync_configs method.
              #   result = client.list_subproperty_sync_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig.
              #     p item
              #   end
              #
              def list_subproperty_sync_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::ListSubpropertySyncConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_subproperty_sync_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_subproperty_sync_configs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_subproperty_sync_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.list_subproperty_sync_configs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @analytics_admin_service_stub, :list_subproperty_sync_configs, "subproperty_sync_configs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a `SubpropertySyncConfig`.
              #
              # @overload update_subproperty_sync_config(request, options = nil)
              #   Pass arguments to `update_subproperty_sync_config` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_subproperty_sync_config(subproperty_sync_config: nil, update_mask: nil)
              #   Pass arguments to `update_subproperty_sync_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param subproperty_sync_config [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig, ::Hash]
              #     Required. The `SubpropertySyncConfig` to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to update. Field names must be in snake case
              #     (for example, "field_to_update"). Omitted fields will not be updated. To
              #     replace the entire entity, use one path with the string "*" to match all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest.new
              #
              #   # Call the update_subproperty_sync_config method.
              #   result = client.update_subproperty_sync_config request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SubpropertySyncConfig.
              #   p result
              #
              def update_subproperty_sync_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::UpdateSubpropertySyncConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_subproperty_sync_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_subproperty_sync_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_subproperty_sync_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.update_subproperty_sync_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup for a single `SubpropertySyncConfig`.
              #
              # @overload get_subproperty_sync_config(request, options = nil)
              #   Pass arguments to `get_subproperty_sync_config` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_subproperty_sync_config(name: nil)
              #   Pass arguments to `get_subproperty_sync_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the SubpropertySyncConfig to lookup.
              #     Format:
              #     properties/\\{ordinary_property_id}/subpropertySyncConfigs/\\{subproperty_id}
              #     Example: properties/1234/subpropertySyncConfigs/5678
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::SubpropertySyncConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest.new
              #
              #   # Call the get_subproperty_sync_config method.
              #   result = client.get_subproperty_sync_config request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::SubpropertySyncConfig.
              #   p result
              #
              def get_subproperty_sync_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetSubpropertySyncConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_subproperty_sync_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_subproperty_sync_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_subproperty_sync_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_subproperty_sync_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the singleton data retention settings for this property.
              #
              # @overload get_reporting_identity_settings(request, options = nil)
              #   Pass arguments to `get_reporting_identity_settings` via a request object, either of type
              #   {::Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_reporting_identity_settings(name: nil)
              #   Pass arguments to `get_reporting_identity_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the settings to lookup.
              #     Format:
              #     properties/\\{property}/reportingIdentitySettings
              #     Example: "properties/1000/reportingIdentitySettings"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Analytics::Admin::V1alpha::ReportingIdentitySettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Analytics::Admin::V1alpha::ReportingIdentitySettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/analytics/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest.new
              #
              #   # Call the get_reporting_identity_settings method.
              #   result = client.get_reporting_identity_settings request
              #
              #   # The returned object is of type Google::Analytics::Admin::V1alpha::ReportingIdentitySettings.
              #   p result
              #
              def get_reporting_identity_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Analytics::Admin::V1alpha::GetReportingIdentitySettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_reporting_identity_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Analytics::Admin::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_reporting_identity_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_reporting_identity_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_admin_service_stub.get_reporting_identity_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AnalyticsAdminService REST API.
              #
              # This class represents the configuration for AnalyticsAdminService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_account to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_account.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Analytics::Admin::V1alpha::AnalyticsAdminService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_account.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "analyticsadmin.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the AnalyticsAdminService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_account
                  ##
                  # RPC-specific configuration for `list_accounts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_accounts
                  ##
                  # RPC-specific configuration for `delete_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_account
                  ##
                  # RPC-specific configuration for `update_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_account
                  ##
                  # RPC-specific configuration for `provision_account_ticket`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :provision_account_ticket
                  ##
                  # RPC-specific configuration for `list_account_summaries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_account_summaries
                  ##
                  # RPC-specific configuration for `get_property`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_property
                  ##
                  # RPC-specific configuration for `list_properties`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_properties
                  ##
                  # RPC-specific configuration for `create_property`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_property
                  ##
                  # RPC-specific configuration for `delete_property`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_property
                  ##
                  # RPC-specific configuration for `update_property`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_property
                  ##
                  # RPC-specific configuration for `create_firebase_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_firebase_link
                  ##
                  # RPC-specific configuration for `delete_firebase_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_firebase_link
                  ##
                  # RPC-specific configuration for `list_firebase_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_firebase_links
                  ##
                  # RPC-specific configuration for `get_global_site_tag`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_global_site_tag
                  ##
                  # RPC-specific configuration for `create_google_ads_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_google_ads_link
                  ##
                  # RPC-specific configuration for `update_google_ads_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_google_ads_link
                  ##
                  # RPC-specific configuration for `delete_google_ads_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_google_ads_link
                  ##
                  # RPC-specific configuration for `list_google_ads_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_google_ads_links
                  ##
                  # RPC-specific configuration for `get_data_sharing_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_sharing_settings
                  ##
                  # RPC-specific configuration for `get_measurement_protocol_secret`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_measurement_protocol_secret
                  ##
                  # RPC-specific configuration for `list_measurement_protocol_secrets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_measurement_protocol_secrets
                  ##
                  # RPC-specific configuration for `create_measurement_protocol_secret`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_measurement_protocol_secret
                  ##
                  # RPC-specific configuration for `delete_measurement_protocol_secret`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_measurement_protocol_secret
                  ##
                  # RPC-specific configuration for `update_measurement_protocol_secret`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_measurement_protocol_secret
                  ##
                  # RPC-specific configuration for `acknowledge_user_data_collection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :acknowledge_user_data_collection
                  ##
                  # RPC-specific configuration for `get_sk_ad_network_conversion_value_schema`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_sk_ad_network_conversion_value_schema
                  ##
                  # RPC-specific configuration for `create_sk_ad_network_conversion_value_schema`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_sk_ad_network_conversion_value_schema
                  ##
                  # RPC-specific configuration for `delete_sk_ad_network_conversion_value_schema`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_sk_ad_network_conversion_value_schema
                  ##
                  # RPC-specific configuration for `update_sk_ad_network_conversion_value_schema`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_sk_ad_network_conversion_value_schema
                  ##
                  # RPC-specific configuration for `list_sk_ad_network_conversion_value_schemas`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_sk_ad_network_conversion_value_schemas
                  ##
                  # RPC-specific configuration for `search_change_history_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_change_history_events
                  ##
                  # RPC-specific configuration for `get_google_signals_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_google_signals_settings
                  ##
                  # RPC-specific configuration for `update_google_signals_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_google_signals_settings
                  ##
                  # RPC-specific configuration for `create_conversion_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_conversion_event
                  ##
                  # RPC-specific configuration for `update_conversion_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_conversion_event
                  ##
                  # RPC-specific configuration for `get_conversion_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_conversion_event
                  ##
                  # RPC-specific configuration for `delete_conversion_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_conversion_event
                  ##
                  # RPC-specific configuration for `list_conversion_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_conversion_events
                  ##
                  # RPC-specific configuration for `create_key_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_key_event
                  ##
                  # RPC-specific configuration for `update_key_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_key_event
                  ##
                  # RPC-specific configuration for `get_key_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_key_event
                  ##
                  # RPC-specific configuration for `delete_key_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_key_event
                  ##
                  # RPC-specific configuration for `list_key_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_key_events
                  ##
                  # RPC-specific configuration for `get_display_video360_advertiser_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_display_video360_advertiser_link
                  ##
                  # RPC-specific configuration for `list_display_video360_advertiser_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_display_video360_advertiser_links
                  ##
                  # RPC-specific configuration for `create_display_video360_advertiser_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_display_video360_advertiser_link
                  ##
                  # RPC-specific configuration for `delete_display_video360_advertiser_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_display_video360_advertiser_link
                  ##
                  # RPC-specific configuration for `update_display_video360_advertiser_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_display_video360_advertiser_link
                  ##
                  # RPC-specific configuration for `get_display_video360_advertiser_link_proposal`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_display_video360_advertiser_link_proposal
                  ##
                  # RPC-specific configuration for `list_display_video360_advertiser_link_proposals`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_display_video360_advertiser_link_proposals
                  ##
                  # RPC-specific configuration for `create_display_video360_advertiser_link_proposal`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_display_video360_advertiser_link_proposal
                  ##
                  # RPC-specific configuration for `delete_display_video360_advertiser_link_proposal`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_display_video360_advertiser_link_proposal
                  ##
                  # RPC-specific configuration for `approve_display_video360_advertiser_link_proposal`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :approve_display_video360_advertiser_link_proposal
                  ##
                  # RPC-specific configuration for `cancel_display_video360_advertiser_link_proposal`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_display_video360_advertiser_link_proposal
                  ##
                  # RPC-specific configuration for `create_custom_dimension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_custom_dimension
                  ##
                  # RPC-specific configuration for `update_custom_dimension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_custom_dimension
                  ##
                  # RPC-specific configuration for `list_custom_dimensions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_custom_dimensions
                  ##
                  # RPC-specific configuration for `archive_custom_dimension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :archive_custom_dimension
                  ##
                  # RPC-specific configuration for `get_custom_dimension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_custom_dimension
                  ##
                  # RPC-specific configuration for `create_custom_metric`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_custom_metric
                  ##
                  # RPC-specific configuration for `update_custom_metric`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_custom_metric
                  ##
                  # RPC-specific configuration for `list_custom_metrics`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_custom_metrics
                  ##
                  # RPC-specific configuration for `archive_custom_metric`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :archive_custom_metric
                  ##
                  # RPC-specific configuration for `get_custom_metric`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_custom_metric
                  ##
                  # RPC-specific configuration for `get_data_retention_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_retention_settings
                  ##
                  # RPC-specific configuration for `update_data_retention_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_retention_settings
                  ##
                  # RPC-specific configuration for `create_data_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_data_stream
                  ##
                  # RPC-specific configuration for `delete_data_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_data_stream
                  ##
                  # RPC-specific configuration for `update_data_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_stream
                  ##
                  # RPC-specific configuration for `list_data_streams`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_data_streams
                  ##
                  # RPC-specific configuration for `get_data_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_stream
                  ##
                  # RPC-specific configuration for `get_audience`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_audience
                  ##
                  # RPC-specific configuration for `list_audiences`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_audiences
                  ##
                  # RPC-specific configuration for `create_audience`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_audience
                  ##
                  # RPC-specific configuration for `update_audience`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_audience
                  ##
                  # RPC-specific configuration for `archive_audience`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :archive_audience
                  ##
                  # RPC-specific configuration for `get_search_ads360_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_search_ads360_link
                  ##
                  # RPC-specific configuration for `list_search_ads360_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_search_ads360_links
                  ##
                  # RPC-specific configuration for `create_search_ads360_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_search_ads360_link
                  ##
                  # RPC-specific configuration for `delete_search_ads360_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_search_ads360_link
                  ##
                  # RPC-specific configuration for `update_search_ads360_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_search_ads360_link
                  ##
                  # RPC-specific configuration for `get_attribution_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_attribution_settings
                  ##
                  # RPC-specific configuration for `update_attribution_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_attribution_settings
                  ##
                  # RPC-specific configuration for `run_access_report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_access_report
                  ##
                  # RPC-specific configuration for `create_access_binding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_access_binding
                  ##
                  # RPC-specific configuration for `get_access_binding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_access_binding
                  ##
                  # RPC-specific configuration for `update_access_binding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_access_binding
                  ##
                  # RPC-specific configuration for `delete_access_binding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_access_binding
                  ##
                  # RPC-specific configuration for `list_access_bindings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_access_bindings
                  ##
                  # RPC-specific configuration for `batch_create_access_bindings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_create_access_bindings
                  ##
                  # RPC-specific configuration for `batch_get_access_bindings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_get_access_bindings
                  ##
                  # RPC-specific configuration for `batch_update_access_bindings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_update_access_bindings
                  ##
                  # RPC-specific configuration for `batch_delete_access_bindings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_delete_access_bindings
                  ##
                  # RPC-specific configuration for `get_expanded_data_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_expanded_data_set
                  ##
                  # RPC-specific configuration for `list_expanded_data_sets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_expanded_data_sets
                  ##
                  # RPC-specific configuration for `create_expanded_data_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_expanded_data_set
                  ##
                  # RPC-specific configuration for `update_expanded_data_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_expanded_data_set
                  ##
                  # RPC-specific configuration for `delete_expanded_data_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_expanded_data_set
                  ##
                  # RPC-specific configuration for `get_channel_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_channel_group
                  ##
                  # RPC-specific configuration for `list_channel_groups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_channel_groups
                  ##
                  # RPC-specific configuration for `create_channel_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_channel_group
                  ##
                  # RPC-specific configuration for `update_channel_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_channel_group
                  ##
                  # RPC-specific configuration for `delete_channel_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_channel_group
                  ##
                  # RPC-specific configuration for `create_big_query_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_big_query_link
                  ##
                  # RPC-specific configuration for `get_big_query_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_big_query_link
                  ##
                  # RPC-specific configuration for `list_big_query_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_big_query_links
                  ##
                  # RPC-specific configuration for `delete_big_query_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_big_query_link
                  ##
                  # RPC-specific configuration for `update_big_query_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_big_query_link
                  ##
                  # RPC-specific configuration for `get_enhanced_measurement_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_enhanced_measurement_settings
                  ##
                  # RPC-specific configuration for `update_enhanced_measurement_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_enhanced_measurement_settings
                  ##
                  # RPC-specific configuration for `get_ad_sense_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_ad_sense_link
                  ##
                  # RPC-specific configuration for `create_ad_sense_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_ad_sense_link
                  ##
                  # RPC-specific configuration for `delete_ad_sense_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_ad_sense_link
                  ##
                  # RPC-specific configuration for `list_ad_sense_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_ad_sense_links
                  ##
                  # RPC-specific configuration for `get_event_create_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_event_create_rule
                  ##
                  # RPC-specific configuration for `list_event_create_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_event_create_rules
                  ##
                  # RPC-specific configuration for `create_event_create_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_event_create_rule
                  ##
                  # RPC-specific configuration for `update_event_create_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_event_create_rule
                  ##
                  # RPC-specific configuration for `delete_event_create_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_event_create_rule
                  ##
                  # RPC-specific configuration for `get_event_edit_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_event_edit_rule
                  ##
                  # RPC-specific configuration for `list_event_edit_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_event_edit_rules
                  ##
                  # RPC-specific configuration for `create_event_edit_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_event_edit_rule
                  ##
                  # RPC-specific configuration for `update_event_edit_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_event_edit_rule
                  ##
                  # RPC-specific configuration for `delete_event_edit_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_event_edit_rule
                  ##
                  # RPC-specific configuration for `reorder_event_edit_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reorder_event_edit_rules
                  ##
                  # RPC-specific configuration for `update_data_redaction_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_redaction_settings
                  ##
                  # RPC-specific configuration for `get_data_redaction_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_redaction_settings
                  ##
                  # RPC-specific configuration for `get_calculated_metric`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_calculated_metric
                  ##
                  # RPC-specific configuration for `create_calculated_metric`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_calculated_metric
                  ##
                  # RPC-specific configuration for `list_calculated_metrics`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_calculated_metrics
                  ##
                  # RPC-specific configuration for `update_calculated_metric`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_calculated_metric
                  ##
                  # RPC-specific configuration for `delete_calculated_metric`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_calculated_metric
                  ##
                  # RPC-specific configuration for `create_rollup_property`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_rollup_property
                  ##
                  # RPC-specific configuration for `get_rollup_property_source_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_rollup_property_source_link
                  ##
                  # RPC-specific configuration for `list_rollup_property_source_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_rollup_property_source_links
                  ##
                  # RPC-specific configuration for `create_rollup_property_source_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_rollup_property_source_link
                  ##
                  # RPC-specific configuration for `delete_rollup_property_source_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_rollup_property_source_link
                  ##
                  # RPC-specific configuration for `provision_subproperty`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :provision_subproperty
                  ##
                  # RPC-specific configuration for `create_subproperty_event_filter`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_subproperty_event_filter
                  ##
                  # RPC-specific configuration for `get_subproperty_event_filter`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_subproperty_event_filter
                  ##
                  # RPC-specific configuration for `list_subproperty_event_filters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_subproperty_event_filters
                  ##
                  # RPC-specific configuration for `update_subproperty_event_filter`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_subproperty_event_filter
                  ##
                  # RPC-specific configuration for `delete_subproperty_event_filter`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_subproperty_event_filter
                  ##
                  # RPC-specific configuration for `create_reporting_data_annotation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_reporting_data_annotation
                  ##
                  # RPC-specific configuration for `get_reporting_data_annotation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_reporting_data_annotation
                  ##
                  # RPC-specific configuration for `list_reporting_data_annotations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_reporting_data_annotations
                  ##
                  # RPC-specific configuration for `update_reporting_data_annotation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_reporting_data_annotation
                  ##
                  # RPC-specific configuration for `delete_reporting_data_annotation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_reporting_data_annotation
                  ##
                  # RPC-specific configuration for `submit_user_deletion`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :submit_user_deletion
                  ##
                  # RPC-specific configuration for `list_subproperty_sync_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_subproperty_sync_configs
                  ##
                  # RPC-specific configuration for `update_subproperty_sync_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_subproperty_sync_config
                  ##
                  # RPC-specific configuration for `get_subproperty_sync_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_subproperty_sync_config
                  ##
                  # RPC-specific configuration for `get_reporting_identity_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_reporting_identity_settings

                  # @private
                  def initialize parent_rpcs = nil
                    get_account_config = parent_rpcs.get_account if parent_rpcs.respond_to? :get_account
                    @get_account = ::Gapic::Config::Method.new get_account_config
                    list_accounts_config = parent_rpcs.list_accounts if parent_rpcs.respond_to? :list_accounts
                    @list_accounts = ::Gapic::Config::Method.new list_accounts_config
                    delete_account_config = parent_rpcs.delete_account if parent_rpcs.respond_to? :delete_account
                    @delete_account = ::Gapic::Config::Method.new delete_account_config
                    update_account_config = parent_rpcs.update_account if parent_rpcs.respond_to? :update_account
                    @update_account = ::Gapic::Config::Method.new update_account_config
                    provision_account_ticket_config = parent_rpcs.provision_account_ticket if parent_rpcs.respond_to? :provision_account_ticket
                    @provision_account_ticket = ::Gapic::Config::Method.new provision_account_ticket_config
                    list_account_summaries_config = parent_rpcs.list_account_summaries if parent_rpcs.respond_to? :list_account_summaries
                    @list_account_summaries = ::Gapic::Config::Method.new list_account_summaries_config
                    get_property_config = parent_rpcs.get_property if parent_rpcs.respond_to? :get_property
                    @get_property = ::Gapic::Config::Method.new get_property_config
                    list_properties_config = parent_rpcs.list_properties if parent_rpcs.respond_to? :list_properties
                    @list_properties = ::Gapic::Config::Method.new list_properties_config
                    create_property_config = parent_rpcs.create_property if parent_rpcs.respond_to? :create_property
                    @create_property = ::Gapic::Config::Method.new create_property_config
                    delete_property_config = parent_rpcs.delete_property if parent_rpcs.respond_to? :delete_property
                    @delete_property = ::Gapic::Config::Method.new delete_property_config
                    update_property_config = parent_rpcs.update_property if parent_rpcs.respond_to? :update_property
                    @update_property = ::Gapic::Config::Method.new update_property_config
                    create_firebase_link_config = parent_rpcs.create_firebase_link if parent_rpcs.respond_to? :create_firebase_link
                    @create_firebase_link = ::Gapic::Config::Method.new create_firebase_link_config
                    delete_firebase_link_config = parent_rpcs.delete_firebase_link if parent_rpcs.respond_to? :delete_firebase_link
                    @delete_firebase_link = ::Gapic::Config::Method.new delete_firebase_link_config
                    list_firebase_links_config = parent_rpcs.list_firebase_links if parent_rpcs.respond_to? :list_firebase_links
                    @list_firebase_links = ::Gapic::Config::Method.new list_firebase_links_config
                    get_global_site_tag_config = parent_rpcs.get_global_site_tag if parent_rpcs.respond_to? :get_global_site_tag
                    @get_global_site_tag = ::Gapic::Config::Method.new get_global_site_tag_config
                    create_google_ads_link_config = parent_rpcs.create_google_ads_link if parent_rpcs.respond_to? :create_google_ads_link
                    @create_google_ads_link = ::Gapic::Config::Method.new create_google_ads_link_config
                    update_google_ads_link_config = parent_rpcs.update_google_ads_link if parent_rpcs.respond_to? :update_google_ads_link
                    @update_google_ads_link = ::Gapic::Config::Method.new update_google_ads_link_config
                    delete_google_ads_link_config = parent_rpcs.delete_google_ads_link if parent_rpcs.respond_to? :delete_google_ads_link
                    @delete_google_ads_link = ::Gapic::Config::Method.new delete_google_ads_link_config
                    list_google_ads_links_config = parent_rpcs.list_google_ads_links if parent_rpcs.respond_to? :list_google_ads_links
                    @list_google_ads_links = ::Gapic::Config::Method.new list_google_ads_links_config
                    get_data_sharing_settings_config = parent_rpcs.get_data_sharing_settings if parent_rpcs.respond_to? :get_data_sharing_settings
                    @get_data_sharing_settings = ::Gapic::Config::Method.new get_data_sharing_settings_config
                    get_measurement_protocol_secret_config = parent_rpcs.get_measurement_protocol_secret if parent_rpcs.respond_to? :get_measurement_protocol_secret
                    @get_measurement_protocol_secret = ::Gapic::Config::Method.new get_measurement_protocol_secret_config
                    list_measurement_protocol_secrets_config = parent_rpcs.list_measurement_protocol_secrets if parent_rpcs.respond_to? :list_measurement_protocol_secrets
                    @list_measurement_protocol_secrets = ::Gapic::Config::Method.new list_measurement_protocol_secrets_config
                    create_measurement_protocol_secret_config = parent_rpcs.create_measurement_protocol_secret if parent_rpcs.respond_to? :create_measurement_protocol_secret
                    @create_measurement_protocol_secret = ::Gapic::Config::Method.new create_measurement_protocol_secret_config
                    delete_measurement_protocol_secret_config = parent_rpcs.delete_measurement_protocol_secret if parent_rpcs.respond_to? :delete_measurement_protocol_secret
                    @delete_measurement_protocol_secret = ::Gapic::Config::Method.new delete_measurement_protocol_secret_config
                    update_measurement_protocol_secret_config = parent_rpcs.update_measurement_protocol_secret if parent_rpcs.respond_to? :update_measurement_protocol_secret
                    @update_measurement_protocol_secret = ::Gapic::Config::Method.new update_measurement_protocol_secret_config
                    acknowledge_user_data_collection_config = parent_rpcs.acknowledge_user_data_collection if parent_rpcs.respond_to? :acknowledge_user_data_collection
                    @acknowledge_user_data_collection = ::Gapic::Config::Method.new acknowledge_user_data_collection_config
                    get_sk_ad_network_conversion_value_schema_config = parent_rpcs.get_sk_ad_network_conversion_value_schema if parent_rpcs.respond_to? :get_sk_ad_network_conversion_value_schema
                    @get_sk_ad_network_conversion_value_schema = ::Gapic::Config::Method.new get_sk_ad_network_conversion_value_schema_config
                    create_sk_ad_network_conversion_value_schema_config = parent_rpcs.create_sk_ad_network_conversion_value_schema if parent_rpcs.respond_to? :create_sk_ad_network_conversion_value_schema
                    @create_sk_ad_network_conversion_value_schema = ::Gapic::Config::Method.new create_sk_ad_network_conversion_value_schema_config
                    delete_sk_ad_network_conversion_value_schema_config = parent_rpcs.delete_sk_ad_network_conversion_value_schema if parent_rpcs.respond_to? :delete_sk_ad_network_conversion_value_schema
                    @delete_sk_ad_network_conversion_value_schema = ::Gapic::Config::Method.new delete_sk_ad_network_conversion_value_schema_config
                    update_sk_ad_network_conversion_value_schema_config = parent_rpcs.update_sk_ad_network_conversion_value_schema if parent_rpcs.respond_to? :update_sk_ad_network_conversion_value_schema
                    @update_sk_ad_network_conversion_value_schema = ::Gapic::Config::Method.new update_sk_ad_network_conversion_value_schema_config
                    list_sk_ad_network_conversion_value_schemas_config = parent_rpcs.list_sk_ad_network_conversion_value_schemas if parent_rpcs.respond_to? :list_sk_ad_network_conversion_value_schemas
                    @list_sk_ad_network_conversion_value_schemas = ::Gapic::Config::Method.new list_sk_ad_network_conversion_value_schemas_config
                    search_change_history_events_config = parent_rpcs.search_change_history_events if parent_rpcs.respond_to? :search_change_history_events
                    @search_change_history_events = ::Gapic::Config::Method.new search_change_history_events_config
                    get_google_signals_settings_config = parent_rpcs.get_google_signals_settings if parent_rpcs.respond_to? :get_google_signals_settings
                    @get_google_signals_settings = ::Gapic::Config::Method.new get_google_signals_settings_config
                    update_google_signals_settings_config = parent_rpcs.update_google_signals_settings if parent_rpcs.respond_to? :update_google_signals_settings
                    @update_google_signals_settings = ::Gapic::Config::Method.new update_google_signals_settings_config
                    create_conversion_event_config = parent_rpcs.create_conversion_event if parent_rpcs.respond_to? :create_conversion_event
                    @create_conversion_event = ::Gapic::Config::Method.new create_conversion_event_config
                    update_conversion_event_config = parent_rpcs.update_conversion_event if parent_rpcs.respond_to? :update_conversion_event
                    @update_conversion_event = ::Gapic::Config::Method.new update_conversion_event_config
                    get_conversion_event_config = parent_rpcs.get_conversion_event if parent_rpcs.respond_to? :get_conversion_event
                    @get_conversion_event = ::Gapic::Config::Method.new get_conversion_event_config
                    delete_conversion_event_config = parent_rpcs.delete_conversion_event if parent_rpcs.respond_to? :delete_conversion_event
                    @delete_conversion_event = ::Gapic::Config::Method.new delete_conversion_event_config
                    list_conversion_events_config = parent_rpcs.list_conversion_events if parent_rpcs.respond_to? :list_conversion_events
                    @list_conversion_events = ::Gapic::Config::Method.new list_conversion_events_config
                    create_key_event_config = parent_rpcs.create_key_event if parent_rpcs.respond_to? :create_key_event
                    @create_key_event = ::Gapic::Config::Method.new create_key_event_config
                    update_key_event_config = parent_rpcs.update_key_event if parent_rpcs.respond_to? :update_key_event
                    @update_key_event = ::Gapic::Config::Method.new update_key_event_config
                    get_key_event_config = parent_rpcs.get_key_event if parent_rpcs.respond_to? :get_key_event
                    @get_key_event = ::Gapic::Config::Method.new get_key_event_config
                    delete_key_event_config = parent_rpcs.delete_key_event if parent_rpcs.respond_to? :delete_key_event
                    @delete_key_event = ::Gapic::Config::Method.new delete_key_event_config
                    list_key_events_config = parent_rpcs.list_key_events if parent_rpcs.respond_to? :list_key_events
                    @list_key_events = ::Gapic::Config::Method.new list_key_events_config
                    get_display_video360_advertiser_link_config = parent_rpcs.get_display_video360_advertiser_link if parent_rpcs.respond_to? :get_display_video360_advertiser_link
                    @get_display_video360_advertiser_link = ::Gapic::Config::Method.new get_display_video360_advertiser_link_config
                    list_display_video360_advertiser_links_config = parent_rpcs.list_display_video360_advertiser_links if parent_rpcs.respond_to? :list_display_video360_advertiser_links
                    @list_display_video360_advertiser_links = ::Gapic::Config::Method.new list_display_video360_advertiser_links_config
                    create_display_video360_advertiser_link_config = parent_rpcs.create_display_video360_advertiser_link if parent_rpcs.respond_to? :create_display_video360_advertiser_link
                    @create_display_video360_advertiser_link = ::Gapic::Config::Method.new create_display_video360_advertiser_link_config
                    delete_display_video360_advertiser_link_config = parent_rpcs.delete_display_video360_advertiser_link if parent_rpcs.respond_to? :delete_display_video360_advertiser_link
                    @delete_display_video360_advertiser_link = ::Gapic::Config::Method.new delete_display_video360_advertiser_link_config
                    update_display_video360_advertiser_link_config = parent_rpcs.update_display_video360_advertiser_link if parent_rpcs.respond_to? :update_display_video360_advertiser_link
                    @update_display_video360_advertiser_link = ::Gapic::Config::Method.new update_display_video360_advertiser_link_config
                    get_display_video360_advertiser_link_proposal_config = parent_rpcs.get_display_video360_advertiser_link_proposal if parent_rpcs.respond_to? :get_display_video360_advertiser_link_proposal
                    @get_display_video360_advertiser_link_proposal = ::Gapic::Config::Method.new get_display_video360_advertiser_link_proposal_config
                    list_display_video360_advertiser_link_proposals_config = parent_rpcs.list_display_video360_advertiser_link_proposals if parent_rpcs.respond_to? :list_display_video360_advertiser_link_proposals
                    @list_display_video360_advertiser_link_proposals = ::Gapic::Config::Method.new list_display_video360_advertiser_link_proposals_config
                    create_display_video360_advertiser_link_proposal_config = parent_rpcs.create_display_video360_advertiser_link_proposal if parent_rpcs.respond_to? :create_display_video360_advertiser_link_proposal
                    @create_display_video360_advertiser_link_proposal = ::Gapic::Config::Method.new create_display_video360_advertiser_link_proposal_config
                    delete_display_video360_advertiser_link_proposal_config = parent_rpcs.delete_display_video360_advertiser_link_proposal if parent_rpcs.respond_to? :delete_display_video360_advertiser_link_proposal
                    @delete_display_video360_advertiser_link_proposal = ::Gapic::Config::Method.new delete_display_video360_advertiser_link_proposal_config
                    approve_display_video360_advertiser_link_proposal_config = parent_rpcs.approve_display_video360_advertiser_link_proposal if parent_rpcs.respond_to? :approve_display_video360_advertiser_link_proposal
                    @approve_display_video360_advertiser_link_proposal = ::Gapic::Config::Method.new approve_display_video360_advertiser_link_proposal_config
                    cancel_display_video360_advertiser_link_proposal_config = parent_rpcs.cancel_display_video360_advertiser_link_proposal if parent_rpcs.respond_to? :cancel_display_video360_advertiser_link_proposal
                    @cancel_display_video360_advertiser_link_proposal = ::Gapic::Config::Method.new cancel_display_video360_advertiser_link_proposal_config
                    create_custom_dimension_config = parent_rpcs.create_custom_dimension if parent_rpcs.respond_to? :create_custom_dimension
                    @create_custom_dimension = ::Gapic::Config::Method.new create_custom_dimension_config
                    update_custom_dimension_config = parent_rpcs.update_custom_dimension if parent_rpcs.respond_to? :update_custom_dimension
                    @update_custom_dimension = ::Gapic::Config::Method.new update_custom_dimension_config
                    list_custom_dimensions_config = parent_rpcs.list_custom_dimensions if parent_rpcs.respond_to? :list_custom_dimensions
                    @list_custom_dimensions = ::Gapic::Config::Method.new list_custom_dimensions_config
                    archive_custom_dimension_config = parent_rpcs.archive_custom_dimension if parent_rpcs.respond_to? :archive_custom_dimension
                    @archive_custom_dimension = ::Gapic::Config::Method.new archive_custom_dimension_config
                    get_custom_dimension_config = parent_rpcs.get_custom_dimension if parent_rpcs.respond_to? :get_custom_dimension
                    @get_custom_dimension = ::Gapic::Config::Method.new get_custom_dimension_config
                    create_custom_metric_config = parent_rpcs.create_custom_metric if parent_rpcs.respond_to? :create_custom_metric
                    @create_custom_metric = ::Gapic::Config::Method.new create_custom_metric_config
                    update_custom_metric_config = parent_rpcs.update_custom_metric if parent_rpcs.respond_to? :update_custom_metric
                    @update_custom_metric = ::Gapic::Config::Method.new update_custom_metric_config
                    list_custom_metrics_config = parent_rpcs.list_custom_metrics if parent_rpcs.respond_to? :list_custom_metrics
                    @list_custom_metrics = ::Gapic::Config::Method.new list_custom_metrics_config
                    archive_custom_metric_config = parent_rpcs.archive_custom_metric if parent_rpcs.respond_to? :archive_custom_metric
                    @archive_custom_metric = ::Gapic::Config::Method.new archive_custom_metric_config
                    get_custom_metric_config = parent_rpcs.get_custom_metric if parent_rpcs.respond_to? :get_custom_metric
                    @get_custom_metric = ::Gapic::Config::Method.new get_custom_metric_config
                    get_data_retention_settings_config = parent_rpcs.get_data_retention_settings if parent_rpcs.respond_to? :get_data_retention_settings
                    @get_data_retention_settings = ::Gapic::Config::Method.new get_data_retention_settings_config
                    update_data_retention_settings_config = parent_rpcs.update_data_retention_settings if parent_rpcs.respond_to? :update_data_retention_settings
                    @update_data_retention_settings = ::Gapic::Config::Method.new update_data_retention_settings_config
                    create_data_stream_config = parent_rpcs.create_data_stream if parent_rpcs.respond_to? :create_data_stream
                    @create_data_stream = ::Gapic::Config::Method.new create_data_stream_config
                    delete_data_stream_config = parent_rpcs.delete_data_stream if parent_rpcs.respond_to? :delete_data_stream
                    @delete_data_stream = ::Gapic::Config::Method.new delete_data_stream_config
                    update_data_stream_config = parent_rpcs.update_data_stream if parent_rpcs.respond_to? :update_data_stream
                    @update_data_stream = ::Gapic::Config::Method.new update_data_stream_config
                    list_data_streams_config = parent_rpcs.list_data_streams if parent_rpcs.respond_to? :list_data_streams
                    @list_data_streams = ::Gapic::Config::Method.new list_data_streams_config
                    get_data_stream_config = parent_rpcs.get_data_stream if parent_rpcs.respond_to? :get_data_stream
                    @get_data_stream = ::Gapic::Config::Method.new get_data_stream_config
                    get_audience_config = parent_rpcs.get_audience if parent_rpcs.respond_to? :get_audience
                    @get_audience = ::Gapic::Config::Method.new get_audience_config
                    list_audiences_config = parent_rpcs.list_audiences if parent_rpcs.respond_to? :list_audiences
                    @list_audiences = ::Gapic::Config::Method.new list_audiences_config
                    create_audience_config = parent_rpcs.create_audience if parent_rpcs.respond_to? :create_audience
                    @create_audience = ::Gapic::Config::Method.new create_audience_config
                    update_audience_config = parent_rpcs.update_audience if parent_rpcs.respond_to? :update_audience
                    @update_audience = ::Gapic::Config::Method.new update_audience_config
                    archive_audience_config = parent_rpcs.archive_audience if parent_rpcs.respond_to? :archive_audience
                    @archive_audience = ::Gapic::Config::Method.new archive_audience_config
                    get_search_ads360_link_config = parent_rpcs.get_search_ads360_link if parent_rpcs.respond_to? :get_search_ads360_link
                    @get_search_ads360_link = ::Gapic::Config::Method.new get_search_ads360_link_config
                    list_search_ads360_links_config = parent_rpcs.list_search_ads360_links if parent_rpcs.respond_to? :list_search_ads360_links
                    @list_search_ads360_links = ::Gapic::Config::Method.new list_search_ads360_links_config
                    create_search_ads360_link_config = parent_rpcs.create_search_ads360_link if parent_rpcs.respond_to? :create_search_ads360_link
                    @create_search_ads360_link = ::Gapic::Config::Method.new create_search_ads360_link_config
                    delete_search_ads360_link_config = parent_rpcs.delete_search_ads360_link if parent_rpcs.respond_to? :delete_search_ads360_link
                    @delete_search_ads360_link = ::Gapic::Config::Method.new delete_search_ads360_link_config
                    update_search_ads360_link_config = parent_rpcs.update_search_ads360_link if parent_rpcs.respond_to? :update_search_ads360_link
                    @update_search_ads360_link = ::Gapic::Config::Method.new update_search_ads360_link_config
                    get_attribution_settings_config = parent_rpcs.get_attribution_settings if parent_rpcs.respond_to? :get_attribution_settings
                    @get_attribution_settings = ::Gapic::Config::Method.new get_attribution_settings_config
                    update_attribution_settings_config = parent_rpcs.update_attribution_settings if parent_rpcs.respond_to? :update_attribution_settings
                    @update_attribution_settings = ::Gapic::Config::Method.new update_attribution_settings_config
                    run_access_report_config = parent_rpcs.run_access_report if parent_rpcs.respond_to? :run_access_report
                    @run_access_report = ::Gapic::Config::Method.new run_access_report_config
                    create_access_binding_config = parent_rpcs.create_access_binding if parent_rpcs.respond_to? :create_access_binding
                    @create_access_binding = ::Gapic::Config::Method.new create_access_binding_config
                    get_access_binding_config = parent_rpcs.get_access_binding if parent_rpcs.respond_to? :get_access_binding
                    @get_access_binding = ::Gapic::Config::Method.new get_access_binding_config
                    update_access_binding_config = parent_rpcs.update_access_binding if parent_rpcs.respond_to? :update_access_binding
                    @update_access_binding = ::Gapic::Config::Method.new update_access_binding_config
                    delete_access_binding_config = parent_rpcs.delete_access_binding if parent_rpcs.respond_to? :delete_access_binding
                    @delete_access_binding = ::Gapic::Config::Method.new delete_access_binding_config
                    list_access_bindings_config = parent_rpcs.list_access_bindings if parent_rpcs.respond_to? :list_access_bindings
                    @list_access_bindings = ::Gapic::Config::Method.new list_access_bindings_config
                    batch_create_access_bindings_config = parent_rpcs.batch_create_access_bindings if parent_rpcs.respond_to? :batch_create_access_bindings
                    @batch_create_access_bindings = ::Gapic::Config::Method.new batch_create_access_bindings_config
                    batch_get_access_bindings_config = parent_rpcs.batch_get_access_bindings if parent_rpcs.respond_to? :batch_get_access_bindings
                    @batch_get_access_bindings = ::Gapic::Config::Method.new batch_get_access_bindings_config
                    batch_update_access_bindings_config = parent_rpcs.batch_update_access_bindings if parent_rpcs.respond_to? :batch_update_access_bindings
                    @batch_update_access_bindings = ::Gapic::Config::Method.new batch_update_access_bindings_config
                    batch_delete_access_bindings_config = parent_rpcs.batch_delete_access_bindings if parent_rpcs.respond_to? :batch_delete_access_bindings
                    @batch_delete_access_bindings = ::Gapic::Config::Method.new batch_delete_access_bindings_config
                    get_expanded_data_set_config = parent_rpcs.get_expanded_data_set if parent_rpcs.respond_to? :get_expanded_data_set
                    @get_expanded_data_set = ::Gapic::Config::Method.new get_expanded_data_set_config
                    list_expanded_data_sets_config = parent_rpcs.list_expanded_data_sets if parent_rpcs.respond_to? :list_expanded_data_sets
                    @list_expanded_data_sets = ::Gapic::Config::Method.new list_expanded_data_sets_config
                    create_expanded_data_set_config = parent_rpcs.create_expanded_data_set if parent_rpcs.respond_to? :create_expanded_data_set
                    @create_expanded_data_set = ::Gapic::Config::Method.new create_expanded_data_set_config
                    update_expanded_data_set_config = parent_rpcs.update_expanded_data_set if parent_rpcs.respond_to? :update_expanded_data_set
                    @update_expanded_data_set = ::Gapic::Config::Method.new update_expanded_data_set_config
                    delete_expanded_data_set_config = parent_rpcs.delete_expanded_data_set if parent_rpcs.respond_to? :delete_expanded_data_set
                    @delete_expanded_data_set = ::Gapic::Config::Method.new delete_expanded_data_set_config
                    get_channel_group_config = parent_rpcs.get_channel_group if parent_rpcs.respond_to? :get_channel_group
                    @get_channel_group = ::Gapic::Config::Method.new get_channel_group_config
                    list_channel_groups_config = parent_rpcs.list_channel_groups if parent_rpcs.respond_to? :list_channel_groups
                    @list_channel_groups = ::Gapic::Config::Method.new list_channel_groups_config
                    create_channel_group_config = parent_rpcs.create_channel_group if parent_rpcs.respond_to? :create_channel_group
                    @create_channel_group = ::Gapic::Config::Method.new create_channel_group_config
                    update_channel_group_config = parent_rpcs.update_channel_group if parent_rpcs.respond_to? :update_channel_group
                    @update_channel_group = ::Gapic::Config::Method.new update_channel_group_config
                    delete_channel_group_config = parent_rpcs.delete_channel_group if parent_rpcs.respond_to? :delete_channel_group
                    @delete_channel_group = ::Gapic::Config::Method.new delete_channel_group_config
                    create_big_query_link_config = parent_rpcs.create_big_query_link if parent_rpcs.respond_to? :create_big_query_link
                    @create_big_query_link = ::Gapic::Config::Method.new create_big_query_link_config
                    get_big_query_link_config = parent_rpcs.get_big_query_link if parent_rpcs.respond_to? :get_big_query_link
                    @get_big_query_link = ::Gapic::Config::Method.new get_big_query_link_config
                    list_big_query_links_config = parent_rpcs.list_big_query_links if parent_rpcs.respond_to? :list_big_query_links
                    @list_big_query_links = ::Gapic::Config::Method.new list_big_query_links_config
                    delete_big_query_link_config = parent_rpcs.delete_big_query_link if parent_rpcs.respond_to? :delete_big_query_link
                    @delete_big_query_link = ::Gapic::Config::Method.new delete_big_query_link_config
                    update_big_query_link_config = parent_rpcs.update_big_query_link if parent_rpcs.respond_to? :update_big_query_link
                    @update_big_query_link = ::Gapic::Config::Method.new update_big_query_link_config
                    get_enhanced_measurement_settings_config = parent_rpcs.get_enhanced_measurement_settings if parent_rpcs.respond_to? :get_enhanced_measurement_settings
                    @get_enhanced_measurement_settings = ::Gapic::Config::Method.new get_enhanced_measurement_settings_config
                    update_enhanced_measurement_settings_config = parent_rpcs.update_enhanced_measurement_settings if parent_rpcs.respond_to? :update_enhanced_measurement_settings
                    @update_enhanced_measurement_settings = ::Gapic::Config::Method.new update_enhanced_measurement_settings_config
                    get_ad_sense_link_config = parent_rpcs.get_ad_sense_link if parent_rpcs.respond_to? :get_ad_sense_link
                    @get_ad_sense_link = ::Gapic::Config::Method.new get_ad_sense_link_config
                    create_ad_sense_link_config = parent_rpcs.create_ad_sense_link if parent_rpcs.respond_to? :create_ad_sense_link
                    @create_ad_sense_link = ::Gapic::Config::Method.new create_ad_sense_link_config
                    delete_ad_sense_link_config = parent_rpcs.delete_ad_sense_link if parent_rpcs.respond_to? :delete_ad_sense_link
                    @delete_ad_sense_link = ::Gapic::Config::Method.new delete_ad_sense_link_config
                    list_ad_sense_links_config = parent_rpcs.list_ad_sense_links if parent_rpcs.respond_to? :list_ad_sense_links
                    @list_ad_sense_links = ::Gapic::Config::Method.new list_ad_sense_links_config
                    get_event_create_rule_config = parent_rpcs.get_event_create_rule if parent_rpcs.respond_to? :get_event_create_rule
                    @get_event_create_rule = ::Gapic::Config::Method.new get_event_create_rule_config
                    list_event_create_rules_config = parent_rpcs.list_event_create_rules if parent_rpcs.respond_to? :list_event_create_rules
                    @list_event_create_rules = ::Gapic::Config::Method.new list_event_create_rules_config
                    create_event_create_rule_config = parent_rpcs.create_event_create_rule if parent_rpcs.respond_to? :create_event_create_rule
                    @create_event_create_rule = ::Gapic::Config::Method.new create_event_create_rule_config
                    update_event_create_rule_config = parent_rpcs.update_event_create_rule if parent_rpcs.respond_to? :update_event_create_rule
                    @update_event_create_rule = ::Gapic::Config::Method.new update_event_create_rule_config
                    delete_event_create_rule_config = parent_rpcs.delete_event_create_rule if parent_rpcs.respond_to? :delete_event_create_rule
                    @delete_event_create_rule = ::Gapic::Config::Method.new delete_event_create_rule_config
                    get_event_edit_rule_config = parent_rpcs.get_event_edit_rule if parent_rpcs.respond_to? :get_event_edit_rule
                    @get_event_edit_rule = ::Gapic::Config::Method.new get_event_edit_rule_config
                    list_event_edit_rules_config = parent_rpcs.list_event_edit_rules if parent_rpcs.respond_to? :list_event_edit_rules
                    @list_event_edit_rules = ::Gapic::Config::Method.new list_event_edit_rules_config
                    create_event_edit_rule_config = parent_rpcs.create_event_edit_rule if parent_rpcs.respond_to? :create_event_edit_rule
                    @create_event_edit_rule = ::Gapic::Config::Method.new create_event_edit_rule_config
                    update_event_edit_rule_config = parent_rpcs.update_event_edit_rule if parent_rpcs.respond_to? :update_event_edit_rule
                    @update_event_edit_rule = ::Gapic::Config::Method.new update_event_edit_rule_config
                    delete_event_edit_rule_config = parent_rpcs.delete_event_edit_rule if parent_rpcs.respond_to? :delete_event_edit_rule
                    @delete_event_edit_rule = ::Gapic::Config::Method.new delete_event_edit_rule_config
                    reorder_event_edit_rules_config = parent_rpcs.reorder_event_edit_rules if parent_rpcs.respond_to? :reorder_event_edit_rules
                    @reorder_event_edit_rules = ::Gapic::Config::Method.new reorder_event_edit_rules_config
                    update_data_redaction_settings_config = parent_rpcs.update_data_redaction_settings if parent_rpcs.respond_to? :update_data_redaction_settings
                    @update_data_redaction_settings = ::Gapic::Config::Method.new update_data_redaction_settings_config
                    get_data_redaction_settings_config = parent_rpcs.get_data_redaction_settings if parent_rpcs.respond_to? :get_data_redaction_settings
                    @get_data_redaction_settings = ::Gapic::Config::Method.new get_data_redaction_settings_config
                    get_calculated_metric_config = parent_rpcs.get_calculated_metric if parent_rpcs.respond_to? :get_calculated_metric
                    @get_calculated_metric = ::Gapic::Config::Method.new get_calculated_metric_config
                    create_calculated_metric_config = parent_rpcs.create_calculated_metric if parent_rpcs.respond_to? :create_calculated_metric
                    @create_calculated_metric = ::Gapic::Config::Method.new create_calculated_metric_config
                    list_calculated_metrics_config = parent_rpcs.list_calculated_metrics if parent_rpcs.respond_to? :list_calculated_metrics
                    @list_calculated_metrics = ::Gapic::Config::Method.new list_calculated_metrics_config
                    update_calculated_metric_config = parent_rpcs.update_calculated_metric if parent_rpcs.respond_to? :update_calculated_metric
                    @update_calculated_metric = ::Gapic::Config::Method.new update_calculated_metric_config
                    delete_calculated_metric_config = parent_rpcs.delete_calculated_metric if parent_rpcs.respond_to? :delete_calculated_metric
                    @delete_calculated_metric = ::Gapic::Config::Method.new delete_calculated_metric_config
                    create_rollup_property_config = parent_rpcs.create_rollup_property if parent_rpcs.respond_to? :create_rollup_property
                    @create_rollup_property = ::Gapic::Config::Method.new create_rollup_property_config
                    get_rollup_property_source_link_config = parent_rpcs.get_rollup_property_source_link if parent_rpcs.respond_to? :get_rollup_property_source_link
                    @get_rollup_property_source_link = ::Gapic::Config::Method.new get_rollup_property_source_link_config
                    list_rollup_property_source_links_config = parent_rpcs.list_rollup_property_source_links if parent_rpcs.respond_to? :list_rollup_property_source_links
                    @list_rollup_property_source_links = ::Gapic::Config::Method.new list_rollup_property_source_links_config
                    create_rollup_property_source_link_config = parent_rpcs.create_rollup_property_source_link if parent_rpcs.respond_to? :create_rollup_property_source_link
                    @create_rollup_property_source_link = ::Gapic::Config::Method.new create_rollup_property_source_link_config
                    delete_rollup_property_source_link_config = parent_rpcs.delete_rollup_property_source_link if parent_rpcs.respond_to? :delete_rollup_property_source_link
                    @delete_rollup_property_source_link = ::Gapic::Config::Method.new delete_rollup_property_source_link_config
                    provision_subproperty_config = parent_rpcs.provision_subproperty if parent_rpcs.respond_to? :provision_subproperty
                    @provision_subproperty = ::Gapic::Config::Method.new provision_subproperty_config
                    create_subproperty_event_filter_config = parent_rpcs.create_subproperty_event_filter if parent_rpcs.respond_to? :create_subproperty_event_filter
                    @create_subproperty_event_filter = ::Gapic::Config::Method.new create_subproperty_event_filter_config
                    get_subproperty_event_filter_config = parent_rpcs.get_subproperty_event_filter if parent_rpcs.respond_to? :get_subproperty_event_filter
                    @get_subproperty_event_filter = ::Gapic::Config::Method.new get_subproperty_event_filter_config
                    list_subproperty_event_filters_config = parent_rpcs.list_subproperty_event_filters if parent_rpcs.respond_to? :list_subproperty_event_filters
                    @list_subproperty_event_filters = ::Gapic::Config::Method.new list_subproperty_event_filters_config
                    update_subproperty_event_filter_config = parent_rpcs.update_subproperty_event_filter if parent_rpcs.respond_to? :update_subproperty_event_filter
                    @update_subproperty_event_filter = ::Gapic::Config::Method.new update_subproperty_event_filter_config
                    delete_subproperty_event_filter_config = parent_rpcs.delete_subproperty_event_filter if parent_rpcs.respond_to? :delete_subproperty_event_filter
                    @delete_subproperty_event_filter = ::Gapic::Config::Method.new delete_subproperty_event_filter_config
                    create_reporting_data_annotation_config = parent_rpcs.create_reporting_data_annotation if parent_rpcs.respond_to? :create_reporting_data_annotation
                    @create_reporting_data_annotation = ::Gapic::Config::Method.new create_reporting_data_annotation_config
                    get_reporting_data_annotation_config = parent_rpcs.get_reporting_data_annotation if parent_rpcs.respond_to? :get_reporting_data_annotation
                    @get_reporting_data_annotation = ::Gapic::Config::Method.new get_reporting_data_annotation_config
                    list_reporting_data_annotations_config = parent_rpcs.list_reporting_data_annotations if parent_rpcs.respond_to? :list_reporting_data_annotations
                    @list_reporting_data_annotations = ::Gapic::Config::Method.new list_reporting_data_annotations_config
                    update_reporting_data_annotation_config = parent_rpcs.update_reporting_data_annotation if parent_rpcs.respond_to? :update_reporting_data_annotation
                    @update_reporting_data_annotation = ::Gapic::Config::Method.new update_reporting_data_annotation_config
                    delete_reporting_data_annotation_config = parent_rpcs.delete_reporting_data_annotation if parent_rpcs.respond_to? :delete_reporting_data_annotation
                    @delete_reporting_data_annotation = ::Gapic::Config::Method.new delete_reporting_data_annotation_config
                    submit_user_deletion_config = parent_rpcs.submit_user_deletion if parent_rpcs.respond_to? :submit_user_deletion
                    @submit_user_deletion = ::Gapic::Config::Method.new submit_user_deletion_config
                    list_subproperty_sync_configs_config = parent_rpcs.list_subproperty_sync_configs if parent_rpcs.respond_to? :list_subproperty_sync_configs
                    @list_subproperty_sync_configs = ::Gapic::Config::Method.new list_subproperty_sync_configs_config
                    update_subproperty_sync_config_config = parent_rpcs.update_subproperty_sync_config if parent_rpcs.respond_to? :update_subproperty_sync_config
                    @update_subproperty_sync_config = ::Gapic::Config::Method.new update_subproperty_sync_config_config
                    get_subproperty_sync_config_config = parent_rpcs.get_subproperty_sync_config if parent_rpcs.respond_to? :get_subproperty_sync_config
                    @get_subproperty_sync_config = ::Gapic::Config::Method.new get_subproperty_sync_config_config
                    get_reporting_identity_settings_config = parent_rpcs.get_reporting_identity_settings if parent_rpcs.respond_to? :get_reporting_identity_settings
                    @get_reporting_identity_settings = ::Gapic::Config::Method.new get_reporting_identity_settings_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
