# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/marketingplatform/admin/v1alpha/marketingplatform_admin_pb"
require "google/ads/marketing_platform/admin/v1alpha/marketingplatform_admin_service"

class ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_organization
    # Create GRPC objects.
    grpc_response = ::Google::Ads::MarketingPlatform::Admin::V1alpha::Organization.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_organization_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_organization, name
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_organization_client_stub do
      # Create client
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_organization({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_organization name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_organization ::Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_organization({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_organization(::Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_organization_client_stub.call_rpc_count
    end
  end

  def test_list_organizations
    # Create GRPC objects.
    grpc_response = ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"

    list_organizations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_organizations, name
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest, request
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_organizations_client_stub do
      # Create client
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_organizations({ page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_organizations page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_organizations ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest.new(page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_organizations({ page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_organizations(::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest.new(page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_organizations_client_stub.call_rpc_count
    end
  end

  def test_find_sales_partner_managed_clients
    # Create GRPC objects.
    grpc_response = ::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    organization = "hello world"
    is_active = true

    find_sales_partner_managed_clients_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :find_sales_partner_managed_clients, name
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest, request
      assert_equal "hello world", request["organization"]
      assert_equal true, request["is_active"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, find_sales_partner_managed_clients_client_stub do
      # Create client
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.find_sales_partner_managed_clients({ organization: organization, is_active: is_active }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.find_sales_partner_managed_clients organization: organization, is_active: is_active do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.find_sales_partner_managed_clients ::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest.new(organization: organization, is_active: is_active) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.find_sales_partner_managed_clients({ organization: organization, is_active: is_active }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.find_sales_partner_managed_clients(::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest.new(organization: organization, is_active: is_active), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, find_sales_partner_managed_clients_client_stub.call_rpc_count
    end
  end

  def test_list_analytics_account_links
    # Create GRPC objects.
    grpc_response = ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_analytics_account_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_analytics_account_links, name
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_analytics_account_links_client_stub do
      # Create client
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_analytics_account_links({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_analytics_account_links parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_analytics_account_links ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_analytics_account_links({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_analytics_account_links(::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_analytics_account_links_client_stub.call_rpc_count
    end
  end

  def test_create_analytics_account_link
    # Create GRPC objects.
    grpc_response = ::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    analytics_account_link = {}

    create_analytics_account_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_analytics_account_link, name
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink), request["analytics_account_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_analytics_account_link_client_stub do
      # Create client
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_analytics_account_link({ parent: parent, analytics_account_link: analytics_account_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_analytics_account_link parent: parent, analytics_account_link: analytics_account_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_analytics_account_link ::Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest.new(parent: parent, analytics_account_link: analytics_account_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_analytics_account_link({ parent: parent, analytics_account_link: analytics_account_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_analytics_account_link(::Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest.new(parent: parent, analytics_account_link: analytics_account_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_analytics_account_link_client_stub.call_rpc_count
    end
  end

  def test_delete_analytics_account_link
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_analytics_account_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_analytics_account_link, name
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_analytics_account_link_client_stub do
      # Create client
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_analytics_account_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_analytics_account_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_analytics_account_link ::Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_analytics_account_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_analytics_account_link(::Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_analytics_account_link_client_stub.call_rpc_count
    end
  end

  def test_set_property_service_level
    # Create GRPC objects.
    grpc_response = ::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    analytics_account_link = "hello world"
    analytics_property = "hello world"
    service_level = :ANALYTICS_SERVICE_LEVEL_UNSPECIFIED

    set_property_service_level_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_property_service_level, name
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest, request
      assert_equal "hello world", request["analytics_account_link"]
      assert_equal "hello world", request["analytics_property"]
      assert_equal :ANALYTICS_SERVICE_LEVEL_UNSPECIFIED, request["service_level"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_property_service_level_client_stub do
      # Create client
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_property_service_level({ analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_property_service_level analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_property_service_level ::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest.new(analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_property_service_level({ analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_property_service_level(::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest.new(analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_property_service_level_client_stub.call_rpc_count
    end
  end

  def test_report_property_usage
    # Create GRPC objects.
    grpc_response = ::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    organization = "hello world"
    month = "hello world"

    report_property_usage_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :report_property_usage, name
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest, request
      assert_equal "hello world", request["organization"]
      assert_equal "hello world", request["month"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, report_property_usage_client_stub do
      # Create client
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.report_property_usage({ organization: organization, month: month }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.report_property_usage organization: organization, month: month do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.report_property_usage ::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest.new(organization: organization, month: month) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.report_property_usage({ organization: organization, month: month }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.report_property_usage(::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest.new(organization: organization, month: month), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, report_property_usage_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
