# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/marketingplatform/admin/v1alpha/marketingplatform_admin_pb"
require "google/ads/marketing_platform/admin/v1alpha/marketingplatform_admin_service/rest"


class ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_organization
    # Create test objects.
    client_result = ::Google::Ads::MarketingPlatform::Admin::V1alpha::Organization.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_organization_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ServiceStub.stub :transcode_get_organization_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_organization_client_stub do
        # Create client
        client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_organization({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_organization name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_organization ::Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_organization({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_organization(::Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_organization_client_stub.call_count
      end
    end
  end

  def test_list_organizations
    # Create test objects.
    client_result = ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"

    list_organizations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ServiceStub.stub :transcode_list_organizations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_organizations_client_stub do
        # Create client
        client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_organizations({ page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_organizations page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_organizations ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest.new(page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_organizations({ page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_organizations(::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest.new(page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_organizations_client_stub.call_count
      end
    end
  end

  def test_find_sales_partner_managed_clients
    # Create test objects.
    client_result = ::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    organization = "hello world"
    is_active = true

    find_sales_partner_managed_clients_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ServiceStub.stub :transcode_find_sales_partner_managed_clients_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, find_sales_partner_managed_clients_client_stub do
        # Create client
        client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.find_sales_partner_managed_clients({ organization: organization, is_active: is_active }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.find_sales_partner_managed_clients organization: organization, is_active: is_active do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.find_sales_partner_managed_clients ::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest.new(organization: organization, is_active: is_active) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.find_sales_partner_managed_clients({ organization: organization, is_active: is_active }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.find_sales_partner_managed_clients(::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest.new(organization: organization, is_active: is_active), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, find_sales_partner_managed_clients_client_stub.call_count
      end
    end
  end

  def test_list_analytics_account_links
    # Create test objects.
    client_result = ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_analytics_account_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ServiceStub.stub :transcode_list_analytics_account_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_analytics_account_links_client_stub do
        # Create client
        client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_analytics_account_links({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_analytics_account_links parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_analytics_account_links ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_analytics_account_links({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_analytics_account_links(::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_analytics_account_links_client_stub.call_count
      end
    end
  end

  def test_create_analytics_account_link
    # Create test objects.
    client_result = ::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    analytics_account_link = {}

    create_analytics_account_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ServiceStub.stub :transcode_create_analytics_account_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_analytics_account_link_client_stub do
        # Create client
        client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_analytics_account_link({ parent: parent, analytics_account_link: analytics_account_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_analytics_account_link parent: parent, analytics_account_link: analytics_account_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_analytics_account_link ::Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest.new(parent: parent, analytics_account_link: analytics_account_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_analytics_account_link({ parent: parent, analytics_account_link: analytics_account_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_analytics_account_link(::Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest.new(parent: parent, analytics_account_link: analytics_account_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_analytics_account_link_client_stub.call_count
      end
    end
  end

  def test_delete_analytics_account_link
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_analytics_account_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ServiceStub.stub :transcode_delete_analytics_account_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_analytics_account_link_client_stub do
        # Create client
        client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_analytics_account_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_analytics_account_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_analytics_account_link ::Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_analytics_account_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_analytics_account_link(::Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_analytics_account_link_client_stub.call_count
      end
    end
  end

  def test_set_property_service_level
    # Create test objects.
    client_result = ::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    analytics_account_link = "hello world"
    analytics_property = "hello world"
    service_level = :ANALYTICS_SERVICE_LEVEL_UNSPECIFIED

    set_property_service_level_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ServiceStub.stub :transcode_set_property_service_level_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_property_service_level_client_stub do
        # Create client
        client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_property_service_level({ analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_property_service_level analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_property_service_level ::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest.new(analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_property_service_level({ analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_property_service_level(::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest.new(analytics_account_link: analytics_account_link, analytics_property: analytics_property, service_level: service_level), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_property_service_level_client_stub.call_count
      end
    end
  end

  def test_report_property_usage
    # Create test objects.
    client_result = ::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    organization = "hello world"
    month = "hello world"

    report_property_usage_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::ServiceStub.stub :transcode_report_property_usage_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, report_property_usage_client_stub do
        # Create client
        client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.report_property_usage({ organization: organization, month: month }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.report_property_usage organization: organization, month: month do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.report_property_usage ::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest.new(organization: organization, month: month) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.report_property_usage({ organization: organization, month: month }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.report_property_usage(::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest.new(organization: organization, month: month), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, report_property_usage_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Rest::Client::Configuration, config
  end
end
