# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module MarketingPlatform
      module Admin
        module V1alpha
          # A resource message representing a Google Marketing Platform organization.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the GMP organization.
          #     Format: organizations/\\{org_id}
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The human-readable name for the organization.
          class Organization
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A resource message representing the link between a Google Analytics account
          # and a Google Marketing Platform organization.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. Resource name of this AnalyticsAccountLink. Note the resource
          #     ID is the same as the ID of the Analtyics account.
          #
          #     Format:
          #     organizations/\\{org_id}/analyticsAccountLinks/\\{analytics_account_link_id}
          #     Example: "organizations/xyz/analyticsAccountLinks/1234"
          # @!attribute [rw] analytics_account
          #   @return [::String]
          #     Required. Immutable. The resource name of the AnalyticsAdmin API account.
          #     The account ID will be used as the ID of this AnalyticsAccountLink
          #     resource, which will become the final component of the resource name.
          #
          #     Format: analyticsadmin.googleapis.com/accounts/\\{account_id}
          # @!attribute [r] display_name
          #   @return [::String]
          #     Output only. The human-readable name for the Analytics account.
          # @!attribute [r] link_verification_state
          #   @return [::Google::Ads::MarketingPlatform::Admin::V1alpha::LinkVerificationState]
          #     Output only. The verification state of the link between the Analytics
          #     account and the parent organization.
          class AnalyticsAccountLink
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The verification state of the link between a product account and a GMP
          # organization.
          module LinkVerificationState
            # The link state is unknown.
            LINK_VERIFICATION_STATE_UNSPECIFIED = 0

            # The link is established.
            LINK_VERIFICATION_STATE_VERIFIED = 1

            # The link is requested, but hasn't been approved by the product account
            # admin.
            LINK_VERIFICATION_STATE_NOT_VERIFIED = 2
          end

          # Various levels of service for Google Analytics.
          module AnalyticsServiceLevel
            # Service level unspecified.
            ANALYTICS_SERVICE_LEVEL_UNSPECIFIED = 0

            # The standard version of Google Analytics.
            ANALYTICS_SERVICE_LEVEL_STANDARD = 1

            # The premium version of Google Analytics.
            ANALYTICS_SERVICE_LEVEL_360 = 2
          end

          # Types of the Google Analytics Property.
          module AnalyticsPropertyType
            # Unknown or unspecified property type
            ANALYTICS_PROPERTY_TYPE_UNSPECIFIED = 0

            # Ordinary Google Analytics property
            ANALYTICS_PROPERTY_TYPE_ORDINARY = 1

            # Google Analytics subproperty
            ANALYTICS_PROPERTY_TYPE_SUBPROPERTY = 2

            # Google Analytics rollup property
            ANALYTICS_PROPERTY_TYPE_ROLLUP = 3
          end
        end
      end
    end
  end
end
