# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module MarketingPlatform
      module Admin
        module V1alpha
          module MarketingplatformAdminService
            # Path helper methods for the MarketingplatformAdminService API.
            module Paths
              ##
              # Create a fully-qualified Account resource string.
              #
              # The resource will be in the following format:
              #
              # `accounts/{account}`
              #
              # @param account [String]
              #
              # @return [::String]
              def account_path account:
                "accounts/#{account}"
              end

              ##
              # Create a fully-qualified AnalyticsAccountLink resource string.
              #
              # The resource will be in the following format:
              #
              # `organizations/{organization}/analyticsAccountLinks/{analytics_account_link}`
              #
              # @param organization [String]
              # @param analytics_account_link [String]
              #
              # @return [::String]
              def analytics_account_link_path organization:, analytics_account_link:
                raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                "organizations/#{organization}/analyticsAccountLinks/#{analytics_account_link}"
              end

              ##
              # Create a fully-qualified Organization resource string.
              #
              # The resource will be in the following format:
              #
              # `organizations/{organization}`
              #
              # @param organization [String]
              #
              # @return [::String]
              def organization_path organization:
                "organizations/#{organization}"
              end

              ##
              # Create a fully-qualified Property resource string.
              #
              # The resource will be in the following format:
              #
              # `properties/{property}`
              #
              # @param property [String]
              #
              # @return [::String]
              def property_path property:
                "properties/#{property}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
