# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/marketingplatform/admin/v1alpha/marketingplatform_admin_pb"

module Google
  module Ads
    module MarketingPlatform
      module Admin
        module V1alpha
          module MarketingplatformAdminService
            ##
            # Client for the MarketingplatformAdminService service.
            #
            # Service Interface for the Google Marketing Platform Admin API.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "marketingplatformadmin.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :marketingplatform_admin_service_stub

              ##
              # Configure the MarketingplatformAdminService Client class.
              #
              # See {::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all MarketingplatformAdminService clients
              #   ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Ads", "MarketingPlatform", "Admin", "V1alpha"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the MarketingplatformAdminService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @marketingplatform_admin_service_stub.universe_domain
              end

              ##
              # Create a new MarketingplatformAdminService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the MarketingplatformAdminService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/marketingplatform/admin/v1alpha/marketingplatform_admin_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @marketingplatform_admin_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @marketingplatform_admin_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @marketingplatform_admin_service_stub.logger
              end

              # Service calls

              ##
              # Lookup for a single organization.
              #
              # @overload get_organization(request, options = nil)
              #   Pass arguments to `get_organization` via a request object, either of type
              #   {::Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_organization(name: nil)
              #   Pass arguments to `get_organization` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Organization to retrieve.
              #     Format: organizations/\\{org_id}
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Ads::MarketingPlatform::Admin::V1alpha::Organization]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Ads::MarketingPlatform::Admin::V1alpha::Organization]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/ads/marketing_platform/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest.new
              #
              #   # Call the get_organization method.
              #   result = client.get_organization request
              #
              #   # The returned object is of type Google::Ads::MarketingPlatform::Admin::V1alpha::Organization.
              #   p result
              #
              def get_organization request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::GetOrganizationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_organization.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::MarketingPlatform::Admin::V1alpha::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_organization.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_organization.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @marketingplatform_admin_service_stub.call_rpc :get_organization, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of organizations that the user has access to.
              #
              # @overload list_organizations(request, options = nil)
              #   Pass arguments to `list_organizations` via a request object, either of type
              #   {::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_organizations(page_size: nil, page_token: nil)
              #   Pass arguments to `list_organizations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param page_size [::Integer]
              #     Optional. The maximum number of organizations to return in one call. The
              #     service may return fewer than this value.
              #
              #     If unspecified, at most 50 organizations will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous ListOrganizations call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListOrganizations` must match the call that provided the page
              #     token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Ads::MarketingPlatform::Admin::V1alpha::Organization>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Ads::MarketingPlatform::Admin::V1alpha::Organization>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/ads/marketing_platform/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest.new
              #
              #   # Call the list_organizations method.
              #   result = client.list_organizations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Ads::MarketingPlatform::Admin::V1alpha::Organization.
              #     p item
              #   end
              #
              def list_organizations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListOrganizationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_organizations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::MarketingPlatform::Admin::V1alpha::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_organizations.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_organizations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @marketingplatform_admin_service_stub.call_rpc :list_organizations, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @marketingplatform_admin_service_stub, :list_organizations, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of clients managed by the sales partner organization.
              #
              # User needs to be an OrgAdmin/BillingAdmin on the sales partner organization
              # in order to view the end clients.
              #
              # @overload find_sales_partner_managed_clients(request, options = nil)
              #   Pass arguments to `find_sales_partner_managed_clients` via a request object, either of type
              #   {::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload find_sales_partner_managed_clients(organization: nil, is_active: nil)
              #   Pass arguments to `find_sales_partner_managed_clients` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param organization [::String]
              #     Required. The name of the sales partner organization.
              #     Format: organizations/\\{org_id}
              #   @param is_active [::Boolean]
              #     Optional. If set, only active and just ended clients will be returned.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/ads/marketing_platform/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest.new
              #
              #   # Call the find_sales_partner_managed_clients method.
              #   result = client.find_sales_partner_managed_clients request
              #
              #   # The returned object is of type Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsResponse.
              #   p result
              #
              def find_sales_partner_managed_clients request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::FindSalesPartnerManagedClientsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.find_sales_partner_managed_clients.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::MarketingPlatform::Admin::V1alpha::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.organization
                  header_params["organization"] = request.organization
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.find_sales_partner_managed_clients.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.find_sales_partner_managed_clients.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @marketingplatform_admin_service_stub.call_rpc :find_sales_partner_managed_clients, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the Google Analytics accounts link to the specified Google Marketing
              # Platform organization.
              #
              # @overload list_analytics_account_links(request, options = nil)
              #   Pass arguments to `list_analytics_account_links` via a request object, either of type
              #   {::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_analytics_account_links(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_analytics_account_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent organization, which owns this collection of Analytics
              #     account links. Format: organizations/\\{org_id}
              #   @param page_size [::Integer]
              #     Optional. The maximum number of Analytics account links to return in one
              #     call. The service may return fewer than this value.
              #
              #     If unspecified, at most 50 Analytics account links will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous ListAnalyticsAccountLinks
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListAnalyticsAccountLinks` must match the call that provided the page
              #     token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/ads/marketing_platform/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest.new
              #
              #   # Call the list_analytics_account_links method.
              #   result = client.list_analytics_account_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink.
              #     p item
              #   end
              #
              def list_analytics_account_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::ListAnalyticsAccountLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_analytics_account_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::MarketingPlatform::Admin::V1alpha::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_analytics_account_links.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_analytics_account_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @marketingplatform_admin_service_stub.call_rpc :list_analytics_account_links, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @marketingplatform_admin_service_stub, :list_analytics_account_links, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates the link between the Analytics account and the Google Marketing
              # Platform organization.
              #
              # User needs to be an org user, and admin on the Analytics account to create
              # the link. If the account is already linked to an organization, user needs
              # to unlink the account from the current organization, then try link again.
              #
              # @overload create_analytics_account_link(request, options = nil)
              #   Pass arguments to `create_analytics_account_link` via a request object, either of type
              #   {::Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_analytics_account_link(parent: nil, analytics_account_link: nil)
              #   Pass arguments to `create_analytics_account_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this Analytics account link will be
              #     created. Format: organizations/\\{org_id}
              #   @param analytics_account_link [::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink, ::Hash]
              #     Required. The Analytics account link to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/ads/marketing_platform/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest.new
              #
              #   # Call the create_analytics_account_link method.
              #   result = client.create_analytics_account_link request
              #
              #   # The returned object is of type Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsAccountLink.
              #   p result
              #
              def create_analytics_account_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::CreateAnalyticsAccountLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_analytics_account_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::MarketingPlatform::Admin::V1alpha::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_analytics_account_link.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_analytics_account_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @marketingplatform_admin_service_stub.call_rpc :create_analytics_account_link, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the AnalyticsAccountLink, which detaches the Analytics account from
              # the Google Marketing Platform organization.
              #
              # User needs to be an org user, and admin on the Analytics account in order
              # to delete the link.
              #
              # @overload delete_analytics_account_link(request, options = nil)
              #   Pass arguments to `delete_analytics_account_link` via a request object, either of type
              #   {::Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_analytics_account_link(name: nil)
              #   Pass arguments to `delete_analytics_account_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Analytics account link to delete.
              #     Format:
              #     organizations/\\{org_id}/analyticsAccountLinks/\\{analytics_account_link_id}
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/ads/marketing_platform/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest.new
              #
              #   # Call the delete_analytics_account_link method.
              #   result = client.delete_analytics_account_link request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_analytics_account_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::DeleteAnalyticsAccountLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_analytics_account_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::MarketingPlatform::Admin::V1alpha::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_analytics_account_link.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_analytics_account_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @marketingplatform_admin_service_stub.call_rpc :delete_analytics_account_link, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the service level for an Analytics property.
              #
              # @overload set_property_service_level(request, options = nil)
              #   Pass arguments to `set_property_service_level` via a request object, either of type
              #   {::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload set_property_service_level(analytics_account_link: nil, analytics_property: nil, service_level: nil)
              #   Pass arguments to `set_property_service_level` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param analytics_account_link [::String]
              #     Required. The parent AnalyticsAccountLink scope where this property is in.
              #     Format:
              #     organizations/\\{org_id}/analyticsAccountLinks/\\{analytics_account_link_id}
              #   @param analytics_property [::String]
              #     Required. The Analytics property to change the ServiceLevel setting. This
              #     field is the name of the Google Analytics Admin API property resource.
              #
              #     Format: analyticsadmin.googleapis.com/properties/\\{property_id}
              #   @param service_level [::Google::Ads::MarketingPlatform::Admin::V1alpha::AnalyticsServiceLevel]
              #     Required. The service level to set for this property.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/ads/marketing_platform/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest.new
              #
              #   # Call the set_property_service_level method.
              #   result = client.set_property_service_level request
              #
              #   # The returned object is of type Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelResponse.
              #   p result
              #
              def set_property_service_level request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::SetPropertyServiceLevelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.set_property_service_level.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::MarketingPlatform::Admin::V1alpha::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.analytics_account_link
                  header_params["analytics_account_link"] = request.analytics_account_link
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.set_property_service_level.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.set_property_service_level.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @marketingplatform_admin_service_stub.call_rpc :set_property_service_level, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the usage and billing data for properties within the organization for
              # the specified month.
              #
              # Per direct client org, user needs to be OrgAdmin/BillingAdmin on the
              # organization in order to view the billing and usage data.
              #
              # Per sales partner client org, user needs to be OrgAdmin/BillingAdmin on
              # the sales partner org in order to view the billing and usage data, or
              # OrgAdmin/BillingAdmin on the sales partner client org in order to view the
              # usage data only.
              #
              # @overload report_property_usage(request, options = nil)
              #   Pass arguments to `report_property_usage` via a request object, either of type
              #   {::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload report_property_usage(organization: nil, month: nil)
              #   Pass arguments to `report_property_usage` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param organization [::String]
              #     Required. Specifies the organization whose property usage will be listed.
              #
              #     Format: organizations/\\{org_id}
              #   @param month [::String]
              #     Required. The target month to list property usages.
              #
              #     Format: YYYY-MM. For example, "2025-05"
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/ads/marketing_platform/admin/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest.new
              #
              #   # Call the report_property_usage method.
              #   result = client.report_property_usage request
              #
              #   # The returned object is of type Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageResponse.
              #   p result
              #
              def report_property_usage request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::MarketingPlatform::Admin::V1alpha::ReportPropertyUsageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.report_property_usage.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::MarketingPlatform::Admin::V1alpha::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.organization
                  header_params["organization"] = request.organization
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.report_property_usage.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.report_property_usage.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @marketingplatform_admin_service_stub.call_rpc :report_property_usage, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the MarketingplatformAdminService API.
              #
              # This class represents the configuration for MarketingplatformAdminService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_organization to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_organization.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_organization.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Ads::MarketingPlatform::Admin::V1alpha::MarketingplatformAdminService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "marketingplatformadmin.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the MarketingplatformAdminService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_organization`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_organization
                  ##
                  # RPC-specific configuration for `list_organizations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_organizations
                  ##
                  # RPC-specific configuration for `find_sales_partner_managed_clients`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :find_sales_partner_managed_clients
                  ##
                  # RPC-specific configuration for `list_analytics_account_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_analytics_account_links
                  ##
                  # RPC-specific configuration for `create_analytics_account_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_analytics_account_link
                  ##
                  # RPC-specific configuration for `delete_analytics_account_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_analytics_account_link
                  ##
                  # RPC-specific configuration for `set_property_service_level`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_property_service_level
                  ##
                  # RPC-specific configuration for `report_property_usage`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :report_property_usage

                  # @private
                  def initialize parent_rpcs = nil
                    get_organization_config = parent_rpcs.get_organization if parent_rpcs.respond_to? :get_organization
                    @get_organization = ::Gapic::Config::Method.new get_organization_config
                    list_organizations_config = parent_rpcs.list_organizations if parent_rpcs.respond_to? :list_organizations
                    @list_organizations = ::Gapic::Config::Method.new list_organizations_config
                    find_sales_partner_managed_clients_config = parent_rpcs.find_sales_partner_managed_clients if parent_rpcs.respond_to? :find_sales_partner_managed_clients
                    @find_sales_partner_managed_clients = ::Gapic::Config::Method.new find_sales_partner_managed_clients_config
                    list_analytics_account_links_config = parent_rpcs.list_analytics_account_links if parent_rpcs.respond_to? :list_analytics_account_links
                    @list_analytics_account_links = ::Gapic::Config::Method.new list_analytics_account_links_config
                    create_analytics_account_link_config = parent_rpcs.create_analytics_account_link if parent_rpcs.respond_to? :create_analytics_account_link
                    @create_analytics_account_link = ::Gapic::Config::Method.new create_analytics_account_link_config
                    delete_analytics_account_link_config = parent_rpcs.delete_analytics_account_link if parent_rpcs.respond_to? :delete_analytics_account_link
                    @delete_analytics_account_link = ::Gapic::Config::Method.new delete_analytics_account_link_config
                    set_property_service_level_config = parent_rpcs.set_property_service_level if parent_rpcs.respond_to? :set_property_service_level
                    @set_property_service_level = ::Gapic::Config::Method.new set_property_service_level_config
                    report_property_usage_config = parent_rpcs.report_property_usage if parent_rpcs.respond_to? :report_property_usage
                    @report_property_usage = ::Gapic::Config::Method.new report_property_usage_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
