# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/ads/datamanager/v1/ingestion_service_pb"
require "google/ads/data_manager/v1/ingestion_service"

class ::Google::Ads::DataManager::V1::IngestionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_ingest_audience_members
    # Create GRPC objects.
    grpc_response = ::Google::Ads::DataManager::V1::IngestAudienceMembersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    destinations = [{}]
    audience_members = [{}]
    consent = {}
    validate_only = true
    encoding = :ENCODING_UNSPECIFIED
    encryption_info = {}
    terms_of_service = {}

    ingest_audience_members_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :ingest_audience_members, name
      assert_kind_of ::Google::Ads::DataManager::V1::IngestAudienceMembersRequest, request
      assert_kind_of ::Google::Ads::DataManager::V1::Destination, request["destinations"].first
      assert_kind_of ::Google::Ads::DataManager::V1::AudienceMember, request["audience_members"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Ads::DataManager::V1::Consent), request["consent"]
      assert_equal true, request["validate_only"]
      assert_equal :ENCODING_UNSPECIFIED, request["encoding"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Ads::DataManager::V1::EncryptionInfo), request["encryption_info"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Ads::DataManager::V1::TermsOfService), request["terms_of_service"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, ingest_audience_members_client_stub do
      # Create client
      client = ::Google::Ads::DataManager::V1::IngestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.ingest_audience_members({ destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.ingest_audience_members destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.ingest_audience_members ::Google::Ads::DataManager::V1::IngestAudienceMembersRequest.new(destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.ingest_audience_members({ destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.ingest_audience_members(::Google::Ads::DataManager::V1::IngestAudienceMembersRequest.new(destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, ingest_audience_members_client_stub.call_rpc_count
    end
  end

  def test_remove_audience_members
    # Create GRPC objects.
    grpc_response = ::Google::Ads::DataManager::V1::RemoveAudienceMembersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    destinations = [{}]
    audience_members = [{}]
    validate_only = true
    encoding = :ENCODING_UNSPECIFIED
    encryption_info = {}

    remove_audience_members_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_audience_members, name
      assert_kind_of ::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest, request
      assert_kind_of ::Google::Ads::DataManager::V1::Destination, request["destinations"].first
      assert_kind_of ::Google::Ads::DataManager::V1::AudienceMember, request["audience_members"].first
      assert_equal true, request["validate_only"]
      assert_equal :ENCODING_UNSPECIFIED, request["encoding"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Ads::DataManager::V1::EncryptionInfo), request["encryption_info"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_audience_members_client_stub do
      # Create client
      client = ::Google::Ads::DataManager::V1::IngestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_audience_members({ destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_audience_members destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_audience_members ::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest.new(destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_audience_members({ destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_audience_members(::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest.new(destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_audience_members_client_stub.call_rpc_count
    end
  end

  def test_ingest_events
    # Create GRPC objects.
    grpc_response = ::Google::Ads::DataManager::V1::IngestEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    destinations = [{}]
    events = [{}]
    consent = {}
    validate_only = true
    encoding = :ENCODING_UNSPECIFIED
    encryption_info = {}

    ingest_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :ingest_events, name
      assert_kind_of ::Google::Ads::DataManager::V1::IngestEventsRequest, request
      assert_kind_of ::Google::Ads::DataManager::V1::Destination, request["destinations"].first
      assert_kind_of ::Google::Ads::DataManager::V1::Event, request["events"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Ads::DataManager::V1::Consent), request["consent"]
      assert_equal true, request["validate_only"]
      assert_equal :ENCODING_UNSPECIFIED, request["encoding"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Ads::DataManager::V1::EncryptionInfo), request["encryption_info"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, ingest_events_client_stub do
      # Create client
      client = ::Google::Ads::DataManager::V1::IngestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.ingest_events({ destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.ingest_events destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.ingest_events ::Google::Ads::DataManager::V1::IngestEventsRequest.new(destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.ingest_events({ destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.ingest_events(::Google::Ads::DataManager::V1::IngestEventsRequest.new(destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, ingest_events_client_stub.call_rpc_count
    end
  end

  def test_retrieve_request_status
    # Create GRPC objects.
    grpc_response = ::Google::Ads::DataManager::V1::RetrieveRequestStatusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    request_id = "hello world"

    retrieve_request_status_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retrieve_request_status, name
      assert_kind_of ::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest, request
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retrieve_request_status_client_stub do
      # Create client
      client = ::Google::Ads::DataManager::V1::IngestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retrieve_request_status({ request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retrieve_request_status request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retrieve_request_status ::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest.new(request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retrieve_request_status({ request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retrieve_request_status(::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest.new(request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retrieve_request_status_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Ads::DataManager::V1::IngestionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Ads::DataManager::V1::IngestionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Ads::DataManager::V1::IngestionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Ads::DataManager::V1::IngestionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
